// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__20446 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__20446) : cljs.core.atom.call(null,G__20446));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__20449){
var vec__20450 = p__20449;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20450,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20450,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__20452 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__20452)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__20452)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__20452)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__20452)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__20452)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__20452)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__20453){
var map__20457 = p__20453;
var map__20457__$1 = ((((!((map__20457 == null)))?((((map__20457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20457):map__20457);
var request = map__20457__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20457__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20457__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20457__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6210__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__20459 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__20459,default_headers);

cljs_http.core.apply_response_type_BANG_(G__20459,response_type);

G__20459.setTimeoutInterval(timeout);

G__20459.setWithCredentials(send_credentials);

return G__20459;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__20460){
var map__20488 = p__20460;
var map__20488__$1 = ((((!((map__20488 == null)))?((((map__20488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20488):map__20488);
var request = map__20488__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20488__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20488__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20488__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20488__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20488__$1,cljs.core.cst$kw$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6210__auto__ = request_method;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__20490 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__20490) : cljs_http.core.error_kw.call(null,G__20490));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__17645__auto___20515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_20501){
var state_val_20502 = (state_20501[(1)]);
if((state_val_20502 === (1))){
var state_20501__$1 = state_20501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20501__$1,(2),cancel);
} else {
if((state_val_20502 === (2))){
var inst_20492 = (state_20501[(2)]);
var inst_20493 = xhr__$1.isComplete();
var inst_20494 = cljs.core.not(inst_20493);
var state_20501__$1 = (function (){var statearr_20503 = state_20501;
(statearr_20503[(7)] = inst_20492);

return statearr_20503;
})();
if(inst_20494){
var statearr_20504_20516 = state_20501__$1;
(statearr_20504_20516[(1)] = (3));

} else {
var statearr_20505_20517 = state_20501__$1;
(statearr_20505_20517[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20502 === (3))){
var inst_20496 = xhr__$1.abort();
var state_20501__$1 = state_20501;
var statearr_20506_20518 = state_20501__$1;
(statearr_20506_20518[(2)] = inst_20496);

(statearr_20506_20518[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20502 === (4))){
var state_20501__$1 = state_20501;
var statearr_20507_20519 = state_20501__$1;
(statearr_20507_20519[(2)] = null);

(statearr_20507_20519[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20502 === (5))){
var inst_20499 = (state_20501[(2)]);
var state_20501__$1 = state_20501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20501__$1,inst_20499);
} else {
return null;
}
}
}
}
}
});})(c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__17531__auto__,c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__17532__auto__ = null;
var cljs_http$core$xhr_$_state_machine__17532__auto____0 = (function (){
var statearr_20511 = [null,null,null,null,null,null,null,null];
(statearr_20511[(0)] = cljs_http$core$xhr_$_state_machine__17532__auto__);

(statearr_20511[(1)] = (1));

return statearr_20511;
});
var cljs_http$core$xhr_$_state_machine__17532__auto____1 = (function (state_20501){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20501);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20512){if((e20512 instanceof Object)){
var ex__17535__auto__ = e20512;
var statearr_20513_20520 = state_20501;
(statearr_20513_20520[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20501);

return cljs.core.cst$kw$recur;
} else {
throw e20512;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20521 = state_20501;
state_20501 = G__20521;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__17532__auto__ = function(state_20501){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__17532__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__17532__auto____1.call(this,state_20501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__17532__auto____0;
cljs_http$core$xhr_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__17532__auto____1;
return cljs_http$core$xhr_$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__17647__auto__ = (function (){var statearr_20514 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20514[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___20515);

return statearr_20514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___20515,channel,request_url,method,headers__$1,xhr__$1,map__20488,map__20488__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__20522){
var map__20539 = p__20522;
var map__20539__$1 = ((((!((map__20539 == null)))?((((map__20539.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20539.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20539):map__20539);
var request = map__20539__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20539__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20539__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20539__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20539__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_20555 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp__$1,cljs.core.cst$kw$request,req_20555], null));

if(cljs.core.truth_(cancel)){
var c__17645__auto___20556 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_20545){
var state_val_20546 = (state_20545[(1)]);
if((state_val_20546 === (1))){
var state_20545__$1 = state_20545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20545__$1,(2),cancel);
} else {
if((state_val_20546 === (2))){
var inst_20542 = (state_20545[(2)]);
var inst_20543 = jsonp__$1.cancel(req_20555);
var state_20545__$1 = (function (){var statearr_20547 = state_20545;
(statearr_20547[(7)] = inst_20542);

return statearr_20547;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20545__$1,inst_20543);
} else {
return null;
}
}
});})(c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__17531__auto__,c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__17532__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__17532__auto____0 = (function (){
var statearr_20551 = [null,null,null,null,null,null,null,null];
(statearr_20551[(0)] = cljs_http$core$jsonp_$_state_machine__17532__auto__);

(statearr_20551[(1)] = (1));

return statearr_20551;
});
var cljs_http$core$jsonp_$_state_machine__17532__auto____1 = (function (state_20545){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20545);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20552){if((e20552 instanceof Object)){
var ex__17535__auto__ = e20552;
var statearr_20553_20557 = state_20545;
(statearr_20553_20557[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20545);

return cljs.core.cst$kw$recur;
} else {
throw e20552;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20558 = state_20545;
state_20545 = G__20558;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__17532__auto__ = function(state_20545){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__17532__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__17532__auto____1.call(this,state_20545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__17532__auto____0;
cljs_http$core$jsonp_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__17532__auto____1;
return cljs_http$core$jsonp_$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__17647__auto__ = (function (){var statearr_20554 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20554[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___20556);

return statearr_20554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___20556,req_20555,channel,jsonp__$1,map__20539,map__20539__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__20559){
var map__20562 = p__20559;
var map__20562__$1 = ((((!((map__20562 == null)))?((((map__20562.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20562.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20562):map__20562);
var request__$1 = map__20562__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20562__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
