// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$temp_DASH_token,null,cljs.core.cst$kw$token,null,cljs.core.cst$kw$username,null,cljs.core.cst$kw$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__20857 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$client,"zebra.ona.io",cljs.core.cst$kw$data,"stage.ona.io",cljs.core.cst$kw$j2x,"j2x.ona.io",cljs.core.cst$kw$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__20857) : cljs.core.atom.call(null,G__20857));
})();
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20863 = arguments.length;
var i__7281__auto___20864 = (0);
while(true){
if((i__7281__auto___20864 < len__7280__auto___20863)){
args__7287__auto__.push((arguments[i__7281__auto___20864]));

var G__20865 = (i__7281__auto___20864 + (1));
i__7281__auto___20864 = G__20865;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__20860){
var vec__20861 = p__20860;
var client_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20861,(0),null);
var j2x_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20861,(1),null);
var request_protocol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20861,(2),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(milia.utils.remote.hosts,cljs.core.merge,(function (){var G__20862 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data_host], null);
var G__20862__$1 = ((cljs.core.some_QMARK_(client_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20862,cljs.core.cst$kw$client,client_host):G__20862);
var G__20862__$2 = ((cljs.core.some_QMARK_(j2x_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20862__$1,cljs.core.cst$kw$j2x,j2x_host):G__20862__$1);
if(cljs.core.some_QMARK_(request_protocol)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__20862__$2,cljs.core.cst$kw$request_DASH_protocol,request_protocol);
} else {
return G__20862__$2;
}
})());
});

milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq20858){
var G__20859 = cljs.core.first(seq20858);
var seq20858__$1 = cljs.core.next(seq20858);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic(G__20859,seq20858__$1);
});
/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20870 = arguments.length;
var i__7281__auto___20871 = (0);
while(true){
if((i__7281__auto___20871 < len__7280__auto___20870)){
args__7287__auto__.push((arguments[i__7281__auto___20871]));

var G__20872 = (i__7281__auto___20871 + (1));
i__7281__auto___20871 = G__20872;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__20868){
var vec__20869 = p__20868;
var password = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20869,(0),null);
var temp_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20869,(1),null);
var token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20869,(2),null);
return milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$password,password,cljs.core.cst$kw$temp_DASH_token,temp_token,cljs.core.cst$kw$token,token], null);
});

milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq20866){
var G__20867 = cljs.core.first(seq20866);
var seq20866__$1 = cljs.core.next(seq20866);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic(G__20867,seq20866__$1);
});
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20874 = arguments.length;
var i__7281__auto___20875 = (0);
while(true){
if((i__7281__auto___20875 < len__7280__auto___20874)){
args__7287__auto__.push((arguments[i__7281__auto___20875]));

var G__20876 = (i__7281__auto___20875 + (1));
i__7281__auto___20875 = G__20876;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq20873){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20873));
});
/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20878 = arguments.length;
var i__7281__auto___20879 = (0);
while(true){
if((i__7281__auto___20879 < len__7280__auto___20878)){
args__7287__auto__.push((arguments[i__7281__auto___20879]));

var G__20880 = (i__7281__auto___20879 + (1));
i__7281__auto___20879 = G__20880;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq20877){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20877));
});
/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20882 = arguments.length;
var i__7281__auto___20883 = (0);
while(true){
if((i__7281__auto___20883 < len__7280__auto___20882)){
args__7287__auto__.push((arguments[i__7281__auto___20883]));

var G__20884 = (i__7281__auto___20883 + (1));
i__7281__auto___20883 = G__20884;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq20881){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20881));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20886 = arguments.length;
var i__7281__auto___20887 = (0);
while(true){
if((i__7281__auto___20887 < len__7280__auto___20886)){
args__7287__auto__.push((arguments[i__7281__auto___20887]));

var G__20888 = (i__7281__auto___20887 + (1));
i__7281__auto___20887 = G__20888;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq20885){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20885));
});
