// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.polling_interval = (5000);
/**
 * Handles API server's response and acts according to given
 *   callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__21427,p__21428){
var map__21437 = p__21427;
var map__21437__$1 = ((((!((map__21437 == null)))?((((map__21437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21437):map__21437);
var response = map__21437__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21437__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21437__$1,cljs.core.cst$kw$body);
var map__21438 = p__21428;
var map__21438__$1 = ((((!((map__21438 == null)))?((((map__21438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21438):map__21438);
var callbacks = map__21438__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__21438__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__21438__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__21438__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__21438__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__21441 = body;
var map__21441__$1 = ((((!((map__21441 == null)))?((((map__21441.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21441.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21441):map__21441);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21441__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21441__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21441__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__21441,map__21441__$1,export_url,job_status,job_id,map__21437,map__21437__$1,response,status,body,map__21438,map__21438__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__21441,map__21441__$1,export_url,job_status,job_id,map__21437,map__21437__$1,response,status,body,map__21438,map__21438__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6210__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
var or__6210__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6210__auto____$1)){
return or__6210__auto____$1;
} else {
var or__6210__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6210__auto____$2)){
return or__6210__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if(cljs.core.truth_((function (){var or__6210__auto__ = (status >= (400));
if(or__6210__auto__){
return or__6210__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__21443_21445 = error_detail;
var G__21444_21446 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__21443_21445,G__21444_21446) : on_error.call(null,G__21443_21445,G__21444_21446));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21504 = arguments.length;
var i__7281__auto___21505 = (0);
while(true){
if((i__7281__auto___21505 < len__7280__auto___21504)){
args__7287__auto__.push((arguments[i__7281__auto___21505]));

var G__21506 = (i__7281__auto___21505 + (1));
i__7281__auto___21505 = G__21506;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__21450){
var map__21451 = p__21450;
var map__21451__$1 = ((((!((map__21451 == null)))?((((map__21451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21451):map__21451);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21451__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21451__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21451__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (state_21481){
var state_val_21482 = (state_21481[(1)]);
if((state_val_21482 === (7))){
var state_21481__$1 = state_21481;
var statearr_21483_21507 = state_21481__$1;
(statearr_21483_21507[(2)] = "dataviews");

(statearr_21483_21507[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (1))){
var state_21481__$1 = state_21481;
var statearr_21484_21508 = state_21481__$1;
(statearr_21484_21508[(2)] = null);

(statearr_21484_21508[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (4))){
var inst_21457 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_21481__$1 = (function (){var statearr_21485 = state_21481;
(statearr_21485[(7)] = inst_21457);

return statearr_21485;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_21486_21509 = state_21481__$1;
(statearr_21486_21509[(1)] = (7));

} else {
var statearr_21487_21510 = state_21481__$1;
(statearr_21487_21510[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (6))){
var inst_21477 = (state_21481[(2)]);
var state_21481__$1 = state_21481;
var statearr_21488_21511 = state_21481__$1;
(statearr_21488_21511[(2)] = inst_21477);

(statearr_21488_21511[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (3))){
var inst_21479 = (state_21481[(2)]);
var state_21481__$1 = state_21481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21481__$1,inst_21479);
} else {
if((state_val_21482 === (2))){
var inst_21454 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_21455 = cljs.core.not(inst_21454);
var state_21481__$1 = state_21481;
if(inst_21455){
var statearr_21489_21512 = state_21481__$1;
(statearr_21489_21512[(1)] = (4));

} else {
var statearr_21490_21513 = state_21481__$1;
(statearr_21490_21513[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (11))){
var inst_21473 = (state_21481[(2)]);
var state_21481__$1 = (function (){var statearr_21491 = state_21481;
(statearr_21491[(8)] = inst_21473);

return statearr_21491;
})();
var statearr_21492_21514 = state_21481__$1;
(statearr_21492_21514[(2)] = null);

(statearr_21492_21514[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (9))){
var inst_21457 = (state_21481[(7)]);
var inst_21462 = (state_21481[(9)]);
var inst_21461 = (state_21481[(2)]);
var inst_21462__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_21461,dataset_id,inst_21457], 0));
var inst_21463 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_21462__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_21481__$1 = (function (){var statearr_21493 = state_21481;
(statearr_21493[(9)] = inst_21462__$1);

return statearr_21493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21481__$1,(10),inst_21463);
} else {
if((state_val_21482 === (5))){
var state_21481__$1 = state_21481;
var statearr_21494_21515 = state_21481__$1;
(statearr_21494_21515[(2)] = null);

(statearr_21494_21515[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21482 === (10))){
var inst_21457 = (state_21481[(7)]);
var inst_21462 = (state_21481[(9)]);
var inst_21465 = (state_21481[(2)]);
var inst_21466 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_21467 = (function (){var job_suffix = inst_21457;
var job_url = inst_21462;
var response = inst_21465;
return ((function (job_suffix,job_url,response,inst_21457,inst_21462,inst_21465,inst_21466,state_val_21482,c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_21457,inst_21462,inst_21465,inst_21466,state_val_21482,c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var inst_21468 = [inst_21467,on_error,on_export_url];
var inst_21469 = cljs.core.PersistentHashMap.fromArrays(inst_21466,inst_21468);
var inst_21470 = milia.api.async_export.handle_response(inst_21465,inst_21469);
var inst_21471 = cljs.core.async.timeout(milia.api.async_export.polling_interval);
var state_21481__$1 = (function (){var statearr_21495 = state_21481;
(statearr_21495[(10)] = inst_21470);

return statearr_21495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21481__$1,(11),inst_21471);
} else {
if((state_val_21482 === (8))){
var state_21481__$1 = state_21481;
var statearr_21496_21516 = state_21481__$1;
(statearr_21496_21516[(2)] = "forms");

(statearr_21496_21516[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
;
return ((function (switch__17531__auto__,c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function() {
var milia$api$async_export$state_machine__17532__auto__ = null;
var milia$api$async_export$state_machine__17532__auto____0 = (function (){
var statearr_21500 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21500[(0)] = milia$api$async_export$state_machine__17532__auto__);

(statearr_21500[(1)] = (1));

return statearr_21500;
});
var milia$api$async_export$state_machine__17532__auto____1 = (function (state_21481){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_21481);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e21501){if((e21501 instanceof Object)){
var ex__17535__auto__ = e21501;
var statearr_21502_21517 = state_21481;
(statearr_21502_21517[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21481);

return cljs.core.cst$kw$recur;
} else {
throw e21501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__21518 = state_21481;
state_21481 = G__21518;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17532__auto__ = function(state_21481){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17532__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17532__auto____1.call(this,state_21481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17532__auto____0;
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17532__auto____1;
return milia$api$async_export$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var state__17647__auto__ = (function (){var statearr_21503 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_21503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_21503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__,done_polling_QMARK_,map__21451,map__21451__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
);

return c__17645__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq21447){
var G__21448 = cljs.core.first(seq21447);
var seq21447__$1 = cljs.core.next(seq21447);
var G__21449 = cljs.core.first(seq21447__$1);
var seq21447__$2 = cljs.core.next(seq21447__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21448,G__21449,seq21447__$2);
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query='{\"%s\":\"%s\"}'",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6210__auto__ = value;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21524 = arguments.length;
var i__7281__auto___21525 = (0);
while(true){
if((i__7281__auto___21525 < len__7280__auto___21524)){
args__7287__auto__.push((arguments[i__7281__auto___21525]));

var G__21526 = (i__7281__auto___21525 + (1));
i__7281__auto___21525 = G__21526;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__21522){
var vec__21523 = p__21522;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21523,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq21519){
var G__21520 = cljs.core.first(seq21519);
var seq21519__$1 = cljs.core.next(seq21519);
var G__21521 = cljs.core.first(seq21519__$1);
var seq21519__$2 = cljs.core.next(seq21519__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__21520,G__21521,seq21519__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21563 = arguments.length;
var i__7281__auto___21564 = (0);
while(true){
if((i__7281__auto___21564 < len__7280__auto___21563)){
args__7287__auto__.push((arguments[i__7281__auto___21564]));

var G__21565 = (i__7281__auto___21564 + (1));
i__7281__auto___21564 = G__21565;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__21529){
var vec__21530 = p__21529;
var map__21531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21530,(0),null);
var map__21531__$1 = ((((!((map__21531 == null)))?((((map__21531.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21531.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21531):map__21531);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21531__$1,cljs.core.cst$kw$on_DASH_error);
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_21548){
var state_val_21549 = (state_21548[(1)]);
if((state_val_21549 === (1))){
var inst_21533 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_21548__$1 = (function (){var statearr_21550 = state_21548;
(statearr_21550[(7)] = inst_21533);

return statearr_21550;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_21551_21566 = state_21548__$1;
(statearr_21551_21566[(1)] = (2));

} else {
var statearr_21552_21567 = state_21548__$1;
(statearr_21552_21567[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21549 === (2))){
var state_21548__$1 = state_21548;
var statearr_21553_21568 = state_21548__$1;
(statearr_21553_21568[(2)] = "dataviews");

(statearr_21553_21568[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21549 === (3))){
var state_21548__$1 = state_21548;
var statearr_21554_21569 = state_21548__$1;
(statearr_21554_21569[(2)] = "forms");

(statearr_21554_21569[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21549 === (4))){
var inst_21537 = (state_21548[(8)]);
var inst_21538 = (state_21548[(9)]);
var inst_21533 = (state_21548[(7)]);
var inst_21537__$1 = (state_21548[(2)]);
var inst_21538__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_21537__$1,dataset_id,inst_21533], 0));
var inst_21539 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_21538__$1);
var state_21548__$1 = (function (){var statearr_21555 = state_21548;
(statearr_21555[(8)] = inst_21537__$1);

(statearr_21555[(9)] = inst_21538__$1);

return statearr_21555;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21548__$1,(5),inst_21539);
} else {
if((state_val_21549 === (5))){
var inst_21537 = (state_21548[(8)]);
var inst_21538 = (state_21548[(9)]);
var inst_21533 = (state_21548[(7)]);
var inst_21541 = (state_21548[(2)]);
var inst_21542 = (function (){var export_suffix = inst_21533;
var export_endpoint = inst_21537;
var export_url = inst_21538;
var response = inst_21541;
return ((function (export_suffix,export_endpoint,export_url,response,inst_21537,inst_21538,inst_21533,inst_21541,state_val_21549,c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_21537,inst_21538,inst_21533,inst_21541,state_val_21549,c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_21543 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_21544 = [on_error,inst_21542,on_export_url];
var inst_21545 = cljs.core.PersistentHashMap.fromArrays(inst_21543,inst_21544);
var inst_21546 = milia.api.async_export.handle_response(inst_21541,inst_21545);
var state_21548__$1 = state_21548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21548__$1,inst_21546);
} else {
return null;
}
}
}
}
}
});})(c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__17531__auto__,c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__17532__auto__ = null;
var milia$api$async_export$state_machine__17532__auto____0 = (function (){
var statearr_21559 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21559[(0)] = milia$api$async_export$state_machine__17532__auto__);

(statearr_21559[(1)] = (1));

return statearr_21559;
});
var milia$api$async_export$state_machine__17532__auto____1 = (function (state_21548){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_21548);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e21560){if((e21560 instanceof Object)){
var ex__17535__auto__ = e21560;
var statearr_21561_21570 = state_21548;
(statearr_21561_21570[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21548);

return cljs.core.cst$kw$recur;
} else {
throw e21560;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__21571 = state_21548;
state_21548 = G__21571;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17532__auto__ = function(state_21548){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17532__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17532__auto____1.call(this,state_21548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17532__auto____0;
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17532__auto____1;
return milia$api$async_export$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__17647__auto__ = (function (){var statearr_21562 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_21562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_21562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__,vec__21530,map__21531,map__21531__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__17645__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq21527){
var G__21528 = cljs.core.first(seq21527);
var seq21527__$1 = cljs.core.next(seq21527);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21528,seq21527__$1);
});
/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__21572_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__21572_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 * downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21597 = arguments.length;
var i__7281__auto___21598 = (0);
while(true){
if((i__7281__auto___21598 < len__7280__auto___21597)){
args__7287__auto__.push((arguments[i__7281__auto___21598]));

var G__21599 = (i__7281__auto___21598 + (1));
i__7281__auto___21598 = G__21599;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__){
return (function (state_21588){
var state_val_21589 = (state_21588[(1)]);
if((state_val_21589 === (1))){
var inst_21577 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_21588__$1 = state_21588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21588__$1,(2),inst_21577);
} else {
if((state_val_21589 === (2))){
var inst_21579 = (state_21588[(2)]);
var inst_21580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21581 = [http_method,inst_21579];
var inst_21582 = (new cljs.core.PersistentVector(null,2,(5),inst_21580,inst_21581,null));
var inst_21583 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_21582,args);
var inst_21584 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_21583);
var state_21588__$1 = state_21588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21588__$1,(3),inst_21584);
} else {
if((state_val_21589 === (3))){
var inst_21586 = (state_21588[(2)]);
var state_21588__$1 = state_21588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21588__$1,inst_21586);
} else {
return null;
}
}
}
});})(c__17645__auto__))
;
return ((function (switch__17531__auto__,c__17645__auto__){
return (function() {
var milia$api$async_export$state_machine__17532__auto__ = null;
var milia$api$async_export$state_machine__17532__auto____0 = (function (){
var statearr_21593 = [null,null,null,null,null,null,null];
(statearr_21593[(0)] = milia$api$async_export$state_machine__17532__auto__);

(statearr_21593[(1)] = (1));

return statearr_21593;
});
var milia$api$async_export$state_machine__17532__auto____1 = (function (state_21588){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_21588);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e21594){if((e21594 instanceof Object)){
var ex__17535__auto__ = e21594;
var statearr_21595_21600 = state_21588;
(statearr_21595_21600[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21588);

return cljs.core.cst$kw$recur;
} else {
throw e21594;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__21601 = state_21588;
state_21588 = G__21601;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
milia$api$async_export$state_machine__17532__auto__ = function(state_21588){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__17532__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__17532__auto____1.call(this,state_21588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__17532__auto____0;
milia$api$async_export$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__17532__auto____1;
return milia$api$async_export$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__))
})();
var state__17647__auto__ = (function (){var statearr_21596 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_21596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_21596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__))
);

return c__17645__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq21573){
var G__21574 = cljs.core.first(seq21573);
var seq21573__$1 = cljs.core.next(seq21573);
var G__21575 = cljs.core.first(seq21573__$1);
var seq21573__$2 = cljs.core.next(seq21573__$1);
var G__21576 = cljs.core.first(seq21573__$2);
var seq21573__$3 = cljs.core.next(seq21573__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__21574,G__21575,G__21576,seq21573__$3);
});
