// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17690 = [];
var len__7280__auto___17696 = arguments.length;
var i__7281__auto___17697 = (0);
while(true){
if((i__7281__auto___17697 < len__7280__auto___17696)){
args17690.push((arguments[i__7281__auto___17697]));

var G__17698 = (i__7281__auto___17697 + (1));
i__7281__auto___17697 = G__17698;
continue;
} else {
}
break;
}

var G__17692 = args17690.length;
switch (G__17692) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17690.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17693 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17693 = (function (f,blockable,meta17694){
this.f = f;
this.blockable = blockable;
this.meta17694 = meta17694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17695,meta17694__$1){
var self__ = this;
var _17695__$1 = this;
return (new cljs.core.async.t_cljs$core$async17693(self__.f,self__.blockable,meta17694__$1));
});

cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17695){
var self__ = this;
var _17695__$1 = this;
return self__.meta17694;
});

cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17693.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17693.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17694], null);
});

cljs.core.async.t_cljs$core$async17693.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17693";

cljs.core.async.t_cljs$core$async17693.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async17693");
});

cljs.core.async.__GT_t_cljs$core$async17693 = (function cljs$core$async$__GT_t_cljs$core$async17693(f__$1,blockable__$1,meta17694){
return (new cljs.core.async.t_cljs$core$async17693(f__$1,blockable__$1,meta17694));
});

}

return (new cljs.core.async.t_cljs$core$async17693(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17702 = [];
var len__7280__auto___17705 = arguments.length;
var i__7281__auto___17706 = (0);
while(true){
if((i__7281__auto___17706 < len__7280__auto___17705)){
args17702.push((arguments[i__7281__auto___17706]));

var G__17707 = (i__7281__auto___17706 + (1));
i__7281__auto___17706 = G__17707;
continue;
} else {
}
break;
}

var G__17704 = args17702.length;
switch (G__17704) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17702.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17709 = [];
var len__7280__auto___17712 = arguments.length;
var i__7281__auto___17713 = (0);
while(true){
if((i__7281__auto___17713 < len__7280__auto___17712)){
args17709.push((arguments[i__7281__auto___17713]));

var G__17714 = (i__7281__auto___17713 + (1));
i__7281__auto___17713 = G__17714;
continue;
} else {
}
break;
}

var G__17711 = args17709.length;
switch (G__17711) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17709.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17716 = [];
var len__7280__auto___17719 = arguments.length;
var i__7281__auto___17720 = (0);
while(true){
if((i__7281__auto___17720 < len__7280__auto___17719)){
args17716.push((arguments[i__7281__auto___17720]));

var G__17721 = (i__7281__auto___17720 + (1));
i__7281__auto___17720 = G__17721;
continue;
} else {
}
break;
}

var G__17718 = args17716.length;
switch (G__17718) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17716.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17723 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17723) : fn1.call(null,val_17723));
} else {
cljs.core.async.impl.dispatch.run(((function (val_17723,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17723) : fn1.call(null,val_17723));
});})(val_17723,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17724 = [];
var len__7280__auto___17727 = arguments.length;
var i__7281__auto___17728 = (0);
while(true){
if((i__7281__auto___17728 < len__7280__auto___17727)){
args17724.push((arguments[i__7281__auto___17728]));

var G__17729 = (i__7281__auto___17728 + (1));
i__7281__auto___17728 = G__17729;
continue;
} else {
}
break;
}

var G__17726 = args17724.length;
switch (G__17726) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17724.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7125__auto___17731 = n;
var x_17732 = (0);
while(true){
if((x_17732 < n__7125__auto___17731)){
(a[x_17732] = (0));

var G__17733 = (x_17732 + (1));
x_17732 = G__17733;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__17734 = (i + (1));
i = G__17734;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async17738 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17738 = (function (alt_flag,flag,meta17739){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17739 = meta17739;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17740,meta17739__$1){
var self__ = this;
var _17740__$1 = this;
return (new cljs.core.async.t_cljs$core$async17738(self__.alt_flag,self__.flag,meta17739__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17740){
var self__ = this;
var _17740__$1 = this;
return self__.meta17739;
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta17739], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17738.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17738.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17738";

cljs.core.async.t_cljs$core$async17738.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async17738");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17738 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17738(alt_flag__$1,flag__$1,meta17739){
return (new cljs.core.async.t_cljs$core$async17738(alt_flag__$1,flag__$1,meta17739));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17738(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17744 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17744 = (function (alt_handler,flag,cb,meta17745){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17745 = meta17745;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17746,meta17745__$1){
var self__ = this;
var _17746__$1 = this;
return (new cljs.core.async.t_cljs$core$async17744(self__.alt_handler,self__.flag,self__.cb,meta17745__$1));
});

cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17746){
var self__ = this;
var _17746__$1 = this;
return self__.meta17745;
});

cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17744.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17744.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta17745], null);
});

cljs.core.async.t_cljs$core$async17744.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17744.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17744";

cljs.core.async.t_cljs$core$async17744.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async17744");
});

cljs.core.async.__GT_t_cljs$core$async17744 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17744(alt_handler__$1,flag__$1,cb__$1,meta17745){
return (new cljs.core.async.t_cljs$core$async17744(alt_handler__$1,flag__$1,cb__$1,meta17745));
});

}

return (new cljs.core.async.t_cljs$core$async17744(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17747_SHARP_){
var G__17751 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17747_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17751) : fret.call(null,G__17751));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17748_SHARP_){
var G__17752 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17748_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17752) : fret.call(null,G__17752));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6210__auto__ = wport;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17753 = (i + (1));
i = G__17753;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6210__auto__ = ret;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6198__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___17759 = arguments.length;
var i__7281__auto___17760 = (0);
while(true){
if((i__7281__auto___17760 < len__7280__auto___17759)){
args__7287__auto__.push((arguments[i__7281__auto___17760]));

var G__17761 = (i__7281__auto___17760 + (1));
i__7281__auto___17760 = G__17761;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17756){
var map__17757 = p__17756;
var map__17757__$1 = ((((!((map__17757 == null)))?((((map__17757.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17757.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17757):map__17757);
var opts = map__17757__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17754){
var G__17755 = cljs.core.first(seq17754);
var seq17754__$1 = cljs.core.next(seq17754);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17755,seq17754__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17762 = [];
var len__7280__auto___17812 = arguments.length;
var i__7281__auto___17813 = (0);
while(true){
if((i__7281__auto___17813 < len__7280__auto___17812)){
args17762.push((arguments[i__7281__auto___17813]));

var G__17814 = (i__7281__auto___17813 + (1));
i__7281__auto___17813 = G__17814;
continue;
} else {
}
break;
}

var G__17764 = args17762.length;
switch (G__17764) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17762.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17645__auto___17816 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___17816){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___17816){
return (function (state_17788){
var state_val_17789 = (state_17788[(1)]);
if((state_val_17789 === (7))){
var inst_17784 = (state_17788[(2)]);
var state_17788__$1 = state_17788;
var statearr_17790_17817 = state_17788__$1;
(statearr_17790_17817[(2)] = inst_17784);

(statearr_17790_17817[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (1))){
var state_17788__$1 = state_17788;
var statearr_17791_17818 = state_17788__$1;
(statearr_17791_17818[(2)] = null);

(statearr_17791_17818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (4))){
var inst_17767 = (state_17788[(7)]);
var inst_17767__$1 = (state_17788[(2)]);
var inst_17768 = (inst_17767__$1 == null);
var state_17788__$1 = (function (){var statearr_17792 = state_17788;
(statearr_17792[(7)] = inst_17767__$1);

return statearr_17792;
})();
if(cljs.core.truth_(inst_17768)){
var statearr_17793_17819 = state_17788__$1;
(statearr_17793_17819[(1)] = (5));

} else {
var statearr_17794_17820 = state_17788__$1;
(statearr_17794_17820[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (13))){
var state_17788__$1 = state_17788;
var statearr_17795_17821 = state_17788__$1;
(statearr_17795_17821[(2)] = null);

(statearr_17795_17821[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (6))){
var inst_17767 = (state_17788[(7)]);
var state_17788__$1 = state_17788;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17788__$1,(11),to,inst_17767);
} else {
if((state_val_17789 === (3))){
var inst_17786 = (state_17788[(2)]);
var state_17788__$1 = state_17788;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17788__$1,inst_17786);
} else {
if((state_val_17789 === (12))){
var state_17788__$1 = state_17788;
var statearr_17796_17822 = state_17788__$1;
(statearr_17796_17822[(2)] = null);

(statearr_17796_17822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (2))){
var state_17788__$1 = state_17788;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17788__$1,(4),from);
} else {
if((state_val_17789 === (11))){
var inst_17777 = (state_17788[(2)]);
var state_17788__$1 = state_17788;
if(cljs.core.truth_(inst_17777)){
var statearr_17797_17823 = state_17788__$1;
(statearr_17797_17823[(1)] = (12));

} else {
var statearr_17798_17824 = state_17788__$1;
(statearr_17798_17824[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (9))){
var state_17788__$1 = state_17788;
var statearr_17799_17825 = state_17788__$1;
(statearr_17799_17825[(2)] = null);

(statearr_17799_17825[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (5))){
var state_17788__$1 = state_17788;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17800_17826 = state_17788__$1;
(statearr_17800_17826[(1)] = (8));

} else {
var statearr_17801_17827 = state_17788__$1;
(statearr_17801_17827[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (14))){
var inst_17782 = (state_17788[(2)]);
var state_17788__$1 = state_17788;
var statearr_17802_17828 = state_17788__$1;
(statearr_17802_17828[(2)] = inst_17782);

(statearr_17802_17828[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (10))){
var inst_17774 = (state_17788[(2)]);
var state_17788__$1 = state_17788;
var statearr_17803_17829 = state_17788__$1;
(statearr_17803_17829[(2)] = inst_17774);

(statearr_17803_17829[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17789 === (8))){
var inst_17771 = cljs.core.async.close_BANG_(to);
var state_17788__$1 = state_17788;
var statearr_17804_17830 = state_17788__$1;
(statearr_17804_17830[(2)] = inst_17771);

(statearr_17804_17830[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___17816))
;
return ((function (switch__17531__auto__,c__17645__auto___17816){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_17808 = [null,null,null,null,null,null,null,null];
(statearr_17808[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_17808[(1)] = (1));

return statearr_17808;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_17788){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_17788);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e17809){if((e17809 instanceof Object)){
var ex__17535__auto__ = e17809;
var statearr_17810_17831 = state_17788;
(statearr_17810_17831[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17788);

return cljs.core.cst$kw$recur;
} else {
throw e17809;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__17832 = state_17788;
state_17788 = G__17832;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_17788){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_17788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___17816))
})();
var state__17647__auto__ = (function (){var statearr_17811 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_17811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___17816);

return statearr_17811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___17816))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__18016){
var vec__18017 = p__18016;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18017,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18017,(1),null);
var job = vec__18017;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17645__auto___18199 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results){
return (function (state_18022){
var state_val_18023 = (state_18022[(1)]);
if((state_val_18023 === (1))){
var state_18022__$1 = state_18022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18022__$1,(2),res,v);
} else {
if((state_val_18023 === (2))){
var inst_18019 = (state_18022[(2)]);
var inst_18020 = cljs.core.async.close_BANG_(res);
var state_18022__$1 = (function (){var statearr_18024 = state_18022;
(statearr_18024[(7)] = inst_18019);

return statearr_18024;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18022__$1,inst_18020);
} else {
return null;
}
}
});})(c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results))
;
return ((function (switch__17531__auto__,c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_18028 = [null,null,null,null,null,null,null,null];
(statearr_18028[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__);

(statearr_18028[(1)] = (1));

return statearr_18028;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1 = (function (state_18022){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18022);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18029){if((e18029 instanceof Object)){
var ex__17535__auto__ = e18029;
var statearr_18030_18200 = state_18022;
(statearr_18030_18200[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18022);

return cljs.core.cst$kw$recur;
} else {
throw e18029;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18201 = state_18022;
state_18022 = G__18201;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = function(state_18022){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1.call(this,state_18022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results))
})();
var state__17647__auto__ = (function (){var statearr_18031 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18199);

return statearr_18031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___18199,res,vec__18017,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18032){
var vec__18033 = p__18032;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18033,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18033,(1),null);
var job = vec__18033;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7125__auto___18202 = n;
var __18203 = (0);
while(true){
if((__18203 < n__7125__auto___18202)){
var G__18034_18204 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__18034_18204) {
case "compute":
var c__17645__auto___18206 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18203,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (__18203,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function (state_18047){
var state_val_18048 = (state_18047[(1)]);
if((state_val_18048 === (1))){
var state_18047__$1 = state_18047;
var statearr_18049_18207 = state_18047__$1;
(statearr_18049_18207[(2)] = null);

(statearr_18049_18207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18048 === (2))){
var state_18047__$1 = state_18047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18047__$1,(4),jobs);
} else {
if((state_val_18048 === (3))){
var inst_18045 = (state_18047[(2)]);
var state_18047__$1 = state_18047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18047__$1,inst_18045);
} else {
if((state_val_18048 === (4))){
var inst_18037 = (state_18047[(2)]);
var inst_18038 = process(inst_18037);
var state_18047__$1 = state_18047;
if(cljs.core.truth_(inst_18038)){
var statearr_18050_18208 = state_18047__$1;
(statearr_18050_18208[(1)] = (5));

} else {
var statearr_18051_18209 = state_18047__$1;
(statearr_18051_18209[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18048 === (5))){
var state_18047__$1 = state_18047;
var statearr_18052_18210 = state_18047__$1;
(statearr_18052_18210[(2)] = null);

(statearr_18052_18210[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18048 === (6))){
var state_18047__$1 = state_18047;
var statearr_18053_18211 = state_18047__$1;
(statearr_18053_18211[(2)] = null);

(statearr_18053_18211[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18048 === (7))){
var inst_18043 = (state_18047[(2)]);
var state_18047__$1 = state_18047;
var statearr_18054_18212 = state_18047__$1;
(statearr_18054_18212[(2)] = inst_18043);

(statearr_18054_18212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18203,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
;
return ((function (__18203,switch__17531__auto__,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_18058 = [null,null,null,null,null,null,null];
(statearr_18058[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__);

(statearr_18058[(1)] = (1));

return statearr_18058;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1 = (function (state_18047){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18047);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18059){if((e18059 instanceof Object)){
var ex__17535__auto__ = e18059;
var statearr_18060_18213 = state_18047;
(statearr_18060_18213[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18047);

return cljs.core.cst$kw$recur;
} else {
throw e18059;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18214 = state_18047;
state_18047 = G__18214;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = function(state_18047){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1.call(this,state_18047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__;
})()
;})(__18203,switch__17531__auto__,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
})();
var state__17647__auto__ = (function (){var statearr_18061 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18061[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18206);

return statearr_18061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(__18203,c__17645__auto___18206,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
);


break;
case "async":
var c__17645__auto___18215 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18203,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (__18203,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function (state_18074){
var state_val_18075 = (state_18074[(1)]);
if((state_val_18075 === (1))){
var state_18074__$1 = state_18074;
var statearr_18076_18216 = state_18074__$1;
(statearr_18076_18216[(2)] = null);

(statearr_18076_18216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18075 === (2))){
var state_18074__$1 = state_18074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18074__$1,(4),jobs);
} else {
if((state_val_18075 === (3))){
var inst_18072 = (state_18074[(2)]);
var state_18074__$1 = state_18074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18074__$1,inst_18072);
} else {
if((state_val_18075 === (4))){
var inst_18064 = (state_18074[(2)]);
var inst_18065 = async(inst_18064);
var state_18074__$1 = state_18074;
if(cljs.core.truth_(inst_18065)){
var statearr_18077_18217 = state_18074__$1;
(statearr_18077_18217[(1)] = (5));

} else {
var statearr_18078_18218 = state_18074__$1;
(statearr_18078_18218[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18075 === (5))){
var state_18074__$1 = state_18074;
var statearr_18079_18219 = state_18074__$1;
(statearr_18079_18219[(2)] = null);

(statearr_18079_18219[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18075 === (6))){
var state_18074__$1 = state_18074;
var statearr_18080_18220 = state_18074__$1;
(statearr_18080_18220[(2)] = null);

(statearr_18080_18220[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18075 === (7))){
var inst_18070 = (state_18074[(2)]);
var state_18074__$1 = state_18074;
var statearr_18081_18221 = state_18074__$1;
(statearr_18081_18221[(2)] = inst_18070);

(statearr_18081_18221[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18203,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
;
return ((function (__18203,switch__17531__auto__,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_18085 = [null,null,null,null,null,null,null];
(statearr_18085[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__);

(statearr_18085[(1)] = (1));

return statearr_18085;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1 = (function (state_18074){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18074);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18086){if((e18086 instanceof Object)){
var ex__17535__auto__ = e18086;
var statearr_18087_18222 = state_18074;
(statearr_18087_18222[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18074);

return cljs.core.cst$kw$recur;
} else {
throw e18086;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18223 = state_18074;
state_18074 = G__18223;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = function(state_18074){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1.call(this,state_18074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__;
})()
;})(__18203,switch__17531__auto__,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
})();
var state__17647__auto__ = (function (){var statearr_18088 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18088[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18215);

return statearr_18088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(__18203,c__17645__auto___18215,G__18034_18204,n__7125__auto___18202,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18224 = (__18203 + (1));
__18203 = G__18224;
continue;
} else {
}
break;
}

var c__17645__auto___18225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___18225,jobs,results,process,async){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___18225,jobs,results,process,async){
return (function (state_18110){
var state_val_18111 = (state_18110[(1)]);
if((state_val_18111 === (1))){
var state_18110__$1 = state_18110;
var statearr_18112_18226 = state_18110__$1;
(statearr_18112_18226[(2)] = null);

(statearr_18112_18226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18111 === (2))){
var state_18110__$1 = state_18110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18110__$1,(4),from);
} else {
if((state_val_18111 === (3))){
var inst_18108 = (state_18110[(2)]);
var state_18110__$1 = state_18110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18110__$1,inst_18108);
} else {
if((state_val_18111 === (4))){
var inst_18091 = (state_18110[(7)]);
var inst_18091__$1 = (state_18110[(2)]);
var inst_18092 = (inst_18091__$1 == null);
var state_18110__$1 = (function (){var statearr_18113 = state_18110;
(statearr_18113[(7)] = inst_18091__$1);

return statearr_18113;
})();
if(cljs.core.truth_(inst_18092)){
var statearr_18114_18227 = state_18110__$1;
(statearr_18114_18227[(1)] = (5));

} else {
var statearr_18115_18228 = state_18110__$1;
(statearr_18115_18228[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18111 === (5))){
var inst_18094 = cljs.core.async.close_BANG_(jobs);
var state_18110__$1 = state_18110;
var statearr_18116_18229 = state_18110__$1;
(statearr_18116_18229[(2)] = inst_18094);

(statearr_18116_18229[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18111 === (6))){
var inst_18091 = (state_18110[(7)]);
var inst_18096 = (state_18110[(8)]);
var inst_18096__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_18097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18098 = [inst_18091,inst_18096__$1];
var inst_18099 = (new cljs.core.PersistentVector(null,2,(5),inst_18097,inst_18098,null));
var state_18110__$1 = (function (){var statearr_18117 = state_18110;
(statearr_18117[(8)] = inst_18096__$1);

return statearr_18117;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18110__$1,(8),jobs,inst_18099);
} else {
if((state_val_18111 === (7))){
var inst_18106 = (state_18110[(2)]);
var state_18110__$1 = state_18110;
var statearr_18118_18230 = state_18110__$1;
(statearr_18118_18230[(2)] = inst_18106);

(statearr_18118_18230[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18111 === (8))){
var inst_18096 = (state_18110[(8)]);
var inst_18101 = (state_18110[(2)]);
var state_18110__$1 = (function (){var statearr_18119 = state_18110;
(statearr_18119[(9)] = inst_18101);

return statearr_18119;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18110__$1,(9),results,inst_18096);
} else {
if((state_val_18111 === (9))){
var inst_18103 = (state_18110[(2)]);
var state_18110__$1 = (function (){var statearr_18120 = state_18110;
(statearr_18120[(10)] = inst_18103);

return statearr_18120;
})();
var statearr_18121_18231 = state_18110__$1;
(statearr_18121_18231[(2)] = null);

(statearr_18121_18231[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___18225,jobs,results,process,async))
;
return ((function (switch__17531__auto__,c__17645__auto___18225,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_18125 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18125[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__);

(statearr_18125[(1)] = (1));

return statearr_18125;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1 = (function (state_18110){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18110);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18126){if((e18126 instanceof Object)){
var ex__17535__auto__ = e18126;
var statearr_18127_18232 = state_18110;
(statearr_18127_18232[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18110);

return cljs.core.cst$kw$recur;
} else {
throw e18126;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18233 = state_18110;
state_18110 = G__18233;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = function(state_18110){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1.call(this,state_18110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___18225,jobs,results,process,async))
})();
var state__17647__auto__ = (function (){var statearr_18128 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18225);

return statearr_18128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___18225,jobs,results,process,async))
);


var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__,jobs,results,process,async){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__,jobs,results,process,async){
return (function (state_18166){
var state_val_18167 = (state_18166[(1)]);
if((state_val_18167 === (7))){
var inst_18162 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
var statearr_18168_18234 = state_18166__$1;
(statearr_18168_18234[(2)] = inst_18162);

(statearr_18168_18234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (20))){
var state_18166__$1 = state_18166;
var statearr_18169_18235 = state_18166__$1;
(statearr_18169_18235[(2)] = null);

(statearr_18169_18235[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (1))){
var state_18166__$1 = state_18166;
var statearr_18170_18236 = state_18166__$1;
(statearr_18170_18236[(2)] = null);

(statearr_18170_18236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (4))){
var inst_18131 = (state_18166[(7)]);
var inst_18131__$1 = (state_18166[(2)]);
var inst_18132 = (inst_18131__$1 == null);
var state_18166__$1 = (function (){var statearr_18171 = state_18166;
(statearr_18171[(7)] = inst_18131__$1);

return statearr_18171;
})();
if(cljs.core.truth_(inst_18132)){
var statearr_18172_18237 = state_18166__$1;
(statearr_18172_18237[(1)] = (5));

} else {
var statearr_18173_18238 = state_18166__$1;
(statearr_18173_18238[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (15))){
var inst_18144 = (state_18166[(8)]);
var state_18166__$1 = state_18166;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18166__$1,(18),to,inst_18144);
} else {
if((state_val_18167 === (21))){
var inst_18157 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
var statearr_18174_18239 = state_18166__$1;
(statearr_18174_18239[(2)] = inst_18157);

(statearr_18174_18239[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (13))){
var inst_18159 = (state_18166[(2)]);
var state_18166__$1 = (function (){var statearr_18175 = state_18166;
(statearr_18175[(9)] = inst_18159);

return statearr_18175;
})();
var statearr_18176_18240 = state_18166__$1;
(statearr_18176_18240[(2)] = null);

(statearr_18176_18240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (6))){
var inst_18131 = (state_18166[(7)]);
var state_18166__$1 = state_18166;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18166__$1,(11),inst_18131);
} else {
if((state_val_18167 === (17))){
var inst_18152 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
if(cljs.core.truth_(inst_18152)){
var statearr_18177_18241 = state_18166__$1;
(statearr_18177_18241[(1)] = (19));

} else {
var statearr_18178_18242 = state_18166__$1;
(statearr_18178_18242[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (3))){
var inst_18164 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18166__$1,inst_18164);
} else {
if((state_val_18167 === (12))){
var inst_18141 = (state_18166[(10)]);
var state_18166__$1 = state_18166;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18166__$1,(14),inst_18141);
} else {
if((state_val_18167 === (2))){
var state_18166__$1 = state_18166;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18166__$1,(4),results);
} else {
if((state_val_18167 === (19))){
var state_18166__$1 = state_18166;
var statearr_18179_18243 = state_18166__$1;
(statearr_18179_18243[(2)] = null);

(statearr_18179_18243[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (11))){
var inst_18141 = (state_18166[(2)]);
var state_18166__$1 = (function (){var statearr_18180 = state_18166;
(statearr_18180[(10)] = inst_18141);

return statearr_18180;
})();
var statearr_18181_18244 = state_18166__$1;
(statearr_18181_18244[(2)] = null);

(statearr_18181_18244[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (9))){
var state_18166__$1 = state_18166;
var statearr_18182_18245 = state_18166__$1;
(statearr_18182_18245[(2)] = null);

(statearr_18182_18245[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (5))){
var state_18166__$1 = state_18166;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18183_18246 = state_18166__$1;
(statearr_18183_18246[(1)] = (8));

} else {
var statearr_18184_18247 = state_18166__$1;
(statearr_18184_18247[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (14))){
var inst_18144 = (state_18166[(8)]);
var inst_18146 = (state_18166[(11)]);
var inst_18144__$1 = (state_18166[(2)]);
var inst_18145 = (inst_18144__$1 == null);
var inst_18146__$1 = cljs.core.not(inst_18145);
var state_18166__$1 = (function (){var statearr_18185 = state_18166;
(statearr_18185[(8)] = inst_18144__$1);

(statearr_18185[(11)] = inst_18146__$1);

return statearr_18185;
})();
if(inst_18146__$1){
var statearr_18186_18248 = state_18166__$1;
(statearr_18186_18248[(1)] = (15));

} else {
var statearr_18187_18249 = state_18166__$1;
(statearr_18187_18249[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (16))){
var inst_18146 = (state_18166[(11)]);
var state_18166__$1 = state_18166;
var statearr_18188_18250 = state_18166__$1;
(statearr_18188_18250[(2)] = inst_18146);

(statearr_18188_18250[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (10))){
var inst_18138 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
var statearr_18189_18251 = state_18166__$1;
(statearr_18189_18251[(2)] = inst_18138);

(statearr_18189_18251[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (18))){
var inst_18149 = (state_18166[(2)]);
var state_18166__$1 = state_18166;
var statearr_18190_18252 = state_18166__$1;
(statearr_18190_18252[(2)] = inst_18149);

(statearr_18190_18252[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18167 === (8))){
var inst_18135 = cljs.core.async.close_BANG_(to);
var state_18166__$1 = state_18166;
var statearr_18191_18253 = state_18166__$1;
(statearr_18191_18253[(2)] = inst_18135);

(statearr_18191_18253[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto__,jobs,results,process,async))
;
return ((function (switch__17531__auto__,c__17645__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_18195 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18195[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__);

(statearr_18195[(1)] = (1));

return statearr_18195;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1 = (function (state_18166){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18166);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18196){if((e18196 instanceof Object)){
var ex__17535__auto__ = e18196;
var statearr_18197_18254 = state_18166;
(statearr_18197_18254[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18166);

return cljs.core.cst$kw$recur;
} else {
throw e18196;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18255 = state_18166;
state_18166 = G__18255;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__ = function(state_18166){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1.call(this,state_18166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__,jobs,results,process,async))
})();
var state__17647__auto__ = (function (){var statearr_18198 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18198[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_18198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__,jobs,results,process,async))
);

return c__17645__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18256 = [];
var len__7280__auto___18259 = arguments.length;
var i__7281__auto___18260 = (0);
while(true){
if((i__7281__auto___18260 < len__7280__auto___18259)){
args18256.push((arguments[i__7281__auto___18260]));

var G__18261 = (i__7281__auto___18260 + (1));
i__7281__auto___18260 = G__18261;
continue;
} else {
}
break;
}

var G__18258 = args18256.length;
switch (G__18258) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18256.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18263 = [];
var len__7280__auto___18266 = arguments.length;
var i__7281__auto___18267 = (0);
while(true){
if((i__7281__auto___18267 < len__7280__auto___18266)){
args18263.push((arguments[i__7281__auto___18267]));

var G__18268 = (i__7281__auto___18267 + (1));
i__7281__auto___18267 = G__18268;
continue;
} else {
}
break;
}

var G__18265 = args18263.length;
switch (G__18265) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18263.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18270 = [];
var len__7280__auto___18323 = arguments.length;
var i__7281__auto___18324 = (0);
while(true){
if((i__7281__auto___18324 < len__7280__auto___18323)){
args18270.push((arguments[i__7281__auto___18324]));

var G__18325 = (i__7281__auto___18324 + (1));
i__7281__auto___18324 = G__18325;
continue;
} else {
}
break;
}

var G__18272 = args18270.length;
switch (G__18272) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18270.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17645__auto___18327 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___18327,tc,fc){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___18327,tc,fc){
return (function (state_18298){
var state_val_18299 = (state_18298[(1)]);
if((state_val_18299 === (7))){
var inst_18294 = (state_18298[(2)]);
var state_18298__$1 = state_18298;
var statearr_18300_18328 = state_18298__$1;
(statearr_18300_18328[(2)] = inst_18294);

(statearr_18300_18328[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (1))){
var state_18298__$1 = state_18298;
var statearr_18301_18329 = state_18298__$1;
(statearr_18301_18329[(2)] = null);

(statearr_18301_18329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (4))){
var inst_18275 = (state_18298[(7)]);
var inst_18275__$1 = (state_18298[(2)]);
var inst_18276 = (inst_18275__$1 == null);
var state_18298__$1 = (function (){var statearr_18302 = state_18298;
(statearr_18302[(7)] = inst_18275__$1);

return statearr_18302;
})();
if(cljs.core.truth_(inst_18276)){
var statearr_18303_18330 = state_18298__$1;
(statearr_18303_18330[(1)] = (5));

} else {
var statearr_18304_18331 = state_18298__$1;
(statearr_18304_18331[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (13))){
var state_18298__$1 = state_18298;
var statearr_18305_18332 = state_18298__$1;
(statearr_18305_18332[(2)] = null);

(statearr_18305_18332[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (6))){
var inst_18275 = (state_18298[(7)]);
var inst_18281 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18275) : p.call(null,inst_18275));
var state_18298__$1 = state_18298;
if(cljs.core.truth_(inst_18281)){
var statearr_18306_18333 = state_18298__$1;
(statearr_18306_18333[(1)] = (9));

} else {
var statearr_18307_18334 = state_18298__$1;
(statearr_18307_18334[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (3))){
var inst_18296 = (state_18298[(2)]);
var state_18298__$1 = state_18298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18298__$1,inst_18296);
} else {
if((state_val_18299 === (12))){
var state_18298__$1 = state_18298;
var statearr_18308_18335 = state_18298__$1;
(statearr_18308_18335[(2)] = null);

(statearr_18308_18335[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (2))){
var state_18298__$1 = state_18298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18298__$1,(4),ch);
} else {
if((state_val_18299 === (11))){
var inst_18275 = (state_18298[(7)]);
var inst_18285 = (state_18298[(2)]);
var state_18298__$1 = state_18298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18298__$1,(8),inst_18285,inst_18275);
} else {
if((state_val_18299 === (9))){
var state_18298__$1 = state_18298;
var statearr_18309_18336 = state_18298__$1;
(statearr_18309_18336[(2)] = tc);

(statearr_18309_18336[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (5))){
var inst_18278 = cljs.core.async.close_BANG_(tc);
var inst_18279 = cljs.core.async.close_BANG_(fc);
var state_18298__$1 = (function (){var statearr_18310 = state_18298;
(statearr_18310[(8)] = inst_18278);

return statearr_18310;
})();
var statearr_18311_18337 = state_18298__$1;
(statearr_18311_18337[(2)] = inst_18279);

(statearr_18311_18337[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (14))){
var inst_18292 = (state_18298[(2)]);
var state_18298__$1 = state_18298;
var statearr_18312_18338 = state_18298__$1;
(statearr_18312_18338[(2)] = inst_18292);

(statearr_18312_18338[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (10))){
var state_18298__$1 = state_18298;
var statearr_18313_18339 = state_18298__$1;
(statearr_18313_18339[(2)] = fc);

(statearr_18313_18339[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18299 === (8))){
var inst_18287 = (state_18298[(2)]);
var state_18298__$1 = state_18298;
if(cljs.core.truth_(inst_18287)){
var statearr_18314_18340 = state_18298__$1;
(statearr_18314_18340[(1)] = (12));

} else {
var statearr_18315_18341 = state_18298__$1;
(statearr_18315_18341[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___18327,tc,fc))
;
return ((function (switch__17531__auto__,c__17645__auto___18327,tc,fc){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_18319 = [null,null,null,null,null,null,null,null,null];
(statearr_18319[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_18319[(1)] = (1));

return statearr_18319;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_18298){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18298);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18320){if((e18320 instanceof Object)){
var ex__17535__auto__ = e18320;
var statearr_18321_18342 = state_18298;
(statearr_18321_18342[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18298);

return cljs.core.cst$kw$recur;
} else {
throw e18320;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18343 = state_18298;
state_18298 = G__18343;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_18298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_18298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___18327,tc,fc))
})();
var state__17647__auto__ = (function (){var statearr_18322 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18322[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18327);

return statearr_18322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___18327,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__){
return (function (state_18407){
var state_val_18408 = (state_18407[(1)]);
if((state_val_18408 === (7))){
var inst_18403 = (state_18407[(2)]);
var state_18407__$1 = state_18407;
var statearr_18409_18430 = state_18407__$1;
(statearr_18409_18430[(2)] = inst_18403);

(statearr_18409_18430[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (1))){
var inst_18387 = init;
var state_18407__$1 = (function (){var statearr_18410 = state_18407;
(statearr_18410[(7)] = inst_18387);

return statearr_18410;
})();
var statearr_18411_18431 = state_18407__$1;
(statearr_18411_18431[(2)] = null);

(statearr_18411_18431[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (4))){
var inst_18390 = (state_18407[(8)]);
var inst_18390__$1 = (state_18407[(2)]);
var inst_18391 = (inst_18390__$1 == null);
var state_18407__$1 = (function (){var statearr_18412 = state_18407;
(statearr_18412[(8)] = inst_18390__$1);

return statearr_18412;
})();
if(cljs.core.truth_(inst_18391)){
var statearr_18413_18432 = state_18407__$1;
(statearr_18413_18432[(1)] = (5));

} else {
var statearr_18414_18433 = state_18407__$1;
(statearr_18414_18433[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (6))){
var inst_18387 = (state_18407[(7)]);
var inst_18390 = (state_18407[(8)]);
var inst_18394 = (state_18407[(9)]);
var inst_18394__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_18387,inst_18390) : f.call(null,inst_18387,inst_18390));
var inst_18395 = cljs.core.reduced_QMARK_(inst_18394__$1);
var state_18407__$1 = (function (){var statearr_18415 = state_18407;
(statearr_18415[(9)] = inst_18394__$1);

return statearr_18415;
})();
if(inst_18395){
var statearr_18416_18434 = state_18407__$1;
(statearr_18416_18434[(1)] = (8));

} else {
var statearr_18417_18435 = state_18407__$1;
(statearr_18417_18435[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (3))){
var inst_18405 = (state_18407[(2)]);
var state_18407__$1 = state_18407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18407__$1,inst_18405);
} else {
if((state_val_18408 === (2))){
var state_18407__$1 = state_18407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18407__$1,(4),ch);
} else {
if((state_val_18408 === (9))){
var inst_18394 = (state_18407[(9)]);
var inst_18387 = inst_18394;
var state_18407__$1 = (function (){var statearr_18418 = state_18407;
(statearr_18418[(7)] = inst_18387);

return statearr_18418;
})();
var statearr_18419_18436 = state_18407__$1;
(statearr_18419_18436[(2)] = null);

(statearr_18419_18436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (5))){
var inst_18387 = (state_18407[(7)]);
var state_18407__$1 = state_18407;
var statearr_18420_18437 = state_18407__$1;
(statearr_18420_18437[(2)] = inst_18387);

(statearr_18420_18437[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (10))){
var inst_18401 = (state_18407[(2)]);
var state_18407__$1 = state_18407;
var statearr_18421_18438 = state_18407__$1;
(statearr_18421_18438[(2)] = inst_18401);

(statearr_18421_18438[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18408 === (8))){
var inst_18394 = (state_18407[(9)]);
var inst_18397 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_18394) : cljs.core.deref.call(null,inst_18394));
var state_18407__$1 = state_18407;
var statearr_18422_18439 = state_18407__$1;
(statearr_18422_18439[(2)] = inst_18397);

(statearr_18422_18439[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto__))
;
return ((function (switch__17531__auto__,c__17645__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17532__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17532__auto____0 = (function (){
var statearr_18426 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18426[(0)] = cljs$core$async$reduce_$_state_machine__17532__auto__);

(statearr_18426[(1)] = (1));

return statearr_18426;
});
var cljs$core$async$reduce_$_state_machine__17532__auto____1 = (function (state_18407){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18407);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18427){if((e18427 instanceof Object)){
var ex__17535__auto__ = e18427;
var statearr_18428_18440 = state_18407;
(statearr_18428_18440[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18407);

return cljs.core.cst$kw$recur;
} else {
throw e18427;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18441 = state_18407;
state_18407 = G__18441;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17532__auto__ = function(state_18407){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17532__auto____1.call(this,state_18407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17532__auto____0;
cljs$core$async$reduce_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17532__auto____1;
return cljs$core$async$reduce_$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__))
})();
var state__17647__auto__ = (function (){var statearr_18429 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18429[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_18429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__))
);

return c__17645__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18442 = [];
var len__7280__auto___18494 = arguments.length;
var i__7281__auto___18495 = (0);
while(true){
if((i__7281__auto___18495 < len__7280__auto___18494)){
args18442.push((arguments[i__7281__auto___18495]));

var G__18496 = (i__7281__auto___18495 + (1));
i__7281__auto___18495 = G__18496;
continue;
} else {
}
break;
}

var G__18444 = args18442.length;
switch (G__18444) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18442.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__){
return (function (state_18469){
var state_val_18470 = (state_18469[(1)]);
if((state_val_18470 === (7))){
var inst_18451 = (state_18469[(2)]);
var state_18469__$1 = state_18469;
var statearr_18471_18498 = state_18469__$1;
(statearr_18471_18498[(2)] = inst_18451);

(statearr_18471_18498[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (1))){
var inst_18445 = cljs.core.seq(coll);
var inst_18446 = inst_18445;
var state_18469__$1 = (function (){var statearr_18472 = state_18469;
(statearr_18472[(7)] = inst_18446);

return statearr_18472;
})();
var statearr_18473_18499 = state_18469__$1;
(statearr_18473_18499[(2)] = null);

(statearr_18473_18499[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (4))){
var inst_18446 = (state_18469[(7)]);
var inst_18449 = cljs.core.first(inst_18446);
var state_18469__$1 = state_18469;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18469__$1,(7),ch,inst_18449);
} else {
if((state_val_18470 === (13))){
var inst_18463 = (state_18469[(2)]);
var state_18469__$1 = state_18469;
var statearr_18474_18500 = state_18469__$1;
(statearr_18474_18500[(2)] = inst_18463);

(statearr_18474_18500[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (6))){
var inst_18454 = (state_18469[(2)]);
var state_18469__$1 = state_18469;
if(cljs.core.truth_(inst_18454)){
var statearr_18475_18501 = state_18469__$1;
(statearr_18475_18501[(1)] = (8));

} else {
var statearr_18476_18502 = state_18469__$1;
(statearr_18476_18502[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (3))){
var inst_18467 = (state_18469[(2)]);
var state_18469__$1 = state_18469;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18469__$1,inst_18467);
} else {
if((state_val_18470 === (12))){
var state_18469__$1 = state_18469;
var statearr_18477_18503 = state_18469__$1;
(statearr_18477_18503[(2)] = null);

(statearr_18477_18503[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (2))){
var inst_18446 = (state_18469[(7)]);
var state_18469__$1 = state_18469;
if(cljs.core.truth_(inst_18446)){
var statearr_18478_18504 = state_18469__$1;
(statearr_18478_18504[(1)] = (4));

} else {
var statearr_18479_18505 = state_18469__$1;
(statearr_18479_18505[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (11))){
var inst_18460 = cljs.core.async.close_BANG_(ch);
var state_18469__$1 = state_18469;
var statearr_18480_18506 = state_18469__$1;
(statearr_18480_18506[(2)] = inst_18460);

(statearr_18480_18506[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (9))){
var state_18469__$1 = state_18469;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18481_18507 = state_18469__$1;
(statearr_18481_18507[(1)] = (11));

} else {
var statearr_18482_18508 = state_18469__$1;
(statearr_18482_18508[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (5))){
var inst_18446 = (state_18469[(7)]);
var state_18469__$1 = state_18469;
var statearr_18483_18509 = state_18469__$1;
(statearr_18483_18509[(2)] = inst_18446);

(statearr_18483_18509[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (10))){
var inst_18465 = (state_18469[(2)]);
var state_18469__$1 = state_18469;
var statearr_18484_18510 = state_18469__$1;
(statearr_18484_18510[(2)] = inst_18465);

(statearr_18484_18510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18470 === (8))){
var inst_18446 = (state_18469[(7)]);
var inst_18456 = cljs.core.next(inst_18446);
var inst_18446__$1 = inst_18456;
var state_18469__$1 = (function (){var statearr_18485 = state_18469;
(statearr_18485[(7)] = inst_18446__$1);

return statearr_18485;
})();
var statearr_18486_18511 = state_18469__$1;
(statearr_18486_18511[(2)] = null);

(statearr_18486_18511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto__))
;
return ((function (switch__17531__auto__,c__17645__auto__){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_18490 = [null,null,null,null,null,null,null,null];
(statearr_18490[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_18490[(1)] = (1));

return statearr_18490;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_18469){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18469);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18491){if((e18491 instanceof Object)){
var ex__17535__auto__ = e18491;
var statearr_18492_18512 = state_18469;
(statearr_18492_18512[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18469);

return cljs.core.cst$kw$recur;
} else {
throw e18491;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__18513 = state_18469;
state_18469 = G__18513;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_18469){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_18469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__))
})();
var state__17647__auto__ = (function (){var statearr_18493 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_18493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__))
);

return c__17645__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6873__auto__ = (((_ == null))?null:_);
var m__6874__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__6874__auto__.call(null,_));
} else {
var m__6874__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__6874__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6874__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__6874__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6874__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto__.call(null,m));
} else {
var m__6874__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__18738 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__18738) : cljs.core.atom.call(null,G__18738));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18739 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18739 = (function (mult,ch,cs,meta18740){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18740 = meta18740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18741,meta18740__$1){
var self__ = this;
var _18741__$1 = this;
return (new cljs.core.async.t_cljs$core$async18739(self__.mult,self__.ch,self__.cs,meta18740__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18741){
var self__ = this;
var _18741__$1 = this;
return self__.meta18740;
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__18742_18962 = self__.cs;
var G__18743_18963 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__18742_18962,G__18743_18963) : cljs.core.reset_BANG_.call(null,G__18742_18962,G__18743_18963));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta18740], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18739.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18739.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18739";

cljs.core.async.t_cljs$core$async18739.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async18739");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18739 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18739(mult__$1,ch__$1,cs__$1,meta18740){
return (new cljs.core.async.t_cljs$core$async18739(mult__$1,ch__$1,cs__$1,meta18740));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18739(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__17645__auto___18964 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___18964,cs,m,dchan,dctr,done){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___18964,cs,m,dchan,dctr,done){
return (function (state_18874){
var state_val_18875 = (state_18874[(1)]);
if((state_val_18875 === (7))){
var inst_18870 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18876_18965 = state_18874__$1;
(statearr_18876_18965[(2)] = inst_18870);

(statearr_18876_18965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (20))){
var inst_18775 = (state_18874[(7)]);
var inst_18785 = cljs.core.first(inst_18775);
var inst_18786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18785,(0),null);
var inst_18787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18785,(1),null);
var state_18874__$1 = (function (){var statearr_18877 = state_18874;
(statearr_18877[(8)] = inst_18786);

return statearr_18877;
})();
if(cljs.core.truth_(inst_18787)){
var statearr_18878_18966 = state_18874__$1;
(statearr_18878_18966[(1)] = (22));

} else {
var statearr_18879_18967 = state_18874__$1;
(statearr_18879_18967[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (27))){
var inst_18817 = (state_18874[(9)]);
var inst_18815 = (state_18874[(10)]);
var inst_18822 = (state_18874[(11)]);
var inst_18746 = (state_18874[(12)]);
var inst_18822__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18815,inst_18817);
var inst_18823 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18822__$1,inst_18746,done);
var state_18874__$1 = (function (){var statearr_18880 = state_18874;
(statearr_18880[(11)] = inst_18822__$1);

return statearr_18880;
})();
if(cljs.core.truth_(inst_18823)){
var statearr_18881_18968 = state_18874__$1;
(statearr_18881_18968[(1)] = (30));

} else {
var statearr_18882_18969 = state_18874__$1;
(statearr_18882_18969[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (1))){
var state_18874__$1 = state_18874;
var statearr_18883_18970 = state_18874__$1;
(statearr_18883_18970[(2)] = null);

(statearr_18883_18970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (24))){
var inst_18775 = (state_18874[(7)]);
var inst_18792 = (state_18874[(2)]);
var inst_18793 = cljs.core.next(inst_18775);
var inst_18755 = inst_18793;
var inst_18756 = null;
var inst_18757 = (0);
var inst_18758 = (0);
var state_18874__$1 = (function (){var statearr_18884 = state_18874;
(statearr_18884[(13)] = inst_18755);

(statearr_18884[(14)] = inst_18756);

(statearr_18884[(15)] = inst_18792);

(statearr_18884[(16)] = inst_18758);

(statearr_18884[(17)] = inst_18757);

return statearr_18884;
})();
var statearr_18885_18971 = state_18874__$1;
(statearr_18885_18971[(2)] = null);

(statearr_18885_18971[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (39))){
var state_18874__$1 = state_18874;
var statearr_18889_18972 = state_18874__$1;
(statearr_18889_18972[(2)] = null);

(statearr_18889_18972[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (4))){
var inst_18746 = (state_18874[(12)]);
var inst_18746__$1 = (state_18874[(2)]);
var inst_18747 = (inst_18746__$1 == null);
var state_18874__$1 = (function (){var statearr_18890 = state_18874;
(statearr_18890[(12)] = inst_18746__$1);

return statearr_18890;
})();
if(cljs.core.truth_(inst_18747)){
var statearr_18891_18973 = state_18874__$1;
(statearr_18891_18973[(1)] = (5));

} else {
var statearr_18892_18974 = state_18874__$1;
(statearr_18892_18974[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (15))){
var inst_18755 = (state_18874[(13)]);
var inst_18756 = (state_18874[(14)]);
var inst_18758 = (state_18874[(16)]);
var inst_18757 = (state_18874[(17)]);
var inst_18771 = (state_18874[(2)]);
var inst_18772 = (inst_18758 + (1));
var tmp18886 = inst_18755;
var tmp18887 = inst_18756;
var tmp18888 = inst_18757;
var inst_18755__$1 = tmp18886;
var inst_18756__$1 = tmp18887;
var inst_18757__$1 = tmp18888;
var inst_18758__$1 = inst_18772;
var state_18874__$1 = (function (){var statearr_18893 = state_18874;
(statearr_18893[(13)] = inst_18755__$1);

(statearr_18893[(18)] = inst_18771);

(statearr_18893[(14)] = inst_18756__$1);

(statearr_18893[(16)] = inst_18758__$1);

(statearr_18893[(17)] = inst_18757__$1);

return statearr_18893;
})();
var statearr_18894_18975 = state_18874__$1;
(statearr_18894_18975[(2)] = null);

(statearr_18894_18975[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (21))){
var inst_18796 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18898_18976 = state_18874__$1;
(statearr_18898_18976[(2)] = inst_18796);

(statearr_18898_18976[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (31))){
var inst_18822 = (state_18874[(11)]);
var inst_18826 = done(null);
var inst_18827 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18822);
var state_18874__$1 = (function (){var statearr_18899 = state_18874;
(statearr_18899[(19)] = inst_18826);

return statearr_18899;
})();
var statearr_18900_18977 = state_18874__$1;
(statearr_18900_18977[(2)] = inst_18827);

(statearr_18900_18977[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (32))){
var inst_18817 = (state_18874[(9)]);
var inst_18815 = (state_18874[(10)]);
var inst_18816 = (state_18874[(20)]);
var inst_18814 = (state_18874[(21)]);
var inst_18829 = (state_18874[(2)]);
var inst_18830 = (inst_18817 + (1));
var tmp18895 = inst_18815;
var tmp18896 = inst_18816;
var tmp18897 = inst_18814;
var inst_18814__$1 = tmp18897;
var inst_18815__$1 = tmp18895;
var inst_18816__$1 = tmp18896;
var inst_18817__$1 = inst_18830;
var state_18874__$1 = (function (){var statearr_18901 = state_18874;
(statearr_18901[(22)] = inst_18829);

(statearr_18901[(9)] = inst_18817__$1);

(statearr_18901[(10)] = inst_18815__$1);

(statearr_18901[(20)] = inst_18816__$1);

(statearr_18901[(21)] = inst_18814__$1);

return statearr_18901;
})();
var statearr_18902_18978 = state_18874__$1;
(statearr_18902_18978[(2)] = null);

(statearr_18902_18978[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (40))){
var inst_18842 = (state_18874[(23)]);
var inst_18846 = done(null);
var inst_18847 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18842);
var state_18874__$1 = (function (){var statearr_18903 = state_18874;
(statearr_18903[(24)] = inst_18846);

return statearr_18903;
})();
var statearr_18904_18979 = state_18874__$1;
(statearr_18904_18979[(2)] = inst_18847);

(statearr_18904_18979[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (33))){
var inst_18833 = (state_18874[(25)]);
var inst_18835 = cljs.core.chunked_seq_QMARK_(inst_18833);
var state_18874__$1 = state_18874;
if(inst_18835){
var statearr_18905_18980 = state_18874__$1;
(statearr_18905_18980[(1)] = (36));

} else {
var statearr_18906_18981 = state_18874__$1;
(statearr_18906_18981[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (13))){
var inst_18765 = (state_18874[(26)]);
var inst_18768 = cljs.core.async.close_BANG_(inst_18765);
var state_18874__$1 = state_18874;
var statearr_18907_18982 = state_18874__$1;
(statearr_18907_18982[(2)] = inst_18768);

(statearr_18907_18982[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (22))){
var inst_18786 = (state_18874[(8)]);
var inst_18789 = cljs.core.async.close_BANG_(inst_18786);
var state_18874__$1 = state_18874;
var statearr_18908_18983 = state_18874__$1;
(statearr_18908_18983[(2)] = inst_18789);

(statearr_18908_18983[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (36))){
var inst_18833 = (state_18874[(25)]);
var inst_18837 = cljs.core.chunk_first(inst_18833);
var inst_18838 = cljs.core.chunk_rest(inst_18833);
var inst_18839 = cljs.core.count(inst_18837);
var inst_18814 = inst_18838;
var inst_18815 = inst_18837;
var inst_18816 = inst_18839;
var inst_18817 = (0);
var state_18874__$1 = (function (){var statearr_18909 = state_18874;
(statearr_18909[(9)] = inst_18817);

(statearr_18909[(10)] = inst_18815);

(statearr_18909[(20)] = inst_18816);

(statearr_18909[(21)] = inst_18814);

return statearr_18909;
})();
var statearr_18910_18984 = state_18874__$1;
(statearr_18910_18984[(2)] = null);

(statearr_18910_18984[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (41))){
var inst_18833 = (state_18874[(25)]);
var inst_18849 = (state_18874[(2)]);
var inst_18850 = cljs.core.next(inst_18833);
var inst_18814 = inst_18850;
var inst_18815 = null;
var inst_18816 = (0);
var inst_18817 = (0);
var state_18874__$1 = (function (){var statearr_18911 = state_18874;
(statearr_18911[(9)] = inst_18817);

(statearr_18911[(10)] = inst_18815);

(statearr_18911[(20)] = inst_18816);

(statearr_18911[(21)] = inst_18814);

(statearr_18911[(27)] = inst_18849);

return statearr_18911;
})();
var statearr_18912_18985 = state_18874__$1;
(statearr_18912_18985[(2)] = null);

(statearr_18912_18985[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (43))){
var state_18874__$1 = state_18874;
var statearr_18913_18986 = state_18874__$1;
(statearr_18913_18986[(2)] = null);

(statearr_18913_18986[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (29))){
var inst_18858 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18914_18987 = state_18874__$1;
(statearr_18914_18987[(2)] = inst_18858);

(statearr_18914_18987[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (44))){
var inst_18867 = (state_18874[(2)]);
var state_18874__$1 = (function (){var statearr_18915 = state_18874;
(statearr_18915[(28)] = inst_18867);

return statearr_18915;
})();
var statearr_18916_18988 = state_18874__$1;
(statearr_18916_18988[(2)] = null);

(statearr_18916_18988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (6))){
var inst_18806 = (state_18874[(29)]);
var inst_18805 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_18806__$1 = cljs.core.keys(inst_18805);
var inst_18807 = cljs.core.count(inst_18806__$1);
var inst_18808 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_18807) : cljs.core.reset_BANG_.call(null,dctr,inst_18807));
var inst_18813 = cljs.core.seq(inst_18806__$1);
var inst_18814 = inst_18813;
var inst_18815 = null;
var inst_18816 = (0);
var inst_18817 = (0);
var state_18874__$1 = (function (){var statearr_18917 = state_18874;
(statearr_18917[(9)] = inst_18817);

(statearr_18917[(10)] = inst_18815);

(statearr_18917[(20)] = inst_18816);

(statearr_18917[(29)] = inst_18806__$1);

(statearr_18917[(21)] = inst_18814);

(statearr_18917[(30)] = inst_18808);

return statearr_18917;
})();
var statearr_18918_18989 = state_18874__$1;
(statearr_18918_18989[(2)] = null);

(statearr_18918_18989[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (28))){
var inst_18814 = (state_18874[(21)]);
var inst_18833 = (state_18874[(25)]);
var inst_18833__$1 = cljs.core.seq(inst_18814);
var state_18874__$1 = (function (){var statearr_18919 = state_18874;
(statearr_18919[(25)] = inst_18833__$1);

return statearr_18919;
})();
if(inst_18833__$1){
var statearr_18920_18990 = state_18874__$1;
(statearr_18920_18990[(1)] = (33));

} else {
var statearr_18921_18991 = state_18874__$1;
(statearr_18921_18991[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (25))){
var inst_18817 = (state_18874[(9)]);
var inst_18816 = (state_18874[(20)]);
var inst_18819 = (inst_18817 < inst_18816);
var inst_18820 = inst_18819;
var state_18874__$1 = state_18874;
if(cljs.core.truth_(inst_18820)){
var statearr_18922_18992 = state_18874__$1;
(statearr_18922_18992[(1)] = (27));

} else {
var statearr_18923_18993 = state_18874__$1;
(statearr_18923_18993[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (34))){
var state_18874__$1 = state_18874;
var statearr_18924_18994 = state_18874__$1;
(statearr_18924_18994[(2)] = null);

(statearr_18924_18994[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (17))){
var state_18874__$1 = state_18874;
var statearr_18925_18995 = state_18874__$1;
(statearr_18925_18995[(2)] = null);

(statearr_18925_18995[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (3))){
var inst_18872 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18874__$1,inst_18872);
} else {
if((state_val_18875 === (12))){
var inst_18801 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18926_18996 = state_18874__$1;
(statearr_18926_18996[(2)] = inst_18801);

(statearr_18926_18996[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (2))){
var state_18874__$1 = state_18874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18874__$1,(4),ch);
} else {
if((state_val_18875 === (23))){
var state_18874__$1 = state_18874;
var statearr_18927_18997 = state_18874__$1;
(statearr_18927_18997[(2)] = null);

(statearr_18927_18997[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (35))){
var inst_18856 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18928_18998 = state_18874__$1;
(statearr_18928_18998[(2)] = inst_18856);

(statearr_18928_18998[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (19))){
var inst_18775 = (state_18874[(7)]);
var inst_18779 = cljs.core.chunk_first(inst_18775);
var inst_18780 = cljs.core.chunk_rest(inst_18775);
var inst_18781 = cljs.core.count(inst_18779);
var inst_18755 = inst_18780;
var inst_18756 = inst_18779;
var inst_18757 = inst_18781;
var inst_18758 = (0);
var state_18874__$1 = (function (){var statearr_18929 = state_18874;
(statearr_18929[(13)] = inst_18755);

(statearr_18929[(14)] = inst_18756);

(statearr_18929[(16)] = inst_18758);

(statearr_18929[(17)] = inst_18757);

return statearr_18929;
})();
var statearr_18930_18999 = state_18874__$1;
(statearr_18930_18999[(2)] = null);

(statearr_18930_18999[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (11))){
var inst_18755 = (state_18874[(13)]);
var inst_18775 = (state_18874[(7)]);
var inst_18775__$1 = cljs.core.seq(inst_18755);
var state_18874__$1 = (function (){var statearr_18931 = state_18874;
(statearr_18931[(7)] = inst_18775__$1);

return statearr_18931;
})();
if(inst_18775__$1){
var statearr_18932_19000 = state_18874__$1;
(statearr_18932_19000[(1)] = (16));

} else {
var statearr_18933_19001 = state_18874__$1;
(statearr_18933_19001[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (9))){
var inst_18803 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18934_19002 = state_18874__$1;
(statearr_18934_19002[(2)] = inst_18803);

(statearr_18934_19002[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (5))){
var inst_18753 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_18754 = cljs.core.seq(inst_18753);
var inst_18755 = inst_18754;
var inst_18756 = null;
var inst_18757 = (0);
var inst_18758 = (0);
var state_18874__$1 = (function (){var statearr_18935 = state_18874;
(statearr_18935[(13)] = inst_18755);

(statearr_18935[(14)] = inst_18756);

(statearr_18935[(16)] = inst_18758);

(statearr_18935[(17)] = inst_18757);

return statearr_18935;
})();
var statearr_18936_19003 = state_18874__$1;
(statearr_18936_19003[(2)] = null);

(statearr_18936_19003[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (14))){
var state_18874__$1 = state_18874;
var statearr_18937_19004 = state_18874__$1;
(statearr_18937_19004[(2)] = null);

(statearr_18937_19004[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (45))){
var inst_18864 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18938_19005 = state_18874__$1;
(statearr_18938_19005[(2)] = inst_18864);

(statearr_18938_19005[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (26))){
var inst_18806 = (state_18874[(29)]);
var inst_18860 = (state_18874[(2)]);
var inst_18861 = cljs.core.seq(inst_18806);
var state_18874__$1 = (function (){var statearr_18939 = state_18874;
(statearr_18939[(31)] = inst_18860);

return statearr_18939;
})();
if(inst_18861){
var statearr_18940_19006 = state_18874__$1;
(statearr_18940_19006[(1)] = (42));

} else {
var statearr_18941_19007 = state_18874__$1;
(statearr_18941_19007[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (16))){
var inst_18775 = (state_18874[(7)]);
var inst_18777 = cljs.core.chunked_seq_QMARK_(inst_18775);
var state_18874__$1 = state_18874;
if(inst_18777){
var statearr_18942_19008 = state_18874__$1;
(statearr_18942_19008[(1)] = (19));

} else {
var statearr_18943_19009 = state_18874__$1;
(statearr_18943_19009[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (38))){
var inst_18853 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18944_19010 = state_18874__$1;
(statearr_18944_19010[(2)] = inst_18853);

(statearr_18944_19010[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (30))){
var state_18874__$1 = state_18874;
var statearr_18945_19011 = state_18874__$1;
(statearr_18945_19011[(2)] = null);

(statearr_18945_19011[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (10))){
var inst_18756 = (state_18874[(14)]);
var inst_18758 = (state_18874[(16)]);
var inst_18764 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18756,inst_18758);
var inst_18765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18764,(0),null);
var inst_18766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18764,(1),null);
var state_18874__$1 = (function (){var statearr_18946 = state_18874;
(statearr_18946[(26)] = inst_18765);

return statearr_18946;
})();
if(cljs.core.truth_(inst_18766)){
var statearr_18947_19012 = state_18874__$1;
(statearr_18947_19012[(1)] = (13));

} else {
var statearr_18948_19013 = state_18874__$1;
(statearr_18948_19013[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (18))){
var inst_18799 = (state_18874[(2)]);
var state_18874__$1 = state_18874;
var statearr_18949_19014 = state_18874__$1;
(statearr_18949_19014[(2)] = inst_18799);

(statearr_18949_19014[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (42))){
var state_18874__$1 = state_18874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18874__$1,(45),dchan);
} else {
if((state_val_18875 === (37))){
var inst_18842 = (state_18874[(23)]);
var inst_18746 = (state_18874[(12)]);
var inst_18833 = (state_18874[(25)]);
var inst_18842__$1 = cljs.core.first(inst_18833);
var inst_18843 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18842__$1,inst_18746,done);
var state_18874__$1 = (function (){var statearr_18950 = state_18874;
(statearr_18950[(23)] = inst_18842__$1);

return statearr_18950;
})();
if(cljs.core.truth_(inst_18843)){
var statearr_18951_19015 = state_18874__$1;
(statearr_18951_19015[(1)] = (39));

} else {
var statearr_18952_19016 = state_18874__$1;
(statearr_18952_19016[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18875 === (8))){
var inst_18758 = (state_18874[(16)]);
var inst_18757 = (state_18874[(17)]);
var inst_18760 = (inst_18758 < inst_18757);
var inst_18761 = inst_18760;
var state_18874__$1 = state_18874;
if(cljs.core.truth_(inst_18761)){
var statearr_18953_19017 = state_18874__$1;
(statearr_18953_19017[(1)] = (10));

} else {
var statearr_18954_19018 = state_18874__$1;
(statearr_18954_19018[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___18964,cs,m,dchan,dctr,done))
;
return ((function (switch__17531__auto__,c__17645__auto___18964,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17532__auto__ = null;
var cljs$core$async$mult_$_state_machine__17532__auto____0 = (function (){
var statearr_18958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18958[(0)] = cljs$core$async$mult_$_state_machine__17532__auto__);

(statearr_18958[(1)] = (1));

return statearr_18958;
});
var cljs$core$async$mult_$_state_machine__17532__auto____1 = (function (state_18874){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_18874);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e18959){if((e18959 instanceof Object)){
var ex__17535__auto__ = e18959;
var statearr_18960_19019 = state_18874;
(statearr_18960_19019[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18874);

return cljs.core.cst$kw$recur;
} else {
throw e18959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19020 = state_18874;
state_18874 = G__19020;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17532__auto__ = function(state_18874){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17532__auto____1.call(this,state_18874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17532__auto____0;
cljs$core$async$mult_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17532__auto____1;
return cljs$core$async$mult_$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___18964,cs,m,dchan,dctr,done))
})();
var state__17647__auto__ = (function (){var statearr_18961 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_18961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___18964);

return statearr_18961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___18964,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args19021 = [];
var len__7280__auto___19024 = arguments.length;
var i__7281__auto___19025 = (0);
while(true){
if((i__7281__auto___19025 < len__7280__auto___19024)){
args19021.push((arguments[i__7281__auto___19025]));

var G__19026 = (i__7281__auto___19025 + (1));
i__7281__auto___19025 = G__19026;
continue;
} else {
}
break;
}

var G__19023 = args19021.length;
switch (G__19023) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19021.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto__.call(null,m,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6874__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto__.call(null,m));
} else {
var m__6874__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6874__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6874__auto__.call(null,m,state_map));
} else {
var m__6874__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6874__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6873__auto__ = (((m == null))?null:m);
var m__6874__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6874__auto__.call(null,m,mode));
} else {
var m__6874__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6874__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7287__auto__ = [];
var len__7280__auto___19038 = arguments.length;
var i__7281__auto___19039 = (0);
while(true){
if((i__7281__auto___19039 < len__7280__auto___19038)){
args__7287__auto__.push((arguments[i__7281__auto___19039]));

var G__19040 = (i__7281__auto___19039 + (1));
i__7281__auto___19039 = G__19040;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((3) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7288__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19032){
var map__19033 = p__19032;
var map__19033__$1 = ((((!((map__19033 == null)))?((((map__19033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19033):map__19033);
var opts = map__19033__$1;
var statearr_19035_19041 = state;
(statearr_19035_19041[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__19033,map__19033__$1,opts){
return (function (val){
var statearr_19036_19042 = state;
(statearr_19036_19042[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__19033,map__19033__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_19037_19043 = state;
(statearr_19037_19043[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19028){
var G__19029 = cljs.core.first(seq19028);
var seq19028__$1 = cljs.core.next(seq19028);
var G__19030 = cljs.core.first(seq19028__$1);
var seq19028__$2 = cljs.core.next(seq19028__$1);
var G__19031 = cljs.core.first(seq19028__$2);
var seq19028__$3 = cljs.core.next(seq19028__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19029,G__19030,G__19031,seq19028__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__19210 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19210) : cljs.core.atom.call(null,G__19210));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19211 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19211 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19212){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19212 = meta19212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19213,meta19212__$1){
var self__ = this;
var _19213__$1 = this;
return (new cljs.core.async.t_cljs$core$async19211(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19212__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19213){
var self__ = this;
var _19213__$1 = this;
return self__.meta19212;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19214_19376 = self__.cs;
var G__19215_19377 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19214_19376,G__19215_19377) : cljs.core.reset_BANG_.call(null,G__19214_19376,G__19215_19377));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta19212], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19211.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19211";

cljs.core.async.t_cljs$core$async19211.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19211");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19211 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19211(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19212){
return (new cljs.core.async.t_cljs$core$async19211(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19212));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19211(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17645__auto___19378 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19313){
var state_val_19314 = (state_19313[(1)]);
if((state_val_19314 === (7))){
var inst_19231 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
var statearr_19315_19379 = state_19313__$1;
(statearr_19315_19379[(2)] = inst_19231);

(statearr_19315_19379[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (20))){
var inst_19243 = (state_19313[(7)]);
var state_19313__$1 = state_19313;
var statearr_19316_19380 = state_19313__$1;
(statearr_19316_19380[(2)] = inst_19243);

(statearr_19316_19380[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (27))){
var state_19313__$1 = state_19313;
var statearr_19317_19381 = state_19313__$1;
(statearr_19317_19381[(2)] = null);

(statearr_19317_19381[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (1))){
var inst_19219 = (state_19313[(8)]);
var inst_19219__$1 = calc_state();
var inst_19221 = (inst_19219__$1 == null);
var inst_19222 = cljs.core.not(inst_19221);
var state_19313__$1 = (function (){var statearr_19318 = state_19313;
(statearr_19318[(8)] = inst_19219__$1);

return statearr_19318;
})();
if(inst_19222){
var statearr_19319_19382 = state_19313__$1;
(statearr_19319_19382[(1)] = (2));

} else {
var statearr_19320_19383 = state_19313__$1;
(statearr_19320_19383[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (24))){
var inst_19273 = (state_19313[(9)]);
var inst_19287 = (state_19313[(10)]);
var inst_19266 = (state_19313[(11)]);
var inst_19287__$1 = (inst_19266.cljs$core$IFn$_invoke$arity$1 ? inst_19266.cljs$core$IFn$_invoke$arity$1(inst_19273) : inst_19266.call(null,inst_19273));
var state_19313__$1 = (function (){var statearr_19321 = state_19313;
(statearr_19321[(10)] = inst_19287__$1);

return statearr_19321;
})();
if(cljs.core.truth_(inst_19287__$1)){
var statearr_19322_19384 = state_19313__$1;
(statearr_19322_19384[(1)] = (29));

} else {
var statearr_19323_19385 = state_19313__$1;
(statearr_19323_19385[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (4))){
var inst_19234 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19234)){
var statearr_19324_19386 = state_19313__$1;
(statearr_19324_19386[(1)] = (8));

} else {
var statearr_19325_19387 = state_19313__$1;
(statearr_19325_19387[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (15))){
var inst_19260 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19260)){
var statearr_19326_19388 = state_19313__$1;
(statearr_19326_19388[(1)] = (19));

} else {
var statearr_19327_19389 = state_19313__$1;
(statearr_19327_19389[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (21))){
var inst_19265 = (state_19313[(12)]);
var inst_19265__$1 = (state_19313[(2)]);
var inst_19266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19265__$1,cljs.core.cst$kw$solos);
var inst_19267 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19265__$1,cljs.core.cst$kw$mutes);
var inst_19268 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19265__$1,cljs.core.cst$kw$reads);
var state_19313__$1 = (function (){var statearr_19328 = state_19313;
(statearr_19328[(13)] = inst_19267);

(statearr_19328[(11)] = inst_19266);

(statearr_19328[(12)] = inst_19265__$1);

return statearr_19328;
})();
return cljs.core.async.ioc_alts_BANG_(state_19313__$1,(22),inst_19268);
} else {
if((state_val_19314 === (31))){
var inst_19295 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19295)){
var statearr_19329_19390 = state_19313__$1;
(statearr_19329_19390[(1)] = (32));

} else {
var statearr_19330_19391 = state_19313__$1;
(statearr_19330_19391[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (32))){
var inst_19272 = (state_19313[(14)]);
var state_19313__$1 = state_19313;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19313__$1,(35),out,inst_19272);
} else {
if((state_val_19314 === (33))){
var inst_19265 = (state_19313[(12)]);
var inst_19243 = inst_19265;
var state_19313__$1 = (function (){var statearr_19331 = state_19313;
(statearr_19331[(7)] = inst_19243);

return statearr_19331;
})();
var statearr_19332_19392 = state_19313__$1;
(statearr_19332_19392[(2)] = null);

(statearr_19332_19392[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (13))){
var inst_19243 = (state_19313[(7)]);
var inst_19250 = inst_19243.cljs$lang$protocol_mask$partition0$;
var inst_19251 = (inst_19250 & (64));
var inst_19252 = inst_19243.cljs$core$ISeq$;
var inst_19253 = (inst_19251) || (inst_19252);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19253)){
var statearr_19333_19393 = state_19313__$1;
(statearr_19333_19393[(1)] = (16));

} else {
var statearr_19334_19394 = state_19313__$1;
(statearr_19334_19394[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (22))){
var inst_19273 = (state_19313[(9)]);
var inst_19272 = (state_19313[(14)]);
var inst_19271 = (state_19313[(2)]);
var inst_19272__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19271,(0),null);
var inst_19273__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19271,(1),null);
var inst_19274 = (inst_19272__$1 == null);
var inst_19275 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19273__$1,change);
var inst_19276 = (inst_19274) || (inst_19275);
var state_19313__$1 = (function (){var statearr_19335 = state_19313;
(statearr_19335[(9)] = inst_19273__$1);

(statearr_19335[(14)] = inst_19272__$1);

return statearr_19335;
})();
if(cljs.core.truth_(inst_19276)){
var statearr_19336_19395 = state_19313__$1;
(statearr_19336_19395[(1)] = (23));

} else {
var statearr_19337_19396 = state_19313__$1;
(statearr_19337_19396[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (36))){
var inst_19265 = (state_19313[(12)]);
var inst_19243 = inst_19265;
var state_19313__$1 = (function (){var statearr_19338 = state_19313;
(statearr_19338[(7)] = inst_19243);

return statearr_19338;
})();
var statearr_19339_19397 = state_19313__$1;
(statearr_19339_19397[(2)] = null);

(statearr_19339_19397[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (29))){
var inst_19287 = (state_19313[(10)]);
var state_19313__$1 = state_19313;
var statearr_19340_19398 = state_19313__$1;
(statearr_19340_19398[(2)] = inst_19287);

(statearr_19340_19398[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (6))){
var state_19313__$1 = state_19313;
var statearr_19341_19399 = state_19313__$1;
(statearr_19341_19399[(2)] = false);

(statearr_19341_19399[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (28))){
var inst_19283 = (state_19313[(2)]);
var inst_19284 = calc_state();
var inst_19243 = inst_19284;
var state_19313__$1 = (function (){var statearr_19342 = state_19313;
(statearr_19342[(7)] = inst_19243);

(statearr_19342[(15)] = inst_19283);

return statearr_19342;
})();
var statearr_19343_19400 = state_19313__$1;
(statearr_19343_19400[(2)] = null);

(statearr_19343_19400[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (25))){
var inst_19309 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
var statearr_19344_19401 = state_19313__$1;
(statearr_19344_19401[(2)] = inst_19309);

(statearr_19344_19401[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (34))){
var inst_19307 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
var statearr_19345_19402 = state_19313__$1;
(statearr_19345_19402[(2)] = inst_19307);

(statearr_19345_19402[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (17))){
var state_19313__$1 = state_19313;
var statearr_19346_19403 = state_19313__$1;
(statearr_19346_19403[(2)] = false);

(statearr_19346_19403[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (3))){
var state_19313__$1 = state_19313;
var statearr_19347_19404 = state_19313__$1;
(statearr_19347_19404[(2)] = false);

(statearr_19347_19404[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (12))){
var inst_19311 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19313__$1,inst_19311);
} else {
if((state_val_19314 === (2))){
var inst_19219 = (state_19313[(8)]);
var inst_19224 = inst_19219.cljs$lang$protocol_mask$partition0$;
var inst_19225 = (inst_19224 & (64));
var inst_19226 = inst_19219.cljs$core$ISeq$;
var inst_19227 = (inst_19225) || (inst_19226);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19227)){
var statearr_19348_19405 = state_19313__$1;
(statearr_19348_19405[(1)] = (5));

} else {
var statearr_19349_19406 = state_19313__$1;
(statearr_19349_19406[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (23))){
var inst_19272 = (state_19313[(14)]);
var inst_19278 = (inst_19272 == null);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19278)){
var statearr_19350_19407 = state_19313__$1;
(statearr_19350_19407[(1)] = (26));

} else {
var statearr_19351_19408 = state_19313__$1;
(statearr_19351_19408[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (35))){
var inst_19298 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
if(cljs.core.truth_(inst_19298)){
var statearr_19352_19409 = state_19313__$1;
(statearr_19352_19409[(1)] = (36));

} else {
var statearr_19353_19410 = state_19313__$1;
(statearr_19353_19410[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (19))){
var inst_19243 = (state_19313[(7)]);
var inst_19262 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19243);
var state_19313__$1 = state_19313;
var statearr_19354_19411 = state_19313__$1;
(statearr_19354_19411[(2)] = inst_19262);

(statearr_19354_19411[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (11))){
var inst_19243 = (state_19313[(7)]);
var inst_19247 = (inst_19243 == null);
var inst_19248 = cljs.core.not(inst_19247);
var state_19313__$1 = state_19313;
if(inst_19248){
var statearr_19355_19412 = state_19313__$1;
(statearr_19355_19412[(1)] = (13));

} else {
var statearr_19356_19413 = state_19313__$1;
(statearr_19356_19413[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (9))){
var inst_19219 = (state_19313[(8)]);
var state_19313__$1 = state_19313;
var statearr_19357_19414 = state_19313__$1;
(statearr_19357_19414[(2)] = inst_19219);

(statearr_19357_19414[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (5))){
var state_19313__$1 = state_19313;
var statearr_19358_19415 = state_19313__$1;
(statearr_19358_19415[(2)] = true);

(statearr_19358_19415[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (14))){
var state_19313__$1 = state_19313;
var statearr_19359_19416 = state_19313__$1;
(statearr_19359_19416[(2)] = false);

(statearr_19359_19416[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (26))){
var inst_19273 = (state_19313[(9)]);
var inst_19280 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_19273);
var state_19313__$1 = state_19313;
var statearr_19360_19417 = state_19313__$1;
(statearr_19360_19417[(2)] = inst_19280);

(statearr_19360_19417[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (16))){
var state_19313__$1 = state_19313;
var statearr_19361_19418 = state_19313__$1;
(statearr_19361_19418[(2)] = true);

(statearr_19361_19418[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (38))){
var inst_19303 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
var statearr_19362_19419 = state_19313__$1;
(statearr_19362_19419[(2)] = inst_19303);

(statearr_19362_19419[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (30))){
var inst_19267 = (state_19313[(13)]);
var inst_19273 = (state_19313[(9)]);
var inst_19266 = (state_19313[(11)]);
var inst_19290 = cljs.core.empty_QMARK_(inst_19266);
var inst_19291 = (inst_19267.cljs$core$IFn$_invoke$arity$1 ? inst_19267.cljs$core$IFn$_invoke$arity$1(inst_19273) : inst_19267.call(null,inst_19273));
var inst_19292 = cljs.core.not(inst_19291);
var inst_19293 = (inst_19290) && (inst_19292);
var state_19313__$1 = state_19313;
var statearr_19363_19420 = state_19313__$1;
(statearr_19363_19420[(2)] = inst_19293);

(statearr_19363_19420[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (10))){
var inst_19219 = (state_19313[(8)]);
var inst_19239 = (state_19313[(2)]);
var inst_19240 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19239,cljs.core.cst$kw$solos);
var inst_19241 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19239,cljs.core.cst$kw$mutes);
var inst_19242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19239,cljs.core.cst$kw$reads);
var inst_19243 = inst_19219;
var state_19313__$1 = (function (){var statearr_19364 = state_19313;
(statearr_19364[(7)] = inst_19243);

(statearr_19364[(16)] = inst_19240);

(statearr_19364[(17)] = inst_19241);

(statearr_19364[(18)] = inst_19242);

return statearr_19364;
})();
var statearr_19365_19421 = state_19313__$1;
(statearr_19365_19421[(2)] = null);

(statearr_19365_19421[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (18))){
var inst_19257 = (state_19313[(2)]);
var state_19313__$1 = state_19313;
var statearr_19366_19422 = state_19313__$1;
(statearr_19366_19422[(2)] = inst_19257);

(statearr_19366_19422[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (37))){
var state_19313__$1 = state_19313;
var statearr_19367_19423 = state_19313__$1;
(statearr_19367_19423[(2)] = null);

(statearr_19367_19423[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19314 === (8))){
var inst_19219 = (state_19313[(8)]);
var inst_19236 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19219);
var state_19313__$1 = state_19313;
var statearr_19368_19424 = state_19313__$1;
(statearr_19368_19424[(2)] = inst_19236);

(statearr_19368_19424[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17531__auto__,c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17532__auto__ = null;
var cljs$core$async$mix_$_state_machine__17532__auto____0 = (function (){
var statearr_19372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19372[(0)] = cljs$core$async$mix_$_state_machine__17532__auto__);

(statearr_19372[(1)] = (1));

return statearr_19372;
});
var cljs$core$async$mix_$_state_machine__17532__auto____1 = (function (state_19313){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19313);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19373){if((e19373 instanceof Object)){
var ex__17535__auto__ = e19373;
var statearr_19374_19425 = state_19313;
(statearr_19374_19425[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19313);

return cljs.core.cst$kw$recur;
} else {
throw e19373;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19426 = state_19313;
state_19313 = G__19426;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17532__auto__ = function(state_19313){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17532__auto____1.call(this,state_19313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17532__auto____0;
cljs$core$async$mix_$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17532__auto____1;
return cljs$core$async$mix_$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__17647__auto__ = (function (){var statearr_19375 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19378);

return statearr_19375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19378,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6874__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__6874__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6874__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6874__auto__.call(null,p,v,ch));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6874__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19427 = [];
var len__7280__auto___19430 = arguments.length;
var i__7281__auto___19431 = (0);
while(true){
if((i__7281__auto___19431 < len__7280__auto___19430)){
args19427.push((arguments[i__7281__auto___19431]));

var G__19432 = (i__7281__auto___19431 + (1));
i__7281__auto___19431 = G__19432;
continue;
} else {
}
break;
}

var G__19429 = args19427.length;
switch (G__19429) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19427.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__6874__auto__.call(null,p));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__6874__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6873__auto__ = (((p == null))?null:p);
var m__6874__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return (m__6874__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__6874__auto__.call(null,p,v));
} else {
var m__6874__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6874__auto____$1 == null))){
return (m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6874__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__6874__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19435 = [];
var len__7280__auto___19563 = arguments.length;
var i__7281__auto___19564 = (0);
while(true){
if((i__7281__auto___19564 < len__7280__auto___19563)){
args19435.push((arguments[i__7281__auto___19564]));

var G__19565 = (i__7281__auto___19564 + (1));
i__7281__auto___19564 = G__19565;
continue;
} else {
}
break;
}

var G__19437 = args19435.length;
switch (G__19437) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19435.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__19438 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19438) : cljs.core.atom.call(null,G__19438));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6210__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6210__auto__,mults){
return (function (p1__19434_SHARP_){
if(cljs.core.truth_((p1__19434_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19434_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__19434_SHARP_.call(null,topic)))){
return p1__19434_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19434_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6210__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19439 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19439 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19440){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19440 = meta19440;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19441,meta19440__$1){
var self__ = this;
var _19441__$1 = this;
return (new cljs.core.async.t_cljs$core$async19439(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19440__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19441){
var self__ = this;
var _19441__$1 = this;
return self__.meta19440;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19442 = self__.mults;
var G__19443 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19442,G__19443) : cljs.core.reset_BANG_.call(null,G__19442,G__19443));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta19440], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19439.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19439.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19439";

cljs.core.async.t_cljs$core$async19439.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19439");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19439 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19439(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19440){
return (new cljs.core.async.t_cljs$core$async19439(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19440));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19439(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17645__auto___19567 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19567,mults,ensure_mult,p){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19567,mults,ensure_mult,p){
return (function (state_19515){
var state_val_19516 = (state_19515[(1)]);
if((state_val_19516 === (7))){
var inst_19511 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19517_19568 = state_19515__$1;
(statearr_19517_19568[(2)] = inst_19511);

(statearr_19517_19568[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (20))){
var state_19515__$1 = state_19515;
var statearr_19518_19569 = state_19515__$1;
(statearr_19518_19569[(2)] = null);

(statearr_19518_19569[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (1))){
var state_19515__$1 = state_19515;
var statearr_19519_19570 = state_19515__$1;
(statearr_19519_19570[(2)] = null);

(statearr_19519_19570[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (24))){
var inst_19494 = (state_19515[(7)]);
var inst_19503 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_19494);
var state_19515__$1 = state_19515;
var statearr_19520_19571 = state_19515__$1;
(statearr_19520_19571[(2)] = inst_19503);

(statearr_19520_19571[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (4))){
var inst_19446 = (state_19515[(8)]);
var inst_19446__$1 = (state_19515[(2)]);
var inst_19447 = (inst_19446__$1 == null);
var state_19515__$1 = (function (){var statearr_19521 = state_19515;
(statearr_19521[(8)] = inst_19446__$1);

return statearr_19521;
})();
if(cljs.core.truth_(inst_19447)){
var statearr_19522_19572 = state_19515__$1;
(statearr_19522_19572[(1)] = (5));

} else {
var statearr_19523_19573 = state_19515__$1;
(statearr_19523_19573[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (15))){
var inst_19488 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19524_19574 = state_19515__$1;
(statearr_19524_19574[(2)] = inst_19488);

(statearr_19524_19574[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (21))){
var inst_19508 = (state_19515[(2)]);
var state_19515__$1 = (function (){var statearr_19525 = state_19515;
(statearr_19525[(9)] = inst_19508);

return statearr_19525;
})();
var statearr_19526_19575 = state_19515__$1;
(statearr_19526_19575[(2)] = null);

(statearr_19526_19575[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (13))){
var inst_19470 = (state_19515[(10)]);
var inst_19472 = cljs.core.chunked_seq_QMARK_(inst_19470);
var state_19515__$1 = state_19515;
if(inst_19472){
var statearr_19527_19576 = state_19515__$1;
(statearr_19527_19576[(1)] = (16));

} else {
var statearr_19528_19577 = state_19515__$1;
(statearr_19528_19577[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (22))){
var inst_19500 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
if(cljs.core.truth_(inst_19500)){
var statearr_19529_19578 = state_19515__$1;
(statearr_19529_19578[(1)] = (23));

} else {
var statearr_19530_19579 = state_19515__$1;
(statearr_19530_19579[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (6))){
var inst_19496 = (state_19515[(11)]);
var inst_19446 = (state_19515[(8)]);
var inst_19494 = (state_19515[(7)]);
var inst_19494__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_19446) : topic_fn.call(null,inst_19446));
var inst_19495 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19496__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19495,inst_19494__$1);
var state_19515__$1 = (function (){var statearr_19531 = state_19515;
(statearr_19531[(11)] = inst_19496__$1);

(statearr_19531[(7)] = inst_19494__$1);

return statearr_19531;
})();
if(cljs.core.truth_(inst_19496__$1)){
var statearr_19532_19580 = state_19515__$1;
(statearr_19532_19580[(1)] = (19));

} else {
var statearr_19533_19581 = state_19515__$1;
(statearr_19533_19581[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (25))){
var inst_19505 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19534_19582 = state_19515__$1;
(statearr_19534_19582[(2)] = inst_19505);

(statearr_19534_19582[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (17))){
var inst_19470 = (state_19515[(10)]);
var inst_19479 = cljs.core.first(inst_19470);
var inst_19480 = cljs.core.async.muxch_STAR_(inst_19479);
var inst_19481 = cljs.core.async.close_BANG_(inst_19480);
var inst_19482 = cljs.core.next(inst_19470);
var inst_19456 = inst_19482;
var inst_19457 = null;
var inst_19458 = (0);
var inst_19459 = (0);
var state_19515__$1 = (function (){var statearr_19535 = state_19515;
(statearr_19535[(12)] = inst_19459);

(statearr_19535[(13)] = inst_19456);

(statearr_19535[(14)] = inst_19457);

(statearr_19535[(15)] = inst_19481);

(statearr_19535[(16)] = inst_19458);

return statearr_19535;
})();
var statearr_19536_19583 = state_19515__$1;
(statearr_19536_19583[(2)] = null);

(statearr_19536_19583[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (3))){
var inst_19513 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19515__$1,inst_19513);
} else {
if((state_val_19516 === (12))){
var inst_19490 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19537_19584 = state_19515__$1;
(statearr_19537_19584[(2)] = inst_19490);

(statearr_19537_19584[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (2))){
var state_19515__$1 = state_19515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19515__$1,(4),ch);
} else {
if((state_val_19516 === (23))){
var state_19515__$1 = state_19515;
var statearr_19538_19585 = state_19515__$1;
(statearr_19538_19585[(2)] = null);

(statearr_19538_19585[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (19))){
var inst_19496 = (state_19515[(11)]);
var inst_19446 = (state_19515[(8)]);
var inst_19498 = cljs.core.async.muxch_STAR_(inst_19496);
var state_19515__$1 = state_19515;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19515__$1,(22),inst_19498,inst_19446);
} else {
if((state_val_19516 === (11))){
var inst_19456 = (state_19515[(13)]);
var inst_19470 = (state_19515[(10)]);
var inst_19470__$1 = cljs.core.seq(inst_19456);
var state_19515__$1 = (function (){var statearr_19539 = state_19515;
(statearr_19539[(10)] = inst_19470__$1);

return statearr_19539;
})();
if(inst_19470__$1){
var statearr_19540_19586 = state_19515__$1;
(statearr_19540_19586[(1)] = (13));

} else {
var statearr_19541_19587 = state_19515__$1;
(statearr_19541_19587[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (9))){
var inst_19492 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19542_19588 = state_19515__$1;
(statearr_19542_19588[(2)] = inst_19492);

(statearr_19542_19588[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (5))){
var inst_19453 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19454 = cljs.core.vals(inst_19453);
var inst_19455 = cljs.core.seq(inst_19454);
var inst_19456 = inst_19455;
var inst_19457 = null;
var inst_19458 = (0);
var inst_19459 = (0);
var state_19515__$1 = (function (){var statearr_19543 = state_19515;
(statearr_19543[(12)] = inst_19459);

(statearr_19543[(13)] = inst_19456);

(statearr_19543[(14)] = inst_19457);

(statearr_19543[(16)] = inst_19458);

return statearr_19543;
})();
var statearr_19544_19589 = state_19515__$1;
(statearr_19544_19589[(2)] = null);

(statearr_19544_19589[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (14))){
var state_19515__$1 = state_19515;
var statearr_19548_19590 = state_19515__$1;
(statearr_19548_19590[(2)] = null);

(statearr_19548_19590[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (16))){
var inst_19470 = (state_19515[(10)]);
var inst_19474 = cljs.core.chunk_first(inst_19470);
var inst_19475 = cljs.core.chunk_rest(inst_19470);
var inst_19476 = cljs.core.count(inst_19474);
var inst_19456 = inst_19475;
var inst_19457 = inst_19474;
var inst_19458 = inst_19476;
var inst_19459 = (0);
var state_19515__$1 = (function (){var statearr_19549 = state_19515;
(statearr_19549[(12)] = inst_19459);

(statearr_19549[(13)] = inst_19456);

(statearr_19549[(14)] = inst_19457);

(statearr_19549[(16)] = inst_19458);

return statearr_19549;
})();
var statearr_19550_19591 = state_19515__$1;
(statearr_19550_19591[(2)] = null);

(statearr_19550_19591[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (10))){
var inst_19459 = (state_19515[(12)]);
var inst_19456 = (state_19515[(13)]);
var inst_19457 = (state_19515[(14)]);
var inst_19458 = (state_19515[(16)]);
var inst_19464 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19457,inst_19459);
var inst_19465 = cljs.core.async.muxch_STAR_(inst_19464);
var inst_19466 = cljs.core.async.close_BANG_(inst_19465);
var inst_19467 = (inst_19459 + (1));
var tmp19545 = inst_19456;
var tmp19546 = inst_19457;
var tmp19547 = inst_19458;
var inst_19456__$1 = tmp19545;
var inst_19457__$1 = tmp19546;
var inst_19458__$1 = tmp19547;
var inst_19459__$1 = inst_19467;
var state_19515__$1 = (function (){var statearr_19551 = state_19515;
(statearr_19551[(12)] = inst_19459__$1);

(statearr_19551[(17)] = inst_19466);

(statearr_19551[(13)] = inst_19456__$1);

(statearr_19551[(14)] = inst_19457__$1);

(statearr_19551[(16)] = inst_19458__$1);

return statearr_19551;
})();
var statearr_19552_19592 = state_19515__$1;
(statearr_19552_19592[(2)] = null);

(statearr_19552_19592[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (18))){
var inst_19485 = (state_19515[(2)]);
var state_19515__$1 = state_19515;
var statearr_19553_19593 = state_19515__$1;
(statearr_19553_19593[(2)] = inst_19485);

(statearr_19553_19593[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19516 === (8))){
var inst_19459 = (state_19515[(12)]);
var inst_19458 = (state_19515[(16)]);
var inst_19461 = (inst_19459 < inst_19458);
var inst_19462 = inst_19461;
var state_19515__$1 = state_19515;
if(cljs.core.truth_(inst_19462)){
var statearr_19554_19594 = state_19515__$1;
(statearr_19554_19594[(1)] = (10));

} else {
var statearr_19555_19595 = state_19515__$1;
(statearr_19555_19595[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19567,mults,ensure_mult,p))
;
return ((function (switch__17531__auto__,c__17645__auto___19567,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_19559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19559[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_19559[(1)] = (1));

return statearr_19559;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_19515){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19515);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19560){if((e19560 instanceof Object)){
var ex__17535__auto__ = e19560;
var statearr_19561_19596 = state_19515;
(statearr_19561_19596[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19515);

return cljs.core.cst$kw$recur;
} else {
throw e19560;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19597 = state_19515;
state_19515 = G__19597;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_19515){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_19515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19567,mults,ensure_mult,p))
})();
var state__17647__auto__ = (function (){var statearr_19562 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19567);

return statearr_19562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19567,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19598 = [];
var len__7280__auto___19601 = arguments.length;
var i__7281__auto___19602 = (0);
while(true){
if((i__7281__auto___19602 < len__7280__auto___19601)){
args19598.push((arguments[i__7281__auto___19602]));

var G__19603 = (i__7281__auto___19602 + (1));
i__7281__auto___19602 = G__19603;
continue;
} else {
}
break;
}

var G__19600 = args19598.length;
switch (G__19600) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19598.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19605 = [];
var len__7280__auto___19608 = arguments.length;
var i__7281__auto___19609 = (0);
while(true){
if((i__7281__auto___19609 < len__7280__auto___19608)){
args19605.push((arguments[i__7281__auto___19609]));

var G__19610 = (i__7281__auto___19609 + (1));
i__7281__auto___19609 = G__19610;
continue;
} else {
}
break;
}

var G__19607 = args19605.length;
switch (G__19607) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19605.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19612 = [];
var len__7280__auto___19683 = arguments.length;
var i__7281__auto___19684 = (0);
while(true){
if((i__7281__auto___19684 < len__7280__auto___19683)){
args19612.push((arguments[i__7281__auto___19684]));

var G__19685 = (i__7281__auto___19684 + (1));
i__7281__auto___19684 = G__19685;
continue;
} else {
}
break;
}

var G__19614 = args19612.length;
switch (G__19614) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19612.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17645__auto___19687 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19653){
var state_val_19654 = (state_19653[(1)]);
if((state_val_19654 === (7))){
var state_19653__$1 = state_19653;
var statearr_19655_19688 = state_19653__$1;
(statearr_19655_19688[(2)] = null);

(statearr_19655_19688[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (1))){
var state_19653__$1 = state_19653;
var statearr_19656_19689 = state_19653__$1;
(statearr_19656_19689[(2)] = null);

(statearr_19656_19689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (4))){
var inst_19617 = (state_19653[(7)]);
var inst_19619 = (inst_19617 < cnt);
var state_19653__$1 = state_19653;
if(cljs.core.truth_(inst_19619)){
var statearr_19657_19690 = state_19653__$1;
(statearr_19657_19690[(1)] = (6));

} else {
var statearr_19658_19691 = state_19653__$1;
(statearr_19658_19691[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (15))){
var inst_19649 = (state_19653[(2)]);
var state_19653__$1 = state_19653;
var statearr_19659_19692 = state_19653__$1;
(statearr_19659_19692[(2)] = inst_19649);

(statearr_19659_19692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (13))){
var inst_19642 = cljs.core.async.close_BANG_(out);
var state_19653__$1 = state_19653;
var statearr_19660_19693 = state_19653__$1;
(statearr_19660_19693[(2)] = inst_19642);

(statearr_19660_19693[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (6))){
var state_19653__$1 = state_19653;
var statearr_19661_19694 = state_19653__$1;
(statearr_19661_19694[(2)] = null);

(statearr_19661_19694[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (3))){
var inst_19651 = (state_19653[(2)]);
var state_19653__$1 = state_19653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19653__$1,inst_19651);
} else {
if((state_val_19654 === (12))){
var inst_19639 = (state_19653[(8)]);
var inst_19639__$1 = (state_19653[(2)]);
var inst_19640 = cljs.core.some(cljs.core.nil_QMARK_,inst_19639__$1);
var state_19653__$1 = (function (){var statearr_19662 = state_19653;
(statearr_19662[(8)] = inst_19639__$1);

return statearr_19662;
})();
if(cljs.core.truth_(inst_19640)){
var statearr_19663_19695 = state_19653__$1;
(statearr_19663_19695[(1)] = (13));

} else {
var statearr_19664_19696 = state_19653__$1;
(statearr_19664_19696[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (2))){
var inst_19616 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_19617 = (0);
var state_19653__$1 = (function (){var statearr_19665 = state_19653;
(statearr_19665[(9)] = inst_19616);

(statearr_19665[(7)] = inst_19617);

return statearr_19665;
})();
var statearr_19666_19697 = state_19653__$1;
(statearr_19666_19697[(2)] = null);

(statearr_19666_19697[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (11))){
var inst_19617 = (state_19653[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_19653,(10),Object,null,(9));
var inst_19626 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_19617) : chs__$1.call(null,inst_19617));
var inst_19627 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_19617) : done.call(null,inst_19617));
var inst_19628 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19626,inst_19627);
var state_19653__$1 = state_19653;
var statearr_19667_19698 = state_19653__$1;
(statearr_19667_19698[(2)] = inst_19628);


cljs.core.async.impl.ioc_helpers.process_exception(state_19653__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (9))){
var inst_19617 = (state_19653[(7)]);
var inst_19630 = (state_19653[(2)]);
var inst_19631 = (inst_19617 + (1));
var inst_19617__$1 = inst_19631;
var state_19653__$1 = (function (){var statearr_19668 = state_19653;
(statearr_19668[(10)] = inst_19630);

(statearr_19668[(7)] = inst_19617__$1);

return statearr_19668;
})();
var statearr_19669_19699 = state_19653__$1;
(statearr_19669_19699[(2)] = null);

(statearr_19669_19699[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (5))){
var inst_19637 = (state_19653[(2)]);
var state_19653__$1 = (function (){var statearr_19670 = state_19653;
(statearr_19670[(11)] = inst_19637);

return statearr_19670;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19653__$1,(12),dchan);
} else {
if((state_val_19654 === (14))){
var inst_19639 = (state_19653[(8)]);
var inst_19644 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_19639);
var state_19653__$1 = state_19653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19653__$1,(16),out,inst_19644);
} else {
if((state_val_19654 === (16))){
var inst_19646 = (state_19653[(2)]);
var state_19653__$1 = (function (){var statearr_19671 = state_19653;
(statearr_19671[(12)] = inst_19646);

return statearr_19671;
})();
var statearr_19672_19700 = state_19653__$1;
(statearr_19672_19700[(2)] = null);

(statearr_19672_19700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (10))){
var inst_19621 = (state_19653[(2)]);
var inst_19622 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_19653__$1 = (function (){var statearr_19673 = state_19653;
(statearr_19673[(13)] = inst_19621);

return statearr_19673;
})();
var statearr_19674_19701 = state_19653__$1;
(statearr_19674_19701[(2)] = inst_19622);


cljs.core.async.impl.ioc_helpers.process_exception(state_19653__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19654 === (8))){
var inst_19635 = (state_19653[(2)]);
var state_19653__$1 = state_19653;
var statearr_19675_19702 = state_19653__$1;
(statearr_19675_19702[(2)] = inst_19635);

(statearr_19675_19702[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17531__auto__,c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_19679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19679[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_19679[(1)] = (1));

return statearr_19679;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_19653){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19653);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19680){if((e19680 instanceof Object)){
var ex__17535__auto__ = e19680;
var statearr_19681_19703 = state_19653;
(statearr_19681_19703[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19653);

return cljs.core.cst$kw$recur;
} else {
throw e19680;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19704 = state_19653;
state_19653 = G__19704;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_19653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_19653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__17647__auto__ = (function (){var statearr_19682 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19682[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19687);

return statearr_19682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19687,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19706 = [];
var len__7280__auto___19762 = arguments.length;
var i__7281__auto___19763 = (0);
while(true){
if((i__7281__auto___19763 < len__7280__auto___19762)){
args19706.push((arguments[i__7281__auto___19763]));

var G__19764 = (i__7281__auto___19763 + (1));
i__7281__auto___19763 = G__19764;
continue;
} else {
}
break;
}

var G__19708 = args19706.length;
switch (G__19708) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19706.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___19766 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19766,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19766,out){
return (function (state_19738){
var state_val_19739 = (state_19738[(1)]);
if((state_val_19739 === (7))){
var inst_19718 = (state_19738[(7)]);
var inst_19717 = (state_19738[(8)]);
var inst_19717__$1 = (state_19738[(2)]);
var inst_19718__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19717__$1,(0),null);
var inst_19719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19717__$1,(1),null);
var inst_19720 = (inst_19718__$1 == null);
var state_19738__$1 = (function (){var statearr_19740 = state_19738;
(statearr_19740[(7)] = inst_19718__$1);

(statearr_19740[(9)] = inst_19719);

(statearr_19740[(8)] = inst_19717__$1);

return statearr_19740;
})();
if(cljs.core.truth_(inst_19720)){
var statearr_19741_19767 = state_19738__$1;
(statearr_19741_19767[(1)] = (8));

} else {
var statearr_19742_19768 = state_19738__$1;
(statearr_19742_19768[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (1))){
var inst_19709 = cljs.core.vec(chs);
var inst_19710 = inst_19709;
var state_19738__$1 = (function (){var statearr_19743 = state_19738;
(statearr_19743[(10)] = inst_19710);

return statearr_19743;
})();
var statearr_19744_19769 = state_19738__$1;
(statearr_19744_19769[(2)] = null);

(statearr_19744_19769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (4))){
var inst_19710 = (state_19738[(10)]);
var state_19738__$1 = state_19738;
return cljs.core.async.ioc_alts_BANG_(state_19738__$1,(7),inst_19710);
} else {
if((state_val_19739 === (6))){
var inst_19734 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19745_19770 = state_19738__$1;
(statearr_19745_19770[(2)] = inst_19734);

(statearr_19745_19770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (3))){
var inst_19736 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19738__$1,inst_19736);
} else {
if((state_val_19739 === (2))){
var inst_19710 = (state_19738[(10)]);
var inst_19712 = cljs.core.count(inst_19710);
var inst_19713 = (inst_19712 > (0));
var state_19738__$1 = state_19738;
if(cljs.core.truth_(inst_19713)){
var statearr_19747_19771 = state_19738__$1;
(statearr_19747_19771[(1)] = (4));

} else {
var statearr_19748_19772 = state_19738__$1;
(statearr_19748_19772[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (11))){
var inst_19710 = (state_19738[(10)]);
var inst_19727 = (state_19738[(2)]);
var tmp19746 = inst_19710;
var inst_19710__$1 = tmp19746;
var state_19738__$1 = (function (){var statearr_19749 = state_19738;
(statearr_19749[(11)] = inst_19727);

(statearr_19749[(10)] = inst_19710__$1);

return statearr_19749;
})();
var statearr_19750_19773 = state_19738__$1;
(statearr_19750_19773[(2)] = null);

(statearr_19750_19773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (9))){
var inst_19718 = (state_19738[(7)]);
var state_19738__$1 = state_19738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19738__$1,(11),out,inst_19718);
} else {
if((state_val_19739 === (5))){
var inst_19732 = cljs.core.async.close_BANG_(out);
var state_19738__$1 = state_19738;
var statearr_19751_19774 = state_19738__$1;
(statearr_19751_19774[(2)] = inst_19732);

(statearr_19751_19774[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (10))){
var inst_19730 = (state_19738[(2)]);
var state_19738__$1 = state_19738;
var statearr_19752_19775 = state_19738__$1;
(statearr_19752_19775[(2)] = inst_19730);

(statearr_19752_19775[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19739 === (8))){
var inst_19718 = (state_19738[(7)]);
var inst_19719 = (state_19738[(9)]);
var inst_19717 = (state_19738[(8)]);
var inst_19710 = (state_19738[(10)]);
var inst_19722 = (function (){var cs = inst_19710;
var vec__19715 = inst_19717;
var v = inst_19718;
var c = inst_19719;
return ((function (cs,vec__19715,v,c,inst_19718,inst_19719,inst_19717,inst_19710,state_val_19739,c__17645__auto___19766,out){
return (function (p1__19705_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__19705_SHARP_);
});
;})(cs,vec__19715,v,c,inst_19718,inst_19719,inst_19717,inst_19710,state_val_19739,c__17645__auto___19766,out))
})();
var inst_19723 = cljs.core.filterv(inst_19722,inst_19710);
var inst_19710__$1 = inst_19723;
var state_19738__$1 = (function (){var statearr_19753 = state_19738;
(statearr_19753[(10)] = inst_19710__$1);

return statearr_19753;
})();
var statearr_19754_19776 = state_19738__$1;
(statearr_19754_19776[(2)] = null);

(statearr_19754_19776[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19766,out))
;
return ((function (switch__17531__auto__,c__17645__auto___19766,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_19758 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19758[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_19758[(1)] = (1));

return statearr_19758;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_19738){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19738);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19759){if((e19759 instanceof Object)){
var ex__17535__auto__ = e19759;
var statearr_19760_19777 = state_19738;
(statearr_19760_19777[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19738);

return cljs.core.cst$kw$recur;
} else {
throw e19759;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19778 = state_19738;
state_19738 = G__19778;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_19738){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_19738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19766,out))
})();
var state__17647__auto__ = (function (){var statearr_19761 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19766);

return statearr_19761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19766,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19779 = [];
var len__7280__auto___19828 = arguments.length;
var i__7281__auto___19829 = (0);
while(true){
if((i__7281__auto___19829 < len__7280__auto___19828)){
args19779.push((arguments[i__7281__auto___19829]));

var G__19830 = (i__7281__auto___19829 + (1));
i__7281__auto___19829 = G__19830;
continue;
} else {
}
break;
}

var G__19781 = args19779.length;
switch (G__19781) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19779.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___19832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19832,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19832,out){
return (function (state_19805){
var state_val_19806 = (state_19805[(1)]);
if((state_val_19806 === (7))){
var inst_19787 = (state_19805[(7)]);
var inst_19787__$1 = (state_19805[(2)]);
var inst_19788 = (inst_19787__$1 == null);
var inst_19789 = cljs.core.not(inst_19788);
var state_19805__$1 = (function (){var statearr_19807 = state_19805;
(statearr_19807[(7)] = inst_19787__$1);

return statearr_19807;
})();
if(inst_19789){
var statearr_19808_19833 = state_19805__$1;
(statearr_19808_19833[(1)] = (8));

} else {
var statearr_19809_19834 = state_19805__$1;
(statearr_19809_19834[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (1))){
var inst_19782 = (0);
var state_19805__$1 = (function (){var statearr_19810 = state_19805;
(statearr_19810[(8)] = inst_19782);

return statearr_19810;
})();
var statearr_19811_19835 = state_19805__$1;
(statearr_19811_19835[(2)] = null);

(statearr_19811_19835[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (4))){
var state_19805__$1 = state_19805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19805__$1,(7),ch);
} else {
if((state_val_19806 === (6))){
var inst_19800 = (state_19805[(2)]);
var state_19805__$1 = state_19805;
var statearr_19812_19836 = state_19805__$1;
(statearr_19812_19836[(2)] = inst_19800);

(statearr_19812_19836[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (3))){
var inst_19802 = (state_19805[(2)]);
var inst_19803 = cljs.core.async.close_BANG_(out);
var state_19805__$1 = (function (){var statearr_19813 = state_19805;
(statearr_19813[(9)] = inst_19802);

return statearr_19813;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19805__$1,inst_19803);
} else {
if((state_val_19806 === (2))){
var inst_19782 = (state_19805[(8)]);
var inst_19784 = (inst_19782 < n);
var state_19805__$1 = state_19805;
if(cljs.core.truth_(inst_19784)){
var statearr_19814_19837 = state_19805__$1;
(statearr_19814_19837[(1)] = (4));

} else {
var statearr_19815_19838 = state_19805__$1;
(statearr_19815_19838[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (11))){
var inst_19782 = (state_19805[(8)]);
var inst_19792 = (state_19805[(2)]);
var inst_19793 = (inst_19782 + (1));
var inst_19782__$1 = inst_19793;
var state_19805__$1 = (function (){var statearr_19816 = state_19805;
(statearr_19816[(8)] = inst_19782__$1);

(statearr_19816[(10)] = inst_19792);

return statearr_19816;
})();
var statearr_19817_19839 = state_19805__$1;
(statearr_19817_19839[(2)] = null);

(statearr_19817_19839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (9))){
var state_19805__$1 = state_19805;
var statearr_19818_19840 = state_19805__$1;
(statearr_19818_19840[(2)] = null);

(statearr_19818_19840[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (5))){
var state_19805__$1 = state_19805;
var statearr_19819_19841 = state_19805__$1;
(statearr_19819_19841[(2)] = null);

(statearr_19819_19841[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (10))){
var inst_19797 = (state_19805[(2)]);
var state_19805__$1 = state_19805;
var statearr_19820_19842 = state_19805__$1;
(statearr_19820_19842[(2)] = inst_19797);

(statearr_19820_19842[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19806 === (8))){
var inst_19787 = (state_19805[(7)]);
var state_19805__$1 = state_19805;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19805__$1,(11),out,inst_19787);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19832,out))
;
return ((function (switch__17531__auto__,c__17645__auto___19832,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_19824 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19824[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_19824[(1)] = (1));

return statearr_19824;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_19805){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19805);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19825){if((e19825 instanceof Object)){
var ex__17535__auto__ = e19825;
var statearr_19826_19843 = state_19805;
(statearr_19826_19843[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19805);

return cljs.core.cst$kw$recur;
} else {
throw e19825;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19844 = state_19805;
state_19805 = G__19844;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_19805){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_19805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19832,out))
})();
var state__17647__auto__ = (function (){var statearr_19827 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19827[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19832);

return statearr_19827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19832,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19854 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19854 = (function (map_LT_,f,ch,meta19855){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19855 = meta19855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19856,meta19855__$1){
var self__ = this;
var _19856__$1 = this;
return (new cljs.core.async.t_cljs$core$async19854(self__.map_LT_,self__.f,self__.ch,meta19855__$1));
});

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19856){
var self__ = this;
var _19856__$1 = this;
return self__.meta19855;
});

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19857 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19857 = (function (map_LT_,f,ch,meta19855,_,fn1,meta19858){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19855 = meta19855;
this._ = _;
this.fn1 = fn1;
this.meta19858 = meta19858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19859,meta19858__$1){
var self__ = this;
var _19859__$1 = this;
return (new cljs.core.async.t_cljs$core$async19857(self__.map_LT_,self__.f,self__.ch,self__.meta19855,self__._,self__.fn1,meta19858__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19859){
var self__ = this;
var _19859__$1 = this;
return self__.meta19858;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19845_SHARP_){
var G__19860 = (((p1__19845_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__19845_SHARP_) : self__.f.call(null,p1__19845_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__19860) : f1.call(null,G__19860));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19855,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async19854], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta19858], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19857.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19857.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19857";

cljs.core.async.t_cljs$core$async19857.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19857");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19857 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19857(map_LT___$1,f__$1,ch__$1,meta19855__$1,___$2,fn1__$1,meta19858){
return (new cljs.core.async.t_cljs$core$async19857(map_LT___$1,f__$1,ch__$1,meta19855__$1,___$2,fn1__$1,meta19858));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19857(self__.map_LT_,self__.f,self__.ch,self__.meta19855,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6198__auto__ = ret;
if(cljs.core.truth_(and__6198__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6198__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__19861 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__19861) : self__.f.call(null,G__19861));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19854.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19854.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19855], null);
});

cljs.core.async.t_cljs$core$async19854.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19854.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19854";

cljs.core.async.t_cljs$core$async19854.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19854");
});

cljs.core.async.__GT_t_cljs$core$async19854 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19854(map_LT___$1,f__$1,ch__$1,meta19855){
return (new cljs.core.async.t_cljs$core$async19854(map_LT___$1,f__$1,ch__$1,meta19855));
});

}

return (new cljs.core.async.t_cljs$core$async19854(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19865 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19865 = (function (map_GT_,f,ch,meta19866){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19866 = meta19866;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19867,meta19866__$1){
var self__ = this;
var _19867__$1 = this;
return (new cljs.core.async.t_cljs$core$async19865(self__.map_GT_,self__.f,self__.ch,meta19866__$1));
});

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19867){
var self__ = this;
var _19867__$1 = this;
return self__.meta19866;
});

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19865.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async19865.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19866], null);
});

cljs.core.async.t_cljs$core$async19865.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19865.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19865";

cljs.core.async.t_cljs$core$async19865.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19865");
});

cljs.core.async.__GT_t_cljs$core$async19865 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19865(map_GT___$1,f__$1,ch__$1,meta19866){
return (new cljs.core.async.t_cljs$core$async19865(map_GT___$1,f__$1,ch__$1,meta19866));
});

}

return (new cljs.core.async.t_cljs$core$async19865(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19871 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19871 = (function (filter_GT_,p,ch,meta19872){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19872 = meta19872;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19873,meta19872__$1){
var self__ = this;
var _19873__$1 = this;
return (new cljs.core.async.t_cljs$core$async19871(self__.filter_GT_,self__.p,self__.ch,meta19872__$1));
});

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19873){
var self__ = this;
var _19873__$1 = this;
return self__.meta19872;
});

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19871.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19871.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta19872], null);
});

cljs.core.async.t_cljs$core$async19871.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19871.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19871";

cljs.core.async.t_cljs$core$async19871.cljs$lang$ctorPrWriter = (function (this__6816__auto__,writer__6817__auto__,opt__6818__auto__){
return cljs.core._write(writer__6817__auto__,"cljs.core.async/t_cljs$core$async19871");
});

cljs.core.async.__GT_t_cljs$core$async19871 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19871(filter_GT___$1,p__$1,ch__$1,meta19872){
return (new cljs.core.async.t_cljs$core$async19871(filter_GT___$1,p__$1,ch__$1,meta19872));
});

}

return (new cljs.core.async.t_cljs$core$async19871(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19874 = [];
var len__7280__auto___19918 = arguments.length;
var i__7281__auto___19919 = (0);
while(true){
if((i__7281__auto___19919 < len__7280__auto___19918)){
args19874.push((arguments[i__7281__auto___19919]));

var G__19920 = (i__7281__auto___19919 + (1));
i__7281__auto___19919 = G__19920;
continue;
} else {
}
break;
}

var G__19876 = args19874.length;
switch (G__19876) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19874.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___19922 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___19922,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___19922,out){
return (function (state_19897){
var state_val_19898 = (state_19897[(1)]);
if((state_val_19898 === (7))){
var inst_19893 = (state_19897[(2)]);
var state_19897__$1 = state_19897;
var statearr_19899_19923 = state_19897__$1;
(statearr_19899_19923[(2)] = inst_19893);

(statearr_19899_19923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (1))){
var state_19897__$1 = state_19897;
var statearr_19900_19924 = state_19897__$1;
(statearr_19900_19924[(2)] = null);

(statearr_19900_19924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (4))){
var inst_19879 = (state_19897[(7)]);
var inst_19879__$1 = (state_19897[(2)]);
var inst_19880 = (inst_19879__$1 == null);
var state_19897__$1 = (function (){var statearr_19901 = state_19897;
(statearr_19901[(7)] = inst_19879__$1);

return statearr_19901;
})();
if(cljs.core.truth_(inst_19880)){
var statearr_19902_19925 = state_19897__$1;
(statearr_19902_19925[(1)] = (5));

} else {
var statearr_19903_19926 = state_19897__$1;
(statearr_19903_19926[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (6))){
var inst_19879 = (state_19897[(7)]);
var inst_19884 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_19879) : p.call(null,inst_19879));
var state_19897__$1 = state_19897;
if(cljs.core.truth_(inst_19884)){
var statearr_19904_19927 = state_19897__$1;
(statearr_19904_19927[(1)] = (8));

} else {
var statearr_19905_19928 = state_19897__$1;
(statearr_19905_19928[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (3))){
var inst_19895 = (state_19897[(2)]);
var state_19897__$1 = state_19897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19897__$1,inst_19895);
} else {
if((state_val_19898 === (2))){
var state_19897__$1 = state_19897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19897__$1,(4),ch);
} else {
if((state_val_19898 === (11))){
var inst_19887 = (state_19897[(2)]);
var state_19897__$1 = state_19897;
var statearr_19906_19929 = state_19897__$1;
(statearr_19906_19929[(2)] = inst_19887);

(statearr_19906_19929[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (9))){
var state_19897__$1 = state_19897;
var statearr_19907_19930 = state_19897__$1;
(statearr_19907_19930[(2)] = null);

(statearr_19907_19930[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (5))){
var inst_19882 = cljs.core.async.close_BANG_(out);
var state_19897__$1 = state_19897;
var statearr_19908_19931 = state_19897__$1;
(statearr_19908_19931[(2)] = inst_19882);

(statearr_19908_19931[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (10))){
var inst_19890 = (state_19897[(2)]);
var state_19897__$1 = (function (){var statearr_19909 = state_19897;
(statearr_19909[(8)] = inst_19890);

return statearr_19909;
})();
var statearr_19910_19932 = state_19897__$1;
(statearr_19910_19932[(2)] = null);

(statearr_19910_19932[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19898 === (8))){
var inst_19879 = (state_19897[(7)]);
var state_19897__$1 = state_19897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19897__$1,(11),out,inst_19879);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___19922,out))
;
return ((function (switch__17531__auto__,c__17645__auto___19922,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_19914 = [null,null,null,null,null,null,null,null,null];
(statearr_19914[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_19914[(1)] = (1));

return statearr_19914;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_19897){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_19897);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e19915){if((e19915 instanceof Object)){
var ex__17535__auto__ = e19915;
var statearr_19916_19933 = state_19897;
(statearr_19916_19933[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19897);

return cljs.core.cst$kw$recur;
} else {
throw e19915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__19934 = state_19897;
state_19897 = G__19934;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_19897){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_19897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___19922,out))
})();
var state__17647__auto__ = (function (){var statearr_19917 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_19917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___19922);

return statearr_19917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___19922,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19935 = [];
var len__7280__auto___19938 = arguments.length;
var i__7281__auto___19939 = (0);
while(true){
if((i__7281__auto___19939 < len__7280__auto___19938)){
args19935.push((arguments[i__7281__auto___19939]));

var G__19940 = (i__7281__auto___19939 + (1));
i__7281__auto___19939 = G__19940;
continue;
} else {
}
break;
}

var G__19937 = args19935.length;
switch (G__19937) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19935.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17645__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto__){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto__){
return (function (state_20107){
var state_val_20108 = (state_20107[(1)]);
if((state_val_20108 === (7))){
var inst_20103 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
var statearr_20109_20150 = state_20107__$1;
(statearr_20109_20150[(2)] = inst_20103);

(statearr_20109_20150[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (20))){
var inst_20073 = (state_20107[(7)]);
var inst_20084 = (state_20107[(2)]);
var inst_20085 = cljs.core.next(inst_20073);
var inst_20059 = inst_20085;
var inst_20060 = null;
var inst_20061 = (0);
var inst_20062 = (0);
var state_20107__$1 = (function (){var statearr_20110 = state_20107;
(statearr_20110[(8)] = inst_20060);

(statearr_20110[(9)] = inst_20062);

(statearr_20110[(10)] = inst_20061);

(statearr_20110[(11)] = inst_20059);

(statearr_20110[(12)] = inst_20084);

return statearr_20110;
})();
var statearr_20111_20151 = state_20107__$1;
(statearr_20111_20151[(2)] = null);

(statearr_20111_20151[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (1))){
var state_20107__$1 = state_20107;
var statearr_20112_20152 = state_20107__$1;
(statearr_20112_20152[(2)] = null);

(statearr_20112_20152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (4))){
var inst_20048 = (state_20107[(13)]);
var inst_20048__$1 = (state_20107[(2)]);
var inst_20049 = (inst_20048__$1 == null);
var state_20107__$1 = (function (){var statearr_20113 = state_20107;
(statearr_20113[(13)] = inst_20048__$1);

return statearr_20113;
})();
if(cljs.core.truth_(inst_20049)){
var statearr_20114_20153 = state_20107__$1;
(statearr_20114_20153[(1)] = (5));

} else {
var statearr_20115_20154 = state_20107__$1;
(statearr_20115_20154[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (15))){
var state_20107__$1 = state_20107;
var statearr_20119_20155 = state_20107__$1;
(statearr_20119_20155[(2)] = null);

(statearr_20119_20155[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (21))){
var state_20107__$1 = state_20107;
var statearr_20120_20156 = state_20107__$1;
(statearr_20120_20156[(2)] = null);

(statearr_20120_20156[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (13))){
var inst_20060 = (state_20107[(8)]);
var inst_20062 = (state_20107[(9)]);
var inst_20061 = (state_20107[(10)]);
var inst_20059 = (state_20107[(11)]);
var inst_20069 = (state_20107[(2)]);
var inst_20070 = (inst_20062 + (1));
var tmp20116 = inst_20060;
var tmp20117 = inst_20061;
var tmp20118 = inst_20059;
var inst_20059__$1 = tmp20118;
var inst_20060__$1 = tmp20116;
var inst_20061__$1 = tmp20117;
var inst_20062__$1 = inst_20070;
var state_20107__$1 = (function (){var statearr_20121 = state_20107;
(statearr_20121[(8)] = inst_20060__$1);

(statearr_20121[(9)] = inst_20062__$1);

(statearr_20121[(10)] = inst_20061__$1);

(statearr_20121[(14)] = inst_20069);

(statearr_20121[(11)] = inst_20059__$1);

return statearr_20121;
})();
var statearr_20122_20157 = state_20107__$1;
(statearr_20122_20157[(2)] = null);

(statearr_20122_20157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (22))){
var state_20107__$1 = state_20107;
var statearr_20123_20158 = state_20107__$1;
(statearr_20123_20158[(2)] = null);

(statearr_20123_20158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (6))){
var inst_20048 = (state_20107[(13)]);
var inst_20057 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20048) : f.call(null,inst_20048));
var inst_20058 = cljs.core.seq(inst_20057);
var inst_20059 = inst_20058;
var inst_20060 = null;
var inst_20061 = (0);
var inst_20062 = (0);
var state_20107__$1 = (function (){var statearr_20124 = state_20107;
(statearr_20124[(8)] = inst_20060);

(statearr_20124[(9)] = inst_20062);

(statearr_20124[(10)] = inst_20061);

(statearr_20124[(11)] = inst_20059);

return statearr_20124;
})();
var statearr_20125_20159 = state_20107__$1;
(statearr_20125_20159[(2)] = null);

(statearr_20125_20159[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (17))){
var inst_20073 = (state_20107[(7)]);
var inst_20077 = cljs.core.chunk_first(inst_20073);
var inst_20078 = cljs.core.chunk_rest(inst_20073);
var inst_20079 = cljs.core.count(inst_20077);
var inst_20059 = inst_20078;
var inst_20060 = inst_20077;
var inst_20061 = inst_20079;
var inst_20062 = (0);
var state_20107__$1 = (function (){var statearr_20126 = state_20107;
(statearr_20126[(8)] = inst_20060);

(statearr_20126[(9)] = inst_20062);

(statearr_20126[(10)] = inst_20061);

(statearr_20126[(11)] = inst_20059);

return statearr_20126;
})();
var statearr_20127_20160 = state_20107__$1;
(statearr_20127_20160[(2)] = null);

(statearr_20127_20160[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (3))){
var inst_20105 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20107__$1,inst_20105);
} else {
if((state_val_20108 === (12))){
var inst_20093 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
var statearr_20128_20161 = state_20107__$1;
(statearr_20128_20161[(2)] = inst_20093);

(statearr_20128_20161[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (2))){
var state_20107__$1 = state_20107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20107__$1,(4),in$);
} else {
if((state_val_20108 === (23))){
var inst_20101 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
var statearr_20129_20162 = state_20107__$1;
(statearr_20129_20162[(2)] = inst_20101);

(statearr_20129_20162[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (19))){
var inst_20088 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
var statearr_20130_20163 = state_20107__$1;
(statearr_20130_20163[(2)] = inst_20088);

(statearr_20130_20163[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (11))){
var inst_20073 = (state_20107[(7)]);
var inst_20059 = (state_20107[(11)]);
var inst_20073__$1 = cljs.core.seq(inst_20059);
var state_20107__$1 = (function (){var statearr_20131 = state_20107;
(statearr_20131[(7)] = inst_20073__$1);

return statearr_20131;
})();
if(inst_20073__$1){
var statearr_20132_20164 = state_20107__$1;
(statearr_20132_20164[(1)] = (14));

} else {
var statearr_20133_20165 = state_20107__$1;
(statearr_20133_20165[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (9))){
var inst_20095 = (state_20107[(2)]);
var inst_20096 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_20107__$1 = (function (){var statearr_20134 = state_20107;
(statearr_20134[(15)] = inst_20095);

return statearr_20134;
})();
if(cljs.core.truth_(inst_20096)){
var statearr_20135_20166 = state_20107__$1;
(statearr_20135_20166[(1)] = (21));

} else {
var statearr_20136_20167 = state_20107__$1;
(statearr_20136_20167[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (5))){
var inst_20051 = cljs.core.async.close_BANG_(out);
var state_20107__$1 = state_20107;
var statearr_20137_20168 = state_20107__$1;
(statearr_20137_20168[(2)] = inst_20051);

(statearr_20137_20168[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (14))){
var inst_20073 = (state_20107[(7)]);
var inst_20075 = cljs.core.chunked_seq_QMARK_(inst_20073);
var state_20107__$1 = state_20107;
if(inst_20075){
var statearr_20138_20169 = state_20107__$1;
(statearr_20138_20169[(1)] = (17));

} else {
var statearr_20139_20170 = state_20107__$1;
(statearr_20139_20170[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (16))){
var inst_20091 = (state_20107[(2)]);
var state_20107__$1 = state_20107;
var statearr_20140_20171 = state_20107__$1;
(statearr_20140_20171[(2)] = inst_20091);

(statearr_20140_20171[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20108 === (10))){
var inst_20060 = (state_20107[(8)]);
var inst_20062 = (state_20107[(9)]);
var inst_20067 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_20060,inst_20062);
var state_20107__$1 = state_20107;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20107__$1,(13),out,inst_20067);
} else {
if((state_val_20108 === (18))){
var inst_20073 = (state_20107[(7)]);
var inst_20082 = cljs.core.first(inst_20073);
var state_20107__$1 = state_20107;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20107__$1,(20),out,inst_20082);
} else {
if((state_val_20108 === (8))){
var inst_20062 = (state_20107[(9)]);
var inst_20061 = (state_20107[(10)]);
var inst_20064 = (inst_20062 < inst_20061);
var inst_20065 = inst_20064;
var state_20107__$1 = state_20107;
if(cljs.core.truth_(inst_20065)){
var statearr_20141_20172 = state_20107__$1;
(statearr_20141_20172[(1)] = (10));

} else {
var statearr_20142_20173 = state_20107__$1;
(statearr_20142_20173[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto__))
;
return ((function (switch__17531__auto__,c__17645__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____0 = (function (){
var statearr_20146 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20146[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__);

(statearr_20146[(1)] = (1));

return statearr_20146;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____1 = (function (state_20107){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20107);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20147){if((e20147 instanceof Object)){
var ex__17535__auto__ = e20147;
var statearr_20148_20174 = state_20107;
(statearr_20148_20174[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20107);

return cljs.core.cst$kw$recur;
} else {
throw e20147;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20175 = state_20107;
state_20107 = G__20175;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__ = function(state_20107){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____1.call(this,state_20107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17532__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto__))
})();
var state__17647__auto__ = (function (){var statearr_20149 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20149[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto__);

return statearr_20149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto__))
);

return c__17645__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20176 = [];
var len__7280__auto___20179 = arguments.length;
var i__7281__auto___20180 = (0);
while(true){
if((i__7281__auto___20180 < len__7280__auto___20179)){
args20176.push((arguments[i__7281__auto___20180]));

var G__20181 = (i__7281__auto___20180 + (1));
i__7281__auto___20180 = G__20181;
continue;
} else {
}
break;
}

var G__20178 = args20176.length;
switch (G__20178) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20176.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20183 = [];
var len__7280__auto___20186 = arguments.length;
var i__7281__auto___20187 = (0);
while(true){
if((i__7281__auto___20187 < len__7280__auto___20186)){
args20183.push((arguments[i__7281__auto___20187]));

var G__20188 = (i__7281__auto___20187 + (1));
i__7281__auto___20187 = G__20188;
continue;
} else {
}
break;
}

var G__20185 = args20183.length;
switch (G__20185) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20183.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20190 = [];
var len__7280__auto___20241 = arguments.length;
var i__7281__auto___20242 = (0);
while(true){
if((i__7281__auto___20242 < len__7280__auto___20241)){
args20190.push((arguments[i__7281__auto___20242]));

var G__20243 = (i__7281__auto___20242 + (1));
i__7281__auto___20242 = G__20243;
continue;
} else {
}
break;
}

var G__20192 = args20190.length;
switch (G__20192) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20190.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___20245 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___20245,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___20245,out){
return (function (state_20216){
var state_val_20217 = (state_20216[(1)]);
if((state_val_20217 === (7))){
var inst_20211 = (state_20216[(2)]);
var state_20216__$1 = state_20216;
var statearr_20218_20246 = state_20216__$1;
(statearr_20218_20246[(2)] = inst_20211);

(statearr_20218_20246[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (1))){
var inst_20193 = null;
var state_20216__$1 = (function (){var statearr_20219 = state_20216;
(statearr_20219[(7)] = inst_20193);

return statearr_20219;
})();
var statearr_20220_20247 = state_20216__$1;
(statearr_20220_20247[(2)] = null);

(statearr_20220_20247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (4))){
var inst_20196 = (state_20216[(8)]);
var inst_20196__$1 = (state_20216[(2)]);
var inst_20197 = (inst_20196__$1 == null);
var inst_20198 = cljs.core.not(inst_20197);
var state_20216__$1 = (function (){var statearr_20221 = state_20216;
(statearr_20221[(8)] = inst_20196__$1);

return statearr_20221;
})();
if(inst_20198){
var statearr_20222_20248 = state_20216__$1;
(statearr_20222_20248[(1)] = (5));

} else {
var statearr_20223_20249 = state_20216__$1;
(statearr_20223_20249[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (6))){
var state_20216__$1 = state_20216;
var statearr_20224_20250 = state_20216__$1;
(statearr_20224_20250[(2)] = null);

(statearr_20224_20250[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (3))){
var inst_20213 = (state_20216[(2)]);
var inst_20214 = cljs.core.async.close_BANG_(out);
var state_20216__$1 = (function (){var statearr_20225 = state_20216;
(statearr_20225[(9)] = inst_20213);

return statearr_20225;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20216__$1,inst_20214);
} else {
if((state_val_20217 === (2))){
var state_20216__$1 = state_20216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20216__$1,(4),ch);
} else {
if((state_val_20217 === (11))){
var inst_20196 = (state_20216[(8)]);
var inst_20205 = (state_20216[(2)]);
var inst_20193 = inst_20196;
var state_20216__$1 = (function (){var statearr_20226 = state_20216;
(statearr_20226[(7)] = inst_20193);

(statearr_20226[(10)] = inst_20205);

return statearr_20226;
})();
var statearr_20227_20251 = state_20216__$1;
(statearr_20227_20251[(2)] = null);

(statearr_20227_20251[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (9))){
var inst_20196 = (state_20216[(8)]);
var state_20216__$1 = state_20216;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20216__$1,(11),out,inst_20196);
} else {
if((state_val_20217 === (5))){
var inst_20193 = (state_20216[(7)]);
var inst_20196 = (state_20216[(8)]);
var inst_20200 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20196,inst_20193);
var state_20216__$1 = state_20216;
if(inst_20200){
var statearr_20229_20252 = state_20216__$1;
(statearr_20229_20252[(1)] = (8));

} else {
var statearr_20230_20253 = state_20216__$1;
(statearr_20230_20253[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (10))){
var inst_20208 = (state_20216[(2)]);
var state_20216__$1 = state_20216;
var statearr_20231_20254 = state_20216__$1;
(statearr_20231_20254[(2)] = inst_20208);

(statearr_20231_20254[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20217 === (8))){
var inst_20193 = (state_20216[(7)]);
var tmp20228 = inst_20193;
var inst_20193__$1 = tmp20228;
var state_20216__$1 = (function (){var statearr_20232 = state_20216;
(statearr_20232[(7)] = inst_20193__$1);

return statearr_20232;
})();
var statearr_20233_20255 = state_20216__$1;
(statearr_20233_20255[(2)] = null);

(statearr_20233_20255[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___20245,out))
;
return ((function (switch__17531__auto__,c__17645__auto___20245,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_20237 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20237[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_20237[(1)] = (1));

return statearr_20237;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_20216){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20216);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20238){if((e20238 instanceof Object)){
var ex__17535__auto__ = e20238;
var statearr_20239_20256 = state_20216;
(statearr_20239_20256[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20216);

return cljs.core.cst$kw$recur;
} else {
throw e20238;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20257 = state_20216;
state_20216 = G__20257;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_20216){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_20216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___20245,out))
})();
var state__17647__auto__ = (function (){var statearr_20240 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20240[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___20245);

return statearr_20240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___20245,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20258 = [];
var len__7280__auto___20328 = arguments.length;
var i__7281__auto___20329 = (0);
while(true){
if((i__7281__auto___20329 < len__7280__auto___20328)){
args20258.push((arguments[i__7281__auto___20329]));

var G__20330 = (i__7281__auto___20329 + (1));
i__7281__auto___20329 = G__20330;
continue;
} else {
}
break;
}

var G__20260 = args20258.length;
switch (G__20260) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20258.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___20332 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___20332,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___20332,out){
return (function (state_20298){
var state_val_20299 = (state_20298[(1)]);
if((state_val_20299 === (7))){
var inst_20294 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
var statearr_20300_20333 = state_20298__$1;
(statearr_20300_20333[(2)] = inst_20294);

(statearr_20300_20333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (1))){
var inst_20261 = (new Array(n));
var inst_20262 = inst_20261;
var inst_20263 = (0);
var state_20298__$1 = (function (){var statearr_20301 = state_20298;
(statearr_20301[(7)] = inst_20263);

(statearr_20301[(8)] = inst_20262);

return statearr_20301;
})();
var statearr_20302_20334 = state_20298__$1;
(statearr_20302_20334[(2)] = null);

(statearr_20302_20334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (4))){
var inst_20266 = (state_20298[(9)]);
var inst_20266__$1 = (state_20298[(2)]);
var inst_20267 = (inst_20266__$1 == null);
var inst_20268 = cljs.core.not(inst_20267);
var state_20298__$1 = (function (){var statearr_20303 = state_20298;
(statearr_20303[(9)] = inst_20266__$1);

return statearr_20303;
})();
if(inst_20268){
var statearr_20304_20335 = state_20298__$1;
(statearr_20304_20335[(1)] = (5));

} else {
var statearr_20305_20336 = state_20298__$1;
(statearr_20305_20336[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (15))){
var inst_20288 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
var statearr_20306_20337 = state_20298__$1;
(statearr_20306_20337[(2)] = inst_20288);

(statearr_20306_20337[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (13))){
var state_20298__$1 = state_20298;
var statearr_20307_20338 = state_20298__$1;
(statearr_20307_20338[(2)] = null);

(statearr_20307_20338[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (6))){
var inst_20263 = (state_20298[(7)]);
var inst_20284 = (inst_20263 > (0));
var state_20298__$1 = state_20298;
if(cljs.core.truth_(inst_20284)){
var statearr_20308_20339 = state_20298__$1;
(statearr_20308_20339[(1)] = (12));

} else {
var statearr_20309_20340 = state_20298__$1;
(statearr_20309_20340[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (3))){
var inst_20296 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20298__$1,inst_20296);
} else {
if((state_val_20299 === (12))){
var inst_20262 = (state_20298[(8)]);
var inst_20286 = cljs.core.vec(inst_20262);
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20298__$1,(15),out,inst_20286);
} else {
if((state_val_20299 === (2))){
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20298__$1,(4),ch);
} else {
if((state_val_20299 === (11))){
var inst_20278 = (state_20298[(2)]);
var inst_20279 = (new Array(n));
var inst_20262 = inst_20279;
var inst_20263 = (0);
var state_20298__$1 = (function (){var statearr_20310 = state_20298;
(statearr_20310[(7)] = inst_20263);

(statearr_20310[(8)] = inst_20262);

(statearr_20310[(10)] = inst_20278);

return statearr_20310;
})();
var statearr_20311_20341 = state_20298__$1;
(statearr_20311_20341[(2)] = null);

(statearr_20311_20341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (9))){
var inst_20262 = (state_20298[(8)]);
var inst_20276 = cljs.core.vec(inst_20262);
var state_20298__$1 = state_20298;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20298__$1,(11),out,inst_20276);
} else {
if((state_val_20299 === (5))){
var inst_20263 = (state_20298[(7)]);
var inst_20262 = (state_20298[(8)]);
var inst_20271 = (state_20298[(11)]);
var inst_20266 = (state_20298[(9)]);
var inst_20270 = (inst_20262[inst_20263] = inst_20266);
var inst_20271__$1 = (inst_20263 + (1));
var inst_20272 = (inst_20271__$1 < n);
var state_20298__$1 = (function (){var statearr_20312 = state_20298;
(statearr_20312[(11)] = inst_20271__$1);

(statearr_20312[(12)] = inst_20270);

return statearr_20312;
})();
if(cljs.core.truth_(inst_20272)){
var statearr_20313_20342 = state_20298__$1;
(statearr_20313_20342[(1)] = (8));

} else {
var statearr_20314_20343 = state_20298__$1;
(statearr_20314_20343[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (14))){
var inst_20291 = (state_20298[(2)]);
var inst_20292 = cljs.core.async.close_BANG_(out);
var state_20298__$1 = (function (){var statearr_20316 = state_20298;
(statearr_20316[(13)] = inst_20291);

return statearr_20316;
})();
var statearr_20317_20344 = state_20298__$1;
(statearr_20317_20344[(2)] = inst_20292);

(statearr_20317_20344[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (10))){
var inst_20282 = (state_20298[(2)]);
var state_20298__$1 = state_20298;
var statearr_20318_20345 = state_20298__$1;
(statearr_20318_20345[(2)] = inst_20282);

(statearr_20318_20345[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20299 === (8))){
var inst_20262 = (state_20298[(8)]);
var inst_20271 = (state_20298[(11)]);
var tmp20315 = inst_20262;
var inst_20262__$1 = tmp20315;
var inst_20263 = inst_20271;
var state_20298__$1 = (function (){var statearr_20319 = state_20298;
(statearr_20319[(7)] = inst_20263);

(statearr_20319[(8)] = inst_20262__$1);

return statearr_20319;
})();
var statearr_20320_20346 = state_20298__$1;
(statearr_20320_20346[(2)] = null);

(statearr_20320_20346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___20332,out))
;
return ((function (switch__17531__auto__,c__17645__auto___20332,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_20324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20324[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_20324[(1)] = (1));

return statearr_20324;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_20298){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20298);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20325){if((e20325 instanceof Object)){
var ex__17535__auto__ = e20325;
var statearr_20326_20347 = state_20298;
(statearr_20326_20347[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20298);

return cljs.core.cst$kw$recur;
} else {
throw e20325;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20348 = state_20298;
state_20298 = G__20348;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_20298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_20298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___20332,out))
})();
var state__17647__auto__ = (function (){var statearr_20327 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___20332);

return statearr_20327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___20332,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20349 = [];
var len__7280__auto___20423 = arguments.length;
var i__7281__auto___20424 = (0);
while(true){
if((i__7281__auto___20424 < len__7280__auto___20423)){
args20349.push((arguments[i__7281__auto___20424]));

var G__20425 = (i__7281__auto___20424 + (1));
i__7281__auto___20424 = G__20425;
continue;
} else {
}
break;
}

var G__20351 = args20349.length;
switch (G__20351) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20349.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17645__auto___20427 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___20427,out){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___20427,out){
return (function (state_20393){
var state_val_20394 = (state_20393[(1)]);
if((state_val_20394 === (7))){
var inst_20389 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
var statearr_20395_20428 = state_20393__$1;
(statearr_20395_20428[(2)] = inst_20389);

(statearr_20395_20428[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (1))){
var inst_20352 = [];
var inst_20353 = inst_20352;
var inst_20354 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_20393__$1 = (function (){var statearr_20396 = state_20393;
(statearr_20396[(7)] = inst_20354);

(statearr_20396[(8)] = inst_20353);

return statearr_20396;
})();
var statearr_20397_20429 = state_20393__$1;
(statearr_20397_20429[(2)] = null);

(statearr_20397_20429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (4))){
var inst_20357 = (state_20393[(9)]);
var inst_20357__$1 = (state_20393[(2)]);
var inst_20358 = (inst_20357__$1 == null);
var inst_20359 = cljs.core.not(inst_20358);
var state_20393__$1 = (function (){var statearr_20398 = state_20393;
(statearr_20398[(9)] = inst_20357__$1);

return statearr_20398;
})();
if(inst_20359){
var statearr_20399_20430 = state_20393__$1;
(statearr_20399_20430[(1)] = (5));

} else {
var statearr_20400_20431 = state_20393__$1;
(statearr_20400_20431[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (15))){
var inst_20383 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
var statearr_20401_20432 = state_20393__$1;
(statearr_20401_20432[(2)] = inst_20383);

(statearr_20401_20432[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (13))){
var state_20393__$1 = state_20393;
var statearr_20402_20433 = state_20393__$1;
(statearr_20402_20433[(2)] = null);

(statearr_20402_20433[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (6))){
var inst_20353 = (state_20393[(8)]);
var inst_20378 = inst_20353.length;
var inst_20379 = (inst_20378 > (0));
var state_20393__$1 = state_20393;
if(cljs.core.truth_(inst_20379)){
var statearr_20403_20434 = state_20393__$1;
(statearr_20403_20434[(1)] = (12));

} else {
var statearr_20404_20435 = state_20393__$1;
(statearr_20404_20435[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (3))){
var inst_20391 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20393__$1,inst_20391);
} else {
if((state_val_20394 === (12))){
var inst_20353 = (state_20393[(8)]);
var inst_20381 = cljs.core.vec(inst_20353);
var state_20393__$1 = state_20393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20393__$1,(15),out,inst_20381);
} else {
if((state_val_20394 === (2))){
var state_20393__$1 = state_20393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20393__$1,(4),ch);
} else {
if((state_val_20394 === (11))){
var inst_20357 = (state_20393[(9)]);
var inst_20361 = (state_20393[(10)]);
var inst_20371 = (state_20393[(2)]);
var inst_20372 = [];
var inst_20373 = inst_20372.push(inst_20357);
var inst_20353 = inst_20372;
var inst_20354 = inst_20361;
var state_20393__$1 = (function (){var statearr_20405 = state_20393;
(statearr_20405[(7)] = inst_20354);

(statearr_20405[(11)] = inst_20373);

(statearr_20405[(12)] = inst_20371);

(statearr_20405[(8)] = inst_20353);

return statearr_20405;
})();
var statearr_20406_20436 = state_20393__$1;
(statearr_20406_20436[(2)] = null);

(statearr_20406_20436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (9))){
var inst_20353 = (state_20393[(8)]);
var inst_20369 = cljs.core.vec(inst_20353);
var state_20393__$1 = state_20393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20393__$1,(11),out,inst_20369);
} else {
if((state_val_20394 === (5))){
var inst_20354 = (state_20393[(7)]);
var inst_20357 = (state_20393[(9)]);
var inst_20361 = (state_20393[(10)]);
var inst_20361__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20357) : f.call(null,inst_20357));
var inst_20362 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20361__$1,inst_20354);
var inst_20363 = cljs.core.keyword_identical_QMARK_(inst_20354,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_20364 = (inst_20362) || (inst_20363);
var state_20393__$1 = (function (){var statearr_20407 = state_20393;
(statearr_20407[(10)] = inst_20361__$1);

return statearr_20407;
})();
if(cljs.core.truth_(inst_20364)){
var statearr_20408_20437 = state_20393__$1;
(statearr_20408_20437[(1)] = (8));

} else {
var statearr_20409_20438 = state_20393__$1;
(statearr_20409_20438[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (14))){
var inst_20386 = (state_20393[(2)]);
var inst_20387 = cljs.core.async.close_BANG_(out);
var state_20393__$1 = (function (){var statearr_20411 = state_20393;
(statearr_20411[(13)] = inst_20386);

return statearr_20411;
})();
var statearr_20412_20439 = state_20393__$1;
(statearr_20412_20439[(2)] = inst_20387);

(statearr_20412_20439[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (10))){
var inst_20376 = (state_20393[(2)]);
var state_20393__$1 = state_20393;
var statearr_20413_20440 = state_20393__$1;
(statearr_20413_20440[(2)] = inst_20376);

(statearr_20413_20440[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20394 === (8))){
var inst_20357 = (state_20393[(9)]);
var inst_20353 = (state_20393[(8)]);
var inst_20361 = (state_20393[(10)]);
var inst_20366 = inst_20353.push(inst_20357);
var tmp20410 = inst_20353;
var inst_20353__$1 = tmp20410;
var inst_20354 = inst_20361;
var state_20393__$1 = (function (){var statearr_20414 = state_20393;
(statearr_20414[(14)] = inst_20366);

(statearr_20414[(7)] = inst_20354);

(statearr_20414[(8)] = inst_20353__$1);

return statearr_20414;
})();
var statearr_20415_20441 = state_20393__$1;
(statearr_20415_20441[(2)] = null);

(statearr_20415_20441[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___20427,out))
;
return ((function (switch__17531__auto__,c__17645__auto___20427,out){
return (function() {
var cljs$core$async$state_machine__17532__auto__ = null;
var cljs$core$async$state_machine__17532__auto____0 = (function (){
var statearr_20419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20419[(0)] = cljs$core$async$state_machine__17532__auto__);

(statearr_20419[(1)] = (1));

return statearr_20419;
});
var cljs$core$async$state_machine__17532__auto____1 = (function (state_20393){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20393);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e20420){if((e20420 instanceof Object)){
var ex__17535__auto__ = e20420;
var statearr_20421_20442 = state_20393;
(statearr_20421_20442[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20393);

return cljs.core.cst$kw$recur;
} else {
throw e20420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__20443 = state_20393;
state_20393 = G__20443;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
cljs$core$async$state_machine__17532__auto__ = function(state_20393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17532__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17532__auto____1.call(this,state_20393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17532__auto____0;
cljs$core$async$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17532__auto____1;
return cljs$core$async$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___20427,out))
})();
var state__17647__auto__ = (function (){var statearr_20422 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_20422[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___20427);

return statearr_20422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___20427,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
