// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.async_export.export_async_url = "export_async.json?format=";
/**
 * Handles API server's response and acts according to given
 * callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__28163,p__28164){
var map__28171 = p__28163;
var map__28171__$1 = ((((!((map__28171 == null)))?((((map__28171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28171):map__28171);
var response = map__28171__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28171__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28171__$1,cljs.core.constant$keyword$body);
var map__28172 = p__28164;
var map__28172__$1 = ((((!((map__28172 == null)))?((((map__28172.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28172.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28172):map__28172);
var callbacks = map__28172__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28172__$1,cljs.core.constant$keyword$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28172__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28172__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28172__$1,cljs.core.constant$keyword$on_DASH_stop,cljs.core.constantly(null));
var map__28175 = body;
var map__28175__$1 = ((((!((map__28175 == null)))?((((map__28175.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28175.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28175):map__28175);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28175__$1,cljs.core.constant$keyword$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28175__$1,cljs.core.constant$keyword$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28175__$1,cljs.core.constant$keyword$job_uuid);
var error_detail = (function (){var or__7940__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__7940__auto__)){
return or__7940__auto__;
} else {
return cljs.core.constant$keyword$error.cljs$core$IFn$_invoke$arity$1(body);
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if((status >= (400))){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 * `millis` is the number of milliseconds after which to poll again.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(){
var args__8986__auto__ = [];
var len__8979__auto___28235 = arguments.length;
var i__8980__auto___28236 = (0);
while(true){
if((i__8980__auto___28236 < len__8979__auto___28235)){
args__8986__auto__.push((arguments[i__8980__auto___28236]));

var G__28237 = (i__8980__auto___28236 + (1));
i__8980__auto___28236 = G__28237;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((2) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8987__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__28180){
var vec__28181 = p__28180;
var map__28182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28181,(0),null);
var map__28182__$1 = ((((!((map__28182 == null)))?((((map__28182.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28182.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28182):map__28182);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28182__$1,cljs.core.constant$keyword$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28182__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28182__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28182__$1,cljs.core.constant$keyword$millis);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__11629__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
var f__11630__auto__ = (function (){var switch__11564__auto__ = ((function (c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (state_28212){
var state_val_28213 = (state_28212[(1)]);
if((state_val_28213 === (7))){
var state_28212__$1 = state_28212;
var statearr_28214_28238 = state_28212__$1;
(statearr_28214_28238[(2)] = "dataviews");

(statearr_28214_28238[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (1))){
var state_28212__$1 = state_28212;
var statearr_28215_28239 = state_28212__$1;
(statearr_28215_28239[(2)] = null);

(statearr_28215_28239[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (4))){
var inst_28188 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_28212__$1 = (function (){var statearr_28216 = state_28212;
(statearr_28216[(7)] = inst_28188);

return statearr_28216;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_28217_28240 = state_28212__$1;
(statearr_28217_28240[(1)] = (7));

} else {
var statearr_28218_28241 = state_28212__$1;
(statearr_28218_28241[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (6))){
var inst_28208 = (state_28212[(2)]);
var state_28212__$1 = state_28212;
var statearr_28219_28242 = state_28212__$1;
(statearr_28219_28242[(2)] = inst_28208);

(statearr_28219_28242[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (3))){
var inst_28210 = (state_28212[(2)]);
var state_28212__$1 = state_28212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28212__$1,inst_28210);
} else {
if((state_val_28213 === (2))){
var inst_28185 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_28186 = cljs.core.not(inst_28185);
var state_28212__$1 = state_28212;
if(inst_28186){
var statearr_28220_28243 = state_28212__$1;
(statearr_28220_28243[(1)] = (4));

} else {
var statearr_28221_28244 = state_28212__$1;
(statearr_28221_28244[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (11))){
var inst_28204 = (state_28212[(2)]);
var state_28212__$1 = (function (){var statearr_28222 = state_28212;
(statearr_28222[(8)] = inst_28204);

return statearr_28222;
})();
var statearr_28223_28245 = state_28212__$1;
(statearr_28223_28245[(2)] = null);

(statearr_28223_28245[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (9))){
var inst_28193 = (state_28212[(9)]);
var inst_28188 = (state_28212[(7)]);
var inst_28192 = (state_28212[(2)]);
var inst_28193__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_28192,dataset_id,inst_28188], 0));
var inst_28194 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_28193__$1);
var state_28212__$1 = (function (){var statearr_28224 = state_28212;
(statearr_28224[(9)] = inst_28193__$1);

return statearr_28224;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28212__$1,(10),inst_28194);
} else {
if((state_val_28213 === (5))){
var state_28212__$1 = state_28212;
var statearr_28225_28246 = state_28212__$1;
(statearr_28225_28246[(2)] = null);

(statearr_28225_28246[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28213 === (10))){
var inst_28193 = (state_28212[(9)]);
var inst_28188 = (state_28212[(7)]);
var inst_28196 = (state_28212[(2)]);
var inst_28197 = [cljs.core.constant$keyword$on_DASH_stop,cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_28198 = (function (){var job_suffix = inst_28188;
var job_url = inst_28193;
var response = inst_28196;
return ((function (job_suffix,job_url,response,inst_28193,inst_28188,inst_28196,inst_28197,state_val_28213,c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_28193,inst_28188,inst_28196,inst_28197,state_val_28213,c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var inst_28199 = [inst_28198,on_error,on_export_url];
var inst_28200 = cljs.core.PersistentHashMap.fromArrays(inst_28197,inst_28199);
var inst_28201 = milia.api.async_export.handle_response(inst_28196,inst_28200);
var inst_28202 = cljs.core.async.timeout(millis);
var state_28212__$1 = (function (){var statearr_28226 = state_28212;
(statearr_28226[(10)] = inst_28201);

return statearr_28226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28212__$1,(11),inst_28202);
} else {
if((state_val_28213 === (8))){
var state_28212__$1 = state_28212;
var statearr_28227_28247 = state_28212__$1;
(statearr_28227_28247[(2)] = "forms");

(statearr_28227_28247[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
;
return ((function (switch__11564__auto__,c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function() {
var milia$api$async_export$state_machine__11565__auto__ = null;
var milia$api$async_export$state_machine__11565__auto____0 = (function (){
var statearr_28231 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28231[(0)] = milia$api$async_export$state_machine__11565__auto__);

(statearr_28231[(1)] = (1));

return statearr_28231;
});
var milia$api$async_export$state_machine__11565__auto____1 = (function (state_28212){
while(true){
var ret_value__11566__auto__ = (function (){try{while(true){
var result__11567__auto__ = switch__11564__auto__(state_28212);
if(cljs.core.keyword_identical_QMARK_(result__11567__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11567__auto__;
}
break;
}
}catch (e28232){if((e28232 instanceof Object)){
var ex__11568__auto__ = e28232;
var statearr_28233_28248 = state_28212;
(statearr_28233_28248[(5)] = ex__11568__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28212);

return cljs.core.constant$keyword$recur;
} else {
throw e28232;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11566__auto__,cljs.core.constant$keyword$recur)){
var G__28249 = state_28212;
state_28212 = G__28249;
continue;
} else {
return ret_value__11566__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11565__auto__ = function(state_28212){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11565__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11565__auto____1.call(this,state_28212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11565__auto____0;
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11565__auto____1;
return milia$api$async_export$state_machine__11565__auto__;
})()
;})(switch__11564__auto__,c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var state__11631__auto__ = (function (){var statearr_28234 = (f__11630__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11630__auto__.cljs$core$IFn$_invoke$arity$0() : f__11630__auto__.call(null));
(statearr_28234[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11629__auto__);

return statearr_28234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11631__auto__);
});})(c__11629__auto__,done_polling_QMARK_,vec__28181,map__28182,map__28182__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
);

return c__11629__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq28177){
var G__28178 = cljs.core.first(seq28177);
var seq28177__$1 = cljs.core.next(seq28177);
var G__28179 = cljs.core.first(seq28177__$1);
var seq28177__$2 = cljs.core.next(seq28177__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28178,G__28179,seq28177__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","remove_group_name","_version"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$meta_DASH_id,cljs.core.constant$keyword$data_DASH_id,cljs.core.constant$keyword$group_DASH_delimiter,cljs.core.constant$keyword$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.constant$keyword$remove_DASH_group_DASH_name_QMARK_,cljs.core.constant$keyword$version], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_(value)){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(){
var args__8986__auto__ = [];
var len__8979__auto___28255 = arguments.length;
var i__8980__auto___28256 = (0);
while(true){
if((i__8980__auto___28256 < len__8979__auto___28255)){
args__8986__auto__.push((arguments[i__8980__auto___28256]));

var G__28257 = (i__8980__auto___28256 + (1));
i__8980__auto___28256 = G__28257;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((2) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((2)),(0))):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8987__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__28253){
var vec__28254 = p__28253;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28254,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq28250){
var G__28251 = cljs.core.first(seq28250);
var seq28250__$1 = cljs.core.next(seq28250);
var G__28252 = cljs.core.first(seq28250__$1);
var seq28250__$2 = cljs.core.next(seq28250__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__28251,G__28252,seq28250__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(){
var args__8986__auto__ = [];
var len__8979__auto___28294 = arguments.length;
var i__8980__auto___28295 = (0);
while(true){
if((i__8980__auto___28295 < len__8979__auto___28294)){
args__8986__auto__.push((arguments[i__8980__auto___28295]));

var G__28296 = (i__8980__auto___28295 + (1));
i__8980__auto___28295 = G__28296;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((1) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8987__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28260){
var vec__28261 = p__28260;
var map__28262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28261,(0),null);
var map__28262__$1 = ((((!((map__28262 == null)))?((((map__28262.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28262.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28262):map__28262);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28262__$1,cljs.core.constant$keyword$on_DASH_error);
var c__11629__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__11630__auto__ = (function (){var switch__11564__auto__ = ((function (c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_28279){
var state_val_28280 = (state_28279[(1)]);
if((state_val_28280 === (1))){
var inst_28264 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_28279__$1 = (function (){var statearr_28281 = state_28279;
(statearr_28281[(7)] = inst_28264);

return statearr_28281;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_28282_28297 = state_28279__$1;
(statearr_28282_28297[(1)] = (2));

} else {
var statearr_28283_28298 = state_28279__$1;
(statearr_28283_28298[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28280 === (2))){
var state_28279__$1 = state_28279;
var statearr_28284_28299 = state_28279__$1;
(statearr_28284_28299[(2)] = "dataviews");

(statearr_28284_28299[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28280 === (3))){
var state_28279__$1 = state_28279;
var statearr_28285_28300 = state_28279__$1;
(statearr_28285_28300[(2)] = "forms");

(statearr_28285_28300[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28280 === (4))){
var inst_28268 = (state_28279[(8)]);
var inst_28269 = (state_28279[(9)]);
var inst_28264 = (state_28279[(7)]);
var inst_28268__$1 = (state_28279[(2)]);
var inst_28269__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_28268__$1,dataset_id,inst_28264], 0));
var inst_28270 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_28269__$1);
var state_28279__$1 = (function (){var statearr_28286 = state_28279;
(statearr_28286[(8)] = inst_28268__$1);

(statearr_28286[(9)] = inst_28269__$1);

return statearr_28286;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28279__$1,(5),inst_28270);
} else {
if((state_val_28280 === (5))){
var inst_28268 = (state_28279[(8)]);
var inst_28269 = (state_28279[(9)]);
var inst_28264 = (state_28279[(7)]);
var inst_28272 = (state_28279[(2)]);
var inst_28273 = (function (){var export_suffix = inst_28264;
var export_endpoint = inst_28268;
var export_url = inst_28269;
var response = inst_28272;
return ((function (export_suffix,export_endpoint,export_url,response,inst_28268,inst_28269,inst_28264,inst_28272,state_val_28280,c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$on_DASH_export_DASH_url,on_export_url,cljs.core.constant$keyword$on_DASH_error,on_error,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], null)], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_28268,inst_28269,inst_28264,inst_28272,state_val_28280,c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_28274 = [cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_28275 = [on_error,inst_28273,on_export_url];
var inst_28276 = cljs.core.PersistentHashMap.fromArrays(inst_28274,inst_28275);
var inst_28277 = milia.api.async_export.handle_response(inst_28272,inst_28276);
var state_28279__$1 = state_28279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28279__$1,inst_28277);
} else {
return null;
}
}
}
}
}
});})(c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__11564__auto__,c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__11565__auto__ = null;
var milia$api$async_export$state_machine__11565__auto____0 = (function (){
var statearr_28290 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28290[(0)] = milia$api$async_export$state_machine__11565__auto__);

(statearr_28290[(1)] = (1));

return statearr_28290;
});
var milia$api$async_export$state_machine__11565__auto____1 = (function (state_28279){
while(true){
var ret_value__11566__auto__ = (function (){try{while(true){
var result__11567__auto__ = switch__11564__auto__(state_28279);
if(cljs.core.keyword_identical_QMARK_(result__11567__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11567__auto__;
}
break;
}
}catch (e28291){if((e28291 instanceof Object)){
var ex__11568__auto__ = e28291;
var statearr_28292_28301 = state_28279;
(statearr_28292_28301[(5)] = ex__11568__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28279);

return cljs.core.constant$keyword$recur;
} else {
throw e28291;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11566__auto__,cljs.core.constant$keyword$recur)){
var G__28302 = state_28279;
state_28279 = G__28302;
continue;
} else {
return ret_value__11566__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11565__auto__ = function(state_28279){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11565__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11565__auto____1.call(this,state_28279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11565__auto____0;
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11565__auto____1;
return milia$api$async_export$state_machine__11565__auto__;
})()
;})(switch__11564__auto__,c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__11631__auto__ = (function (){var statearr_28293 = (f__11630__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11630__auto__.cljs$core$IFn$_invoke$arity$0() : f__11630__auto__.call(null));
(statearr_28293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11629__auto__);

return statearr_28293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11631__auto__);
});})(c__11629__auto__,vec__28261,map__28262,map__28262__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__11629__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq28258){
var G__28259 = cljs.core.first(seq28258);
var seq28258__$1 = cljs.core.next(seq28258);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28259,seq28258__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$data_DASH_format,data_format,cljs.core.constant$keyword$on_DASH_export_DASH_url,((function (ch){
return (function (p1__28303_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__28303_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(){
var args__8986__auto__ = [];
var len__8979__auto___28328 = arguments.length;
var i__8980__auto___28329 = (0);
while(true){
if((i__8980__auto___28329 < len__8979__auto___28328)){
args__8986__auto__.push((arguments[i__8980__auto___28329]));

var G__28330 = (i__8980__auto___28329 + (1));
i__8980__auto___28329 = G__28330;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((3) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8987__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__11629__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11629__auto__){
return (function (){
var f__11630__auto__ = (function (){var switch__11564__auto__ = ((function (c__11629__auto__){
return (function (state_28319){
var state_val_28320 = (state_28319[(1)]);
if((state_val_28320 === (1))){
var inst_28308 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_28319__$1 = state_28319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28319__$1,(2),inst_28308);
} else {
if((state_val_28320 === (2))){
var inst_28310 = (state_28319[(2)]);
var inst_28311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28312 = [http_method,inst_28310];
var inst_28313 = (new cljs.core.PersistentVector(null,2,(5),inst_28311,inst_28312,null));
var inst_28314 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28313,args);
var inst_28315 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_28314);
var state_28319__$1 = state_28319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28319__$1,(3),inst_28315);
} else {
if((state_val_28320 === (3))){
var inst_28317 = (state_28319[(2)]);
var state_28319__$1 = state_28319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28319__$1,inst_28317);
} else {
return null;
}
}
}
});})(c__11629__auto__))
;
return ((function (switch__11564__auto__,c__11629__auto__){
return (function() {
var milia$api$async_export$state_machine__11565__auto__ = null;
var milia$api$async_export$state_machine__11565__auto____0 = (function (){
var statearr_28324 = [null,null,null,null,null,null,null];
(statearr_28324[(0)] = milia$api$async_export$state_machine__11565__auto__);

(statearr_28324[(1)] = (1));

return statearr_28324;
});
var milia$api$async_export$state_machine__11565__auto____1 = (function (state_28319){
while(true){
var ret_value__11566__auto__ = (function (){try{while(true){
var result__11567__auto__ = switch__11564__auto__(state_28319);
if(cljs.core.keyword_identical_QMARK_(result__11567__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11567__auto__;
}
break;
}
}catch (e28325){if((e28325 instanceof Object)){
var ex__11568__auto__ = e28325;
var statearr_28326_28331 = state_28319;
(statearr_28326_28331[(5)] = ex__11568__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28319);

return cljs.core.constant$keyword$recur;
} else {
throw e28325;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11566__auto__,cljs.core.constant$keyword$recur)){
var G__28332 = state_28319;
state_28319 = G__28332;
continue;
} else {
return ret_value__11566__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11565__auto__ = function(state_28319){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11565__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11565__auto____1.call(this,state_28319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11565__auto____0;
milia$api$async_export$state_machine__11565__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11565__auto____1;
return milia$api$async_export$state_machine__11565__auto__;
})()
;})(switch__11564__auto__,c__11629__auto__))
})();
var state__11631__auto__ = (function (){var statearr_28327 = (f__11630__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11630__auto__.cljs$core$IFn$_invoke$arity$0() : f__11630__auto__.call(null));
(statearr_28327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11629__auto__);

return statearr_28327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11631__auto__);
});})(c__11629__auto__))
);

return c__11629__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq28304){
var G__28305 = cljs.core.first(seq28304);
var seq28304__$1 = cljs.core.next(seq28304);
var G__28306 = cljs.core.first(seq28304__$1);
var seq28304__$2 = cljs.core.next(seq28304__$1);
var G__28307 = cljs.core.first(seq28304__$2);
var seq28304__$3 = cljs.core.next(seq28304__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__28305,G__28306,G__28307,seq28304__$3);
});
