// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.async_export.export_async_url = "export_async.json?format=";
/**
 * Handles API server's response and acts according to given
 * callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__16640,p__16641){
var map__16648 = p__16640;
var map__16648__$1 = ((((!((map__16648 == null)))?((((map__16648.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16648.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16648):map__16648);
var response = map__16648__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16648__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16648__$1,cljs.core.constant$keyword$body);
var map__16649 = p__16641;
var map__16649__$1 = ((((!((map__16649 == null)))?((((map__16649.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16649.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16649):map__16649);
var callbacks = map__16649__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16649__$1,cljs.core.constant$keyword$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16649__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16649__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16649__$1,cljs.core.constant$keyword$on_DASH_stop,cljs.core.constantly(null));
var map__16652 = body;
var map__16652__$1 = ((((!((map__16652 == null)))?((((map__16652.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16652.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16652):map__16652);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16652__$1,cljs.core.constant$keyword$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16652__$1,cljs.core.constant$keyword$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16652__$1,cljs.core.constant$keyword$job_uuid);
var error_detail = (function (){var or__4495__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4495__auto__)){
return or__4495__auto__;
} else {
return cljs.core.constant$keyword$error.cljs$core$IFn$_invoke$arity$1(body);
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if((status >= (400))){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 * `millis` is the number of milliseconds after which to poll again.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(){
var args__5541__auto__ = [];
var len__5534__auto___16712 = arguments.length;
var i__5535__auto___16713 = (0);
while(true){
if((i__5535__auto___16713 < len__5534__auto___16712)){
args__5541__auto__.push((arguments[i__5535__auto___16713]));

var G__16714 = (i__5535__auto___16713 + (1));
i__5535__auto___16713 = G__16714;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((2) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5542__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__16657){
var vec__16658 = p__16657;
var map__16659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16658,(0),null);
var map__16659__$1 = ((((!((map__16659 == null)))?((((map__16659.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16659.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16659):map__16659);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16659__$1,cljs.core.constant$keyword$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16659__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16659__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16659__$1,cljs.core.constant$keyword$millis);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (state_16689){
var state_val_16690 = (state_16689[(1)]);
if((state_val_16690 === (7))){
var state_16689__$1 = state_16689;
var statearr_16691_16715 = state_16689__$1;
(statearr_16691_16715[(2)] = "dataviews");

(statearr_16691_16715[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (1))){
var state_16689__$1 = state_16689;
var statearr_16692_16716 = state_16689__$1;
(statearr_16692_16716[(2)] = null);

(statearr_16692_16716[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (4))){
var inst_16665 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_16689__$1 = (function (){var statearr_16693 = state_16689;
(statearr_16693[(7)] = inst_16665);

return statearr_16693;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_16694_16717 = state_16689__$1;
(statearr_16694_16717[(1)] = (7));

} else {
var statearr_16695_16718 = state_16689__$1;
(statearr_16695_16718[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (6))){
var inst_16685 = (state_16689[(2)]);
var state_16689__$1 = state_16689;
var statearr_16696_16719 = state_16689__$1;
(statearr_16696_16719[(2)] = inst_16685);

(statearr_16696_16719[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (3))){
var inst_16687 = (state_16689[(2)]);
var state_16689__$1 = state_16689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16689__$1,inst_16687);
} else {
if((state_val_16690 === (2))){
var inst_16662 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_16663 = cljs.core.not(inst_16662);
var state_16689__$1 = state_16689;
if(inst_16663){
var statearr_16697_16720 = state_16689__$1;
(statearr_16697_16720[(1)] = (4));

} else {
var statearr_16698_16721 = state_16689__$1;
(statearr_16698_16721[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (11))){
var inst_16681 = (state_16689[(2)]);
var state_16689__$1 = (function (){var statearr_16699 = state_16689;
(statearr_16699[(8)] = inst_16681);

return statearr_16699;
})();
var statearr_16700_16722 = state_16689__$1;
(statearr_16700_16722[(2)] = null);

(statearr_16700_16722[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (9))){
var inst_16665 = (state_16689[(7)]);
var inst_16670 = (state_16689[(9)]);
var inst_16669 = (state_16689[(2)]);
var inst_16670__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16669,dataset_id,inst_16665], 0));
var inst_16671 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_16670__$1);
var state_16689__$1 = (function (){var statearr_16701 = state_16689;
(statearr_16701[(9)] = inst_16670__$1);

return statearr_16701;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16689__$1,(10),inst_16671);
} else {
if((state_val_16690 === (5))){
var state_16689__$1 = state_16689;
var statearr_16702_16723 = state_16689__$1;
(statearr_16702_16723[(2)] = null);

(statearr_16702_16723[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16690 === (10))){
var inst_16665 = (state_16689[(7)]);
var inst_16670 = (state_16689[(9)]);
var inst_16673 = (state_16689[(2)]);
var inst_16674 = [cljs.core.constant$keyword$on_DASH_stop,cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_16675 = (function (){var job_suffix = inst_16665;
var job_url = inst_16670;
var response = inst_16673;
return ((function (job_suffix,job_url,response,inst_16665,inst_16670,inst_16673,inst_16674,state_val_16690,c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_16665,inst_16670,inst_16673,inst_16674,state_val_16690,c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var inst_16676 = [inst_16675,on_error,on_export_url];
var inst_16677 = cljs.core.PersistentHashMap.fromArrays(inst_16674,inst_16676);
var inst_16678 = milia.api.async_export.handle_response(inst_16673,inst_16677);
var inst_16679 = cljs.core.async.timeout(millis);
var state_16689__$1 = (function (){var statearr_16703 = state_16689;
(statearr_16703[(10)] = inst_16678);

return statearr_16703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16689__$1,(11),inst_16679);
} else {
if((state_val_16690 === (8))){
var state_16689__$1 = state_16689;
var statearr_16704_16724 = state_16689__$1;
(statearr_16704_16724[(2)] = "forms");

(statearr_16704_16724[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
;
return ((function (switch__7918__auto__,c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16708 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16708[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16708[(1)] = (1));

return statearr_16708;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16689){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16689);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16709){if((e16709 instanceof Object)){
var ex__7922__auto__ = e16709;
var statearr_16710_16725 = state_16689;
(statearr_16710_16725[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16689);

return cljs.core.constant$keyword$recur;
} else {
throw e16709;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16726 = state_16689;
state_16689 = G__16726;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16689){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var state__7985__auto__ = (function (){var statearr_16711 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__,done_polling_QMARK_,vec__16658,map__16659,map__16659__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
);

return c__7983__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq16654){
var G__16655 = cljs.core.first(seq16654);
var seq16654__$1 = cljs.core.next(seq16654);
var G__16656 = cljs.core.first(seq16654__$1);
var seq16654__$2 = cljs.core.next(seq16654__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16655,G__16656,seq16654__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","remove_group_name","_version"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$meta_DASH_id,cljs.core.constant$keyword$data_DASH_id,cljs.core.constant$keyword$group_DASH_delimiter,cljs.core.constant$keyword$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.constant$keyword$remove_DASH_group_DASH_name_QMARK_,cljs.core.constant$keyword$version], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_(value)){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(){
var args__5541__auto__ = [];
var len__5534__auto___16732 = arguments.length;
var i__5535__auto___16733 = (0);
while(true){
if((i__5535__auto___16733 < len__5534__auto___16732)){
args__5541__auto__.push((arguments[i__5535__auto___16733]));

var G__16734 = (i__5535__auto___16733 + (1));
i__5535__auto___16733 = G__16734;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((2) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((2)),(0))):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5542__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,export_options,p__16730){
var vec__16731 = p__16730;
var data_format = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16731,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq16727){
var G__16728 = cljs.core.first(seq16727);
var seq16727__$1 = cljs.core.next(seq16727);
var G__16729 = cljs.core.first(seq16727__$1);
var seq16727__$2 = cljs.core.next(seq16727__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__16728,G__16729,seq16727__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(){
var args__5541__auto__ = [];
var len__5534__auto___16771 = arguments.length;
var i__5535__auto___16772 = (0);
while(true){
if((i__5535__auto___16772 < len__5534__auto___16771)){
args__5541__auto__.push((arguments[i__5535__auto___16772]));

var G__16773 = (i__5535__auto___16772 + (1));
i__5535__auto___16772 = G__16773;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((1) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5542__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__16737){
var vec__16738 = p__16737;
var map__16739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16738,(0),null);
var map__16739__$1 = ((((!((map__16739 == null)))?((((map__16739.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16739.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16739):map__16739);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16739__$1,cljs.core.constant$keyword$on_DASH_error);
var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_16756){
var state_val_16757 = (state_16756[(1)]);
if((state_val_16757 === (1))){
var inst_16741 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_16756__$1 = (function (){var statearr_16758 = state_16756;
(statearr_16758[(7)] = inst_16741);

return statearr_16758;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_16759_16774 = state_16756__$1;
(statearr_16759_16774[(1)] = (2));

} else {
var statearr_16760_16775 = state_16756__$1;
(statearr_16760_16775[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16757 === (2))){
var state_16756__$1 = state_16756;
var statearr_16761_16776 = state_16756__$1;
(statearr_16761_16776[(2)] = "dataviews");

(statearr_16761_16776[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16757 === (3))){
var state_16756__$1 = state_16756;
var statearr_16762_16777 = state_16756__$1;
(statearr_16762_16777[(2)] = "forms");

(statearr_16762_16777[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16757 === (4))){
var inst_16741 = (state_16756[(7)]);
var inst_16746 = (state_16756[(8)]);
var inst_16745 = (state_16756[(9)]);
var inst_16745__$1 = (state_16756[(2)]);
var inst_16746__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16745__$1,dataset_id,inst_16741], 0));
var inst_16747 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_16746__$1);
var state_16756__$1 = (function (){var statearr_16763 = state_16756;
(statearr_16763[(8)] = inst_16746__$1);

(statearr_16763[(9)] = inst_16745__$1);

return statearr_16763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16756__$1,(5),inst_16747);
} else {
if((state_val_16757 === (5))){
var inst_16741 = (state_16756[(7)]);
var inst_16746 = (state_16756[(8)]);
var inst_16745 = (state_16756[(9)]);
var inst_16749 = (state_16756[(2)]);
var inst_16750 = (function (){var export_suffix = inst_16741;
var export_endpoint = inst_16745;
var export_url = inst_16746;
var response = inst_16749;
return ((function (export_suffix,export_endpoint,export_url,response,inst_16741,inst_16746,inst_16745,inst_16749,state_val_16757,c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$on_DASH_export_DASH_url,on_export_url,cljs.core.constant$keyword$on_DASH_error,on_error,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], null)], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_16741,inst_16746,inst_16745,inst_16749,state_val_16757,c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_16751 = [cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_16752 = [on_error,inst_16750,on_export_url];
var inst_16753 = cljs.core.PersistentHashMap.fromArrays(inst_16751,inst_16752);
var inst_16754 = milia.api.async_export.handle_response(inst_16749,inst_16753);
var state_16756__$1 = state_16756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16756__$1,inst_16754);
} else {
return null;
}
}
}
}
}
});})(c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__7918__auto__,c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16767 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16767[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16767[(1)] = (1));

return statearr_16767;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16756){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16756);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16768){if((e16768 instanceof Object)){
var ex__7922__auto__ = e16768;
var statearr_16769_16778 = state_16756;
(statearr_16769_16778[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16756);

return cljs.core.constant$keyword$recur;
} else {
throw e16768;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16779 = state_16756;
state_16756 = G__16779;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16756){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__7985__auto__ = (function (){var statearr_16770 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16770[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__,vec__16738,map__16739,map__16739__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__7983__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq16735){
var G__16736 = cljs.core.first(seq16735);
var seq16735__$1 = cljs.core.next(seq16735);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16736,seq16735__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$data_DASH_format,data_format,cljs.core.constant$keyword$on_DASH_export_DASH_url,((function (ch){
return (function (p1__16780_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__16780_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(){
var args__5541__auto__ = [];
var len__5534__auto___16805 = arguments.length;
var i__5535__auto___16806 = (0);
while(true){
if((i__5535__auto___16806 < len__5534__auto___16805)){
args__5541__auto__.push((arguments[i__5535__auto___16806]));

var G__16807 = (i__5535__auto___16806 + (1));
i__5535__auto___16806 = G__16807;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((3) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5542__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__){
return (function (state_16796){
var state_val_16797 = (state_16796[(1)]);
if((state_val_16797 === (1))){
var inst_16785 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_16796__$1 = state_16796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16796__$1,(2),inst_16785);
} else {
if((state_val_16797 === (2))){
var inst_16787 = (state_16796[(2)]);
var inst_16788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16789 = [http_method,inst_16787];
var inst_16790 = (new cljs.core.PersistentVector(null,2,(5),inst_16788,inst_16789,null));
var inst_16791 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_16790,args);
var inst_16792 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_16791);
var state_16796__$1 = state_16796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16796__$1,(3),inst_16792);
} else {
if((state_val_16797 === (3))){
var inst_16794 = (state_16796[(2)]);
var state_16796__$1 = state_16796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16796__$1,inst_16794);
} else {
return null;
}
}
}
});})(c__7983__auto__))
;
return ((function (switch__7918__auto__,c__7983__auto__){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16801 = [null,null,null,null,null,null,null];
(statearr_16801[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16801[(1)] = (1));

return statearr_16801;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16796){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16796);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16802){if((e16802 instanceof Object)){
var ex__7922__auto__ = e16802;
var statearr_16803_16808 = state_16796;
(statearr_16803_16808[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16796);

return cljs.core.constant$keyword$recur;
} else {
throw e16802;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16809 = state_16796;
state_16796 = G__16809;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16796){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__))
})();
var state__7985__auto__ = (function (){var statearr_16804 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16804[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__))
);

return c__7983__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq16781){
var G__16782 = cljs.core.first(seq16781);
var seq16781__$1 = cljs.core.next(seq16781);
var G__16783 = cljs.core.first(seq16781__$1);
var seq16781__$2 = cljs.core.next(seq16781__$1);
var G__16784 = cljs.core.first(seq16781__$2);
var seq16781__$3 = cljs.core.next(seq16781__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__16782,G__16783,G__16784,seq16781__$3);
});
