// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.charts');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.charts.format = goog.string.format;
milia.api.charts.suffix = (function milia$api$charts$suffix(var_args){
var args21403 = [];
var len__7280__auto___21406 = arguments.length;
var i__7281__auto___21407 = (0);
while(true){
if((i__7281__auto___21407 < len__7280__auto___21406)){
args21403.push((arguments[i__7281__auto___21407]));

var G__21408 = (i__7281__auto___21407 + (1));
i__7281__auto___21407 = G__21408;
continue;
} else {
}
break;
}

var G__21405 = args21403.length;
switch (G__21405) {
case 1:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21403.length)].join('')));

}
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return [cljs.core.str(dataset_id),cljs.core.str(".json")].join('');
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var field_s = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_name,"all"))?"fields":"field_name");
return [cljs.core.str(dataset_id),cljs.core.str(".json?"),cljs.core.str(field_s),cljs.core.str("="),cljs.core.str(field_name)].join('');
});

milia.api.charts.suffix.cljs$lang$maxFixedArity = 2;
/**
 * Get list of chart fields for a specific dataset
 */
milia.api.charts.fields = (function milia$api$charts$fields(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1(dataset_id)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get chart for a specific field in a dataset
 */
milia.api.charts.chart = (function milia$api$charts$chart(var_args){
var args21410 = [];
var len__7280__auto___21413 = arguments.length;
var i__7281__auto___21414 = (0);
while(true){
if((i__7281__auto___21414 < len__7280__auto___21413)){
args21410.push((arguments[i__7281__auto___21414]));

var G__21415 = (i__7281__auto___21414 + (1));
i__7281__auto___21414 = G__21415;
continue;
} else {
}
break;
}

var G__21412 = args21410.length;
switch (G__21412) {
case 1:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21410.length)].join('')));

}
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2(dataset_id,"all");
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2(dataset_id,field_name)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.chart.cljs$lang$maxFixedArity = 2;
/**
 * Given a field name, return chart data associated with a dataset or dataview
 */
milia.api.charts.get = (function milia$api$charts$get(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21422 = arguments.length;
var i__7281__auto___21423 = (0);
while(true){
if((i__7281__auto___21423 < len__7280__auto___21422)){
args__7287__auto__.push((arguments[i__7281__auto___21423]));

var G__21424 = (i__7281__auto___21423 + (1));
i__7281__auto___21423 = G__21424;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic = (function (field_name,p__21419){
var map__21420 = p__21419;
var map__21420__$1 = ((((!((map__21420 == null)))?((((map__21420.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21420.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21420):map__21420);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21420__$1,cljs.core.cst$kw$dataview_DASH_id);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21420__$1,cljs.core.cst$kw$dataset_DASH_id);
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21420__$1,cljs.core.cst$kw$group_DASH_by);
var id = (function (){var or__6210__auto__ = dataview_id;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return dataset_id;
}
})();
var base_url_template = (cljs.core.truth_(dataview_id)?"dataviews/%s/charts.json?field_name=%s":"charts/%s.json?field_name=%s");
var url_template = [cljs.core.str(base_url_template),cljs.core.str((cljs.core.truth_(group_by)?"&group_by=%s":null))].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(milia.api.charts.format.cljs$core$IFn$_invoke$arity$4 ? milia.api.charts.format.cljs$core$IFn$_invoke$arity$4(url_template,id,field_name,group_by) : milia.api.charts.format.call(null,url_template,id,field_name,group_by))], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.get.cljs$lang$maxFixedArity = (1);

milia.api.charts.get.cljs$lang$applyTo = (function (seq21417){
var G__21418 = cljs.core.first(seq21417);
var seq21417__$1 = cljs.core.next(seq21417);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic(G__21418,seq21417__$1);
});
