// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.utils.url');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$temp_DASH_token,null,cljs.core.constant$keyword$token,null,cljs.core.constant$keyword$username,null,cljs.core.constant$keyword$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__25300 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$client,"zebra.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$j2x,"j2x.ona.io",cljs.core.constant$keyword$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25300) : cljs.core.atom.call(null,G__25300));
})();
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var args__8982__auto__ = [];
var len__8975__auto___25302 = arguments.length;
var i__8976__auto___25303 = (0);
while(true){
if((i__8976__auto___25303 < len__8975__auto___25302)){
args__8982__auto__.push((arguments[i__8976__auto___25303]));

var G__25304 = (i__8976__auto___25303 + (1));
i__8976__auto___25303 = G__25304;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq25301){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25301));
});
/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(){
var args__8982__auto__ = [];
var len__8975__auto___25306 = arguments.length;
var i__8976__auto___25307 = (0);
while(true){
if((i__8976__auto___25307 < len__8975__auto___25306)){
args__8982__auto__.push((arguments[i__8976__auto___25307]));

var G__25308 = (i__8976__auto___25307 + (1));
i__8976__auto___25307 = G__25308;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq25305){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25305));
});
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(){
var args__8982__auto__ = [];
var len__8975__auto___25310 = arguments.length;
var i__8976__auto___25311 = (0);
while(true){
if((i__8976__auto___25311 < len__8975__auto___25310)){
args__8982__auto__.push((arguments[i__8976__auto___25311]));

var G__25312 = (i__8976__auto___25311 + (1));
i__8976__auto___25311 = G__25312;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq25309){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25309));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var args__8982__auto__ = [];
var len__8975__auto___25314 = arguments.length;
var i__8976__auto___25315 = (0);
while(true){
if((i__8976__auto___25315 < len__8975__auto___25314)){
args__8982__auto__.push((arguments[i__8976__auto___25315]));

var G__25316 = (i__8976__auto___25315 + (1));
i__8976__auto___25315 = G__25316;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq25313){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25313));
});
