// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Handles API server's response and acts according to given
 * callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__28342,p__28343){
var map__28350 = p__28342;
var map__28350__$1 = ((((!((map__28350 == null)))?((((map__28350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28350):map__28350);
var response = map__28350__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28350__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28350__$1,cljs.core.constant$keyword$body);
var map__28351 = p__28343;
var map__28351__$1 = ((((!((map__28351 == null)))?((((map__28351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28351):map__28351);
var callbacks = map__28351__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28351__$1,cljs.core.constant$keyword$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28351__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28351__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28351__$1,cljs.core.constant$keyword$on_DASH_stop,cljs.core.constantly(null));
var map__28354 = body;
var map__28354__$1 = ((((!((map__28354 == null)))?((((map__28354.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28354.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28354):map__28354);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28354__$1,cljs.core.constant$keyword$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28354__$1,cljs.core.constant$keyword$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28354__$1,cljs.core.constant$keyword$job_uuid);
var error_detail = (function (){var or__7936__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return cljs.core.constant$keyword$error.cljs$core$IFn$_invoke$arity$1(body);
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if((status >= (400))){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 * `millis` is the number of milliseconds after which to poll again.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(){
var args__8982__auto__ = [];
var len__8975__auto___28414 = arguments.length;
var i__8976__auto___28415 = (0);
while(true){
if((i__8976__auto___28415 < len__8975__auto___28414)){
args__8982__auto__.push((arguments[i__8976__auto___28415]));

var G__28416 = (i__8976__auto___28415 + (1));
i__8976__auto___28415 = G__28416;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((2) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8983__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__28359){
var vec__28360 = p__28359;
var map__28361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28360,(0),null);
var map__28361__$1 = ((((!((map__28361 == null)))?((((map__28361.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28361.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28361):map__28361);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28361__$1,cljs.core.constant$keyword$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28361__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28361__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28361__$1,cljs.core.constant$keyword$millis);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (state_28391){
var state_val_28392 = (state_28391[(1)]);
if((state_val_28392 === (7))){
var state_28391__$1 = state_28391;
var statearr_28393_28417 = state_28391__$1;
(statearr_28393_28417[(2)] = "dataviews");

(statearr_28393_28417[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (1))){
var state_28391__$1 = state_28391;
var statearr_28394_28418 = state_28391__$1;
(statearr_28394_28418[(2)] = null);

(statearr_28394_28418[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (4))){
var inst_28367 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_28391__$1 = (function (){var statearr_28395 = state_28391;
(statearr_28395[(7)] = inst_28367);

return statearr_28395;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_28396_28419 = state_28391__$1;
(statearr_28396_28419[(1)] = (7));

} else {
var statearr_28397_28420 = state_28391__$1;
(statearr_28397_28420[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (6))){
var inst_28387 = (state_28391[(2)]);
var state_28391__$1 = state_28391;
var statearr_28398_28421 = state_28391__$1;
(statearr_28398_28421[(2)] = inst_28387);

(statearr_28398_28421[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (3))){
var inst_28389 = (state_28391[(2)]);
var state_28391__$1 = state_28391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28391__$1,inst_28389);
} else {
if((state_val_28392 === (2))){
var inst_28364 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_28365 = cljs.core.not(inst_28364);
var state_28391__$1 = state_28391;
if(inst_28365){
var statearr_28399_28422 = state_28391__$1;
(statearr_28399_28422[(1)] = (4));

} else {
var statearr_28400_28423 = state_28391__$1;
(statearr_28400_28423[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (11))){
var inst_28383 = (state_28391[(2)]);
var state_28391__$1 = (function (){var statearr_28401 = state_28391;
(statearr_28401[(8)] = inst_28383);

return statearr_28401;
})();
var statearr_28402_28424 = state_28391__$1;
(statearr_28402_28424[(2)] = null);

(statearr_28402_28424[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (9))){
var inst_28372 = (state_28391[(9)]);
var inst_28367 = (state_28391[(7)]);
var inst_28371 = (state_28391[(2)]);
var inst_28372__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_28371,dataset_id,inst_28367], 0));
var inst_28373 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_28372__$1);
var state_28391__$1 = (function (){var statearr_28403 = state_28391;
(statearr_28403[(9)] = inst_28372__$1);

return statearr_28403;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28391__$1,(10),inst_28373);
} else {
if((state_val_28392 === (5))){
var state_28391__$1 = state_28391;
var statearr_28404_28425 = state_28391__$1;
(statearr_28404_28425[(2)] = null);

(statearr_28404_28425[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28392 === (10))){
var inst_28372 = (state_28391[(9)]);
var inst_28367 = (state_28391[(7)]);
var inst_28375 = (state_28391[(2)]);
var inst_28376 = [cljs.core.constant$keyword$on_DASH_stop,cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_28377 = (function (){var job_suffix = inst_28367;
var job_url = inst_28372;
var response = inst_28375;
return ((function (job_suffix,job_url,response,inst_28372,inst_28367,inst_28375,inst_28376,state_val_28392,c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_28372,inst_28367,inst_28375,inst_28376,state_val_28392,c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var inst_28378 = [inst_28377,on_error,on_export_url];
var inst_28379 = cljs.core.PersistentHashMap.fromArrays(inst_28376,inst_28378);
var inst_28380 = milia.api.async_export.handle_response(inst_28375,inst_28379);
var inst_28381 = cljs.core.async.timeout(millis);
var state_28391__$1 = (function (){var statearr_28405 = state_28391;
(statearr_28405[(10)] = inst_28380);

return statearr_28405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28391__$1,(11),inst_28381);
} else {
if((state_val_28392 === (8))){
var state_28391__$1 = state_28391;
var statearr_28406_28426 = state_28391__$1;
(statearr_28406_28426[(2)] = "forms");

(statearr_28406_28426[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
;
return ((function (switch__11560__auto__,c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function() {
var milia$api$async_export$state_machine__11561__auto__ = null;
var milia$api$async_export$state_machine__11561__auto____0 = (function (){
var statearr_28410 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28410[(0)] = milia$api$async_export$state_machine__11561__auto__);

(statearr_28410[(1)] = (1));

return statearr_28410;
});
var milia$api$async_export$state_machine__11561__auto____1 = (function (state_28391){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28391);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28411){if((e28411 instanceof Object)){
var ex__11564__auto__ = e28411;
var statearr_28412_28427 = state_28391;
(statearr_28412_28427[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28391);

return cljs.core.constant$keyword$recur;
} else {
throw e28411;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28428 = state_28391;
state_28391 = G__28428;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11561__auto__ = function(state_28391){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11561__auto____1.call(this,state_28391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11561__auto____0;
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11561__auto____1;
return milia$api$async_export$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var state__11627__auto__ = (function (){var statearr_28413 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28413[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_28413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__,done_polling_QMARK_,vec__28360,map__28361,map__28361__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
);

return c__11625__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq28356){
var G__28357 = cljs.core.first(seq28356);
var seq28356__$1 = cljs.core.next(seq28356);
var G__28358 = cljs.core.first(seq28356__$1);
var seq28356__$2 = cljs.core.next(seq28356__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28357,G__28358,seq28356__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","remove_group_name","_version"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$meta_DASH_id,cljs.core.constant$keyword$data_DASH_id,cljs.core.constant$keyword$group_DASH_delimiter,cljs.core.constant$keyword$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.constant$keyword$remove_DASH_group_DASH_name_QMARK_,cljs.core.constant$keyword$version], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_(value)){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(data_format,export_options){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["export_async.json?format=",data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(){
var args__8982__auto__ = [];
var len__8975__auto___28465 = arguments.length;
var i__8976__auto___28466 = (0);
while(true){
if((i__8976__auto___28466 < len__8975__auto___28465)){
args__8982__auto__.push((arguments[i__8976__auto___28466]));

var G__28467 = (i__8976__auto___28466 + (1));
i__8976__auto___28466 = G__28467;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28431){
var vec__28432 = p__28431;
var map__28433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28432,(0),null);
var map__28433__$1 = ((((!((map__28433 == null)))?((((map__28433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28433):map__28433);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28433__$1,cljs.core.constant$keyword$on_DASH_error);
var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_28450){
var state_val_28451 = (state_28450[(1)]);
if((state_val_28451 === (1))){
var inst_28435 = milia.api.async_export.build_export_suffix(data_format,export_options);
var state_28450__$1 = (function (){var statearr_28452 = state_28450;
(statearr_28452[(7)] = inst_28435);

return statearr_28452;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_28453_28468 = state_28450__$1;
(statearr_28453_28468[(1)] = (2));

} else {
var statearr_28454_28469 = state_28450__$1;
(statearr_28454_28469[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28451 === (2))){
var state_28450__$1 = state_28450;
var statearr_28455_28470 = state_28450__$1;
(statearr_28455_28470[(2)] = "dataviews");

(statearr_28455_28470[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28451 === (3))){
var state_28450__$1 = state_28450;
var statearr_28456_28471 = state_28450__$1;
(statearr_28456_28471[(2)] = "forms");

(statearr_28456_28471[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28451 === (4))){
var inst_28440 = (state_28450[(8)]);
var inst_28435 = (state_28450[(7)]);
var inst_28439 = (state_28450[(9)]);
var inst_28439__$1 = (state_28450[(2)]);
var inst_28440__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_28439__$1,dataset_id,inst_28435], 0));
var inst_28441 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_28440__$1);
var state_28450__$1 = (function (){var statearr_28457 = state_28450;
(statearr_28457[(8)] = inst_28440__$1);

(statearr_28457[(9)] = inst_28439__$1);

return statearr_28457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28450__$1,(5),inst_28441);
} else {
if((state_val_28451 === (5))){
var inst_28440 = (state_28450[(8)]);
var inst_28435 = (state_28450[(7)]);
var inst_28439 = (state_28450[(9)]);
var inst_28443 = (state_28450[(2)]);
var inst_28444 = (function (){var export_suffix = inst_28435;
var export_endpoint = inst_28439;
var export_url = inst_28440;
var response = inst_28443;
return ((function (export_suffix,export_endpoint,export_url,response,inst_28440,inst_28435,inst_28439,inst_28443,state_val_28451,c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$on_DASH_export_DASH_url,on_export_url,cljs.core.constant$keyword$on_DASH_error,on_error,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], null)], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_28440,inst_28435,inst_28439,inst_28443,state_val_28451,c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_28445 = [cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_28446 = [on_error,inst_28444,on_export_url];
var inst_28447 = cljs.core.PersistentHashMap.fromArrays(inst_28445,inst_28446);
var inst_28448 = milia.api.async_export.handle_response(inst_28443,inst_28447);
var state_28450__$1 = state_28450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28450__$1,inst_28448);
} else {
return null;
}
}
}
}
}
});})(c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__11560__auto__,c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__11561__auto__ = null;
var milia$api$async_export$state_machine__11561__auto____0 = (function (){
var statearr_28461 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28461[(0)] = milia$api$async_export$state_machine__11561__auto__);

(statearr_28461[(1)] = (1));

return statearr_28461;
});
var milia$api$async_export$state_machine__11561__auto____1 = (function (state_28450){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28450);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28462){if((e28462 instanceof Object)){
var ex__11564__auto__ = e28462;
var statearr_28463_28472 = state_28450;
(statearr_28463_28472[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28450);

return cljs.core.constant$keyword$recur;
} else {
throw e28462;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28473 = state_28450;
state_28450 = G__28473;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11561__auto__ = function(state_28450){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11561__auto____1.call(this,state_28450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11561__auto____0;
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11561__auto____1;
return milia$api$async_export$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__11627__auto__ = (function (){var statearr_28464 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28464[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_28464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__,vec__28432,map__28433,map__28433__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__11625__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq28429){
var G__28430 = cljs.core.first(seq28429);
var seq28429__$1 = cljs.core.next(seq28429);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28430,seq28429__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$data_DASH_format,data_format,cljs.core.constant$keyword$on_DASH_export_DASH_url,((function (ch){
return (function (p1__28474_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__28474_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(){
var args__8982__auto__ = [];
var len__8975__auto___28499 = arguments.length;
var i__8976__auto___28500 = (0);
while(true){
if((i__8976__auto___28500 < len__8975__auto___28499)){
args__8982__auto__.push((arguments[i__8976__auto___28500]));

var G__28501 = (i__8976__auto___28500 + (1));
i__8976__auto___28500 = G__28501;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((3) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8983__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__){
return (function (state_28490){
var state_val_28491 = (state_28490[(1)]);
if((state_val_28491 === (1))){
var inst_28479 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_28490__$1 = state_28490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28490__$1,(2),inst_28479);
} else {
if((state_val_28491 === (2))){
var inst_28481 = (state_28490[(2)]);
var inst_28482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28483 = [http_method,inst_28481];
var inst_28484 = (new cljs.core.PersistentVector(null,2,(5),inst_28482,inst_28483,null));
var inst_28485 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28484,args);
var inst_28486 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_28485);
var state_28490__$1 = state_28490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28490__$1,(3),inst_28486);
} else {
if((state_val_28491 === (3))){
var inst_28488 = (state_28490[(2)]);
var state_28490__$1 = state_28490;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28490__$1,inst_28488);
} else {
return null;
}
}
}
});})(c__11625__auto__))
;
return ((function (switch__11560__auto__,c__11625__auto__){
return (function() {
var milia$api$async_export$state_machine__11561__auto__ = null;
var milia$api$async_export$state_machine__11561__auto____0 = (function (){
var statearr_28495 = [null,null,null,null,null,null,null];
(statearr_28495[(0)] = milia$api$async_export$state_machine__11561__auto__);

(statearr_28495[(1)] = (1));

return statearr_28495;
});
var milia$api$async_export$state_machine__11561__auto____1 = (function (state_28490){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28490);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28496){if((e28496 instanceof Object)){
var ex__11564__auto__ = e28496;
var statearr_28497_28502 = state_28490;
(statearr_28497_28502[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28490);

return cljs.core.constant$keyword$recur;
} else {
throw e28496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28503 = state_28490;
state_28490 = G__28503;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$async_export$state_machine__11561__auto__ = function(state_28490){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__11561__auto____1.call(this,state_28490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__11561__auto____0;
milia$api$async_export$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__11561__auto____1;
return milia$api$async_export$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__))
})();
var state__11627__auto__ = (function (){var statearr_28498 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_28498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__))
);

return c__11625__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq28475){
var G__28476 = cljs.core.first(seq28475);
var seq28475__$1 = cljs.core.next(seq28475);
var G__28477 = cljs.core.first(seq28475__$1);
var seq28475__$2 = cljs.core.next(seq28475__$1);
var G__28478 = cljs.core.first(seq28475__$2);
var seq28475__$3 = cljs.core.next(seq28475__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__28476,G__28477,G__28478,seq28475__$3);
});
