// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29419 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29419 = (function (fn_handler,f,meta29420){
this.fn_handler = fn_handler;
this.f = f;
this.meta29420 = meta29420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29421,meta29420__$1){
var self__ = this;
var _29421__$1 = this;
return (new cljs.core.async.t29419(self__.fn_handler,self__.f,meta29420__$1));
});

cljs.core.async.t29419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29421){
var self__ = this;
var _29421__$1 = this;
return self__.meta29420;
});

cljs.core.async.t29419.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29419.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29419.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29420","meta29420",218552068,null)], null);
});

cljs.core.async.t29419.cljs$lang$type = true;

cljs.core.async.t29419.cljs$lang$ctorStr = "cljs.core.async/t29419";

cljs.core.async.t29419.cljs$lang$ctorPrWriter = (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t29419");
});

cljs.core.async.__GT_t29419 = (function cljs$core$async$fn_handler_$___GT_t29419(fn_handler__$1,f__$1,meta29420){
return (new cljs.core.async.t29419(fn_handler__$1,f__$1,meta29420));
});

}

return (new cljs.core.async.t29419(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29424 = [];
var len__8975__auto___29427 = arguments.length;
var i__8976__auto___29428 = (0);
while(true){
if((i__8976__auto___29428 < len__8975__auto___29427)){
args29424.push((arguments[i__8976__auto___29428]));

var G__29429 = (i__8976__auto___29428 + (1));
i__8976__auto___29428 = G__29429;
continue;
} else {
}
break;
}

var G__29426 = args29424.length;
switch (G__29426) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29424.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29431 = [];
var len__8975__auto___29434 = arguments.length;
var i__8976__auto___29435 = (0);
while(true){
if((i__8976__auto___29435 < len__8975__auto___29434)){
args29431.push((arguments[i__8976__auto___29435]));

var G__29436 = (i__8976__auto___29435 + (1));
i__8976__auto___29435 = G__29436;
continue;
} else {
}
break;
}

var G__29433 = args29431.length;
switch (G__29433) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29431.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_29438 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29438) : fn1.call(null,val_29438));
} else {
cljs.core.async.impl.dispatch.run(((function (val_29438,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29438) : fn1.call(null,val_29438));
});})(val_29438,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29439 = [];
var len__8975__auto___29442 = arguments.length;
var i__8976__auto___29443 = (0);
while(true){
if((i__8976__auto___29443 < len__8975__auto___29442)){
args29439.push((arguments[i__8976__auto___29443]));

var G__29444 = (i__8976__auto___29443 + (1));
i__8976__auto___29443 = G__29444;
continue;
} else {
}
break;
}

var G__29441 = args29439.length;
switch (G__29441) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29439.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8820__auto___29446 = n;
var x_29447 = (0);
while(true){
if((x_29447 < n__8820__auto___29446)){
(a[x_29447] = (0));

var G__29448 = (x_29447 + (1));
x_29447 = G__29448;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__29449 = (i + (1));
i = G__29449;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t29453 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29453 = (function (alt_flag,flag,meta29454){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29454 = meta29454;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29455,meta29454__$1){
var self__ = this;
var _29455__$1 = this;
return (new cljs.core.async.t29453(self__.alt_flag,self__.flag,meta29454__$1));
});})(flag))
;

cljs.core.async.t29453.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29455){
var self__ = this;
var _29455__$1 = this;
return self__.meta29454;
});})(flag))
;

cljs.core.async.t29453.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29453.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t29453.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t29453.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29454","meta29454",206161266,null)], null);
});})(flag))
;

cljs.core.async.t29453.cljs$lang$type = true;

cljs.core.async.t29453.cljs$lang$ctorStr = "cljs.core.async/t29453";

cljs.core.async.t29453.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t29453");
});})(flag))
;

cljs.core.async.__GT_t29453 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29453(alt_flag__$1,flag__$1,meta29454){
return (new cljs.core.async.t29453(alt_flag__$1,flag__$1,meta29454));
});})(flag))
;

}

return (new cljs.core.async.t29453(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29459 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29459 = (function (alt_handler,flag,cb,meta29460){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29460 = meta29460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29461,meta29460__$1){
var self__ = this;
var _29461__$1 = this;
return (new cljs.core.async.t29459(self__.alt_handler,self__.flag,self__.cb,meta29460__$1));
});

cljs.core.async.t29459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29461){
var self__ = this;
var _29461__$1 = this;
return self__.meta29460;
});

cljs.core.async.t29459.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29459.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t29459.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t29459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29460","meta29460",478367966,null)], null);
});

cljs.core.async.t29459.cljs$lang$type = true;

cljs.core.async.t29459.cljs$lang$ctorStr = "cljs.core.async/t29459";

cljs.core.async.t29459.cljs$lang$ctorPrWriter = (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t29459");
});

cljs.core.async.__GT_t29459 = (function cljs$core$async$alt_handler_$___GT_t29459(alt_handler__$1,flag__$1,cb__$1,meta29460){
return (new cljs.core.async.t29459(alt_handler__$1,flag__$1,cb__$1,meta29460));
});

}

return (new cljs.core.async.t29459(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29462_SHARP_){
var G__29466 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29462_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29466) : fret.call(null,G__29466));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29463_SHARP_){
var G__29467 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29463_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29467) : fret.call(null,G__29467));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7936__auto__ = wport;
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29468 = (i + (1));
i = G__29468;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7936__auto__ = ret;
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__7924__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7924__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7924__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__8982__auto__ = [];
var len__8975__auto___29474 = arguments.length;
var i__8976__auto___29475 = (0);
while(true){
if((i__8976__auto___29475 < len__8975__auto___29474)){
args__8982__auto__.push((arguments[i__8976__auto___29475]));

var G__29476 = (i__8976__auto___29475 + (1));
i__8976__auto___29475 = G__29476;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29471){
var map__29472 = p__29471;
var map__29472__$1 = ((((!((map__29472 == null)))?((((map__29472.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29472.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29472):map__29472);
var opts = map__29472__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29469){
var G__29470 = cljs.core.first(seq29469);
var seq29469__$1 = cljs.core.next(seq29469);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29470,seq29469__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29477 = [];
var len__8975__auto___29527 = arguments.length;
var i__8976__auto___29528 = (0);
while(true){
if((i__8976__auto___29528 < len__8975__auto___29527)){
args29477.push((arguments[i__8976__auto___29528]));

var G__29529 = (i__8976__auto___29528 + (1));
i__8976__auto___29528 = G__29529;
continue;
} else {
}
break;
}

var G__29479 = args29477.length;
switch (G__29479) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29477.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11625__auto___29531 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___29531){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___29531){
return (function (state_29503){
var state_val_29504 = (state_29503[(1)]);
if((state_val_29504 === (7))){
var inst_29499 = (state_29503[(2)]);
var state_29503__$1 = state_29503;
var statearr_29505_29532 = state_29503__$1;
(statearr_29505_29532[(2)] = inst_29499);

(statearr_29505_29532[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (1))){
var state_29503__$1 = state_29503;
var statearr_29506_29533 = state_29503__$1;
(statearr_29506_29533[(2)] = null);

(statearr_29506_29533[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (4))){
var inst_29482 = (state_29503[(7)]);
var inst_29482__$1 = (state_29503[(2)]);
var inst_29483 = (inst_29482__$1 == null);
var state_29503__$1 = (function (){var statearr_29507 = state_29503;
(statearr_29507[(7)] = inst_29482__$1);

return statearr_29507;
})();
if(cljs.core.truth_(inst_29483)){
var statearr_29508_29534 = state_29503__$1;
(statearr_29508_29534[(1)] = (5));

} else {
var statearr_29509_29535 = state_29503__$1;
(statearr_29509_29535[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (13))){
var state_29503__$1 = state_29503;
var statearr_29510_29536 = state_29503__$1;
(statearr_29510_29536[(2)] = null);

(statearr_29510_29536[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (6))){
var inst_29482 = (state_29503[(7)]);
var state_29503__$1 = state_29503;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29503__$1,(11),to,inst_29482);
} else {
if((state_val_29504 === (3))){
var inst_29501 = (state_29503[(2)]);
var state_29503__$1 = state_29503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29503__$1,inst_29501);
} else {
if((state_val_29504 === (12))){
var state_29503__$1 = state_29503;
var statearr_29511_29537 = state_29503__$1;
(statearr_29511_29537[(2)] = null);

(statearr_29511_29537[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (2))){
var state_29503__$1 = state_29503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29503__$1,(4),from);
} else {
if((state_val_29504 === (11))){
var inst_29492 = (state_29503[(2)]);
var state_29503__$1 = state_29503;
if(cljs.core.truth_(inst_29492)){
var statearr_29512_29538 = state_29503__$1;
(statearr_29512_29538[(1)] = (12));

} else {
var statearr_29513_29539 = state_29503__$1;
(statearr_29513_29539[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (9))){
var state_29503__$1 = state_29503;
var statearr_29514_29540 = state_29503__$1;
(statearr_29514_29540[(2)] = null);

(statearr_29514_29540[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (5))){
var state_29503__$1 = state_29503;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29515_29541 = state_29503__$1;
(statearr_29515_29541[(1)] = (8));

} else {
var statearr_29516_29542 = state_29503__$1;
(statearr_29516_29542[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (14))){
var inst_29497 = (state_29503[(2)]);
var state_29503__$1 = state_29503;
var statearr_29517_29543 = state_29503__$1;
(statearr_29517_29543[(2)] = inst_29497);

(statearr_29517_29543[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (10))){
var inst_29489 = (state_29503[(2)]);
var state_29503__$1 = state_29503;
var statearr_29518_29544 = state_29503__$1;
(statearr_29518_29544[(2)] = inst_29489);

(statearr_29518_29544[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29504 === (8))){
var inst_29486 = cljs.core.async.close_BANG_(to);
var state_29503__$1 = state_29503;
var statearr_29519_29545 = state_29503__$1;
(statearr_29519_29545[(2)] = inst_29486);

(statearr_29519_29545[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___29531))
;
return ((function (switch__11560__auto__,c__11625__auto___29531){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_29523 = [null,null,null,null,null,null,null,null];
(statearr_29523[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_29523[(1)] = (1));

return statearr_29523;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_29503){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29503);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29524){if((e29524 instanceof Object)){
var ex__11564__auto__ = e29524;
var statearr_29525_29546 = state_29503;
(statearr_29525_29546[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29503);

return cljs.core.constant$keyword$recur;
} else {
throw e29524;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29547 = state_29503;
state_29503 = G__29547;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_29503){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_29503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___29531))
})();
var state__11627__auto__ = (function (){var statearr_29526 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29526[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___29531);

return statearr_29526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___29531))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29731){
var vec__29732 = p__29731;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29732,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29732,(1),null);
var job = vec__29732;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11625__auto___29914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results){
return (function (state_29737){
var state_val_29738 = (state_29737[(1)]);
if((state_val_29738 === (1))){
var state_29737__$1 = state_29737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29737__$1,(2),res,v);
} else {
if((state_val_29738 === (2))){
var inst_29734 = (state_29737[(2)]);
var inst_29735 = cljs.core.async.close_BANG_(res);
var state_29737__$1 = (function (){var statearr_29739 = state_29737;
(statearr_29739[(7)] = inst_29734);

return statearr_29739;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29737__$1,inst_29735);
} else {
return null;
}
}
});})(c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results))
;
return ((function (switch__11560__auto__,c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_29743 = [null,null,null,null,null,null,null,null];
(statearr_29743[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_29743[(1)] = (1));

return statearr_29743;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_29737){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29737);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29744){if((e29744 instanceof Object)){
var ex__11564__auto__ = e29744;
var statearr_29745_29915 = state_29737;
(statearr_29745_29915[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29737);

return cljs.core.constant$keyword$recur;
} else {
throw e29744;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29916 = state_29737;
state_29737 = G__29916;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_29737){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_29737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results))
})();
var state__11627__auto__ = (function (){var statearr_29746 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29746[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___29914);

return statearr_29746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___29914,res,vec__29732,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29747){
var vec__29748 = p__29747;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29748,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29748,(1),null);
var job = vec__29748;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8820__auto___29917 = n;
var __29918 = (0);
while(true){
if((__29918 < n__8820__auto___29917)){
var G__29749_29919 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29749_29919) {
case "compute":
var c__11625__auto___29921 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29918,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (__29918,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function (state_29762){
var state_val_29763 = (state_29762[(1)]);
if((state_val_29763 === (1))){
var state_29762__$1 = state_29762;
var statearr_29764_29922 = state_29762__$1;
(statearr_29764_29922[(2)] = null);

(statearr_29764_29922[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29763 === (2))){
var state_29762__$1 = state_29762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29762__$1,(4),jobs);
} else {
if((state_val_29763 === (3))){
var inst_29760 = (state_29762[(2)]);
var state_29762__$1 = state_29762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29762__$1,inst_29760);
} else {
if((state_val_29763 === (4))){
var inst_29752 = (state_29762[(2)]);
var inst_29753 = process(inst_29752);
var state_29762__$1 = state_29762;
if(cljs.core.truth_(inst_29753)){
var statearr_29765_29923 = state_29762__$1;
(statearr_29765_29923[(1)] = (5));

} else {
var statearr_29766_29924 = state_29762__$1;
(statearr_29766_29924[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29763 === (5))){
var state_29762__$1 = state_29762;
var statearr_29767_29925 = state_29762__$1;
(statearr_29767_29925[(2)] = null);

(statearr_29767_29925[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29763 === (6))){
var state_29762__$1 = state_29762;
var statearr_29768_29926 = state_29762__$1;
(statearr_29768_29926[(2)] = null);

(statearr_29768_29926[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29763 === (7))){
var inst_29758 = (state_29762[(2)]);
var state_29762__$1 = state_29762;
var statearr_29769_29927 = state_29762__$1;
(statearr_29769_29927[(2)] = inst_29758);

(statearr_29769_29927[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29918,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
;
return ((function (__29918,switch__11560__auto__,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_29773 = [null,null,null,null,null,null,null];
(statearr_29773[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_29773[(1)] = (1));

return statearr_29773;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_29762){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29762);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29774){if((e29774 instanceof Object)){
var ex__11564__auto__ = e29774;
var statearr_29775_29928 = state_29762;
(statearr_29775_29928[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29762);

return cljs.core.constant$keyword$recur;
} else {
throw e29774;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29929 = state_29762;
state_29762 = G__29929;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_29762){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_29762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(__29918,switch__11560__auto__,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
})();
var state__11627__auto__ = (function (){var statearr_29776 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___29921);

return statearr_29776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(__29918,c__11625__auto___29921,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
);


break;
case "async":
var c__11625__auto___29930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29918,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (__29918,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function (state_29789){
var state_val_29790 = (state_29789[(1)]);
if((state_val_29790 === (1))){
var state_29789__$1 = state_29789;
var statearr_29791_29931 = state_29789__$1;
(statearr_29791_29931[(2)] = null);

(statearr_29791_29931[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (2))){
var state_29789__$1 = state_29789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29789__$1,(4),jobs);
} else {
if((state_val_29790 === (3))){
var inst_29787 = (state_29789[(2)]);
var state_29789__$1 = state_29789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29789__$1,inst_29787);
} else {
if((state_val_29790 === (4))){
var inst_29779 = (state_29789[(2)]);
var inst_29780 = async(inst_29779);
var state_29789__$1 = state_29789;
if(cljs.core.truth_(inst_29780)){
var statearr_29792_29932 = state_29789__$1;
(statearr_29792_29932[(1)] = (5));

} else {
var statearr_29793_29933 = state_29789__$1;
(statearr_29793_29933[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (5))){
var state_29789__$1 = state_29789;
var statearr_29794_29934 = state_29789__$1;
(statearr_29794_29934[(2)] = null);

(statearr_29794_29934[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (6))){
var state_29789__$1 = state_29789;
var statearr_29795_29935 = state_29789__$1;
(statearr_29795_29935[(2)] = null);

(statearr_29795_29935[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (7))){
var inst_29785 = (state_29789[(2)]);
var state_29789__$1 = state_29789;
var statearr_29796_29936 = state_29789__$1;
(statearr_29796_29936[(2)] = inst_29785);

(statearr_29796_29936[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29918,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
;
return ((function (__29918,switch__11560__auto__,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_29800 = [null,null,null,null,null,null,null];
(statearr_29800[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_29800[(1)] = (1));

return statearr_29800;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_29789){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29789);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29801){if((e29801 instanceof Object)){
var ex__11564__auto__ = e29801;
var statearr_29802_29937 = state_29789;
(statearr_29802_29937[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29789);

return cljs.core.constant$keyword$recur;
} else {
throw e29801;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29938 = state_29789;
state_29789 = G__29938;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_29789){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_29789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(__29918,switch__11560__auto__,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
})();
var state__11627__auto__ = (function (){var statearr_29803 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___29930);

return statearr_29803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(__29918,c__11625__auto___29930,G__29749_29919,n__8820__auto___29917,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29939 = (__29918 + (1));
__29918 = G__29939;
continue;
} else {
}
break;
}

var c__11625__auto___29940 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___29940,jobs,results,process,async){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___29940,jobs,results,process,async){
return (function (state_29825){
var state_val_29826 = (state_29825[(1)]);
if((state_val_29826 === (1))){
var state_29825__$1 = state_29825;
var statearr_29827_29941 = state_29825__$1;
(statearr_29827_29941[(2)] = null);

(statearr_29827_29941[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29826 === (2))){
var state_29825__$1 = state_29825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29825__$1,(4),from);
} else {
if((state_val_29826 === (3))){
var inst_29823 = (state_29825[(2)]);
var state_29825__$1 = state_29825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29825__$1,inst_29823);
} else {
if((state_val_29826 === (4))){
var inst_29806 = (state_29825[(7)]);
var inst_29806__$1 = (state_29825[(2)]);
var inst_29807 = (inst_29806__$1 == null);
var state_29825__$1 = (function (){var statearr_29828 = state_29825;
(statearr_29828[(7)] = inst_29806__$1);

return statearr_29828;
})();
if(cljs.core.truth_(inst_29807)){
var statearr_29829_29942 = state_29825__$1;
(statearr_29829_29942[(1)] = (5));

} else {
var statearr_29830_29943 = state_29825__$1;
(statearr_29830_29943[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29826 === (5))){
var inst_29809 = cljs.core.async.close_BANG_(jobs);
var state_29825__$1 = state_29825;
var statearr_29831_29944 = state_29825__$1;
(statearr_29831_29944[(2)] = inst_29809);

(statearr_29831_29944[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29826 === (6))){
var inst_29806 = (state_29825[(7)]);
var inst_29811 = (state_29825[(8)]);
var inst_29811__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29813 = [inst_29806,inst_29811__$1];
var inst_29814 = (new cljs.core.PersistentVector(null,2,(5),inst_29812,inst_29813,null));
var state_29825__$1 = (function (){var statearr_29832 = state_29825;
(statearr_29832[(8)] = inst_29811__$1);

return statearr_29832;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29825__$1,(8),jobs,inst_29814);
} else {
if((state_val_29826 === (7))){
var inst_29821 = (state_29825[(2)]);
var state_29825__$1 = state_29825;
var statearr_29833_29945 = state_29825__$1;
(statearr_29833_29945[(2)] = inst_29821);

(statearr_29833_29945[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29826 === (8))){
var inst_29811 = (state_29825[(8)]);
var inst_29816 = (state_29825[(2)]);
var state_29825__$1 = (function (){var statearr_29834 = state_29825;
(statearr_29834[(9)] = inst_29816);

return statearr_29834;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29825__$1,(9),results,inst_29811);
} else {
if((state_val_29826 === (9))){
var inst_29818 = (state_29825[(2)]);
var state_29825__$1 = (function (){var statearr_29835 = state_29825;
(statearr_29835[(10)] = inst_29818);

return statearr_29835;
})();
var statearr_29836_29946 = state_29825__$1;
(statearr_29836_29946[(2)] = null);

(statearr_29836_29946[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___29940,jobs,results,process,async))
;
return ((function (switch__11560__auto__,c__11625__auto___29940,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_29840 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29840[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_29840[(1)] = (1));

return statearr_29840;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_29825){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29825);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29841){if((e29841 instanceof Object)){
var ex__11564__auto__ = e29841;
var statearr_29842_29947 = state_29825;
(statearr_29842_29947[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29825);

return cljs.core.constant$keyword$recur;
} else {
throw e29841;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29948 = state_29825;
state_29825 = G__29948;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_29825){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_29825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___29940,jobs,results,process,async))
})();
var state__11627__auto__ = (function (){var statearr_29843 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29843[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___29940);

return statearr_29843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___29940,jobs,results,process,async))
);


var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__,jobs,results,process,async){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__,jobs,results,process,async){
return (function (state_29881){
var state_val_29882 = (state_29881[(1)]);
if((state_val_29882 === (7))){
var inst_29877 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
var statearr_29883_29949 = state_29881__$1;
(statearr_29883_29949[(2)] = inst_29877);

(statearr_29883_29949[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (20))){
var state_29881__$1 = state_29881;
var statearr_29884_29950 = state_29881__$1;
(statearr_29884_29950[(2)] = null);

(statearr_29884_29950[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (1))){
var state_29881__$1 = state_29881;
var statearr_29885_29951 = state_29881__$1;
(statearr_29885_29951[(2)] = null);

(statearr_29885_29951[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (4))){
var inst_29846 = (state_29881[(7)]);
var inst_29846__$1 = (state_29881[(2)]);
var inst_29847 = (inst_29846__$1 == null);
var state_29881__$1 = (function (){var statearr_29886 = state_29881;
(statearr_29886[(7)] = inst_29846__$1);

return statearr_29886;
})();
if(cljs.core.truth_(inst_29847)){
var statearr_29887_29952 = state_29881__$1;
(statearr_29887_29952[(1)] = (5));

} else {
var statearr_29888_29953 = state_29881__$1;
(statearr_29888_29953[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (15))){
var inst_29859 = (state_29881[(8)]);
var state_29881__$1 = state_29881;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29881__$1,(18),to,inst_29859);
} else {
if((state_val_29882 === (21))){
var inst_29872 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
var statearr_29889_29954 = state_29881__$1;
(statearr_29889_29954[(2)] = inst_29872);

(statearr_29889_29954[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (13))){
var inst_29874 = (state_29881[(2)]);
var state_29881__$1 = (function (){var statearr_29890 = state_29881;
(statearr_29890[(9)] = inst_29874);

return statearr_29890;
})();
var statearr_29891_29955 = state_29881__$1;
(statearr_29891_29955[(2)] = null);

(statearr_29891_29955[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (6))){
var inst_29846 = (state_29881[(7)]);
var state_29881__$1 = state_29881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29881__$1,(11),inst_29846);
} else {
if((state_val_29882 === (17))){
var inst_29867 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
if(cljs.core.truth_(inst_29867)){
var statearr_29892_29956 = state_29881__$1;
(statearr_29892_29956[(1)] = (19));

} else {
var statearr_29893_29957 = state_29881__$1;
(statearr_29893_29957[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (3))){
var inst_29879 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29881__$1,inst_29879);
} else {
if((state_val_29882 === (12))){
var inst_29856 = (state_29881[(10)]);
var state_29881__$1 = state_29881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29881__$1,(14),inst_29856);
} else {
if((state_val_29882 === (2))){
var state_29881__$1 = state_29881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29881__$1,(4),results);
} else {
if((state_val_29882 === (19))){
var state_29881__$1 = state_29881;
var statearr_29894_29958 = state_29881__$1;
(statearr_29894_29958[(2)] = null);

(statearr_29894_29958[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (11))){
var inst_29856 = (state_29881[(2)]);
var state_29881__$1 = (function (){var statearr_29895 = state_29881;
(statearr_29895[(10)] = inst_29856);

return statearr_29895;
})();
var statearr_29896_29959 = state_29881__$1;
(statearr_29896_29959[(2)] = null);

(statearr_29896_29959[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (9))){
var state_29881__$1 = state_29881;
var statearr_29897_29960 = state_29881__$1;
(statearr_29897_29960[(2)] = null);

(statearr_29897_29960[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (5))){
var state_29881__$1 = state_29881;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29898_29961 = state_29881__$1;
(statearr_29898_29961[(1)] = (8));

} else {
var statearr_29899_29962 = state_29881__$1;
(statearr_29899_29962[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (14))){
var inst_29861 = (state_29881[(11)]);
var inst_29859 = (state_29881[(8)]);
var inst_29859__$1 = (state_29881[(2)]);
var inst_29860 = (inst_29859__$1 == null);
var inst_29861__$1 = cljs.core.not(inst_29860);
var state_29881__$1 = (function (){var statearr_29900 = state_29881;
(statearr_29900[(11)] = inst_29861__$1);

(statearr_29900[(8)] = inst_29859__$1);

return statearr_29900;
})();
if(inst_29861__$1){
var statearr_29901_29963 = state_29881__$1;
(statearr_29901_29963[(1)] = (15));

} else {
var statearr_29902_29964 = state_29881__$1;
(statearr_29902_29964[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (16))){
var inst_29861 = (state_29881[(11)]);
var state_29881__$1 = state_29881;
var statearr_29903_29965 = state_29881__$1;
(statearr_29903_29965[(2)] = inst_29861);

(statearr_29903_29965[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (10))){
var inst_29853 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
var statearr_29904_29966 = state_29881__$1;
(statearr_29904_29966[(2)] = inst_29853);

(statearr_29904_29966[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (18))){
var inst_29864 = (state_29881[(2)]);
var state_29881__$1 = state_29881;
var statearr_29905_29967 = state_29881__$1;
(statearr_29905_29967[(2)] = inst_29864);

(statearr_29905_29967[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29882 === (8))){
var inst_29850 = cljs.core.async.close_BANG_(to);
var state_29881__$1 = state_29881;
var statearr_29906_29968 = state_29881__$1;
(statearr_29906_29968[(2)] = inst_29850);

(statearr_29906_29968[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto__,jobs,results,process,async))
;
return ((function (switch__11560__auto__,c__11625__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_29910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29910[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_29910[(1)] = (1));

return statearr_29910;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_29881){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_29881);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e29911){if((e29911 instanceof Object)){
var ex__11564__auto__ = e29911;
var statearr_29912_29969 = state_29881;
(statearr_29912_29969[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29881);

return cljs.core.constant$keyword$recur;
} else {
throw e29911;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__29970 = state_29881;
state_29881 = G__29970;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_29881){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_29881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__,jobs,results,process,async))
})();
var state__11627__auto__ = (function (){var statearr_29913 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_29913[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_29913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__,jobs,results,process,async))
);

return c__11625__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args29971 = [];
var len__8975__auto___29974 = arguments.length;
var i__8976__auto___29975 = (0);
while(true){
if((i__8976__auto___29975 < len__8975__auto___29974)){
args29971.push((arguments[i__8976__auto___29975]));

var G__29976 = (i__8976__auto___29975 + (1));
i__8976__auto___29975 = G__29976;
continue;
} else {
}
break;
}

var G__29973 = args29971.length;
switch (G__29973) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29971.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args29978 = [];
var len__8975__auto___29981 = arguments.length;
var i__8976__auto___29982 = (0);
while(true){
if((i__8976__auto___29982 < len__8975__auto___29981)){
args29978.push((arguments[i__8976__auto___29982]));

var G__29983 = (i__8976__auto___29982 + (1));
i__8976__auto___29982 = G__29983;
continue;
} else {
}
break;
}

var G__29980 = args29978.length;
switch (G__29980) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29978.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args29985 = [];
var len__8975__auto___30038 = arguments.length;
var i__8976__auto___30039 = (0);
while(true){
if((i__8976__auto___30039 < len__8975__auto___30038)){
args29985.push((arguments[i__8976__auto___30039]));

var G__30040 = (i__8976__auto___30039 + (1));
i__8976__auto___30039 = G__30040;
continue;
} else {
}
break;
}

var G__29987 = args29985.length;
switch (G__29987) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29985.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11625__auto___30042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___30042,tc,fc){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___30042,tc,fc){
return (function (state_30013){
var state_val_30014 = (state_30013[(1)]);
if((state_val_30014 === (7))){
var inst_30009 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
var statearr_30015_30043 = state_30013__$1;
(statearr_30015_30043[(2)] = inst_30009);

(statearr_30015_30043[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (1))){
var state_30013__$1 = state_30013;
var statearr_30016_30044 = state_30013__$1;
(statearr_30016_30044[(2)] = null);

(statearr_30016_30044[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (4))){
var inst_29990 = (state_30013[(7)]);
var inst_29990__$1 = (state_30013[(2)]);
var inst_29991 = (inst_29990__$1 == null);
var state_30013__$1 = (function (){var statearr_30017 = state_30013;
(statearr_30017[(7)] = inst_29990__$1);

return statearr_30017;
})();
if(cljs.core.truth_(inst_29991)){
var statearr_30018_30045 = state_30013__$1;
(statearr_30018_30045[(1)] = (5));

} else {
var statearr_30019_30046 = state_30013__$1;
(statearr_30019_30046[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (13))){
var state_30013__$1 = state_30013;
var statearr_30020_30047 = state_30013__$1;
(statearr_30020_30047[(2)] = null);

(statearr_30020_30047[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (6))){
var inst_29990 = (state_30013[(7)]);
var inst_29996 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29990) : p.call(null,inst_29990));
var state_30013__$1 = state_30013;
if(cljs.core.truth_(inst_29996)){
var statearr_30021_30048 = state_30013__$1;
(statearr_30021_30048[(1)] = (9));

} else {
var statearr_30022_30049 = state_30013__$1;
(statearr_30022_30049[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (3))){
var inst_30011 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30013__$1,inst_30011);
} else {
if((state_val_30014 === (12))){
var state_30013__$1 = state_30013;
var statearr_30023_30050 = state_30013__$1;
(statearr_30023_30050[(2)] = null);

(statearr_30023_30050[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (2))){
var state_30013__$1 = state_30013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30013__$1,(4),ch);
} else {
if((state_val_30014 === (11))){
var inst_29990 = (state_30013[(7)]);
var inst_30000 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30013__$1,(8),inst_30000,inst_29990);
} else {
if((state_val_30014 === (9))){
var state_30013__$1 = state_30013;
var statearr_30024_30051 = state_30013__$1;
(statearr_30024_30051[(2)] = tc);

(statearr_30024_30051[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (5))){
var inst_29993 = cljs.core.async.close_BANG_(tc);
var inst_29994 = cljs.core.async.close_BANG_(fc);
var state_30013__$1 = (function (){var statearr_30025 = state_30013;
(statearr_30025[(8)] = inst_29993);

return statearr_30025;
})();
var statearr_30026_30052 = state_30013__$1;
(statearr_30026_30052[(2)] = inst_29994);

(statearr_30026_30052[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (14))){
var inst_30007 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
var statearr_30027_30053 = state_30013__$1;
(statearr_30027_30053[(2)] = inst_30007);

(statearr_30027_30053[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (10))){
var state_30013__$1 = state_30013;
var statearr_30028_30054 = state_30013__$1;
(statearr_30028_30054[(2)] = fc);

(statearr_30028_30054[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30014 === (8))){
var inst_30002 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
if(cljs.core.truth_(inst_30002)){
var statearr_30029_30055 = state_30013__$1;
(statearr_30029_30055[(1)] = (12));

} else {
var statearr_30030_30056 = state_30013__$1;
(statearr_30030_30056[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___30042,tc,fc))
;
return ((function (switch__11560__auto__,c__11625__auto___30042,tc,fc){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_30034 = [null,null,null,null,null,null,null,null,null];
(statearr_30034[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_30034[(1)] = (1));

return statearr_30034;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_30013){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_30013);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e30035){if((e30035 instanceof Object)){
var ex__11564__auto__ = e30035;
var statearr_30036_30057 = state_30013;
(statearr_30036_30057[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30013);

return cljs.core.constant$keyword$recur;
} else {
throw e30035;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__30058 = state_30013;
state_30013 = G__30058;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_30013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_30013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___30042,tc,fc))
})();
var state__11627__auto__ = (function (){var statearr_30037 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_30037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___30042);

return statearr_30037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___30042,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__){
return (function (state_30105){
var state_val_30106 = (state_30105[(1)]);
if((state_val_30106 === (1))){
var inst_30091 = init;
var state_30105__$1 = (function (){var statearr_30107 = state_30105;
(statearr_30107[(7)] = inst_30091);

return statearr_30107;
})();
var statearr_30108_30123 = state_30105__$1;
(statearr_30108_30123[(2)] = null);

(statearr_30108_30123[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30106 === (2))){
var state_30105__$1 = state_30105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30105__$1,(4),ch);
} else {
if((state_val_30106 === (3))){
var inst_30103 = (state_30105[(2)]);
var state_30105__$1 = state_30105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30105__$1,inst_30103);
} else {
if((state_val_30106 === (4))){
var inst_30094 = (state_30105[(8)]);
var inst_30094__$1 = (state_30105[(2)]);
var inst_30095 = (inst_30094__$1 == null);
var state_30105__$1 = (function (){var statearr_30109 = state_30105;
(statearr_30109[(8)] = inst_30094__$1);

return statearr_30109;
})();
if(cljs.core.truth_(inst_30095)){
var statearr_30110_30124 = state_30105__$1;
(statearr_30110_30124[(1)] = (5));

} else {
var statearr_30111_30125 = state_30105__$1;
(statearr_30111_30125[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30106 === (5))){
var inst_30091 = (state_30105[(7)]);
var state_30105__$1 = state_30105;
var statearr_30112_30126 = state_30105__$1;
(statearr_30112_30126[(2)] = inst_30091);

(statearr_30112_30126[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30106 === (6))){
var inst_30094 = (state_30105[(8)]);
var inst_30091 = (state_30105[(7)]);
var inst_30098 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30091,inst_30094) : f.call(null,inst_30091,inst_30094));
var inst_30091__$1 = inst_30098;
var state_30105__$1 = (function (){var statearr_30113 = state_30105;
(statearr_30113[(7)] = inst_30091__$1);

return statearr_30113;
})();
var statearr_30114_30127 = state_30105__$1;
(statearr_30114_30127[(2)] = null);

(statearr_30114_30127[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30106 === (7))){
var inst_30101 = (state_30105[(2)]);
var state_30105__$1 = state_30105;
var statearr_30115_30128 = state_30105__$1;
(statearr_30115_30128[(2)] = inst_30101);

(statearr_30115_30128[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11625__auto__))
;
return ((function (switch__11560__auto__,c__11625__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11561__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11561__auto____0 = (function (){
var statearr_30119 = [null,null,null,null,null,null,null,null,null];
(statearr_30119[(0)] = cljs$core$async$reduce_$_state_machine__11561__auto__);

(statearr_30119[(1)] = (1));

return statearr_30119;
});
var cljs$core$async$reduce_$_state_machine__11561__auto____1 = (function (state_30105){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_30105);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e30120){if((e30120 instanceof Object)){
var ex__11564__auto__ = e30120;
var statearr_30121_30129 = state_30105;
(statearr_30121_30129[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30105);

return cljs.core.constant$keyword$recur;
} else {
throw e30120;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__30130 = state_30105;
state_30105 = G__30130;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11561__auto__ = function(state_30105){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11561__auto____1.call(this,state_30105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11561__auto____0;
cljs$core$async$reduce_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11561__auto____1;
return cljs$core$async$reduce_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__))
})();
var state__11627__auto__ = (function (){var statearr_30122 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_30122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_30122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__))
);

return c__11625__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args30131 = [];
var len__8975__auto___30183 = arguments.length;
var i__8976__auto___30184 = (0);
while(true){
if((i__8976__auto___30184 < len__8975__auto___30183)){
args30131.push((arguments[i__8976__auto___30184]));

var G__30185 = (i__8976__auto___30184 + (1));
i__8976__auto___30184 = G__30185;
continue;
} else {
}
break;
}

var G__30133 = args30131.length;
switch (G__30133) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30131.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__){
return (function (state_30158){
var state_val_30159 = (state_30158[(1)]);
if((state_val_30159 === (7))){
var inst_30140 = (state_30158[(2)]);
var state_30158__$1 = state_30158;
var statearr_30160_30187 = state_30158__$1;
(statearr_30160_30187[(2)] = inst_30140);

(statearr_30160_30187[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (1))){
var inst_30134 = cljs.core.seq(coll);
var inst_30135 = inst_30134;
var state_30158__$1 = (function (){var statearr_30161 = state_30158;
(statearr_30161[(7)] = inst_30135);

return statearr_30161;
})();
var statearr_30162_30188 = state_30158__$1;
(statearr_30162_30188[(2)] = null);

(statearr_30162_30188[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (4))){
var inst_30135 = (state_30158[(7)]);
var inst_30138 = cljs.core.first(inst_30135);
var state_30158__$1 = state_30158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30158__$1,(7),ch,inst_30138);
} else {
if((state_val_30159 === (13))){
var inst_30152 = (state_30158[(2)]);
var state_30158__$1 = state_30158;
var statearr_30163_30189 = state_30158__$1;
(statearr_30163_30189[(2)] = inst_30152);

(statearr_30163_30189[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (6))){
var inst_30143 = (state_30158[(2)]);
var state_30158__$1 = state_30158;
if(cljs.core.truth_(inst_30143)){
var statearr_30164_30190 = state_30158__$1;
(statearr_30164_30190[(1)] = (8));

} else {
var statearr_30165_30191 = state_30158__$1;
(statearr_30165_30191[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (3))){
var inst_30156 = (state_30158[(2)]);
var state_30158__$1 = state_30158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30158__$1,inst_30156);
} else {
if((state_val_30159 === (12))){
var state_30158__$1 = state_30158;
var statearr_30166_30192 = state_30158__$1;
(statearr_30166_30192[(2)] = null);

(statearr_30166_30192[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (2))){
var inst_30135 = (state_30158[(7)]);
var state_30158__$1 = state_30158;
if(cljs.core.truth_(inst_30135)){
var statearr_30167_30193 = state_30158__$1;
(statearr_30167_30193[(1)] = (4));

} else {
var statearr_30168_30194 = state_30158__$1;
(statearr_30168_30194[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (11))){
var inst_30149 = cljs.core.async.close_BANG_(ch);
var state_30158__$1 = state_30158;
var statearr_30169_30195 = state_30158__$1;
(statearr_30169_30195[(2)] = inst_30149);

(statearr_30169_30195[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (9))){
var state_30158__$1 = state_30158;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30170_30196 = state_30158__$1;
(statearr_30170_30196[(1)] = (11));

} else {
var statearr_30171_30197 = state_30158__$1;
(statearr_30171_30197[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (5))){
var inst_30135 = (state_30158[(7)]);
var state_30158__$1 = state_30158;
var statearr_30172_30198 = state_30158__$1;
(statearr_30172_30198[(2)] = inst_30135);

(statearr_30172_30198[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (10))){
var inst_30154 = (state_30158[(2)]);
var state_30158__$1 = state_30158;
var statearr_30173_30199 = state_30158__$1;
(statearr_30173_30199[(2)] = inst_30154);

(statearr_30173_30199[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30159 === (8))){
var inst_30135 = (state_30158[(7)]);
var inst_30145 = cljs.core.next(inst_30135);
var inst_30135__$1 = inst_30145;
var state_30158__$1 = (function (){var statearr_30174 = state_30158;
(statearr_30174[(7)] = inst_30135__$1);

return statearr_30174;
})();
var statearr_30175_30200 = state_30158__$1;
(statearr_30175_30200[(2)] = null);

(statearr_30175_30200[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto__))
;
return ((function (switch__11560__auto__,c__11625__auto__){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_30179 = [null,null,null,null,null,null,null,null];
(statearr_30179[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_30179[(1)] = (1));

return statearr_30179;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_30158){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_30158);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e30180){if((e30180 instanceof Object)){
var ex__11564__auto__ = e30180;
var statearr_30181_30201 = state_30158;
(statearr_30181_30201[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30158);

return cljs.core.constant$keyword$recur;
} else {
throw e30180;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__30202 = state_30158;
state_30158 = G__30202;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_30158){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_30158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__))
})();
var state__11627__auto__ = (function (){var statearr_30182 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_30182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_30182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__))
);

return c__11625__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8572__auto__ = (((_ == null))?null:_);
var m__8573__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8573__auto__.call(null,_));
} else {
var m__8573__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8573__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8573__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8573__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8573__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto__.call(null,m,ch));
} else {
var m__8573__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8573__auto__.call(null,m));
} else {
var m__8573__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8573__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__30431 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30431) : cljs.core.atom.call(null,G__30431));
})();
var m = (function (){
if(typeof cljs.core.async.t30432 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30432 = (function (mult,ch,cs,meta30433){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30433 = meta30433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30434,meta30433__$1){
var self__ = this;
var _30434__$1 = this;
return (new cljs.core.async.t30432(self__.mult,self__.ch,self__.cs,meta30433__$1));
});})(cs))
;

cljs.core.async.t30432.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30434){
var self__ = this;
var _30434__$1 = this;
return self__.meta30433;
});})(cs))
;

cljs.core.async.t30432.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30432.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30432.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30432.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30432.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30432.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30435_30655 = self__.cs;
var G__30436_30656 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30435_30655,G__30436_30656) : cljs.core.reset_BANG_.call(null,G__30435_30655,G__30436_30656));

return null;
});})(cs))
;

cljs.core.async.t30432.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30433","meta30433",661195478,null)], null);
});})(cs))
;

cljs.core.async.t30432.cljs$lang$type = true;

cljs.core.async.t30432.cljs$lang$ctorStr = "cljs.core.async/t30432";

cljs.core.async.t30432.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t30432");
});})(cs))
;

cljs.core.async.__GT_t30432 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30432(mult__$1,ch__$1,cs__$1,meta30433){
return (new cljs.core.async.t30432(mult__$1,ch__$1,cs__$1,meta30433));
});})(cs))
;

}

return (new cljs.core.async.t30432(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11625__auto___30657 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___30657,cs,m,dchan,dctr,done){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___30657,cs,m,dchan,dctr,done){
return (function (state_30567){
var state_val_30568 = (state_30567[(1)]);
if((state_val_30568 === (7))){
var inst_30563 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30569_30658 = state_30567__$1;
(statearr_30569_30658[(2)] = inst_30563);

(statearr_30569_30658[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (20))){
var inst_30468 = (state_30567[(7)]);
var inst_30478 = cljs.core.first(inst_30468);
var inst_30479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30478,(0),null);
var inst_30480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30478,(1),null);
var state_30567__$1 = (function (){var statearr_30570 = state_30567;
(statearr_30570[(8)] = inst_30479);

return statearr_30570;
})();
if(cljs.core.truth_(inst_30480)){
var statearr_30571_30659 = state_30567__$1;
(statearr_30571_30659[(1)] = (22));

} else {
var statearr_30572_30660 = state_30567__$1;
(statearr_30572_30660[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (27))){
var inst_30508 = (state_30567[(9)]);
var inst_30515 = (state_30567[(10)]);
var inst_30510 = (state_30567[(11)]);
var inst_30439 = (state_30567[(12)]);
var inst_30515__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30508,inst_30510);
var inst_30516 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30515__$1,inst_30439,done);
var state_30567__$1 = (function (){var statearr_30573 = state_30567;
(statearr_30573[(10)] = inst_30515__$1);

return statearr_30573;
})();
if(cljs.core.truth_(inst_30516)){
var statearr_30574_30661 = state_30567__$1;
(statearr_30574_30661[(1)] = (30));

} else {
var statearr_30575_30662 = state_30567__$1;
(statearr_30575_30662[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (1))){
var state_30567__$1 = state_30567;
var statearr_30576_30663 = state_30567__$1;
(statearr_30576_30663[(2)] = null);

(statearr_30576_30663[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (24))){
var inst_30468 = (state_30567[(7)]);
var inst_30485 = (state_30567[(2)]);
var inst_30486 = cljs.core.next(inst_30468);
var inst_30448 = inst_30486;
var inst_30449 = null;
var inst_30450 = (0);
var inst_30451 = (0);
var state_30567__$1 = (function (){var statearr_30577 = state_30567;
(statearr_30577[(13)] = inst_30485);

(statearr_30577[(14)] = inst_30449);

(statearr_30577[(15)] = inst_30451);

(statearr_30577[(16)] = inst_30448);

(statearr_30577[(17)] = inst_30450);

return statearr_30577;
})();
var statearr_30578_30664 = state_30567__$1;
(statearr_30578_30664[(2)] = null);

(statearr_30578_30664[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (39))){
var state_30567__$1 = state_30567;
var statearr_30582_30665 = state_30567__$1;
(statearr_30582_30665[(2)] = null);

(statearr_30582_30665[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (4))){
var inst_30439 = (state_30567[(12)]);
var inst_30439__$1 = (state_30567[(2)]);
var inst_30440 = (inst_30439__$1 == null);
var state_30567__$1 = (function (){var statearr_30583 = state_30567;
(statearr_30583[(12)] = inst_30439__$1);

return statearr_30583;
})();
if(cljs.core.truth_(inst_30440)){
var statearr_30584_30666 = state_30567__$1;
(statearr_30584_30666[(1)] = (5));

} else {
var statearr_30585_30667 = state_30567__$1;
(statearr_30585_30667[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (15))){
var inst_30449 = (state_30567[(14)]);
var inst_30451 = (state_30567[(15)]);
var inst_30448 = (state_30567[(16)]);
var inst_30450 = (state_30567[(17)]);
var inst_30464 = (state_30567[(2)]);
var inst_30465 = (inst_30451 + (1));
var tmp30579 = inst_30449;
var tmp30580 = inst_30448;
var tmp30581 = inst_30450;
var inst_30448__$1 = tmp30580;
var inst_30449__$1 = tmp30579;
var inst_30450__$1 = tmp30581;
var inst_30451__$1 = inst_30465;
var state_30567__$1 = (function (){var statearr_30586 = state_30567;
(statearr_30586[(14)] = inst_30449__$1);

(statearr_30586[(15)] = inst_30451__$1);

(statearr_30586[(16)] = inst_30448__$1);

(statearr_30586[(17)] = inst_30450__$1);

(statearr_30586[(18)] = inst_30464);

return statearr_30586;
})();
var statearr_30587_30668 = state_30567__$1;
(statearr_30587_30668[(2)] = null);

(statearr_30587_30668[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (21))){
var inst_30489 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30591_30669 = state_30567__$1;
(statearr_30591_30669[(2)] = inst_30489);

(statearr_30591_30669[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (31))){
var inst_30515 = (state_30567[(10)]);
var inst_30519 = done(null);
var inst_30520 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30515);
var state_30567__$1 = (function (){var statearr_30592 = state_30567;
(statearr_30592[(19)] = inst_30519);

return statearr_30592;
})();
var statearr_30593_30670 = state_30567__$1;
(statearr_30593_30670[(2)] = inst_30520);

(statearr_30593_30670[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (32))){
var inst_30508 = (state_30567[(9)]);
var inst_30509 = (state_30567[(20)]);
var inst_30507 = (state_30567[(21)]);
var inst_30510 = (state_30567[(11)]);
var inst_30522 = (state_30567[(2)]);
var inst_30523 = (inst_30510 + (1));
var tmp30588 = inst_30508;
var tmp30589 = inst_30509;
var tmp30590 = inst_30507;
var inst_30507__$1 = tmp30590;
var inst_30508__$1 = tmp30588;
var inst_30509__$1 = tmp30589;
var inst_30510__$1 = inst_30523;
var state_30567__$1 = (function (){var statearr_30594 = state_30567;
(statearr_30594[(22)] = inst_30522);

(statearr_30594[(9)] = inst_30508__$1);

(statearr_30594[(20)] = inst_30509__$1);

(statearr_30594[(21)] = inst_30507__$1);

(statearr_30594[(11)] = inst_30510__$1);

return statearr_30594;
})();
var statearr_30595_30671 = state_30567__$1;
(statearr_30595_30671[(2)] = null);

(statearr_30595_30671[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (40))){
var inst_30535 = (state_30567[(23)]);
var inst_30539 = done(null);
var inst_30540 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30535);
var state_30567__$1 = (function (){var statearr_30596 = state_30567;
(statearr_30596[(24)] = inst_30539);

return statearr_30596;
})();
var statearr_30597_30672 = state_30567__$1;
(statearr_30597_30672[(2)] = inst_30540);

(statearr_30597_30672[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (33))){
var inst_30526 = (state_30567[(25)]);
var inst_30528 = cljs.core.chunked_seq_QMARK_(inst_30526);
var state_30567__$1 = state_30567;
if(inst_30528){
var statearr_30598_30673 = state_30567__$1;
(statearr_30598_30673[(1)] = (36));

} else {
var statearr_30599_30674 = state_30567__$1;
(statearr_30599_30674[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (13))){
var inst_30458 = (state_30567[(26)]);
var inst_30461 = cljs.core.async.close_BANG_(inst_30458);
var state_30567__$1 = state_30567;
var statearr_30600_30675 = state_30567__$1;
(statearr_30600_30675[(2)] = inst_30461);

(statearr_30600_30675[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (22))){
var inst_30479 = (state_30567[(8)]);
var inst_30482 = cljs.core.async.close_BANG_(inst_30479);
var state_30567__$1 = state_30567;
var statearr_30601_30676 = state_30567__$1;
(statearr_30601_30676[(2)] = inst_30482);

(statearr_30601_30676[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (36))){
var inst_30526 = (state_30567[(25)]);
var inst_30530 = cljs.core.chunk_first(inst_30526);
var inst_30531 = cljs.core.chunk_rest(inst_30526);
var inst_30532 = cljs.core.count(inst_30530);
var inst_30507 = inst_30531;
var inst_30508 = inst_30530;
var inst_30509 = inst_30532;
var inst_30510 = (0);
var state_30567__$1 = (function (){var statearr_30602 = state_30567;
(statearr_30602[(9)] = inst_30508);

(statearr_30602[(20)] = inst_30509);

(statearr_30602[(21)] = inst_30507);

(statearr_30602[(11)] = inst_30510);

return statearr_30602;
})();
var statearr_30603_30677 = state_30567__$1;
(statearr_30603_30677[(2)] = null);

(statearr_30603_30677[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (41))){
var inst_30526 = (state_30567[(25)]);
var inst_30542 = (state_30567[(2)]);
var inst_30543 = cljs.core.next(inst_30526);
var inst_30507 = inst_30543;
var inst_30508 = null;
var inst_30509 = (0);
var inst_30510 = (0);
var state_30567__$1 = (function (){var statearr_30604 = state_30567;
(statearr_30604[(27)] = inst_30542);

(statearr_30604[(9)] = inst_30508);

(statearr_30604[(20)] = inst_30509);

(statearr_30604[(21)] = inst_30507);

(statearr_30604[(11)] = inst_30510);

return statearr_30604;
})();
var statearr_30605_30678 = state_30567__$1;
(statearr_30605_30678[(2)] = null);

(statearr_30605_30678[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (43))){
var state_30567__$1 = state_30567;
var statearr_30606_30679 = state_30567__$1;
(statearr_30606_30679[(2)] = null);

(statearr_30606_30679[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (29))){
var inst_30551 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30607_30680 = state_30567__$1;
(statearr_30607_30680[(2)] = inst_30551);

(statearr_30607_30680[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (44))){
var inst_30560 = (state_30567[(2)]);
var state_30567__$1 = (function (){var statearr_30608 = state_30567;
(statearr_30608[(28)] = inst_30560);

return statearr_30608;
})();
var statearr_30609_30681 = state_30567__$1;
(statearr_30609_30681[(2)] = null);

(statearr_30609_30681[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (6))){
var inst_30499 = (state_30567[(29)]);
var inst_30498 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30499__$1 = cljs.core.keys(inst_30498);
var inst_30500 = cljs.core.count(inst_30499__$1);
var inst_30501 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30500) : cljs.core.reset_BANG_.call(null,dctr,inst_30500));
var inst_30506 = cljs.core.seq(inst_30499__$1);
var inst_30507 = inst_30506;
var inst_30508 = null;
var inst_30509 = (0);
var inst_30510 = (0);
var state_30567__$1 = (function (){var statearr_30610 = state_30567;
(statearr_30610[(29)] = inst_30499__$1);

(statearr_30610[(9)] = inst_30508);

(statearr_30610[(20)] = inst_30509);

(statearr_30610[(30)] = inst_30501);

(statearr_30610[(21)] = inst_30507);

(statearr_30610[(11)] = inst_30510);

return statearr_30610;
})();
var statearr_30611_30682 = state_30567__$1;
(statearr_30611_30682[(2)] = null);

(statearr_30611_30682[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (28))){
var inst_30526 = (state_30567[(25)]);
var inst_30507 = (state_30567[(21)]);
var inst_30526__$1 = cljs.core.seq(inst_30507);
var state_30567__$1 = (function (){var statearr_30612 = state_30567;
(statearr_30612[(25)] = inst_30526__$1);

return statearr_30612;
})();
if(inst_30526__$1){
var statearr_30613_30683 = state_30567__$1;
(statearr_30613_30683[(1)] = (33));

} else {
var statearr_30614_30684 = state_30567__$1;
(statearr_30614_30684[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (25))){
var inst_30509 = (state_30567[(20)]);
var inst_30510 = (state_30567[(11)]);
var inst_30512 = (inst_30510 < inst_30509);
var inst_30513 = inst_30512;
var state_30567__$1 = state_30567;
if(cljs.core.truth_(inst_30513)){
var statearr_30615_30685 = state_30567__$1;
(statearr_30615_30685[(1)] = (27));

} else {
var statearr_30616_30686 = state_30567__$1;
(statearr_30616_30686[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (34))){
var state_30567__$1 = state_30567;
var statearr_30617_30687 = state_30567__$1;
(statearr_30617_30687[(2)] = null);

(statearr_30617_30687[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (17))){
var state_30567__$1 = state_30567;
var statearr_30618_30688 = state_30567__$1;
(statearr_30618_30688[(2)] = null);

(statearr_30618_30688[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (3))){
var inst_30565 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30567__$1,inst_30565);
} else {
if((state_val_30568 === (12))){
var inst_30494 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30619_30689 = state_30567__$1;
(statearr_30619_30689[(2)] = inst_30494);

(statearr_30619_30689[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (2))){
var state_30567__$1 = state_30567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30567__$1,(4),ch);
} else {
if((state_val_30568 === (23))){
var state_30567__$1 = state_30567;
var statearr_30620_30690 = state_30567__$1;
(statearr_30620_30690[(2)] = null);

(statearr_30620_30690[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (35))){
var inst_30549 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30621_30691 = state_30567__$1;
(statearr_30621_30691[(2)] = inst_30549);

(statearr_30621_30691[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (19))){
var inst_30468 = (state_30567[(7)]);
var inst_30472 = cljs.core.chunk_first(inst_30468);
var inst_30473 = cljs.core.chunk_rest(inst_30468);
var inst_30474 = cljs.core.count(inst_30472);
var inst_30448 = inst_30473;
var inst_30449 = inst_30472;
var inst_30450 = inst_30474;
var inst_30451 = (0);
var state_30567__$1 = (function (){var statearr_30622 = state_30567;
(statearr_30622[(14)] = inst_30449);

(statearr_30622[(15)] = inst_30451);

(statearr_30622[(16)] = inst_30448);

(statearr_30622[(17)] = inst_30450);

return statearr_30622;
})();
var statearr_30623_30692 = state_30567__$1;
(statearr_30623_30692[(2)] = null);

(statearr_30623_30692[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (11))){
var inst_30448 = (state_30567[(16)]);
var inst_30468 = (state_30567[(7)]);
var inst_30468__$1 = cljs.core.seq(inst_30448);
var state_30567__$1 = (function (){var statearr_30624 = state_30567;
(statearr_30624[(7)] = inst_30468__$1);

return statearr_30624;
})();
if(inst_30468__$1){
var statearr_30625_30693 = state_30567__$1;
(statearr_30625_30693[(1)] = (16));

} else {
var statearr_30626_30694 = state_30567__$1;
(statearr_30626_30694[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (9))){
var inst_30496 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30627_30695 = state_30567__$1;
(statearr_30627_30695[(2)] = inst_30496);

(statearr_30627_30695[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (5))){
var inst_30446 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30447 = cljs.core.seq(inst_30446);
var inst_30448 = inst_30447;
var inst_30449 = null;
var inst_30450 = (0);
var inst_30451 = (0);
var state_30567__$1 = (function (){var statearr_30628 = state_30567;
(statearr_30628[(14)] = inst_30449);

(statearr_30628[(15)] = inst_30451);

(statearr_30628[(16)] = inst_30448);

(statearr_30628[(17)] = inst_30450);

return statearr_30628;
})();
var statearr_30629_30696 = state_30567__$1;
(statearr_30629_30696[(2)] = null);

(statearr_30629_30696[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (14))){
var state_30567__$1 = state_30567;
var statearr_30630_30697 = state_30567__$1;
(statearr_30630_30697[(2)] = null);

(statearr_30630_30697[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (45))){
var inst_30557 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30631_30698 = state_30567__$1;
(statearr_30631_30698[(2)] = inst_30557);

(statearr_30631_30698[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (26))){
var inst_30499 = (state_30567[(29)]);
var inst_30553 = (state_30567[(2)]);
var inst_30554 = cljs.core.seq(inst_30499);
var state_30567__$1 = (function (){var statearr_30632 = state_30567;
(statearr_30632[(31)] = inst_30553);

return statearr_30632;
})();
if(inst_30554){
var statearr_30633_30699 = state_30567__$1;
(statearr_30633_30699[(1)] = (42));

} else {
var statearr_30634_30700 = state_30567__$1;
(statearr_30634_30700[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (16))){
var inst_30468 = (state_30567[(7)]);
var inst_30470 = cljs.core.chunked_seq_QMARK_(inst_30468);
var state_30567__$1 = state_30567;
if(inst_30470){
var statearr_30635_30701 = state_30567__$1;
(statearr_30635_30701[(1)] = (19));

} else {
var statearr_30636_30702 = state_30567__$1;
(statearr_30636_30702[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (38))){
var inst_30546 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30637_30703 = state_30567__$1;
(statearr_30637_30703[(2)] = inst_30546);

(statearr_30637_30703[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (30))){
var state_30567__$1 = state_30567;
var statearr_30638_30704 = state_30567__$1;
(statearr_30638_30704[(2)] = null);

(statearr_30638_30704[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (10))){
var inst_30449 = (state_30567[(14)]);
var inst_30451 = (state_30567[(15)]);
var inst_30457 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30449,inst_30451);
var inst_30458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30457,(0),null);
var inst_30459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30457,(1),null);
var state_30567__$1 = (function (){var statearr_30639 = state_30567;
(statearr_30639[(26)] = inst_30458);

return statearr_30639;
})();
if(cljs.core.truth_(inst_30459)){
var statearr_30640_30705 = state_30567__$1;
(statearr_30640_30705[(1)] = (13));

} else {
var statearr_30641_30706 = state_30567__$1;
(statearr_30641_30706[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (18))){
var inst_30492 = (state_30567[(2)]);
var state_30567__$1 = state_30567;
var statearr_30642_30707 = state_30567__$1;
(statearr_30642_30707[(2)] = inst_30492);

(statearr_30642_30707[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (42))){
var state_30567__$1 = state_30567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30567__$1,(45),dchan);
} else {
if((state_val_30568 === (37))){
var inst_30535 = (state_30567[(23)]);
var inst_30526 = (state_30567[(25)]);
var inst_30439 = (state_30567[(12)]);
var inst_30535__$1 = cljs.core.first(inst_30526);
var inst_30536 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30535__$1,inst_30439,done);
var state_30567__$1 = (function (){var statearr_30643 = state_30567;
(statearr_30643[(23)] = inst_30535__$1);

return statearr_30643;
})();
if(cljs.core.truth_(inst_30536)){
var statearr_30644_30708 = state_30567__$1;
(statearr_30644_30708[(1)] = (39));

} else {
var statearr_30645_30709 = state_30567__$1;
(statearr_30645_30709[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30568 === (8))){
var inst_30451 = (state_30567[(15)]);
var inst_30450 = (state_30567[(17)]);
var inst_30453 = (inst_30451 < inst_30450);
var inst_30454 = inst_30453;
var state_30567__$1 = state_30567;
if(cljs.core.truth_(inst_30454)){
var statearr_30646_30710 = state_30567__$1;
(statearr_30646_30710[(1)] = (10));

} else {
var statearr_30647_30711 = state_30567__$1;
(statearr_30647_30711[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___30657,cs,m,dchan,dctr,done))
;
return ((function (switch__11560__auto__,c__11625__auto___30657,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11561__auto__ = null;
var cljs$core$async$mult_$_state_machine__11561__auto____0 = (function (){
var statearr_30651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30651[(0)] = cljs$core$async$mult_$_state_machine__11561__auto__);

(statearr_30651[(1)] = (1));

return statearr_30651;
});
var cljs$core$async$mult_$_state_machine__11561__auto____1 = (function (state_30567){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_30567);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e30652){if((e30652 instanceof Object)){
var ex__11564__auto__ = e30652;
var statearr_30653_30712 = state_30567;
(statearr_30653_30712[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30567);

return cljs.core.constant$keyword$recur;
} else {
throw e30652;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__30713 = state_30567;
state_30567 = G__30713;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11561__auto__ = function(state_30567){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11561__auto____1.call(this,state_30567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11561__auto____0;
cljs$core$async$mult_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11561__auto____1;
return cljs$core$async$mult_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___30657,cs,m,dchan,dctr,done))
})();
var state__11627__auto__ = (function (){var statearr_30654 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_30654[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___30657);

return statearr_30654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___30657,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30714 = [];
var len__8975__auto___30717 = arguments.length;
var i__8976__auto___30718 = (0);
while(true){
if((i__8976__auto___30718 < len__8975__auto___30717)){
args30714.push((arguments[i__8976__auto___30718]));

var G__30719 = (i__8976__auto___30718 + (1));
i__8976__auto___30718 = G__30719;
continue;
} else {
}
break;
}

var G__30716 = args30714.length;
switch (G__30716) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30714.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto__.call(null,m,ch));
} else {
var m__8573__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto__.call(null,m,ch));
} else {
var m__8573__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8573__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8573__auto__.call(null,m));
} else {
var m__8573__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8573__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8573__auto__.call(null,m,state_map));
} else {
var m__8573__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8573__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8572__auto__ = (((m == null))?null:m);
var m__8573__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8573__auto__.call(null,m,mode));
} else {
var m__8573__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8573__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__8982__auto__ = [];
var len__8975__auto___30733 = arguments.length;
var i__8976__auto___30734 = (0);
while(true){
if((i__8976__auto___30734 < len__8975__auto___30733)){
args__8982__auto__.push((arguments[i__8976__auto___30734]));

var G__30735 = (i__8976__auto___30734 + (1));
i__8976__auto___30734 = G__30735;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((3) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8983__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30727){
var map__30728 = p__30727;
var map__30728__$1 = ((((!((map__30728 == null)))?((((map__30728.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30728.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30728):map__30728);
var opts = map__30728__$1;
var statearr_30730_30736 = state;
(statearr_30730_30736[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__30728,map__30728__$1,opts){
return (function (val){
var statearr_30731_30737 = state;
(statearr_30731_30737[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30728,map__30728__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30732_30738 = state;
(statearr_30732_30738[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30723){
var G__30724 = cljs.core.first(seq30723);
var seq30723__$1 = cljs.core.next(seq30723);
var G__30725 = cljs.core.first(seq30723__$1);
var seq30723__$2 = cljs.core.next(seq30723__$1);
var G__30726 = cljs.core.first(seq30723__$2);
var seq30723__$3 = cljs.core.next(seq30723__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30724,G__30725,G__30726,seq30723__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30905 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30905) : cljs.core.atom.call(null,G__30905));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.constant$keyword$mute) : cljs.core.atom.call(null,cljs.core.constant$keyword$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t30906 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30906 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30907){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30907 = meta30907;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30906.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30908,meta30907__$1){
var self__ = this;
var _30908__$1 = this;
return (new cljs.core.async.t30906(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30907__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30908){
var self__ = this;
var _30908__$1 = this;
return self__.meta30907;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30906.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30909_31071 = self__.cs;
var G__30910_31072 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30909_31071,G__30910_31072) : cljs.core.reset_BANG_.call(null,G__30909_31071,G__30910_31072));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30907","meta30907",841899328,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30906.cljs$lang$type = true;

cljs.core.async.t30906.cljs$lang$ctorStr = "cljs.core.async/t30906";

cljs.core.async.t30906.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t30906");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t30906 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t30906(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30907){
return (new cljs.core.async.t30906(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30907));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t30906(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11625__auto___31073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31008){
var state_val_31009 = (state_31008[(1)]);
if((state_val_31009 === (7))){
var inst_30926 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
var statearr_31010_31074 = state_31008__$1;
(statearr_31010_31074[(2)] = inst_30926);

(statearr_31010_31074[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (20))){
var inst_30938 = (state_31008[(7)]);
var state_31008__$1 = state_31008;
var statearr_31011_31075 = state_31008__$1;
(statearr_31011_31075[(2)] = inst_30938);

(statearr_31011_31075[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (27))){
var state_31008__$1 = state_31008;
var statearr_31012_31076 = state_31008__$1;
(statearr_31012_31076[(2)] = null);

(statearr_31012_31076[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (1))){
var inst_30914 = (state_31008[(8)]);
var inst_30914__$1 = calc_state();
var inst_30916 = (inst_30914__$1 == null);
var inst_30917 = cljs.core.not(inst_30916);
var state_31008__$1 = (function (){var statearr_31013 = state_31008;
(statearr_31013[(8)] = inst_30914__$1);

return statearr_31013;
})();
if(inst_30917){
var statearr_31014_31077 = state_31008__$1;
(statearr_31014_31077[(1)] = (2));

} else {
var statearr_31015_31078 = state_31008__$1;
(statearr_31015_31078[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (24))){
var inst_30968 = (state_31008[(9)]);
var inst_30982 = (state_31008[(10)]);
var inst_30961 = (state_31008[(11)]);
var inst_30982__$1 = (inst_30961.cljs$core$IFn$_invoke$arity$1 ? inst_30961.cljs$core$IFn$_invoke$arity$1(inst_30968) : inst_30961.call(null,inst_30968));
var state_31008__$1 = (function (){var statearr_31016 = state_31008;
(statearr_31016[(10)] = inst_30982__$1);

return statearr_31016;
})();
if(cljs.core.truth_(inst_30982__$1)){
var statearr_31017_31079 = state_31008__$1;
(statearr_31017_31079[(1)] = (29));

} else {
var statearr_31018_31080 = state_31008__$1;
(statearr_31018_31080[(1)] = (30));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (4))){
var inst_30929 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30929)){
var statearr_31019_31081 = state_31008__$1;
(statearr_31019_31081[(1)] = (8));

} else {
var statearr_31020_31082 = state_31008__$1;
(statearr_31020_31082[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (15))){
var inst_30955 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30955)){
var statearr_31021_31083 = state_31008__$1;
(statearr_31021_31083[(1)] = (19));

} else {
var statearr_31022_31084 = state_31008__$1;
(statearr_31022_31084[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (21))){
var inst_30960 = (state_31008[(12)]);
var inst_30960__$1 = (state_31008[(2)]);
var inst_30961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30960__$1,cljs.core.constant$keyword$solos);
var inst_30962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30960__$1,cljs.core.constant$keyword$mutes);
var inst_30963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30960__$1,cljs.core.constant$keyword$reads);
var state_31008__$1 = (function (){var statearr_31023 = state_31008;
(statearr_31023[(13)] = inst_30962);

(statearr_31023[(12)] = inst_30960__$1);

(statearr_31023[(11)] = inst_30961);

return statearr_31023;
})();
return cljs.core.async.ioc_alts_BANG_(state_31008__$1,(22),inst_30963);
} else {
if((state_val_31009 === (31))){
var inst_30990 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30990)){
var statearr_31024_31085 = state_31008__$1;
(statearr_31024_31085[(1)] = (32));

} else {
var statearr_31025_31086 = state_31008__$1;
(statearr_31025_31086[(1)] = (33));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (32))){
var inst_30967 = (state_31008[(14)]);
var state_31008__$1 = state_31008;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31008__$1,(35),out,inst_30967);
} else {
if((state_val_31009 === (33))){
var inst_30960 = (state_31008[(12)]);
var inst_30938 = inst_30960;
var state_31008__$1 = (function (){var statearr_31026 = state_31008;
(statearr_31026[(7)] = inst_30938);

return statearr_31026;
})();
var statearr_31027_31087 = state_31008__$1;
(statearr_31027_31087[(2)] = null);

(statearr_31027_31087[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (13))){
var inst_30938 = (state_31008[(7)]);
var inst_30945 = inst_30938.cljs$lang$protocol_mask$partition0$;
var inst_30946 = (inst_30945 & (64));
var inst_30947 = inst_30938.cljs$core$ISeq$;
var inst_30948 = (inst_30946) || (inst_30947);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30948)){
var statearr_31028_31088 = state_31008__$1;
(statearr_31028_31088[(1)] = (16));

} else {
var statearr_31029_31089 = state_31008__$1;
(statearr_31029_31089[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (22))){
var inst_30968 = (state_31008[(9)]);
var inst_30967 = (state_31008[(14)]);
var inst_30966 = (state_31008[(2)]);
var inst_30967__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30966,(0),null);
var inst_30968__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30966,(1),null);
var inst_30969 = (inst_30967__$1 == null);
var inst_30970 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30968__$1,change);
var inst_30971 = (inst_30969) || (inst_30970);
var state_31008__$1 = (function (){var statearr_31030 = state_31008;
(statearr_31030[(9)] = inst_30968__$1);

(statearr_31030[(14)] = inst_30967__$1);

return statearr_31030;
})();
if(cljs.core.truth_(inst_30971)){
var statearr_31031_31090 = state_31008__$1;
(statearr_31031_31090[(1)] = (23));

} else {
var statearr_31032_31091 = state_31008__$1;
(statearr_31032_31091[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (36))){
var inst_30960 = (state_31008[(12)]);
var inst_30938 = inst_30960;
var state_31008__$1 = (function (){var statearr_31033 = state_31008;
(statearr_31033[(7)] = inst_30938);

return statearr_31033;
})();
var statearr_31034_31092 = state_31008__$1;
(statearr_31034_31092[(2)] = null);

(statearr_31034_31092[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (29))){
var inst_30982 = (state_31008[(10)]);
var state_31008__$1 = state_31008;
var statearr_31035_31093 = state_31008__$1;
(statearr_31035_31093[(2)] = inst_30982);

(statearr_31035_31093[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (6))){
var state_31008__$1 = state_31008;
var statearr_31036_31094 = state_31008__$1;
(statearr_31036_31094[(2)] = false);

(statearr_31036_31094[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (28))){
var inst_30978 = (state_31008[(2)]);
var inst_30979 = calc_state();
var inst_30938 = inst_30979;
var state_31008__$1 = (function (){var statearr_31037 = state_31008;
(statearr_31037[(15)] = inst_30978);

(statearr_31037[(7)] = inst_30938);

return statearr_31037;
})();
var statearr_31038_31095 = state_31008__$1;
(statearr_31038_31095[(2)] = null);

(statearr_31038_31095[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (25))){
var inst_31004 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
var statearr_31039_31096 = state_31008__$1;
(statearr_31039_31096[(2)] = inst_31004);

(statearr_31039_31096[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (34))){
var inst_31002 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
var statearr_31040_31097 = state_31008__$1;
(statearr_31040_31097[(2)] = inst_31002);

(statearr_31040_31097[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (17))){
var state_31008__$1 = state_31008;
var statearr_31041_31098 = state_31008__$1;
(statearr_31041_31098[(2)] = false);

(statearr_31041_31098[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (3))){
var state_31008__$1 = state_31008;
var statearr_31042_31099 = state_31008__$1;
(statearr_31042_31099[(2)] = false);

(statearr_31042_31099[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (12))){
var inst_31006 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31008__$1,inst_31006);
} else {
if((state_val_31009 === (2))){
var inst_30914 = (state_31008[(8)]);
var inst_30919 = inst_30914.cljs$lang$protocol_mask$partition0$;
var inst_30920 = (inst_30919 & (64));
var inst_30921 = inst_30914.cljs$core$ISeq$;
var inst_30922 = (inst_30920) || (inst_30921);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30922)){
var statearr_31043_31100 = state_31008__$1;
(statearr_31043_31100[(1)] = (5));

} else {
var statearr_31044_31101 = state_31008__$1;
(statearr_31044_31101[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (23))){
var inst_30967 = (state_31008[(14)]);
var inst_30973 = (inst_30967 == null);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30973)){
var statearr_31045_31102 = state_31008__$1;
(statearr_31045_31102[(1)] = (26));

} else {
var statearr_31046_31103 = state_31008__$1;
(statearr_31046_31103[(1)] = (27));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (35))){
var inst_30993 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
if(cljs.core.truth_(inst_30993)){
var statearr_31047_31104 = state_31008__$1;
(statearr_31047_31104[(1)] = (36));

} else {
var statearr_31048_31105 = state_31008__$1;
(statearr_31048_31105[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (19))){
var inst_30938 = (state_31008[(7)]);
var inst_30957 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30938);
var state_31008__$1 = state_31008;
var statearr_31049_31106 = state_31008__$1;
(statearr_31049_31106[(2)] = inst_30957);

(statearr_31049_31106[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (11))){
var inst_30938 = (state_31008[(7)]);
var inst_30942 = (inst_30938 == null);
var inst_30943 = cljs.core.not(inst_30942);
var state_31008__$1 = state_31008;
if(inst_30943){
var statearr_31050_31107 = state_31008__$1;
(statearr_31050_31107[(1)] = (13));

} else {
var statearr_31051_31108 = state_31008__$1;
(statearr_31051_31108[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (9))){
var inst_30914 = (state_31008[(8)]);
var state_31008__$1 = state_31008;
var statearr_31052_31109 = state_31008__$1;
(statearr_31052_31109[(2)] = inst_30914);

(statearr_31052_31109[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (5))){
var state_31008__$1 = state_31008;
var statearr_31053_31110 = state_31008__$1;
(statearr_31053_31110[(2)] = true);

(statearr_31053_31110[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (14))){
var state_31008__$1 = state_31008;
var statearr_31054_31111 = state_31008__$1;
(statearr_31054_31111[(2)] = false);

(statearr_31054_31111[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (26))){
var inst_30968 = (state_31008[(9)]);
var inst_30975 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_30968);
var state_31008__$1 = state_31008;
var statearr_31055_31112 = state_31008__$1;
(statearr_31055_31112[(2)] = inst_30975);

(statearr_31055_31112[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (16))){
var state_31008__$1 = state_31008;
var statearr_31056_31113 = state_31008__$1;
(statearr_31056_31113[(2)] = true);

(statearr_31056_31113[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (38))){
var inst_30998 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
var statearr_31057_31114 = state_31008__$1;
(statearr_31057_31114[(2)] = inst_30998);

(statearr_31057_31114[(1)] = (34));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (30))){
var inst_30968 = (state_31008[(9)]);
var inst_30962 = (state_31008[(13)]);
var inst_30961 = (state_31008[(11)]);
var inst_30985 = cljs.core.empty_QMARK_(inst_30961);
var inst_30986 = (inst_30962.cljs$core$IFn$_invoke$arity$1 ? inst_30962.cljs$core$IFn$_invoke$arity$1(inst_30968) : inst_30962.call(null,inst_30968));
var inst_30987 = cljs.core.not(inst_30986);
var inst_30988 = (inst_30985) && (inst_30987);
var state_31008__$1 = state_31008;
var statearr_31058_31115 = state_31008__$1;
(statearr_31058_31115[(2)] = inst_30988);

(statearr_31058_31115[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (10))){
var inst_30914 = (state_31008[(8)]);
var inst_30934 = (state_31008[(2)]);
var inst_30935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30934,cljs.core.constant$keyword$solos);
var inst_30936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30934,cljs.core.constant$keyword$mutes);
var inst_30937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30934,cljs.core.constant$keyword$reads);
var inst_30938 = inst_30914;
var state_31008__$1 = (function (){var statearr_31059 = state_31008;
(statearr_31059[(7)] = inst_30938);

(statearr_31059[(16)] = inst_30936);

(statearr_31059[(17)] = inst_30937);

(statearr_31059[(18)] = inst_30935);

return statearr_31059;
})();
var statearr_31060_31116 = state_31008__$1;
(statearr_31060_31116[(2)] = null);

(statearr_31060_31116[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (18))){
var inst_30952 = (state_31008[(2)]);
var state_31008__$1 = state_31008;
var statearr_31061_31117 = state_31008__$1;
(statearr_31061_31117[(2)] = inst_30952);

(statearr_31061_31117[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (37))){
var state_31008__$1 = state_31008;
var statearr_31062_31118 = state_31008__$1;
(statearr_31062_31118[(2)] = null);

(statearr_31062_31118[(1)] = (38));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31009 === (8))){
var inst_30914 = (state_31008[(8)]);
var inst_30931 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30914);
var state_31008__$1 = state_31008;
var statearr_31063_31119 = state_31008__$1;
(statearr_31063_31119[(2)] = inst_30931);

(statearr_31063_31119[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11560__auto__,c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11561__auto__ = null;
var cljs$core$async$mix_$_state_machine__11561__auto____0 = (function (){
var statearr_31067 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31067[(0)] = cljs$core$async$mix_$_state_machine__11561__auto__);

(statearr_31067[(1)] = (1));

return statearr_31067;
});
var cljs$core$async$mix_$_state_machine__11561__auto____1 = (function (state_31008){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31008);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31068){if((e31068 instanceof Object)){
var ex__11564__auto__ = e31068;
var statearr_31069_31120 = state_31008;
(statearr_31069_31120[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31008);

return cljs.core.constant$keyword$recur;
} else {
throw e31068;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31121 = state_31008;
state_31008 = G__31121;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11561__auto__ = function(state_31008){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11561__auto____1.call(this,state_31008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11561__auto____0;
cljs$core$async$mix_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11561__auto____1;
return cljs$core$async$mix_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11627__auto__ = (function (){var statearr_31070 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31070[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31073);

return statearr_31070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31073,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8572__auto__ = (((p == null))?null:p);
var m__8573__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8573__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8573__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8573__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8572__auto__ = (((p == null))?null:p);
var m__8573__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8573__auto__.call(null,p,v,ch));
} else {
var m__8573__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8573__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args31124 = [];
var len__8975__auto___31127 = arguments.length;
var i__8976__auto___31128 = (0);
while(true){
if((i__8976__auto___31128 < len__8975__auto___31127)){
args31124.push((arguments[i__8976__auto___31128]));

var G__31129 = (i__8976__auto___31128 + (1));
i__8976__auto___31128 = G__31129;
continue;
} else {
}
break;
}

var G__31126 = args31124.length;
switch (G__31126) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31124.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8572__auto__ = (((p == null))?null:p);
var m__8573__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8573__auto__.call(null,p));
} else {
var m__8573__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8573__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8572__auto__ = (((p == null))?null:p);
var m__8573__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8572__auto__)]);
if(!((m__8573__auto__ == null))){
return (m__8573__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8573__auto__.call(null,p,v));
} else {
var m__8573__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8573__auto____$1 == null))){
return (m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8573__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8573__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args31132 = [];
var len__8975__auto___31260 = arguments.length;
var i__8976__auto___31261 = (0);
while(true){
if((i__8976__auto___31261 < len__8975__auto___31260)){
args31132.push((arguments[i__8976__auto___31261]));

var G__31262 = (i__8976__auto___31261 + (1));
i__8976__auto___31261 = G__31262;
continue;
} else {
}
break;
}

var G__31134 = args31132.length;
switch (G__31134) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31132.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__31135 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31135) : cljs.core.atom.call(null,G__31135));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7936__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7936__auto__,mults){
return (function (p1__31131_SHARP_){
if(cljs.core.truth_((p1__31131_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31131_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31131_SHARP_.call(null,topic)))){
return p1__31131_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31131_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7936__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t31136 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31136 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31137){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31137 = meta31137;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31136.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31138,meta31137__$1){
var self__ = this;
var _31138__$1 = this;
return (new cljs.core.async.t31136(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31137__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31138){
var self__ = this;
var _31138__$1 = this;
return self__.meta31137;
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31136.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t31136.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31139 = self__.mults;
var G__31140 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31139,G__31140) : cljs.core.reset_BANG_.call(null,G__31139,G__31140));
});})(mults,ensure_mult))
;

cljs.core.async.t31136.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t31136.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31137","meta31137",-709119664,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t31136.cljs$lang$type = true;

cljs.core.async.t31136.cljs$lang$ctorStr = "cljs.core.async/t31136";

cljs.core.async.t31136.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t31136");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t31136 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t31136(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31137){
return (new cljs.core.async.t31136(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31137));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t31136(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11625__auto___31264 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31264,mults,ensure_mult,p){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31264,mults,ensure_mult,p){
return (function (state_31212){
var state_val_31213 = (state_31212[(1)]);
if((state_val_31213 === (7))){
var inst_31208 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31214_31265 = state_31212__$1;
(statearr_31214_31265[(2)] = inst_31208);

(statearr_31214_31265[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (20))){
var state_31212__$1 = state_31212;
var statearr_31215_31266 = state_31212__$1;
(statearr_31215_31266[(2)] = null);

(statearr_31215_31266[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (1))){
var state_31212__$1 = state_31212;
var statearr_31216_31267 = state_31212__$1;
(statearr_31216_31267[(2)] = null);

(statearr_31216_31267[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (24))){
var inst_31191 = (state_31212[(7)]);
var inst_31200 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31191);
var state_31212__$1 = state_31212;
var statearr_31217_31268 = state_31212__$1;
(statearr_31217_31268[(2)] = inst_31200);

(statearr_31217_31268[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (4))){
var inst_31143 = (state_31212[(8)]);
var inst_31143__$1 = (state_31212[(2)]);
var inst_31144 = (inst_31143__$1 == null);
var state_31212__$1 = (function (){var statearr_31218 = state_31212;
(statearr_31218[(8)] = inst_31143__$1);

return statearr_31218;
})();
if(cljs.core.truth_(inst_31144)){
var statearr_31219_31269 = state_31212__$1;
(statearr_31219_31269[(1)] = (5));

} else {
var statearr_31220_31270 = state_31212__$1;
(statearr_31220_31270[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (15))){
var inst_31185 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31221_31271 = state_31212__$1;
(statearr_31221_31271[(2)] = inst_31185);

(statearr_31221_31271[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (21))){
var inst_31205 = (state_31212[(2)]);
var state_31212__$1 = (function (){var statearr_31222 = state_31212;
(statearr_31222[(9)] = inst_31205);

return statearr_31222;
})();
var statearr_31223_31272 = state_31212__$1;
(statearr_31223_31272[(2)] = null);

(statearr_31223_31272[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (13))){
var inst_31167 = (state_31212[(10)]);
var inst_31169 = cljs.core.chunked_seq_QMARK_(inst_31167);
var state_31212__$1 = state_31212;
if(inst_31169){
var statearr_31224_31273 = state_31212__$1;
(statearr_31224_31273[(1)] = (16));

} else {
var statearr_31225_31274 = state_31212__$1;
(statearr_31225_31274[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (22))){
var inst_31197 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
if(cljs.core.truth_(inst_31197)){
var statearr_31226_31275 = state_31212__$1;
(statearr_31226_31275[(1)] = (23));

} else {
var statearr_31227_31276 = state_31212__$1;
(statearr_31227_31276[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (6))){
var inst_31143 = (state_31212[(8)]);
var inst_31193 = (state_31212[(11)]);
var inst_31191 = (state_31212[(7)]);
var inst_31191__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31143) : topic_fn.call(null,inst_31143));
var inst_31192 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31193__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31192,inst_31191__$1);
var state_31212__$1 = (function (){var statearr_31228 = state_31212;
(statearr_31228[(11)] = inst_31193__$1);

(statearr_31228[(7)] = inst_31191__$1);

return statearr_31228;
})();
if(cljs.core.truth_(inst_31193__$1)){
var statearr_31229_31277 = state_31212__$1;
(statearr_31229_31277[(1)] = (19));

} else {
var statearr_31230_31278 = state_31212__$1;
(statearr_31230_31278[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (25))){
var inst_31202 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31231_31279 = state_31212__$1;
(statearr_31231_31279[(2)] = inst_31202);

(statearr_31231_31279[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (17))){
var inst_31167 = (state_31212[(10)]);
var inst_31176 = cljs.core.first(inst_31167);
var inst_31177 = cljs.core.async.muxch_STAR_(inst_31176);
var inst_31178 = cljs.core.async.close_BANG_(inst_31177);
var inst_31179 = cljs.core.next(inst_31167);
var inst_31153 = inst_31179;
var inst_31154 = null;
var inst_31155 = (0);
var inst_31156 = (0);
var state_31212__$1 = (function (){var statearr_31232 = state_31212;
(statearr_31232[(12)] = inst_31153);

(statearr_31232[(13)] = inst_31155);

(statearr_31232[(14)] = inst_31156);

(statearr_31232[(15)] = inst_31154);

(statearr_31232[(16)] = inst_31178);

return statearr_31232;
})();
var statearr_31233_31280 = state_31212__$1;
(statearr_31233_31280[(2)] = null);

(statearr_31233_31280[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (3))){
var inst_31210 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31212__$1,inst_31210);
} else {
if((state_val_31213 === (12))){
var inst_31187 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31234_31281 = state_31212__$1;
(statearr_31234_31281[(2)] = inst_31187);

(statearr_31234_31281[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (2))){
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31212__$1,(4),ch);
} else {
if((state_val_31213 === (23))){
var state_31212__$1 = state_31212;
var statearr_31235_31282 = state_31212__$1;
(statearr_31235_31282[(2)] = null);

(statearr_31235_31282[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (19))){
var inst_31143 = (state_31212[(8)]);
var inst_31193 = (state_31212[(11)]);
var inst_31195 = cljs.core.async.muxch_STAR_(inst_31193);
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31212__$1,(22),inst_31195,inst_31143);
} else {
if((state_val_31213 === (11))){
var inst_31167 = (state_31212[(10)]);
var inst_31153 = (state_31212[(12)]);
var inst_31167__$1 = cljs.core.seq(inst_31153);
var state_31212__$1 = (function (){var statearr_31236 = state_31212;
(statearr_31236[(10)] = inst_31167__$1);

return statearr_31236;
})();
if(inst_31167__$1){
var statearr_31237_31283 = state_31212__$1;
(statearr_31237_31283[(1)] = (13));

} else {
var statearr_31238_31284 = state_31212__$1;
(statearr_31238_31284[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (9))){
var inst_31189 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31239_31285 = state_31212__$1;
(statearr_31239_31285[(2)] = inst_31189);

(statearr_31239_31285[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (5))){
var inst_31150 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31151 = cljs.core.vals(inst_31150);
var inst_31152 = cljs.core.seq(inst_31151);
var inst_31153 = inst_31152;
var inst_31154 = null;
var inst_31155 = (0);
var inst_31156 = (0);
var state_31212__$1 = (function (){var statearr_31240 = state_31212;
(statearr_31240[(12)] = inst_31153);

(statearr_31240[(13)] = inst_31155);

(statearr_31240[(14)] = inst_31156);

(statearr_31240[(15)] = inst_31154);

return statearr_31240;
})();
var statearr_31241_31286 = state_31212__$1;
(statearr_31241_31286[(2)] = null);

(statearr_31241_31286[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (14))){
var state_31212__$1 = state_31212;
var statearr_31245_31287 = state_31212__$1;
(statearr_31245_31287[(2)] = null);

(statearr_31245_31287[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (16))){
var inst_31167 = (state_31212[(10)]);
var inst_31171 = cljs.core.chunk_first(inst_31167);
var inst_31172 = cljs.core.chunk_rest(inst_31167);
var inst_31173 = cljs.core.count(inst_31171);
var inst_31153 = inst_31172;
var inst_31154 = inst_31171;
var inst_31155 = inst_31173;
var inst_31156 = (0);
var state_31212__$1 = (function (){var statearr_31246 = state_31212;
(statearr_31246[(12)] = inst_31153);

(statearr_31246[(13)] = inst_31155);

(statearr_31246[(14)] = inst_31156);

(statearr_31246[(15)] = inst_31154);

return statearr_31246;
})();
var statearr_31247_31288 = state_31212__$1;
(statearr_31247_31288[(2)] = null);

(statearr_31247_31288[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (10))){
var inst_31153 = (state_31212[(12)]);
var inst_31155 = (state_31212[(13)]);
var inst_31156 = (state_31212[(14)]);
var inst_31154 = (state_31212[(15)]);
var inst_31161 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31154,inst_31156);
var inst_31162 = cljs.core.async.muxch_STAR_(inst_31161);
var inst_31163 = cljs.core.async.close_BANG_(inst_31162);
var inst_31164 = (inst_31156 + (1));
var tmp31242 = inst_31153;
var tmp31243 = inst_31155;
var tmp31244 = inst_31154;
var inst_31153__$1 = tmp31242;
var inst_31154__$1 = tmp31244;
var inst_31155__$1 = tmp31243;
var inst_31156__$1 = inst_31164;
var state_31212__$1 = (function (){var statearr_31248 = state_31212;
(statearr_31248[(17)] = inst_31163);

(statearr_31248[(12)] = inst_31153__$1);

(statearr_31248[(13)] = inst_31155__$1);

(statearr_31248[(14)] = inst_31156__$1);

(statearr_31248[(15)] = inst_31154__$1);

return statearr_31248;
})();
var statearr_31249_31289 = state_31212__$1;
(statearr_31249_31289[(2)] = null);

(statearr_31249_31289[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (18))){
var inst_31182 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31250_31290 = state_31212__$1;
(statearr_31250_31290[(2)] = inst_31182);

(statearr_31250_31290[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31213 === (8))){
var inst_31155 = (state_31212[(13)]);
var inst_31156 = (state_31212[(14)]);
var inst_31158 = (inst_31156 < inst_31155);
var inst_31159 = inst_31158;
var state_31212__$1 = state_31212;
if(cljs.core.truth_(inst_31159)){
var statearr_31251_31291 = state_31212__$1;
(statearr_31251_31291[(1)] = (10));

} else {
var statearr_31252_31292 = state_31212__$1;
(statearr_31252_31292[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31264,mults,ensure_mult,p))
;
return ((function (switch__11560__auto__,c__11625__auto___31264,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31256[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31256[(1)] = (1));

return statearr_31256;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31212){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31212);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31257){if((e31257 instanceof Object)){
var ex__11564__auto__ = e31257;
var statearr_31258_31293 = state_31212;
(statearr_31258_31293[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31212);

return cljs.core.constant$keyword$recur;
} else {
throw e31257;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31294 = state_31212;
state_31212 = G__31294;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31212){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31264,mults,ensure_mult,p))
})();
var state__11627__auto__ = (function (){var statearr_31259 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31259[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31264);

return statearr_31259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31264,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31295 = [];
var len__8975__auto___31298 = arguments.length;
var i__8976__auto___31299 = (0);
while(true){
if((i__8976__auto___31299 < len__8975__auto___31298)){
args31295.push((arguments[i__8976__auto___31299]));

var G__31300 = (i__8976__auto___31299 + (1));
i__8976__auto___31299 = G__31300;
continue;
} else {
}
break;
}

var G__31297 = args31295.length;
switch (G__31297) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31295.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31302 = [];
var len__8975__auto___31305 = arguments.length;
var i__8976__auto___31306 = (0);
while(true){
if((i__8976__auto___31306 < len__8975__auto___31305)){
args31302.push((arguments[i__8976__auto___31306]));

var G__31307 = (i__8976__auto___31306 + (1));
i__8976__auto___31306 = G__31307;
continue;
} else {
}
break;
}

var G__31304 = args31302.length;
switch (G__31304) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31302.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31309 = [];
var len__8975__auto___31380 = arguments.length;
var i__8976__auto___31381 = (0);
while(true){
if((i__8976__auto___31381 < len__8975__auto___31380)){
args31309.push((arguments[i__8976__auto___31381]));

var G__31382 = (i__8976__auto___31381 + (1));
i__8976__auto___31381 = G__31382;
continue;
} else {
}
break;
}

var G__31311 = args31309.length;
switch (G__31311) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31309.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11625__auto___31384 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31350){
var state_val_31351 = (state_31350[(1)]);
if((state_val_31351 === (7))){
var state_31350__$1 = state_31350;
var statearr_31352_31385 = state_31350__$1;
(statearr_31352_31385[(2)] = null);

(statearr_31352_31385[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (1))){
var state_31350__$1 = state_31350;
var statearr_31353_31386 = state_31350__$1;
(statearr_31353_31386[(2)] = null);

(statearr_31353_31386[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (4))){
var inst_31314 = (state_31350[(7)]);
var inst_31316 = (inst_31314 < cnt);
var state_31350__$1 = state_31350;
if(cljs.core.truth_(inst_31316)){
var statearr_31354_31387 = state_31350__$1;
(statearr_31354_31387[(1)] = (6));

} else {
var statearr_31355_31388 = state_31350__$1;
(statearr_31355_31388[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (15))){
var inst_31346 = (state_31350[(2)]);
var state_31350__$1 = state_31350;
var statearr_31356_31389 = state_31350__$1;
(statearr_31356_31389[(2)] = inst_31346);

(statearr_31356_31389[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (13))){
var inst_31339 = cljs.core.async.close_BANG_(out);
var state_31350__$1 = state_31350;
var statearr_31357_31390 = state_31350__$1;
(statearr_31357_31390[(2)] = inst_31339);

(statearr_31357_31390[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (6))){
var state_31350__$1 = state_31350;
var statearr_31358_31391 = state_31350__$1;
(statearr_31358_31391[(2)] = null);

(statearr_31358_31391[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (3))){
var inst_31348 = (state_31350[(2)]);
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31350__$1,inst_31348);
} else {
if((state_val_31351 === (12))){
var inst_31336 = (state_31350[(8)]);
var inst_31336__$1 = (state_31350[(2)]);
var inst_31337 = cljs.core.some(cljs.core.nil_QMARK_,inst_31336__$1);
var state_31350__$1 = (function (){var statearr_31359 = state_31350;
(statearr_31359[(8)] = inst_31336__$1);

return statearr_31359;
})();
if(cljs.core.truth_(inst_31337)){
var statearr_31360_31392 = state_31350__$1;
(statearr_31360_31392[(1)] = (13));

} else {
var statearr_31361_31393 = state_31350__$1;
(statearr_31361_31393[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (2))){
var inst_31313 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_31314 = (0);
var state_31350__$1 = (function (){var statearr_31362 = state_31350;
(statearr_31362[(7)] = inst_31314);

(statearr_31362[(9)] = inst_31313);

return statearr_31362;
})();
var statearr_31363_31394 = state_31350__$1;
(statearr_31363_31394[(2)] = null);

(statearr_31363_31394[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (11))){
var inst_31314 = (state_31350[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_31350,(10),Object,null,(9));
var inst_31323 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31314) : chs__$1.call(null,inst_31314));
var inst_31324 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31314) : done.call(null,inst_31314));
var inst_31325 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31323,inst_31324);
var state_31350__$1 = state_31350;
var statearr_31364_31395 = state_31350__$1;
(statearr_31364_31395[(2)] = inst_31325);


cljs.core.async.impl.ioc_helpers.process_exception(state_31350__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (9))){
var inst_31314 = (state_31350[(7)]);
var inst_31327 = (state_31350[(2)]);
var inst_31328 = (inst_31314 + (1));
var inst_31314__$1 = inst_31328;
var state_31350__$1 = (function (){var statearr_31365 = state_31350;
(statearr_31365[(10)] = inst_31327);

(statearr_31365[(7)] = inst_31314__$1);

return statearr_31365;
})();
var statearr_31366_31396 = state_31350__$1;
(statearr_31366_31396[(2)] = null);

(statearr_31366_31396[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (5))){
var inst_31334 = (state_31350[(2)]);
var state_31350__$1 = (function (){var statearr_31367 = state_31350;
(statearr_31367[(11)] = inst_31334);

return statearr_31367;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31350__$1,(12),dchan);
} else {
if((state_val_31351 === (14))){
var inst_31336 = (state_31350[(8)]);
var inst_31341 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31336);
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31350__$1,(16),out,inst_31341);
} else {
if((state_val_31351 === (16))){
var inst_31343 = (state_31350[(2)]);
var state_31350__$1 = (function (){var statearr_31368 = state_31350;
(statearr_31368[(12)] = inst_31343);

return statearr_31368;
})();
var statearr_31369_31397 = state_31350__$1;
(statearr_31369_31397[(2)] = null);

(statearr_31369_31397[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (10))){
var inst_31318 = (state_31350[(2)]);
var inst_31319 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31350__$1 = (function (){var statearr_31370 = state_31350;
(statearr_31370[(13)] = inst_31318);

return statearr_31370;
})();
var statearr_31371_31398 = state_31350__$1;
(statearr_31371_31398[(2)] = inst_31319);


cljs.core.async.impl.ioc_helpers.process_exception(state_31350__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31351 === (8))){
var inst_31332 = (state_31350[(2)]);
var state_31350__$1 = state_31350;
var statearr_31372_31399 = state_31350__$1;
(statearr_31372_31399[(2)] = inst_31332);

(statearr_31372_31399[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11560__auto__,c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31376[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31376[(1)] = (1));

return statearr_31376;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31350){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31350);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31377){if((e31377 instanceof Object)){
var ex__11564__auto__ = e31377;
var statearr_31378_31400 = state_31350;
(statearr_31378_31400[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31350);

return cljs.core.constant$keyword$recur;
} else {
throw e31377;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31401 = state_31350;
state_31350 = G__31401;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31350){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11627__auto__ = (function (){var statearr_31379 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31379[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31384);

return statearr_31379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31384,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31403 = [];
var len__8975__auto___31459 = arguments.length;
var i__8976__auto___31460 = (0);
while(true){
if((i__8976__auto___31460 < len__8975__auto___31459)){
args31403.push((arguments[i__8976__auto___31460]));

var G__31461 = (i__8976__auto___31460 + (1));
i__8976__auto___31460 = G__31461;
continue;
} else {
}
break;
}

var G__31405 = args31403.length;
switch (G__31405) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31403.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___31463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31463,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31463,out){
return (function (state_31435){
var state_val_31436 = (state_31435[(1)]);
if((state_val_31436 === (7))){
var inst_31414 = (state_31435[(7)]);
var inst_31415 = (state_31435[(8)]);
var inst_31414__$1 = (state_31435[(2)]);
var inst_31415__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31414__$1,(0),null);
var inst_31416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31414__$1,(1),null);
var inst_31417 = (inst_31415__$1 == null);
var state_31435__$1 = (function (){var statearr_31437 = state_31435;
(statearr_31437[(7)] = inst_31414__$1);

(statearr_31437[(9)] = inst_31416);

(statearr_31437[(8)] = inst_31415__$1);

return statearr_31437;
})();
if(cljs.core.truth_(inst_31417)){
var statearr_31438_31464 = state_31435__$1;
(statearr_31438_31464[(1)] = (8));

} else {
var statearr_31439_31465 = state_31435__$1;
(statearr_31439_31465[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (1))){
var inst_31406 = cljs.core.vec(chs);
var inst_31407 = inst_31406;
var state_31435__$1 = (function (){var statearr_31440 = state_31435;
(statearr_31440[(10)] = inst_31407);

return statearr_31440;
})();
var statearr_31441_31466 = state_31435__$1;
(statearr_31441_31466[(2)] = null);

(statearr_31441_31466[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (4))){
var inst_31407 = (state_31435[(10)]);
var state_31435__$1 = state_31435;
return cljs.core.async.ioc_alts_BANG_(state_31435__$1,(7),inst_31407);
} else {
if((state_val_31436 === (6))){
var inst_31431 = (state_31435[(2)]);
var state_31435__$1 = state_31435;
var statearr_31442_31467 = state_31435__$1;
(statearr_31442_31467[(2)] = inst_31431);

(statearr_31442_31467[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (3))){
var inst_31433 = (state_31435[(2)]);
var state_31435__$1 = state_31435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31435__$1,inst_31433);
} else {
if((state_val_31436 === (2))){
var inst_31407 = (state_31435[(10)]);
var inst_31409 = cljs.core.count(inst_31407);
var inst_31410 = (inst_31409 > (0));
var state_31435__$1 = state_31435;
if(cljs.core.truth_(inst_31410)){
var statearr_31444_31468 = state_31435__$1;
(statearr_31444_31468[(1)] = (4));

} else {
var statearr_31445_31469 = state_31435__$1;
(statearr_31445_31469[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (11))){
var inst_31407 = (state_31435[(10)]);
var inst_31424 = (state_31435[(2)]);
var tmp31443 = inst_31407;
var inst_31407__$1 = tmp31443;
var state_31435__$1 = (function (){var statearr_31446 = state_31435;
(statearr_31446[(11)] = inst_31424);

(statearr_31446[(10)] = inst_31407__$1);

return statearr_31446;
})();
var statearr_31447_31470 = state_31435__$1;
(statearr_31447_31470[(2)] = null);

(statearr_31447_31470[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (9))){
var inst_31415 = (state_31435[(8)]);
var state_31435__$1 = state_31435;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31435__$1,(11),out,inst_31415);
} else {
if((state_val_31436 === (5))){
var inst_31429 = cljs.core.async.close_BANG_(out);
var state_31435__$1 = state_31435;
var statearr_31448_31471 = state_31435__$1;
(statearr_31448_31471[(2)] = inst_31429);

(statearr_31448_31471[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (10))){
var inst_31427 = (state_31435[(2)]);
var state_31435__$1 = state_31435;
var statearr_31449_31472 = state_31435__$1;
(statearr_31449_31472[(2)] = inst_31427);

(statearr_31449_31472[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31436 === (8))){
var inst_31414 = (state_31435[(7)]);
var inst_31416 = (state_31435[(9)]);
var inst_31407 = (state_31435[(10)]);
var inst_31415 = (state_31435[(8)]);
var inst_31419 = (function (){var cs = inst_31407;
var vec__31412 = inst_31414;
var v = inst_31415;
var c = inst_31416;
return ((function (cs,vec__31412,v,c,inst_31414,inst_31416,inst_31407,inst_31415,state_val_31436,c__11625__auto___31463,out){
return (function (p1__31402_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31402_SHARP_);
});
;})(cs,vec__31412,v,c,inst_31414,inst_31416,inst_31407,inst_31415,state_val_31436,c__11625__auto___31463,out))
})();
var inst_31420 = cljs.core.filterv(inst_31419,inst_31407);
var inst_31407__$1 = inst_31420;
var state_31435__$1 = (function (){var statearr_31450 = state_31435;
(statearr_31450[(10)] = inst_31407__$1);

return statearr_31450;
})();
var statearr_31451_31473 = state_31435__$1;
(statearr_31451_31473[(2)] = null);

(statearr_31451_31473[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31463,out))
;
return ((function (switch__11560__auto__,c__11625__auto___31463,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31455 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31455[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31455[(1)] = (1));

return statearr_31455;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31435){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31435);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31456){if((e31456 instanceof Object)){
var ex__11564__auto__ = e31456;
var statearr_31457_31474 = state_31435;
(statearr_31457_31474[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31435);

return cljs.core.constant$keyword$recur;
} else {
throw e31456;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31475 = state_31435;
state_31435 = G__31475;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31435){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31463,out))
})();
var state__11627__auto__ = (function (){var statearr_31458 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31458[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31463);

return statearr_31458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31463,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31476 = [];
var len__8975__auto___31525 = arguments.length;
var i__8976__auto___31526 = (0);
while(true){
if((i__8976__auto___31526 < len__8975__auto___31525)){
args31476.push((arguments[i__8976__auto___31526]));

var G__31527 = (i__8976__auto___31526 + (1));
i__8976__auto___31526 = G__31527;
continue;
} else {
}
break;
}

var G__31478 = args31476.length;
switch (G__31478) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31476.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___31529 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31529,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31529,out){
return (function (state_31502){
var state_val_31503 = (state_31502[(1)]);
if((state_val_31503 === (7))){
var inst_31484 = (state_31502[(7)]);
var inst_31484__$1 = (state_31502[(2)]);
var inst_31485 = (inst_31484__$1 == null);
var inst_31486 = cljs.core.not(inst_31485);
var state_31502__$1 = (function (){var statearr_31504 = state_31502;
(statearr_31504[(7)] = inst_31484__$1);

return statearr_31504;
})();
if(inst_31486){
var statearr_31505_31530 = state_31502__$1;
(statearr_31505_31530[(1)] = (8));

} else {
var statearr_31506_31531 = state_31502__$1;
(statearr_31506_31531[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (1))){
var inst_31479 = (0);
var state_31502__$1 = (function (){var statearr_31507 = state_31502;
(statearr_31507[(8)] = inst_31479);

return statearr_31507;
})();
var statearr_31508_31532 = state_31502__$1;
(statearr_31508_31532[(2)] = null);

(statearr_31508_31532[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (4))){
var state_31502__$1 = state_31502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31502__$1,(7),ch);
} else {
if((state_val_31503 === (6))){
var inst_31497 = (state_31502[(2)]);
var state_31502__$1 = state_31502;
var statearr_31509_31533 = state_31502__$1;
(statearr_31509_31533[(2)] = inst_31497);

(statearr_31509_31533[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (3))){
var inst_31499 = (state_31502[(2)]);
var inst_31500 = cljs.core.async.close_BANG_(out);
var state_31502__$1 = (function (){var statearr_31510 = state_31502;
(statearr_31510[(9)] = inst_31499);

return statearr_31510;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31502__$1,inst_31500);
} else {
if((state_val_31503 === (2))){
var inst_31479 = (state_31502[(8)]);
var inst_31481 = (inst_31479 < n);
var state_31502__$1 = state_31502;
if(cljs.core.truth_(inst_31481)){
var statearr_31511_31534 = state_31502__$1;
(statearr_31511_31534[(1)] = (4));

} else {
var statearr_31512_31535 = state_31502__$1;
(statearr_31512_31535[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (11))){
var inst_31479 = (state_31502[(8)]);
var inst_31489 = (state_31502[(2)]);
var inst_31490 = (inst_31479 + (1));
var inst_31479__$1 = inst_31490;
var state_31502__$1 = (function (){var statearr_31513 = state_31502;
(statearr_31513[(10)] = inst_31489);

(statearr_31513[(8)] = inst_31479__$1);

return statearr_31513;
})();
var statearr_31514_31536 = state_31502__$1;
(statearr_31514_31536[(2)] = null);

(statearr_31514_31536[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (9))){
var state_31502__$1 = state_31502;
var statearr_31515_31537 = state_31502__$1;
(statearr_31515_31537[(2)] = null);

(statearr_31515_31537[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (5))){
var state_31502__$1 = state_31502;
var statearr_31516_31538 = state_31502__$1;
(statearr_31516_31538[(2)] = null);

(statearr_31516_31538[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (10))){
var inst_31494 = (state_31502[(2)]);
var state_31502__$1 = state_31502;
var statearr_31517_31539 = state_31502__$1;
(statearr_31517_31539[(2)] = inst_31494);

(statearr_31517_31539[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31503 === (8))){
var inst_31484 = (state_31502[(7)]);
var state_31502__$1 = state_31502;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31502__$1,(11),out,inst_31484);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31529,out))
;
return ((function (switch__11560__auto__,c__11625__auto___31529,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31521 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31521[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31521[(1)] = (1));

return statearr_31521;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31502){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31502);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31522){if((e31522 instanceof Object)){
var ex__11564__auto__ = e31522;
var statearr_31523_31540 = state_31502;
(statearr_31523_31540[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31502);

return cljs.core.constant$keyword$recur;
} else {
throw e31522;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31541 = state_31502;
state_31502 = G__31541;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31502){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31529,out))
})();
var state__11627__auto__ = (function (){var statearr_31524 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31524[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31529);

return statearr_31524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31529,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31551 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31551 = (function (map_LT_,f,ch,meta31552){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31552 = meta31552;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31553,meta31552__$1){
var self__ = this;
var _31553__$1 = this;
return (new cljs.core.async.t31551(self__.map_LT_,self__.f,self__.ch,meta31552__$1));
});

cljs.core.async.t31551.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31553){
var self__ = this;
var _31553__$1 = this;
return self__.meta31552;
});

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t31554 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31554 = (function (map_LT_,f,ch,meta31552,_,fn1,meta31555){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31552 = meta31552;
this._ = _;
this.fn1 = fn1;
this.meta31555 = meta31555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31556,meta31555__$1){
var self__ = this;
var _31556__$1 = this;
return (new cljs.core.async.t31554(self__.map_LT_,self__.f,self__.ch,self__.meta31552,self__._,self__.fn1,meta31555__$1));
});})(___$1))
;

cljs.core.async.t31554.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31556){
var self__ = this;
var _31556__$1 = this;
return self__.meta31555;
});})(___$1))
;

cljs.core.async.t31554.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31554.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t31554.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31542_SHARP_){
var G__31557 = (((p1__31542_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31542_SHARP_) : self__.f.call(null,p1__31542_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31557) : f1.call(null,G__31557));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31554.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31552","meta31552",-952047671,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tag,new cljs.core.Symbol("cljs.core.async","t31551","cljs.core.async/t31551",591674839,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31555","meta31555",-1613734171,null)], null);
});})(___$1))
;

cljs.core.async.t31554.cljs$lang$type = true;

cljs.core.async.t31554.cljs$lang$ctorStr = "cljs.core.async/t31554";

cljs.core.async.t31554.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t31554");
});})(___$1))
;

cljs.core.async.__GT_t31554 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31554(map_LT___$1,f__$1,ch__$1,meta31552__$1,___$2,fn1__$1,meta31555){
return (new cljs.core.async.t31554(map_LT___$1,f__$1,ch__$1,meta31552__$1,___$2,fn1__$1,meta31555));
});})(___$1))
;

}

return (new cljs.core.async.t31554(self__.map_LT_,self__.f,self__.ch,self__.meta31552,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7924__auto__ = ret;
if(cljs.core.truth_(and__7924__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7924__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31558 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31558) : self__.f.call(null,G__31558));
})());
} else {
return ret;
}
});

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31551.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t31551.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31552","meta31552",-952047671,null)], null);
});

cljs.core.async.t31551.cljs$lang$type = true;

cljs.core.async.t31551.cljs$lang$ctorStr = "cljs.core.async/t31551";

cljs.core.async.t31551.cljs$lang$ctorPrWriter = (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t31551");
});

cljs.core.async.__GT_t31551 = (function cljs$core$async$map_LT__$___GT_t31551(map_LT___$1,f__$1,ch__$1,meta31552){
return (new cljs.core.async.t31551(map_LT___$1,f__$1,ch__$1,meta31552));
});

}

return (new cljs.core.async.t31551(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31562 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31562 = (function (map_GT_,f,ch,meta31563){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31563 = meta31563;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31564,meta31563__$1){
var self__ = this;
var _31564__$1 = this;
return (new cljs.core.async.t31562(self__.map_GT_,self__.f,self__.ch,meta31563__$1));
});

cljs.core.async.t31562.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31564){
var self__ = this;
var _31564__$1 = this;
return self__.meta31563;
});

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31562.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t31562.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31563","meta31563",127889360,null)], null);
});

cljs.core.async.t31562.cljs$lang$type = true;

cljs.core.async.t31562.cljs$lang$ctorStr = "cljs.core.async/t31562";

cljs.core.async.t31562.cljs$lang$ctorPrWriter = (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t31562");
});

cljs.core.async.__GT_t31562 = (function cljs$core$async$map_GT__$___GT_t31562(map_GT___$1,f__$1,ch__$1,meta31563){
return (new cljs.core.async.t31562(map_GT___$1,f__$1,ch__$1,meta31563));
});

}

return (new cljs.core.async.t31562(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31568 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31568 = (function (filter_GT_,p,ch,meta31569){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31569 = meta31569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31570,meta31569__$1){
var self__ = this;
var _31570__$1 = this;
return (new cljs.core.async.t31568(self__.filter_GT_,self__.p,self__.ch,meta31569__$1));
});

cljs.core.async.t31568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31570){
var self__ = this;
var _31570__$1 = this;
return self__.meta31569;
});

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31568.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t31568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31569","meta31569",572750454,null)], null);
});

cljs.core.async.t31568.cljs$lang$type = true;

cljs.core.async.t31568.cljs$lang$ctorStr = "cljs.core.async/t31568";

cljs.core.async.t31568.cljs$lang$ctorPrWriter = (function (this__8515__auto__,writer__8516__auto__,opt__8517__auto__){
return cljs.core._write(writer__8516__auto__,"cljs.core.async/t31568");
});

cljs.core.async.__GT_t31568 = (function cljs$core$async$filter_GT__$___GT_t31568(filter_GT___$1,p__$1,ch__$1,meta31569){
return (new cljs.core.async.t31568(filter_GT___$1,p__$1,ch__$1,meta31569));
});

}

return (new cljs.core.async.t31568(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31571 = [];
var len__8975__auto___31615 = arguments.length;
var i__8976__auto___31616 = (0);
while(true){
if((i__8976__auto___31616 < len__8975__auto___31615)){
args31571.push((arguments[i__8976__auto___31616]));

var G__31617 = (i__8976__auto___31616 + (1));
i__8976__auto___31616 = G__31617;
continue;
} else {
}
break;
}

var G__31573 = args31571.length;
switch (G__31573) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31571.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___31619 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31619,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31619,out){
return (function (state_31594){
var state_val_31595 = (state_31594[(1)]);
if((state_val_31595 === (7))){
var inst_31590 = (state_31594[(2)]);
var state_31594__$1 = state_31594;
var statearr_31596_31620 = state_31594__$1;
(statearr_31596_31620[(2)] = inst_31590);

(statearr_31596_31620[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (1))){
var state_31594__$1 = state_31594;
var statearr_31597_31621 = state_31594__$1;
(statearr_31597_31621[(2)] = null);

(statearr_31597_31621[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (4))){
var inst_31576 = (state_31594[(7)]);
var inst_31576__$1 = (state_31594[(2)]);
var inst_31577 = (inst_31576__$1 == null);
var state_31594__$1 = (function (){var statearr_31598 = state_31594;
(statearr_31598[(7)] = inst_31576__$1);

return statearr_31598;
})();
if(cljs.core.truth_(inst_31577)){
var statearr_31599_31622 = state_31594__$1;
(statearr_31599_31622[(1)] = (5));

} else {
var statearr_31600_31623 = state_31594__$1;
(statearr_31600_31623[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (6))){
var inst_31576 = (state_31594[(7)]);
var inst_31581 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31576) : p.call(null,inst_31576));
var state_31594__$1 = state_31594;
if(cljs.core.truth_(inst_31581)){
var statearr_31601_31624 = state_31594__$1;
(statearr_31601_31624[(1)] = (8));

} else {
var statearr_31602_31625 = state_31594__$1;
(statearr_31602_31625[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (3))){
var inst_31592 = (state_31594[(2)]);
var state_31594__$1 = state_31594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31594__$1,inst_31592);
} else {
if((state_val_31595 === (2))){
var state_31594__$1 = state_31594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31594__$1,(4),ch);
} else {
if((state_val_31595 === (11))){
var inst_31584 = (state_31594[(2)]);
var state_31594__$1 = state_31594;
var statearr_31603_31626 = state_31594__$1;
(statearr_31603_31626[(2)] = inst_31584);

(statearr_31603_31626[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (9))){
var state_31594__$1 = state_31594;
var statearr_31604_31627 = state_31594__$1;
(statearr_31604_31627[(2)] = null);

(statearr_31604_31627[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (5))){
var inst_31579 = cljs.core.async.close_BANG_(out);
var state_31594__$1 = state_31594;
var statearr_31605_31628 = state_31594__$1;
(statearr_31605_31628[(2)] = inst_31579);

(statearr_31605_31628[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (10))){
var inst_31587 = (state_31594[(2)]);
var state_31594__$1 = (function (){var statearr_31606 = state_31594;
(statearr_31606[(8)] = inst_31587);

return statearr_31606;
})();
var statearr_31607_31629 = state_31594__$1;
(statearr_31607_31629[(2)] = null);

(statearr_31607_31629[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31595 === (8))){
var inst_31576 = (state_31594[(7)]);
var state_31594__$1 = state_31594;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31594__$1,(11),out,inst_31576);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31619,out))
;
return ((function (switch__11560__auto__,c__11625__auto___31619,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31611 = [null,null,null,null,null,null,null,null,null];
(statearr_31611[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31611[(1)] = (1));

return statearr_31611;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31594){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31594);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31612){if((e31612 instanceof Object)){
var ex__11564__auto__ = e31612;
var statearr_31613_31630 = state_31594;
(statearr_31613_31630[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31594);

return cljs.core.constant$keyword$recur;
} else {
throw e31612;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31631 = state_31594;
state_31594 = G__31631;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31594){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31619,out))
})();
var state__11627__auto__ = (function (){var statearr_31614 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31619);

return statearr_31614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31619,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31632 = [];
var len__8975__auto___31635 = arguments.length;
var i__8976__auto___31636 = (0);
while(true){
if((i__8976__auto___31636 < len__8975__auto___31635)){
args31632.push((arguments[i__8976__auto___31636]));

var G__31637 = (i__8976__auto___31636 + (1));
i__8976__auto___31636 = G__31637;
continue;
} else {
}
break;
}

var G__31634 = args31632.length;
switch (G__31634) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31632.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11625__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto__){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto__){
return (function (state_31804){
var state_val_31805 = (state_31804[(1)]);
if((state_val_31805 === (7))){
var inst_31800 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
var statearr_31806_31847 = state_31804__$1;
(statearr_31806_31847[(2)] = inst_31800);

(statearr_31806_31847[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (20))){
var inst_31770 = (state_31804[(7)]);
var inst_31781 = (state_31804[(2)]);
var inst_31782 = cljs.core.next(inst_31770);
var inst_31756 = inst_31782;
var inst_31757 = null;
var inst_31758 = (0);
var inst_31759 = (0);
var state_31804__$1 = (function (){var statearr_31807 = state_31804;
(statearr_31807[(8)] = inst_31758);

(statearr_31807[(9)] = inst_31759);

(statearr_31807[(10)] = inst_31756);

(statearr_31807[(11)] = inst_31757);

(statearr_31807[(12)] = inst_31781);

return statearr_31807;
})();
var statearr_31808_31848 = state_31804__$1;
(statearr_31808_31848[(2)] = null);

(statearr_31808_31848[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (1))){
var state_31804__$1 = state_31804;
var statearr_31809_31849 = state_31804__$1;
(statearr_31809_31849[(2)] = null);

(statearr_31809_31849[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (4))){
var inst_31745 = (state_31804[(13)]);
var inst_31745__$1 = (state_31804[(2)]);
var inst_31746 = (inst_31745__$1 == null);
var state_31804__$1 = (function (){var statearr_31810 = state_31804;
(statearr_31810[(13)] = inst_31745__$1);

return statearr_31810;
})();
if(cljs.core.truth_(inst_31746)){
var statearr_31811_31850 = state_31804__$1;
(statearr_31811_31850[(1)] = (5));

} else {
var statearr_31812_31851 = state_31804__$1;
(statearr_31812_31851[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (15))){
var state_31804__$1 = state_31804;
var statearr_31816_31852 = state_31804__$1;
(statearr_31816_31852[(2)] = null);

(statearr_31816_31852[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (21))){
var state_31804__$1 = state_31804;
var statearr_31817_31853 = state_31804__$1;
(statearr_31817_31853[(2)] = null);

(statearr_31817_31853[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (13))){
var inst_31758 = (state_31804[(8)]);
var inst_31759 = (state_31804[(9)]);
var inst_31756 = (state_31804[(10)]);
var inst_31757 = (state_31804[(11)]);
var inst_31766 = (state_31804[(2)]);
var inst_31767 = (inst_31759 + (1));
var tmp31813 = inst_31758;
var tmp31814 = inst_31756;
var tmp31815 = inst_31757;
var inst_31756__$1 = tmp31814;
var inst_31757__$1 = tmp31815;
var inst_31758__$1 = tmp31813;
var inst_31759__$1 = inst_31767;
var state_31804__$1 = (function (){var statearr_31818 = state_31804;
(statearr_31818[(8)] = inst_31758__$1);

(statearr_31818[(9)] = inst_31759__$1);

(statearr_31818[(10)] = inst_31756__$1);

(statearr_31818[(14)] = inst_31766);

(statearr_31818[(11)] = inst_31757__$1);

return statearr_31818;
})();
var statearr_31819_31854 = state_31804__$1;
(statearr_31819_31854[(2)] = null);

(statearr_31819_31854[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (22))){
var state_31804__$1 = state_31804;
var statearr_31820_31855 = state_31804__$1;
(statearr_31820_31855[(2)] = null);

(statearr_31820_31855[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (6))){
var inst_31745 = (state_31804[(13)]);
var inst_31754 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31745) : f.call(null,inst_31745));
var inst_31755 = cljs.core.seq(inst_31754);
var inst_31756 = inst_31755;
var inst_31757 = null;
var inst_31758 = (0);
var inst_31759 = (0);
var state_31804__$1 = (function (){var statearr_31821 = state_31804;
(statearr_31821[(8)] = inst_31758);

(statearr_31821[(9)] = inst_31759);

(statearr_31821[(10)] = inst_31756);

(statearr_31821[(11)] = inst_31757);

return statearr_31821;
})();
var statearr_31822_31856 = state_31804__$1;
(statearr_31822_31856[(2)] = null);

(statearr_31822_31856[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (17))){
var inst_31770 = (state_31804[(7)]);
var inst_31774 = cljs.core.chunk_first(inst_31770);
var inst_31775 = cljs.core.chunk_rest(inst_31770);
var inst_31776 = cljs.core.count(inst_31774);
var inst_31756 = inst_31775;
var inst_31757 = inst_31774;
var inst_31758 = inst_31776;
var inst_31759 = (0);
var state_31804__$1 = (function (){var statearr_31823 = state_31804;
(statearr_31823[(8)] = inst_31758);

(statearr_31823[(9)] = inst_31759);

(statearr_31823[(10)] = inst_31756);

(statearr_31823[(11)] = inst_31757);

return statearr_31823;
})();
var statearr_31824_31857 = state_31804__$1;
(statearr_31824_31857[(2)] = null);

(statearr_31824_31857[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (3))){
var inst_31802 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31804__$1,inst_31802);
} else {
if((state_val_31805 === (12))){
var inst_31790 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
var statearr_31825_31858 = state_31804__$1;
(statearr_31825_31858[(2)] = inst_31790);

(statearr_31825_31858[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (2))){
var state_31804__$1 = state_31804;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31804__$1,(4),in$);
} else {
if((state_val_31805 === (23))){
var inst_31798 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
var statearr_31826_31859 = state_31804__$1;
(statearr_31826_31859[(2)] = inst_31798);

(statearr_31826_31859[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (19))){
var inst_31785 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
var statearr_31827_31860 = state_31804__$1;
(statearr_31827_31860[(2)] = inst_31785);

(statearr_31827_31860[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (11))){
var inst_31770 = (state_31804[(7)]);
var inst_31756 = (state_31804[(10)]);
var inst_31770__$1 = cljs.core.seq(inst_31756);
var state_31804__$1 = (function (){var statearr_31828 = state_31804;
(statearr_31828[(7)] = inst_31770__$1);

return statearr_31828;
})();
if(inst_31770__$1){
var statearr_31829_31861 = state_31804__$1;
(statearr_31829_31861[(1)] = (14));

} else {
var statearr_31830_31862 = state_31804__$1;
(statearr_31830_31862[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (9))){
var inst_31792 = (state_31804[(2)]);
var inst_31793 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31804__$1 = (function (){var statearr_31831 = state_31804;
(statearr_31831[(15)] = inst_31792);

return statearr_31831;
})();
if(cljs.core.truth_(inst_31793)){
var statearr_31832_31863 = state_31804__$1;
(statearr_31832_31863[(1)] = (21));

} else {
var statearr_31833_31864 = state_31804__$1;
(statearr_31833_31864[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (5))){
var inst_31748 = cljs.core.async.close_BANG_(out);
var state_31804__$1 = state_31804;
var statearr_31834_31865 = state_31804__$1;
(statearr_31834_31865[(2)] = inst_31748);

(statearr_31834_31865[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (14))){
var inst_31770 = (state_31804[(7)]);
var inst_31772 = cljs.core.chunked_seq_QMARK_(inst_31770);
var state_31804__$1 = state_31804;
if(inst_31772){
var statearr_31835_31866 = state_31804__$1;
(statearr_31835_31866[(1)] = (17));

} else {
var statearr_31836_31867 = state_31804__$1;
(statearr_31836_31867[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (16))){
var inst_31788 = (state_31804[(2)]);
var state_31804__$1 = state_31804;
var statearr_31837_31868 = state_31804__$1;
(statearr_31837_31868[(2)] = inst_31788);

(statearr_31837_31868[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31805 === (10))){
var inst_31759 = (state_31804[(9)]);
var inst_31757 = (state_31804[(11)]);
var inst_31764 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31757,inst_31759);
var state_31804__$1 = state_31804;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31804__$1,(13),out,inst_31764);
} else {
if((state_val_31805 === (18))){
var inst_31770 = (state_31804[(7)]);
var inst_31779 = cljs.core.first(inst_31770);
var state_31804__$1 = state_31804;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31804__$1,(20),out,inst_31779);
} else {
if((state_val_31805 === (8))){
var inst_31758 = (state_31804[(8)]);
var inst_31759 = (state_31804[(9)]);
var inst_31761 = (inst_31759 < inst_31758);
var inst_31762 = inst_31761;
var state_31804__$1 = state_31804;
if(cljs.core.truth_(inst_31762)){
var statearr_31838_31869 = state_31804__$1;
(statearr_31838_31869[(1)] = (10));

} else {
var statearr_31839_31870 = state_31804__$1;
(statearr_31839_31870[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto__))
;
return ((function (switch__11560__auto__,c__11625__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_31843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31843[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__);

(statearr_31843[(1)] = (1));

return statearr_31843;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1 = (function (state_31804){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31804);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31844){if((e31844 instanceof Object)){
var ex__11564__auto__ = e31844;
var statearr_31845_31871 = state_31804;
(statearr_31845_31871[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31804);

return cljs.core.constant$keyword$recur;
} else {
throw e31844;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31872 = state_31804;
state_31804 = G__31872;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__ = function(state_31804){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1.call(this,state_31804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto__))
})();
var state__11627__auto__ = (function (){var statearr_31846 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto__);

return statearr_31846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto__))
);

return c__11625__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args31873 = [];
var len__8975__auto___31876 = arguments.length;
var i__8976__auto___31877 = (0);
while(true){
if((i__8976__auto___31877 < len__8975__auto___31876)){
args31873.push((arguments[i__8976__auto___31877]));

var G__31878 = (i__8976__auto___31877 + (1));
i__8976__auto___31877 = G__31878;
continue;
} else {
}
break;
}

var G__31875 = args31873.length;
switch (G__31875) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31873.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args31880 = [];
var len__8975__auto___31883 = arguments.length;
var i__8976__auto___31884 = (0);
while(true){
if((i__8976__auto___31884 < len__8975__auto___31883)){
args31880.push((arguments[i__8976__auto___31884]));

var G__31885 = (i__8976__auto___31884 + (1));
i__8976__auto___31884 = G__31885;
continue;
} else {
}
break;
}

var G__31882 = args31880.length;
switch (G__31882) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31880.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args31887 = [];
var len__8975__auto___31938 = arguments.length;
var i__8976__auto___31939 = (0);
while(true){
if((i__8976__auto___31939 < len__8975__auto___31938)){
args31887.push((arguments[i__8976__auto___31939]));

var G__31940 = (i__8976__auto___31939 + (1));
i__8976__auto___31939 = G__31940;
continue;
} else {
}
break;
}

var G__31889 = args31887.length;
switch (G__31889) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31887.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___31942 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___31942,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___31942,out){
return (function (state_31913){
var state_val_31914 = (state_31913[(1)]);
if((state_val_31914 === (7))){
var inst_31908 = (state_31913[(2)]);
var state_31913__$1 = state_31913;
var statearr_31915_31943 = state_31913__$1;
(statearr_31915_31943[(2)] = inst_31908);

(statearr_31915_31943[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (1))){
var inst_31890 = null;
var state_31913__$1 = (function (){var statearr_31916 = state_31913;
(statearr_31916[(7)] = inst_31890);

return statearr_31916;
})();
var statearr_31917_31944 = state_31913__$1;
(statearr_31917_31944[(2)] = null);

(statearr_31917_31944[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (4))){
var inst_31893 = (state_31913[(8)]);
var inst_31893__$1 = (state_31913[(2)]);
var inst_31894 = (inst_31893__$1 == null);
var inst_31895 = cljs.core.not(inst_31894);
var state_31913__$1 = (function (){var statearr_31918 = state_31913;
(statearr_31918[(8)] = inst_31893__$1);

return statearr_31918;
})();
if(inst_31895){
var statearr_31919_31945 = state_31913__$1;
(statearr_31919_31945[(1)] = (5));

} else {
var statearr_31920_31946 = state_31913__$1;
(statearr_31920_31946[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (6))){
var state_31913__$1 = state_31913;
var statearr_31921_31947 = state_31913__$1;
(statearr_31921_31947[(2)] = null);

(statearr_31921_31947[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (3))){
var inst_31910 = (state_31913[(2)]);
var inst_31911 = cljs.core.async.close_BANG_(out);
var state_31913__$1 = (function (){var statearr_31922 = state_31913;
(statearr_31922[(9)] = inst_31910);

return statearr_31922;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31913__$1,inst_31911);
} else {
if((state_val_31914 === (2))){
var state_31913__$1 = state_31913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31913__$1,(4),ch);
} else {
if((state_val_31914 === (11))){
var inst_31893 = (state_31913[(8)]);
var inst_31902 = (state_31913[(2)]);
var inst_31890 = inst_31893;
var state_31913__$1 = (function (){var statearr_31923 = state_31913;
(statearr_31923[(10)] = inst_31902);

(statearr_31923[(7)] = inst_31890);

return statearr_31923;
})();
var statearr_31924_31948 = state_31913__$1;
(statearr_31924_31948[(2)] = null);

(statearr_31924_31948[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (9))){
var inst_31893 = (state_31913[(8)]);
var state_31913__$1 = state_31913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31913__$1,(11),out,inst_31893);
} else {
if((state_val_31914 === (5))){
var inst_31893 = (state_31913[(8)]);
var inst_31890 = (state_31913[(7)]);
var inst_31897 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31893,inst_31890);
var state_31913__$1 = state_31913;
if(inst_31897){
var statearr_31926_31949 = state_31913__$1;
(statearr_31926_31949[(1)] = (8));

} else {
var statearr_31927_31950 = state_31913__$1;
(statearr_31927_31950[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (10))){
var inst_31905 = (state_31913[(2)]);
var state_31913__$1 = state_31913;
var statearr_31928_31951 = state_31913__$1;
(statearr_31928_31951[(2)] = inst_31905);

(statearr_31928_31951[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31914 === (8))){
var inst_31890 = (state_31913[(7)]);
var tmp31925 = inst_31890;
var inst_31890__$1 = tmp31925;
var state_31913__$1 = (function (){var statearr_31929 = state_31913;
(statearr_31929[(7)] = inst_31890__$1);

return statearr_31929;
})();
var statearr_31930_31952 = state_31913__$1;
(statearr_31930_31952[(2)] = null);

(statearr_31930_31952[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___31942,out))
;
return ((function (switch__11560__auto__,c__11625__auto___31942,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_31934 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31934[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_31934[(1)] = (1));

return statearr_31934;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31913){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31913);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e31935){if((e31935 instanceof Object)){
var ex__11564__auto__ = e31935;
var statearr_31936_31953 = state_31913;
(statearr_31936_31953[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31913);

return cljs.core.constant$keyword$recur;
} else {
throw e31935;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__31954 = state_31913;
state_31913 = G__31954;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___31942,out))
})();
var state__11627__auto__ = (function (){var statearr_31937 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_31937[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___31942);

return statearr_31937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___31942,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args31955 = [];
var len__8975__auto___32025 = arguments.length;
var i__8976__auto___32026 = (0);
while(true){
if((i__8976__auto___32026 < len__8975__auto___32025)){
args31955.push((arguments[i__8976__auto___32026]));

var G__32027 = (i__8976__auto___32026 + (1));
i__8976__auto___32026 = G__32027;
continue;
} else {
}
break;
}

var G__31957 = args31955.length;
switch (G__31957) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31955.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___32029 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___32029,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___32029,out){
return (function (state_31995){
var state_val_31996 = (state_31995[(1)]);
if((state_val_31996 === (7))){
var inst_31991 = (state_31995[(2)]);
var state_31995__$1 = state_31995;
var statearr_31997_32030 = state_31995__$1;
(statearr_31997_32030[(2)] = inst_31991);

(statearr_31997_32030[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (1))){
var inst_31958 = (new Array(n));
var inst_31959 = inst_31958;
var inst_31960 = (0);
var state_31995__$1 = (function (){var statearr_31998 = state_31995;
(statearr_31998[(7)] = inst_31960);

(statearr_31998[(8)] = inst_31959);

return statearr_31998;
})();
var statearr_31999_32031 = state_31995__$1;
(statearr_31999_32031[(2)] = null);

(statearr_31999_32031[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (4))){
var inst_31963 = (state_31995[(9)]);
var inst_31963__$1 = (state_31995[(2)]);
var inst_31964 = (inst_31963__$1 == null);
var inst_31965 = cljs.core.not(inst_31964);
var state_31995__$1 = (function (){var statearr_32000 = state_31995;
(statearr_32000[(9)] = inst_31963__$1);

return statearr_32000;
})();
if(inst_31965){
var statearr_32001_32032 = state_31995__$1;
(statearr_32001_32032[(1)] = (5));

} else {
var statearr_32002_32033 = state_31995__$1;
(statearr_32002_32033[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (15))){
var inst_31985 = (state_31995[(2)]);
var state_31995__$1 = state_31995;
var statearr_32003_32034 = state_31995__$1;
(statearr_32003_32034[(2)] = inst_31985);

(statearr_32003_32034[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (13))){
var state_31995__$1 = state_31995;
var statearr_32004_32035 = state_31995__$1;
(statearr_32004_32035[(2)] = null);

(statearr_32004_32035[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (6))){
var inst_31960 = (state_31995[(7)]);
var inst_31981 = (inst_31960 > (0));
var state_31995__$1 = state_31995;
if(cljs.core.truth_(inst_31981)){
var statearr_32005_32036 = state_31995__$1;
(statearr_32005_32036[(1)] = (12));

} else {
var statearr_32006_32037 = state_31995__$1;
(statearr_32006_32037[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (3))){
var inst_31993 = (state_31995[(2)]);
var state_31995__$1 = state_31995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31995__$1,inst_31993);
} else {
if((state_val_31996 === (12))){
var inst_31959 = (state_31995[(8)]);
var inst_31983 = cljs.core.vec(inst_31959);
var state_31995__$1 = state_31995;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31995__$1,(15),out,inst_31983);
} else {
if((state_val_31996 === (2))){
var state_31995__$1 = state_31995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31995__$1,(4),ch);
} else {
if((state_val_31996 === (11))){
var inst_31975 = (state_31995[(2)]);
var inst_31976 = (new Array(n));
var inst_31959 = inst_31976;
var inst_31960 = (0);
var state_31995__$1 = (function (){var statearr_32007 = state_31995;
(statearr_32007[(10)] = inst_31975);

(statearr_32007[(7)] = inst_31960);

(statearr_32007[(8)] = inst_31959);

return statearr_32007;
})();
var statearr_32008_32038 = state_31995__$1;
(statearr_32008_32038[(2)] = null);

(statearr_32008_32038[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (9))){
var inst_31959 = (state_31995[(8)]);
var inst_31973 = cljs.core.vec(inst_31959);
var state_31995__$1 = state_31995;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31995__$1,(11),out,inst_31973);
} else {
if((state_val_31996 === (5))){
var inst_31963 = (state_31995[(9)]);
var inst_31960 = (state_31995[(7)]);
var inst_31968 = (state_31995[(11)]);
var inst_31959 = (state_31995[(8)]);
var inst_31967 = (inst_31959[inst_31960] = inst_31963);
var inst_31968__$1 = (inst_31960 + (1));
var inst_31969 = (inst_31968__$1 < n);
var state_31995__$1 = (function (){var statearr_32009 = state_31995;
(statearr_32009[(12)] = inst_31967);

(statearr_32009[(11)] = inst_31968__$1);

return statearr_32009;
})();
if(cljs.core.truth_(inst_31969)){
var statearr_32010_32039 = state_31995__$1;
(statearr_32010_32039[(1)] = (8));

} else {
var statearr_32011_32040 = state_31995__$1;
(statearr_32011_32040[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (14))){
var inst_31988 = (state_31995[(2)]);
var inst_31989 = cljs.core.async.close_BANG_(out);
var state_31995__$1 = (function (){var statearr_32013 = state_31995;
(statearr_32013[(13)] = inst_31988);

return statearr_32013;
})();
var statearr_32014_32041 = state_31995__$1;
(statearr_32014_32041[(2)] = inst_31989);

(statearr_32014_32041[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (10))){
var inst_31979 = (state_31995[(2)]);
var state_31995__$1 = state_31995;
var statearr_32015_32042 = state_31995__$1;
(statearr_32015_32042[(2)] = inst_31979);

(statearr_32015_32042[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31996 === (8))){
var inst_31968 = (state_31995[(11)]);
var inst_31959 = (state_31995[(8)]);
var tmp32012 = inst_31959;
var inst_31959__$1 = tmp32012;
var inst_31960 = inst_31968;
var state_31995__$1 = (function (){var statearr_32016 = state_31995;
(statearr_32016[(7)] = inst_31960);

(statearr_32016[(8)] = inst_31959__$1);

return statearr_32016;
})();
var statearr_32017_32043 = state_31995__$1;
(statearr_32017_32043[(2)] = null);

(statearr_32017_32043[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___32029,out))
;
return ((function (switch__11560__auto__,c__11625__auto___32029,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_32021 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32021[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_32021[(1)] = (1));

return statearr_32021;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_31995){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_31995);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e32022){if((e32022 instanceof Object)){
var ex__11564__auto__ = e32022;
var statearr_32023_32044 = state_31995;
(statearr_32023_32044[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31995);

return cljs.core.constant$keyword$recur;
} else {
throw e32022;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__32045 = state_31995;
state_31995 = G__32045;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_31995){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_31995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___32029,out))
})();
var state__11627__auto__ = (function (){var statearr_32024 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_32024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___32029);

return statearr_32024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___32029,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args32046 = [];
var len__8975__auto___32120 = arguments.length;
var i__8976__auto___32121 = (0);
while(true){
if((i__8976__auto___32121 < len__8975__auto___32120)){
args32046.push((arguments[i__8976__auto___32121]));

var G__32122 = (i__8976__auto___32121 + (1));
i__8976__auto___32121 = G__32122;
continue;
} else {
}
break;
}

var G__32048 = args32046.length;
switch (G__32048) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32046.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11625__auto___32124 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___32124,out){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___32124,out){
return (function (state_32090){
var state_val_32091 = (state_32090[(1)]);
if((state_val_32091 === (7))){
var inst_32086 = (state_32090[(2)]);
var state_32090__$1 = state_32090;
var statearr_32092_32125 = state_32090__$1;
(statearr_32092_32125[(2)] = inst_32086);

(statearr_32092_32125[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (1))){
var inst_32049 = [];
var inst_32050 = inst_32049;
var inst_32051 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_32090__$1 = (function (){var statearr_32093 = state_32090;
(statearr_32093[(7)] = inst_32050);

(statearr_32093[(8)] = inst_32051);

return statearr_32093;
})();
var statearr_32094_32126 = state_32090__$1;
(statearr_32094_32126[(2)] = null);

(statearr_32094_32126[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (4))){
var inst_32054 = (state_32090[(9)]);
var inst_32054__$1 = (state_32090[(2)]);
var inst_32055 = (inst_32054__$1 == null);
var inst_32056 = cljs.core.not(inst_32055);
var state_32090__$1 = (function (){var statearr_32095 = state_32090;
(statearr_32095[(9)] = inst_32054__$1);

return statearr_32095;
})();
if(inst_32056){
var statearr_32096_32127 = state_32090__$1;
(statearr_32096_32127[(1)] = (5));

} else {
var statearr_32097_32128 = state_32090__$1;
(statearr_32097_32128[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (15))){
var inst_32080 = (state_32090[(2)]);
var state_32090__$1 = state_32090;
var statearr_32098_32129 = state_32090__$1;
(statearr_32098_32129[(2)] = inst_32080);

(statearr_32098_32129[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (13))){
var state_32090__$1 = state_32090;
var statearr_32099_32130 = state_32090__$1;
(statearr_32099_32130[(2)] = null);

(statearr_32099_32130[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (6))){
var inst_32050 = (state_32090[(7)]);
var inst_32075 = inst_32050.length;
var inst_32076 = (inst_32075 > (0));
var state_32090__$1 = state_32090;
if(cljs.core.truth_(inst_32076)){
var statearr_32100_32131 = state_32090__$1;
(statearr_32100_32131[(1)] = (12));

} else {
var statearr_32101_32132 = state_32090__$1;
(statearr_32101_32132[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (3))){
var inst_32088 = (state_32090[(2)]);
var state_32090__$1 = state_32090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32090__$1,inst_32088);
} else {
if((state_val_32091 === (12))){
var inst_32050 = (state_32090[(7)]);
var inst_32078 = cljs.core.vec(inst_32050);
var state_32090__$1 = state_32090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32090__$1,(15),out,inst_32078);
} else {
if((state_val_32091 === (2))){
var state_32090__$1 = state_32090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32090__$1,(4),ch);
} else {
if((state_val_32091 === (11))){
var inst_32058 = (state_32090[(10)]);
var inst_32054 = (state_32090[(9)]);
var inst_32068 = (state_32090[(2)]);
var inst_32069 = [];
var inst_32070 = inst_32069.push(inst_32054);
var inst_32050 = inst_32069;
var inst_32051 = inst_32058;
var state_32090__$1 = (function (){var statearr_32102 = state_32090;
(statearr_32102[(11)] = inst_32070);

(statearr_32102[(7)] = inst_32050);

(statearr_32102[(12)] = inst_32068);

(statearr_32102[(8)] = inst_32051);

return statearr_32102;
})();
var statearr_32103_32133 = state_32090__$1;
(statearr_32103_32133[(2)] = null);

(statearr_32103_32133[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (9))){
var inst_32050 = (state_32090[(7)]);
var inst_32066 = cljs.core.vec(inst_32050);
var state_32090__$1 = state_32090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32090__$1,(11),out,inst_32066);
} else {
if((state_val_32091 === (5))){
var inst_32058 = (state_32090[(10)]);
var inst_32054 = (state_32090[(9)]);
var inst_32051 = (state_32090[(8)]);
var inst_32058__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32054) : f.call(null,inst_32054));
var inst_32059 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32058__$1,inst_32051);
var inst_32060 = cljs.core.keyword_identical_QMARK_(inst_32051,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_32061 = (inst_32059) || (inst_32060);
var state_32090__$1 = (function (){var statearr_32104 = state_32090;
(statearr_32104[(10)] = inst_32058__$1);

return statearr_32104;
})();
if(cljs.core.truth_(inst_32061)){
var statearr_32105_32134 = state_32090__$1;
(statearr_32105_32134[(1)] = (8));

} else {
var statearr_32106_32135 = state_32090__$1;
(statearr_32106_32135[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (14))){
var inst_32083 = (state_32090[(2)]);
var inst_32084 = cljs.core.async.close_BANG_(out);
var state_32090__$1 = (function (){var statearr_32108 = state_32090;
(statearr_32108[(13)] = inst_32083);

return statearr_32108;
})();
var statearr_32109_32136 = state_32090__$1;
(statearr_32109_32136[(2)] = inst_32084);

(statearr_32109_32136[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (10))){
var inst_32073 = (state_32090[(2)]);
var state_32090__$1 = state_32090;
var statearr_32110_32137 = state_32090__$1;
(statearr_32110_32137[(2)] = inst_32073);

(statearr_32110_32137[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32091 === (8))){
var inst_32050 = (state_32090[(7)]);
var inst_32058 = (state_32090[(10)]);
var inst_32054 = (state_32090[(9)]);
var inst_32063 = inst_32050.push(inst_32054);
var tmp32107 = inst_32050;
var inst_32050__$1 = tmp32107;
var inst_32051 = inst_32058;
var state_32090__$1 = (function (){var statearr_32111 = state_32090;
(statearr_32111[(7)] = inst_32050__$1);

(statearr_32111[(8)] = inst_32051);

(statearr_32111[(14)] = inst_32063);

return statearr_32111;
})();
var statearr_32112_32138 = state_32090__$1;
(statearr_32112_32138[(2)] = null);

(statearr_32112_32138[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___32124,out))
;
return ((function (switch__11560__auto__,c__11625__auto___32124,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_32116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32116[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_32116[(1)] = (1));

return statearr_32116;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_32090){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_32090);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e32117){if((e32117 instanceof Object)){
var ex__11564__auto__ = e32117;
var statearr_32118_32139 = state_32090;
(statearr_32118_32139[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32090);

return cljs.core.constant$keyword$recur;
} else {
throw e32117;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__32140 = state_32090;
state_32090 = G__32140;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_32090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_32090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___32124,out))
})();
var state__11627__auto__ = (function (){var statearr_32119 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_32119[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___32124);

return statearr_32119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___32124,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
