// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.get = (function milia$api$dataview$get(){
var args__8986__auto__ = [];
var len__8979__auto___28130 = arguments.length;
var i__8980__auto___28131 = (0);
while(true){
if((i__8980__auto___28131 < len__8979__auto___28130)){
args__8986__auto__.push((arguments[i__8980__auto___28131]));

var G__28132 = (i__8980__auto___28131 + (1));
i__8980__auto___28131 = G__28132;
continue;
} else {
}
break;
}

var argseq__8987__auto__ = ((((1) < args__8986__auto__.length))?(new cljs.core.IndexedSeq(args__8986__auto__.slice((1)),(0))):null);
return milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8987__auto__);
});

milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic = (function (dataview_id,p__28127){
var map__28128 = p__28127;
var map__28128__$1 = ((((!((map__28128 == null)))?((((map__28128.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28128.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28128):map__28128);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28128__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$no_DASH_cache_QMARK_,no_cache_QMARK_,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataview.get.cljs$lang$maxFixedArity = (1);

milia.api.dataview.get.cljs$lang$applyTo = (function (seq28125){
var G__28126 = cljs.core.first(seq28125);
var seq28125__$1 = cljs.core.next(seq28125);
return milia.api.dataview.get.cljs$core$IFn$_invoke$arity$variadic(G__28126,seq28125__$1);
});
/**
 * Retrieves dataview data using dataview id
 */
milia.api.dataview.data = (function milia$api$dataview$data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$raw_DASH_response_QMARK_,true], 0));
});
/**
 * Retrieves form used to create dataview
 */
milia.api.dataview.form = (function milia$api$dataview$form(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"form.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(dataview_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
