// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like(elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like(elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like(elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__29208 = arguments.length;
switch (G__29208) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__29209 = dommy.template.__GT_node_like(parent);
G__29209.appendChild(dommy.template.__GT_node_like(child));

return G__29209;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__29210_29215 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__29211_29216 = null;
var count__29212_29217 = (0);
var i__29213_29218 = (0);
while(true){
if((i__29213_29218 < count__29212_29217)){
var c_29219 = chunk__29211_29216.cljs$core$IIndexed$_nth$arity$2(null,i__29213_29218);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_29219);

var G__29220 = seq__29210_29215;
var G__29221 = chunk__29211_29216;
var G__29222 = count__29212_29217;
var G__29223 = (i__29213_29218 + (1));
seq__29210_29215 = G__29220;
chunk__29211_29216 = G__29221;
count__29212_29217 = G__29222;
i__29213_29218 = G__29223;
continue;
} else {
var temp__4126__auto___29224 = cljs.core.seq(seq__29210_29215);
if(temp__4126__auto___29224){
var seq__29210_29225__$1 = temp__4126__auto___29224;
if(cljs.core.chunked_seq_QMARK_(seq__29210_29225__$1)){
var c__5061__auto___29226 = cljs.core.chunk_first(seq__29210_29225__$1);
var G__29227 = cljs.core.chunk_rest(seq__29210_29225__$1);
var G__29228 = c__5061__auto___29226;
var G__29229 = cljs.core.count(c__5061__auto___29226);
var G__29230 = (0);
seq__29210_29215 = G__29227;
chunk__29211_29216 = G__29228;
count__29212_29217 = G__29229;
i__29213_29218 = G__29230;
continue;
} else {
var c_29231 = cljs.core.first(seq__29210_29225__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_29231);

var G__29232 = cljs.core.next(seq__29210_29225__$1);
var G__29233 = null;
var G__29234 = (0);
var G__29235 = (0);
seq__29210_29215 = G__29232;
chunk__29211_29216 = G__29233;
count__29212_29217 = G__29234;
i__29213_29218 = G__29235;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq29204){
var G__29205 = cljs.core.first(seq29204);
var seq29204__$1 = cljs.core.next(seq29204);
var G__29206 = cljs.core.first(seq29204__$1);
var seq29204__$2 = cljs.core.next(seq29204__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29205,G__29206,seq29204__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__29240 = arguments.length;
switch (G__29240) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like(parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like(child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__29241_29246 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__29242_29247 = null;
var count__29243_29248 = (0);
var i__29244_29249 = (0);
while(true){
if((i__29244_29249 < count__29243_29248)){
var c_29250 = chunk__29242_29247.cljs$core$IIndexed$_nth$arity$2(null,i__29244_29249);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_29250);

var G__29251 = seq__29241_29246;
var G__29252 = chunk__29242_29247;
var G__29253 = count__29243_29248;
var G__29254 = (i__29244_29249 + (1));
seq__29241_29246 = G__29251;
chunk__29242_29247 = G__29252;
count__29243_29248 = G__29253;
i__29244_29249 = G__29254;
continue;
} else {
var temp__4126__auto___29255 = cljs.core.seq(seq__29241_29246);
if(temp__4126__auto___29255){
var seq__29241_29256__$1 = temp__4126__auto___29255;
if(cljs.core.chunked_seq_QMARK_(seq__29241_29256__$1)){
var c__5061__auto___29257 = cljs.core.chunk_first(seq__29241_29256__$1);
var G__29258 = cljs.core.chunk_rest(seq__29241_29256__$1);
var G__29259 = c__5061__auto___29257;
var G__29260 = cljs.core.count(c__5061__auto___29257);
var G__29261 = (0);
seq__29241_29246 = G__29258;
chunk__29242_29247 = G__29259;
count__29243_29248 = G__29260;
i__29244_29249 = G__29261;
continue;
} else {
var c_29262 = cljs.core.first(seq__29241_29256__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_29262);

var G__29263 = cljs.core.next(seq__29241_29256__$1);
var G__29264 = null;
var G__29265 = (0);
var G__29266 = (0);
seq__29241_29246 = G__29263;
chunk__29242_29247 = G__29264;
count__29243_29248 = G__29265;
i__29244_29249 = G__29266;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq29236){
var G__29237 = cljs.core.first(seq29236);
var seq29236__$1 = cljs.core.next(seq29236);
var G__29238 = cljs.core.first(seq29236__$1);
var seq29236__$2 = cljs.core.next(seq29236__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29237,G__29238,seq29236__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))], 0)))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
var parent = other__$1.parentNode;
var temp__4124__auto___29267 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___29267)){
var next_29268 = temp__4124__auto___29267;
parent.insertBefore(actual_node,next_29268);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like(new$);
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))], 0)))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__29270 = dommy.template.__GT_node_like(parent);
G__29270.innerHTML = "";

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(G__29270,node_like);

return G__29270;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
var G__29272 = elem__$1.parentNode;
G__29272.removeChild(elem__$1);

return G__29272;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like(elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like(template);
if(!(cljs.core.contains_QMARK_(key_selectors_map,cljs.core.constant$keyword$container))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),cljs.core.constant$keyword$container))], 0)))].join('')));
}

return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$container,container], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (container){
return (function (p__29278){
var vec__29279 = p__29278;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29279,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29279,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(cljs.core.constant$keyword$live.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))?(function (){
if(typeof dommy.core.t29280 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t29280 = (function (v,k,vec__29279,p__29278,container,key_selectors_map,template,selector_map,meta29281){
this.v = v;
this.k = k;
this.vec__29279 = vec__29279;
this.p__29278 = p__29278;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta29281 = meta29281;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t29280.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__29279,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array(dommy.template.__GT_node_like(self__.container).querySelectorAll(dommy.core.selector(self__.v)));
});})(vec__29279,k,v,container))
;

dommy.core.t29280.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__29279,k,v,container){
return (function (_29282){
var self__ = this;
var _29282__$1 = this;
return self__.meta29281;
});})(vec__29279,k,v,container))
;

dommy.core.t29280.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__29279,k,v,container){
return (function (_29282,meta29281__$1){
var self__ = this;
var _29282__$1 = this;
return (new dommy.core.t29280(self__.v,self__.k,self__.vec__29279,self__.p__29278,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta29281__$1));
});})(vec__29279,k,v,container))
;

dommy.core.t29280.cljs$lang$type = true;

dommy.core.t29280.cljs$lang$ctorStr = "dommy.core/t29280";

dommy.core.t29280.cljs$lang$ctorPrWriter = ((function (vec__29279,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"dommy.core/t29280");
});})(vec__29279,k,v,container))
;

dommy.core.__GT_t29280 = ((function (vec__29279,k,v,container){
return (function dommy$core$selector_map_$___GT_t29280(v__$1,k__$1,vec__29279__$1,p__29278__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta29281){
return (new dommy.core.t29280(v__$1,k__$1,vec__29279__$1,p__29278__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta29281));
});})(vec__29279,k,v,container))
;

}

return (new dommy.core.t29280(v,k,vec__29279,p__29278,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like(container).querySelector(dommy.core.selector(v)))], null);
});})(container))
,key_selectors_map))], 0));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate((function (p1__29283_SHARP_){
return p1__29283_SHARP_.parentNode;
}),dommy.template.__GT_node_like(elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__29285 = arguments.length;
switch (G__29285) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(dommy.template.__GT_node_like(dommy.template.__GT_node_like(base)).querySelectorAll(dommy.core.selector(selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__29289 = arguments.length;
switch (G__29289) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like(base);
var elem__$1 = dommy.template.__GT_node_like(elem);
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base__$1,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (base__$1,elem__$1){
return (function (p1__29287_SHARP_){
return !((p1__29287_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes(elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1(selector),dommy.core.ancestor_nodes(dommy.template.__GT_node_like(elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like(descendant);
var ancestor__$1 = dommy.template.__GT_node_like(ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__29291){
var vec__29292 = p__29291;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29292,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29292,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__29292,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__29292,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
var G__29293 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__29293) : f.call(null,G__29293));
}
});
;})(vec__29292,special_mouse_event,real_mouse_event))
});})(vec__29292,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$mouseenter,cljs.core.constant$keyword$mouseover,cljs.core.constant$keyword$mouseleave,cljs.core.constant$keyword$mouseout], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not((function (){var G__29297 = selected_target;
var G__29298 = cljs.core.constant$keyword$disabled;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__29297,G__29298) : dommy.core.attr.call(null,G__29297,G__29298));
})());
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

var G__29299 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__29299) : f.call(null,G__29299));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like(elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like(elem);
return elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq29300){
var G__29301 = cljs.core.first(seq29300);
var seq29300__$1 = cljs.core.next(seq29300);
var G__29302 = cljs.core.first(seq29300__$1);
var seq29300__$2 = cljs.core.next(seq29300__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29301,G__29302,seq29300__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((function (p1__29303_SHARP_){
return dommy.template.__GT_node_like(cljs.core.first(p1__29303_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like(elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__29306_29333 = dommy.core.elem_and_selector(elem_sel);
var elem_29334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29306_29333,(0),null);
var selector_29335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29306_29333,(1),null);
var seq__29307_29336 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__29314_29337 = null;
var count__29315_29338 = (0);
var i__29316_29339 = (0);
while(true){
if((i__29316_29339 < count__29315_29338)){
var vec__29323_29340 = chunk__29314_29337.cljs$core$IIndexed$_nth$arity$2(null,i__29316_29339);
var orig_type_29341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29323_29340,(0),null);
var f_29342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29323_29340,(1),null);
var seq__29317_29343 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29341,new cljs.core.PersistentArrayMap.fromArray([orig_type_29341,cljs.core.identity], true, false)));
var chunk__29319_29344 = null;
var count__29320_29345 = (0);
var i__29321_29346 = (0);
while(true){
if((i__29321_29346 < count__29320_29345)){
var vec__29324_29347 = chunk__29319_29344.cljs$core$IIndexed$_nth$arity$2(null,i__29321_29346);
var actual_type_29348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29324_29347,(0),null);
var factory_29349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29324_29347,(1),null);
var canonical_f_29350 = (cljs.core.truth_(selector_29335)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_29334,selector_29335):cljs.core.identity).call(null,(function (){var G__29325 = f_29342;
return (factory_29349.cljs$core$IFn$_invoke$arity$1 ? factory_29349.cljs$core$IFn$_invoke$arity$1(G__29325) : factory_29349.call(null,G__29325));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29334,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29335,actual_type_29348,f_29342], null),canonical_f_29350], 0));

if(cljs.core.truth_(elem_29334.addEventListener)){
elem_29334.addEventListener(cljs.core.name(actual_type_29348),canonical_f_29350);
} else {
elem_29334.attachEvent(cljs.core.name(actual_type_29348),canonical_f_29350);
}

var G__29351 = seq__29317_29343;
var G__29352 = chunk__29319_29344;
var G__29353 = count__29320_29345;
var G__29354 = (i__29321_29346 + (1));
seq__29317_29343 = G__29351;
chunk__29319_29344 = G__29352;
count__29320_29345 = G__29353;
i__29321_29346 = G__29354;
continue;
} else {
var temp__4126__auto___29355 = cljs.core.seq(seq__29317_29343);
if(temp__4126__auto___29355){
var seq__29317_29356__$1 = temp__4126__auto___29355;
if(cljs.core.chunked_seq_QMARK_(seq__29317_29356__$1)){
var c__5061__auto___29357 = cljs.core.chunk_first(seq__29317_29356__$1);
var G__29358 = cljs.core.chunk_rest(seq__29317_29356__$1);
var G__29359 = c__5061__auto___29357;
var G__29360 = cljs.core.count(c__5061__auto___29357);
var G__29361 = (0);
seq__29317_29343 = G__29358;
chunk__29319_29344 = G__29359;
count__29320_29345 = G__29360;
i__29321_29346 = G__29361;
continue;
} else {
var vec__29326_29362 = cljs.core.first(seq__29317_29356__$1);
var actual_type_29363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29326_29362,(0),null);
var factory_29364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29326_29362,(1),null);
var canonical_f_29365 = (cljs.core.truth_(selector_29335)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_29334,selector_29335):cljs.core.identity).call(null,(function (){var G__29327 = f_29342;
return (factory_29364.cljs$core$IFn$_invoke$arity$1 ? factory_29364.cljs$core$IFn$_invoke$arity$1(G__29327) : factory_29364.call(null,G__29327));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29334,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29335,actual_type_29363,f_29342], null),canonical_f_29365], 0));

if(cljs.core.truth_(elem_29334.addEventListener)){
elem_29334.addEventListener(cljs.core.name(actual_type_29363),canonical_f_29365);
} else {
elem_29334.attachEvent(cljs.core.name(actual_type_29363),canonical_f_29365);
}

var G__29366 = cljs.core.next(seq__29317_29356__$1);
var G__29367 = null;
var G__29368 = (0);
var G__29369 = (0);
seq__29317_29343 = G__29366;
chunk__29319_29344 = G__29367;
count__29320_29345 = G__29368;
i__29321_29346 = G__29369;
continue;
}
} else {
}
}
break;
}

var G__29370 = seq__29307_29336;
var G__29371 = chunk__29314_29337;
var G__29372 = count__29315_29338;
var G__29373 = (i__29316_29339 + (1));
seq__29307_29336 = G__29370;
chunk__29314_29337 = G__29371;
count__29315_29338 = G__29372;
i__29316_29339 = G__29373;
continue;
} else {
var temp__4126__auto___29374 = cljs.core.seq(seq__29307_29336);
if(temp__4126__auto___29374){
var seq__29307_29375__$1 = temp__4126__auto___29374;
if(cljs.core.chunked_seq_QMARK_(seq__29307_29375__$1)){
var c__5061__auto___29376 = cljs.core.chunk_first(seq__29307_29375__$1);
var G__29377 = cljs.core.chunk_rest(seq__29307_29375__$1);
var G__29378 = c__5061__auto___29376;
var G__29379 = cljs.core.count(c__5061__auto___29376);
var G__29380 = (0);
seq__29307_29336 = G__29377;
chunk__29314_29337 = G__29378;
count__29315_29338 = G__29379;
i__29316_29339 = G__29380;
continue;
} else {
var vec__29328_29381 = cljs.core.first(seq__29307_29375__$1);
var orig_type_29382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29328_29381,(0),null);
var f_29383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29328_29381,(1),null);
var seq__29308_29384 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29382,new cljs.core.PersistentArrayMap.fromArray([orig_type_29382,cljs.core.identity], true, false)));
var chunk__29310_29385 = null;
var count__29311_29386 = (0);
var i__29312_29387 = (0);
while(true){
if((i__29312_29387 < count__29311_29386)){
var vec__29329_29388 = chunk__29310_29385.cljs$core$IIndexed$_nth$arity$2(null,i__29312_29387);
var actual_type_29389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29329_29388,(0),null);
var factory_29390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29329_29388,(1),null);
var canonical_f_29391 = (cljs.core.truth_(selector_29335)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_29334,selector_29335):cljs.core.identity).call(null,(function (){var G__29330 = f_29383;
return (factory_29390.cljs$core$IFn$_invoke$arity$1 ? factory_29390.cljs$core$IFn$_invoke$arity$1(G__29330) : factory_29390.call(null,G__29330));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29334,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29335,actual_type_29389,f_29383], null),canonical_f_29391], 0));

if(cljs.core.truth_(elem_29334.addEventListener)){
elem_29334.addEventListener(cljs.core.name(actual_type_29389),canonical_f_29391);
} else {
elem_29334.attachEvent(cljs.core.name(actual_type_29389),canonical_f_29391);
}

var G__29392 = seq__29308_29384;
var G__29393 = chunk__29310_29385;
var G__29394 = count__29311_29386;
var G__29395 = (i__29312_29387 + (1));
seq__29308_29384 = G__29392;
chunk__29310_29385 = G__29393;
count__29311_29386 = G__29394;
i__29312_29387 = G__29395;
continue;
} else {
var temp__4126__auto___29396__$1 = cljs.core.seq(seq__29308_29384);
if(temp__4126__auto___29396__$1){
var seq__29308_29397__$1 = temp__4126__auto___29396__$1;
if(cljs.core.chunked_seq_QMARK_(seq__29308_29397__$1)){
var c__5061__auto___29398 = cljs.core.chunk_first(seq__29308_29397__$1);
var G__29399 = cljs.core.chunk_rest(seq__29308_29397__$1);
var G__29400 = c__5061__auto___29398;
var G__29401 = cljs.core.count(c__5061__auto___29398);
var G__29402 = (0);
seq__29308_29384 = G__29399;
chunk__29310_29385 = G__29400;
count__29311_29386 = G__29401;
i__29312_29387 = G__29402;
continue;
} else {
var vec__29331_29403 = cljs.core.first(seq__29308_29397__$1);
var actual_type_29404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29331_29403,(0),null);
var factory_29405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29331_29403,(1),null);
var canonical_f_29406 = (cljs.core.truth_(selector_29335)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_29334,selector_29335):cljs.core.identity).call(null,(function (){var G__29332 = f_29383;
return (factory_29405.cljs$core$IFn$_invoke$arity$1 ? factory_29405.cljs$core$IFn$_invoke$arity$1(G__29332) : factory_29405.call(null,G__29332));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29334,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29335,actual_type_29404,f_29383], null),canonical_f_29406], 0));

if(cljs.core.truth_(elem_29334.addEventListener)){
elem_29334.addEventListener(cljs.core.name(actual_type_29404),canonical_f_29406);
} else {
elem_29334.attachEvent(cljs.core.name(actual_type_29404),canonical_f_29406);
}

var G__29407 = cljs.core.next(seq__29308_29397__$1);
var G__29408 = null;
var G__29409 = (0);
var G__29410 = (0);
seq__29308_29384 = G__29407;
chunk__29310_29385 = G__29408;
count__29311_29386 = G__29409;
i__29312_29387 = G__29410;
continue;
}
} else {
}
}
break;
}

var G__29411 = cljs.core.next(seq__29307_29375__$1);
var G__29412 = null;
var G__29413 = (0);
var G__29414 = (0);
seq__29307_29336 = G__29411;
chunk__29314_29337 = G__29412;
count__29315_29338 = G__29413;
i__29316_29339 = G__29414;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq29304){
var G__29305 = cljs.core.first(seq29304);
var seq29304__$1 = cljs.core.next(seq29304);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29305,seq29304__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__29417_29440 = dommy.core.elem_and_selector(elem_sel);
var elem_29441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29417_29440,(0),null);
var selector_29442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29417_29440,(1),null);
var seq__29418_29443 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__29425_29444 = null;
var count__29426_29445 = (0);
var i__29427_29446 = (0);
while(true){
if((i__29427_29446 < count__29426_29445)){
var vec__29434_29447 = chunk__29425_29444.cljs$core$IIndexed$_nth$arity$2(null,i__29427_29446);
var orig_type_29448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29434_29447,(0),null);
var f_29449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29434_29447,(1),null);
var seq__29428_29450 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29448,new cljs.core.PersistentArrayMap.fromArray([orig_type_29448,cljs.core.identity], true, false)));
var chunk__29430_29451 = null;
var count__29431_29452 = (0);
var i__29432_29453 = (0);
while(true){
if((i__29432_29453 < count__29431_29452)){
var vec__29435_29454 = chunk__29430_29451.cljs$core$IIndexed$_nth$arity$2(null,i__29432_29453);
var actual_type_29455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29435_29454,(0),null);
var __29456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29435_29454,(1),null);
var keys_29457 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29442,actual_type_29455,f_29449], null);
var canonical_f_29458 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29441),keys_29457);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29441,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29457], 0));

if(cljs.core.truth_(elem_29441.removeEventListener)){
elem_29441.removeEventListener(cljs.core.name(actual_type_29455),canonical_f_29458);
} else {
elem_29441.detachEvent(cljs.core.name(actual_type_29455),canonical_f_29458);
}

var G__29459 = seq__29428_29450;
var G__29460 = chunk__29430_29451;
var G__29461 = count__29431_29452;
var G__29462 = (i__29432_29453 + (1));
seq__29428_29450 = G__29459;
chunk__29430_29451 = G__29460;
count__29431_29452 = G__29461;
i__29432_29453 = G__29462;
continue;
} else {
var temp__4126__auto___29463 = cljs.core.seq(seq__29428_29450);
if(temp__4126__auto___29463){
var seq__29428_29464__$1 = temp__4126__auto___29463;
if(cljs.core.chunked_seq_QMARK_(seq__29428_29464__$1)){
var c__5061__auto___29465 = cljs.core.chunk_first(seq__29428_29464__$1);
var G__29466 = cljs.core.chunk_rest(seq__29428_29464__$1);
var G__29467 = c__5061__auto___29465;
var G__29468 = cljs.core.count(c__5061__auto___29465);
var G__29469 = (0);
seq__29428_29450 = G__29466;
chunk__29430_29451 = G__29467;
count__29431_29452 = G__29468;
i__29432_29453 = G__29469;
continue;
} else {
var vec__29436_29470 = cljs.core.first(seq__29428_29464__$1);
var actual_type_29471 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436_29470,(0),null);
var __29472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436_29470,(1),null);
var keys_29473 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29442,actual_type_29471,f_29449], null);
var canonical_f_29474 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29441),keys_29473);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29441,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29473], 0));

if(cljs.core.truth_(elem_29441.removeEventListener)){
elem_29441.removeEventListener(cljs.core.name(actual_type_29471),canonical_f_29474);
} else {
elem_29441.detachEvent(cljs.core.name(actual_type_29471),canonical_f_29474);
}

var G__29475 = cljs.core.next(seq__29428_29464__$1);
var G__29476 = null;
var G__29477 = (0);
var G__29478 = (0);
seq__29428_29450 = G__29475;
chunk__29430_29451 = G__29476;
count__29431_29452 = G__29477;
i__29432_29453 = G__29478;
continue;
}
} else {
}
}
break;
}

var G__29479 = seq__29418_29443;
var G__29480 = chunk__29425_29444;
var G__29481 = count__29426_29445;
var G__29482 = (i__29427_29446 + (1));
seq__29418_29443 = G__29479;
chunk__29425_29444 = G__29480;
count__29426_29445 = G__29481;
i__29427_29446 = G__29482;
continue;
} else {
var temp__4126__auto___29483 = cljs.core.seq(seq__29418_29443);
if(temp__4126__auto___29483){
var seq__29418_29484__$1 = temp__4126__auto___29483;
if(cljs.core.chunked_seq_QMARK_(seq__29418_29484__$1)){
var c__5061__auto___29485 = cljs.core.chunk_first(seq__29418_29484__$1);
var G__29486 = cljs.core.chunk_rest(seq__29418_29484__$1);
var G__29487 = c__5061__auto___29485;
var G__29488 = cljs.core.count(c__5061__auto___29485);
var G__29489 = (0);
seq__29418_29443 = G__29486;
chunk__29425_29444 = G__29487;
count__29426_29445 = G__29488;
i__29427_29446 = G__29489;
continue;
} else {
var vec__29437_29490 = cljs.core.first(seq__29418_29484__$1);
var orig_type_29491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29437_29490,(0),null);
var f_29492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29437_29490,(1),null);
var seq__29419_29493 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29491,new cljs.core.PersistentArrayMap.fromArray([orig_type_29491,cljs.core.identity], true, false)));
var chunk__29421_29494 = null;
var count__29422_29495 = (0);
var i__29423_29496 = (0);
while(true){
if((i__29423_29496 < count__29422_29495)){
var vec__29438_29497 = chunk__29421_29494.cljs$core$IIndexed$_nth$arity$2(null,i__29423_29496);
var actual_type_29498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29438_29497,(0),null);
var __29499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29438_29497,(1),null);
var keys_29500 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29442,actual_type_29498,f_29492], null);
var canonical_f_29501 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29441),keys_29500);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29441,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29500], 0));

if(cljs.core.truth_(elem_29441.removeEventListener)){
elem_29441.removeEventListener(cljs.core.name(actual_type_29498),canonical_f_29501);
} else {
elem_29441.detachEvent(cljs.core.name(actual_type_29498),canonical_f_29501);
}

var G__29502 = seq__29419_29493;
var G__29503 = chunk__29421_29494;
var G__29504 = count__29422_29495;
var G__29505 = (i__29423_29496 + (1));
seq__29419_29493 = G__29502;
chunk__29421_29494 = G__29503;
count__29422_29495 = G__29504;
i__29423_29496 = G__29505;
continue;
} else {
var temp__4126__auto___29506__$1 = cljs.core.seq(seq__29419_29493);
if(temp__4126__auto___29506__$1){
var seq__29419_29507__$1 = temp__4126__auto___29506__$1;
if(cljs.core.chunked_seq_QMARK_(seq__29419_29507__$1)){
var c__5061__auto___29508 = cljs.core.chunk_first(seq__29419_29507__$1);
var G__29509 = cljs.core.chunk_rest(seq__29419_29507__$1);
var G__29510 = c__5061__auto___29508;
var G__29511 = cljs.core.count(c__5061__auto___29508);
var G__29512 = (0);
seq__29419_29493 = G__29509;
chunk__29421_29494 = G__29510;
count__29422_29495 = G__29511;
i__29423_29496 = G__29512;
continue;
} else {
var vec__29439_29513 = cljs.core.first(seq__29419_29507__$1);
var actual_type_29514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29439_29513,(0),null);
var __29515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29439_29513,(1),null);
var keys_29516 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29442,actual_type_29514,f_29492], null);
var canonical_f_29517 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29441),keys_29516);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29441,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29516], 0));

if(cljs.core.truth_(elem_29441.removeEventListener)){
elem_29441.removeEventListener(cljs.core.name(actual_type_29514),canonical_f_29517);
} else {
elem_29441.detachEvent(cljs.core.name(actual_type_29514),canonical_f_29517);
}

var G__29518 = cljs.core.next(seq__29419_29507__$1);
var G__29519 = null;
var G__29520 = (0);
var G__29521 = (0);
seq__29419_29493 = G__29518;
chunk__29421_29494 = G__29519;
count__29422_29495 = G__29520;
i__29423_29496 = G__29521;
continue;
}
} else {
}
}
break;
}

var G__29522 = cljs.core.next(seq__29418_29484__$1);
var G__29523 = null;
var G__29524 = (0);
var G__29525 = (0);
seq__29418_29443 = G__29522;
chunk__29425_29444 = G__29523;
count__29426_29445 = G__29524;
i__29427_29446 = G__29525;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq29415){
var G__29416 = cljs.core.first(seq29415);
var seq29415__$1 = cljs.core.next(seq29415);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29416,seq29415__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__29528_29539 = dommy.core.elem_and_selector(elem_sel);
var elem_29540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29528_29539,(0),null);
var selector_29541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29528_29539,(1),null);
var seq__29529_29542 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__29530_29543 = null;
var count__29531_29544 = (0);
var i__29532_29545 = (0);
while(true){
if((i__29532_29545 < count__29531_29544)){
var vec__29533_29546 = chunk__29530_29543.cljs$core$IIndexed$_nth$arity$2(null,i__29532_29545);
var type_29547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29533_29546,(0),null);
var f_29548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29533_29546,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29547,((function (seq__29529_29542,chunk__29530_29543,count__29531_29544,i__29532_29545,vec__29533_29546,type_29547,f_29548,vec__29528_29539,elem_29540,selector_29541){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29547,dommy$core$this_fn], 0));

var G__29535 = e;
return (f_29548.cljs$core$IFn$_invoke$arity$1 ? f_29548.cljs$core$IFn$_invoke$arity$1(G__29535) : f_29548.call(null,G__29535));
});})(seq__29529_29542,chunk__29530_29543,count__29531_29544,i__29532_29545,vec__29533_29546,type_29547,f_29548,vec__29528_29539,elem_29540,selector_29541))
], 0));

var G__29549 = seq__29529_29542;
var G__29550 = chunk__29530_29543;
var G__29551 = count__29531_29544;
var G__29552 = (i__29532_29545 + (1));
seq__29529_29542 = G__29549;
chunk__29530_29543 = G__29550;
count__29531_29544 = G__29551;
i__29532_29545 = G__29552;
continue;
} else {
var temp__4126__auto___29553 = cljs.core.seq(seq__29529_29542);
if(temp__4126__auto___29553){
var seq__29529_29554__$1 = temp__4126__auto___29553;
if(cljs.core.chunked_seq_QMARK_(seq__29529_29554__$1)){
var c__5061__auto___29555 = cljs.core.chunk_first(seq__29529_29554__$1);
var G__29556 = cljs.core.chunk_rest(seq__29529_29554__$1);
var G__29557 = c__5061__auto___29555;
var G__29558 = cljs.core.count(c__5061__auto___29555);
var G__29559 = (0);
seq__29529_29542 = G__29556;
chunk__29530_29543 = G__29557;
count__29531_29544 = G__29558;
i__29532_29545 = G__29559;
continue;
} else {
var vec__29536_29560 = cljs.core.first(seq__29529_29554__$1);
var type_29561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29536_29560,(0),null);
var f_29562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29536_29560,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29561,((function (seq__29529_29542,chunk__29530_29543,count__29531_29544,i__29532_29545,vec__29536_29560,type_29561,f_29562,seq__29529_29554__$1,temp__4126__auto___29553,vec__29528_29539,elem_29540,selector_29541){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29561,dommy$core$this_fn], 0));

var G__29538 = e;
return (f_29562.cljs$core$IFn$_invoke$arity$1 ? f_29562.cljs$core$IFn$_invoke$arity$1(G__29538) : f_29562.call(null,G__29538));
});})(seq__29529_29542,chunk__29530_29543,count__29531_29544,i__29532_29545,vec__29536_29560,type_29561,f_29562,seq__29529_29554__$1,temp__4126__auto___29553,vec__29528_29539,elem_29540,selector_29541))
], 0));

var G__29563 = cljs.core.next(seq__29529_29554__$1);
var G__29564 = null;
var G__29565 = (0);
var G__29566 = (0);
seq__29529_29542 = G__29563;
chunk__29530_29543 = G__29564;
count__29531_29544 = G__29565;
i__29532_29545 = G__29566;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq29526){
var G__29527 = cljs.core.first(seq29526);
var seq29526__$1 = cljs.core.next(seq29526);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29527,seq29526__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__29570){
var vec__29571 = p__29570;
var update_event_BANG_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29571,(0),null);
if(dommy.core.descendant_QMARK_(node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))], 0)))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name(event_type),true,true);

return node.dispatchEvent((function (){var G__29572 = event;
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__29572) : update_event_BANG___$1.call(null,G__29572));
})());
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name(event_type))].join(''),(function (){var G__29573 = document.createEventObject();
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__29573) : update_event_BANG___$1.call(null,G__29573));
})());
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq29567){
var G__29568 = cljs.core.first(seq29567);
var seq29567__$1 = cljs.core.next(seq29567);
var G__29569 = cljs.core.first(seq29567__$1);
var seq29567__$2 = cljs.core.next(seq29567__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29568,G__29569,seq29567__$2);
});
