// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__7925__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__7925__auto__)){
return stateful_method_QMARK_;
} else {
return and__7925__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__7925__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__7925__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__7925__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__28095 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28095) : cljs_hash.md5.md5.call(null,G__28095));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__8983__auto__ = [];
var len__8976__auto___28100 = arguments.length;
var i__8977__auto___28101 = (0);
while(true){
if((i__8977__auto___28101 < len__8976__auto___28100)){
args__8983__auto__.push((arguments[i__8977__auto___28101]));

var G__28102 = (i__8977__auto___28101 + (1));
i__8977__auto___28101 = G__28102;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((0) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__8984__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28097){
var map__28098 = p__28097;
var map__28098__$1 = ((((!((map__28098 == null)))?((((map__28098.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28098.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28098):map__28098);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28098__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28098__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28098__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_) : cljs.core.deref.call(null,milia.utils.remote._STAR_credentials_STAR_)));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__7925__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__7925__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__7925__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__7925__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__7925__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__7925__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__7937__auto__ = accept_header;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28096){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28096));
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__28109_28115 = io_obj;
var G__28110_28116 = goog.net.EventType.SUCCESS;
var G__28111_28117 = ((function (G__28109_28115,G__28110_28116,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28109_28115,G__28110_28116,io_obj,url))
;
goog.events.listen(G__28109_28115,G__28110_28116,G__28111_28117);

var G__28112_28118 = io_obj;
var G__28113_28119 = goog.net.EventType.ERROR;
var G__28114_28120 = ((function (G__28112_28118,G__28113_28119,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28112_28118,G__28113_28119,io_obj,url))
;
goog.events.listen(G__28112_28118,G__28113_28119,G__28114_28120);

return io_obj.sendFromForm(form,url);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__8983__auto__ = [];
var len__8976__auto___28183 = arguments.length;
var i__8977__auto___28184 = (0);
while(true){
if((i__8977__auto___28184 < len__8976__auto___28183)){
args__8983__auto__.push((arguments[i__8977__auto___28184]));

var G__28185 = (i__8977__auto___28184 + (1));
i__8977__auto___28184 = G__28185;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11626__auto___28186 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___28186,response_channel){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___28186,response_channel){
return (function (state_28156){
var state_val_28157 = (state_28156[(1)]);
if((state_val_28157 === (7))){
var state_28156__$1 = state_28156;
var statearr_28158_28187 = state_28156__$1;
(statearr_28158_28187[(2)] = false);

(statearr_28158_28187[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (1))){
var inst_28124 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28156__$1,(2),inst_28124);
} else {
if((state_val_28157 === (4))){
var state_28156__$1 = state_28156;
var statearr_28159_28188 = state_28156__$1;
(statearr_28159_28188[(2)] = false);

(statearr_28159_28188[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (13))){
var inst_28146 = (state_28156[(7)]);
var inst_28152 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28146);
var state_28156__$1 = state_28156;
var statearr_28160_28189 = state_28156__$1;
(statearr_28160_28189[(2)] = inst_28152);

(statearr_28160_28189[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (6))){
var state_28156__$1 = state_28156;
var statearr_28161_28190 = state_28156__$1;
(statearr_28161_28190[(2)] = true);

(statearr_28161_28190[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (3))){
var inst_28126 = (state_28156[(8)]);
var inst_28131 = inst_28126.cljs$lang$protocol_mask$partition0$;
var inst_28132 = (inst_28131 & (64));
var inst_28133 = inst_28126.cljs$core$ISeq$;
var inst_28134 = (inst_28132) || (inst_28133);
var state_28156__$1 = state_28156;
if(cljs.core.truth_(inst_28134)){
var statearr_28162_28191 = state_28156__$1;
(statearr_28162_28191[(1)] = (6));

} else {
var statearr_28163_28192 = state_28156__$1;
(statearr_28163_28192[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (12))){
var inst_28150 = window.location = window.location;
var state_28156__$1 = state_28156;
var statearr_28164_28193 = state_28156__$1;
(statearr_28164_28193[(2)] = inst_28150);

(statearr_28164_28193[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (2))){
var inst_28126 = (state_28156[(8)]);
var inst_28126__$1 = (state_28156[(2)]);
var inst_28128 = (inst_28126__$1 == null);
var inst_28129 = cljs.core.not(inst_28128);
var state_28156__$1 = (function (){var statearr_28165 = state_28156;
(statearr_28165[(8)] = inst_28126__$1);

return statearr_28165;
})();
if(inst_28129){
var statearr_28166_28194 = state_28156__$1;
(statearr_28166_28194[(1)] = (3));

} else {
var statearr_28167_28195 = state_28156__$1;
(statearr_28167_28195[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (11))){
var inst_28146 = (state_28156[(7)]);
var inst_28146__$1 = (state_28156[(2)]);
var inst_28147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28146__$1,cljs.core.constant$keyword$status);
var inst_28148 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28147,(401));
var state_28156__$1 = (function (){var statearr_28168 = state_28156;
(statearr_28168[(7)] = inst_28146__$1);

return statearr_28168;
})();
if(inst_28148){
var statearr_28169_28196 = state_28156__$1;
(statearr_28169_28196[(1)] = (12));

} else {
var statearr_28170_28197 = state_28156__$1;
(statearr_28170_28197[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (9))){
var inst_28126 = (state_28156[(8)]);
var inst_28143 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28126);
var state_28156__$1 = state_28156;
var statearr_28171_28198 = state_28156__$1;
(statearr_28171_28198[(2)] = inst_28143);

(statearr_28171_28198[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (5))){
var inst_28141 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
if(cljs.core.truth_(inst_28141)){
var statearr_28172_28199 = state_28156__$1;
(statearr_28172_28199[(1)] = (9));

} else {
var statearr_28173_28200 = state_28156__$1;
(statearr_28173_28200[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (14))){
var inst_28154 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28156__$1,inst_28154);
} else {
if((state_val_28157 === (10))){
var inst_28126 = (state_28156[(8)]);
var state_28156__$1 = state_28156;
var statearr_28174_28201 = state_28156__$1;
(statearr_28174_28201[(2)] = inst_28126);

(statearr_28174_28201[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28157 === (8))){
var inst_28138 = (state_28156[(2)]);
var state_28156__$1 = state_28156;
var statearr_28175_28202 = state_28156__$1;
(statearr_28175_28202[(2)] = inst_28138);

(statearr_28175_28202[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___28186,response_channel))
;
return ((function (switch__11561__auto__,c__11626__auto___28186,response_channel){
return (function() {
var milia$api$io$state_machine__11562__auto__ = null;
var milia$api$io$state_machine__11562__auto____0 = (function (){
var statearr_28179 = [null,null,null,null,null,null,null,null,null];
(statearr_28179[(0)] = milia$api$io$state_machine__11562__auto__);

(statearr_28179[(1)] = (1));

return statearr_28179;
});
var milia$api$io$state_machine__11562__auto____1 = (function (state_28156){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_28156);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e28180){if((e28180 instanceof Object)){
var ex__11565__auto__ = e28180;
var statearr_28181_28203 = state_28156;
(statearr_28181_28203[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28156);

return cljs.core.constant$keyword$recur;
} else {
throw e28180;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__28204 = state_28156;
state_28156 = G__28204;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
milia$api$io$state_machine__11562__auto__ = function(state_28156){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11562__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11562__auto____1.call(this,state_28156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11562__auto____0;
milia$api$io$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11562__auto____1;
return milia$api$io$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___28186,response_channel))
})();
var state__11628__auto__ = (function (){var statearr_28182 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_28182[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___28186);

return statearr_28182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___28186,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq28121){
var G__28122 = cljs.core.first(seq28121);
var seq28121__$1 = cljs.core.next(seq28121);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__28122,seq28121__$1);
});
