// Compiled by ClojureScript 0.0-3196 {}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(account,params){
var url = milia.api.io.make_url.call(null,"dataviews");
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),params,new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,account,options);
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.show = (function milia$api$dataview$show(account,dataview_id){
var url = milia.api.io.make_url.call(null,"dataviews",dataview_id);
var options = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,options);
});
/**
 * Retrieves dataview data using dataview id
 */
milia.api.dataview.data = (function milia$api$dataview$data(account,dataview_id){
var url = milia.api.io.make_url.call(null,"dataviews",dataview_id,"data.json");
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true,new cljs.core.Keyword(null,"raw-response?","raw-response?",557978228),true], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,options);
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(account,dataview_id){
var url = milia.api.io.make_url.call(null,"dataviews",dataview_id,"data");
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true,new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"count","count",2139924085),true], null)], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,options);
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(account){
var url = milia.api.io.make_url.call(null,"dataviews");
var options = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,options);
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(account,dataview_id,params){
var url = milia.api.io.make_url.call(null,"dataviews",dataview_id);
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),params,new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929),true], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"put","put",1299772570),url,account,options);
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(account,dataview_id){
var url = milia.api.io.make_url.call(null,"dataviews",dataview_id);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),url,account);
});
