// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29454 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29454 = (function (fn_handler,f,meta29455){
this.fn_handler = fn_handler;
this.f = f;
this.meta29455 = meta29455;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29454.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29456,meta29455__$1){
var self__ = this;
var _29456__$1 = this;
return (new cljs.core.async.t29454(self__.fn_handler,self__.f,meta29455__$1));
});

cljs.core.async.t29454.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29456){
var self__ = this;
var _29456__$1 = this;
return self__.meta29455;
});

cljs.core.async.t29454.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29454.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29454.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29454.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29455","meta29455",403849541,null)], null);
});

cljs.core.async.t29454.cljs$lang$type = true;

cljs.core.async.t29454.cljs$lang$ctorStr = "cljs.core.async/t29454";

cljs.core.async.t29454.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29454");
});

cljs.core.async.__GT_t29454 = (function cljs$core$async$fn_handler_$___GT_t29454(fn_handler__$1,f__$1,meta29455){
return (new cljs.core.async.t29454(fn_handler__$1,f__$1,meta29455));
});

}

return (new cljs.core.async.t29454(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29459 = [];
var len__8976__auto___29462 = arguments.length;
var i__8977__auto___29463 = (0);
while(true){
if((i__8977__auto___29463 < len__8976__auto___29462)){
args29459.push((arguments[i__8977__auto___29463]));

var G__29464 = (i__8977__auto___29463 + (1));
i__8977__auto___29463 = G__29464;
continue;
} else {
}
break;
}

var G__29461 = args29459.length;
switch (G__29461) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29459.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29466 = [];
var len__8976__auto___29469 = arguments.length;
var i__8977__auto___29470 = (0);
while(true){
if((i__8977__auto___29470 < len__8976__auto___29469)){
args29466.push((arguments[i__8977__auto___29470]));

var G__29471 = (i__8977__auto___29470 + (1));
i__8977__auto___29470 = G__29471;
continue;
} else {
}
break;
}

var G__29468 = args29466.length;
switch (G__29468) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29466.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_29473 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29473) : fn1.call(null,val_29473));
} else {
cljs.core.async.impl.dispatch.run(((function (val_29473,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29473) : fn1.call(null,val_29473));
});})(val_29473,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29474 = [];
var len__8976__auto___29477 = arguments.length;
var i__8977__auto___29478 = (0);
while(true){
if((i__8977__auto___29478 < len__8976__auto___29477)){
args29474.push((arguments[i__8977__auto___29478]));

var G__29479 = (i__8977__auto___29478 + (1));
i__8977__auto___29478 = G__29479;
continue;
} else {
}
break;
}

var G__29476 = args29474.length;
switch (G__29476) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29474.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8821__auto___29481 = n;
var x_29482 = (0);
while(true){
if((x_29482 < n__8821__auto___29481)){
(a[x_29482] = (0));

var G__29483 = (x_29482 + (1));
x_29482 = G__29483;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__29484 = (i + (1));
i = G__29484;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t29488 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29488 = (function (alt_flag,flag,meta29489){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29489 = meta29489;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29488.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29490,meta29489__$1){
var self__ = this;
var _29490__$1 = this;
return (new cljs.core.async.t29488(self__.alt_flag,self__.flag,meta29489__$1));
});})(flag))
;

cljs.core.async.t29488.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29490){
var self__ = this;
var _29490__$1 = this;
return self__.meta29489;
});})(flag))
;

cljs.core.async.t29488.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29488.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t29488.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t29488.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29489","meta29489",-715890661,null)], null);
});})(flag))
;

cljs.core.async.t29488.cljs$lang$type = true;

cljs.core.async.t29488.cljs$lang$ctorStr = "cljs.core.async/t29488";

cljs.core.async.t29488.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29488");
});})(flag))
;

cljs.core.async.__GT_t29488 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29488(alt_flag__$1,flag__$1,meta29489){
return (new cljs.core.async.t29488(alt_flag__$1,flag__$1,meta29489));
});})(flag))
;

}

return (new cljs.core.async.t29488(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29494 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29494 = (function (alt_handler,flag,cb,meta29495){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29495 = meta29495;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29494.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29496,meta29495__$1){
var self__ = this;
var _29496__$1 = this;
return (new cljs.core.async.t29494(self__.alt_handler,self__.flag,self__.cb,meta29495__$1));
});

cljs.core.async.t29494.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29496){
var self__ = this;
var _29496__$1 = this;
return self__.meta29495;
});

cljs.core.async.t29494.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29494.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t29494.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t29494.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29495","meta29495",-446926674,null)], null);
});

cljs.core.async.t29494.cljs$lang$type = true;

cljs.core.async.t29494.cljs$lang$ctorStr = "cljs.core.async/t29494";

cljs.core.async.t29494.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29494");
});

cljs.core.async.__GT_t29494 = (function cljs$core$async$alt_handler_$___GT_t29494(alt_handler__$1,flag__$1,cb__$1,meta29495){
return (new cljs.core.async.t29494(alt_handler__$1,flag__$1,cb__$1,meta29495));
});

}

return (new cljs.core.async.t29494(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29497_SHARP_){
var G__29501 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29497_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29501) : fret.call(null,G__29501));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29498_SHARP_){
var G__29502 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29498_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29502) : fret.call(null,G__29502));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7937__auto__ = wport;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29503 = (i + (1));
i = G__29503;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7937__auto__ = ret;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__7925__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7925__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7925__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___29509 = arguments.length;
var i__8977__auto___29510 = (0);
while(true){
if((i__8977__auto___29510 < len__8976__auto___29509)){
args__8983__auto__.push((arguments[i__8977__auto___29510]));

var G__29511 = (i__8977__auto___29510 + (1));
i__8977__auto___29510 = G__29511;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29506){
var map__29507 = p__29506;
var map__29507__$1 = ((((!((map__29507 == null)))?((((map__29507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29507):map__29507);
var opts = map__29507__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29504){
var G__29505 = cljs.core.first(seq29504);
var seq29504__$1 = cljs.core.next(seq29504);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29505,seq29504__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29512 = [];
var len__8976__auto___29562 = arguments.length;
var i__8977__auto___29563 = (0);
while(true){
if((i__8977__auto___29563 < len__8976__auto___29562)){
args29512.push((arguments[i__8977__auto___29563]));

var G__29564 = (i__8977__auto___29563 + (1));
i__8977__auto___29563 = G__29564;
continue;
} else {
}
break;
}

var G__29514 = args29512.length;
switch (G__29514) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29512.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11624__auto___29566 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___29566){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___29566){
return (function (state_29538){
var state_val_29539 = (state_29538[(1)]);
if((state_val_29539 === (7))){
var inst_29534 = (state_29538[(2)]);
var state_29538__$1 = state_29538;
var statearr_29540_29567 = state_29538__$1;
(statearr_29540_29567[(2)] = inst_29534);

(statearr_29540_29567[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (1))){
var state_29538__$1 = state_29538;
var statearr_29541_29568 = state_29538__$1;
(statearr_29541_29568[(2)] = null);

(statearr_29541_29568[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (4))){
var inst_29517 = (state_29538[(7)]);
var inst_29517__$1 = (state_29538[(2)]);
var inst_29518 = (inst_29517__$1 == null);
var state_29538__$1 = (function (){var statearr_29542 = state_29538;
(statearr_29542[(7)] = inst_29517__$1);

return statearr_29542;
})();
if(cljs.core.truth_(inst_29518)){
var statearr_29543_29569 = state_29538__$1;
(statearr_29543_29569[(1)] = (5));

} else {
var statearr_29544_29570 = state_29538__$1;
(statearr_29544_29570[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (13))){
var state_29538__$1 = state_29538;
var statearr_29545_29571 = state_29538__$1;
(statearr_29545_29571[(2)] = null);

(statearr_29545_29571[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (6))){
var inst_29517 = (state_29538[(7)]);
var state_29538__$1 = state_29538;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29538__$1,(11),to,inst_29517);
} else {
if((state_val_29539 === (3))){
var inst_29536 = (state_29538[(2)]);
var state_29538__$1 = state_29538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29538__$1,inst_29536);
} else {
if((state_val_29539 === (12))){
var state_29538__$1 = state_29538;
var statearr_29546_29572 = state_29538__$1;
(statearr_29546_29572[(2)] = null);

(statearr_29546_29572[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (2))){
var state_29538__$1 = state_29538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29538__$1,(4),from);
} else {
if((state_val_29539 === (11))){
var inst_29527 = (state_29538[(2)]);
var state_29538__$1 = state_29538;
if(cljs.core.truth_(inst_29527)){
var statearr_29547_29573 = state_29538__$1;
(statearr_29547_29573[(1)] = (12));

} else {
var statearr_29548_29574 = state_29538__$1;
(statearr_29548_29574[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (9))){
var state_29538__$1 = state_29538;
var statearr_29549_29575 = state_29538__$1;
(statearr_29549_29575[(2)] = null);

(statearr_29549_29575[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (5))){
var state_29538__$1 = state_29538;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29550_29576 = state_29538__$1;
(statearr_29550_29576[(1)] = (8));

} else {
var statearr_29551_29577 = state_29538__$1;
(statearr_29551_29577[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (14))){
var inst_29532 = (state_29538[(2)]);
var state_29538__$1 = state_29538;
var statearr_29552_29578 = state_29538__$1;
(statearr_29552_29578[(2)] = inst_29532);

(statearr_29552_29578[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (10))){
var inst_29524 = (state_29538[(2)]);
var state_29538__$1 = state_29538;
var statearr_29553_29579 = state_29538__$1;
(statearr_29553_29579[(2)] = inst_29524);

(statearr_29553_29579[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29539 === (8))){
var inst_29521 = cljs.core.async.close_BANG_(to);
var state_29538__$1 = state_29538;
var statearr_29554_29580 = state_29538__$1;
(statearr_29554_29580[(2)] = inst_29521);

(statearr_29554_29580[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___29566))
;
return ((function (switch__11559__auto__,c__11624__auto___29566){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_29558 = [null,null,null,null,null,null,null,null];
(statearr_29558[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_29558[(1)] = (1));

return statearr_29558;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_29538){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29538);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29559){if((e29559 instanceof Object)){
var ex__11563__auto__ = e29559;
var statearr_29560_29581 = state_29538;
(statearr_29560_29581[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29538);

return cljs.core.constant$keyword$recur;
} else {
throw e29559;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__29582 = state_29538;
state_29538 = G__29582;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_29538){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_29538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___29566))
})();
var state__11626__auto__ = (function (){var statearr_29561 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29561[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___29566);

return statearr_29561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___29566))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29766){
var vec__29767 = p__29766;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29767,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29767,(1),null);
var job = vec__29767;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11624__auto___29949 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results){
return (function (state_29772){
var state_val_29773 = (state_29772[(1)]);
if((state_val_29773 === (1))){
var state_29772__$1 = state_29772;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29772__$1,(2),res,v);
} else {
if((state_val_29773 === (2))){
var inst_29769 = (state_29772[(2)]);
var inst_29770 = cljs.core.async.close_BANG_(res);
var state_29772__$1 = (function (){var statearr_29774 = state_29772;
(statearr_29774[(7)] = inst_29769);

return statearr_29774;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29772__$1,inst_29770);
} else {
return null;
}
}
});})(c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results))
;
return ((function (switch__11559__auto__,c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_29778 = [null,null,null,null,null,null,null,null];
(statearr_29778[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__);

(statearr_29778[(1)] = (1));

return statearr_29778;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1 = (function (state_29772){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29772);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29779){if((e29779 instanceof Object)){
var ex__11563__auto__ = e29779;
var statearr_29780_29950 = state_29772;
(statearr_29780_29950[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29772);

return cljs.core.constant$keyword$recur;
} else {
throw e29779;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__29951 = state_29772;
state_29772 = G__29951;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = function(state_29772){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1.call(this,state_29772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results))
})();
var state__11626__auto__ = (function (){var statearr_29781 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29781[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___29949);

return statearr_29781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___29949,res,vec__29767,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29782){
var vec__29783 = p__29782;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29783,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29783,(1),null);
var job = vec__29783;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8821__auto___29952 = n;
var __29953 = (0);
while(true){
if((__29953 < n__8821__auto___29952)){
var G__29784_29954 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29784_29954) {
case "compute":
var c__11624__auto___29956 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29953,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (__29953,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function (state_29797){
var state_val_29798 = (state_29797[(1)]);
if((state_val_29798 === (1))){
var state_29797__$1 = state_29797;
var statearr_29799_29957 = state_29797__$1;
(statearr_29799_29957[(2)] = null);

(statearr_29799_29957[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29798 === (2))){
var state_29797__$1 = state_29797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29797__$1,(4),jobs);
} else {
if((state_val_29798 === (3))){
var inst_29795 = (state_29797[(2)]);
var state_29797__$1 = state_29797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29797__$1,inst_29795);
} else {
if((state_val_29798 === (4))){
var inst_29787 = (state_29797[(2)]);
var inst_29788 = process(inst_29787);
var state_29797__$1 = state_29797;
if(cljs.core.truth_(inst_29788)){
var statearr_29800_29958 = state_29797__$1;
(statearr_29800_29958[(1)] = (5));

} else {
var statearr_29801_29959 = state_29797__$1;
(statearr_29801_29959[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29798 === (5))){
var state_29797__$1 = state_29797;
var statearr_29802_29960 = state_29797__$1;
(statearr_29802_29960[(2)] = null);

(statearr_29802_29960[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29798 === (6))){
var state_29797__$1 = state_29797;
var statearr_29803_29961 = state_29797__$1;
(statearr_29803_29961[(2)] = null);

(statearr_29803_29961[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29798 === (7))){
var inst_29793 = (state_29797[(2)]);
var state_29797__$1 = state_29797;
var statearr_29804_29962 = state_29797__$1;
(statearr_29804_29962[(2)] = inst_29793);

(statearr_29804_29962[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29953,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
;
return ((function (__29953,switch__11559__auto__,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_29808 = [null,null,null,null,null,null,null];
(statearr_29808[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__);

(statearr_29808[(1)] = (1));

return statearr_29808;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1 = (function (state_29797){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29797);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29809){if((e29809 instanceof Object)){
var ex__11563__auto__ = e29809;
var statearr_29810_29963 = state_29797;
(statearr_29810_29963[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29797);

return cljs.core.constant$keyword$recur;
} else {
throw e29809;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__29964 = state_29797;
state_29797 = G__29964;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = function(state_29797){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1.call(this,state_29797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__;
})()
;})(__29953,switch__11559__auto__,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
})();
var state__11626__auto__ = (function (){var statearr_29811 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___29956);

return statearr_29811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(__29953,c__11624__auto___29956,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
);


break;
case "async":
var c__11624__auto___29965 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29953,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (__29953,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function (state_29824){
var state_val_29825 = (state_29824[(1)]);
if((state_val_29825 === (1))){
var state_29824__$1 = state_29824;
var statearr_29826_29966 = state_29824__$1;
(statearr_29826_29966[(2)] = null);

(statearr_29826_29966[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29825 === (2))){
var state_29824__$1 = state_29824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29824__$1,(4),jobs);
} else {
if((state_val_29825 === (3))){
var inst_29822 = (state_29824[(2)]);
var state_29824__$1 = state_29824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29824__$1,inst_29822);
} else {
if((state_val_29825 === (4))){
var inst_29814 = (state_29824[(2)]);
var inst_29815 = async(inst_29814);
var state_29824__$1 = state_29824;
if(cljs.core.truth_(inst_29815)){
var statearr_29827_29967 = state_29824__$1;
(statearr_29827_29967[(1)] = (5));

} else {
var statearr_29828_29968 = state_29824__$1;
(statearr_29828_29968[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29825 === (5))){
var state_29824__$1 = state_29824;
var statearr_29829_29969 = state_29824__$1;
(statearr_29829_29969[(2)] = null);

(statearr_29829_29969[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29825 === (6))){
var state_29824__$1 = state_29824;
var statearr_29830_29970 = state_29824__$1;
(statearr_29830_29970[(2)] = null);

(statearr_29830_29970[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29825 === (7))){
var inst_29820 = (state_29824[(2)]);
var state_29824__$1 = state_29824;
var statearr_29831_29971 = state_29824__$1;
(statearr_29831_29971[(2)] = inst_29820);

(statearr_29831_29971[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29953,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
;
return ((function (__29953,switch__11559__auto__,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_29835 = [null,null,null,null,null,null,null];
(statearr_29835[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__);

(statearr_29835[(1)] = (1));

return statearr_29835;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1 = (function (state_29824){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29824);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29836){if((e29836 instanceof Object)){
var ex__11563__auto__ = e29836;
var statearr_29837_29972 = state_29824;
(statearr_29837_29972[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29824);

return cljs.core.constant$keyword$recur;
} else {
throw e29836;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__29973 = state_29824;
state_29824 = G__29973;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = function(state_29824){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1.call(this,state_29824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__;
})()
;})(__29953,switch__11559__auto__,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
})();
var state__11626__auto__ = (function (){var statearr_29838 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___29965);

return statearr_29838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(__29953,c__11624__auto___29965,G__29784_29954,n__8821__auto___29952,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29974 = (__29953 + (1));
__29953 = G__29974;
continue;
} else {
}
break;
}

var c__11624__auto___29975 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___29975,jobs,results,process,async){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___29975,jobs,results,process,async){
return (function (state_29860){
var state_val_29861 = (state_29860[(1)]);
if((state_val_29861 === (1))){
var state_29860__$1 = state_29860;
var statearr_29862_29976 = state_29860__$1;
(statearr_29862_29976[(2)] = null);

(statearr_29862_29976[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29861 === (2))){
var state_29860__$1 = state_29860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29860__$1,(4),from);
} else {
if((state_val_29861 === (3))){
var inst_29858 = (state_29860[(2)]);
var state_29860__$1 = state_29860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29860__$1,inst_29858);
} else {
if((state_val_29861 === (4))){
var inst_29841 = (state_29860[(7)]);
var inst_29841__$1 = (state_29860[(2)]);
var inst_29842 = (inst_29841__$1 == null);
var state_29860__$1 = (function (){var statearr_29863 = state_29860;
(statearr_29863[(7)] = inst_29841__$1);

return statearr_29863;
})();
if(cljs.core.truth_(inst_29842)){
var statearr_29864_29977 = state_29860__$1;
(statearr_29864_29977[(1)] = (5));

} else {
var statearr_29865_29978 = state_29860__$1;
(statearr_29865_29978[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29861 === (5))){
var inst_29844 = cljs.core.async.close_BANG_(jobs);
var state_29860__$1 = state_29860;
var statearr_29866_29979 = state_29860__$1;
(statearr_29866_29979[(2)] = inst_29844);

(statearr_29866_29979[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29861 === (6))){
var inst_29841 = (state_29860[(7)]);
var inst_29846 = (state_29860[(8)]);
var inst_29846__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29848 = [inst_29841,inst_29846__$1];
var inst_29849 = (new cljs.core.PersistentVector(null,2,(5),inst_29847,inst_29848,null));
var state_29860__$1 = (function (){var statearr_29867 = state_29860;
(statearr_29867[(8)] = inst_29846__$1);

return statearr_29867;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29860__$1,(8),jobs,inst_29849);
} else {
if((state_val_29861 === (7))){
var inst_29856 = (state_29860[(2)]);
var state_29860__$1 = state_29860;
var statearr_29868_29980 = state_29860__$1;
(statearr_29868_29980[(2)] = inst_29856);

(statearr_29868_29980[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29861 === (8))){
var inst_29846 = (state_29860[(8)]);
var inst_29851 = (state_29860[(2)]);
var state_29860__$1 = (function (){var statearr_29869 = state_29860;
(statearr_29869[(9)] = inst_29851);

return statearr_29869;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29860__$1,(9),results,inst_29846);
} else {
if((state_val_29861 === (9))){
var inst_29853 = (state_29860[(2)]);
var state_29860__$1 = (function (){var statearr_29870 = state_29860;
(statearr_29870[(10)] = inst_29853);

return statearr_29870;
})();
var statearr_29871_29981 = state_29860__$1;
(statearr_29871_29981[(2)] = null);

(statearr_29871_29981[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___29975,jobs,results,process,async))
;
return ((function (switch__11559__auto__,c__11624__auto___29975,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_29875 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29875[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__);

(statearr_29875[(1)] = (1));

return statearr_29875;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1 = (function (state_29860){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29860);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29876){if((e29876 instanceof Object)){
var ex__11563__auto__ = e29876;
var statearr_29877_29982 = state_29860;
(statearr_29877_29982[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29860);

return cljs.core.constant$keyword$recur;
} else {
throw e29876;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__29983 = state_29860;
state_29860 = G__29983;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = function(state_29860){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1.call(this,state_29860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___29975,jobs,results,process,async))
})();
var state__11626__auto__ = (function (){var statearr_29878 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29878[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___29975);

return statearr_29878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___29975,jobs,results,process,async))
);


var c__11624__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto__,jobs,results,process,async){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto__,jobs,results,process,async){
return (function (state_29916){
var state_val_29917 = (state_29916[(1)]);
if((state_val_29917 === (7))){
var inst_29912 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29918_29984 = state_29916__$1;
(statearr_29918_29984[(2)] = inst_29912);

(statearr_29918_29984[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (20))){
var state_29916__$1 = state_29916;
var statearr_29919_29985 = state_29916__$1;
(statearr_29919_29985[(2)] = null);

(statearr_29919_29985[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (1))){
var state_29916__$1 = state_29916;
var statearr_29920_29986 = state_29916__$1;
(statearr_29920_29986[(2)] = null);

(statearr_29920_29986[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (4))){
var inst_29881 = (state_29916[(7)]);
var inst_29881__$1 = (state_29916[(2)]);
var inst_29882 = (inst_29881__$1 == null);
var state_29916__$1 = (function (){var statearr_29921 = state_29916;
(statearr_29921[(7)] = inst_29881__$1);

return statearr_29921;
})();
if(cljs.core.truth_(inst_29882)){
var statearr_29922_29987 = state_29916__$1;
(statearr_29922_29987[(1)] = (5));

} else {
var statearr_29923_29988 = state_29916__$1;
(statearr_29923_29988[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (15))){
var inst_29894 = (state_29916[(8)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29916__$1,(18),to,inst_29894);
} else {
if((state_val_29917 === (21))){
var inst_29907 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29924_29989 = state_29916__$1;
(statearr_29924_29989[(2)] = inst_29907);

(statearr_29924_29989[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (13))){
var inst_29909 = (state_29916[(2)]);
var state_29916__$1 = (function (){var statearr_29925 = state_29916;
(statearr_29925[(9)] = inst_29909);

return statearr_29925;
})();
var statearr_29926_29990 = state_29916__$1;
(statearr_29926_29990[(2)] = null);

(statearr_29926_29990[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (6))){
var inst_29881 = (state_29916[(7)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29916__$1,(11),inst_29881);
} else {
if((state_val_29917 === (17))){
var inst_29902 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
if(cljs.core.truth_(inst_29902)){
var statearr_29927_29991 = state_29916__$1;
(statearr_29927_29991[(1)] = (19));

} else {
var statearr_29928_29992 = state_29916__$1;
(statearr_29928_29992[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (3))){
var inst_29914 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29916__$1,inst_29914);
} else {
if((state_val_29917 === (12))){
var inst_29891 = (state_29916[(10)]);
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29916__$1,(14),inst_29891);
} else {
if((state_val_29917 === (2))){
var state_29916__$1 = state_29916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29916__$1,(4),results);
} else {
if((state_val_29917 === (19))){
var state_29916__$1 = state_29916;
var statearr_29929_29993 = state_29916__$1;
(statearr_29929_29993[(2)] = null);

(statearr_29929_29993[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (11))){
var inst_29891 = (state_29916[(2)]);
var state_29916__$1 = (function (){var statearr_29930 = state_29916;
(statearr_29930[(10)] = inst_29891);

return statearr_29930;
})();
var statearr_29931_29994 = state_29916__$1;
(statearr_29931_29994[(2)] = null);

(statearr_29931_29994[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (9))){
var state_29916__$1 = state_29916;
var statearr_29932_29995 = state_29916__$1;
(statearr_29932_29995[(2)] = null);

(statearr_29932_29995[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (5))){
var state_29916__$1 = state_29916;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29933_29996 = state_29916__$1;
(statearr_29933_29996[(1)] = (8));

} else {
var statearr_29934_29997 = state_29916__$1;
(statearr_29934_29997[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (14))){
var inst_29896 = (state_29916[(11)]);
var inst_29894 = (state_29916[(8)]);
var inst_29894__$1 = (state_29916[(2)]);
var inst_29895 = (inst_29894__$1 == null);
var inst_29896__$1 = cljs.core.not(inst_29895);
var state_29916__$1 = (function (){var statearr_29935 = state_29916;
(statearr_29935[(11)] = inst_29896__$1);

(statearr_29935[(8)] = inst_29894__$1);

return statearr_29935;
})();
if(inst_29896__$1){
var statearr_29936_29998 = state_29916__$1;
(statearr_29936_29998[(1)] = (15));

} else {
var statearr_29937_29999 = state_29916__$1;
(statearr_29937_29999[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (16))){
var inst_29896 = (state_29916[(11)]);
var state_29916__$1 = state_29916;
var statearr_29938_30000 = state_29916__$1;
(statearr_29938_30000[(2)] = inst_29896);

(statearr_29938_30000[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (10))){
var inst_29888 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29939_30001 = state_29916__$1;
(statearr_29939_30001[(2)] = inst_29888);

(statearr_29939_30001[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (18))){
var inst_29899 = (state_29916[(2)]);
var state_29916__$1 = state_29916;
var statearr_29940_30002 = state_29916__$1;
(statearr_29940_30002[(2)] = inst_29899);

(statearr_29940_30002[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29917 === (8))){
var inst_29885 = cljs.core.async.close_BANG_(to);
var state_29916__$1 = state_29916;
var statearr_29941_30003 = state_29916__$1;
(statearr_29941_30003[(2)] = inst_29885);

(statearr_29941_30003[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto__,jobs,results,process,async))
;
return ((function (switch__11559__auto__,c__11624__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_29945 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29945[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__);

(statearr_29945[(1)] = (1));

return statearr_29945;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1 = (function (state_29916){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_29916);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e29946){if((e29946 instanceof Object)){
var ex__11563__auto__ = e29946;
var statearr_29947_30004 = state_29916;
(statearr_29947_30004[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29916);

return cljs.core.constant$keyword$recur;
} else {
throw e29946;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__30005 = state_29916;
state_29916 = G__30005;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__ = function(state_29916){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1.call(this,state_29916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto__,jobs,results,process,async))
})();
var state__11626__auto__ = (function (){var statearr_29948 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_29948[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto__);

return statearr_29948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto__,jobs,results,process,async))
);

return c__11624__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args30006 = [];
var len__8976__auto___30009 = arguments.length;
var i__8977__auto___30010 = (0);
while(true){
if((i__8977__auto___30010 < len__8976__auto___30009)){
args30006.push((arguments[i__8977__auto___30010]));

var G__30011 = (i__8977__auto___30010 + (1));
i__8977__auto___30010 = G__30011;
continue;
} else {
}
break;
}

var G__30008 = args30006.length;
switch (G__30008) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30006.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args30013 = [];
var len__8976__auto___30016 = arguments.length;
var i__8977__auto___30017 = (0);
while(true){
if((i__8977__auto___30017 < len__8976__auto___30016)){
args30013.push((arguments[i__8977__auto___30017]));

var G__30018 = (i__8977__auto___30017 + (1));
i__8977__auto___30017 = G__30018;
continue;
} else {
}
break;
}

var G__30015 = args30013.length;
switch (G__30015) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30013.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args30020 = [];
var len__8976__auto___30073 = arguments.length;
var i__8977__auto___30074 = (0);
while(true){
if((i__8977__auto___30074 < len__8976__auto___30073)){
args30020.push((arguments[i__8977__auto___30074]));

var G__30075 = (i__8977__auto___30074 + (1));
i__8977__auto___30074 = G__30075;
continue;
} else {
}
break;
}

var G__30022 = args30020.length;
switch (G__30022) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30020.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11624__auto___30077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___30077,tc,fc){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___30077,tc,fc){
return (function (state_30048){
var state_val_30049 = (state_30048[(1)]);
if((state_val_30049 === (7))){
var inst_30044 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
var statearr_30050_30078 = state_30048__$1;
(statearr_30050_30078[(2)] = inst_30044);

(statearr_30050_30078[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (1))){
var state_30048__$1 = state_30048;
var statearr_30051_30079 = state_30048__$1;
(statearr_30051_30079[(2)] = null);

(statearr_30051_30079[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (4))){
var inst_30025 = (state_30048[(7)]);
var inst_30025__$1 = (state_30048[(2)]);
var inst_30026 = (inst_30025__$1 == null);
var state_30048__$1 = (function (){var statearr_30052 = state_30048;
(statearr_30052[(7)] = inst_30025__$1);

return statearr_30052;
})();
if(cljs.core.truth_(inst_30026)){
var statearr_30053_30080 = state_30048__$1;
(statearr_30053_30080[(1)] = (5));

} else {
var statearr_30054_30081 = state_30048__$1;
(statearr_30054_30081[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (13))){
var state_30048__$1 = state_30048;
var statearr_30055_30082 = state_30048__$1;
(statearr_30055_30082[(2)] = null);

(statearr_30055_30082[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (6))){
var inst_30025 = (state_30048[(7)]);
var inst_30031 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30025) : p.call(null,inst_30025));
var state_30048__$1 = state_30048;
if(cljs.core.truth_(inst_30031)){
var statearr_30056_30083 = state_30048__$1;
(statearr_30056_30083[(1)] = (9));

} else {
var statearr_30057_30084 = state_30048__$1;
(statearr_30057_30084[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (3))){
var inst_30046 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30048__$1,inst_30046);
} else {
if((state_val_30049 === (12))){
var state_30048__$1 = state_30048;
var statearr_30058_30085 = state_30048__$1;
(statearr_30058_30085[(2)] = null);

(statearr_30058_30085[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (2))){
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30048__$1,(4),ch);
} else {
if((state_val_30049 === (11))){
var inst_30025 = (state_30048[(7)]);
var inst_30035 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30048__$1,(8),inst_30035,inst_30025);
} else {
if((state_val_30049 === (9))){
var state_30048__$1 = state_30048;
var statearr_30059_30086 = state_30048__$1;
(statearr_30059_30086[(2)] = tc);

(statearr_30059_30086[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (5))){
var inst_30028 = cljs.core.async.close_BANG_(tc);
var inst_30029 = cljs.core.async.close_BANG_(fc);
var state_30048__$1 = (function (){var statearr_30060 = state_30048;
(statearr_30060[(8)] = inst_30028);

return statearr_30060;
})();
var statearr_30061_30087 = state_30048__$1;
(statearr_30061_30087[(2)] = inst_30029);

(statearr_30061_30087[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (14))){
var inst_30042 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
var statearr_30062_30088 = state_30048__$1;
(statearr_30062_30088[(2)] = inst_30042);

(statearr_30062_30088[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (10))){
var state_30048__$1 = state_30048;
var statearr_30063_30089 = state_30048__$1;
(statearr_30063_30089[(2)] = fc);

(statearr_30063_30089[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30049 === (8))){
var inst_30037 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
if(cljs.core.truth_(inst_30037)){
var statearr_30064_30090 = state_30048__$1;
(statearr_30064_30090[(1)] = (12));

} else {
var statearr_30065_30091 = state_30048__$1;
(statearr_30065_30091[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___30077,tc,fc))
;
return ((function (switch__11559__auto__,c__11624__auto___30077,tc,fc){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_30069 = [null,null,null,null,null,null,null,null,null];
(statearr_30069[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_30069[(1)] = (1));

return statearr_30069;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_30048){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_30048);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e30070){if((e30070 instanceof Object)){
var ex__11563__auto__ = e30070;
var statearr_30071_30092 = state_30048;
(statearr_30071_30092[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30048);

return cljs.core.constant$keyword$recur;
} else {
throw e30070;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__30093 = state_30048;
state_30048 = G__30093;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_30048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_30048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___30077,tc,fc))
})();
var state__11626__auto__ = (function (){var statearr_30072 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_30072[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___30077);

return statearr_30072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___30077,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11624__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto__){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto__){
return (function (state_30140){
var state_val_30141 = (state_30140[(1)]);
if((state_val_30141 === (1))){
var inst_30126 = init;
var state_30140__$1 = (function (){var statearr_30142 = state_30140;
(statearr_30142[(7)] = inst_30126);

return statearr_30142;
})();
var statearr_30143_30158 = state_30140__$1;
(statearr_30143_30158[(2)] = null);

(statearr_30143_30158[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30141 === (2))){
var state_30140__$1 = state_30140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30140__$1,(4),ch);
} else {
if((state_val_30141 === (3))){
var inst_30138 = (state_30140[(2)]);
var state_30140__$1 = state_30140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30140__$1,inst_30138);
} else {
if((state_val_30141 === (4))){
var inst_30129 = (state_30140[(8)]);
var inst_30129__$1 = (state_30140[(2)]);
var inst_30130 = (inst_30129__$1 == null);
var state_30140__$1 = (function (){var statearr_30144 = state_30140;
(statearr_30144[(8)] = inst_30129__$1);

return statearr_30144;
})();
if(cljs.core.truth_(inst_30130)){
var statearr_30145_30159 = state_30140__$1;
(statearr_30145_30159[(1)] = (5));

} else {
var statearr_30146_30160 = state_30140__$1;
(statearr_30146_30160[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30141 === (5))){
var inst_30126 = (state_30140[(7)]);
var state_30140__$1 = state_30140;
var statearr_30147_30161 = state_30140__$1;
(statearr_30147_30161[(2)] = inst_30126);

(statearr_30147_30161[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30141 === (6))){
var inst_30129 = (state_30140[(8)]);
var inst_30126 = (state_30140[(7)]);
var inst_30133 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30126,inst_30129) : f.call(null,inst_30126,inst_30129));
var inst_30126__$1 = inst_30133;
var state_30140__$1 = (function (){var statearr_30148 = state_30140;
(statearr_30148[(7)] = inst_30126__$1);

return statearr_30148;
})();
var statearr_30149_30162 = state_30140__$1;
(statearr_30149_30162[(2)] = null);

(statearr_30149_30162[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30141 === (7))){
var inst_30136 = (state_30140[(2)]);
var state_30140__$1 = state_30140;
var statearr_30150_30163 = state_30140__$1;
(statearr_30150_30163[(2)] = inst_30136);

(statearr_30150_30163[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11624__auto__))
;
return ((function (switch__11559__auto__,c__11624__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11560__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11560__auto____0 = (function (){
var statearr_30154 = [null,null,null,null,null,null,null,null,null];
(statearr_30154[(0)] = cljs$core$async$reduce_$_state_machine__11560__auto__);

(statearr_30154[(1)] = (1));

return statearr_30154;
});
var cljs$core$async$reduce_$_state_machine__11560__auto____1 = (function (state_30140){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_30140);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e30155){if((e30155 instanceof Object)){
var ex__11563__auto__ = e30155;
var statearr_30156_30164 = state_30140;
(statearr_30156_30164[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30140);

return cljs.core.constant$keyword$recur;
} else {
throw e30155;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__30165 = state_30140;
state_30140 = G__30165;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11560__auto__ = function(state_30140){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11560__auto____1.call(this,state_30140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11560__auto____0;
cljs$core$async$reduce_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11560__auto____1;
return cljs$core$async$reduce_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto__))
})();
var state__11626__auto__ = (function (){var statearr_30157 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_30157[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto__);

return statearr_30157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto__))
);

return c__11624__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args30166 = [];
var len__8976__auto___30218 = arguments.length;
var i__8977__auto___30219 = (0);
while(true){
if((i__8977__auto___30219 < len__8976__auto___30218)){
args30166.push((arguments[i__8977__auto___30219]));

var G__30220 = (i__8977__auto___30219 + (1));
i__8977__auto___30219 = G__30220;
continue;
} else {
}
break;
}

var G__30168 = args30166.length;
switch (G__30168) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30166.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11624__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto__){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto__){
return (function (state_30193){
var state_val_30194 = (state_30193[(1)]);
if((state_val_30194 === (7))){
var inst_30175 = (state_30193[(2)]);
var state_30193__$1 = state_30193;
var statearr_30195_30222 = state_30193__$1;
(statearr_30195_30222[(2)] = inst_30175);

(statearr_30195_30222[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (1))){
var inst_30169 = cljs.core.seq(coll);
var inst_30170 = inst_30169;
var state_30193__$1 = (function (){var statearr_30196 = state_30193;
(statearr_30196[(7)] = inst_30170);

return statearr_30196;
})();
var statearr_30197_30223 = state_30193__$1;
(statearr_30197_30223[(2)] = null);

(statearr_30197_30223[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (4))){
var inst_30170 = (state_30193[(7)]);
var inst_30173 = cljs.core.first(inst_30170);
var state_30193__$1 = state_30193;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30193__$1,(7),ch,inst_30173);
} else {
if((state_val_30194 === (13))){
var inst_30187 = (state_30193[(2)]);
var state_30193__$1 = state_30193;
var statearr_30198_30224 = state_30193__$1;
(statearr_30198_30224[(2)] = inst_30187);

(statearr_30198_30224[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (6))){
var inst_30178 = (state_30193[(2)]);
var state_30193__$1 = state_30193;
if(cljs.core.truth_(inst_30178)){
var statearr_30199_30225 = state_30193__$1;
(statearr_30199_30225[(1)] = (8));

} else {
var statearr_30200_30226 = state_30193__$1;
(statearr_30200_30226[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (3))){
var inst_30191 = (state_30193[(2)]);
var state_30193__$1 = state_30193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30193__$1,inst_30191);
} else {
if((state_val_30194 === (12))){
var state_30193__$1 = state_30193;
var statearr_30201_30227 = state_30193__$1;
(statearr_30201_30227[(2)] = null);

(statearr_30201_30227[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (2))){
var inst_30170 = (state_30193[(7)]);
var state_30193__$1 = state_30193;
if(cljs.core.truth_(inst_30170)){
var statearr_30202_30228 = state_30193__$1;
(statearr_30202_30228[(1)] = (4));

} else {
var statearr_30203_30229 = state_30193__$1;
(statearr_30203_30229[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (11))){
var inst_30184 = cljs.core.async.close_BANG_(ch);
var state_30193__$1 = state_30193;
var statearr_30204_30230 = state_30193__$1;
(statearr_30204_30230[(2)] = inst_30184);

(statearr_30204_30230[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (9))){
var state_30193__$1 = state_30193;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30205_30231 = state_30193__$1;
(statearr_30205_30231[(1)] = (11));

} else {
var statearr_30206_30232 = state_30193__$1;
(statearr_30206_30232[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (5))){
var inst_30170 = (state_30193[(7)]);
var state_30193__$1 = state_30193;
var statearr_30207_30233 = state_30193__$1;
(statearr_30207_30233[(2)] = inst_30170);

(statearr_30207_30233[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (10))){
var inst_30189 = (state_30193[(2)]);
var state_30193__$1 = state_30193;
var statearr_30208_30234 = state_30193__$1;
(statearr_30208_30234[(2)] = inst_30189);

(statearr_30208_30234[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30194 === (8))){
var inst_30170 = (state_30193[(7)]);
var inst_30180 = cljs.core.next(inst_30170);
var inst_30170__$1 = inst_30180;
var state_30193__$1 = (function (){var statearr_30209 = state_30193;
(statearr_30209[(7)] = inst_30170__$1);

return statearr_30209;
})();
var statearr_30210_30235 = state_30193__$1;
(statearr_30210_30235[(2)] = null);

(statearr_30210_30235[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto__))
;
return ((function (switch__11559__auto__,c__11624__auto__){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_30214 = [null,null,null,null,null,null,null,null];
(statearr_30214[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_30214[(1)] = (1));

return statearr_30214;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_30193){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_30193);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e30215){if((e30215 instanceof Object)){
var ex__11563__auto__ = e30215;
var statearr_30216_30236 = state_30193;
(statearr_30216_30236[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30193);

return cljs.core.constant$keyword$recur;
} else {
throw e30215;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__30237 = state_30193;
state_30193 = G__30237;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_30193){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_30193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto__))
})();
var state__11626__auto__ = (function (){var statearr_30217 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_30217[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto__);

return statearr_30217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto__))
);

return c__11624__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8573__auto__ = (((_ == null))?null:_);
var m__8574__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto__.call(null,_));
} else {
var m__8574__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__30466 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30466) : cljs.core.atom.call(null,G__30466));
})();
var m = (function (){
if(typeof cljs.core.async.t30467 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30467 = (function (mult,ch,cs,meta30468){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30468 = meta30468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30469,meta30468__$1){
var self__ = this;
var _30469__$1 = this;
return (new cljs.core.async.t30467(self__.mult,self__.ch,self__.cs,meta30468__$1));
});})(cs))
;

cljs.core.async.t30467.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30469){
var self__ = this;
var _30469__$1 = this;
return self__.meta30468;
});})(cs))
;

cljs.core.async.t30467.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30467.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30467.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30467.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30467.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30467.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30470_30690 = self__.cs;
var G__30471_30691 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30470_30690,G__30471_30691) : cljs.core.reset_BANG_.call(null,G__30470_30690,G__30471_30691));

return null;
});})(cs))
;

cljs.core.async.t30467.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30468","meta30468",795326081,null)], null);
});})(cs))
;

cljs.core.async.t30467.cljs$lang$type = true;

cljs.core.async.t30467.cljs$lang$ctorStr = "cljs.core.async/t30467";

cljs.core.async.t30467.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30467");
});})(cs))
;

cljs.core.async.__GT_t30467 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30467(mult__$1,ch__$1,cs__$1,meta30468){
return (new cljs.core.async.t30467(mult__$1,ch__$1,cs__$1,meta30468));
});})(cs))
;

}

return (new cljs.core.async.t30467(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11624__auto___30692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___30692,cs,m,dchan,dctr,done){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___30692,cs,m,dchan,dctr,done){
return (function (state_30602){
var state_val_30603 = (state_30602[(1)]);
if((state_val_30603 === (7))){
var inst_30598 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30604_30693 = state_30602__$1;
(statearr_30604_30693[(2)] = inst_30598);

(statearr_30604_30693[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (20))){
var inst_30503 = (state_30602[(7)]);
var inst_30513 = cljs.core.first(inst_30503);
var inst_30514 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30513,(0),null);
var inst_30515 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30513,(1),null);
var state_30602__$1 = (function (){var statearr_30605 = state_30602;
(statearr_30605[(8)] = inst_30514);

return statearr_30605;
})();
if(cljs.core.truth_(inst_30515)){
var statearr_30606_30694 = state_30602__$1;
(statearr_30606_30694[(1)] = (22));

} else {
var statearr_30607_30695 = state_30602__$1;
(statearr_30607_30695[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (27))){
var inst_30474 = (state_30602[(9)]);
var inst_30550 = (state_30602[(10)]);
var inst_30545 = (state_30602[(11)]);
var inst_30543 = (state_30602[(12)]);
var inst_30550__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30543,inst_30545);
var inst_30551 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30550__$1,inst_30474,done);
var state_30602__$1 = (function (){var statearr_30608 = state_30602;
(statearr_30608[(10)] = inst_30550__$1);

return statearr_30608;
})();
if(cljs.core.truth_(inst_30551)){
var statearr_30609_30696 = state_30602__$1;
(statearr_30609_30696[(1)] = (30));

} else {
var statearr_30610_30697 = state_30602__$1;
(statearr_30610_30697[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (1))){
var state_30602__$1 = state_30602;
var statearr_30611_30698 = state_30602__$1;
(statearr_30611_30698[(2)] = null);

(statearr_30611_30698[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (24))){
var inst_30503 = (state_30602[(7)]);
var inst_30520 = (state_30602[(2)]);
var inst_30521 = cljs.core.next(inst_30503);
var inst_30483 = inst_30521;
var inst_30484 = null;
var inst_30485 = (0);
var inst_30486 = (0);
var state_30602__$1 = (function (){var statearr_30612 = state_30602;
(statearr_30612[(13)] = inst_30485);

(statearr_30612[(14)] = inst_30483);

(statearr_30612[(15)] = inst_30484);

(statearr_30612[(16)] = inst_30520);

(statearr_30612[(17)] = inst_30486);

return statearr_30612;
})();
var statearr_30613_30699 = state_30602__$1;
(statearr_30613_30699[(2)] = null);

(statearr_30613_30699[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (39))){
var state_30602__$1 = state_30602;
var statearr_30617_30700 = state_30602__$1;
(statearr_30617_30700[(2)] = null);

(statearr_30617_30700[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (4))){
var inst_30474 = (state_30602[(9)]);
var inst_30474__$1 = (state_30602[(2)]);
var inst_30475 = (inst_30474__$1 == null);
var state_30602__$1 = (function (){var statearr_30618 = state_30602;
(statearr_30618[(9)] = inst_30474__$1);

return statearr_30618;
})();
if(cljs.core.truth_(inst_30475)){
var statearr_30619_30701 = state_30602__$1;
(statearr_30619_30701[(1)] = (5));

} else {
var statearr_30620_30702 = state_30602__$1;
(statearr_30620_30702[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (15))){
var inst_30485 = (state_30602[(13)]);
var inst_30483 = (state_30602[(14)]);
var inst_30484 = (state_30602[(15)]);
var inst_30486 = (state_30602[(17)]);
var inst_30499 = (state_30602[(2)]);
var inst_30500 = (inst_30486 + (1));
var tmp30614 = inst_30485;
var tmp30615 = inst_30483;
var tmp30616 = inst_30484;
var inst_30483__$1 = tmp30615;
var inst_30484__$1 = tmp30616;
var inst_30485__$1 = tmp30614;
var inst_30486__$1 = inst_30500;
var state_30602__$1 = (function (){var statearr_30621 = state_30602;
(statearr_30621[(13)] = inst_30485__$1);

(statearr_30621[(18)] = inst_30499);

(statearr_30621[(14)] = inst_30483__$1);

(statearr_30621[(15)] = inst_30484__$1);

(statearr_30621[(17)] = inst_30486__$1);

return statearr_30621;
})();
var statearr_30622_30703 = state_30602__$1;
(statearr_30622_30703[(2)] = null);

(statearr_30622_30703[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (21))){
var inst_30524 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30626_30704 = state_30602__$1;
(statearr_30626_30704[(2)] = inst_30524);

(statearr_30626_30704[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (31))){
var inst_30550 = (state_30602[(10)]);
var inst_30554 = done(null);
var inst_30555 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30550);
var state_30602__$1 = (function (){var statearr_30627 = state_30602;
(statearr_30627[(19)] = inst_30554);

return statearr_30627;
})();
var statearr_30628_30705 = state_30602__$1;
(statearr_30628_30705[(2)] = inst_30555);

(statearr_30628_30705[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (32))){
var inst_30544 = (state_30602[(20)]);
var inst_30542 = (state_30602[(21)]);
var inst_30545 = (state_30602[(11)]);
var inst_30543 = (state_30602[(12)]);
var inst_30557 = (state_30602[(2)]);
var inst_30558 = (inst_30545 + (1));
var tmp30623 = inst_30544;
var tmp30624 = inst_30542;
var tmp30625 = inst_30543;
var inst_30542__$1 = tmp30624;
var inst_30543__$1 = tmp30625;
var inst_30544__$1 = tmp30623;
var inst_30545__$1 = inst_30558;
var state_30602__$1 = (function (){var statearr_30629 = state_30602;
(statearr_30629[(20)] = inst_30544__$1);

(statearr_30629[(22)] = inst_30557);

(statearr_30629[(21)] = inst_30542__$1);

(statearr_30629[(11)] = inst_30545__$1);

(statearr_30629[(12)] = inst_30543__$1);

return statearr_30629;
})();
var statearr_30630_30706 = state_30602__$1;
(statearr_30630_30706[(2)] = null);

(statearr_30630_30706[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (40))){
var inst_30570 = (state_30602[(23)]);
var inst_30574 = done(null);
var inst_30575 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30570);
var state_30602__$1 = (function (){var statearr_30631 = state_30602;
(statearr_30631[(24)] = inst_30574);

return statearr_30631;
})();
var statearr_30632_30707 = state_30602__$1;
(statearr_30632_30707[(2)] = inst_30575);

(statearr_30632_30707[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (33))){
var inst_30561 = (state_30602[(25)]);
var inst_30563 = cljs.core.chunked_seq_QMARK_(inst_30561);
var state_30602__$1 = state_30602;
if(inst_30563){
var statearr_30633_30708 = state_30602__$1;
(statearr_30633_30708[(1)] = (36));

} else {
var statearr_30634_30709 = state_30602__$1;
(statearr_30634_30709[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (13))){
var inst_30493 = (state_30602[(26)]);
var inst_30496 = cljs.core.async.close_BANG_(inst_30493);
var state_30602__$1 = state_30602;
var statearr_30635_30710 = state_30602__$1;
(statearr_30635_30710[(2)] = inst_30496);

(statearr_30635_30710[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (22))){
var inst_30514 = (state_30602[(8)]);
var inst_30517 = cljs.core.async.close_BANG_(inst_30514);
var state_30602__$1 = state_30602;
var statearr_30636_30711 = state_30602__$1;
(statearr_30636_30711[(2)] = inst_30517);

(statearr_30636_30711[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (36))){
var inst_30561 = (state_30602[(25)]);
var inst_30565 = cljs.core.chunk_first(inst_30561);
var inst_30566 = cljs.core.chunk_rest(inst_30561);
var inst_30567 = cljs.core.count(inst_30565);
var inst_30542 = inst_30566;
var inst_30543 = inst_30565;
var inst_30544 = inst_30567;
var inst_30545 = (0);
var state_30602__$1 = (function (){var statearr_30637 = state_30602;
(statearr_30637[(20)] = inst_30544);

(statearr_30637[(21)] = inst_30542);

(statearr_30637[(11)] = inst_30545);

(statearr_30637[(12)] = inst_30543);

return statearr_30637;
})();
var statearr_30638_30712 = state_30602__$1;
(statearr_30638_30712[(2)] = null);

(statearr_30638_30712[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (41))){
var inst_30561 = (state_30602[(25)]);
var inst_30577 = (state_30602[(2)]);
var inst_30578 = cljs.core.next(inst_30561);
var inst_30542 = inst_30578;
var inst_30543 = null;
var inst_30544 = (0);
var inst_30545 = (0);
var state_30602__$1 = (function (){var statearr_30639 = state_30602;
(statearr_30639[(20)] = inst_30544);

(statearr_30639[(21)] = inst_30542);

(statearr_30639[(11)] = inst_30545);

(statearr_30639[(27)] = inst_30577);

(statearr_30639[(12)] = inst_30543);

return statearr_30639;
})();
var statearr_30640_30713 = state_30602__$1;
(statearr_30640_30713[(2)] = null);

(statearr_30640_30713[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (43))){
var state_30602__$1 = state_30602;
var statearr_30641_30714 = state_30602__$1;
(statearr_30641_30714[(2)] = null);

(statearr_30641_30714[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (29))){
var inst_30586 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30642_30715 = state_30602__$1;
(statearr_30642_30715[(2)] = inst_30586);

(statearr_30642_30715[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (44))){
var inst_30595 = (state_30602[(2)]);
var state_30602__$1 = (function (){var statearr_30643 = state_30602;
(statearr_30643[(28)] = inst_30595);

return statearr_30643;
})();
var statearr_30644_30716 = state_30602__$1;
(statearr_30644_30716[(2)] = null);

(statearr_30644_30716[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (6))){
var inst_30534 = (state_30602[(29)]);
var inst_30533 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30534__$1 = cljs.core.keys(inst_30533);
var inst_30535 = cljs.core.count(inst_30534__$1);
var inst_30536 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30535) : cljs.core.reset_BANG_.call(null,dctr,inst_30535));
var inst_30541 = cljs.core.seq(inst_30534__$1);
var inst_30542 = inst_30541;
var inst_30543 = null;
var inst_30544 = (0);
var inst_30545 = (0);
var state_30602__$1 = (function (){var statearr_30645 = state_30602;
(statearr_30645[(20)] = inst_30544);

(statearr_30645[(21)] = inst_30542);

(statearr_30645[(11)] = inst_30545);

(statearr_30645[(29)] = inst_30534__$1);

(statearr_30645[(30)] = inst_30536);

(statearr_30645[(12)] = inst_30543);

return statearr_30645;
})();
var statearr_30646_30717 = state_30602__$1;
(statearr_30646_30717[(2)] = null);

(statearr_30646_30717[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (28))){
var inst_30542 = (state_30602[(21)]);
var inst_30561 = (state_30602[(25)]);
var inst_30561__$1 = cljs.core.seq(inst_30542);
var state_30602__$1 = (function (){var statearr_30647 = state_30602;
(statearr_30647[(25)] = inst_30561__$1);

return statearr_30647;
})();
if(inst_30561__$1){
var statearr_30648_30718 = state_30602__$1;
(statearr_30648_30718[(1)] = (33));

} else {
var statearr_30649_30719 = state_30602__$1;
(statearr_30649_30719[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (25))){
var inst_30544 = (state_30602[(20)]);
var inst_30545 = (state_30602[(11)]);
var inst_30547 = (inst_30545 < inst_30544);
var inst_30548 = inst_30547;
var state_30602__$1 = state_30602;
if(cljs.core.truth_(inst_30548)){
var statearr_30650_30720 = state_30602__$1;
(statearr_30650_30720[(1)] = (27));

} else {
var statearr_30651_30721 = state_30602__$1;
(statearr_30651_30721[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (34))){
var state_30602__$1 = state_30602;
var statearr_30652_30722 = state_30602__$1;
(statearr_30652_30722[(2)] = null);

(statearr_30652_30722[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (17))){
var state_30602__$1 = state_30602;
var statearr_30653_30723 = state_30602__$1;
(statearr_30653_30723[(2)] = null);

(statearr_30653_30723[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (3))){
var inst_30600 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30602__$1,inst_30600);
} else {
if((state_val_30603 === (12))){
var inst_30529 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30654_30724 = state_30602__$1;
(statearr_30654_30724[(2)] = inst_30529);

(statearr_30654_30724[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (2))){
var state_30602__$1 = state_30602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30602__$1,(4),ch);
} else {
if((state_val_30603 === (23))){
var state_30602__$1 = state_30602;
var statearr_30655_30725 = state_30602__$1;
(statearr_30655_30725[(2)] = null);

(statearr_30655_30725[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (35))){
var inst_30584 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30656_30726 = state_30602__$1;
(statearr_30656_30726[(2)] = inst_30584);

(statearr_30656_30726[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (19))){
var inst_30503 = (state_30602[(7)]);
var inst_30507 = cljs.core.chunk_first(inst_30503);
var inst_30508 = cljs.core.chunk_rest(inst_30503);
var inst_30509 = cljs.core.count(inst_30507);
var inst_30483 = inst_30508;
var inst_30484 = inst_30507;
var inst_30485 = inst_30509;
var inst_30486 = (0);
var state_30602__$1 = (function (){var statearr_30657 = state_30602;
(statearr_30657[(13)] = inst_30485);

(statearr_30657[(14)] = inst_30483);

(statearr_30657[(15)] = inst_30484);

(statearr_30657[(17)] = inst_30486);

return statearr_30657;
})();
var statearr_30658_30727 = state_30602__$1;
(statearr_30658_30727[(2)] = null);

(statearr_30658_30727[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (11))){
var inst_30503 = (state_30602[(7)]);
var inst_30483 = (state_30602[(14)]);
var inst_30503__$1 = cljs.core.seq(inst_30483);
var state_30602__$1 = (function (){var statearr_30659 = state_30602;
(statearr_30659[(7)] = inst_30503__$1);

return statearr_30659;
})();
if(inst_30503__$1){
var statearr_30660_30728 = state_30602__$1;
(statearr_30660_30728[(1)] = (16));

} else {
var statearr_30661_30729 = state_30602__$1;
(statearr_30661_30729[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (9))){
var inst_30531 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30662_30730 = state_30602__$1;
(statearr_30662_30730[(2)] = inst_30531);

(statearr_30662_30730[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (5))){
var inst_30481 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30482 = cljs.core.seq(inst_30481);
var inst_30483 = inst_30482;
var inst_30484 = null;
var inst_30485 = (0);
var inst_30486 = (0);
var state_30602__$1 = (function (){var statearr_30663 = state_30602;
(statearr_30663[(13)] = inst_30485);

(statearr_30663[(14)] = inst_30483);

(statearr_30663[(15)] = inst_30484);

(statearr_30663[(17)] = inst_30486);

return statearr_30663;
})();
var statearr_30664_30731 = state_30602__$1;
(statearr_30664_30731[(2)] = null);

(statearr_30664_30731[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (14))){
var state_30602__$1 = state_30602;
var statearr_30665_30732 = state_30602__$1;
(statearr_30665_30732[(2)] = null);

(statearr_30665_30732[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (45))){
var inst_30592 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30666_30733 = state_30602__$1;
(statearr_30666_30733[(2)] = inst_30592);

(statearr_30666_30733[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (26))){
var inst_30534 = (state_30602[(29)]);
var inst_30588 = (state_30602[(2)]);
var inst_30589 = cljs.core.seq(inst_30534);
var state_30602__$1 = (function (){var statearr_30667 = state_30602;
(statearr_30667[(31)] = inst_30588);

return statearr_30667;
})();
if(inst_30589){
var statearr_30668_30734 = state_30602__$1;
(statearr_30668_30734[(1)] = (42));

} else {
var statearr_30669_30735 = state_30602__$1;
(statearr_30669_30735[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (16))){
var inst_30503 = (state_30602[(7)]);
var inst_30505 = cljs.core.chunked_seq_QMARK_(inst_30503);
var state_30602__$1 = state_30602;
if(inst_30505){
var statearr_30670_30736 = state_30602__$1;
(statearr_30670_30736[(1)] = (19));

} else {
var statearr_30671_30737 = state_30602__$1;
(statearr_30671_30737[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (38))){
var inst_30581 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30672_30738 = state_30602__$1;
(statearr_30672_30738[(2)] = inst_30581);

(statearr_30672_30738[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (30))){
var state_30602__$1 = state_30602;
var statearr_30673_30739 = state_30602__$1;
(statearr_30673_30739[(2)] = null);

(statearr_30673_30739[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (10))){
var inst_30484 = (state_30602[(15)]);
var inst_30486 = (state_30602[(17)]);
var inst_30492 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30484,inst_30486);
var inst_30493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30492,(0),null);
var inst_30494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30492,(1),null);
var state_30602__$1 = (function (){var statearr_30674 = state_30602;
(statearr_30674[(26)] = inst_30493);

return statearr_30674;
})();
if(cljs.core.truth_(inst_30494)){
var statearr_30675_30740 = state_30602__$1;
(statearr_30675_30740[(1)] = (13));

} else {
var statearr_30676_30741 = state_30602__$1;
(statearr_30676_30741[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (18))){
var inst_30527 = (state_30602[(2)]);
var state_30602__$1 = state_30602;
var statearr_30677_30742 = state_30602__$1;
(statearr_30677_30742[(2)] = inst_30527);

(statearr_30677_30742[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (42))){
var state_30602__$1 = state_30602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30602__$1,(45),dchan);
} else {
if((state_val_30603 === (37))){
var inst_30474 = (state_30602[(9)]);
var inst_30570 = (state_30602[(23)]);
var inst_30561 = (state_30602[(25)]);
var inst_30570__$1 = cljs.core.first(inst_30561);
var inst_30571 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30570__$1,inst_30474,done);
var state_30602__$1 = (function (){var statearr_30678 = state_30602;
(statearr_30678[(23)] = inst_30570__$1);

return statearr_30678;
})();
if(cljs.core.truth_(inst_30571)){
var statearr_30679_30743 = state_30602__$1;
(statearr_30679_30743[(1)] = (39));

} else {
var statearr_30680_30744 = state_30602__$1;
(statearr_30680_30744[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30603 === (8))){
var inst_30485 = (state_30602[(13)]);
var inst_30486 = (state_30602[(17)]);
var inst_30488 = (inst_30486 < inst_30485);
var inst_30489 = inst_30488;
var state_30602__$1 = state_30602;
if(cljs.core.truth_(inst_30489)){
var statearr_30681_30745 = state_30602__$1;
(statearr_30681_30745[(1)] = (10));

} else {
var statearr_30682_30746 = state_30602__$1;
(statearr_30682_30746[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___30692,cs,m,dchan,dctr,done))
;
return ((function (switch__11559__auto__,c__11624__auto___30692,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11560__auto__ = null;
var cljs$core$async$mult_$_state_machine__11560__auto____0 = (function (){
var statearr_30686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30686[(0)] = cljs$core$async$mult_$_state_machine__11560__auto__);

(statearr_30686[(1)] = (1));

return statearr_30686;
});
var cljs$core$async$mult_$_state_machine__11560__auto____1 = (function (state_30602){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_30602);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e30687){if((e30687 instanceof Object)){
var ex__11563__auto__ = e30687;
var statearr_30688_30747 = state_30602;
(statearr_30688_30747[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30602);

return cljs.core.constant$keyword$recur;
} else {
throw e30687;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__30748 = state_30602;
state_30602 = G__30748;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11560__auto__ = function(state_30602){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11560__auto____1.call(this,state_30602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11560__auto____0;
cljs$core$async$mult_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11560__auto____1;
return cljs$core$async$mult_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___30692,cs,m,dchan,dctr,done))
})();
var state__11626__auto__ = (function (){var statearr_30689 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_30689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___30692);

return statearr_30689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___30692,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30749 = [];
var len__8976__auto___30752 = arguments.length;
var i__8977__auto___30753 = (0);
while(true){
if((i__8977__auto___30753 < len__8976__auto___30752)){
args30749.push((arguments[i__8977__auto___30753]));

var G__30754 = (i__8977__auto___30753 + (1));
i__8977__auto___30753 = G__30754;
continue;
} else {
}
break;
}

var G__30751 = args30749.length;
switch (G__30751) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30749.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto__.call(null,m,state_map));
} else {
var m__8574__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto__.call(null,m,mode));
} else {
var m__8574__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___30768 = arguments.length;
var i__8977__auto___30769 = (0);
while(true){
if((i__8977__auto___30769 < len__8976__auto___30768)){
args__8983__auto__.push((arguments[i__8977__auto___30769]));

var G__30770 = (i__8977__auto___30769 + (1));
i__8977__auto___30769 = G__30770;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((3) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8984__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30762){
var map__30763 = p__30762;
var map__30763__$1 = ((((!((map__30763 == null)))?((((map__30763.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30763.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30763):map__30763);
var opts = map__30763__$1;
var statearr_30765_30771 = state;
(statearr_30765_30771[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__30763,map__30763__$1,opts){
return (function (val){
var statearr_30766_30772 = state;
(statearr_30766_30772[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30763,map__30763__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30767_30773 = state;
(statearr_30767_30773[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30758){
var G__30759 = cljs.core.first(seq30758);
var seq30758__$1 = cljs.core.next(seq30758);
var G__30760 = cljs.core.first(seq30758__$1);
var seq30758__$2 = cljs.core.next(seq30758__$1);
var G__30761 = cljs.core.first(seq30758__$2);
var seq30758__$3 = cljs.core.next(seq30758__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30759,G__30760,G__30761,seq30758__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30940 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30940) : cljs.core.atom.call(null,G__30940));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.constant$keyword$mute) : cljs.core.atom.call(null,cljs.core.constant$keyword$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t30941 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30941 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30942){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30942 = meta30942;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30941.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30943,meta30942__$1){
var self__ = this;
var _30943__$1 = this;
return (new cljs.core.async.t30941(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30942__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30943){
var self__ = this;
var _30943__$1 = this;
return self__.meta30942;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30941.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30944_31106 = self__.cs;
var G__30945_31107 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30944_31106,G__30945_31107) : cljs.core.reset_BANG_.call(null,G__30944_31106,G__30945_31107));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30942","meta30942",348540256,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30941.cljs$lang$type = true;

cljs.core.async.t30941.cljs$lang$ctorStr = "cljs.core.async/t30941";

cljs.core.async.t30941.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30941");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t30941 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t30941(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30942){
return (new cljs.core.async.t30941(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30942));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t30941(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11624__auto___31108 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31043){
var state_val_31044 = (state_31043[(1)]);
if((state_val_31044 === (7))){
var inst_30961 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
var statearr_31045_31109 = state_31043__$1;
(statearr_31045_31109[(2)] = inst_30961);

(statearr_31045_31109[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (20))){
var inst_30973 = (state_31043[(7)]);
var state_31043__$1 = state_31043;
var statearr_31046_31110 = state_31043__$1;
(statearr_31046_31110[(2)] = inst_30973);

(statearr_31046_31110[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (27))){
var state_31043__$1 = state_31043;
var statearr_31047_31111 = state_31043__$1;
(statearr_31047_31111[(2)] = null);

(statearr_31047_31111[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (1))){
var inst_30949 = (state_31043[(8)]);
var inst_30949__$1 = calc_state();
var inst_30951 = (inst_30949__$1 == null);
var inst_30952 = cljs.core.not(inst_30951);
var state_31043__$1 = (function (){var statearr_31048 = state_31043;
(statearr_31048[(8)] = inst_30949__$1);

return statearr_31048;
})();
if(inst_30952){
var statearr_31049_31112 = state_31043__$1;
(statearr_31049_31112[(1)] = (2));

} else {
var statearr_31050_31113 = state_31043__$1;
(statearr_31050_31113[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (24))){
var inst_31017 = (state_31043[(9)]);
var inst_30996 = (state_31043[(10)]);
var inst_31003 = (state_31043[(11)]);
var inst_31017__$1 = (inst_30996.cljs$core$IFn$_invoke$arity$1 ? inst_30996.cljs$core$IFn$_invoke$arity$1(inst_31003) : inst_30996.call(null,inst_31003));
var state_31043__$1 = (function (){var statearr_31051 = state_31043;
(statearr_31051[(9)] = inst_31017__$1);

return statearr_31051;
})();
if(cljs.core.truth_(inst_31017__$1)){
var statearr_31052_31114 = state_31043__$1;
(statearr_31052_31114[(1)] = (29));

} else {
var statearr_31053_31115 = state_31043__$1;
(statearr_31053_31115[(1)] = (30));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (4))){
var inst_30964 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_30964)){
var statearr_31054_31116 = state_31043__$1;
(statearr_31054_31116[(1)] = (8));

} else {
var statearr_31055_31117 = state_31043__$1;
(statearr_31055_31117[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (15))){
var inst_30990 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_30990)){
var statearr_31056_31118 = state_31043__$1;
(statearr_31056_31118[(1)] = (19));

} else {
var statearr_31057_31119 = state_31043__$1;
(statearr_31057_31119[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (21))){
var inst_30995 = (state_31043[(12)]);
var inst_30995__$1 = (state_31043[(2)]);
var inst_30996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30995__$1,cljs.core.constant$keyword$solos);
var inst_30997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30995__$1,cljs.core.constant$keyword$mutes);
var inst_30998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30995__$1,cljs.core.constant$keyword$reads);
var state_31043__$1 = (function (){var statearr_31058 = state_31043;
(statearr_31058[(13)] = inst_30997);

(statearr_31058[(10)] = inst_30996);

(statearr_31058[(12)] = inst_30995__$1);

return statearr_31058;
})();
return cljs.core.async.ioc_alts_BANG_(state_31043__$1,(22),inst_30998);
} else {
if((state_val_31044 === (31))){
var inst_31025 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_31025)){
var statearr_31059_31120 = state_31043__$1;
(statearr_31059_31120[(1)] = (32));

} else {
var statearr_31060_31121 = state_31043__$1;
(statearr_31060_31121[(1)] = (33));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (32))){
var inst_31002 = (state_31043[(14)]);
var state_31043__$1 = state_31043;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31043__$1,(35),out,inst_31002);
} else {
if((state_val_31044 === (33))){
var inst_30995 = (state_31043[(12)]);
var inst_30973 = inst_30995;
var state_31043__$1 = (function (){var statearr_31061 = state_31043;
(statearr_31061[(7)] = inst_30973);

return statearr_31061;
})();
var statearr_31062_31122 = state_31043__$1;
(statearr_31062_31122[(2)] = null);

(statearr_31062_31122[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (13))){
var inst_30973 = (state_31043[(7)]);
var inst_30980 = inst_30973.cljs$lang$protocol_mask$partition0$;
var inst_30981 = (inst_30980 & (64));
var inst_30982 = inst_30973.cljs$core$ISeq$;
var inst_30983 = (inst_30981) || (inst_30982);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_30983)){
var statearr_31063_31123 = state_31043__$1;
(statearr_31063_31123[(1)] = (16));

} else {
var statearr_31064_31124 = state_31043__$1;
(statearr_31064_31124[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (22))){
var inst_31002 = (state_31043[(14)]);
var inst_31003 = (state_31043[(11)]);
var inst_31001 = (state_31043[(2)]);
var inst_31002__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31001,(0),null);
var inst_31003__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31001,(1),null);
var inst_31004 = (inst_31002__$1 == null);
var inst_31005 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31003__$1,change);
var inst_31006 = (inst_31004) || (inst_31005);
var state_31043__$1 = (function (){var statearr_31065 = state_31043;
(statearr_31065[(14)] = inst_31002__$1);

(statearr_31065[(11)] = inst_31003__$1);

return statearr_31065;
})();
if(cljs.core.truth_(inst_31006)){
var statearr_31066_31125 = state_31043__$1;
(statearr_31066_31125[(1)] = (23));

} else {
var statearr_31067_31126 = state_31043__$1;
(statearr_31067_31126[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (36))){
var inst_30995 = (state_31043[(12)]);
var inst_30973 = inst_30995;
var state_31043__$1 = (function (){var statearr_31068 = state_31043;
(statearr_31068[(7)] = inst_30973);

return statearr_31068;
})();
var statearr_31069_31127 = state_31043__$1;
(statearr_31069_31127[(2)] = null);

(statearr_31069_31127[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (29))){
var inst_31017 = (state_31043[(9)]);
var state_31043__$1 = state_31043;
var statearr_31070_31128 = state_31043__$1;
(statearr_31070_31128[(2)] = inst_31017);

(statearr_31070_31128[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (6))){
var state_31043__$1 = state_31043;
var statearr_31071_31129 = state_31043__$1;
(statearr_31071_31129[(2)] = false);

(statearr_31071_31129[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (28))){
var inst_31013 = (state_31043[(2)]);
var inst_31014 = calc_state();
var inst_30973 = inst_31014;
var state_31043__$1 = (function (){var statearr_31072 = state_31043;
(statearr_31072[(15)] = inst_31013);

(statearr_31072[(7)] = inst_30973);

return statearr_31072;
})();
var statearr_31073_31130 = state_31043__$1;
(statearr_31073_31130[(2)] = null);

(statearr_31073_31130[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (25))){
var inst_31039 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
var statearr_31074_31131 = state_31043__$1;
(statearr_31074_31131[(2)] = inst_31039);

(statearr_31074_31131[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (34))){
var inst_31037 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
var statearr_31075_31132 = state_31043__$1;
(statearr_31075_31132[(2)] = inst_31037);

(statearr_31075_31132[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (17))){
var state_31043__$1 = state_31043;
var statearr_31076_31133 = state_31043__$1;
(statearr_31076_31133[(2)] = false);

(statearr_31076_31133[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (3))){
var state_31043__$1 = state_31043;
var statearr_31077_31134 = state_31043__$1;
(statearr_31077_31134[(2)] = false);

(statearr_31077_31134[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (12))){
var inst_31041 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31043__$1,inst_31041);
} else {
if((state_val_31044 === (2))){
var inst_30949 = (state_31043[(8)]);
var inst_30954 = inst_30949.cljs$lang$protocol_mask$partition0$;
var inst_30955 = (inst_30954 & (64));
var inst_30956 = inst_30949.cljs$core$ISeq$;
var inst_30957 = (inst_30955) || (inst_30956);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_30957)){
var statearr_31078_31135 = state_31043__$1;
(statearr_31078_31135[(1)] = (5));

} else {
var statearr_31079_31136 = state_31043__$1;
(statearr_31079_31136[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (23))){
var inst_31002 = (state_31043[(14)]);
var inst_31008 = (inst_31002 == null);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_31008)){
var statearr_31080_31137 = state_31043__$1;
(statearr_31080_31137[(1)] = (26));

} else {
var statearr_31081_31138 = state_31043__$1;
(statearr_31081_31138[(1)] = (27));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (35))){
var inst_31028 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
if(cljs.core.truth_(inst_31028)){
var statearr_31082_31139 = state_31043__$1;
(statearr_31082_31139[(1)] = (36));

} else {
var statearr_31083_31140 = state_31043__$1;
(statearr_31083_31140[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (19))){
var inst_30973 = (state_31043[(7)]);
var inst_30992 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30973);
var state_31043__$1 = state_31043;
var statearr_31084_31141 = state_31043__$1;
(statearr_31084_31141[(2)] = inst_30992);

(statearr_31084_31141[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (11))){
var inst_30973 = (state_31043[(7)]);
var inst_30977 = (inst_30973 == null);
var inst_30978 = cljs.core.not(inst_30977);
var state_31043__$1 = state_31043;
if(inst_30978){
var statearr_31085_31142 = state_31043__$1;
(statearr_31085_31142[(1)] = (13));

} else {
var statearr_31086_31143 = state_31043__$1;
(statearr_31086_31143[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (9))){
var inst_30949 = (state_31043[(8)]);
var state_31043__$1 = state_31043;
var statearr_31087_31144 = state_31043__$1;
(statearr_31087_31144[(2)] = inst_30949);

(statearr_31087_31144[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (5))){
var state_31043__$1 = state_31043;
var statearr_31088_31145 = state_31043__$1;
(statearr_31088_31145[(2)] = true);

(statearr_31088_31145[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (14))){
var state_31043__$1 = state_31043;
var statearr_31089_31146 = state_31043__$1;
(statearr_31089_31146[(2)] = false);

(statearr_31089_31146[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (26))){
var inst_31003 = (state_31043[(11)]);
var inst_31010 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31003);
var state_31043__$1 = state_31043;
var statearr_31090_31147 = state_31043__$1;
(statearr_31090_31147[(2)] = inst_31010);

(statearr_31090_31147[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (16))){
var state_31043__$1 = state_31043;
var statearr_31091_31148 = state_31043__$1;
(statearr_31091_31148[(2)] = true);

(statearr_31091_31148[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (38))){
var inst_31033 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
var statearr_31092_31149 = state_31043__$1;
(statearr_31092_31149[(2)] = inst_31033);

(statearr_31092_31149[(1)] = (34));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (30))){
var inst_30997 = (state_31043[(13)]);
var inst_30996 = (state_31043[(10)]);
var inst_31003 = (state_31043[(11)]);
var inst_31020 = cljs.core.empty_QMARK_(inst_30996);
var inst_31021 = (inst_30997.cljs$core$IFn$_invoke$arity$1 ? inst_30997.cljs$core$IFn$_invoke$arity$1(inst_31003) : inst_30997.call(null,inst_31003));
var inst_31022 = cljs.core.not(inst_31021);
var inst_31023 = (inst_31020) && (inst_31022);
var state_31043__$1 = state_31043;
var statearr_31093_31150 = state_31043__$1;
(statearr_31093_31150[(2)] = inst_31023);

(statearr_31093_31150[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (10))){
var inst_30949 = (state_31043[(8)]);
var inst_30969 = (state_31043[(2)]);
var inst_30970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30969,cljs.core.constant$keyword$solos);
var inst_30971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30969,cljs.core.constant$keyword$mutes);
var inst_30972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30969,cljs.core.constant$keyword$reads);
var inst_30973 = inst_30949;
var state_31043__$1 = (function (){var statearr_31094 = state_31043;
(statearr_31094[(16)] = inst_30972);

(statearr_31094[(7)] = inst_30973);

(statearr_31094[(17)] = inst_30970);

(statearr_31094[(18)] = inst_30971);

return statearr_31094;
})();
var statearr_31095_31151 = state_31043__$1;
(statearr_31095_31151[(2)] = null);

(statearr_31095_31151[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (18))){
var inst_30987 = (state_31043[(2)]);
var state_31043__$1 = state_31043;
var statearr_31096_31152 = state_31043__$1;
(statearr_31096_31152[(2)] = inst_30987);

(statearr_31096_31152[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (37))){
var state_31043__$1 = state_31043;
var statearr_31097_31153 = state_31043__$1;
(statearr_31097_31153[(2)] = null);

(statearr_31097_31153[(1)] = (38));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31044 === (8))){
var inst_30949 = (state_31043[(8)]);
var inst_30966 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30949);
var state_31043__$1 = state_31043;
var statearr_31098_31154 = state_31043__$1;
(statearr_31098_31154[(2)] = inst_30966);

(statearr_31098_31154[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11559__auto__,c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11560__auto__ = null;
var cljs$core$async$mix_$_state_machine__11560__auto____0 = (function (){
var statearr_31102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31102[(0)] = cljs$core$async$mix_$_state_machine__11560__auto__);

(statearr_31102[(1)] = (1));

return statearr_31102;
});
var cljs$core$async$mix_$_state_machine__11560__auto____1 = (function (state_31043){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31043);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31103){if((e31103 instanceof Object)){
var ex__11563__auto__ = e31103;
var statearr_31104_31155 = state_31043;
(statearr_31104_31155[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31043);

return cljs.core.constant$keyword$recur;
} else {
throw e31103;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31156 = state_31043;
state_31043 = G__31156;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11560__auto__ = function(state_31043){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11560__auto____1.call(this,state_31043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11560__auto____0;
cljs$core$async$mix_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11560__auto____1;
return cljs$core$async$mix_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11626__auto__ = (function (){var statearr_31105 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31108);

return statearr_31105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31108,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto__.call(null,p,v,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args31159 = [];
var len__8976__auto___31162 = arguments.length;
var i__8977__auto___31163 = (0);
while(true){
if((i__8977__auto___31163 < len__8976__auto___31162)){
args31159.push((arguments[i__8977__auto___31163]));

var G__31164 = (i__8977__auto___31163 + (1));
i__8977__auto___31163 = G__31164;
continue;
} else {
}
break;
}

var G__31161 = args31159.length;
switch (G__31161) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31159.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto__.call(null,p));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto__.call(null,p,v));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args31167 = [];
var len__8976__auto___31295 = arguments.length;
var i__8977__auto___31296 = (0);
while(true){
if((i__8977__auto___31296 < len__8976__auto___31295)){
args31167.push((arguments[i__8977__auto___31296]));

var G__31297 = (i__8977__auto___31296 + (1));
i__8977__auto___31296 = G__31297;
continue;
} else {
}
break;
}

var G__31169 = args31167.length;
switch (G__31169) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31167.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__31170 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31170) : cljs.core.atom.call(null,G__31170));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7937__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7937__auto__,mults){
return (function (p1__31166_SHARP_){
if(cljs.core.truth_((p1__31166_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31166_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31166_SHARP_.call(null,topic)))){
return p1__31166_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31166_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7937__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t31171 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31171 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31172){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31172 = meta31172;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31171.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31173,meta31172__$1){
var self__ = this;
var _31173__$1 = this;
return (new cljs.core.async.t31171(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31172__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31173){
var self__ = this;
var _31173__$1 = this;
return self__.meta31172;
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31171.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t31171.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31174 = self__.mults;
var G__31175 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31174,G__31175) : cljs.core.reset_BANG_.call(null,G__31174,G__31175));
});})(mults,ensure_mult))
;

cljs.core.async.t31171.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t31171.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31172","meta31172",966406259,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t31171.cljs$lang$type = true;

cljs.core.async.t31171.cljs$lang$ctorStr = "cljs.core.async/t31171";

cljs.core.async.t31171.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31171");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t31171 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t31171(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31172){
return (new cljs.core.async.t31171(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31172));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t31171(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11624__auto___31299 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31299,mults,ensure_mult,p){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31299,mults,ensure_mult,p){
return (function (state_31247){
var state_val_31248 = (state_31247[(1)]);
if((state_val_31248 === (7))){
var inst_31243 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31249_31300 = state_31247__$1;
(statearr_31249_31300[(2)] = inst_31243);

(statearr_31249_31300[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (20))){
var state_31247__$1 = state_31247;
var statearr_31250_31301 = state_31247__$1;
(statearr_31250_31301[(2)] = null);

(statearr_31250_31301[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (1))){
var state_31247__$1 = state_31247;
var statearr_31251_31302 = state_31247__$1;
(statearr_31251_31302[(2)] = null);

(statearr_31251_31302[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (24))){
var inst_31226 = (state_31247[(7)]);
var inst_31235 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31226);
var state_31247__$1 = state_31247;
var statearr_31252_31303 = state_31247__$1;
(statearr_31252_31303[(2)] = inst_31235);

(statearr_31252_31303[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (4))){
var inst_31178 = (state_31247[(8)]);
var inst_31178__$1 = (state_31247[(2)]);
var inst_31179 = (inst_31178__$1 == null);
var state_31247__$1 = (function (){var statearr_31253 = state_31247;
(statearr_31253[(8)] = inst_31178__$1);

return statearr_31253;
})();
if(cljs.core.truth_(inst_31179)){
var statearr_31254_31304 = state_31247__$1;
(statearr_31254_31304[(1)] = (5));

} else {
var statearr_31255_31305 = state_31247__$1;
(statearr_31255_31305[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (15))){
var inst_31220 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31256_31306 = state_31247__$1;
(statearr_31256_31306[(2)] = inst_31220);

(statearr_31256_31306[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (21))){
var inst_31240 = (state_31247[(2)]);
var state_31247__$1 = (function (){var statearr_31257 = state_31247;
(statearr_31257[(9)] = inst_31240);

return statearr_31257;
})();
var statearr_31258_31307 = state_31247__$1;
(statearr_31258_31307[(2)] = null);

(statearr_31258_31307[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (13))){
var inst_31202 = (state_31247[(10)]);
var inst_31204 = cljs.core.chunked_seq_QMARK_(inst_31202);
var state_31247__$1 = state_31247;
if(inst_31204){
var statearr_31259_31308 = state_31247__$1;
(statearr_31259_31308[(1)] = (16));

} else {
var statearr_31260_31309 = state_31247__$1;
(statearr_31260_31309[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (22))){
var inst_31232 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
if(cljs.core.truth_(inst_31232)){
var statearr_31261_31310 = state_31247__$1;
(statearr_31261_31310[(1)] = (23));

} else {
var statearr_31262_31311 = state_31247__$1;
(statearr_31262_31311[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (6))){
var inst_31228 = (state_31247[(11)]);
var inst_31226 = (state_31247[(7)]);
var inst_31178 = (state_31247[(8)]);
var inst_31226__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31178) : topic_fn.call(null,inst_31178));
var inst_31227 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31228__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31227,inst_31226__$1);
var state_31247__$1 = (function (){var statearr_31263 = state_31247;
(statearr_31263[(11)] = inst_31228__$1);

(statearr_31263[(7)] = inst_31226__$1);

return statearr_31263;
})();
if(cljs.core.truth_(inst_31228__$1)){
var statearr_31264_31312 = state_31247__$1;
(statearr_31264_31312[(1)] = (19));

} else {
var statearr_31265_31313 = state_31247__$1;
(statearr_31265_31313[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (25))){
var inst_31237 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31266_31314 = state_31247__$1;
(statearr_31266_31314[(2)] = inst_31237);

(statearr_31266_31314[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (17))){
var inst_31202 = (state_31247[(10)]);
var inst_31211 = cljs.core.first(inst_31202);
var inst_31212 = cljs.core.async.muxch_STAR_(inst_31211);
var inst_31213 = cljs.core.async.close_BANG_(inst_31212);
var inst_31214 = cljs.core.next(inst_31202);
var inst_31188 = inst_31214;
var inst_31189 = null;
var inst_31190 = (0);
var inst_31191 = (0);
var state_31247__$1 = (function (){var statearr_31267 = state_31247;
(statearr_31267[(12)] = inst_31213);

(statearr_31267[(13)] = inst_31188);

(statearr_31267[(14)] = inst_31190);

(statearr_31267[(15)] = inst_31189);

(statearr_31267[(16)] = inst_31191);

return statearr_31267;
})();
var statearr_31268_31315 = state_31247__$1;
(statearr_31268_31315[(2)] = null);

(statearr_31268_31315[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (3))){
var inst_31245 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31247__$1,inst_31245);
} else {
if((state_val_31248 === (12))){
var inst_31222 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31269_31316 = state_31247__$1;
(statearr_31269_31316[(2)] = inst_31222);

(statearr_31269_31316[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (2))){
var state_31247__$1 = state_31247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31247__$1,(4),ch);
} else {
if((state_val_31248 === (23))){
var state_31247__$1 = state_31247;
var statearr_31270_31317 = state_31247__$1;
(statearr_31270_31317[(2)] = null);

(statearr_31270_31317[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (19))){
var inst_31228 = (state_31247[(11)]);
var inst_31178 = (state_31247[(8)]);
var inst_31230 = cljs.core.async.muxch_STAR_(inst_31228);
var state_31247__$1 = state_31247;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31247__$1,(22),inst_31230,inst_31178);
} else {
if((state_val_31248 === (11))){
var inst_31188 = (state_31247[(13)]);
var inst_31202 = (state_31247[(10)]);
var inst_31202__$1 = cljs.core.seq(inst_31188);
var state_31247__$1 = (function (){var statearr_31271 = state_31247;
(statearr_31271[(10)] = inst_31202__$1);

return statearr_31271;
})();
if(inst_31202__$1){
var statearr_31272_31318 = state_31247__$1;
(statearr_31272_31318[(1)] = (13));

} else {
var statearr_31273_31319 = state_31247__$1;
(statearr_31273_31319[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (9))){
var inst_31224 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31274_31320 = state_31247__$1;
(statearr_31274_31320[(2)] = inst_31224);

(statearr_31274_31320[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (5))){
var inst_31185 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31186 = cljs.core.vals(inst_31185);
var inst_31187 = cljs.core.seq(inst_31186);
var inst_31188 = inst_31187;
var inst_31189 = null;
var inst_31190 = (0);
var inst_31191 = (0);
var state_31247__$1 = (function (){var statearr_31275 = state_31247;
(statearr_31275[(13)] = inst_31188);

(statearr_31275[(14)] = inst_31190);

(statearr_31275[(15)] = inst_31189);

(statearr_31275[(16)] = inst_31191);

return statearr_31275;
})();
var statearr_31276_31321 = state_31247__$1;
(statearr_31276_31321[(2)] = null);

(statearr_31276_31321[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (14))){
var state_31247__$1 = state_31247;
var statearr_31280_31322 = state_31247__$1;
(statearr_31280_31322[(2)] = null);

(statearr_31280_31322[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (16))){
var inst_31202 = (state_31247[(10)]);
var inst_31206 = cljs.core.chunk_first(inst_31202);
var inst_31207 = cljs.core.chunk_rest(inst_31202);
var inst_31208 = cljs.core.count(inst_31206);
var inst_31188 = inst_31207;
var inst_31189 = inst_31206;
var inst_31190 = inst_31208;
var inst_31191 = (0);
var state_31247__$1 = (function (){var statearr_31281 = state_31247;
(statearr_31281[(13)] = inst_31188);

(statearr_31281[(14)] = inst_31190);

(statearr_31281[(15)] = inst_31189);

(statearr_31281[(16)] = inst_31191);

return statearr_31281;
})();
var statearr_31282_31323 = state_31247__$1;
(statearr_31282_31323[(2)] = null);

(statearr_31282_31323[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (10))){
var inst_31188 = (state_31247[(13)]);
var inst_31190 = (state_31247[(14)]);
var inst_31189 = (state_31247[(15)]);
var inst_31191 = (state_31247[(16)]);
var inst_31196 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31189,inst_31191);
var inst_31197 = cljs.core.async.muxch_STAR_(inst_31196);
var inst_31198 = cljs.core.async.close_BANG_(inst_31197);
var inst_31199 = (inst_31191 + (1));
var tmp31277 = inst_31188;
var tmp31278 = inst_31190;
var tmp31279 = inst_31189;
var inst_31188__$1 = tmp31277;
var inst_31189__$1 = tmp31279;
var inst_31190__$1 = tmp31278;
var inst_31191__$1 = inst_31199;
var state_31247__$1 = (function (){var statearr_31283 = state_31247;
(statearr_31283[(17)] = inst_31198);

(statearr_31283[(13)] = inst_31188__$1);

(statearr_31283[(14)] = inst_31190__$1);

(statearr_31283[(15)] = inst_31189__$1);

(statearr_31283[(16)] = inst_31191__$1);

return statearr_31283;
})();
var statearr_31284_31324 = state_31247__$1;
(statearr_31284_31324[(2)] = null);

(statearr_31284_31324[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (18))){
var inst_31217 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31285_31325 = state_31247__$1;
(statearr_31285_31325[(2)] = inst_31217);

(statearr_31285_31325[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (8))){
var inst_31190 = (state_31247[(14)]);
var inst_31191 = (state_31247[(16)]);
var inst_31193 = (inst_31191 < inst_31190);
var inst_31194 = inst_31193;
var state_31247__$1 = state_31247;
if(cljs.core.truth_(inst_31194)){
var statearr_31286_31326 = state_31247__$1;
(statearr_31286_31326[(1)] = (10));

} else {
var statearr_31287_31327 = state_31247__$1;
(statearr_31287_31327[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31299,mults,ensure_mult,p))
;
return ((function (switch__11559__auto__,c__11624__auto___31299,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31291 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31291[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31291[(1)] = (1));

return statearr_31291;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31247){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31247);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31292){if((e31292 instanceof Object)){
var ex__11563__auto__ = e31292;
var statearr_31293_31328 = state_31247;
(statearr_31293_31328[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31247);

return cljs.core.constant$keyword$recur;
} else {
throw e31292;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31329 = state_31247;
state_31247 = G__31329;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31247){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31299,mults,ensure_mult,p))
})();
var state__11626__auto__ = (function (){var statearr_31294 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31294[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31299);

return statearr_31294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31299,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31330 = [];
var len__8976__auto___31333 = arguments.length;
var i__8977__auto___31334 = (0);
while(true){
if((i__8977__auto___31334 < len__8976__auto___31333)){
args31330.push((arguments[i__8977__auto___31334]));

var G__31335 = (i__8977__auto___31334 + (1));
i__8977__auto___31334 = G__31335;
continue;
} else {
}
break;
}

var G__31332 = args31330.length;
switch (G__31332) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31330.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31337 = [];
var len__8976__auto___31340 = arguments.length;
var i__8977__auto___31341 = (0);
while(true){
if((i__8977__auto___31341 < len__8976__auto___31340)){
args31337.push((arguments[i__8977__auto___31341]));

var G__31342 = (i__8977__auto___31341 + (1));
i__8977__auto___31341 = G__31342;
continue;
} else {
}
break;
}

var G__31339 = args31337.length;
switch (G__31339) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31337.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31344 = [];
var len__8976__auto___31415 = arguments.length;
var i__8977__auto___31416 = (0);
while(true){
if((i__8977__auto___31416 < len__8976__auto___31415)){
args31344.push((arguments[i__8977__auto___31416]));

var G__31417 = (i__8977__auto___31416 + (1));
i__8977__auto___31416 = G__31417;
continue;
} else {
}
break;
}

var G__31346 = args31344.length;
switch (G__31346) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31344.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11624__auto___31419 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31385){
var state_val_31386 = (state_31385[(1)]);
if((state_val_31386 === (7))){
var state_31385__$1 = state_31385;
var statearr_31387_31420 = state_31385__$1;
(statearr_31387_31420[(2)] = null);

(statearr_31387_31420[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (1))){
var state_31385__$1 = state_31385;
var statearr_31388_31421 = state_31385__$1;
(statearr_31388_31421[(2)] = null);

(statearr_31388_31421[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (4))){
var inst_31349 = (state_31385[(7)]);
var inst_31351 = (inst_31349 < cnt);
var state_31385__$1 = state_31385;
if(cljs.core.truth_(inst_31351)){
var statearr_31389_31422 = state_31385__$1;
(statearr_31389_31422[(1)] = (6));

} else {
var statearr_31390_31423 = state_31385__$1;
(statearr_31390_31423[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (15))){
var inst_31381 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
var statearr_31391_31424 = state_31385__$1;
(statearr_31391_31424[(2)] = inst_31381);

(statearr_31391_31424[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (13))){
var inst_31374 = cljs.core.async.close_BANG_(out);
var state_31385__$1 = state_31385;
var statearr_31392_31425 = state_31385__$1;
(statearr_31392_31425[(2)] = inst_31374);

(statearr_31392_31425[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (6))){
var state_31385__$1 = state_31385;
var statearr_31393_31426 = state_31385__$1;
(statearr_31393_31426[(2)] = null);

(statearr_31393_31426[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (3))){
var inst_31383 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31385__$1,inst_31383);
} else {
if((state_val_31386 === (12))){
var inst_31371 = (state_31385[(8)]);
var inst_31371__$1 = (state_31385[(2)]);
var inst_31372 = cljs.core.some(cljs.core.nil_QMARK_,inst_31371__$1);
var state_31385__$1 = (function (){var statearr_31394 = state_31385;
(statearr_31394[(8)] = inst_31371__$1);

return statearr_31394;
})();
if(cljs.core.truth_(inst_31372)){
var statearr_31395_31427 = state_31385__$1;
(statearr_31395_31427[(1)] = (13));

} else {
var statearr_31396_31428 = state_31385__$1;
(statearr_31396_31428[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (2))){
var inst_31348 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_31349 = (0);
var state_31385__$1 = (function (){var statearr_31397 = state_31385;
(statearr_31397[(9)] = inst_31348);

(statearr_31397[(7)] = inst_31349);

return statearr_31397;
})();
var statearr_31398_31429 = state_31385__$1;
(statearr_31398_31429[(2)] = null);

(statearr_31398_31429[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (11))){
var inst_31349 = (state_31385[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_31385,(10),Object,null,(9));
var inst_31358 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31349) : chs__$1.call(null,inst_31349));
var inst_31359 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31349) : done.call(null,inst_31349));
var inst_31360 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31358,inst_31359);
var state_31385__$1 = state_31385;
var statearr_31399_31430 = state_31385__$1;
(statearr_31399_31430[(2)] = inst_31360);


cljs.core.async.impl.ioc_helpers.process_exception(state_31385__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (9))){
var inst_31349 = (state_31385[(7)]);
var inst_31362 = (state_31385[(2)]);
var inst_31363 = (inst_31349 + (1));
var inst_31349__$1 = inst_31363;
var state_31385__$1 = (function (){var statearr_31400 = state_31385;
(statearr_31400[(10)] = inst_31362);

(statearr_31400[(7)] = inst_31349__$1);

return statearr_31400;
})();
var statearr_31401_31431 = state_31385__$1;
(statearr_31401_31431[(2)] = null);

(statearr_31401_31431[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (5))){
var inst_31369 = (state_31385[(2)]);
var state_31385__$1 = (function (){var statearr_31402 = state_31385;
(statearr_31402[(11)] = inst_31369);

return statearr_31402;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31385__$1,(12),dchan);
} else {
if((state_val_31386 === (14))){
var inst_31371 = (state_31385[(8)]);
var inst_31376 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31371);
var state_31385__$1 = state_31385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31385__$1,(16),out,inst_31376);
} else {
if((state_val_31386 === (16))){
var inst_31378 = (state_31385[(2)]);
var state_31385__$1 = (function (){var statearr_31403 = state_31385;
(statearr_31403[(12)] = inst_31378);

return statearr_31403;
})();
var statearr_31404_31432 = state_31385__$1;
(statearr_31404_31432[(2)] = null);

(statearr_31404_31432[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (10))){
var inst_31353 = (state_31385[(2)]);
var inst_31354 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31385__$1 = (function (){var statearr_31405 = state_31385;
(statearr_31405[(13)] = inst_31353);

return statearr_31405;
})();
var statearr_31406_31433 = state_31385__$1;
(statearr_31406_31433[(2)] = inst_31354);


cljs.core.async.impl.ioc_helpers.process_exception(state_31385__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31386 === (8))){
var inst_31367 = (state_31385[(2)]);
var state_31385__$1 = state_31385;
var statearr_31407_31434 = state_31385__$1;
(statearr_31407_31434[(2)] = inst_31367);

(statearr_31407_31434[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11559__auto__,c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31411 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31411[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31411[(1)] = (1));

return statearr_31411;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31385){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31385);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31412){if((e31412 instanceof Object)){
var ex__11563__auto__ = e31412;
var statearr_31413_31435 = state_31385;
(statearr_31413_31435[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31385);

return cljs.core.constant$keyword$recur;
} else {
throw e31412;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31436 = state_31385;
state_31385 = G__31436;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11626__auto__ = (function (){var statearr_31414 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31419);

return statearr_31414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31419,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31438 = [];
var len__8976__auto___31494 = arguments.length;
var i__8977__auto___31495 = (0);
while(true){
if((i__8977__auto___31495 < len__8976__auto___31494)){
args31438.push((arguments[i__8977__auto___31495]));

var G__31496 = (i__8977__auto___31495 + (1));
i__8977__auto___31495 = G__31496;
continue;
} else {
}
break;
}

var G__31440 = args31438.length;
switch (G__31440) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31438.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___31498 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31498,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31498,out){
return (function (state_31470){
var state_val_31471 = (state_31470[(1)]);
if((state_val_31471 === (7))){
var inst_31450 = (state_31470[(7)]);
var inst_31449 = (state_31470[(8)]);
var inst_31449__$1 = (state_31470[(2)]);
var inst_31450__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31449__$1,(0),null);
var inst_31451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31449__$1,(1),null);
var inst_31452 = (inst_31450__$1 == null);
var state_31470__$1 = (function (){var statearr_31472 = state_31470;
(statearr_31472[(7)] = inst_31450__$1);

(statearr_31472[(9)] = inst_31451);

(statearr_31472[(8)] = inst_31449__$1);

return statearr_31472;
})();
if(cljs.core.truth_(inst_31452)){
var statearr_31473_31499 = state_31470__$1;
(statearr_31473_31499[(1)] = (8));

} else {
var statearr_31474_31500 = state_31470__$1;
(statearr_31474_31500[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (1))){
var inst_31441 = cljs.core.vec(chs);
var inst_31442 = inst_31441;
var state_31470__$1 = (function (){var statearr_31475 = state_31470;
(statearr_31475[(10)] = inst_31442);

return statearr_31475;
})();
var statearr_31476_31501 = state_31470__$1;
(statearr_31476_31501[(2)] = null);

(statearr_31476_31501[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (4))){
var inst_31442 = (state_31470[(10)]);
var state_31470__$1 = state_31470;
return cljs.core.async.ioc_alts_BANG_(state_31470__$1,(7),inst_31442);
} else {
if((state_val_31471 === (6))){
var inst_31466 = (state_31470[(2)]);
var state_31470__$1 = state_31470;
var statearr_31477_31502 = state_31470__$1;
(statearr_31477_31502[(2)] = inst_31466);

(statearr_31477_31502[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (3))){
var inst_31468 = (state_31470[(2)]);
var state_31470__$1 = state_31470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31470__$1,inst_31468);
} else {
if((state_val_31471 === (2))){
var inst_31442 = (state_31470[(10)]);
var inst_31444 = cljs.core.count(inst_31442);
var inst_31445 = (inst_31444 > (0));
var state_31470__$1 = state_31470;
if(cljs.core.truth_(inst_31445)){
var statearr_31479_31503 = state_31470__$1;
(statearr_31479_31503[(1)] = (4));

} else {
var statearr_31480_31504 = state_31470__$1;
(statearr_31480_31504[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (11))){
var inst_31442 = (state_31470[(10)]);
var inst_31459 = (state_31470[(2)]);
var tmp31478 = inst_31442;
var inst_31442__$1 = tmp31478;
var state_31470__$1 = (function (){var statearr_31481 = state_31470;
(statearr_31481[(10)] = inst_31442__$1);

(statearr_31481[(11)] = inst_31459);

return statearr_31481;
})();
var statearr_31482_31505 = state_31470__$1;
(statearr_31482_31505[(2)] = null);

(statearr_31482_31505[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (9))){
var inst_31450 = (state_31470[(7)]);
var state_31470__$1 = state_31470;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31470__$1,(11),out,inst_31450);
} else {
if((state_val_31471 === (5))){
var inst_31464 = cljs.core.async.close_BANG_(out);
var state_31470__$1 = state_31470;
var statearr_31483_31506 = state_31470__$1;
(statearr_31483_31506[(2)] = inst_31464);

(statearr_31483_31506[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (10))){
var inst_31462 = (state_31470[(2)]);
var state_31470__$1 = state_31470;
var statearr_31484_31507 = state_31470__$1;
(statearr_31484_31507[(2)] = inst_31462);

(statearr_31484_31507[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31471 === (8))){
var inst_31450 = (state_31470[(7)]);
var inst_31442 = (state_31470[(10)]);
var inst_31451 = (state_31470[(9)]);
var inst_31449 = (state_31470[(8)]);
var inst_31454 = (function (){var cs = inst_31442;
var vec__31447 = inst_31449;
var v = inst_31450;
var c = inst_31451;
return ((function (cs,vec__31447,v,c,inst_31450,inst_31442,inst_31451,inst_31449,state_val_31471,c__11624__auto___31498,out){
return (function (p1__31437_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31437_SHARP_);
});
;})(cs,vec__31447,v,c,inst_31450,inst_31442,inst_31451,inst_31449,state_val_31471,c__11624__auto___31498,out))
})();
var inst_31455 = cljs.core.filterv(inst_31454,inst_31442);
var inst_31442__$1 = inst_31455;
var state_31470__$1 = (function (){var statearr_31485 = state_31470;
(statearr_31485[(10)] = inst_31442__$1);

return statearr_31485;
})();
var statearr_31486_31508 = state_31470__$1;
(statearr_31486_31508[(2)] = null);

(statearr_31486_31508[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31498,out))
;
return ((function (switch__11559__auto__,c__11624__auto___31498,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31490 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31490[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31490[(1)] = (1));

return statearr_31490;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31470){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31470);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31491){if((e31491 instanceof Object)){
var ex__11563__auto__ = e31491;
var statearr_31492_31509 = state_31470;
(statearr_31492_31509[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31470);

return cljs.core.constant$keyword$recur;
} else {
throw e31491;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31510 = state_31470;
state_31470 = G__31510;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31498,out))
})();
var state__11626__auto__ = (function (){var statearr_31493 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31498);

return statearr_31493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31498,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31511 = [];
var len__8976__auto___31560 = arguments.length;
var i__8977__auto___31561 = (0);
while(true){
if((i__8977__auto___31561 < len__8976__auto___31560)){
args31511.push((arguments[i__8977__auto___31561]));

var G__31562 = (i__8977__auto___31561 + (1));
i__8977__auto___31561 = G__31562;
continue;
} else {
}
break;
}

var G__31513 = args31511.length;
switch (G__31513) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31511.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___31564 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31564,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31564,out){
return (function (state_31537){
var state_val_31538 = (state_31537[(1)]);
if((state_val_31538 === (7))){
var inst_31519 = (state_31537[(7)]);
var inst_31519__$1 = (state_31537[(2)]);
var inst_31520 = (inst_31519__$1 == null);
var inst_31521 = cljs.core.not(inst_31520);
var state_31537__$1 = (function (){var statearr_31539 = state_31537;
(statearr_31539[(7)] = inst_31519__$1);

return statearr_31539;
})();
if(inst_31521){
var statearr_31540_31565 = state_31537__$1;
(statearr_31540_31565[(1)] = (8));

} else {
var statearr_31541_31566 = state_31537__$1;
(statearr_31541_31566[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (1))){
var inst_31514 = (0);
var state_31537__$1 = (function (){var statearr_31542 = state_31537;
(statearr_31542[(8)] = inst_31514);

return statearr_31542;
})();
var statearr_31543_31567 = state_31537__$1;
(statearr_31543_31567[(2)] = null);

(statearr_31543_31567[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (4))){
var state_31537__$1 = state_31537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31537__$1,(7),ch);
} else {
if((state_val_31538 === (6))){
var inst_31532 = (state_31537[(2)]);
var state_31537__$1 = state_31537;
var statearr_31544_31568 = state_31537__$1;
(statearr_31544_31568[(2)] = inst_31532);

(statearr_31544_31568[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (3))){
var inst_31534 = (state_31537[(2)]);
var inst_31535 = cljs.core.async.close_BANG_(out);
var state_31537__$1 = (function (){var statearr_31545 = state_31537;
(statearr_31545[(9)] = inst_31534);

return statearr_31545;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31537__$1,inst_31535);
} else {
if((state_val_31538 === (2))){
var inst_31514 = (state_31537[(8)]);
var inst_31516 = (inst_31514 < n);
var state_31537__$1 = state_31537;
if(cljs.core.truth_(inst_31516)){
var statearr_31546_31569 = state_31537__$1;
(statearr_31546_31569[(1)] = (4));

} else {
var statearr_31547_31570 = state_31537__$1;
(statearr_31547_31570[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (11))){
var inst_31514 = (state_31537[(8)]);
var inst_31524 = (state_31537[(2)]);
var inst_31525 = (inst_31514 + (1));
var inst_31514__$1 = inst_31525;
var state_31537__$1 = (function (){var statearr_31548 = state_31537;
(statearr_31548[(10)] = inst_31524);

(statearr_31548[(8)] = inst_31514__$1);

return statearr_31548;
})();
var statearr_31549_31571 = state_31537__$1;
(statearr_31549_31571[(2)] = null);

(statearr_31549_31571[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (9))){
var state_31537__$1 = state_31537;
var statearr_31550_31572 = state_31537__$1;
(statearr_31550_31572[(2)] = null);

(statearr_31550_31572[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (5))){
var state_31537__$1 = state_31537;
var statearr_31551_31573 = state_31537__$1;
(statearr_31551_31573[(2)] = null);

(statearr_31551_31573[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (10))){
var inst_31529 = (state_31537[(2)]);
var state_31537__$1 = state_31537;
var statearr_31552_31574 = state_31537__$1;
(statearr_31552_31574[(2)] = inst_31529);

(statearr_31552_31574[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31538 === (8))){
var inst_31519 = (state_31537[(7)]);
var state_31537__$1 = state_31537;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31537__$1,(11),out,inst_31519);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31564,out))
;
return ((function (switch__11559__auto__,c__11624__auto___31564,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31556 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31556[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31556[(1)] = (1));

return statearr_31556;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31537){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31537);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31557){if((e31557 instanceof Object)){
var ex__11563__auto__ = e31557;
var statearr_31558_31575 = state_31537;
(statearr_31558_31575[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31537);

return cljs.core.constant$keyword$recur;
} else {
throw e31557;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31576 = state_31537;
state_31537 = G__31576;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31537){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31564,out))
})();
var state__11626__auto__ = (function (){var statearr_31559 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31559[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31564);

return statearr_31559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31564,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31586 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31586 = (function (map_LT_,f,ch,meta31587){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31587 = meta31587;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31586.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31588,meta31587__$1){
var self__ = this;
var _31588__$1 = this;
return (new cljs.core.async.t31586(self__.map_LT_,self__.f,self__.ch,meta31587__$1));
});

cljs.core.async.t31586.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31588){
var self__ = this;
var _31588__$1 = this;
return self__.meta31587;
});

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t31589 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31589 = (function (map_LT_,f,ch,meta31587,_,fn1,meta31590){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31587 = meta31587;
this._ = _;
this.fn1 = fn1;
this.meta31590 = meta31590;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31589.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31591,meta31590__$1){
var self__ = this;
var _31591__$1 = this;
return (new cljs.core.async.t31589(self__.map_LT_,self__.f,self__.ch,self__.meta31587,self__._,self__.fn1,meta31590__$1));
});})(___$1))
;

cljs.core.async.t31589.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31591){
var self__ = this;
var _31591__$1 = this;
return self__.meta31590;
});})(___$1))
;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31577_SHARP_){
var G__31592 = (((p1__31577_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31577_SHARP_) : self__.f.call(null,p1__31577_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31592) : f1.call(null,G__31592));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31589.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31587","meta31587",1419904719,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tag,new cljs.core.Symbol("cljs.core.async","t31586","cljs.core.async/t31586",-65806731,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31590","meta31590",-398177588,null)], null);
});})(___$1))
;

cljs.core.async.t31589.cljs$lang$type = true;

cljs.core.async.t31589.cljs$lang$ctorStr = "cljs.core.async/t31589";

cljs.core.async.t31589.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31589");
});})(___$1))
;

cljs.core.async.__GT_t31589 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31589(map_LT___$1,f__$1,ch__$1,meta31587__$1,___$2,fn1__$1,meta31590){
return (new cljs.core.async.t31589(map_LT___$1,f__$1,ch__$1,meta31587__$1,___$2,fn1__$1,meta31590));
});})(___$1))
;

}

return (new cljs.core.async.t31589(self__.map_LT_,self__.f,self__.ch,self__.meta31587,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7925__auto__ = ret;
if(cljs.core.truth_(and__7925__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7925__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31593 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31593) : self__.f.call(null,G__31593));
})());
} else {
return ret;
}
});

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31586.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t31586.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31587","meta31587",1419904719,null)], null);
});

cljs.core.async.t31586.cljs$lang$type = true;

cljs.core.async.t31586.cljs$lang$ctorStr = "cljs.core.async/t31586";

cljs.core.async.t31586.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31586");
});

cljs.core.async.__GT_t31586 = (function cljs$core$async$map_LT__$___GT_t31586(map_LT___$1,f__$1,ch__$1,meta31587){
return (new cljs.core.async.t31586(map_LT___$1,f__$1,ch__$1,meta31587));
});

}

return (new cljs.core.async.t31586(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31597 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31597 = (function (map_GT_,f,ch,meta31598){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31598 = meta31598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31599,meta31598__$1){
var self__ = this;
var _31599__$1 = this;
return (new cljs.core.async.t31597(self__.map_GT_,self__.f,self__.ch,meta31598__$1));
});

cljs.core.async.t31597.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31599){
var self__ = this;
var _31599__$1 = this;
return self__.meta31598;
});

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t31597.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31598","meta31598",825837995,null)], null);
});

cljs.core.async.t31597.cljs$lang$type = true;

cljs.core.async.t31597.cljs$lang$ctorStr = "cljs.core.async/t31597";

cljs.core.async.t31597.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31597");
});

cljs.core.async.__GT_t31597 = (function cljs$core$async$map_GT__$___GT_t31597(map_GT___$1,f__$1,ch__$1,meta31598){
return (new cljs.core.async.t31597(map_GT___$1,f__$1,ch__$1,meta31598));
});

}

return (new cljs.core.async.t31597(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31603 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31603 = (function (filter_GT_,p,ch,meta31604){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31604 = meta31604;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31603.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31605,meta31604__$1){
var self__ = this;
var _31605__$1 = this;
return (new cljs.core.async.t31603(self__.filter_GT_,self__.p,self__.ch,meta31604__$1));
});

cljs.core.async.t31603.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31605){
var self__ = this;
var _31605__$1 = this;
return self__.meta31604;
});

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31603.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t31603.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31604","meta31604",-2001237763,null)], null);
});

cljs.core.async.t31603.cljs$lang$type = true;

cljs.core.async.t31603.cljs$lang$ctorStr = "cljs.core.async/t31603";

cljs.core.async.t31603.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31603");
});

cljs.core.async.__GT_t31603 = (function cljs$core$async$filter_GT__$___GT_t31603(filter_GT___$1,p__$1,ch__$1,meta31604){
return (new cljs.core.async.t31603(filter_GT___$1,p__$1,ch__$1,meta31604));
});

}

return (new cljs.core.async.t31603(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31606 = [];
var len__8976__auto___31650 = arguments.length;
var i__8977__auto___31651 = (0);
while(true){
if((i__8977__auto___31651 < len__8976__auto___31650)){
args31606.push((arguments[i__8977__auto___31651]));

var G__31652 = (i__8977__auto___31651 + (1));
i__8977__auto___31651 = G__31652;
continue;
} else {
}
break;
}

var G__31608 = args31606.length;
switch (G__31608) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31606.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___31654 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31654,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31654,out){
return (function (state_31629){
var state_val_31630 = (state_31629[(1)]);
if((state_val_31630 === (7))){
var inst_31625 = (state_31629[(2)]);
var state_31629__$1 = state_31629;
var statearr_31631_31655 = state_31629__$1;
(statearr_31631_31655[(2)] = inst_31625);

(statearr_31631_31655[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (1))){
var state_31629__$1 = state_31629;
var statearr_31632_31656 = state_31629__$1;
(statearr_31632_31656[(2)] = null);

(statearr_31632_31656[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (4))){
var inst_31611 = (state_31629[(7)]);
var inst_31611__$1 = (state_31629[(2)]);
var inst_31612 = (inst_31611__$1 == null);
var state_31629__$1 = (function (){var statearr_31633 = state_31629;
(statearr_31633[(7)] = inst_31611__$1);

return statearr_31633;
})();
if(cljs.core.truth_(inst_31612)){
var statearr_31634_31657 = state_31629__$1;
(statearr_31634_31657[(1)] = (5));

} else {
var statearr_31635_31658 = state_31629__$1;
(statearr_31635_31658[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (6))){
var inst_31611 = (state_31629[(7)]);
var inst_31616 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31611) : p.call(null,inst_31611));
var state_31629__$1 = state_31629;
if(cljs.core.truth_(inst_31616)){
var statearr_31636_31659 = state_31629__$1;
(statearr_31636_31659[(1)] = (8));

} else {
var statearr_31637_31660 = state_31629__$1;
(statearr_31637_31660[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (3))){
var inst_31627 = (state_31629[(2)]);
var state_31629__$1 = state_31629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31629__$1,inst_31627);
} else {
if((state_val_31630 === (2))){
var state_31629__$1 = state_31629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31629__$1,(4),ch);
} else {
if((state_val_31630 === (11))){
var inst_31619 = (state_31629[(2)]);
var state_31629__$1 = state_31629;
var statearr_31638_31661 = state_31629__$1;
(statearr_31638_31661[(2)] = inst_31619);

(statearr_31638_31661[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (9))){
var state_31629__$1 = state_31629;
var statearr_31639_31662 = state_31629__$1;
(statearr_31639_31662[(2)] = null);

(statearr_31639_31662[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (5))){
var inst_31614 = cljs.core.async.close_BANG_(out);
var state_31629__$1 = state_31629;
var statearr_31640_31663 = state_31629__$1;
(statearr_31640_31663[(2)] = inst_31614);

(statearr_31640_31663[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (10))){
var inst_31622 = (state_31629[(2)]);
var state_31629__$1 = (function (){var statearr_31641 = state_31629;
(statearr_31641[(8)] = inst_31622);

return statearr_31641;
})();
var statearr_31642_31664 = state_31629__$1;
(statearr_31642_31664[(2)] = null);

(statearr_31642_31664[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31630 === (8))){
var inst_31611 = (state_31629[(7)]);
var state_31629__$1 = state_31629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31629__$1,(11),out,inst_31611);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31654,out))
;
return ((function (switch__11559__auto__,c__11624__auto___31654,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31646 = [null,null,null,null,null,null,null,null,null];
(statearr_31646[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31646[(1)] = (1));

return statearr_31646;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31629){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31629);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31647){if((e31647 instanceof Object)){
var ex__11563__auto__ = e31647;
var statearr_31648_31665 = state_31629;
(statearr_31648_31665[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31629);

return cljs.core.constant$keyword$recur;
} else {
throw e31647;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31666 = state_31629;
state_31629 = G__31666;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31629){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31654,out))
})();
var state__11626__auto__ = (function (){var statearr_31649 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31649[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31654);

return statearr_31649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31654,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31667 = [];
var len__8976__auto___31670 = arguments.length;
var i__8977__auto___31671 = (0);
while(true){
if((i__8977__auto___31671 < len__8976__auto___31670)){
args31667.push((arguments[i__8977__auto___31671]));

var G__31672 = (i__8977__auto___31671 + (1));
i__8977__auto___31671 = G__31672;
continue;
} else {
}
break;
}

var G__31669 = args31667.length;
switch (G__31669) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31667.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11624__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto__){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto__){
return (function (state_31839){
var state_val_31840 = (state_31839[(1)]);
if((state_val_31840 === (7))){
var inst_31835 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31841_31882 = state_31839__$1;
(statearr_31841_31882[(2)] = inst_31835);

(statearr_31841_31882[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (20))){
var inst_31805 = (state_31839[(7)]);
var inst_31816 = (state_31839[(2)]);
var inst_31817 = cljs.core.next(inst_31805);
var inst_31791 = inst_31817;
var inst_31792 = null;
var inst_31793 = (0);
var inst_31794 = (0);
var state_31839__$1 = (function (){var statearr_31842 = state_31839;
(statearr_31842[(8)] = inst_31791);

(statearr_31842[(9)] = inst_31794);

(statearr_31842[(10)] = inst_31816);

(statearr_31842[(11)] = inst_31792);

(statearr_31842[(12)] = inst_31793);

return statearr_31842;
})();
var statearr_31843_31883 = state_31839__$1;
(statearr_31843_31883[(2)] = null);

(statearr_31843_31883[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (1))){
var state_31839__$1 = state_31839;
var statearr_31844_31884 = state_31839__$1;
(statearr_31844_31884[(2)] = null);

(statearr_31844_31884[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (4))){
var inst_31780 = (state_31839[(13)]);
var inst_31780__$1 = (state_31839[(2)]);
var inst_31781 = (inst_31780__$1 == null);
var state_31839__$1 = (function (){var statearr_31845 = state_31839;
(statearr_31845[(13)] = inst_31780__$1);

return statearr_31845;
})();
if(cljs.core.truth_(inst_31781)){
var statearr_31846_31885 = state_31839__$1;
(statearr_31846_31885[(1)] = (5));

} else {
var statearr_31847_31886 = state_31839__$1;
(statearr_31847_31886[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (15))){
var state_31839__$1 = state_31839;
var statearr_31851_31887 = state_31839__$1;
(statearr_31851_31887[(2)] = null);

(statearr_31851_31887[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (21))){
var state_31839__$1 = state_31839;
var statearr_31852_31888 = state_31839__$1;
(statearr_31852_31888[(2)] = null);

(statearr_31852_31888[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (13))){
var inst_31791 = (state_31839[(8)]);
var inst_31794 = (state_31839[(9)]);
var inst_31792 = (state_31839[(11)]);
var inst_31793 = (state_31839[(12)]);
var inst_31801 = (state_31839[(2)]);
var inst_31802 = (inst_31794 + (1));
var tmp31848 = inst_31791;
var tmp31849 = inst_31792;
var tmp31850 = inst_31793;
var inst_31791__$1 = tmp31848;
var inst_31792__$1 = tmp31849;
var inst_31793__$1 = tmp31850;
var inst_31794__$1 = inst_31802;
var state_31839__$1 = (function (){var statearr_31853 = state_31839;
(statearr_31853[(8)] = inst_31791__$1);

(statearr_31853[(9)] = inst_31794__$1);

(statearr_31853[(14)] = inst_31801);

(statearr_31853[(11)] = inst_31792__$1);

(statearr_31853[(12)] = inst_31793__$1);

return statearr_31853;
})();
var statearr_31854_31889 = state_31839__$1;
(statearr_31854_31889[(2)] = null);

(statearr_31854_31889[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (22))){
var state_31839__$1 = state_31839;
var statearr_31855_31890 = state_31839__$1;
(statearr_31855_31890[(2)] = null);

(statearr_31855_31890[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (6))){
var inst_31780 = (state_31839[(13)]);
var inst_31789 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31780) : f.call(null,inst_31780));
var inst_31790 = cljs.core.seq(inst_31789);
var inst_31791 = inst_31790;
var inst_31792 = null;
var inst_31793 = (0);
var inst_31794 = (0);
var state_31839__$1 = (function (){var statearr_31856 = state_31839;
(statearr_31856[(8)] = inst_31791);

(statearr_31856[(9)] = inst_31794);

(statearr_31856[(11)] = inst_31792);

(statearr_31856[(12)] = inst_31793);

return statearr_31856;
})();
var statearr_31857_31891 = state_31839__$1;
(statearr_31857_31891[(2)] = null);

(statearr_31857_31891[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (17))){
var inst_31805 = (state_31839[(7)]);
var inst_31809 = cljs.core.chunk_first(inst_31805);
var inst_31810 = cljs.core.chunk_rest(inst_31805);
var inst_31811 = cljs.core.count(inst_31809);
var inst_31791 = inst_31810;
var inst_31792 = inst_31809;
var inst_31793 = inst_31811;
var inst_31794 = (0);
var state_31839__$1 = (function (){var statearr_31858 = state_31839;
(statearr_31858[(8)] = inst_31791);

(statearr_31858[(9)] = inst_31794);

(statearr_31858[(11)] = inst_31792);

(statearr_31858[(12)] = inst_31793);

return statearr_31858;
})();
var statearr_31859_31892 = state_31839__$1;
(statearr_31859_31892[(2)] = null);

(statearr_31859_31892[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (3))){
var inst_31837 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31839__$1,inst_31837);
} else {
if((state_val_31840 === (12))){
var inst_31825 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31860_31893 = state_31839__$1;
(statearr_31860_31893[(2)] = inst_31825);

(statearr_31860_31893[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (2))){
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31839__$1,(4),in$);
} else {
if((state_val_31840 === (23))){
var inst_31833 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31861_31894 = state_31839__$1;
(statearr_31861_31894[(2)] = inst_31833);

(statearr_31861_31894[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (19))){
var inst_31820 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31862_31895 = state_31839__$1;
(statearr_31862_31895[(2)] = inst_31820);

(statearr_31862_31895[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (11))){
var inst_31791 = (state_31839[(8)]);
var inst_31805 = (state_31839[(7)]);
var inst_31805__$1 = cljs.core.seq(inst_31791);
var state_31839__$1 = (function (){var statearr_31863 = state_31839;
(statearr_31863[(7)] = inst_31805__$1);

return statearr_31863;
})();
if(inst_31805__$1){
var statearr_31864_31896 = state_31839__$1;
(statearr_31864_31896[(1)] = (14));

} else {
var statearr_31865_31897 = state_31839__$1;
(statearr_31865_31897[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (9))){
var inst_31827 = (state_31839[(2)]);
var inst_31828 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31839__$1 = (function (){var statearr_31866 = state_31839;
(statearr_31866[(15)] = inst_31827);

return statearr_31866;
})();
if(cljs.core.truth_(inst_31828)){
var statearr_31867_31898 = state_31839__$1;
(statearr_31867_31898[(1)] = (21));

} else {
var statearr_31868_31899 = state_31839__$1;
(statearr_31868_31899[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (5))){
var inst_31783 = cljs.core.async.close_BANG_(out);
var state_31839__$1 = state_31839;
var statearr_31869_31900 = state_31839__$1;
(statearr_31869_31900[(2)] = inst_31783);

(statearr_31869_31900[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (14))){
var inst_31805 = (state_31839[(7)]);
var inst_31807 = cljs.core.chunked_seq_QMARK_(inst_31805);
var state_31839__$1 = state_31839;
if(inst_31807){
var statearr_31870_31901 = state_31839__$1;
(statearr_31870_31901[(1)] = (17));

} else {
var statearr_31871_31902 = state_31839__$1;
(statearr_31871_31902[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (16))){
var inst_31823 = (state_31839[(2)]);
var state_31839__$1 = state_31839;
var statearr_31872_31903 = state_31839__$1;
(statearr_31872_31903[(2)] = inst_31823);

(statearr_31872_31903[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31840 === (10))){
var inst_31794 = (state_31839[(9)]);
var inst_31792 = (state_31839[(11)]);
var inst_31799 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31792,inst_31794);
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31839__$1,(13),out,inst_31799);
} else {
if((state_val_31840 === (18))){
var inst_31805 = (state_31839[(7)]);
var inst_31814 = cljs.core.first(inst_31805);
var state_31839__$1 = state_31839;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31839__$1,(20),out,inst_31814);
} else {
if((state_val_31840 === (8))){
var inst_31794 = (state_31839[(9)]);
var inst_31793 = (state_31839[(12)]);
var inst_31796 = (inst_31794 < inst_31793);
var inst_31797 = inst_31796;
var state_31839__$1 = state_31839;
if(cljs.core.truth_(inst_31797)){
var statearr_31873_31904 = state_31839__$1;
(statearr_31873_31904[(1)] = (10));

} else {
var statearr_31874_31905 = state_31839__$1;
(statearr_31874_31905[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto__))
;
return ((function (switch__11559__auto__,c__11624__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____0 = (function (){
var statearr_31878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31878[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__);

(statearr_31878[(1)] = (1));

return statearr_31878;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____1 = (function (state_31839){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31839);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31879){if((e31879 instanceof Object)){
var ex__11563__auto__ = e31879;
var statearr_31880_31906 = state_31839;
(statearr_31880_31906[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31839);

return cljs.core.constant$keyword$recur;
} else {
throw e31879;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31907 = state_31839;
state_31839 = G__31907;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__ = function(state_31839){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____1.call(this,state_31839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11560__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto__))
})();
var state__11626__auto__ = (function (){var statearr_31881 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto__);

return statearr_31881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto__))
);

return c__11624__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args31908 = [];
var len__8976__auto___31911 = arguments.length;
var i__8977__auto___31912 = (0);
while(true){
if((i__8977__auto___31912 < len__8976__auto___31911)){
args31908.push((arguments[i__8977__auto___31912]));

var G__31913 = (i__8977__auto___31912 + (1));
i__8977__auto___31912 = G__31913;
continue;
} else {
}
break;
}

var G__31910 = args31908.length;
switch (G__31910) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31908.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args31915 = [];
var len__8976__auto___31918 = arguments.length;
var i__8977__auto___31919 = (0);
while(true){
if((i__8977__auto___31919 < len__8976__auto___31918)){
args31915.push((arguments[i__8977__auto___31919]));

var G__31920 = (i__8977__auto___31919 + (1));
i__8977__auto___31919 = G__31920;
continue;
} else {
}
break;
}

var G__31917 = args31915.length;
switch (G__31917) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31915.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args31922 = [];
var len__8976__auto___31973 = arguments.length;
var i__8977__auto___31974 = (0);
while(true){
if((i__8977__auto___31974 < len__8976__auto___31973)){
args31922.push((arguments[i__8977__auto___31974]));

var G__31975 = (i__8977__auto___31974 + (1));
i__8977__auto___31974 = G__31975;
continue;
} else {
}
break;
}

var G__31924 = args31922.length;
switch (G__31924) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31922.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___31977 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___31977,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___31977,out){
return (function (state_31948){
var state_val_31949 = (state_31948[(1)]);
if((state_val_31949 === (7))){
var inst_31943 = (state_31948[(2)]);
var state_31948__$1 = state_31948;
var statearr_31950_31978 = state_31948__$1;
(statearr_31950_31978[(2)] = inst_31943);

(statearr_31950_31978[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (1))){
var inst_31925 = null;
var state_31948__$1 = (function (){var statearr_31951 = state_31948;
(statearr_31951[(7)] = inst_31925);

return statearr_31951;
})();
var statearr_31952_31979 = state_31948__$1;
(statearr_31952_31979[(2)] = null);

(statearr_31952_31979[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (4))){
var inst_31928 = (state_31948[(8)]);
var inst_31928__$1 = (state_31948[(2)]);
var inst_31929 = (inst_31928__$1 == null);
var inst_31930 = cljs.core.not(inst_31929);
var state_31948__$1 = (function (){var statearr_31953 = state_31948;
(statearr_31953[(8)] = inst_31928__$1);

return statearr_31953;
})();
if(inst_31930){
var statearr_31954_31980 = state_31948__$1;
(statearr_31954_31980[(1)] = (5));

} else {
var statearr_31955_31981 = state_31948__$1;
(statearr_31955_31981[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (6))){
var state_31948__$1 = state_31948;
var statearr_31956_31982 = state_31948__$1;
(statearr_31956_31982[(2)] = null);

(statearr_31956_31982[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (3))){
var inst_31945 = (state_31948[(2)]);
var inst_31946 = cljs.core.async.close_BANG_(out);
var state_31948__$1 = (function (){var statearr_31957 = state_31948;
(statearr_31957[(9)] = inst_31945);

return statearr_31957;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31948__$1,inst_31946);
} else {
if((state_val_31949 === (2))){
var state_31948__$1 = state_31948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31948__$1,(4),ch);
} else {
if((state_val_31949 === (11))){
var inst_31928 = (state_31948[(8)]);
var inst_31937 = (state_31948[(2)]);
var inst_31925 = inst_31928;
var state_31948__$1 = (function (){var statearr_31958 = state_31948;
(statearr_31958[(10)] = inst_31937);

(statearr_31958[(7)] = inst_31925);

return statearr_31958;
})();
var statearr_31959_31983 = state_31948__$1;
(statearr_31959_31983[(2)] = null);

(statearr_31959_31983[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (9))){
var inst_31928 = (state_31948[(8)]);
var state_31948__$1 = state_31948;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31948__$1,(11),out,inst_31928);
} else {
if((state_val_31949 === (5))){
var inst_31928 = (state_31948[(8)]);
var inst_31925 = (state_31948[(7)]);
var inst_31932 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31928,inst_31925);
var state_31948__$1 = state_31948;
if(inst_31932){
var statearr_31961_31984 = state_31948__$1;
(statearr_31961_31984[(1)] = (8));

} else {
var statearr_31962_31985 = state_31948__$1;
(statearr_31962_31985[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (10))){
var inst_31940 = (state_31948[(2)]);
var state_31948__$1 = state_31948;
var statearr_31963_31986 = state_31948__$1;
(statearr_31963_31986[(2)] = inst_31940);

(statearr_31963_31986[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31949 === (8))){
var inst_31925 = (state_31948[(7)]);
var tmp31960 = inst_31925;
var inst_31925__$1 = tmp31960;
var state_31948__$1 = (function (){var statearr_31964 = state_31948;
(statearr_31964[(7)] = inst_31925__$1);

return statearr_31964;
})();
var statearr_31965_31987 = state_31948__$1;
(statearr_31965_31987[(2)] = null);

(statearr_31965_31987[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___31977,out))
;
return ((function (switch__11559__auto__,c__11624__auto___31977,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_31969 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31969[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_31969[(1)] = (1));

return statearr_31969;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_31948){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_31948);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e31970){if((e31970 instanceof Object)){
var ex__11563__auto__ = e31970;
var statearr_31971_31988 = state_31948;
(statearr_31971_31988[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31948);

return cljs.core.constant$keyword$recur;
} else {
throw e31970;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__31989 = state_31948;
state_31948 = G__31989;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_31948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_31948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___31977,out))
})();
var state__11626__auto__ = (function (){var statearr_31972 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_31972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___31977);

return statearr_31972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___31977,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args31990 = [];
var len__8976__auto___32060 = arguments.length;
var i__8977__auto___32061 = (0);
while(true){
if((i__8977__auto___32061 < len__8976__auto___32060)){
args31990.push((arguments[i__8977__auto___32061]));

var G__32062 = (i__8977__auto___32061 + (1));
i__8977__auto___32061 = G__32062;
continue;
} else {
}
break;
}

var G__31992 = args31990.length;
switch (G__31992) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31990.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___32064 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___32064,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___32064,out){
return (function (state_32030){
var state_val_32031 = (state_32030[(1)]);
if((state_val_32031 === (7))){
var inst_32026 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32032_32065 = state_32030__$1;
(statearr_32032_32065[(2)] = inst_32026);

(statearr_32032_32065[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (1))){
var inst_31993 = (new Array(n));
var inst_31994 = inst_31993;
var inst_31995 = (0);
var state_32030__$1 = (function (){var statearr_32033 = state_32030;
(statearr_32033[(7)] = inst_31995);

(statearr_32033[(8)] = inst_31994);

return statearr_32033;
})();
var statearr_32034_32066 = state_32030__$1;
(statearr_32034_32066[(2)] = null);

(statearr_32034_32066[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (4))){
var inst_31998 = (state_32030[(9)]);
var inst_31998__$1 = (state_32030[(2)]);
var inst_31999 = (inst_31998__$1 == null);
var inst_32000 = cljs.core.not(inst_31999);
var state_32030__$1 = (function (){var statearr_32035 = state_32030;
(statearr_32035[(9)] = inst_31998__$1);

return statearr_32035;
})();
if(inst_32000){
var statearr_32036_32067 = state_32030__$1;
(statearr_32036_32067[(1)] = (5));

} else {
var statearr_32037_32068 = state_32030__$1;
(statearr_32037_32068[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (15))){
var inst_32020 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32038_32069 = state_32030__$1;
(statearr_32038_32069[(2)] = inst_32020);

(statearr_32038_32069[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (13))){
var state_32030__$1 = state_32030;
var statearr_32039_32070 = state_32030__$1;
(statearr_32039_32070[(2)] = null);

(statearr_32039_32070[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (6))){
var inst_31995 = (state_32030[(7)]);
var inst_32016 = (inst_31995 > (0));
var state_32030__$1 = state_32030;
if(cljs.core.truth_(inst_32016)){
var statearr_32040_32071 = state_32030__$1;
(statearr_32040_32071[(1)] = (12));

} else {
var statearr_32041_32072 = state_32030__$1;
(statearr_32041_32072[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (3))){
var inst_32028 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32030__$1,inst_32028);
} else {
if((state_val_32031 === (12))){
var inst_31994 = (state_32030[(8)]);
var inst_32018 = cljs.core.vec(inst_31994);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32030__$1,(15),out,inst_32018);
} else {
if((state_val_32031 === (2))){
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32030__$1,(4),ch);
} else {
if((state_val_32031 === (11))){
var inst_32010 = (state_32030[(2)]);
var inst_32011 = (new Array(n));
var inst_31994 = inst_32011;
var inst_31995 = (0);
var state_32030__$1 = (function (){var statearr_32042 = state_32030;
(statearr_32042[(7)] = inst_31995);

(statearr_32042[(10)] = inst_32010);

(statearr_32042[(8)] = inst_31994);

return statearr_32042;
})();
var statearr_32043_32073 = state_32030__$1;
(statearr_32043_32073[(2)] = null);

(statearr_32043_32073[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (9))){
var inst_31994 = (state_32030[(8)]);
var inst_32008 = cljs.core.vec(inst_31994);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32030__$1,(11),out,inst_32008);
} else {
if((state_val_32031 === (5))){
var inst_32003 = (state_32030[(11)]);
var inst_31995 = (state_32030[(7)]);
var inst_31998 = (state_32030[(9)]);
var inst_31994 = (state_32030[(8)]);
var inst_32002 = (inst_31994[inst_31995] = inst_31998);
var inst_32003__$1 = (inst_31995 + (1));
var inst_32004 = (inst_32003__$1 < n);
var state_32030__$1 = (function (){var statearr_32044 = state_32030;
(statearr_32044[(11)] = inst_32003__$1);

(statearr_32044[(12)] = inst_32002);

return statearr_32044;
})();
if(cljs.core.truth_(inst_32004)){
var statearr_32045_32074 = state_32030__$1;
(statearr_32045_32074[(1)] = (8));

} else {
var statearr_32046_32075 = state_32030__$1;
(statearr_32046_32075[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (14))){
var inst_32023 = (state_32030[(2)]);
var inst_32024 = cljs.core.async.close_BANG_(out);
var state_32030__$1 = (function (){var statearr_32048 = state_32030;
(statearr_32048[(13)] = inst_32023);

return statearr_32048;
})();
var statearr_32049_32076 = state_32030__$1;
(statearr_32049_32076[(2)] = inst_32024);

(statearr_32049_32076[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (10))){
var inst_32014 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32050_32077 = state_32030__$1;
(statearr_32050_32077[(2)] = inst_32014);

(statearr_32050_32077[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32031 === (8))){
var inst_32003 = (state_32030[(11)]);
var inst_31994 = (state_32030[(8)]);
var tmp32047 = inst_31994;
var inst_31994__$1 = tmp32047;
var inst_31995 = inst_32003;
var state_32030__$1 = (function (){var statearr_32051 = state_32030;
(statearr_32051[(7)] = inst_31995);

(statearr_32051[(8)] = inst_31994__$1);

return statearr_32051;
})();
var statearr_32052_32078 = state_32030__$1;
(statearr_32052_32078[(2)] = null);

(statearr_32052_32078[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___32064,out))
;
return ((function (switch__11559__auto__,c__11624__auto___32064,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_32056 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32056[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_32056[(1)] = (1));

return statearr_32056;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_32030){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_32030);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e32057){if((e32057 instanceof Object)){
var ex__11563__auto__ = e32057;
var statearr_32058_32079 = state_32030;
(statearr_32058_32079[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32030);

return cljs.core.constant$keyword$recur;
} else {
throw e32057;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__32080 = state_32030;
state_32030 = G__32080;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_32030){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_32030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___32064,out))
})();
var state__11626__auto__ = (function (){var statearr_32059 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_32059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___32064);

return statearr_32059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___32064,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args32081 = [];
var len__8976__auto___32155 = arguments.length;
var i__8977__auto___32156 = (0);
while(true){
if((i__8977__auto___32156 < len__8976__auto___32155)){
args32081.push((arguments[i__8977__auto___32156]));

var G__32157 = (i__8977__auto___32156 + (1));
i__8977__auto___32156 = G__32157;
continue;
} else {
}
break;
}

var G__32083 = args32081.length;
switch (G__32083) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32081.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11624__auto___32159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___32159,out){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___32159,out){
return (function (state_32125){
var state_val_32126 = (state_32125[(1)]);
if((state_val_32126 === (7))){
var inst_32121 = (state_32125[(2)]);
var state_32125__$1 = state_32125;
var statearr_32127_32160 = state_32125__$1;
(statearr_32127_32160[(2)] = inst_32121);

(statearr_32127_32160[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (1))){
var inst_32084 = [];
var inst_32085 = inst_32084;
var inst_32086 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_32125__$1 = (function (){var statearr_32128 = state_32125;
(statearr_32128[(7)] = inst_32086);

(statearr_32128[(8)] = inst_32085);

return statearr_32128;
})();
var statearr_32129_32161 = state_32125__$1;
(statearr_32129_32161[(2)] = null);

(statearr_32129_32161[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (4))){
var inst_32089 = (state_32125[(9)]);
var inst_32089__$1 = (state_32125[(2)]);
var inst_32090 = (inst_32089__$1 == null);
var inst_32091 = cljs.core.not(inst_32090);
var state_32125__$1 = (function (){var statearr_32130 = state_32125;
(statearr_32130[(9)] = inst_32089__$1);

return statearr_32130;
})();
if(inst_32091){
var statearr_32131_32162 = state_32125__$1;
(statearr_32131_32162[(1)] = (5));

} else {
var statearr_32132_32163 = state_32125__$1;
(statearr_32132_32163[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (15))){
var inst_32115 = (state_32125[(2)]);
var state_32125__$1 = state_32125;
var statearr_32133_32164 = state_32125__$1;
(statearr_32133_32164[(2)] = inst_32115);

(statearr_32133_32164[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (13))){
var state_32125__$1 = state_32125;
var statearr_32134_32165 = state_32125__$1;
(statearr_32134_32165[(2)] = null);

(statearr_32134_32165[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (6))){
var inst_32085 = (state_32125[(8)]);
var inst_32110 = inst_32085.length;
var inst_32111 = (inst_32110 > (0));
var state_32125__$1 = state_32125;
if(cljs.core.truth_(inst_32111)){
var statearr_32135_32166 = state_32125__$1;
(statearr_32135_32166[(1)] = (12));

} else {
var statearr_32136_32167 = state_32125__$1;
(statearr_32136_32167[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (3))){
var inst_32123 = (state_32125[(2)]);
var state_32125__$1 = state_32125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32125__$1,inst_32123);
} else {
if((state_val_32126 === (12))){
var inst_32085 = (state_32125[(8)]);
var inst_32113 = cljs.core.vec(inst_32085);
var state_32125__$1 = state_32125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32125__$1,(15),out,inst_32113);
} else {
if((state_val_32126 === (2))){
var state_32125__$1 = state_32125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32125__$1,(4),ch);
} else {
if((state_val_32126 === (11))){
var inst_32089 = (state_32125[(9)]);
var inst_32093 = (state_32125[(10)]);
var inst_32103 = (state_32125[(2)]);
var inst_32104 = [];
var inst_32105 = inst_32104.push(inst_32089);
var inst_32085 = inst_32104;
var inst_32086 = inst_32093;
var state_32125__$1 = (function (){var statearr_32137 = state_32125;
(statearr_32137[(11)] = inst_32105);

(statearr_32137[(7)] = inst_32086);

(statearr_32137[(12)] = inst_32103);

(statearr_32137[(8)] = inst_32085);

return statearr_32137;
})();
var statearr_32138_32168 = state_32125__$1;
(statearr_32138_32168[(2)] = null);

(statearr_32138_32168[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (9))){
var inst_32085 = (state_32125[(8)]);
var inst_32101 = cljs.core.vec(inst_32085);
var state_32125__$1 = state_32125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32125__$1,(11),out,inst_32101);
} else {
if((state_val_32126 === (5))){
var inst_32086 = (state_32125[(7)]);
var inst_32089 = (state_32125[(9)]);
var inst_32093 = (state_32125[(10)]);
var inst_32093__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32089) : f.call(null,inst_32089));
var inst_32094 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32093__$1,inst_32086);
var inst_32095 = cljs.core.keyword_identical_QMARK_(inst_32086,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_32096 = (inst_32094) || (inst_32095);
var state_32125__$1 = (function (){var statearr_32139 = state_32125;
(statearr_32139[(10)] = inst_32093__$1);

return statearr_32139;
})();
if(cljs.core.truth_(inst_32096)){
var statearr_32140_32169 = state_32125__$1;
(statearr_32140_32169[(1)] = (8));

} else {
var statearr_32141_32170 = state_32125__$1;
(statearr_32141_32170[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (14))){
var inst_32118 = (state_32125[(2)]);
var inst_32119 = cljs.core.async.close_BANG_(out);
var state_32125__$1 = (function (){var statearr_32143 = state_32125;
(statearr_32143[(13)] = inst_32118);

return statearr_32143;
})();
var statearr_32144_32171 = state_32125__$1;
(statearr_32144_32171[(2)] = inst_32119);

(statearr_32144_32171[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (10))){
var inst_32108 = (state_32125[(2)]);
var state_32125__$1 = state_32125;
var statearr_32145_32172 = state_32125__$1;
(statearr_32145_32172[(2)] = inst_32108);

(statearr_32145_32172[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32126 === (8))){
var inst_32089 = (state_32125[(9)]);
var inst_32093 = (state_32125[(10)]);
var inst_32085 = (state_32125[(8)]);
var inst_32098 = inst_32085.push(inst_32089);
var tmp32142 = inst_32085;
var inst_32085__$1 = tmp32142;
var inst_32086 = inst_32093;
var state_32125__$1 = (function (){var statearr_32146 = state_32125;
(statearr_32146[(14)] = inst_32098);

(statearr_32146[(7)] = inst_32086);

(statearr_32146[(8)] = inst_32085__$1);

return statearr_32146;
})();
var statearr_32147_32173 = state_32125__$1;
(statearr_32147_32173[(2)] = null);

(statearr_32147_32173[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11624__auto___32159,out))
;
return ((function (switch__11559__auto__,c__11624__auto___32159,out){
return (function() {
var cljs$core$async$state_machine__11560__auto__ = null;
var cljs$core$async$state_machine__11560__auto____0 = (function (){
var statearr_32151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32151[(0)] = cljs$core$async$state_machine__11560__auto__);

(statearr_32151[(1)] = (1));

return statearr_32151;
});
var cljs$core$async$state_machine__11560__auto____1 = (function (state_32125){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_32125);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e32152){if((e32152 instanceof Object)){
var ex__11563__auto__ = e32152;
var statearr_32153_32174 = state_32125;
(statearr_32153_32174[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32125);

return cljs.core.constant$keyword$recur;
} else {
throw e32152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__32175 = state_32125;
state_32125 = G__32175;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs$core$async$state_machine__11560__auto__ = function(state_32125){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11560__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11560__auto____1.call(this,state_32125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11560__auto____0;
cljs$core$async$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11560__auto____1;
return cljs$core$async$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___32159,out))
})();
var state__11626__auto__ = (function (){var statearr_32154 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_32154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___32159);

return statearr_32154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___32159,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
