// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.utils.url');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = (function (){var G__25290 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$temp_DASH_token,null,cljs.core.constant$keyword$token,null,cljs.core.constant$keyword$username,null,cljs.core.constant$keyword$password,null], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25290) : cljs.core.atom.call(null,G__25290));
})();
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__25291 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$client,"zebra.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$j2x,"j2x.ona.io",cljs.core.constant$keyword$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25291) : cljs.core.atom.call(null,G__25291));
})();
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var args__8983__auto__ = [];
var len__8976__auto___25293 = arguments.length;
var i__8977__auto___25294 = (0);
while(true){
if((i__8977__auto___25294 < len__8976__auto___25293)){
args__8983__auto__.push((arguments[i__8977__auto___25294]));

var G__25295 = (i__8977__auto___25294 + (1));
i__8977__auto___25294 = G__25295;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((0) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8984__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq25292){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25292));
});
/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(){
var args__8983__auto__ = [];
var len__8976__auto___25297 = arguments.length;
var i__8977__auto___25298 = (0);
while(true){
if((i__8977__auto___25298 < len__8976__auto___25297)){
args__8983__auto__.push((arguments[i__8977__auto___25298]));

var G__25299 = (i__8977__auto___25298 + (1));
i__8977__auto___25298 = G__25299;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((0) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8984__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq25296){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25296));
});
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(){
var args__8983__auto__ = [];
var len__8976__auto___25301 = arguments.length;
var i__8977__auto___25302 = (0);
while(true){
if((i__8977__auto___25302 < len__8976__auto___25301)){
args__8983__auto__.push((arguments[i__8977__auto___25302]));

var G__25303 = (i__8977__auto___25302 + (1));
i__8977__auto___25302 = G__25303;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((0) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8984__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq25300){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25300));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var args__8983__auto__ = [];
var len__8976__auto___25305 = arguments.length;
var i__8977__auto___25306 = (0);
while(true){
if((i__8977__auto___25306 < len__8976__auto___25305)){
args__8983__auto__.push((arguments[i__8977__auto___25306]));

var G__25307 = (i__8977__auto___25306 + (1));
i__8977__auto___25306 = G__25307;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((0) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__8984__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq25304){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25304));
});
