// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.io.retry_count = (3);
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__7924__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__7924__auto__)){
return stateful_method_QMARK_;
} else {
return and__7924__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__7924__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__7924__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__7924__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__28065 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28065) : cljs_hash.md5.md5.call(null,G__28065));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__8982__auto__ = [];
var len__8975__auto___28070 = arguments.length;
var i__8976__auto___28071 = (0);
while(true){
if((i__8976__auto___28071 < len__8975__auto___28070)){
args__8982__auto__.push((arguments[i__8976__auto___28071]));

var G__28072 = (i__8976__auto___28071 + (1));
i__8976__auto___28071 = G__28072;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28067){
var map__28068 = p__28067;
var map__28068__$1 = ((((!((map__28068 == null)))?((((map__28068.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28068.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28068):map__28068);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28068__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28068__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28068__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_) : cljs.core.deref.call(null,milia.utils.remote._STAR_credentials_STAR_)));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__7924__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__7924__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__7924__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__7924__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__7924__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__7924__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__7936__auto__ = accept_header;
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28066){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28066));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 * a core.async channel where result message will be put
 * and (optionally) an id to include in the result message. Returns the
 * XhrIo object that can be used to abort request. More XhrIo API
 * docs at:
 * https://closure-library.googlecode.com/git-history/docs/class_goog_net_XhrIo.html
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(){
var args__8982__auto__ = [];
var len__8975__auto___28088 = arguments.length;
var i__8976__auto___28089 = (0);
while(true){
if((i__8976__auto___28089 < len__8975__auto___28088)){
args__8982__auto__.push((arguments[i__8976__auto___28089]));

var G__28090 = (i__8976__auto___28089 + (1));
i__8976__auto___28089 = G__28090;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((2) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((2)),(0))):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8983__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__28077){
var vec__28078 = p__28077;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28078,(0),null);
var io_obj = (new goog.net.XhrIo());
var data_out = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$io_DASH_obj,io_obj], null),(cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,id], null):null)], 0));
var url = form.action;
var G__28079_28091 = io_obj;
var G__28080_28092 = goog.net.EventType.SUCCESS;
var G__28081_28093 = ((function (G__28079_28091,G__28080_28092,io_obj,data_out,url,vec__28078,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data_out,cljs.core.constant$keyword$success_QMARK_,true));
});})(G__28079_28091,G__28080_28092,io_obj,data_out,url,vec__28078,id))
;
goog.events.listen(G__28079_28091,G__28080_28092,G__28081_28093);

var G__28082_28094 = io_obj;
var G__28083_28095 = goog.net.EventType.ERROR;
var G__28084_28096 = ((function (G__28082_28094,G__28083_28095,io_obj,data_out,url,vec__28078,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data_out,cljs.core.constant$keyword$success_QMARK_,false));
});})(G__28082_28094,G__28083_28095,io_obj,data_out,url,vec__28078,id))
;
goog.events.listen(G__28082_28094,G__28083_28095,G__28084_28096);

var G__28085_28097 = io_obj;
var G__28086_28098 = goog.net.EventType.PROGRESS;
var G__28087_28099 = ((function (G__28085_28097,G__28086_28098,io_obj,data_out,url,vec__28078,id){
return (function (p1__28073_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data_out,cljs.core.constant$keyword$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$length_DASH_computable,p1__28073_SHARP_.lengthComputable,cljs.core.constant$keyword$loaded,p1__28073_SHARP_.loaded,cljs.core.constant$keyword$total,p1__28073_SHARP_.total], null)));
});})(G__28085_28097,G__28086_28098,io_obj,data_out,url,vec__28078,id))
;
goog.events.listen(G__28085_28097,G__28086_28098,G__28087_28099);

io_obj.send(url,"POST",form);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq28074){
var G__28075 = cljs.core.first(seq28074);
var seq28074__$1 = cljs.core.next(seq28074);
var G__28076 = cljs.core.first(seq28074__$1);
var seq28074__$2 = cljs.core.next(seq28074__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__28075,G__28076,seq28074__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__8982__auto__ = [];
var len__8975__auto___28162 = arguments.length;
var i__8976__auto___28163 = (0);
while(true){
if((i__8976__auto___28163 < len__8975__auto___28162)){
args__8982__auto__.push((arguments[i__8976__auto___28163]));

var G__28164 = (i__8976__auto___28163 + (1));
i__8976__auto___28163 = G__28164;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11625__auto___28165 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___28165,response_channel){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___28165,response_channel){
return (function (state_28135){
var state_val_28136 = (state_28135[(1)]);
if((state_val_28136 === (7))){
var state_28135__$1 = state_28135;
var statearr_28137_28166 = state_28135__$1;
(statearr_28137_28166[(2)] = false);

(statearr_28137_28166[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (1))){
var inst_28103 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28135__$1 = state_28135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28135__$1,(2),inst_28103);
} else {
if((state_val_28136 === (4))){
var state_28135__$1 = state_28135;
var statearr_28138_28167 = state_28135__$1;
(statearr_28138_28167[(2)] = false);

(statearr_28138_28167[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (13))){
var inst_28125 = (state_28135[(7)]);
var inst_28131 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28125);
var state_28135__$1 = state_28135;
var statearr_28139_28168 = state_28135__$1;
(statearr_28139_28168[(2)] = inst_28131);

(statearr_28139_28168[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (6))){
var state_28135__$1 = state_28135;
var statearr_28140_28169 = state_28135__$1;
(statearr_28140_28169[(2)] = true);

(statearr_28140_28169[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (3))){
var inst_28105 = (state_28135[(8)]);
var inst_28110 = inst_28105.cljs$lang$protocol_mask$partition0$;
var inst_28111 = (inst_28110 & (64));
var inst_28112 = inst_28105.cljs$core$ISeq$;
var inst_28113 = (inst_28111) || (inst_28112);
var state_28135__$1 = state_28135;
if(cljs.core.truth_(inst_28113)){
var statearr_28141_28170 = state_28135__$1;
(statearr_28141_28170[(1)] = (6));

} else {
var statearr_28142_28171 = state_28135__$1;
(statearr_28142_28171[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (12))){
var inst_28129 = window.location = window.location;
var state_28135__$1 = state_28135;
var statearr_28143_28172 = state_28135__$1;
(statearr_28143_28172[(2)] = inst_28129);

(statearr_28143_28172[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (2))){
var inst_28105 = (state_28135[(8)]);
var inst_28105__$1 = (state_28135[(2)]);
var inst_28107 = (inst_28105__$1 == null);
var inst_28108 = cljs.core.not(inst_28107);
var state_28135__$1 = (function (){var statearr_28144 = state_28135;
(statearr_28144[(8)] = inst_28105__$1);

return statearr_28144;
})();
if(inst_28108){
var statearr_28145_28173 = state_28135__$1;
(statearr_28145_28173[(1)] = (3));

} else {
var statearr_28146_28174 = state_28135__$1;
(statearr_28146_28174[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (11))){
var inst_28125 = (state_28135[(7)]);
var inst_28125__$1 = (state_28135[(2)]);
var inst_28126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28125__$1,cljs.core.constant$keyword$status);
var inst_28127 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28126,(401));
var state_28135__$1 = (function (){var statearr_28147 = state_28135;
(statearr_28147[(7)] = inst_28125__$1);

return statearr_28147;
})();
if(inst_28127){
var statearr_28148_28175 = state_28135__$1;
(statearr_28148_28175[(1)] = (12));

} else {
var statearr_28149_28176 = state_28135__$1;
(statearr_28149_28176[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (9))){
var inst_28105 = (state_28135[(8)]);
var inst_28122 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28105);
var state_28135__$1 = state_28135;
var statearr_28150_28177 = state_28135__$1;
(statearr_28150_28177[(2)] = inst_28122);

(statearr_28150_28177[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (5))){
var inst_28120 = (state_28135[(2)]);
var state_28135__$1 = state_28135;
if(cljs.core.truth_(inst_28120)){
var statearr_28151_28178 = state_28135__$1;
(statearr_28151_28178[(1)] = (9));

} else {
var statearr_28152_28179 = state_28135__$1;
(statearr_28152_28179[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (14))){
var inst_28133 = (state_28135[(2)]);
var state_28135__$1 = state_28135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28135__$1,inst_28133);
} else {
if((state_val_28136 === (10))){
var inst_28105 = (state_28135[(8)]);
var state_28135__$1 = state_28135;
var statearr_28153_28180 = state_28135__$1;
(statearr_28153_28180[(2)] = inst_28105);

(statearr_28153_28180[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28136 === (8))){
var inst_28117 = (state_28135[(2)]);
var state_28135__$1 = state_28135;
var statearr_28154_28181 = state_28135__$1;
(statearr_28154_28181[(2)] = inst_28117);

(statearr_28154_28181[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___28165,response_channel))
;
return ((function (switch__11560__auto__,c__11625__auto___28165,response_channel){
return (function() {
var milia$api$io$state_machine__11561__auto__ = null;
var milia$api$io$state_machine__11561__auto____0 = (function (){
var statearr_28158 = [null,null,null,null,null,null,null,null,null];
(statearr_28158[(0)] = milia$api$io$state_machine__11561__auto__);

(statearr_28158[(1)] = (1));

return statearr_28158;
});
var milia$api$io$state_machine__11561__auto____1 = (function (state_28135){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28135);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28159){if((e28159 instanceof Object)){
var ex__11564__auto__ = e28159;
var statearr_28160_28182 = state_28135;
(statearr_28160_28182[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28135);

return cljs.core.constant$keyword$recur;
} else {
throw e28159;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28183 = state_28135;
state_28135 = G__28183;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$io$state_machine__11561__auto__ = function(state_28135){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11561__auto____1.call(this,state_28135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11561__auto____0;
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11561__auto____1;
return milia$api$io$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___28165,response_channel))
})();
var state__11627__auto__ = (function (){var statearr_28161 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28161[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___28165);

return statearr_28161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___28165,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq28100){
var G__28101 = cljs.core.first(seq28100);
var seq28100__$1 = cljs.core.next(seq28100);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__28101,seq28100__$1);
});
/**
 * Checks if the response is 200 before returning.
 * Non-200 responses result in the get request being retried 3 times.
 */
milia.api.io.get_or_retry = (function milia$api$io$get_or_retry(){
var args28184 = [];
var len__8975__auto___28189 = arguments.length;
var i__8976__auto___28190 = (0);
while(true){
if((i__8976__auto___28190 < len__8975__auto___28189)){
args28184.push((arguments[i__8976__auto___28190]));

var G__28191 = (i__8976__auto___28190 + (1));
i__8976__auto___28190 = G__28191;
continue;
} else {
}
break;
}

var G__28186 = args28184.length;
switch (G__28186) {
case 1:
return milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28184.length)].join('')));

}
});

milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$1 = (function (request){
return milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$2(request,milia.api.io.retry_count);
});

milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$2 = (function (request,times){
var map__28187 = request;
var map__28187__$1 = ((((!((map__28187 == null)))?((((map__28187.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28187.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28187):map__28187);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28187__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28187__$1,cljs.core.constant$keyword$body);
var failed_QMARK_ = (status >= (400));
var can_retry_QMARK_ = (times > (0));
if((failed_QMARK_) && (can_retry_QMARK_)){
return milia.api.io.get_or_retry.cljs$core$IFn$_invoke$arity$2(request,(times - (1)));
} else {
if(failed_QMARK_){
return null;
} else {
return body;
}
}
});

milia.api.io.get_or_retry.cljs$lang$maxFixedArity = 2;
