// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.seq');
goog.require('milia.utils.remote');
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("forms?owner="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",username], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(){
var args__8983__auto__ = [];
var len__8976__auto___28580 = arguments.length;
var i__8977__auto___28581 = (0);
while(true){
if((i__8977__auto___28581 < len__8976__auto___28580)){
args__8983__auto__.push((arguments[i__8977__auto___28581]));

var G__28582 = (i__8977__auto___28581 + (1));
i__8977__auto___28581 = G__28582;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((2) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((2)),(0))):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8984__auto__);
});

milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__28577){
var map__28578 = p__28577;
var map__28578__$1 = ((((!((map__28578 == null)))?((((map__28578.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28578.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28578):map__28578);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28578__$1,cljs.core.constant$keyword$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"clone"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$form_DASH_params,cljs.core.constant$keyword$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,data,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataset.clone.cljs$lang$maxFixedArity = (2);

milia.api.dataset.clone.cljs$lang$applyTo = (function (seq28574){
var G__28575 = cljs.core.first(seq28574);
var seq28574__$1 = cljs.core.next(seq28574);
var G__28576 = cljs.core.first(seq28574__$1);
var seq28574__$2 = cljs.core.next(seq28574__$1);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic(G__28575,G__28576,seq28574__$2);
});
/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(cljs.core.truth_(milia.utils.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null))], 0)))].join('')));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(){
var args__8983__auto__ = [];
var len__8976__auto___28588 = arguments.length;
var i__8977__auto___28589 = (0);
while(true){
if((i__8977__auto___28589 < len__8976__auto___28588)){
args__8983__auto__.push((arguments[i__8977__auto___28589]));

var G__28590 = (i__8977__auto___28589 + (1));
i__8977__auto___28589 = G__28590;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28585){
var map__28586 = p__28585;
var map__28586__$1 = ((((!((map__28586 == null)))?((((map__28586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28586):map__28586);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28586__$1,cljs.core.constant$keyword$format,"json");
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28586__$1,cljs.core.constant$keyword$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28586__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_], 0));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (1);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq28583){
var G__28584 = cljs.core.first(seq28583);
var seq28583__$1 = cljs.core.next(seq28583);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__28584,seq28583__$1);
});
/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,record_id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(){
var args28591 = [];
var len__8976__auto___28594 = arguments.length;
var i__8977__auto___28595 = (0);
while(true){
if((i__8977__auto___28595 < len__8976__auto___28594)){
args28591.push((arguments[i__8977__auto___28595]));

var G__28596 = (i__8977__auto___28595 + (1));
i__8977__auto___28595 = G__28596;
continue;
} else {
}
break;
}

var G__28593 = args28591.length;
switch (G__28593) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28591.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$filename,filename], 0));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 2;
/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"enketo"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,[cljs.core.str("enketo?return_url="),cljs.core.str(return_url)].join('')], 0));
return cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.constant$keyword$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"delete_async"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"forms"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$formid,dataset_id], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null)], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$xform,dataset_id,cljs.core.constant$keyword$data_type,"external_export",cljs.core.constant$keyword$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(){
var args28598 = [];
var len__8976__auto___28601 = arguments.length;
var i__8977__auto___28602 = (0);
while(true){
if((i__8977__auto___28602 < len__8976__auto___28601)){
args28598.push((arguments[i__8977__auto___28602]));

var G__28603 = (i__8977__auto___28602 + (1));
i__8977__auto___28602 = G__28603;
continue;
} else {
}
break;
}

var G__28600 = args28598.length;
switch (G__28600) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28598.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array], null),cljs.core.constant$keyword$as_DASH_map_QMARK_,true,cljs.core.constant$keyword$filename,filename], 0));
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4;
