// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__28779 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28779) : cljs.core.atom.call(null,G__28779));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4425__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4425__auto__)){
var req = temp__4425__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.constant$keyword$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.constant$keyword$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__28792 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)));
var chunk__28797 = null;
var count__28798 = (0);
var i__28799 = (0);
while(true){
if((i__28799 < count__28798)){
var h_name = chunk__28797.cljs$core$IIndexed$_nth$arity$2(null,i__28799);
var seq__28800_28804 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28801_28805 = null;
var count__28802_28806 = (0);
var i__28803_28807 = (0);
while(true){
if((i__28803_28807 < count__28802_28806)){
var h_val_28808 = chunk__28801_28805.cljs$core$IIndexed$_nth$arity$2(null,i__28803_28807);
xhr.headers.set(h_name,h_val_28808);

var G__28809 = seq__28800_28804;
var G__28810 = chunk__28801_28805;
var G__28811 = count__28802_28806;
var G__28812 = (i__28803_28807 + (1));
seq__28800_28804 = G__28809;
chunk__28801_28805 = G__28810;
count__28802_28806 = G__28811;
i__28803_28807 = G__28812;
continue;
} else {
var temp__4425__auto___28813 = cljs.core.seq(seq__28800_28804);
if(temp__4425__auto___28813){
var seq__28800_28814__$1 = temp__4425__auto___28813;
if(cljs.core.chunked_seq_QMARK_(seq__28800_28814__$1)){
var c__8826__auto___28815 = cljs.core.chunk_first(seq__28800_28814__$1);
var G__28816 = cljs.core.chunk_rest(seq__28800_28814__$1);
var G__28817 = c__8826__auto___28815;
var G__28818 = cljs.core.count(c__8826__auto___28815);
var G__28819 = (0);
seq__28800_28804 = G__28816;
chunk__28801_28805 = G__28817;
count__28802_28806 = G__28818;
i__28803_28807 = G__28819;
continue;
} else {
var h_val_28820 = cljs.core.first(seq__28800_28814__$1);
xhr.headers.set(h_name,h_val_28820);

var G__28821 = cljs.core.next(seq__28800_28814__$1);
var G__28822 = null;
var G__28823 = (0);
var G__28824 = (0);
seq__28800_28804 = G__28821;
chunk__28801_28805 = G__28822;
count__28802_28806 = G__28823;
i__28803_28807 = G__28824;
continue;
}
} else {
}
}
break;
}

var G__28825 = seq__28792;
var G__28826 = chunk__28797;
var G__28827 = count__28798;
var G__28828 = (i__28799 + (1));
seq__28792 = G__28825;
chunk__28797 = G__28826;
count__28798 = G__28827;
i__28799 = G__28828;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28792);
if(temp__4425__auto__){
var seq__28792__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28792__$1)){
var c__8826__auto__ = cljs.core.chunk_first(seq__28792__$1);
var G__28829 = cljs.core.chunk_rest(seq__28792__$1);
var G__28830 = c__8826__auto__;
var G__28831 = cljs.core.count(c__8826__auto__);
var G__28832 = (0);
seq__28792 = G__28829;
chunk__28797 = G__28830;
count__28798 = G__28831;
i__28799 = G__28832;
continue;
} else {
var h_name = cljs.core.first(seq__28792__$1);
var seq__28793_28833 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28794_28834 = null;
var count__28795_28835 = (0);
var i__28796_28836 = (0);
while(true){
if((i__28796_28836 < count__28795_28835)){
var h_val_28837 = chunk__28794_28834.cljs$core$IIndexed$_nth$arity$2(null,i__28796_28836);
xhr.headers.set(h_name,h_val_28837);

var G__28838 = seq__28793_28833;
var G__28839 = chunk__28794_28834;
var G__28840 = count__28795_28835;
var G__28841 = (i__28796_28836 + (1));
seq__28793_28833 = G__28838;
chunk__28794_28834 = G__28839;
count__28795_28835 = G__28840;
i__28796_28836 = G__28841;
continue;
} else {
var temp__4425__auto___28842__$1 = cljs.core.seq(seq__28793_28833);
if(temp__4425__auto___28842__$1){
var seq__28793_28843__$1 = temp__4425__auto___28842__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28793_28843__$1)){
var c__8826__auto___28844 = cljs.core.chunk_first(seq__28793_28843__$1);
var G__28845 = cljs.core.chunk_rest(seq__28793_28843__$1);
var G__28846 = c__8826__auto___28844;
var G__28847 = cljs.core.count(c__8826__auto___28844);
var G__28848 = (0);
seq__28793_28833 = G__28845;
chunk__28794_28834 = G__28846;
count__28795_28835 = G__28847;
i__28796_28836 = G__28848;
continue;
} else {
var h_val_28849 = cljs.core.first(seq__28793_28843__$1);
xhr.headers.set(h_name,h_val_28849);

var G__28850 = cljs.core.next(seq__28793_28843__$1);
var G__28851 = null;
var G__28852 = (0);
var G__28853 = (0);
seq__28793_28833 = G__28850;
chunk__28794_28834 = G__28851;
count__28795_28835 = G__28852;
i__28796_28836 = G__28853;
continue;
}
} else {
}
}
break;
}

var G__28854 = cljs.core.next(seq__28792__$1);
var G__28855 = null;
var G__28856 = (0);
var G__28857 = (0);
seq__28792 = G__28854;
chunk__28797 = G__28855;
count__28798 = G__28856;
i__28799 = G__28857;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__28859 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$array_DASH_buffer,G__28859)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$blob,G__28859)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$document,G__28859)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$text,G__28859)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$default,G__28859)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__28859)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__28860){
var map__28864 = p__28860;
var map__28864__$1 = ((((!((map__28864 == null)))?((((map__28864.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28864.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28864):map__28864);
var request = map__28864__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.constant$keyword$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28864__$1,cljs.core.constant$keyword$response_DASH_type);
var timeout = (function (){var or__8042__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__28866 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__28866,default_headers);

cljs_http.core.apply_response_type_BANG_(G__28866,response_type);

G__28866.setTimeoutInterval(timeout);

G__28866.setWithCredentials(send_credentials);

return G__28866;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.constant$keyword$no_DASH_error,cljs.core.constant$keyword$abort,cljs.core.constant$keyword$access_DASH_denied,cljs.core.constant$keyword$custom_DASH_error,cljs.core.constant$keyword$http_DASH_error,cljs.core.constant$keyword$ff_DASH_silent_DASH_error,cljs.core.constant$keyword$file_DASH_not_DASH_found,cljs.core.constant$keyword$offline,cljs.core.constant$keyword$exception,cljs.core.constant$keyword$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__28867){
var map__28895 = p__28867;
var map__28895__$1 = ((((!((map__28895 == null)))?((((map__28895.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28895.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28895):map__28895);
var request = map__28895__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28895__$1,cljs.core.constant$keyword$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28895__$1,cljs.core.constant$keyword$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28895__$1,cljs.core.constant$keyword$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28895__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28895__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8042__auto__ = request_method;
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponse(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.constant$keyword$error_DASH_code,(function (){var G__28897 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__28897) : cljs_http.core.error_kw.call(null,G__28897));
})(),cljs.core.constant$keyword$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__11731__auto___28922 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_28908){
var state_val_28909 = (state_28908[(1)]);
if((state_val_28909 === (1))){
var state_28908__$1 = state_28908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28908__$1,(2),cancel);
} else {
if((state_val_28909 === (2))){
var inst_28899 = (state_28908[(2)]);
var inst_28900 = xhr__$1.isComplete();
var inst_28901 = cljs.core.not(inst_28900);
var state_28908__$1 = (function (){var statearr_28910 = state_28908;
(statearr_28910[(7)] = inst_28899);

return statearr_28910;
})();
if(inst_28901){
var statearr_28911_28923 = state_28908__$1;
(statearr_28911_28923[(1)] = (3));

} else {
var statearr_28912_28924 = state_28908__$1;
(statearr_28912_28924[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28909 === (3))){
var inst_28903 = xhr__$1.abort();
var state_28908__$1 = state_28908;
var statearr_28913_28925 = state_28908__$1;
(statearr_28913_28925[(2)] = inst_28903);

(statearr_28913_28925[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28909 === (4))){
var state_28908__$1 = state_28908;
var statearr_28914_28926 = state_28908__$1;
(statearr_28914_28926[(2)] = null);

(statearr_28914_28926[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28909 === (5))){
var inst_28906 = (state_28908[(2)]);
var state_28908__$1 = state_28908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28908__$1,inst_28906);
} else {
return null;
}
}
}
}
}
});})(c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__11666__auto__,c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__11667__auto__ = null;
var cljs_http$core$xhr_$_state_machine__11667__auto____0 = (function (){
var statearr_28918 = [null,null,null,null,null,null,null,null];
(statearr_28918[(0)] = cljs_http$core$xhr_$_state_machine__11667__auto__);

(statearr_28918[(1)] = (1));

return statearr_28918;
});
var cljs_http$core$xhr_$_state_machine__11667__auto____1 = (function (state_28908){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_28908);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e28919){if((e28919 instanceof Object)){
var ex__11670__auto__ = e28919;
var statearr_28920_28927 = state_28908;
(statearr_28920_28927[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28908);

return cljs.core.constant$keyword$recur;
} else {
throw e28919;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__28928 = state_28908;
state_28908 = G__28928;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__11667__auto__ = function(state_28908){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__11667__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__11667__auto____1.call(this,state_28908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__11667__auto____0;
cljs_http$core$xhr_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__11667__auto____1;
return cljs_http$core$xhr_$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__11733__auto__ = (function (){var statearr_28921 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_28921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___28922);

return statearr_28921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___28922,channel,request_url,method,headers__$1,xhr__$1,map__28895,map__28895__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__28929){
var map__28946 = p__28929;
var map__28946__$1 = ((((!((map__28946 == null)))?((((map__28946.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28946.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28946):map__28946);
var request = map__28946__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28946__$1,cljs.core.constant$keyword$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28946__$1,cljs.core.constant$keyword$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28946__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_28962 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$status,(200),cljs.core.constant$keyword$success,true,cljs.core.constant$keyword$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$jsonp,jsonp__$1,cljs.core.constant$keyword$request,req_28962], null));

if(cljs.core.truth_(cancel)){
var c__11731__auto___28963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel){
return (function (state_28952){
var state_val_28953 = (state_28952[(1)]);
if((state_val_28953 === (1))){
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28952__$1,(2),cancel);
} else {
if((state_val_28953 === (2))){
var inst_28949 = (state_28952[(2)]);
var inst_28950 = jsonp__$1.cancel(req_28962);
var state_28952__$1 = (function (){var statearr_28954 = state_28952;
(statearr_28954[(7)] = inst_28949);

return statearr_28954;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28952__$1,inst_28950);
} else {
return null;
}
}
});})(c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__11666__auto__,c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__11667__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__11667__auto____0 = (function (){
var statearr_28958 = [null,null,null,null,null,null,null,null];
(statearr_28958[(0)] = cljs_http$core$jsonp_$_state_machine__11667__auto__);

(statearr_28958[(1)] = (1));

return statearr_28958;
});
var cljs_http$core$jsonp_$_state_machine__11667__auto____1 = (function (state_28952){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_28952);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e28959){if((e28959 instanceof Object)){
var ex__11670__auto__ = e28959;
var statearr_28960_28964 = state_28952;
(statearr_28960_28964[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28952);

return cljs.core.constant$keyword$recur;
} else {
throw e28959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__28965 = state_28952;
state_28952 = G__28965;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__11667__auto__ = function(state_28952){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__11667__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__11667__auto____1.call(this,state_28952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__11667__auto____0;
cljs_http$core$jsonp_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__11667__auto____1;
return cljs_http$core$jsonp_$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel))
})();
var state__11733__auto__ = (function (){var statearr_28961 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_28961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___28963);

return statearr_28961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___28963,req_28962,channel,jsonp__$1,map__28946,map__28946__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__28966){
var map__28969 = p__28966;
var map__28969__$1 = ((((!((map__28969 == null)))?((((map__28969.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28969.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28969):map__28969);
var request__$1 = map__28969__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28969__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.constant$keyword$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
