// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__4483__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__4483__auto__)){
return stateful_method_QMARK_;
} else {
return and__4483__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__4483__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__4483__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__4483__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__16714 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__16714) : cljs_hash.md5.md5.call(null,G__16714));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__5541__auto__ = [];
var len__5534__auto___16719 = arguments.length;
var i__5535__auto___16720 = (0);
while(true){
if((i__5535__auto___16720 < len__5534__auto___16719)){
args__5541__auto__.push((arguments[i__5535__auto___16720]));

var G__16721 = (i__5535__auto___16720 + (1));
i__5535__auto___16720 = G__16721;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((0) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__5542__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__16716){
var map__16717 = p__16716;
var map__16717__$1 = ((((!((map__16717 == null)))?((((map__16717.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16717.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16717):map__16717);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16717__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16717__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16717__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_) : cljs.core.deref.call(null,milia.utils.remote._STAR_credentials_STAR_)));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__4483__auto__ = temp_token;
if(cljs.core.truth_(and__4483__auto__)){
var and__4483__auto____$1 = (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
if(cljs.core.truth_(and__4483__auto____$1)){
return cljs.core.not_empty(temp_token);
} else {
return and__4483__auto____$1;
}
} else {
return and__4483__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__4483__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4483__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__4483__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__4495__auto__ = accept_header;
if(cljs.core.truth_(or__4495__auto__)){
return or__4495__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq16715){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16715));
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__16728_16734 = io_obj;
var G__16729_16735 = goog.net.EventType.SUCCESS;
var G__16730_16736 = ((function (G__16728_16734,G__16729_16735,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__16728_16734,G__16729_16735,io_obj,url))
;
goog.events.listen(G__16728_16734,G__16729_16735,G__16730_16736);

var G__16731_16737 = io_obj;
var G__16732_16738 = goog.net.EventType.ERROR;
var G__16733_16739 = ((function (G__16731_16737,G__16732_16738,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__16731_16737,G__16732_16738,io_obj,url))
;
goog.events.listen(G__16731_16737,G__16732_16738,G__16733_16739);

return io_obj.sendFromForm(form,url);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__5541__auto__ = [];
var len__5534__auto___16802 = arguments.length;
var i__5535__auto___16803 = (0);
while(true){
if((i__5535__auto___16803 < len__5534__auto___16802)){
args__5541__auto__.push((arguments[i__5535__auto___16803]));

var G__16804 = (i__5535__auto___16803 + (1));
i__5535__auto___16803 = G__16804;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((1) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5542__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__8116__auto___16805 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__8116__auto___16805,response_channel){
return (function (){
var f__8117__auto__ = (function (){var switch__8051__auto__ = ((function (c__8116__auto___16805,response_channel){
return (function (state_16775){
var state_val_16776 = (state_16775[(1)]);
if((state_val_16776 === (7))){
var state_16775__$1 = state_16775;
var statearr_16777_16806 = state_16775__$1;
(statearr_16777_16806[(2)] = false);

(statearr_16777_16806[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (1))){
var inst_16743 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16775__$1,(2),inst_16743);
} else {
if((state_val_16776 === (4))){
var state_16775__$1 = state_16775;
var statearr_16778_16807 = state_16775__$1;
(statearr_16778_16807[(2)] = false);

(statearr_16778_16807[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (13))){
var inst_16765 = (state_16775[(7)]);
var inst_16771 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_16765);
var state_16775__$1 = state_16775;
var statearr_16779_16808 = state_16775__$1;
(statearr_16779_16808[(2)] = inst_16771);

(statearr_16779_16808[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (6))){
var state_16775__$1 = state_16775;
var statearr_16780_16809 = state_16775__$1;
(statearr_16780_16809[(2)] = true);

(statearr_16780_16809[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (3))){
var inst_16745 = (state_16775[(8)]);
var inst_16750 = inst_16745.cljs$lang$protocol_mask$partition0$;
var inst_16751 = (inst_16750 & (64));
var inst_16752 = inst_16745.cljs$core$ISeq$;
var inst_16753 = (inst_16751) || (inst_16752);
var state_16775__$1 = state_16775;
if(cljs.core.truth_(inst_16753)){
var statearr_16781_16810 = state_16775__$1;
(statearr_16781_16810[(1)] = (6));

} else {
var statearr_16782_16811 = state_16775__$1;
(statearr_16782_16811[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (12))){
var inst_16769 = window.location = window.location;
var state_16775__$1 = state_16775;
var statearr_16783_16812 = state_16775__$1;
(statearr_16783_16812[(2)] = inst_16769);

(statearr_16783_16812[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (2))){
var inst_16745 = (state_16775[(8)]);
var inst_16745__$1 = (state_16775[(2)]);
var inst_16747 = (inst_16745__$1 == null);
var inst_16748 = cljs.core.not(inst_16747);
var state_16775__$1 = (function (){var statearr_16784 = state_16775;
(statearr_16784[(8)] = inst_16745__$1);

return statearr_16784;
})();
if(inst_16748){
var statearr_16785_16813 = state_16775__$1;
(statearr_16785_16813[(1)] = (3));

} else {
var statearr_16786_16814 = state_16775__$1;
(statearr_16786_16814[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (11))){
var inst_16765 = (state_16775[(7)]);
var inst_16765__$1 = (state_16775[(2)]);
var inst_16766 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16765__$1,cljs.core.constant$keyword$status);
var inst_16767 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16766,(401));
var state_16775__$1 = (function (){var statearr_16787 = state_16775;
(statearr_16787[(7)] = inst_16765__$1);

return statearr_16787;
})();
if(inst_16767){
var statearr_16788_16815 = state_16775__$1;
(statearr_16788_16815[(1)] = (12));

} else {
var statearr_16789_16816 = state_16775__$1;
(statearr_16789_16816[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (9))){
var inst_16745 = (state_16775[(8)]);
var inst_16762 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16745);
var state_16775__$1 = state_16775;
var statearr_16790_16817 = state_16775__$1;
(statearr_16790_16817[(2)] = inst_16762);

(statearr_16790_16817[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (5))){
var inst_16760 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
if(cljs.core.truth_(inst_16760)){
var statearr_16791_16818 = state_16775__$1;
(statearr_16791_16818[(1)] = (9));

} else {
var statearr_16792_16819 = state_16775__$1;
(statearr_16792_16819[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (14))){
var inst_16773 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16775__$1,inst_16773);
} else {
if((state_val_16776 === (10))){
var inst_16745 = (state_16775[(8)]);
var state_16775__$1 = state_16775;
var statearr_16793_16820 = state_16775__$1;
(statearr_16793_16820[(2)] = inst_16745);

(statearr_16793_16820[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16776 === (8))){
var inst_16757 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16794_16821 = state_16775__$1;
(statearr_16794_16821[(2)] = inst_16757);

(statearr_16794_16821[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8116__auto___16805,response_channel))
;
return ((function (switch__8051__auto__,c__8116__auto___16805,response_channel){
return (function() {
var milia$api$io$state_machine__8052__auto__ = null;
var milia$api$io$state_machine__8052__auto____0 = (function (){
var statearr_16798 = [null,null,null,null,null,null,null,null,null];
(statearr_16798[(0)] = milia$api$io$state_machine__8052__auto__);

(statearr_16798[(1)] = (1));

return statearr_16798;
});
var milia$api$io$state_machine__8052__auto____1 = (function (state_16775){
while(true){
var ret_value__8053__auto__ = (function (){try{while(true){
var result__8054__auto__ = switch__8051__auto__(state_16775);
if(cljs.core.keyword_identical_QMARK_(result__8054__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__8054__auto__;
}
break;
}
}catch (e16799){if((e16799 instanceof Object)){
var ex__8055__auto__ = e16799;
var statearr_16800_16822 = state_16775;
(statearr_16800_16822[(5)] = ex__8055__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16775);

return cljs.core.constant$keyword$recur;
} else {
throw e16799;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8053__auto__,cljs.core.constant$keyword$recur)){
var G__16823 = state_16775;
state_16775 = G__16823;
continue;
} else {
return ret_value__8053__auto__;
}
break;
}
});
milia$api$io$state_machine__8052__auto__ = function(state_16775){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__8052__auto____0.call(this);
case 1:
return milia$api$io$state_machine__8052__auto____1.call(this,state_16775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__8052__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__8052__auto____0;
milia$api$io$state_machine__8052__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__8052__auto____1;
return milia$api$io$state_machine__8052__auto__;
})()
;})(switch__8051__auto__,c__8116__auto___16805,response_channel))
})();
var state__8118__auto__ = (function (){var statearr_16801 = (f__8117__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8117__auto__.cljs$core$IFn$_invoke$arity$0() : f__8117__auto__.call(null));
(statearr_16801[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8116__auto___16805);

return statearr_16801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8118__auto__);
});})(c__8116__auto___16805,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq16740){
var G__16741 = cljs.core.first(seq16740);
var seq16740__$1 = cljs.core.next(seq16740);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__16741,seq16740__$1);
});
