// Compiled by ClojureScript 0.0-3196 {}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.call(null,milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq10450){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10450));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join.call(null,zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq10451){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10451));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_android_cors_bugfix.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__10454){
var vec__10455 = p__10454;
var req = cljs.core.nth.call(null,vec__10455,(0),null);

return milia.api.io.raw_request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq10452){
var G__10453 = cljs.core.first.call(null,seq10452);
var seq10452__$1 = cljs.core.next.call(null,seq10452);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__10453,seq10452__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__10458){
var vec__10459 = p__10458;
var req = cljs.core.nth.call(null,vec__10459,(0),null);

return milia.api.io.raw_request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq10456){
var G__10457 = cljs.core.first.call(null,seq10456);
var seq10456__$1 = cljs.core.next.call(null,seq10456);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__10457,seq10456__$1);
});
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var G__10461 = arguments.length;
switch (G__10461) {
case 1:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return milia.api.io.token__GT_headers.call(null,token,false);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.call(null,headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__10467 = null;
var G__10467__1 = (function (url){
return milia$api$io$query_helper.call(null,method).call(null,url,null,null);
});
var G__10467__2 = (function (url,query_params){
return milia$api$io$query_helper.call(null,method).call(null,url,query_params,null);
});
var G__10467__4 = (function() { 
var G__10468__delegate = function (url,query_params,token,p__10465){
var map__10466 = p__10465;
var map__10466__$1 = ((cljs.core.seq_QMARK_.call(null,map__10466))?cljs.core.apply.call(null,cljs.core.hash_map,map__10466):map__10466);
var no_cache_QMARK_ = cljs.core.get.call(null,map__10466__$1,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981));
var http_method = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"get","get",1683182755),cljs_http.client.get,new cljs.core.Keyword(null,"raw-get","raw-get",524046152),milia.api.io.raw_get,new cljs.core.Keyword(null,"post","post",269697687),cljs_http.client.post,new cljs.core.Keyword(null,"raw-post","raw-post",-555212647),milia.api.io.raw_post,new cljs.core.Keyword(null,"delete","delete",-1768633620),cljs_http.client.delete$,new cljs.core.Keyword(null,"put","put",1299772570),cljs_http.client.put,new cljs.core.Keyword(null,"patch","patch",380775109),cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null),method))?new cljs.core.Keyword(null,"form-params","form-params",1884296467):new cljs.core.Keyword(null,"query-params","query-params",900640534));
var headers = milia.api.io.token__GT_headers.call(null,cljs.core.apply.call(null,cljs.core.str,token),cljs.core._EQ_.call(null,http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"t","t",-1397832519),cljs_hash.md5.md5.call(null,Date.now().toString())], null):null);
var query_params__$1 = cljs.core.merge.call(null,query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xhr","xhr",-177710851),true], null));
return http_method.call(null,url,new cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"headers","headers",-835030129),headers,param_key,query_params__$1], true, false));
};
var G__10468 = function (url,query_params,token,var_args){
var p__10465 = null;
if (arguments.length > 3) {
var G__10469__i = 0, G__10469__a = new Array(arguments.length -  3);
while (G__10469__i < G__10469__a.length) {G__10469__a[G__10469__i] = arguments[G__10469__i + 3]; ++G__10469__i;}
  p__10465 = new cljs.core.IndexedSeq(G__10469__a,0);
} 
return G__10468__delegate.call(this,url,query_params,token,p__10465);};
G__10468.cljs$lang$maxFixedArity = 3;
G__10468.cljs$lang$applyTo = (function (arglist__10470){
var url = cljs.core.first(arglist__10470);
arglist__10470 = cljs.core.next(arglist__10470);
var query_params = cljs.core.first(arglist__10470);
arglist__10470 = cljs.core.next(arglist__10470);
var token = cljs.core.first(arglist__10470);
var p__10465 = cljs.core.rest(arglist__10470);
return G__10468__delegate(url,query_params,token,p__10465);
});
G__10468.cljs$core$IFn$_invoke$arity$variadic = G__10468__delegate;
return G__10468;
})()
;
G__10467 = function(url,query_params,token,var_args){
var p__10465 = var_args;
switch(arguments.length){
case 1:
return G__10467__1.call(this,url);
case 2:
return G__10467__2.call(this,url,query_params);
default:
var G__10471 = null;
if (arguments.length > 3) {
var G__10472__i = 0, G__10472__a = new Array(arguments.length -  3);
while (G__10472__i < G__10472__a.length) {G__10472__a[G__10472__i] = arguments[G__10472__i + 3]; ++G__10472__i;}
G__10471 = new cljs.core.IndexedSeq(G__10472__a,0);
}
return G__10467__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__10471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10467.cljs$lang$maxFixedArity = 3;
G__10467.cljs$lang$applyTo = G__10467__4.cljs$lang$applyTo;
G__10467.cljs$core$IFn$_invoke$arity$1 = G__10467__1;
G__10467.cljs$core$IFn$_invoke$arity$2 = G__10467__2;
G__10467.cljs$core$IFn$_invoke$arity$variadic = G__10467__4.cljs$core$IFn$_invoke$arity$variadic;
return G__10467;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"raw-get","raw-get",524046152));
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"get","get",1683182755));
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620));
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"patch","patch",380775109));
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"raw-post","raw-post",-555212647));
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"post","post",269697687));
milia.api.io.put_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"put","put",1299772570));
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__10480 = arguments.length;
switch (G__10480) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.call(null,url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.call(null,method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.call(null,method,url,callback,query_params,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_10491){
var state_val_10492 = (state_10491[(1)]);
if((state_val_10492 === (5))){
var inst_10489 = (state_10491[(2)]);
var state_10491__$1 = state_10491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10491__$1,inst_10489);
} else {
if((state_val_10492 === (4))){
var state_10491__$1 = state_10491;
var statearr_10493_10506 = state_10491__$1;
(statearr_10493_10506[(2)] = null);

(statearr_10493_10506[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10492 === (3))){
var inst_10484 = (state_10491[(7)]);
var inst_10486 = callback.call(null,inst_10484);
var state_10491__$1 = state_10491;
var statearr_10494_10507 = state_10491__$1;
(statearr_10494_10507[(2)] = inst_10486);

(statearr_10494_10507[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10492 === (2))){
var inst_10484 = (state_10491[(2)]);
var state_10491__$1 = (function (){var statearr_10495 = state_10491;
(statearr_10495[(7)] = inst_10484);

return statearr_10495;
})();
if(cljs.core.truth_(callback)){
var statearr_10496_10508 = state_10491__$1;
(statearr_10496_10508[(1)] = (3));

} else {
var statearr_10497_10509 = state_10491__$1;
(statearr_10497_10509[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10492 === (1))){
var inst_10481 = milia.api.io.query_helper.call(null,method);
var inst_10482 = inst_10481.call(null,url,query_params,token,opts);
var state_10491__$1 = state_10491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10491__$1,(2),inst_10482);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_10501 = [null,null,null,null,null,null,null,null];
(statearr_10501[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_10501[(1)] = (1));

return statearr_10501;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_10491){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_10491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e10502){if((e10502 instanceof Object)){
var ex__7651__auto__ = e10502;
var statearr_10503_10510 = state_10491;
(statearr_10503_10510[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10491);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10511 = state_10491;
state_10491 = G__10511;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_10491){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_10491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_10504 = f__7710__auto__.call(null);
(statearr_10504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_10504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq10473){
var G__10474 = cljs.core.first.call(null,seq10473);
var seq10473__$1 = cljs.core.next.call(null,seq10473);
var G__10475 = cljs.core.first.call(null,seq10473__$1);
var seq10473__$2 = cljs.core.next.call(null,seq10473__$1);
var G__10476 = cljs.core.first.call(null,seq10473__$2);
var seq10473__$3 = cljs.core.next.call(null,seq10473__$2);
var G__10477 = cljs.core.first.call(null,seq10473__$3);
var seq10473__$4 = cljs.core.next.call(null,seq10473__$3);
var G__10478 = cljs.core.first.call(null,seq10473__$4);
var seq10473__$5 = cljs.core.next.call(null,seq10473__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10474,G__10475,G__10476,G__10477,G__10478,seq10473__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__10513 = arguments.length;
switch (G__10513) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.call(null,event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = dommy.core.attr.call(null,event.target,new cljs.core.Keyword(null,"href","href",-793805698));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = dommy.core.attr.call(null,event.target.form,new cljs.core.Keyword(null,"action","action",-811238024));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__10516 = arguments.length;
switch (G__10516) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.call(null,event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = dommy.core.attr.call(null,event.target,new cljs.core.Keyword(null,"href","href",-793805698));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_10641){
var state_val_10642 = (state_10641[(1)]);
if((state_val_10642 === (7))){
var inst_10606 = (state_10641[(2)]);
var state_10641__$1 = state_10641;
var statearr_10643_10678 = state_10641__$1;
(statearr_10643_10678[(2)] = inst_10606);

(statearr_10643_10678[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (20))){
var state_10641__$1 = state_10641;
var statearr_10644_10679 = state_10641__$1;
(statearr_10644_10679[(2)] = null);

(statearr_10644_10679[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (1))){
var inst_10598 = (state_10641[(7)]);
var inst_10598__$1 = (auth_token == null);
var state_10641__$1 = (function (){var statearr_10645 = state_10641;
(statearr_10645[(7)] = inst_10598__$1);

return statearr_10645;
})();
if(cljs.core.truth_(inst_10598__$1)){
var statearr_10646_10680 = state_10641__$1;
(statearr_10646_10680[(1)] = (2));

} else {
var statearr_10647_10681 = state_10641__$1;
(statearr_10647_10681[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (4))){
var inst_10608 = (state_10641[(2)]);
var state_10641__$1 = state_10641;
if(cljs.core.truth_(inst_10608)){
var statearr_10648_10682 = state_10641__$1;
(statearr_10648_10682[(1)] = (8));

} else {
var statearr_10649_10683 = state_10641__$1;
(statearr_10649_10683[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (15))){
var inst_10621 = (state_10641[(8)]);
var inst_10621__$1 = (state_10641[(2)]);
var inst_10622 = cljs.core.seq_QMARK_.call(null,inst_10621__$1);
var state_10641__$1 = (function (){var statearr_10650 = state_10641;
(statearr_10650[(8)] = inst_10621__$1);

return statearr_10650;
})();
if(inst_10622){
var statearr_10651_10684 = state_10641__$1;
(statearr_10651_10684[(1)] = (16));

} else {
var statearr_10652_10685 = state_10641__$1;
(statearr_10652_10685[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (21))){
var inst_10634 = (state_10641[(2)]);
var state_10641__$1 = state_10641;
var statearr_10653_10686 = state_10641__$1;
(statearr_10653_10686[(2)] = inst_10634);

(statearr_10653_10686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (13))){
var state_10641__$1 = state_10641;
var statearr_10654_10687 = state_10641__$1;
(statearr_10654_10687[(2)] = auth_token);

(statearr_10654_10687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (6))){
var inst_10604 = cljs.core._EQ_.call(null,"null",auth_token);
var state_10641__$1 = state_10641;
var statearr_10655_10688 = state_10641__$1;
(statearr_10655_10688[(2)] = inst_10604);

(statearr_10655_10688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (17))){
var inst_10621 = (state_10641[(8)]);
var state_10641__$1 = state_10641;
var statearr_10656_10689 = state_10641__$1;
(statearr_10656_10689[(2)] = inst_10621);

(statearr_10656_10689[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (3))){
var inst_10601 = (state_10641[(9)]);
var inst_10601__$1 = clojure.string.blank_QMARK_.call(null,auth_token);
var state_10641__$1 = (function (){var statearr_10657 = state_10641;
(statearr_10657[(9)] = inst_10601__$1);

return statearr_10657;
})();
if(cljs.core.truth_(inst_10601__$1)){
var statearr_10658_10690 = state_10641__$1;
(statearr_10658_10690[(1)] = (5));

} else {
var statearr_10659_10691 = state_10641__$1;
(statearr_10659_10691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (12))){
var inst_10618 = milia.api.io.refresh_token_url.call(null,username);
var inst_10619 = milia.api.io.get_url.call(null,inst_10618,null,null,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981),true);
var state_10641__$1 = state_10641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10641__$1,(15),inst_10619);
} else {
if((state_val_10642 === (2))){
var inst_10598 = (state_10641[(7)]);
var state_10641__$1 = state_10641;
var statearr_10660_10692 = state_10641__$1;
(statearr_10660_10692[(2)] = inst_10598);

(statearr_10660_10692[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (19))){
var inst_10628 = (state_10641[(10)]);
var state_10641__$1 = state_10641;
var statearr_10661_10693 = state_10641__$1;
(statearr_10661_10693[(2)] = inst_10628);

(statearr_10661_10693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (11))){
var inst_10614 = (state_10641[(2)]);
var inst_10615 = milia.api.io.invalid_token_QMARK_.call(null,inst_10614);
var state_10641__$1 = state_10641;
if(cljs.core.truth_(inst_10615)){
var statearr_10662_10694 = state_10641__$1;
(statearr_10662_10694[(1)] = (12));

} else {
var statearr_10663_10695 = state_10641__$1;
(statearr_10663_10695[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (9))){
var inst_10611 = milia.api.io.validate_token_url.call(null,username);
var inst_10612 = milia.api.io.get_url.call(null,inst_10611,null,null,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981),true);
var state_10641__$1 = state_10641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10641__$1,(11),inst_10612);
} else {
if((state_val_10642 === (5))){
var inst_10601 = (state_10641[(9)]);
var state_10641__$1 = state_10641;
var statearr_10664_10696 = state_10641__$1;
(statearr_10664_10696[(2)] = inst_10601);

(statearr_10664_10696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (14))){
var inst_10637 = (state_10641[(2)]);
var state_10641__$1 = state_10641;
var statearr_10665_10697 = state_10641__$1;
(statearr_10665_10697[(2)] = inst_10637);

(statearr_10665_10697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (16))){
var inst_10621 = (state_10641[(8)]);
var inst_10624 = cljs.core.apply.call(null,cljs.core.hash_map,inst_10621);
var state_10641__$1 = state_10641;
var statearr_10666_10698 = state_10641__$1;
(statearr_10666_10698[(2)] = inst_10624);

(statearr_10666_10698[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (10))){
var inst_10639 = (state_10641[(2)]);
var state_10641__$1 = state_10641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10641__$1,inst_10639);
} else {
if((state_val_10642 === (18))){
var inst_10627 = (state_10641[(2)]);
var inst_10628 = cljs.core.get.call(null,inst_10627,new cljs.core.Keyword(null,"body","body",-2049205669));
var inst_10629 = cljs.core.get.call(null,inst_10627,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_10630 = cljs.core._EQ_.call(null,inst_10629,(200));
var state_10641__$1 = (function (){var statearr_10667 = state_10641;
(statearr_10667[(10)] = inst_10628);

return statearr_10667;
})();
if(inst_10630){
var statearr_10668_10699 = state_10641__$1;
(statearr_10668_10699[(1)] = (19));

} else {
var statearr_10669_10700 = state_10641__$1;
(statearr_10669_10700[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10642 === (8))){
var state_10641__$1 = state_10641;
var statearr_10670_10701 = state_10641__$1;
(statearr_10670_10701[(2)] = null);

(statearr_10670_10701[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_10674 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10674[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_10674[(1)] = (1));

return statearr_10674;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_10641){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_10641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e10675){if((e10675 instanceof Object)){
var ex__7651__auto__ = e10675;
var statearr_10676_10702 = state_10641;
(statearr_10676_10702[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10675;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10703 = state_10641;
state_10641 = G__10703;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_10641){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_10641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_10677 = f__7710__auto__.call(null);
(statearr_10677[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_10677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
goog.events.listen(io_obj,goog.net.EventType.SUCCESS,((function (io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"success?","success?",-122854052),true,new cljs.core.Keyword(null,"io-obj","io-obj",2062337291),io_obj], null));
});})(io_obj,url))
);

goog.events.listen(io_obj,goog.net.EventType.ERROR,((function (io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"success?","success?",-122854052),false,new cljs.core.Keyword(null,"io-obj","io-obj",2062337291),io_obj], null));
});})(io_obj,url))
);

return io_obj.sendFromForm(form,url);
});
