// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__8170__auto__ = v;
if(cljs.core.truth_(and__8170__auto__)){
return (v > (0));
} else {
return and__8170__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__34989_SHARP_,p2__34988_SHARP_){
var vec__34991 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__34988_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34991,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34991,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__34989_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = (function (){var G__34993 = url;
return goog.Uri.parse(G__34993);
})();
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34994_SHARP_){
return cljs_http.client.encode_val(k,p1__34994_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__34995){
var vec__34997 = p__34995;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__34998_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__34998_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__8170__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__8170__auto__){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__8170__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__35001 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35001) : client.call(null,G__35001));
} else {
var G__35002 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35002) : client.call(null,G__35002));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__11622__auto___35041 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35041,channel){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35041,channel){
return (function (state_35030){
var state_val_35031 = (state_35030[(1)]);
if((state_val_35031 === (1))){
var inst_35022 = (function (){var G__35032 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35032) : client.call(null,G__35032));
})();
var state_35030__$1 = state_35030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35030__$1,(2),inst_35022);
} else {
if((state_val_35031 === (2))){
var inst_35024 = (state_35030[(2)]);
var inst_35025 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_35026 = cljs_http.client.decode_body(inst_35024,cljs.reader.read_string,"application/edn",inst_35025);
var inst_35027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_35026);
var inst_35028 = cljs.core.async.close_BANG_(channel);
var state_35030__$1 = (function (){var statearr_35033 = state_35030;
(statearr_35033[(7)] = inst_35027);

return statearr_35033;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35030__$1,inst_35028);
} else {
return null;
}
}
});})(c__11622__auto___35041,channel))
;
return ((function (switch__11560__auto__,c__11622__auto___35041,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____0 = (function (){
var statearr_35037 = [null,null,null,null,null,null,null,null];
(statearr_35037[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__);

(statearr_35037[(1)] = (1));

return statearr_35037;
});
var cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____1 = (function (state_35030){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35030);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35038){if((e35038 instanceof Object)){
var ex__11564__auto__ = e35038;
var statearr_35039_35042 = state_35030;
(statearr_35039_35042[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35030);

return cljs.core.constant$keyword$recur;
} else {
throw e35038;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35043 = state_35030;
state_35030 = G__35043;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__ = function(state_35030){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____1.call(this,state_35030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__11561__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35041,channel))
})();
var state__11624__auto__ = (function (){var statearr_35040 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35041);

return statearr_35040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35041,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35046){
var vec__35047 = p__35046;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35047,(0),null);
return ((function (vec__35047,accept){
return (function (request){
var temp__4423__auto__ = (function (){var or__8182__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var accept__$1 = temp__4423__auto__;
var G__35048 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35048) : client.call(null,G__35048));
} else {
var G__35049 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35049) : client.call(null,G__35049));
}
});
;})(vec__35047,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq35044){
var G__35045 = cljs.core.first(seq35044);
var seq35044__$1 = cljs.core.next(seq35044);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__35045,seq35044__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35052){
var vec__35053 = p__35052;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35053,(0),null);
return ((function (vec__35053,content_type){
return (function (request){
var temp__4423__auto__ = (function (){var or__8182__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var content_type__$1 = temp__4423__auto__;
var G__35054 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35054) : client.call(null,G__35054));
} else {
var G__35055 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35055) : client.call(null,G__35055));
}
});
;})(vec__35053,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq35050){
var G__35051 = cljs.core.first(seq35050);
var seq35050__$1 = cljs.core.next(seq35050);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__35051,seq35050__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var map__35059 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__35059__$1 = ((cljs.core.seq_QMARK_(map__35059))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35059):map__35059);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35059__$1,cljs.core.constant$keyword$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35059__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var G__35060 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35060) : client.call(null,G__35060));
} else {
var G__35061 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35061) : client.call(null,G__35061));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var map__35084 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__35084__$1 = ((cljs.core.seq_QMARK_(map__35084))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35084):map__35084);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.constant$keyword$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35084__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var c__11622__auto___35105 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts){
return (function (state_35094){
var state_val_35095 = (state_35094[(1)]);
if((state_val_35095 === (1))){
var inst_35085 = (function (){var G__35096 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35096) : client.call(null,G__35096));
})();
var state_35094__$1 = state_35094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35094__$1,(2),inst_35085);
} else {
if((state_val_35095 === (2))){
var inst_35087 = (state_35094[(2)]);
var inst_35088 = (function (){var response = inst_35087;
return ((function (response,inst_35087,state_val_35095,c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts){
return (function (p1__35062_SHARP_){
return cljs_http.util.transit_decode(p1__35062_SHARP_,decoding,decoding_opts);
});
;})(response,inst_35087,state_val_35095,c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts))
})();
var inst_35089 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_35090 = cljs_http.client.decode_body(inst_35087,inst_35088,"application/transit+json",inst_35089);
var inst_35091 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_35090);
var inst_35092 = cljs.core.async.close_BANG_(channel);
var state_35094__$1 = (function (){var statearr_35097 = state_35094;
(statearr_35097[(7)] = inst_35091);

return statearr_35097;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35094__$1,inst_35092);
} else {
return null;
}
}
});})(c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts))
;
return ((function (switch__11560__auto__,c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____0 = (function (){
var statearr_35101 = [null,null,null,null,null,null,null,null];
(statearr_35101[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__);

(statearr_35101[(1)] = (1));

return statearr_35101;
});
var cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____1 = (function (state_35094){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35094);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35102){if((e35102 instanceof Object)){
var ex__11564__auto__ = e35102;
var statearr_35103_35106 = state_35094;
(statearr_35103_35106[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35094);

return cljs.core.constant$keyword$recur;
} else {
throw e35102;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35107 = state_35094;
state_35094 = G__35107;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__ = function(state_35094){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____1.call(this,state_35094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__11561__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts))
})();
var state__11624__auto__ = (function (){var statearr_35104 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35105);

return statearr_35104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35105,channel,map__35084,map__35084__$1,decoding,decoding_opts))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__35110 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35110) : client.call(null,G__35110));
} else {
var G__35111 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35111) : client.call(null,G__35111));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__11622__auto___35150 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35150,channel){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35150,channel){
return (function (state_35139){
var state_val_35140 = (state_35139[(1)]);
if((state_val_35140 === (1))){
var inst_35131 = (function (){var G__35141 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35141) : client.call(null,G__35141));
})();
var state_35139__$1 = state_35139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35139__$1,(2),inst_35131);
} else {
if((state_val_35140 === (2))){
var inst_35133 = (state_35139[(2)]);
var inst_35134 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_35135 = cljs_http.client.decode_body(inst_35133,cljs_http.util.json_decode,"application/json",inst_35134);
var inst_35136 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_35135);
var inst_35137 = cljs.core.async.close_BANG_(channel);
var state_35139__$1 = (function (){var statearr_35142 = state_35139;
(statearr_35142[(7)] = inst_35136);

return statearr_35142;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35139__$1,inst_35137);
} else {
return null;
}
}
});})(c__11622__auto___35150,channel))
;
return ((function (switch__11560__auto__,c__11622__auto___35150,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__11561__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__11561__auto____0 = (function (){
var statearr_35146 = [null,null,null,null,null,null,null,null];
(statearr_35146[(0)] = cljs_http$client$wrap_json_response_$_state_machine__11561__auto__);

(statearr_35146[(1)] = (1));

return statearr_35146;
});
var cljs_http$client$wrap_json_response_$_state_machine__11561__auto____1 = (function (state_35139){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35139);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35147){if((e35147 instanceof Object)){
var ex__11564__auto__ = e35147;
var statearr_35148_35151 = state_35139;
(statearr_35148_35151[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35139);

return cljs.core.constant$keyword$recur;
} else {
throw e35147;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35152 = state_35139;
state_35139 = G__35152;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__11561__auto__ = function(state_35139){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__11561__auto____1.call(this,state_35139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__11561__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__11561__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35150,channel))
})();
var state__11624__auto__ = (function (){var statearr_35149 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35149[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35150);

return statearr_35149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35150,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__35157){
var map__35158 = p__35157;
var map__35158__$1 = ((cljs.core.seq_QMARK_(map__35158))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35158):map__35158);
var req = map__35158__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35158__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__35159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35159) : client.call(null,G__35159));
} else {
var G__35160 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35160) : client.call(null,G__35160));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__35165){
var map__35166 = p__35165;
var map__35166__$1 = ((cljs.core.seq_QMARK_(map__35166))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35166):map__35166);
var request = map__35166__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35166__$1,cljs.core.constant$keyword$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35166__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__8170__auto__ = form_params;
if(cljs.core.truth_(and__8170__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__8170__auto__;
}
})())){
var G__35167 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35167) : client.call(null,G__35167));
} else {
var G__35168 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35168) : client.call(null,G__35168));
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
var G__35170 = (cljs.core.truth_(cljs_http.util.android_QMARK_())?cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$android], null),(function (){return Math.random();
})()):request);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35170) : client.call(null,G__35170));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var m = temp__4423__auto__;
var G__35173 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35173) : client.call(null,G__35173));
} else {
var G__35174 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35174) : client.call(null,G__35174));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__35175_SHARP_){
var G__35177 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35175_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35177) : client.call(null,G__35177));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__35183){
var map__35184 = p__35183;
var map__35184__$1 = ((cljs.core.seq_QMARK_(map__35184))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35184):map__35184);
var req = map__35184__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35184__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4423__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4423__auto__)){
var spec = temp__4423__auto__;
var G__35185 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4423__auto__,map__35184,map__35184__$1,req,query_params){
return (function (p1__35178_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__35178_SHARP_,query_params], 0));
});})(spec,temp__4423__auto__,map__35184,map__35184__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35185) : client.call(null,G__35185));
} else {
var G__35186 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35186) : client.call(null,G__35186));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35189){
var vec__35190 = p__35189;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35190,(0),null);
return ((function (vec__35190,credentials){
return (function (req){
var credentials__$1 = (function (){var or__8182__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__35191 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35191) : client.call(null,G__35191));
} else {
var G__35192 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35192) : client.call(null,G__35192));
}
});
;})(vec__35190,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq35187){
var G__35188 = cljs.core.first(seq35187);
var seq35187__$1 = cljs.core.next(seq35187);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__35188,seq35187__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var oauth_token = temp__4423__auto__;
var G__35195 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35195) : client.call(null,G__35195));
} else {
var G__35196 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__35196) : client.call(null,G__35196));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35199){
var vec__35200 = p__35199;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35200,(0),null);
var G__35201 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35201) : cljs_http.client.request.call(null,G__35201));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq35197){
var G__35198 = cljs.core.first(seq35197);
var seq35197__$1 = cljs.core.next(seq35197);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__35198,seq35197__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35204){
var vec__35205 = p__35204;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35205,(0),null);
var G__35206 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35206) : cljs_http.client.request.call(null,G__35206));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq35202){
var G__35203 = cljs.core.first(seq35202);
var seq35202__$1 = cljs.core.next(seq35202);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__35203,seq35202__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35209){
var vec__35210 = p__35209;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35210,(0),null);
var G__35211 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35211) : cljs_http.client.request.call(null,G__35211));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq35207){
var G__35208 = cljs.core.first(seq35207);
var seq35207__$1 = cljs.core.next(seq35207);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__35208,seq35207__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35214){
var vec__35215 = p__35214;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35215,(0),null);
var G__35216 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35216) : cljs_http.client.request.call(null,G__35216));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq35212){
var G__35213 = cljs.core.first(seq35212);
var seq35212__$1 = cljs.core.next(seq35212);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__35213,seq35212__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35219){
var vec__35220 = p__35219;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35220,(0),null);
var G__35221 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35221) : cljs_http.client.request.call(null,G__35221));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq35217){
var G__35218 = cljs.core.first(seq35217);
var seq35217__$1 = cljs.core.next(seq35217);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__35218,seq35217__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35224){
var vec__35225 = p__35224;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35225,(0),null);
var G__35226 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35226) : cljs_http.client.request.call(null,G__35226));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq35222){
var G__35223 = cljs.core.first(seq35222);
var seq35222__$1 = cljs.core.next(seq35222);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__35223,seq35222__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35229){
var vec__35230 = p__35229;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35230,(0),null);
var G__35231 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35231) : cljs_http.client.request.call(null,G__35231));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq35227){
var G__35228 = cljs.core.first(seq35227);
var seq35227__$1 = cljs.core.next(seq35227);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__35228,seq35227__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35234){
var vec__35235 = p__35234;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35235,(0),null);
var G__35236 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__35236) : cljs_http.client.request.call(null,G__35236));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq35232){
var G__35233 = cljs.core.first(seq35232);
var seq35232__$1 = cljs.core.next(seq35232);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__35233,seq35232__$1);
});
