// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var http_options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?http_options:clojure.set.rename_keys(http_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,cljs.core.constant$keyword$query_DASH_params], null)));
if(cljs.core.truth_(no_cache_QMARK_)){
return cljs.core.assoc_in(http_options__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$t], null),(function (){var G__30914 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__30914) : cljs_hash.md5.md5.call(null,G__30914));
})());
} else {
return http_options__$1;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__9248__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__9248__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__30919){
var map__30920 = p__30919;
var map__30920__$1 = ((cljs.core.seq_QMARK_(map__30920))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30920):map__30920);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30920__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30920__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((function (){var G__30921 = milia.utils.remote._STAR_credentials_STAR_;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30921) : cljs.core.deref.call(null,G__30921));
})());
var Authorization = ((function (temp_token,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30915_SHARP_){
if(cljs.core.truth_(temp_token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30915_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join(''));
} else {
return null;
}
});})(temp_token,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var Cache_control = ((function (temp_token,Authorization,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30916_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30916_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(temp_token,Authorization,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var X_CSRFToken = ((function (temp_token,Authorization,Cache_control,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30917_SHARP_){
var temp__4425__auto__ = (function (){var and__8196__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__8196__auto__)){
var G__30922 = "csrftoken";
return goog.net.cookies.get(G__30922);
} else {
return and__8196__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30917_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(temp_token,Authorization,Cache_control,map__30920,map__30920__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(Authorization,Cache_control,X_CSRFToken).call(null,new cljs.core.PersistentArrayMap(null, 1, ["Accept","application/json"], null)));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq30918){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30918));
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__30929_30935 = io_obj;
var G__30930_30936 = goog.net.EventType.SUCCESS;
var G__30931_30937 = ((function (G__30929_30935,G__30930_30936,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__30929_30935,G__30930_30936,io_obj,url))
;
goog.events.listen(G__30929_30935,G__30930_30936,G__30931_30937);

var G__30932_30938 = io_obj;
var G__30933_30939 = goog.net.EventType.ERROR;
var G__30934_30940 = ((function (G__30932_30938,G__30933_30939,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__30932_30938,G__30933_30939,io_obj,url))
;
goog.events.listen(G__30932_30938,G__30933_30939,G__30934_30940);

return io_obj.sendFromForm(form,url);
});
milia.api.io.console_log = (function milia$api$io$console_log(s){

return console.log(cljs.core.clj__GT_js(s));
});
milia.api.io.debug_api = (function milia$api$io$debug_api(args,response){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$clients.cljs$core$IFn$_invoke$arity$1((function (){var G__30942 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30942) : cljs.core.deref.call(null,G__30942));
})()),"beta.ona.io")){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(milia.api.io.consol_log,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["-- DEBUG io/http-request","-- args:",args,"-- response",response], null));
} else {
return null;
}
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var argseq__9248__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9248__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11694__auto___30996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11694__auto___30996,response_channel){
return (function (){
var f__11695__auto__ = (function (){var switch__11632__auto__ = ((function (c__11694__auto___30996,response_channel){
return (function (state_30973){
var state_val_30974 = (state_30973[(1)]);
if((state_val_30974 === (7))){
var inst_30954 = (state_30973[(7)]);
var inst_30969 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_30954);
var state_30973__$1 = state_30973;
var statearr_30975_30997 = state_30973__$1;
(statearr_30975_30997[(2)] = inst_30969);

(statearr_30975_30997[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (1))){
var inst_30946 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_30973__$1 = state_30973;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30973__$1,(2),inst_30946);
} else {
if((state_val_30974 === (4))){
var inst_30948 = (state_30973[(8)]);
var state_30973__$1 = state_30973;
var statearr_30976_30998 = state_30973__$1;
(statearr_30976_30998[(2)] = inst_30948);

(statearr_30976_30998[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (6))){
var inst_30954 = (state_30973[(7)]);
var inst_30959 = cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(inst_30954);
var inst_30960 = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(inst_30959);
var inst_30961 = milia.utils.seq.in_QMARK_(milia.utils.remote.bad_token_msgs,inst_30960);
var state_30973__$1 = state_30973;
if(cljs.core.truth_(inst_30961)){
var statearr_30977_30999 = state_30973__$1;
(statearr_30977_30999[(1)] = (9));

} else {
var statearr_30978_31000 = state_30973__$1;
(statearr_30978_31000[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (3))){
var inst_30948 = (state_30973[(8)]);
var inst_30951 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30948);
var state_30973__$1 = state_30973;
var statearr_30979_31001 = state_30973__$1;
(statearr_30979_31001[(2)] = inst_30951);

(statearr_30979_31001[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (2))){
var inst_30948 = (state_30973[(8)]);
var inst_30948__$1 = (state_30973[(2)]);
var inst_30949 = cljs.core.seq_QMARK_(inst_30948__$1);
var state_30973__$1 = (function (){var statearr_30980 = state_30973;
(statearr_30980[(8)] = inst_30948__$1);

return statearr_30980;
})();
if(inst_30949){
var statearr_30981_31002 = state_30973__$1;
(statearr_30981_31002[(1)] = (3));

} else {
var statearr_30982_31003 = state_30973__$1;
(statearr_30982_31003[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (11))){
var inst_30967 = (state_30973[(2)]);
var state_30973__$1 = state_30973;
var statearr_30983_31004 = state_30973__$1;
(statearr_30983_31004[(2)] = inst_30967);

(statearr_30983_31004[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (9))){
var inst_30963 = window.location = window.location;
var state_30973__$1 = state_30973;
var statearr_30984_31005 = state_30973__$1;
(statearr_30984_31005[(2)] = inst_30963);

(statearr_30984_31005[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (5))){
var inst_30954 = (state_30973[(7)]);
var inst_30954__$1 = (state_30973[(2)]);
var inst_30955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30954__$1,cljs.core.constant$keyword$status);
var inst_30956 = milia.api.io.debug_api(args,inst_30954__$1);
var inst_30957 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30955,(401));
var state_30973__$1 = (function (){var statearr_30985 = state_30973;
(statearr_30985[(7)] = inst_30954__$1);

(statearr_30985[(9)] = inst_30956);

return statearr_30985;
})();
if(inst_30957){
var statearr_30986_31006 = state_30973__$1;
(statearr_30986_31006[(1)] = (6));

} else {
var statearr_30987_31007 = state_30973__$1;
(statearr_30987_31007[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (10))){
var inst_30965 = window.location = "/login";
var state_30973__$1 = state_30973;
var statearr_30988_31008 = state_30973__$1;
(statearr_30988_31008[(2)] = inst_30965);

(statearr_30988_31008[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30974 === (8))){
var inst_30971 = (state_30973[(2)]);
var state_30973__$1 = state_30973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30973__$1,inst_30971);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11694__auto___30996,response_channel))
;
return ((function (switch__11632__auto__,c__11694__auto___30996,response_channel){
return (function() {
var milia$api$io$state_machine__11633__auto__ = null;
var milia$api$io$state_machine__11633__auto____0 = (function (){
var statearr_30992 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30992[(0)] = milia$api$io$state_machine__11633__auto__);

(statearr_30992[(1)] = (1));

return statearr_30992;
});
var milia$api$io$state_machine__11633__auto____1 = (function (state_30973){
while(true){
var ret_value__11634__auto__ = (function (){try{while(true){
var result__11635__auto__ = switch__11632__auto__(state_30973);
if(cljs.core.keyword_identical_QMARK_(result__11635__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11635__auto__;
}
break;
}
}catch (e30993){if((e30993 instanceof Object)){
var ex__11636__auto__ = e30993;
var statearr_30994_31009 = state_30973;
(statearr_30994_31009[(5)] = ex__11636__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30973);

return cljs.core.constant$keyword$recur;
} else {
throw e30993;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11634__auto__,cljs.core.constant$keyword$recur)){
var G__31010 = state_30973;
state_30973 = G__31010;
continue;
} else {
return ret_value__11634__auto__;
}
break;
}
});
milia$api$io$state_machine__11633__auto__ = function(state_30973){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11633__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11633__auto____1.call(this,state_30973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11633__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11633__auto____0;
milia$api$io$state_machine__11633__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11633__auto____1;
return milia$api$io$state_machine__11633__auto__;
})()
;})(switch__11632__auto__,c__11694__auto___30996,response_channel))
})();
var state__11696__auto__ = (function (){var statearr_30995 = (function (){return (f__11695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11695__auto__.cljs$core$IFn$_invoke$arity$0() : f__11695__auto__.call(null));
})();
(statearr_30995[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11694__auto___30996);

return statearr_30995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11696__auto__);
});})(c__11694__auto___30996,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq30943){
var G__30944 = cljs.core.first(seq30943);
var seq30943__$1 = cljs.core.next(seq30943);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__30944,seq30943__$1);
});
