// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `callback`, `no-cache?`.
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var argseq__9248__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9248__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31016){
var map__31017 = p__31016;
var map__31017__$1 = ((cljs.core.seq_QMARK_(map__31017))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31017):map__31017);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$callback);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$http_DASH_options);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31017__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete),cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$xhr,true,cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__11694__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (){
var f__11695__auto__ = (function (){var switch__11632__auto__ = ((function (c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (state_31022){
var state_val_31023 = (state_31022[(1)]);
if((state_val_31023 === (1))){
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31022__$1,(2),ch);
} else {
if((state_val_31023 === (2))){
var inst_31019 = (state_31022[(2)]);
var inst_31020 = (function (){var G__31024 = inst_31019;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__31024) : callback.call(null,G__31024));
})();
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31022__$1,inst_31020);
} else {
return null;
}
}
});})(c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
;
return ((function (switch__11632__auto__,c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function() {
var milia$api$http$state_machine__11633__auto__ = null;
var milia$api$http$state_machine__11633__auto____0 = (function (){
var statearr_31028 = [null,null,null,null,null,null,null];
(statearr_31028[(0)] = milia$api$http$state_machine__11633__auto__);

(statearr_31028[(1)] = (1));

return statearr_31028;
});
var milia$api$http$state_machine__11633__auto____1 = (function (state_31022){
while(true){
var ret_value__11634__auto__ = (function (){try{while(true){
var result__11635__auto__ = switch__11632__auto__(state_31022);
if(cljs.core.keyword_identical_QMARK_(result__11635__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11635__auto__;
}
break;
}
}catch (e31029){if((e31029 instanceof Object)){
var ex__11636__auto__ = e31029;
var statearr_31030_31032 = state_31022;
(statearr_31030_31032[(5)] = ex__11636__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31022);

return cljs.core.constant$keyword$recur;
} else {
throw e31029;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11634__auto__,cljs.core.constant$keyword$recur)){
var G__31033 = state_31022;
state_31022 = G__31033;
continue;
} else {
return ret_value__11634__auto__;
}
break;
}
});
milia$api$http$state_machine__11633__auto__ = function(state_31022){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__11633__auto____0.call(this);
case 1:
return milia$api$http$state_machine__11633__auto____1.call(this,state_31022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__11633__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__11633__auto____0;
milia$api$http$state_machine__11633__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__11633__auto____1;
return milia$api$http$state_machine__11633__auto__;
})()
;})(switch__11632__auto__,c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
})();
var state__11696__auto__ = (function (){var statearr_31031 = (function (){return (f__11695__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11695__auto__.cljs$core$IFn$_invoke$arity$0() : f__11695__auto__.call(null));
})();
(statearr_31031[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11694__auto__);

return statearr_31031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11696__auto__);
});})(c__11694__auto__,request_fn,headers,ch,map__31017,map__31017__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
);

return c__11694__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq31013){
var G__31014 = cljs.core.first(seq31013);
var seq31013__$1 = cljs.core.next(seq31013);
var G__31015 = cljs.core.first(seq31013__$1);
var seq31013__$2 = cljs.core.next(seq31013__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31014,G__31015,seq31013__$2);
});
