// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.widgets');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * The Ona API expects clients to submit a URL as the value of the object bound
 * to a widget. This is basically asking clients to be aware of internal API
 * implementation details since this is a Django REST framework peculiarity.
 * This function provides an abstraction that allows Clojure based clients to
 * be ignorant of the quirk.
 * `content-type` can be either :form or :dataview
 * `content-id` is an integer identifying the object
 */
milia.api.widgets.generate_content_object_url = (function milia$api$widgets$generate_content_object_url(content_type,content_id){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var G__31039 = (((content_type instanceof cljs.core.Keyword))?content_type.fqn:null);
switch (G__31039) {
case "form":
return "forms";

break;
case "dataview":
return "dataviews";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(content_type)].join('')));

}
})(),content_id], 0));
});
/**
 * Create a new widget.
 * `account` is a map representing the authenticating user's credentials
 * `widget-definition` is a map containing the following keys:
 * `:title` is a string
 * `:content_type` is one of either :form of :dataview
 * `:content_id` is an intger identifying the content object
 * `:description` is a string.
 * `:widget_type` is a string, determined by the client e.g. chart
 * `:view_type` is a string, determined by the client e.g. bar-chart
 * `:column` is the  data column to be stored based on the form field.
 * `:group_by` the data column for the data to be grouped by. Optional
 */
milia.api.widgets.create = (function milia$api$widgets$create(p__31041){
var map__31043 = p__31041;
var map__31043__$1 = ((cljs.core.seq_QMARK_(map__31043))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31043):map__31043);
var widget_definition = map__31043__$1;
var content_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31043__$1,cljs.core.constant$keyword$content_type);
var content_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31043__$1,cljs.core.constant$keyword$content_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets"], 0));
var processed_widget_definition = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(widget_definition,cljs.core.constant$keyword$content_object,milia.api.widgets.generate_content_object_url(content_type,content_id));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,processed_widget_definition,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
milia.api.widgets.list = (function milia$api$widgets$list(){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets"], 0)),cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
milia.api.widgets.list_by_xform_id = (function milia$api$widgets$list_by_xform_id(xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("widgets?xform="),cljs.core.str(xform_id)].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
