// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var http_options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?http_options:clojure.set.rename_keys(http_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,cljs.core.constant$keyword$query_DASH_params], null)));
if(cljs.core.truth_(no_cache_QMARK_)){
return cljs.core.assoc_in(http_options__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$t], null),(function (){var G__30919 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__30919) : cljs_hash.md5.md5.call(null,G__30919));
})());
} else {
return http_options__$1;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__9254__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__9254__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__30924){
var map__30925 = p__30924;
var map__30925__$1 = ((cljs.core.seq_QMARK_(map__30925))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30925):map__30925);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30925__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30925__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((function (){var G__30926 = milia.utils.remote._STAR_credentials_STAR_;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30926) : cljs.core.deref.call(null,G__30926));
})());
var Authorization = ((function (temp_token,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30920_SHARP_){
if(cljs.core.truth_(temp_token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30920_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join(''));
} else {
return null;
}
});})(temp_token,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var Cache_control = ((function (temp_token,Authorization,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30921_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30921_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(temp_token,Authorization,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var X_CSRFToken = ((function (temp_token,Authorization,Cache_control,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__30922_SHARP_){
var temp__4425__auto__ = (function (){var and__8202__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__8202__auto__)){
var G__30927 = "csrftoken";
return goog.net.cookies.get(G__30927);
} else {
return and__8202__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30922_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(temp_token,Authorization,Cache_control,map__30925,map__30925__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(Authorization,Cache_control,X_CSRFToken).call(null,cljs.core.PersistentArrayMap.EMPTY));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq30923){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30923));
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__30934_30940 = io_obj;
var G__30935_30941 = goog.net.EventType.SUCCESS;
var G__30936_30942 = ((function (G__30934_30940,G__30935_30941,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__30934_30940,G__30935_30941,io_obj,url))
;
goog.events.listen(G__30934_30940,G__30935_30941,G__30936_30942);

var G__30937_30943 = io_obj;
var G__30938_30944 = goog.net.EventType.ERROR;
var G__30939_30945 = ((function (G__30937_30943,G__30938_30944,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__30937_30943,G__30938_30944,io_obj,url))
;
goog.events.listen(G__30937_30943,G__30938_30944,G__30939_30945);

return io_obj.sendFromForm(form,url);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var argseq__9254__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9254__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11700__auto___30998 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11700__auto___30998,response_channel){
return (function (){
var f__11701__auto__ = (function (){var switch__11638__auto__ = ((function (c__11700__auto___30998,response_channel){
return (function (state_30975){
var state_val_30976 = (state_30975[(1)]);
if((state_val_30976 === (7))){
var inst_30957 = (state_30975[(7)]);
var inst_30971 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_30957);
var state_30975__$1 = state_30975;
var statearr_30977_30999 = state_30975__$1;
(statearr_30977_30999[(2)] = inst_30971);

(statearr_30977_30999[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (1))){
var inst_30949 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_30975__$1 = state_30975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30975__$1,(2),inst_30949);
} else {
if((state_val_30976 === (4))){
var inst_30951 = (state_30975[(8)]);
var state_30975__$1 = state_30975;
var statearr_30978_31000 = state_30975__$1;
(statearr_30978_31000[(2)] = inst_30951);

(statearr_30978_31000[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (6))){
var inst_30957 = (state_30975[(7)]);
var inst_30961 = cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(inst_30957);
var inst_30962 = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(inst_30961);
var inst_30963 = milia.utils.seq.in_QMARK_(milia.utils.remote.bad_token_msgs,inst_30962);
var state_30975__$1 = state_30975;
if(cljs.core.truth_(inst_30963)){
var statearr_30979_31001 = state_30975__$1;
(statearr_30979_31001[(1)] = (9));

} else {
var statearr_30980_31002 = state_30975__$1;
(statearr_30980_31002[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (3))){
var inst_30951 = (state_30975[(8)]);
var inst_30954 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30951);
var state_30975__$1 = state_30975;
var statearr_30981_31003 = state_30975__$1;
(statearr_30981_31003[(2)] = inst_30954);

(statearr_30981_31003[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (2))){
var inst_30951 = (state_30975[(8)]);
var inst_30951__$1 = (state_30975[(2)]);
var inst_30952 = cljs.core.seq_QMARK_(inst_30951__$1);
var state_30975__$1 = (function (){var statearr_30982 = state_30975;
(statearr_30982[(8)] = inst_30951__$1);

return statearr_30982;
})();
if(inst_30952){
var statearr_30983_31004 = state_30975__$1;
(statearr_30983_31004[(1)] = (3));

} else {
var statearr_30984_31005 = state_30975__$1;
(statearr_30984_31005[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (11))){
var inst_30969 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
var statearr_30985_31006 = state_30975__$1;
(statearr_30985_31006[(2)] = inst_30969);

(statearr_30985_31006[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (9))){
var inst_30965 = window.location = window.location;
var state_30975__$1 = state_30975;
var statearr_30986_31007 = state_30975__$1;
(statearr_30986_31007[(2)] = inst_30965);

(statearr_30986_31007[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (5))){
var inst_30957 = (state_30975[(7)]);
var inst_30957__$1 = (state_30975[(2)]);
var inst_30958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30957__$1,cljs.core.constant$keyword$status);
var inst_30959 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30958,(401));
var state_30975__$1 = (function (){var statearr_30987 = state_30975;
(statearr_30987[(7)] = inst_30957__$1);

return statearr_30987;
})();
if(inst_30959){
var statearr_30988_31008 = state_30975__$1;
(statearr_30988_31008[(1)] = (6));

} else {
var statearr_30989_31009 = state_30975__$1;
(statearr_30989_31009[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (10))){
var inst_30967 = window.location = "/login";
var state_30975__$1 = state_30975;
var statearr_30990_31010 = state_30975__$1;
(statearr_30990_31010[(2)] = inst_30967);

(statearr_30990_31010[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30976 === (8))){
var inst_30973 = (state_30975[(2)]);
var state_30975__$1 = state_30975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30975__$1,inst_30973);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11700__auto___30998,response_channel))
;
return ((function (switch__11638__auto__,c__11700__auto___30998,response_channel){
return (function() {
var milia$api$io$state_machine__11639__auto__ = null;
var milia$api$io$state_machine__11639__auto____0 = (function (){
var statearr_30994 = [null,null,null,null,null,null,null,null,null];
(statearr_30994[(0)] = milia$api$io$state_machine__11639__auto__);

(statearr_30994[(1)] = (1));

return statearr_30994;
});
var milia$api$io$state_machine__11639__auto____1 = (function (state_30975){
while(true){
var ret_value__11640__auto__ = (function (){try{while(true){
var result__11641__auto__ = switch__11638__auto__(state_30975);
if(cljs.core.keyword_identical_QMARK_(result__11641__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11641__auto__;
}
break;
}
}catch (e30995){if((e30995 instanceof Object)){
var ex__11642__auto__ = e30995;
var statearr_30996_31011 = state_30975;
(statearr_30996_31011[(5)] = ex__11642__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30975);

return cljs.core.constant$keyword$recur;
} else {
throw e30995;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11640__auto__,cljs.core.constant$keyword$recur)){
var G__31012 = state_30975;
state_30975 = G__31012;
continue;
} else {
return ret_value__11640__auto__;
}
break;
}
});
milia$api$io$state_machine__11639__auto__ = function(state_30975){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11639__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11639__auto____1.call(this,state_30975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11639__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11639__auto____0;
milia$api$io$state_machine__11639__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11639__auto____1;
return milia$api$io$state_machine__11639__auto__;
})()
;})(switch__11638__auto__,c__11700__auto___30998,response_channel))
})();
var state__11702__auto__ = (function (){var statearr_30997 = (function (){return (f__11701__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11701__auto__.cljs$core$IFn$_invoke$arity$0() : f__11701__auto__.call(null));
})();
(statearr_30997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11700__auto___30998);

return statearr_30997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11702__auto__);
});})(c__11700__auto___30998,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq30946){
var G__30947 = cljs.core.first(seq30946);
var seq30946__$1 = cljs.core.next(seq30946);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__30947,seq30946__$1);
});
