// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var http_options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?http_options:(function (){var G__32801 = http_options;
var G__32802 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,cljs.core.constant$keyword$query_DASH_params], null);
return (milia.api.io.rename_keys.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.rename_keys.cljs$core$IFn$_invoke$arity$2(G__32801,G__32802) : milia.api.io.rename_keys.call(null,G__32801,G__32802));
})());
if(cljs.core.truth_(no_cache_QMARK_)){
return cljs.core.assoc_in(http_options__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$t], null),(function (){var G__32803 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32803) : cljs_hash.md5.md5.call(null,G__32803));
})());
} else {
return http_options__$1;
}
});
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__9221__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9221__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq32804){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32804));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_client_url = (function milia$api$io$make_client_url(){
var argseq__9221__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9221__auto__);
});

milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_client_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_client_url.cljs$lang$applyTo = (function (seq32805){
return milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32805));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__9221__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9221__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32808){
var vec__32809 = p__32808;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32809,(0),null);

var G__32810 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32810) : milia.api.io.raw_request.call(null,G__32810));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq32806){
var G__32807 = cljs.core.first(seq32806);
var seq32806__$1 = cljs.core.next(seq32806);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__32807,seq32806__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__9221__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9221__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32813){
var vec__32814 = p__32813;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32814,(0),null);

var G__32815 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32815) : milia.api.io.raw_request.call(null,G__32815));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq32811){
var G__32812 = cljs.core.first(seq32811);
var seq32811__$1 = cljs.core.next(seq32811);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__32812,seq32811__$1);
});
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__9221__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__9221__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__32820){
var map__32821 = p__32820;
var map__32821__$1 = ((cljs.core.seq_QMARK_(map__32821))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32821):map__32821);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32821__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32821__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var Authorization = ((function (map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32816_SHARP_){
if(cljs.core.truth_(clojure.string.blank_QMARK_(milia.api.io.token))){
return null;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32816_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_))].join(''));
}
});})(map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var Cache_control = ((function (Authorization,map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32817_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32817_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(Authorization,map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var X_CSRFToken = ((function (Authorization,Cache_control,map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32818_SHARP_){
var temp__4425__auto__ = (function (){var and__8169__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__8169__auto__)){
var G__32822 = "csrftoken";
return goog.net.cookies.get(G__32822);
} else {
return and__8169__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32818_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(Authorization,Cache_control,map__32821,map__32821__$1,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(Authorization,Cache_control,X_CSRFToken).call(null,cljs.core.PersistentArrayMap.EMPTY));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq32819){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32819));
});
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__32835 = null;
var G__32835__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null);
});
var G__32835__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params);
});
var G__32835__3 = (function() { 
var G__32836__delegate = function (url,query_params,p__32830){
var map__32831 = p__32830;
var map__32831__$1 = ((cljs.core.seq_QMARK_(map__32831))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32831):map__32831);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32831__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$)], 0));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__32832 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32832) : cljs_hash.md5.md5.call(null,G__32832));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__32833 = url;
var G__32834 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__32833,G__32834) : http_method.call(null,G__32833,G__32834));
};
var G__32836 = function (url,query_params,var_args){
var p__32830 = null;
if (arguments.length > 2) {
var G__32837__i = 0, G__32837__a = new Array(arguments.length -  2);
while (G__32837__i < G__32837__a.length) {G__32837__a[G__32837__i] = arguments[G__32837__i + 2]; ++G__32837__i;}
  p__32830 = new cljs.core.IndexedSeq(G__32837__a,0);
} 
return G__32836__delegate.call(this,url,query_params,p__32830);};
G__32836.cljs$lang$maxFixedArity = 2;
G__32836.cljs$lang$applyTo = (function (arglist__32838){
var url = cljs.core.first(arglist__32838);
arglist__32838 = cljs.core.next(arglist__32838);
var query_params = cljs.core.first(arglist__32838);
var p__32830 = cljs.core.rest(arglist__32838);
return G__32836__delegate(url,query_params,p__32830);
});
G__32836.cljs$core$IFn$_invoke$arity$variadic = G__32836__delegate;
return G__32836;
})()
;
G__32835 = function(url,query_params,var_args){
var p__32830 = var_args;
switch(arguments.length){
case 1:
return G__32835__1.call(this,url);
case 2:
return G__32835__2.call(this,url,query_params);
default:
var G__32839 = null;
if (arguments.length > 2) {
var G__32840__i = 0, G__32840__a = new Array(arguments.length -  2);
while (G__32840__i < G__32840__a.length) {G__32840__a[G__32840__i] = arguments[G__32840__i + 2]; ++G__32840__i;}
G__32839 = new cljs.core.IndexedSeq(G__32840__a,0);
}
return G__32835__3.cljs$core$IFn$_invoke$arity$variadic(url,query_params, G__32839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32835.cljs$lang$maxFixedArity = 2;
G__32835.cljs$lang$applyTo = G__32835__3.cljs$lang$applyTo;
G__32835.cljs$core$IFn$_invoke$arity$1 = G__32835__1;
G__32835.cljs$core$IFn$_invoke$arity$2 = G__32835__2;
G__32835.cljs$core$IFn$_invoke$arity$variadic = G__32835__3.cljs$core$IFn$_invoke$arity$variadic;
return G__32835;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__32848 = arguments.length;
switch (G__32848) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__9232__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(5)),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9232__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_(method,url,callback,query_params,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__11621__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11621__auto__){
return (function (){
var f__11622__auto__ = (function (){var switch__11559__auto__ = ((function (c__11621__auto__){
return (function (state_32859){
var state_val_32860 = (state_32859[(1)]);
if((state_val_32860 === (1))){
var inst_32849 = milia.api.io.query_helper(method);
var inst_32850 = (function (){var G__32861 = url;
var G__32862 = query_params;
var G__32863 = token;
var G__32864 = opts;
return (inst_32849.cljs$core$IFn$_invoke$arity$4 ? inst_32849.cljs$core$IFn$_invoke$arity$4(G__32861,G__32862,G__32863,G__32864) : inst_32849.call(null,G__32861,G__32862,G__32863,G__32864));
})();
var state_32859__$1 = state_32859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32859__$1,(2),inst_32850);
} else {
if((state_val_32860 === (2))){
var inst_32852 = (state_32859[(2)]);
var state_32859__$1 = (function (){var statearr_32865 = state_32859;
(statearr_32865[(7)] = inst_32852);

return statearr_32865;
})();
if(cljs.core.truth_(callback)){
var statearr_32866_32879 = state_32859__$1;
(statearr_32866_32879[(1)] = (3));

} else {
var statearr_32867_32880 = state_32859__$1;
(statearr_32867_32880[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32860 === (3))){
var inst_32852 = (state_32859[(7)]);
var inst_32854 = (function (){var G__32868 = inst_32852;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__32868) : callback.call(null,G__32868));
})();
var state_32859__$1 = state_32859;
var statearr_32869_32881 = state_32859__$1;
(statearr_32869_32881[(2)] = inst_32854);

(statearr_32869_32881[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32860 === (4))){
var state_32859__$1 = state_32859;
var statearr_32870_32882 = state_32859__$1;
(statearr_32870_32882[(2)] = null);

(statearr_32870_32882[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32860 === (5))){
var inst_32857 = (state_32859[(2)]);
var state_32859__$1 = state_32859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32859__$1,inst_32857);
} else {
return null;
}
}
}
}
}
});})(c__11621__auto__))
;
return ((function (switch__11559__auto__,c__11621__auto__){
return (function() {
var milia$api$io$state_machine__11560__auto__ = null;
var milia$api$io$state_machine__11560__auto____0 = (function (){
var statearr_32874 = [null,null,null,null,null,null,null,null];
(statearr_32874[(0)] = milia$api$io$state_machine__11560__auto__);

(statearr_32874[(1)] = (1));

return statearr_32874;
});
var milia$api$io$state_machine__11560__auto____1 = (function (state_32859){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_32859);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e32875){if((e32875 instanceof Object)){
var ex__11563__auto__ = e32875;
var statearr_32876_32883 = state_32859;
(statearr_32876_32883[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32859);

return cljs.core.constant$keyword$recur;
} else {
throw e32875;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__32884 = state_32859;
state_32859 = G__32884;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
milia$api$io$state_machine__11560__auto__ = function(state_32859){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11560__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11560__auto____1.call(this,state_32859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11560__auto____0;
milia$api$io$state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11560__auto____1;
return milia$api$io$state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11621__auto__))
})();
var state__11623__auto__ = (function (){var statearr_32877 = (function (){return (f__11622__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11622__auto__.cljs$core$IFn$_invoke$arity$0() : f__11622__auto__.call(null));
})();
(statearr_32877[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11621__auto__);

return statearr_32877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11623__auto__);
});})(c__11621__auto__))
);

return c__11621__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq32841){
var G__32842 = cljs.core.first(seq32841);
var seq32841__$1 = cljs.core.next(seq32841);
var G__32843 = cljs.core.first(seq32841__$1);
var seq32841__$2 = cljs.core.next(seq32841__$1);
var G__32844 = cljs.core.first(seq32841__$2);
var seq32841__$3 = cljs.core.next(seq32841__$2);
var G__32845 = cljs.core.first(seq32841__$3);
var seq32841__$4 = cljs.core.next(seq32841__$3);
var G__32846 = cljs.core.first(seq32841__$4);
var seq32841__$5 = cljs.core.next(seq32841__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32842,G__32843,G__32844,G__32845,G__32846,seq32841__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = (5);
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__32886 = arguments.length;
switch (G__32886) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32887 = event.target;
var G__32888 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32887,G__32888) : dommy.core.attr.call(null,G__32887,G__32888));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__32889 = event.target.form;
var G__32890 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32889,G__32890) : dommy.core.attr.call(null,G__32889,G__32890));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__32893 = arguments.length;
switch (G__32893) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32894 = event.target;
var G__32895 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32894,G__32895) : dommy.core.attr.call(null,G__32894,G__32895));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__11621__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11621__auto__){
return (function (){
var f__11622__auto__ = (function (){var switch__11559__auto__ = ((function (c__11621__auto__){
return (function (state_33030){
var state_val_33031 = (state_33030[(1)]);
if((state_val_33031 === (7))){
var inst_32995 = (state_33030[(2)]);
var state_33030__$1 = state_33030;
var statearr_33032_33077 = state_33030__$1;
(statearr_33032_33077[(2)] = inst_32995);

(statearr_33032_33077[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (20))){
var state_33030__$1 = state_33030;
var statearr_33033_33078 = state_33030__$1;
(statearr_33033_33078[(2)] = null);

(statearr_33033_33078[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (1))){
var inst_32987 = (state_33030[(7)]);
var inst_32987__$1 = (auth_token == null);
var state_33030__$1 = (function (){var statearr_33034 = state_33030;
(statearr_33034[(7)] = inst_32987__$1);

return statearr_33034;
})();
if(cljs.core.truth_(inst_32987__$1)){
var statearr_33035_33079 = state_33030__$1;
(statearr_33035_33079[(1)] = (2));

} else {
var statearr_33036_33080 = state_33030__$1;
(statearr_33036_33080[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (4))){
var inst_32997 = (state_33030[(2)]);
var state_33030__$1 = state_33030;
if(cljs.core.truth_(inst_32997)){
var statearr_33037_33081 = state_33030__$1;
(statearr_33037_33081[(1)] = (8));

} else {
var statearr_33038_33082 = state_33030__$1;
(statearr_33038_33082[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (15))){
var inst_33010 = (state_33030[(8)]);
var inst_33010__$1 = (state_33030[(2)]);
var inst_33011 = cljs.core.seq_QMARK_(inst_33010__$1);
var state_33030__$1 = (function (){var statearr_33039 = state_33030;
(statearr_33039[(8)] = inst_33010__$1);

return statearr_33039;
})();
if(inst_33011){
var statearr_33040_33083 = state_33030__$1;
(statearr_33040_33083[(1)] = (16));

} else {
var statearr_33041_33084 = state_33030__$1;
(statearr_33041_33084[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (21))){
var inst_33023 = (state_33030[(2)]);
var state_33030__$1 = state_33030;
var statearr_33042_33085 = state_33030__$1;
(statearr_33042_33085[(2)] = inst_33023);

(statearr_33042_33085[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (13))){
var state_33030__$1 = state_33030;
var statearr_33043_33086 = state_33030__$1;
(statearr_33043_33086[(2)] = auth_token);

(statearr_33043_33086[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (6))){
var inst_32993 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_33030__$1 = state_33030;
var statearr_33044_33087 = state_33030__$1;
(statearr_33044_33087[(2)] = inst_32993);

(statearr_33044_33087[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (17))){
var inst_33010 = (state_33030[(8)]);
var state_33030__$1 = state_33030;
var statearr_33045_33088 = state_33030__$1;
(statearr_33045_33088[(2)] = inst_33010);

(statearr_33045_33088[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (3))){
var inst_32990 = (state_33030[(9)]);
var inst_32990__$1 = clojure.string.blank_QMARK_(auth_token);
var state_33030__$1 = (function (){var statearr_33046 = state_33030;
(statearr_33046[(9)] = inst_32990__$1);

return statearr_33046;
})();
if(cljs.core.truth_(inst_32990__$1)){
var statearr_33047_33089 = state_33030__$1;
(statearr_33047_33089[(1)] = (5));

} else {
var statearr_33048_33090 = state_33030__$1;
(statearr_33048_33090[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (12))){
var inst_33007 = milia.api.io.refresh_token_url(username);
var inst_33008 = (function (){var G__33049 = inst_33007;
var G__33050 = null;
var G__33051 = null;
var G__33052 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__33053 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__33049,G__33050,G__33051,G__33052,G__33053) : milia.api.io.get_url.call(null,G__33049,G__33050,G__33051,G__33052,G__33053));
})();
var state_33030__$1 = state_33030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33030__$1,(15),inst_33008);
} else {
if((state_val_33031 === (2))){
var inst_32987 = (state_33030[(7)]);
var state_33030__$1 = state_33030;
var statearr_33054_33091 = state_33030__$1;
(statearr_33054_33091[(2)] = inst_32987);

(statearr_33054_33091[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (19))){
var inst_33018 = (state_33030[(10)]);
var state_33030__$1 = state_33030;
var statearr_33055_33092 = state_33030__$1;
(statearr_33055_33092[(2)] = inst_33018);

(statearr_33055_33092[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (11))){
var inst_33003 = (state_33030[(2)]);
var inst_33004 = milia.api.io.invalid_token_QMARK_(inst_33003);
var state_33030__$1 = state_33030;
if(cljs.core.truth_(inst_33004)){
var statearr_33056_33093 = state_33030__$1;
(statearr_33056_33093[(1)] = (12));

} else {
var statearr_33057_33094 = state_33030__$1;
(statearr_33057_33094[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (9))){
var inst_33000 = milia.api.io.validate_token_url(username);
var inst_33001 = (function (){var G__33058 = inst_33000;
var G__33059 = null;
var G__33060 = null;
var G__33061 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__33062 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__33058,G__33059,G__33060,G__33061,G__33062) : milia.api.io.get_url.call(null,G__33058,G__33059,G__33060,G__33061,G__33062));
})();
var state_33030__$1 = state_33030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33030__$1,(11),inst_33001);
} else {
if((state_val_33031 === (5))){
var inst_32990 = (state_33030[(9)]);
var state_33030__$1 = state_33030;
var statearr_33063_33095 = state_33030__$1;
(statearr_33063_33095[(2)] = inst_32990);

(statearr_33063_33095[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (14))){
var inst_33026 = (state_33030[(2)]);
var state_33030__$1 = state_33030;
var statearr_33064_33096 = state_33030__$1;
(statearr_33064_33096[(2)] = inst_33026);

(statearr_33064_33096[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (16))){
var inst_33010 = (state_33030[(8)]);
var inst_33013 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33010);
var state_33030__$1 = state_33030;
var statearr_33065_33097 = state_33030__$1;
(statearr_33065_33097[(2)] = inst_33013);

(statearr_33065_33097[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (10))){
var inst_33028 = (state_33030[(2)]);
var state_33030__$1 = state_33030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33030__$1,inst_33028);
} else {
if((state_val_33031 === (18))){
var inst_33016 = (state_33030[(2)]);
var inst_33017 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33016,cljs.core.constant$keyword$status);
var inst_33018 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33016,cljs.core.constant$keyword$body);
var inst_33019 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33017,(200));
var state_33030__$1 = (function (){var statearr_33066 = state_33030;
(statearr_33066[(10)] = inst_33018);

return statearr_33066;
})();
if(inst_33019){
var statearr_33067_33098 = state_33030__$1;
(statearr_33067_33098[(1)] = (19));

} else {
var statearr_33068_33099 = state_33030__$1;
(statearr_33068_33099[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33031 === (8))){
var state_33030__$1 = state_33030;
var statearr_33069_33100 = state_33030__$1;
(statearr_33069_33100[(2)] = null);

(statearr_33069_33100[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11621__auto__))
;
return ((function (switch__11559__auto__,c__11621__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__11560__auto__ = null;
var milia$api$io$validate_token_$_state_machine__11560__auto____0 = (function (){
var statearr_33073 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33073[(0)] = milia$api$io$validate_token_$_state_machine__11560__auto__);

(statearr_33073[(1)] = (1));

return statearr_33073;
});
var milia$api$io$validate_token_$_state_machine__11560__auto____1 = (function (state_33030){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_33030);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e33074){if((e33074 instanceof Object)){
var ex__11563__auto__ = e33074;
var statearr_33075_33101 = state_33030;
(statearr_33075_33101[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33030);

return cljs.core.constant$keyword$recur;
} else {
throw e33074;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__33102 = state_33030;
state_33030 = G__33102;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__11560__auto__ = function(state_33030){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__11560__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__11560__auto____1.call(this,state_33030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__11560__auto____0;
milia$api$io$validate_token_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__11560__auto____1;
return milia$api$io$validate_token_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11621__auto__))
})();
var state__11623__auto__ = (function (){var statearr_33076 = (function (){return (f__11622__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11622__auto__.cljs$core$IFn$_invoke$arity$0() : f__11622__auto__.call(null));
})();
(statearr_33076[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11621__auto__);

return statearr_33076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11623__auto__);
});})(c__11621__auto__))
);

return c__11621__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__33109_33115 = io_obj;
var G__33110_33116 = goog.net.EventType.SUCCESS;
var G__33111_33117 = ((function (G__33109_33115,G__33110_33116,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__33109_33115,G__33110_33116,io_obj,url))
;
goog.events.listen(G__33109_33115,G__33110_33116,G__33111_33117);

var G__33112_33118 = io_obj;
var G__33113_33119 = goog.net.EventType.ERROR;
var G__33114_33120 = ((function (G__33112_33118,G__33113_33119,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__33112_33118,G__33113_33119,io_obj,url))
;
goog.events.listen(G__33112_33118,G__33113_33119,G__33114_33120);

return io_obj.sendFromForm(form,url);
});
