// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('milia.utils.request');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In clj: `suppress-40x-exceptions?`, `as-map?`.
 * In cljs: `no-cache?`.
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var argseq__9221__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9221__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,options){
var map__33167 = options;
var map__33167__$1 = ((cljs.core.seq_QMARK_(map__33167))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33167):map__33167);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$http_DASH_options);
var suppress_40x_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33167__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var http_request = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:milia.utils.request.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$token,milia.api.http.auth_token,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs_http.client.delete$),cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_], 0));
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
}

var G__33168 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var G__33169 = http_options;
var G__33170 = method;
var G__33171 = no_cache_QMARK_;
return (milia.api.http.build_http_options.cljs$core$IFn$_invoke$arity$3 ? milia.api.http.build_http_options.cljs$core$IFn$_invoke$arity$3(G__33169,G__33170,G__33171) : milia.api.http.build_http_options.call(null,G__33169,G__33170,G__33171));
})(),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$xhr,true,cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0));
return (http_request.cljs$core$IFn$_invoke$arity$1 ? http_request.cljs$core$IFn$_invoke$arity$1(G__33168) : http_request.call(null,G__33168));
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq33164){
var G__33165 = cljs.core.first(seq33164);
var seq33164__$1 = cljs.core.next(seq33164);
var G__33166 = cljs.core.first(seq33164__$1);
var seq33164__$2 = cljs.core.next(seq33164__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__33165,G__33166,seq33164__$2);
});
