// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t35242 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t35242 = (function (fn_handler,f,meta35243){
this.fn_handler = fn_handler;
this.f = f;
this.meta35243 = meta35243;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t35242.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35244,meta35243__$1){
var self__ = this;
var _35244__$1 = this;
return (new cljs.core.async.t35242(self__.fn_handler,self__.f,meta35243__$1));
});

cljs.core.async.t35242.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35244){
var self__ = this;
var _35244__$1 = this;
return self__.meta35243;
});

cljs.core.async.t35242.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t35242.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t35242.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t35242.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta35243","meta35243",-879372618,null)], null);
});

cljs.core.async.t35242.cljs$lang$type = true;

cljs.core.async.t35242.cljs$lang$ctorStr = "cljs.core.async/t35242";

cljs.core.async.t35242.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t35242");
});

cljs.core.async.__GT_t35242 = (function cljs$core$async$fn_handler_$___GT_t35242(fn_handler__$1,f__$1,meta35243){
return (new cljs.core.async.t35242(fn_handler__$1,f__$1,meta35243));
});

}

return (new cljs.core.async.t35242(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__35246 = buff;
if(G__35246){
var bit__8856__auto__ = null;
if(cljs.core.truth_((function (){var or__8182__auto__ = bit__8856__auto__;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return G__35246.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__35246.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__35246);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__35246);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__35248 = arguments.length;
switch (G__35248) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__35251 = arguments.length;
switch (G__35251) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_35256 = (function (){var G__35252 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35252) : cljs.core.deref.call(null,G__35252));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__35253_35257 = val_35256;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__35253_35257) : fn1.call(null,G__35253_35257));
} else {
cljs.core.async.impl.dispatch.run(((function (val_35256,ret){
return (function (){
var G__35254 = val_35256;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__35254) : fn1.call(null,G__35254));
});})(val_35256,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__35259 = arguments.length;
switch (G__35259) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
var G__35260 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35260) : cljs.core.deref.call(null,G__35260));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (function (){var G__35261 = retb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35261) : cljs.core.deref.call(null,G__35261));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__35262_35265 = ret;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__35262_35265) : fn1.call(null,G__35262_35265));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
var G__35263 = ret;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__35263) : fn1.call(null,G__35263));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9067__auto___35266 = n;
var x_35267 = (0);
while(true){
if((x_35267 < n__9067__auto___35266)){
(a[x_35267] = (0));

var G__35268 = (x_35267 + (1));
x_35267 = G__35268;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__35269 = (i + (1));
i = G__35269;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (function (){var G__35277 = true;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__35277) : cljs.core.atom.call(null,G__35277));
})();
if(typeof cljs.core.async.t35278 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t35278 = (function (alt_flag,flag,meta35279){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta35279 = meta35279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t35278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_35280,meta35279__$1){
var self__ = this;
var _35280__$1 = this;
return (new cljs.core.async.t35278(self__.alt_flag,self__.flag,meta35279__$1));
});})(flag))
;

cljs.core.async.t35278.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_35280){
var self__ = this;
var _35280__$1 = this;
return self__.meta35279;
});})(flag))
;

cljs.core.async.t35278.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t35278.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__35281 = self__.flag;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35281) : cljs.core.deref.call(null,G__35281));
});})(flag))
;

cljs.core.async.t35278.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__35282_35284 = self__.flag;
var G__35283_35285 = null;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__35282_35284,G__35283_35285) : cljs.core.reset_BANG_.call(null,G__35282_35284,G__35283_35285));

return true;
});})(flag))
;

cljs.core.async.t35278.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta35279","meta35279",-178056163,null)], null);
});})(flag))
;

cljs.core.async.t35278.cljs$lang$type = true;

cljs.core.async.t35278.cljs$lang$ctorStr = "cljs.core.async/t35278";

cljs.core.async.t35278.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t35278");
});})(flag))
;

cljs.core.async.__GT_t35278 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t35278(alt_flag__$1,flag__$1,meta35279){
return (new cljs.core.async.t35278(alt_flag__$1,flag__$1,meta35279));
});})(flag))
;

}

return (new cljs.core.async.t35278(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t35289 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t35289 = (function (alt_handler,flag,cb,meta35290){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta35290 = meta35290;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t35289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35291,meta35290__$1){
var self__ = this;
var _35291__$1 = this;
return (new cljs.core.async.t35289(self__.alt_handler,self__.flag,self__.cb,meta35290__$1));
});

cljs.core.async.t35289.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35291){
var self__ = this;
var _35291__$1 = this;
return self__.meta35290;
});

cljs.core.async.t35289.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t35289.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t35289.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t35289.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta35290","meta35290",-166447569,null)], null);
});

cljs.core.async.t35289.cljs$lang$type = true;

cljs.core.async.t35289.cljs$lang$ctorStr = "cljs.core.async/t35289";

cljs.core.async.t35289.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t35289");
});

cljs.core.async.__GT_t35289 = (function cljs$core$async$alt_handler_$___GT_t35289(alt_handler__$1,flag__$1,cb__$1,meta35290){
return (new cljs.core.async.t35289(alt_handler__$1,flag__$1,cb__$1,meta35290));
});

}

return (new cljs.core.async.t35289(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(function (){var G__35299 = (0);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__35299) : port.call(null,G__35299));
})():null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (function (){var G__35300 = (1);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__35300) : port.call(null,G__35300));
})();
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35292_SHARP_){
var G__35301 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35292_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35301) : fret.call(null,G__35301));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35293_SHARP_){
var G__35302 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35293_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35302) : fret.call(null,G__35302));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35303 = vbox;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35303) : cljs.core.deref.call(null,G__35303));
})(),(function (){var or__8182__auto__ = wport;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return port;
}
})()], null));
} else {
var G__35304 = (i + (1));
i = G__35304;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8182__auto__ = ret;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__8170__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8170__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8170__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__35307){
var map__35308 = p__35307;
var map__35308__$1 = ((cljs.core.seq_QMARK_(map__35308))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35308):map__35308);
var opts = map__35308__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq35305){
var G__35306 = cljs.core.first(seq35305);
var seq35305__$1 = cljs.core.next(seq35305);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35306,seq35305__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__35310 = arguments.length;
switch (G__35310) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11622__auto___35359 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35359){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35359){
return (function (state_35334){
var state_val_35335 = (state_35334[(1)]);
if((state_val_35335 === (7))){
var inst_35330 = (state_35334[(2)]);
var state_35334__$1 = state_35334;
var statearr_35336_35360 = state_35334__$1;
(statearr_35336_35360[(2)] = inst_35330);

(statearr_35336_35360[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (1))){
var state_35334__$1 = state_35334;
var statearr_35337_35361 = state_35334__$1;
(statearr_35337_35361[(2)] = null);

(statearr_35337_35361[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (4))){
var inst_35313 = (state_35334[(7)]);
var inst_35313__$1 = (state_35334[(2)]);
var inst_35314 = (inst_35313__$1 == null);
var state_35334__$1 = (function (){var statearr_35338 = state_35334;
(statearr_35338[(7)] = inst_35313__$1);

return statearr_35338;
})();
if(cljs.core.truth_(inst_35314)){
var statearr_35339_35362 = state_35334__$1;
(statearr_35339_35362[(1)] = (5));

} else {
var statearr_35340_35363 = state_35334__$1;
(statearr_35340_35363[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (13))){
var state_35334__$1 = state_35334;
var statearr_35341_35364 = state_35334__$1;
(statearr_35341_35364[(2)] = null);

(statearr_35341_35364[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (6))){
var inst_35313 = (state_35334[(7)]);
var state_35334__$1 = state_35334;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35334__$1,(11),to,inst_35313);
} else {
if((state_val_35335 === (3))){
var inst_35332 = (state_35334[(2)]);
var state_35334__$1 = state_35334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35334__$1,inst_35332);
} else {
if((state_val_35335 === (12))){
var state_35334__$1 = state_35334;
var statearr_35342_35365 = state_35334__$1;
(statearr_35342_35365[(2)] = null);

(statearr_35342_35365[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (2))){
var state_35334__$1 = state_35334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35334__$1,(4),from);
} else {
if((state_val_35335 === (11))){
var inst_35323 = (state_35334[(2)]);
var state_35334__$1 = state_35334;
if(cljs.core.truth_(inst_35323)){
var statearr_35343_35366 = state_35334__$1;
(statearr_35343_35366[(1)] = (12));

} else {
var statearr_35344_35367 = state_35334__$1;
(statearr_35344_35367[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (9))){
var state_35334__$1 = state_35334;
var statearr_35345_35368 = state_35334__$1;
(statearr_35345_35368[(2)] = null);

(statearr_35345_35368[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (5))){
var state_35334__$1 = state_35334;
if(cljs.core.truth_(close_QMARK_)){
var statearr_35346_35369 = state_35334__$1;
(statearr_35346_35369[(1)] = (8));

} else {
var statearr_35347_35370 = state_35334__$1;
(statearr_35347_35370[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (14))){
var inst_35328 = (state_35334[(2)]);
var state_35334__$1 = state_35334;
var statearr_35348_35371 = state_35334__$1;
(statearr_35348_35371[(2)] = inst_35328);

(statearr_35348_35371[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (10))){
var inst_35320 = (state_35334[(2)]);
var state_35334__$1 = state_35334;
var statearr_35349_35372 = state_35334__$1;
(statearr_35349_35372[(2)] = inst_35320);

(statearr_35349_35372[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35335 === (8))){
var inst_35317 = cljs.core.async.close_BANG_(to);
var state_35334__$1 = state_35334;
var statearr_35350_35373 = state_35334__$1;
(statearr_35350_35373[(2)] = inst_35317);

(statearr_35350_35373[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___35359))
;
return ((function (switch__11560__auto__,c__11622__auto___35359){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_35354 = [null,null,null,null,null,null,null,null];
(statearr_35354[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_35354[(1)] = (1));

return statearr_35354;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_35334){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35334);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35355){if((e35355 instanceof Object)){
var ex__11564__auto__ = e35355;
var statearr_35356_35374 = state_35334;
(statearr_35356_35374[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35334);

return cljs.core.constant$keyword$recur;
} else {
throw e35355;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35375 = state_35334;
state_35334 = G__35375;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_35334){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_35334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35359))
})();
var state__11624__auto__ = (function (){var statearr_35357 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35357[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35359);

return statearr_35357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35359))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__35561){
var vec__35562 = p__35561;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35562,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35562,(1),null);
var job = vec__35562;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11622__auto___35746 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results){
return (function (state_35567){
var state_val_35568 = (state_35567[(1)]);
if((state_val_35568 === (1))){
var state_35567__$1 = state_35567;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35567__$1,(2),res,v);
} else {
if((state_val_35568 === (2))){
var inst_35564 = (state_35567[(2)]);
var inst_35565 = cljs.core.async.close_BANG_(res);
var state_35567__$1 = (function (){var statearr_35569 = state_35567;
(statearr_35569[(7)] = inst_35564);

return statearr_35569;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35567__$1,inst_35565);
} else {
return null;
}
}
});})(c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results))
;
return ((function (switch__11560__auto__,c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_35573 = [null,null,null,null,null,null,null,null];
(statearr_35573[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_35573[(1)] = (1));

return statearr_35573;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_35567){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35567);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35574){if((e35574 instanceof Object)){
var ex__11564__auto__ = e35574;
var statearr_35575_35747 = state_35567;
(statearr_35575_35747[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35567);

return cljs.core.constant$keyword$recur;
} else {
throw e35574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35748 = state_35567;
state_35567 = G__35748;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_35567){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_35567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results))
})();
var state__11624__auto__ = (function (){var statearr_35576 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35576[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35746);

return statearr_35576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35746,res,vec__35562,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__35577){
var vec__35578 = p__35577;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35578,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35578,(1),null);
var job = vec__35578;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var G__35579_35749 = v;
var G__35580_35750 = res;
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(G__35579_35749,G__35580_35750) : xf.call(null,G__35579_35749,G__35580_35750));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9067__auto___35751 = n;
var __35752 = (0);
while(true){
if((__35752 < n__9067__auto___35751)){
var G__35581_35753 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__35581_35753) {
case "compute":
var c__11622__auto___35755 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__35752,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (__35752,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function (state_35594){
var state_val_35595 = (state_35594[(1)]);
if((state_val_35595 === (1))){
var state_35594__$1 = state_35594;
var statearr_35596_35756 = state_35594__$1;
(statearr_35596_35756[(2)] = null);

(statearr_35596_35756[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35595 === (2))){
var state_35594__$1 = state_35594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35594__$1,(4),jobs);
} else {
if((state_val_35595 === (3))){
var inst_35592 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35594__$1,inst_35592);
} else {
if((state_val_35595 === (4))){
var inst_35584 = (state_35594[(2)]);
var inst_35585 = process(inst_35584);
var state_35594__$1 = state_35594;
if(cljs.core.truth_(inst_35585)){
var statearr_35597_35757 = state_35594__$1;
(statearr_35597_35757[(1)] = (5));

} else {
var statearr_35598_35758 = state_35594__$1;
(statearr_35598_35758[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35595 === (5))){
var state_35594__$1 = state_35594;
var statearr_35599_35759 = state_35594__$1;
(statearr_35599_35759[(2)] = null);

(statearr_35599_35759[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35595 === (6))){
var state_35594__$1 = state_35594;
var statearr_35600_35760 = state_35594__$1;
(statearr_35600_35760[(2)] = null);

(statearr_35600_35760[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35595 === (7))){
var inst_35590 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
var statearr_35601_35761 = state_35594__$1;
(statearr_35601_35761[(2)] = inst_35590);

(statearr_35601_35761[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__35752,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
;
return ((function (__35752,switch__11560__auto__,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_35605 = [null,null,null,null,null,null,null];
(statearr_35605[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_35605[(1)] = (1));

return statearr_35605;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_35594){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35594);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35606){if((e35606 instanceof Object)){
var ex__11564__auto__ = e35606;
var statearr_35607_35762 = state_35594;
(statearr_35607_35762[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35594);

return cljs.core.constant$keyword$recur;
} else {
throw e35606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35763 = state_35594;
state_35594 = G__35763;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_35594){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_35594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(__35752,switch__11560__auto__,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
})();
var state__11624__auto__ = (function (){var statearr_35608 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35608[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35755);

return statearr_35608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(__35752,c__11622__auto___35755,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
);


break;
case "async":
var c__11622__auto___35764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__35752,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (__35752,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function (state_35621){
var state_val_35622 = (state_35621[(1)]);
if((state_val_35622 === (1))){
var state_35621__$1 = state_35621;
var statearr_35623_35765 = state_35621__$1;
(statearr_35623_35765[(2)] = null);

(statearr_35623_35765[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35622 === (2))){
var state_35621__$1 = state_35621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35621__$1,(4),jobs);
} else {
if((state_val_35622 === (3))){
var inst_35619 = (state_35621[(2)]);
var state_35621__$1 = state_35621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35621__$1,inst_35619);
} else {
if((state_val_35622 === (4))){
var inst_35611 = (state_35621[(2)]);
var inst_35612 = async(inst_35611);
var state_35621__$1 = state_35621;
if(cljs.core.truth_(inst_35612)){
var statearr_35624_35766 = state_35621__$1;
(statearr_35624_35766[(1)] = (5));

} else {
var statearr_35625_35767 = state_35621__$1;
(statearr_35625_35767[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35622 === (5))){
var state_35621__$1 = state_35621;
var statearr_35626_35768 = state_35621__$1;
(statearr_35626_35768[(2)] = null);

(statearr_35626_35768[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35622 === (6))){
var state_35621__$1 = state_35621;
var statearr_35627_35769 = state_35621__$1;
(statearr_35627_35769[(2)] = null);

(statearr_35627_35769[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35622 === (7))){
var inst_35617 = (state_35621[(2)]);
var state_35621__$1 = state_35621;
var statearr_35628_35770 = state_35621__$1;
(statearr_35628_35770[(2)] = inst_35617);

(statearr_35628_35770[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__35752,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
;
return ((function (__35752,switch__11560__auto__,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_35632 = [null,null,null,null,null,null,null];
(statearr_35632[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_35632[(1)] = (1));

return statearr_35632;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_35621){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35621);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35633){if((e35633 instanceof Object)){
var ex__11564__auto__ = e35633;
var statearr_35634_35771 = state_35621;
(statearr_35634_35771[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35621);

return cljs.core.constant$keyword$recur;
} else {
throw e35633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35772 = state_35621;
state_35621 = G__35772;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_35621){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_35621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(__35752,switch__11560__auto__,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
})();
var state__11624__auto__ = (function (){var statearr_35635 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35764);

return statearr_35635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(__35752,c__11622__auto___35764,G__35581_35753,n__9067__auto___35751,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__35773 = (__35752 + (1));
__35752 = G__35773;
continue;
} else {
}
break;
}

var c__11622__auto___35774 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35774,jobs,results,process,async){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35774,jobs,results,process,async){
return (function (state_35657){
var state_val_35658 = (state_35657[(1)]);
if((state_val_35658 === (1))){
var state_35657__$1 = state_35657;
var statearr_35659_35775 = state_35657__$1;
(statearr_35659_35775[(2)] = null);

(statearr_35659_35775[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35658 === (2))){
var state_35657__$1 = state_35657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35657__$1,(4),from);
} else {
if((state_val_35658 === (3))){
var inst_35655 = (state_35657[(2)]);
var state_35657__$1 = state_35657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35657__$1,inst_35655);
} else {
if((state_val_35658 === (4))){
var inst_35638 = (state_35657[(7)]);
var inst_35638__$1 = (state_35657[(2)]);
var inst_35639 = (inst_35638__$1 == null);
var state_35657__$1 = (function (){var statearr_35660 = state_35657;
(statearr_35660[(7)] = inst_35638__$1);

return statearr_35660;
})();
if(cljs.core.truth_(inst_35639)){
var statearr_35661_35776 = state_35657__$1;
(statearr_35661_35776[(1)] = (5));

} else {
var statearr_35662_35777 = state_35657__$1;
(statearr_35662_35777[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35658 === (5))){
var inst_35641 = cljs.core.async.close_BANG_(jobs);
var state_35657__$1 = state_35657;
var statearr_35663_35778 = state_35657__$1;
(statearr_35663_35778[(2)] = inst_35641);

(statearr_35663_35778[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35658 === (6))){
var inst_35638 = (state_35657[(7)]);
var inst_35643 = (state_35657[(8)]);
var inst_35643__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_35644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35645 = [inst_35638,inst_35643__$1];
var inst_35646 = (new cljs.core.PersistentVector(null,2,(5),inst_35644,inst_35645,null));
var state_35657__$1 = (function (){var statearr_35664 = state_35657;
(statearr_35664[(8)] = inst_35643__$1);

return statearr_35664;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35657__$1,(8),jobs,inst_35646);
} else {
if((state_val_35658 === (7))){
var inst_35653 = (state_35657[(2)]);
var state_35657__$1 = state_35657;
var statearr_35665_35779 = state_35657__$1;
(statearr_35665_35779[(2)] = inst_35653);

(statearr_35665_35779[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35658 === (8))){
var inst_35643 = (state_35657[(8)]);
var inst_35648 = (state_35657[(2)]);
var state_35657__$1 = (function (){var statearr_35666 = state_35657;
(statearr_35666[(9)] = inst_35648);

return statearr_35666;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35657__$1,(9),results,inst_35643);
} else {
if((state_val_35658 === (9))){
var inst_35650 = (state_35657[(2)]);
var state_35657__$1 = (function (){var statearr_35667 = state_35657;
(statearr_35667[(10)] = inst_35650);

return statearr_35667;
})();
var statearr_35668_35780 = state_35657__$1;
(statearr_35668_35780[(2)] = null);

(statearr_35668_35780[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___35774,jobs,results,process,async))
;
return ((function (switch__11560__auto__,c__11622__auto___35774,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_35672 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35672[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_35672[(1)] = (1));

return statearr_35672;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_35657){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35657);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35673){if((e35673 instanceof Object)){
var ex__11564__auto__ = e35673;
var statearr_35674_35781 = state_35657;
(statearr_35674_35781[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35657);

return cljs.core.constant$keyword$recur;
} else {
throw e35673;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35782 = state_35657;
state_35657 = G__35782;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_35657){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_35657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35774,jobs,results,process,async))
})();
var state__11624__auto__ = (function (){var statearr_35675 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35675[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35774);

return statearr_35675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35774,jobs,results,process,async))
);


var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__,jobs,results,process,async){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__,jobs,results,process,async){
return (function (state_35713){
var state_val_35714 = (state_35713[(1)]);
if((state_val_35714 === (7))){
var inst_35709 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
var statearr_35715_35783 = state_35713__$1;
(statearr_35715_35783[(2)] = inst_35709);

(statearr_35715_35783[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (20))){
var state_35713__$1 = state_35713;
var statearr_35716_35784 = state_35713__$1;
(statearr_35716_35784[(2)] = null);

(statearr_35716_35784[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (1))){
var state_35713__$1 = state_35713;
var statearr_35717_35785 = state_35713__$1;
(statearr_35717_35785[(2)] = null);

(statearr_35717_35785[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (4))){
var inst_35678 = (state_35713[(7)]);
var inst_35678__$1 = (state_35713[(2)]);
var inst_35679 = (inst_35678__$1 == null);
var state_35713__$1 = (function (){var statearr_35718 = state_35713;
(statearr_35718[(7)] = inst_35678__$1);

return statearr_35718;
})();
if(cljs.core.truth_(inst_35679)){
var statearr_35719_35786 = state_35713__$1;
(statearr_35719_35786[(1)] = (5));

} else {
var statearr_35720_35787 = state_35713__$1;
(statearr_35720_35787[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (15))){
var inst_35691 = (state_35713[(8)]);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35713__$1,(18),to,inst_35691);
} else {
if((state_val_35714 === (21))){
var inst_35704 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
var statearr_35721_35788 = state_35713__$1;
(statearr_35721_35788[(2)] = inst_35704);

(statearr_35721_35788[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (13))){
var inst_35706 = (state_35713[(2)]);
var state_35713__$1 = (function (){var statearr_35722 = state_35713;
(statearr_35722[(9)] = inst_35706);

return statearr_35722;
})();
var statearr_35723_35789 = state_35713__$1;
(statearr_35723_35789[(2)] = null);

(statearr_35723_35789[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (6))){
var inst_35678 = (state_35713[(7)]);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35713__$1,(11),inst_35678);
} else {
if((state_val_35714 === (17))){
var inst_35699 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
if(cljs.core.truth_(inst_35699)){
var statearr_35724_35790 = state_35713__$1;
(statearr_35724_35790[(1)] = (19));

} else {
var statearr_35725_35791 = state_35713__$1;
(statearr_35725_35791[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (3))){
var inst_35711 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35713__$1,inst_35711);
} else {
if((state_val_35714 === (12))){
var inst_35688 = (state_35713[(10)]);
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35713__$1,(14),inst_35688);
} else {
if((state_val_35714 === (2))){
var state_35713__$1 = state_35713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35713__$1,(4),results);
} else {
if((state_val_35714 === (19))){
var state_35713__$1 = state_35713;
var statearr_35726_35792 = state_35713__$1;
(statearr_35726_35792[(2)] = null);

(statearr_35726_35792[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (11))){
var inst_35688 = (state_35713[(2)]);
var state_35713__$1 = (function (){var statearr_35727 = state_35713;
(statearr_35727[(10)] = inst_35688);

return statearr_35727;
})();
var statearr_35728_35793 = state_35713__$1;
(statearr_35728_35793[(2)] = null);

(statearr_35728_35793[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (9))){
var state_35713__$1 = state_35713;
var statearr_35729_35794 = state_35713__$1;
(statearr_35729_35794[(2)] = null);

(statearr_35729_35794[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (5))){
var state_35713__$1 = state_35713;
if(cljs.core.truth_(close_QMARK_)){
var statearr_35730_35795 = state_35713__$1;
(statearr_35730_35795[(1)] = (8));

} else {
var statearr_35731_35796 = state_35713__$1;
(statearr_35731_35796[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (14))){
var inst_35691 = (state_35713[(8)]);
var inst_35693 = (state_35713[(11)]);
var inst_35691__$1 = (state_35713[(2)]);
var inst_35692 = (inst_35691__$1 == null);
var inst_35693__$1 = cljs.core.not(inst_35692);
var state_35713__$1 = (function (){var statearr_35732 = state_35713;
(statearr_35732[(8)] = inst_35691__$1);

(statearr_35732[(11)] = inst_35693__$1);

return statearr_35732;
})();
if(inst_35693__$1){
var statearr_35733_35797 = state_35713__$1;
(statearr_35733_35797[(1)] = (15));

} else {
var statearr_35734_35798 = state_35713__$1;
(statearr_35734_35798[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (16))){
var inst_35693 = (state_35713[(11)]);
var state_35713__$1 = state_35713;
var statearr_35735_35799 = state_35713__$1;
(statearr_35735_35799[(2)] = inst_35693);

(statearr_35735_35799[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (10))){
var inst_35685 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
var statearr_35736_35800 = state_35713__$1;
(statearr_35736_35800[(2)] = inst_35685);

(statearr_35736_35800[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (18))){
var inst_35696 = (state_35713[(2)]);
var state_35713__$1 = state_35713;
var statearr_35737_35801 = state_35713__$1;
(statearr_35737_35801[(2)] = inst_35696);

(statearr_35737_35801[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35714 === (8))){
var inst_35682 = cljs.core.async.close_BANG_(to);
var state_35713__$1 = state_35713;
var statearr_35738_35802 = state_35713__$1;
(statearr_35738_35802[(2)] = inst_35682);

(statearr_35738_35802[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto__,jobs,results,process,async))
;
return ((function (switch__11560__auto__,c__11622__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_35742 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35742[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__);

(statearr_35742[(1)] = (1));

return statearr_35742;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1 = (function (state_35713){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35713);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35743){if((e35743 instanceof Object)){
var ex__11564__auto__ = e35743;
var statearr_35744_35803 = state_35713;
(statearr_35744_35803[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35713);

return cljs.core.constant$keyword$recur;
} else {
throw e35743;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35804 = state_35713;
state_35713 = G__35804;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__ = function(state_35713){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1.call(this,state_35713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__,jobs,results,process,async))
})();
var state__11624__auto__ = (function (){var statearr_35745 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35745[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_35745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__,jobs,results,process,async))
);

return c__11622__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__35806 = arguments.length;
switch (G__35806) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__35809 = arguments.length;
switch (G__35809) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__35812 = arguments.length;
switch (G__35812) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11622__auto___35865 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___35865,tc,fc){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___35865,tc,fc){
return (function (state_35838){
var state_val_35839 = (state_35838[(1)]);
if((state_val_35839 === (7))){
var inst_35834 = (state_35838[(2)]);
var state_35838__$1 = state_35838;
var statearr_35840_35866 = state_35838__$1;
(statearr_35840_35866[(2)] = inst_35834);

(statearr_35840_35866[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (1))){
var state_35838__$1 = state_35838;
var statearr_35841_35867 = state_35838__$1;
(statearr_35841_35867[(2)] = null);

(statearr_35841_35867[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (4))){
var inst_35815 = (state_35838[(7)]);
var inst_35815__$1 = (state_35838[(2)]);
var inst_35816 = (inst_35815__$1 == null);
var state_35838__$1 = (function (){var statearr_35842 = state_35838;
(statearr_35842[(7)] = inst_35815__$1);

return statearr_35842;
})();
if(cljs.core.truth_(inst_35816)){
var statearr_35843_35868 = state_35838__$1;
(statearr_35843_35868[(1)] = (5));

} else {
var statearr_35844_35869 = state_35838__$1;
(statearr_35844_35869[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (13))){
var state_35838__$1 = state_35838;
var statearr_35845_35870 = state_35838__$1;
(statearr_35845_35870[(2)] = null);

(statearr_35845_35870[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (6))){
var inst_35815 = (state_35838[(7)]);
var inst_35821 = (function (){var G__35846 = inst_35815;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__35846) : p.call(null,G__35846));
})();
var state_35838__$1 = state_35838;
if(cljs.core.truth_(inst_35821)){
var statearr_35847_35871 = state_35838__$1;
(statearr_35847_35871[(1)] = (9));

} else {
var statearr_35848_35872 = state_35838__$1;
(statearr_35848_35872[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (3))){
var inst_35836 = (state_35838[(2)]);
var state_35838__$1 = state_35838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35838__$1,inst_35836);
} else {
if((state_val_35839 === (12))){
var state_35838__$1 = state_35838;
var statearr_35849_35873 = state_35838__$1;
(statearr_35849_35873[(2)] = null);

(statearr_35849_35873[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (2))){
var state_35838__$1 = state_35838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35838__$1,(4),ch);
} else {
if((state_val_35839 === (11))){
var inst_35815 = (state_35838[(7)]);
var inst_35825 = (state_35838[(2)]);
var state_35838__$1 = state_35838;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35838__$1,(8),inst_35825,inst_35815);
} else {
if((state_val_35839 === (9))){
var state_35838__$1 = state_35838;
var statearr_35850_35874 = state_35838__$1;
(statearr_35850_35874[(2)] = tc);

(statearr_35850_35874[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (5))){
var inst_35818 = cljs.core.async.close_BANG_(tc);
var inst_35819 = cljs.core.async.close_BANG_(fc);
var state_35838__$1 = (function (){var statearr_35851 = state_35838;
(statearr_35851[(8)] = inst_35818);

return statearr_35851;
})();
var statearr_35852_35875 = state_35838__$1;
(statearr_35852_35875[(2)] = inst_35819);

(statearr_35852_35875[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (14))){
var inst_35832 = (state_35838[(2)]);
var state_35838__$1 = state_35838;
var statearr_35853_35876 = state_35838__$1;
(statearr_35853_35876[(2)] = inst_35832);

(statearr_35853_35876[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (10))){
var state_35838__$1 = state_35838;
var statearr_35854_35877 = state_35838__$1;
(statearr_35854_35877[(2)] = fc);

(statearr_35854_35877[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35839 === (8))){
var inst_35827 = (state_35838[(2)]);
var state_35838__$1 = state_35838;
if(cljs.core.truth_(inst_35827)){
var statearr_35855_35878 = state_35838__$1;
(statearr_35855_35878[(1)] = (12));

} else {
var statearr_35856_35879 = state_35838__$1;
(statearr_35856_35879[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___35865,tc,fc))
;
return ((function (switch__11560__auto__,c__11622__auto___35865,tc,fc){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_35860 = [null,null,null,null,null,null,null,null,null];
(statearr_35860[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_35860[(1)] = (1));

return statearr_35860;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_35838){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35838);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35861){if((e35861 instanceof Object)){
var ex__11564__auto__ = e35861;
var statearr_35862_35880 = state_35838;
(statearr_35862_35880[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35838);

return cljs.core.constant$keyword$recur;
} else {
throw e35861;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35881 = state_35838;
state_35838 = G__35881;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_35838){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_35838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___35865,tc,fc))
})();
var state__11624__auto__ = (function (){var statearr_35863 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35863[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___35865);

return statearr_35863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___35865,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__){
return (function (state_35930){
var state_val_35931 = (state_35930[(1)]);
if((state_val_35931 === (1))){
var inst_35916 = init;
var state_35930__$1 = (function (){var statearr_35932 = state_35930;
(statearr_35932[(7)] = inst_35916);

return statearr_35932;
})();
var statearr_35933_35950 = state_35930__$1;
(statearr_35933_35950[(2)] = null);

(statearr_35933_35950[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35931 === (2))){
var state_35930__$1 = state_35930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35930__$1,(4),ch);
} else {
if((state_val_35931 === (3))){
var inst_35928 = (state_35930[(2)]);
var state_35930__$1 = state_35930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35930__$1,inst_35928);
} else {
if((state_val_35931 === (4))){
var inst_35919 = (state_35930[(8)]);
var inst_35919__$1 = (state_35930[(2)]);
var inst_35920 = (inst_35919__$1 == null);
var state_35930__$1 = (function (){var statearr_35934 = state_35930;
(statearr_35934[(8)] = inst_35919__$1);

return statearr_35934;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_35935_35951 = state_35930__$1;
(statearr_35935_35951[(1)] = (5));

} else {
var statearr_35936_35952 = state_35930__$1;
(statearr_35936_35952[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35931 === (5))){
var inst_35916 = (state_35930[(7)]);
var state_35930__$1 = state_35930;
var statearr_35937_35953 = state_35930__$1;
(statearr_35937_35953[(2)] = inst_35916);

(statearr_35937_35953[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35931 === (6))){
var inst_35916 = (state_35930[(7)]);
var inst_35919 = (state_35930[(8)]);
var inst_35923 = (function (){var G__35938 = inst_35916;
var G__35939 = inst_35919;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__35938,G__35939) : f.call(null,G__35938,G__35939));
})();
var inst_35916__$1 = inst_35923;
var state_35930__$1 = (function (){var statearr_35940 = state_35930;
(statearr_35940[(7)] = inst_35916__$1);

return statearr_35940;
})();
var statearr_35941_35954 = state_35930__$1;
(statearr_35941_35954[(2)] = null);

(statearr_35941_35954[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35931 === (7))){
var inst_35926 = (state_35930[(2)]);
var state_35930__$1 = state_35930;
var statearr_35942_35955 = state_35930__$1;
(statearr_35942_35955[(2)] = inst_35926);

(statearr_35942_35955[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11622__auto__))
;
return ((function (switch__11560__auto__,c__11622__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11561__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11561__auto____0 = (function (){
var statearr_35946 = [null,null,null,null,null,null,null,null,null];
(statearr_35946[(0)] = cljs$core$async$reduce_$_state_machine__11561__auto__);

(statearr_35946[(1)] = (1));

return statearr_35946;
});
var cljs$core$async$reduce_$_state_machine__11561__auto____1 = (function (state_35930){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35930);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e35947){if((e35947 instanceof Object)){
var ex__11564__auto__ = e35947;
var statearr_35948_35956 = state_35930;
(statearr_35948_35956[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35930);

return cljs.core.constant$keyword$recur;
} else {
throw e35947;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__35957 = state_35930;
state_35930 = G__35957;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11561__auto__ = function(state_35930){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11561__auto____1.call(this,state_35930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11561__auto____0;
cljs$core$async$reduce_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11561__auto____1;
return cljs$core$async$reduce_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__))
})();
var state__11624__auto__ = (function (){var statearr_35949 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_35949[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_35949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__))
);

return c__11622__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__35959 = arguments.length;
switch (G__35959) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__){
return (function (state_35984){
var state_val_35985 = (state_35984[(1)]);
if((state_val_35985 === (7))){
var inst_35966 = (state_35984[(2)]);
var state_35984__$1 = state_35984;
var statearr_35986_36010 = state_35984__$1;
(statearr_35986_36010[(2)] = inst_35966);

(statearr_35986_36010[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (1))){
var inst_35960 = cljs.core.seq(coll);
var inst_35961 = inst_35960;
var state_35984__$1 = (function (){var statearr_35987 = state_35984;
(statearr_35987[(7)] = inst_35961);

return statearr_35987;
})();
var statearr_35988_36011 = state_35984__$1;
(statearr_35988_36011[(2)] = null);

(statearr_35988_36011[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (4))){
var inst_35961 = (state_35984[(7)]);
var inst_35964 = cljs.core.first(inst_35961);
var state_35984__$1 = state_35984;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35984__$1,(7),ch,inst_35964);
} else {
if((state_val_35985 === (13))){
var inst_35978 = (state_35984[(2)]);
var state_35984__$1 = state_35984;
var statearr_35989_36012 = state_35984__$1;
(statearr_35989_36012[(2)] = inst_35978);

(statearr_35989_36012[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (6))){
var inst_35969 = (state_35984[(2)]);
var state_35984__$1 = state_35984;
if(cljs.core.truth_(inst_35969)){
var statearr_35990_36013 = state_35984__$1;
(statearr_35990_36013[(1)] = (8));

} else {
var statearr_35991_36014 = state_35984__$1;
(statearr_35991_36014[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (3))){
var inst_35982 = (state_35984[(2)]);
var state_35984__$1 = state_35984;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35984__$1,inst_35982);
} else {
if((state_val_35985 === (12))){
var state_35984__$1 = state_35984;
var statearr_35992_36015 = state_35984__$1;
(statearr_35992_36015[(2)] = null);

(statearr_35992_36015[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (2))){
var inst_35961 = (state_35984[(7)]);
var state_35984__$1 = state_35984;
if(cljs.core.truth_(inst_35961)){
var statearr_35993_36016 = state_35984__$1;
(statearr_35993_36016[(1)] = (4));

} else {
var statearr_35994_36017 = state_35984__$1;
(statearr_35994_36017[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (11))){
var inst_35975 = cljs.core.async.close_BANG_(ch);
var state_35984__$1 = state_35984;
var statearr_35995_36018 = state_35984__$1;
(statearr_35995_36018[(2)] = inst_35975);

(statearr_35995_36018[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (9))){
var state_35984__$1 = state_35984;
if(cljs.core.truth_(close_QMARK_)){
var statearr_35996_36019 = state_35984__$1;
(statearr_35996_36019[(1)] = (11));

} else {
var statearr_35997_36020 = state_35984__$1;
(statearr_35997_36020[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (5))){
var inst_35961 = (state_35984[(7)]);
var state_35984__$1 = state_35984;
var statearr_35998_36021 = state_35984__$1;
(statearr_35998_36021[(2)] = inst_35961);

(statearr_35998_36021[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (10))){
var inst_35980 = (state_35984[(2)]);
var state_35984__$1 = state_35984;
var statearr_35999_36022 = state_35984__$1;
(statearr_35999_36022[(2)] = inst_35980);

(statearr_35999_36022[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_35985 === (8))){
var inst_35961 = (state_35984[(7)]);
var inst_35971 = cljs.core.next(inst_35961);
var inst_35961__$1 = inst_35971;
var state_35984__$1 = (function (){var statearr_36000 = state_35984;
(statearr_36000[(7)] = inst_35961__$1);

return statearr_36000;
})();
var statearr_36001_36023 = state_35984__$1;
(statearr_36001_36023[(2)] = null);

(statearr_36001_36023[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto__))
;
return ((function (switch__11560__auto__,c__11622__auto__){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_36005 = [null,null,null,null,null,null,null,null];
(statearr_36005[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_36005[(1)] = (1));

return statearr_36005;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_35984){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_35984);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e36006){if((e36006 instanceof Object)){
var ex__11564__auto__ = e36006;
var statearr_36007_36024 = state_35984;
(statearr_36007_36024[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35984);

return cljs.core.constant$keyword$recur;
} else {
throw e36006;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__36025 = state_35984;
state_35984 = G__36025;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_35984){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_35984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__))
})();
var state__11624__auto__ = (function (){var statearr_36008 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_36008[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_36008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__))
);

return c__11622__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj36027 = {};
return obj36027;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__8170__auto__ = _;
if(and__8170__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__8170__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8818__auto__ = (((_ == null))?null:_);
return (function (){var or__8182__auto__ = (cljs.core.async.muxch_STAR_[(function (){var G__36031 = x__8818__auto__;
return goog.typeOf(G__36031);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj36033 = {};
return obj36033;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.tap_STAR_[(function (){var G__36037 = x__8818__auto__;
return goog.typeOf(G__36037);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.untap_STAR_[(function (){var G__36041 = x__8818__auto__;
return goog.typeOf(G__36041);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.untap_all_STAR_[(function (){var G__36045 = x__8818__auto__;
return goog.typeOf(G__36045);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__36275 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36275) : cljs.core.atom.call(null,G__36275));
})();
var m = (function (){
if(typeof cljs.core.async.t36276 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t36276 = (function (mult,ch,cs,meta36277){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta36277 = meta36277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t36276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_36278,meta36277__$1){
var self__ = this;
var _36278__$1 = this;
return (new cljs.core.async.t36276(self__.mult,self__.ch,self__.cs,meta36277__$1));
});})(cs))
;

cljs.core.async.t36276.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_36278){
var self__ = this;
var _36278__$1 = this;
return self__.meta36277;
});})(cs))
;

cljs.core.async.t36276.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t36276.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t36276.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t36276.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t36276.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t36276.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__36279_36504 = self__.cs;
var G__36280_36505 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__36279_36504,G__36280_36505) : cljs.core.reset_BANG_.call(null,G__36279_36504,G__36280_36505));

return null;
});})(cs))
;

cljs.core.async.t36276.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta36277","meta36277",-642684287,null)], null);
});})(cs))
;

cljs.core.async.t36276.cljs$lang$type = true;

cljs.core.async.t36276.cljs$lang$ctorStr = "cljs.core.async/t36276";

cljs.core.async.t36276.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t36276");
});})(cs))
;

cljs.core.async.__GT_t36276 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t36276(mult__$1,ch__$1,cs__$1,meta36277){
return (new cljs.core.async.t36276(mult__$1,ch__$1,cs__$1,meta36277));
});})(cs))
;

}

return (new cljs.core.async.t36276(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__36281 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36281) : cljs.core.atom.call(null,G__36281));
})();
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11622__auto___36506 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___36506,cs,m,dchan,dctr,done){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___36506,cs,m,dchan,dctr,done){
return (function (state_36412){
var state_val_36413 = (state_36412[(1)]);
if((state_val_36413 === (7))){
var inst_36408 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36414_36507 = state_36412__$1;
(statearr_36414_36507[(2)] = inst_36408);

(statearr_36414_36507[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (20))){
var inst_36313 = (state_36412[(7)]);
var inst_36323 = cljs.core.first(inst_36313);
var inst_36324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36323,(0),null);
var inst_36325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36323,(1),null);
var state_36412__$1 = (function (){var statearr_36415 = state_36412;
(statearr_36415[(8)] = inst_36324);

return statearr_36415;
})();
if(cljs.core.truth_(inst_36325)){
var statearr_36416_36508 = state_36412__$1;
(statearr_36416_36508[(1)] = (22));

} else {
var statearr_36417_36509 = state_36412__$1;
(statearr_36417_36509[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (27))){
var inst_36360 = (state_36412[(9)]);
var inst_36284 = (state_36412[(10)]);
var inst_36355 = (state_36412[(11)]);
var inst_36353 = (state_36412[(12)]);
var inst_36360__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36353,inst_36355);
var inst_36361 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_36360__$1,inst_36284,done);
var state_36412__$1 = (function (){var statearr_36418 = state_36412;
(statearr_36418[(9)] = inst_36360__$1);

return statearr_36418;
})();
if(cljs.core.truth_(inst_36361)){
var statearr_36419_36510 = state_36412__$1;
(statearr_36419_36510[(1)] = (30));

} else {
var statearr_36420_36511 = state_36412__$1;
(statearr_36420_36511[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (1))){
var state_36412__$1 = state_36412;
var statearr_36421_36512 = state_36412__$1;
(statearr_36421_36512[(2)] = null);

(statearr_36421_36512[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (24))){
var inst_36313 = (state_36412[(7)]);
var inst_36330 = (state_36412[(2)]);
var inst_36331 = cljs.core.next(inst_36313);
var inst_36293 = inst_36331;
var inst_36294 = null;
var inst_36295 = (0);
var inst_36296 = (0);
var state_36412__$1 = (function (){var statearr_36422 = state_36412;
(statearr_36422[(13)] = inst_36293);

(statearr_36422[(14)] = inst_36295);

(statearr_36422[(15)] = inst_36294);

(statearr_36422[(16)] = inst_36296);

(statearr_36422[(17)] = inst_36330);

return statearr_36422;
})();
var statearr_36423_36513 = state_36412__$1;
(statearr_36423_36513[(2)] = null);

(statearr_36423_36513[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (39))){
var state_36412__$1 = state_36412;
var statearr_36427_36514 = state_36412__$1;
(statearr_36427_36514[(2)] = null);

(statearr_36427_36514[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (4))){
var inst_36284 = (state_36412[(10)]);
var inst_36284__$1 = (state_36412[(2)]);
var inst_36285 = (inst_36284__$1 == null);
var state_36412__$1 = (function (){var statearr_36428 = state_36412;
(statearr_36428[(10)] = inst_36284__$1);

return statearr_36428;
})();
if(cljs.core.truth_(inst_36285)){
var statearr_36429_36515 = state_36412__$1;
(statearr_36429_36515[(1)] = (5));

} else {
var statearr_36430_36516 = state_36412__$1;
(statearr_36430_36516[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (15))){
var inst_36293 = (state_36412[(13)]);
var inst_36295 = (state_36412[(14)]);
var inst_36294 = (state_36412[(15)]);
var inst_36296 = (state_36412[(16)]);
var inst_36309 = (state_36412[(2)]);
var inst_36310 = (inst_36296 + (1));
var tmp36424 = inst_36293;
var tmp36425 = inst_36295;
var tmp36426 = inst_36294;
var inst_36293__$1 = tmp36424;
var inst_36294__$1 = tmp36426;
var inst_36295__$1 = tmp36425;
var inst_36296__$1 = inst_36310;
var state_36412__$1 = (function (){var statearr_36431 = state_36412;
(statearr_36431[(13)] = inst_36293__$1);

(statearr_36431[(14)] = inst_36295__$1);

(statearr_36431[(15)] = inst_36294__$1);

(statearr_36431[(18)] = inst_36309);

(statearr_36431[(16)] = inst_36296__$1);

return statearr_36431;
})();
var statearr_36432_36517 = state_36412__$1;
(statearr_36432_36517[(2)] = null);

(statearr_36432_36517[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (21))){
var inst_36334 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36436_36518 = state_36412__$1;
(statearr_36436_36518[(2)] = inst_36334);

(statearr_36436_36518[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (31))){
var inst_36360 = (state_36412[(9)]);
var inst_36364 = done(null);
var inst_36365 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_36360);
var state_36412__$1 = (function (){var statearr_36437 = state_36412;
(statearr_36437[(19)] = inst_36364);

return statearr_36437;
})();
var statearr_36438_36519 = state_36412__$1;
(statearr_36438_36519[(2)] = inst_36365);

(statearr_36438_36519[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (32))){
var inst_36352 = (state_36412[(20)]);
var inst_36355 = (state_36412[(11)]);
var inst_36353 = (state_36412[(12)]);
var inst_36354 = (state_36412[(21)]);
var inst_36367 = (state_36412[(2)]);
var inst_36368 = (inst_36355 + (1));
var tmp36433 = inst_36352;
var tmp36434 = inst_36353;
var tmp36435 = inst_36354;
var inst_36352__$1 = tmp36433;
var inst_36353__$1 = tmp36434;
var inst_36354__$1 = tmp36435;
var inst_36355__$1 = inst_36368;
var state_36412__$1 = (function (){var statearr_36439 = state_36412;
(statearr_36439[(20)] = inst_36352__$1);

(statearr_36439[(11)] = inst_36355__$1);

(statearr_36439[(12)] = inst_36353__$1);

(statearr_36439[(21)] = inst_36354__$1);

(statearr_36439[(22)] = inst_36367);

return statearr_36439;
})();
var statearr_36440_36520 = state_36412__$1;
(statearr_36440_36520[(2)] = null);

(statearr_36440_36520[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (40))){
var inst_36380 = (state_36412[(23)]);
var inst_36384 = done(null);
var inst_36385 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_36380);
var state_36412__$1 = (function (){var statearr_36441 = state_36412;
(statearr_36441[(24)] = inst_36384);

return statearr_36441;
})();
var statearr_36442_36521 = state_36412__$1;
(statearr_36442_36521[(2)] = inst_36385);

(statearr_36442_36521[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (33))){
var inst_36371 = (state_36412[(25)]);
var inst_36373 = cljs.core.chunked_seq_QMARK_(inst_36371);
var state_36412__$1 = state_36412;
if(inst_36373){
var statearr_36443_36522 = state_36412__$1;
(statearr_36443_36522[(1)] = (36));

} else {
var statearr_36444_36523 = state_36412__$1;
(statearr_36444_36523[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (13))){
var inst_36303 = (state_36412[(26)]);
var inst_36306 = cljs.core.async.close_BANG_(inst_36303);
var state_36412__$1 = state_36412;
var statearr_36445_36524 = state_36412__$1;
(statearr_36445_36524[(2)] = inst_36306);

(statearr_36445_36524[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (22))){
var inst_36324 = (state_36412[(8)]);
var inst_36327 = cljs.core.async.close_BANG_(inst_36324);
var state_36412__$1 = state_36412;
var statearr_36446_36525 = state_36412__$1;
(statearr_36446_36525[(2)] = inst_36327);

(statearr_36446_36525[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (36))){
var inst_36371 = (state_36412[(25)]);
var inst_36375 = cljs.core.chunk_first(inst_36371);
var inst_36376 = cljs.core.chunk_rest(inst_36371);
var inst_36377 = cljs.core.count(inst_36375);
var inst_36352 = inst_36376;
var inst_36353 = inst_36375;
var inst_36354 = inst_36377;
var inst_36355 = (0);
var state_36412__$1 = (function (){var statearr_36447 = state_36412;
(statearr_36447[(20)] = inst_36352);

(statearr_36447[(11)] = inst_36355);

(statearr_36447[(12)] = inst_36353);

(statearr_36447[(21)] = inst_36354);

return statearr_36447;
})();
var statearr_36448_36526 = state_36412__$1;
(statearr_36448_36526[(2)] = null);

(statearr_36448_36526[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (41))){
var inst_36371 = (state_36412[(25)]);
var inst_36387 = (state_36412[(2)]);
var inst_36388 = cljs.core.next(inst_36371);
var inst_36352 = inst_36388;
var inst_36353 = null;
var inst_36354 = (0);
var inst_36355 = (0);
var state_36412__$1 = (function (){var statearr_36449 = state_36412;
(statearr_36449[(20)] = inst_36352);

(statearr_36449[(11)] = inst_36355);

(statearr_36449[(12)] = inst_36353);

(statearr_36449[(21)] = inst_36354);

(statearr_36449[(27)] = inst_36387);

return statearr_36449;
})();
var statearr_36450_36527 = state_36412__$1;
(statearr_36450_36527[(2)] = null);

(statearr_36450_36527[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (43))){
var state_36412__$1 = state_36412;
var statearr_36451_36528 = state_36412__$1;
(statearr_36451_36528[(2)] = null);

(statearr_36451_36528[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (29))){
var inst_36396 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36452_36529 = state_36412__$1;
(statearr_36452_36529[(2)] = inst_36396);

(statearr_36452_36529[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (44))){
var inst_36405 = (state_36412[(2)]);
var state_36412__$1 = (function (){var statearr_36453 = state_36412;
(statearr_36453[(28)] = inst_36405);

return statearr_36453;
})();
var statearr_36454_36530 = state_36412__$1;
(statearr_36454_36530[(2)] = null);

(statearr_36454_36530[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (6))){
var inst_36344 = (state_36412[(29)]);
var inst_36343 = (function (){var G__36455 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36455) : cljs.core.deref.call(null,G__36455));
})();
var inst_36344__$1 = cljs.core.keys(inst_36343);
var inst_36345 = cljs.core.count(inst_36344__$1);
var inst_36346 = (function (){var G__36456 = dctr;
var G__36457 = inst_36345;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__36456,G__36457) : cljs.core.reset_BANG_.call(null,G__36456,G__36457));
})();
var inst_36351 = cljs.core.seq(inst_36344__$1);
var inst_36352 = inst_36351;
var inst_36353 = null;
var inst_36354 = (0);
var inst_36355 = (0);
var state_36412__$1 = (function (){var statearr_36458 = state_36412;
(statearr_36458[(30)] = inst_36346);

(statearr_36458[(20)] = inst_36352);

(statearr_36458[(11)] = inst_36355);

(statearr_36458[(12)] = inst_36353);

(statearr_36458[(29)] = inst_36344__$1);

(statearr_36458[(21)] = inst_36354);

return statearr_36458;
})();
var statearr_36459_36531 = state_36412__$1;
(statearr_36459_36531[(2)] = null);

(statearr_36459_36531[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (28))){
var inst_36371 = (state_36412[(25)]);
var inst_36352 = (state_36412[(20)]);
var inst_36371__$1 = cljs.core.seq(inst_36352);
var state_36412__$1 = (function (){var statearr_36460 = state_36412;
(statearr_36460[(25)] = inst_36371__$1);

return statearr_36460;
})();
if(inst_36371__$1){
var statearr_36461_36532 = state_36412__$1;
(statearr_36461_36532[(1)] = (33));

} else {
var statearr_36462_36533 = state_36412__$1;
(statearr_36462_36533[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (25))){
var inst_36355 = (state_36412[(11)]);
var inst_36354 = (state_36412[(21)]);
var inst_36357 = (inst_36355 < inst_36354);
var inst_36358 = inst_36357;
var state_36412__$1 = state_36412;
if(cljs.core.truth_(inst_36358)){
var statearr_36463_36534 = state_36412__$1;
(statearr_36463_36534[(1)] = (27));

} else {
var statearr_36464_36535 = state_36412__$1;
(statearr_36464_36535[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (34))){
var state_36412__$1 = state_36412;
var statearr_36465_36536 = state_36412__$1;
(statearr_36465_36536[(2)] = null);

(statearr_36465_36536[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (17))){
var state_36412__$1 = state_36412;
var statearr_36466_36537 = state_36412__$1;
(statearr_36466_36537[(2)] = null);

(statearr_36466_36537[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (3))){
var inst_36410 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36412__$1,inst_36410);
} else {
if((state_val_36413 === (12))){
var inst_36339 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36467_36538 = state_36412__$1;
(statearr_36467_36538[(2)] = inst_36339);

(statearr_36467_36538[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (2))){
var state_36412__$1 = state_36412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36412__$1,(4),ch);
} else {
if((state_val_36413 === (23))){
var state_36412__$1 = state_36412;
var statearr_36468_36539 = state_36412__$1;
(statearr_36468_36539[(2)] = null);

(statearr_36468_36539[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (35))){
var inst_36394 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36469_36540 = state_36412__$1;
(statearr_36469_36540[(2)] = inst_36394);

(statearr_36469_36540[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (19))){
var inst_36313 = (state_36412[(7)]);
var inst_36317 = cljs.core.chunk_first(inst_36313);
var inst_36318 = cljs.core.chunk_rest(inst_36313);
var inst_36319 = cljs.core.count(inst_36317);
var inst_36293 = inst_36318;
var inst_36294 = inst_36317;
var inst_36295 = inst_36319;
var inst_36296 = (0);
var state_36412__$1 = (function (){var statearr_36470 = state_36412;
(statearr_36470[(13)] = inst_36293);

(statearr_36470[(14)] = inst_36295);

(statearr_36470[(15)] = inst_36294);

(statearr_36470[(16)] = inst_36296);

return statearr_36470;
})();
var statearr_36471_36541 = state_36412__$1;
(statearr_36471_36541[(2)] = null);

(statearr_36471_36541[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (11))){
var inst_36293 = (state_36412[(13)]);
var inst_36313 = (state_36412[(7)]);
var inst_36313__$1 = cljs.core.seq(inst_36293);
var state_36412__$1 = (function (){var statearr_36472 = state_36412;
(statearr_36472[(7)] = inst_36313__$1);

return statearr_36472;
})();
if(inst_36313__$1){
var statearr_36473_36542 = state_36412__$1;
(statearr_36473_36542[(1)] = (16));

} else {
var statearr_36474_36543 = state_36412__$1;
(statearr_36474_36543[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (9))){
var inst_36341 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36475_36544 = state_36412__$1;
(statearr_36475_36544[(2)] = inst_36341);

(statearr_36475_36544[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (5))){
var inst_36291 = (function (){var G__36476 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36476) : cljs.core.deref.call(null,G__36476));
})();
var inst_36292 = cljs.core.seq(inst_36291);
var inst_36293 = inst_36292;
var inst_36294 = null;
var inst_36295 = (0);
var inst_36296 = (0);
var state_36412__$1 = (function (){var statearr_36477 = state_36412;
(statearr_36477[(13)] = inst_36293);

(statearr_36477[(14)] = inst_36295);

(statearr_36477[(15)] = inst_36294);

(statearr_36477[(16)] = inst_36296);

return statearr_36477;
})();
var statearr_36478_36545 = state_36412__$1;
(statearr_36478_36545[(2)] = null);

(statearr_36478_36545[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (14))){
var state_36412__$1 = state_36412;
var statearr_36479_36546 = state_36412__$1;
(statearr_36479_36546[(2)] = null);

(statearr_36479_36546[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (45))){
var inst_36402 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36480_36547 = state_36412__$1;
(statearr_36480_36547[(2)] = inst_36402);

(statearr_36480_36547[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (26))){
var inst_36344 = (state_36412[(29)]);
var inst_36398 = (state_36412[(2)]);
var inst_36399 = cljs.core.seq(inst_36344);
var state_36412__$1 = (function (){var statearr_36481 = state_36412;
(statearr_36481[(31)] = inst_36398);

return statearr_36481;
})();
if(inst_36399){
var statearr_36482_36548 = state_36412__$1;
(statearr_36482_36548[(1)] = (42));

} else {
var statearr_36483_36549 = state_36412__$1;
(statearr_36483_36549[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (16))){
var inst_36313 = (state_36412[(7)]);
var inst_36315 = cljs.core.chunked_seq_QMARK_(inst_36313);
var state_36412__$1 = state_36412;
if(inst_36315){
var statearr_36484_36550 = state_36412__$1;
(statearr_36484_36550[(1)] = (19));

} else {
var statearr_36485_36551 = state_36412__$1;
(statearr_36485_36551[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (38))){
var inst_36391 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36486_36552 = state_36412__$1;
(statearr_36486_36552[(2)] = inst_36391);

(statearr_36486_36552[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (30))){
var state_36412__$1 = state_36412;
var statearr_36487_36553 = state_36412__$1;
(statearr_36487_36553[(2)] = null);

(statearr_36487_36553[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (10))){
var inst_36294 = (state_36412[(15)]);
var inst_36296 = (state_36412[(16)]);
var inst_36302 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36294,inst_36296);
var inst_36303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36302,(0),null);
var inst_36304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36302,(1),null);
var state_36412__$1 = (function (){var statearr_36488 = state_36412;
(statearr_36488[(26)] = inst_36303);

return statearr_36488;
})();
if(cljs.core.truth_(inst_36304)){
var statearr_36489_36554 = state_36412__$1;
(statearr_36489_36554[(1)] = (13));

} else {
var statearr_36490_36555 = state_36412__$1;
(statearr_36490_36555[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (18))){
var inst_36337 = (state_36412[(2)]);
var state_36412__$1 = state_36412;
var statearr_36491_36556 = state_36412__$1;
(statearr_36491_36556[(2)] = inst_36337);

(statearr_36491_36556[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (42))){
var state_36412__$1 = state_36412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36412__$1,(45),dchan);
} else {
if((state_val_36413 === (37))){
var inst_36371 = (state_36412[(25)]);
var inst_36284 = (state_36412[(10)]);
var inst_36380 = (state_36412[(23)]);
var inst_36380__$1 = cljs.core.first(inst_36371);
var inst_36381 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_36380__$1,inst_36284,done);
var state_36412__$1 = (function (){var statearr_36492 = state_36412;
(statearr_36492[(23)] = inst_36380__$1);

return statearr_36492;
})();
if(cljs.core.truth_(inst_36381)){
var statearr_36493_36557 = state_36412__$1;
(statearr_36493_36557[(1)] = (39));

} else {
var statearr_36494_36558 = state_36412__$1;
(statearr_36494_36558[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36413 === (8))){
var inst_36295 = (state_36412[(14)]);
var inst_36296 = (state_36412[(16)]);
var inst_36298 = (inst_36296 < inst_36295);
var inst_36299 = inst_36298;
var state_36412__$1 = state_36412;
if(cljs.core.truth_(inst_36299)){
var statearr_36495_36559 = state_36412__$1;
(statearr_36495_36559[(1)] = (10));

} else {
var statearr_36496_36560 = state_36412__$1;
(statearr_36496_36560[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___36506,cs,m,dchan,dctr,done))
;
return ((function (switch__11560__auto__,c__11622__auto___36506,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11561__auto__ = null;
var cljs$core$async$mult_$_state_machine__11561__auto____0 = (function (){
var statearr_36500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36500[(0)] = cljs$core$async$mult_$_state_machine__11561__auto__);

(statearr_36500[(1)] = (1));

return statearr_36500;
});
var cljs$core$async$mult_$_state_machine__11561__auto____1 = (function (state_36412){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_36412);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e36501){if((e36501 instanceof Object)){
var ex__11564__auto__ = e36501;
var statearr_36502_36561 = state_36412;
(statearr_36502_36561[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36412);

return cljs.core.constant$keyword$recur;
} else {
throw e36501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__36562 = state_36412;
state_36412 = G__36562;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11561__auto__ = function(state_36412){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11561__auto____1.call(this,state_36412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11561__auto____0;
cljs$core$async$mult_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11561__auto____1;
return cljs$core$async$mult_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___36506,cs,m,dchan,dctr,done))
})();
var state__11624__auto__ = (function (){var statearr_36503 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_36503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___36506);

return statearr_36503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___36506,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__36564 = arguments.length;
switch (G__36564) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = (function (){var obj36567 = {};
return obj36567;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.admix_STAR_[(function (){var G__36571 = x__8818__auto__;
return goog.typeOf(G__36571);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.unmix_STAR_[(function (){var G__36575 = x__8818__auto__;
return goog.typeOf(G__36575);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.unmix_all_STAR_[(function (){var G__36579 = x__8818__auto__;
return goog.typeOf(G__36579);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.toggle_STAR_[(function (){var G__36583 = x__8818__auto__;
return goog.typeOf(G__36583);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__8170__auto__ = m;
if(and__8170__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8818__auto__ = (((m == null))?null:m);
return (function (){var or__8182__auto__ = (cljs.core.async.solo_mode_STAR_[(function (){var G__36587 = x__8818__auto__;
return goog.typeOf(G__36587);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__9222__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9222__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__36592){
var map__36593 = p__36592;
var map__36593__$1 = ((cljs.core.seq_QMARK_(map__36593))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36593):map__36593);
var opts = map__36593__$1;
var statearr_36594_36598 = state;
(statearr_36594_36598[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__36593,map__36593__$1,opts){
return (function (val){
var statearr_36595_36599 = state;
(statearr_36595_36599[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__36593,map__36593__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_36596_36600 = state;
(statearr_36596_36600[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__36597 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36597) : cljs.core.deref.call(null,G__36597));
})());


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq36588){
var G__36589 = cljs.core.first(seq36588);
var seq36588__$1 = cljs.core.next(seq36588);
var G__36590 = cljs.core.first(seq36588__$1);
var seq36588__$2 = cljs.core.next(seq36588__$1);
var G__36591 = cljs.core.first(seq36588__$2);
var seq36588__$3 = cljs.core.next(seq36588__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36589,G__36590,G__36591,seq36588__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__36734 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36734) : cljs.core.atom.call(null,G__36734));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (function (){var G__36735 = cljs.core.constant$keyword$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36735) : cljs.core.atom.call(null,G__36735));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((function (){var G__36736 = v;
return (attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(G__36736) : attr.call(null,G__36736));
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (function (){var G__36737 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36737) : cljs.core.deref.call(null,G__36737));
})();
var mode = (function (){var G__36738 = solo_mode;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36738) : cljs.core.deref.call(null,G__36738));
})();
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t36739 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t36739 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta36740){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta36740 = meta36740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t36739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_36741,meta36740__$1){
var self__ = this;
var _36741__$1 = this;
return (new cljs.core.async.t36739(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta36740__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_36741){
var self__ = this;
var _36741__$1 = this;
return self__.meta36740;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t36739.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__36742_36867 = self__.cs;
var G__36743_36868 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__36742_36867,G__36743_36868) : cljs.core.reset_BANG_.call(null,G__36742_36867,G__36743_36868));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__36744 = mode;
return (self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(G__36744) : self__.solo_modes.call(null,G__36744));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

var G__36745_36869 = self__.solo_mode;
var G__36746_36870 = mode;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__36745_36869,G__36746_36870) : cljs.core.reset_BANG_.call(null,G__36745_36869,G__36746_36870));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta36740","meta36740",-484410789,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t36739.cljs$lang$type = true;

cljs.core.async.t36739.cljs$lang$ctorStr = "cljs.core.async/t36739";

cljs.core.async.t36739.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t36739");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t36739 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t36739(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta36740){
return (new cljs.core.async.t36739(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta36740));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t36739(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11622__auto___36871 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_36818){
var state_val_36819 = (state_36818[(1)]);
if((state_val_36819 === (7))){
var inst_36760 = (state_36818[(7)]);
var inst_36765 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36760);
var state_36818__$1 = state_36818;
var statearr_36820_36872 = state_36818__$1;
(statearr_36820_36872[(2)] = inst_36765);

(statearr_36820_36872[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (20))){
var inst_36775 = (state_36818[(8)]);
var state_36818__$1 = state_36818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36818__$1,(23),out,inst_36775);
} else {
if((state_val_36819 === (1))){
var inst_36750 = (state_36818[(9)]);
var inst_36750__$1 = calc_state();
var inst_36751 = cljs.core.seq_QMARK_(inst_36750__$1);
var state_36818__$1 = (function (){var statearr_36821 = state_36818;
(statearr_36821[(9)] = inst_36750__$1);

return statearr_36821;
})();
if(inst_36751){
var statearr_36822_36873 = state_36818__$1;
(statearr_36822_36873[(1)] = (2));

} else {
var statearr_36823_36874 = state_36818__$1;
(statearr_36823_36874[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (24))){
var inst_36768 = (state_36818[(10)]);
var inst_36760 = inst_36768;
var state_36818__$1 = (function (){var statearr_36824 = state_36818;
(statearr_36824[(7)] = inst_36760);

return statearr_36824;
})();
var statearr_36825_36875 = state_36818__$1;
(statearr_36825_36875[(2)] = null);

(statearr_36825_36875[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (4))){
var inst_36750 = (state_36818[(9)]);
var inst_36756 = (state_36818[(2)]);
var inst_36757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36756,cljs.core.constant$keyword$solos);
var inst_36758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36756,cljs.core.constant$keyword$mutes);
var inst_36759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36756,cljs.core.constant$keyword$reads);
var inst_36760 = inst_36750;
var state_36818__$1 = (function (){var statearr_36826 = state_36818;
(statearr_36826[(11)] = inst_36757);

(statearr_36826[(12)] = inst_36759);

(statearr_36826[(13)] = inst_36758);

(statearr_36826[(7)] = inst_36760);

return statearr_36826;
})();
var statearr_36827_36876 = state_36818__$1;
(statearr_36827_36876[(2)] = null);

(statearr_36827_36876[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (15))){
var state_36818__$1 = state_36818;
var statearr_36828_36877 = state_36818__$1;
(statearr_36828_36877[(2)] = null);

(statearr_36828_36877[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (21))){
var inst_36768 = (state_36818[(10)]);
var inst_36760 = inst_36768;
var state_36818__$1 = (function (){var statearr_36829 = state_36818;
(statearr_36829[(7)] = inst_36760);

return statearr_36829;
})();
var statearr_36830_36878 = state_36818__$1;
(statearr_36830_36878[(2)] = null);

(statearr_36830_36878[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (13))){
var inst_36814 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
var statearr_36831_36879 = state_36818__$1;
(statearr_36831_36879[(2)] = inst_36814);

(statearr_36831_36879[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (22))){
var inst_36812 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
var statearr_36832_36880 = state_36818__$1;
(statearr_36832_36880[(2)] = inst_36812);

(statearr_36832_36880[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (6))){
var inst_36816 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36818__$1,inst_36816);
} else {
if((state_val_36819 === (25))){
var state_36818__$1 = state_36818;
var statearr_36833_36881 = state_36818__$1;
(statearr_36833_36881[(2)] = null);

(statearr_36833_36881[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (17))){
var inst_36791 = (state_36818[(14)]);
var state_36818__$1 = state_36818;
var statearr_36834_36882 = state_36818__$1;
(statearr_36834_36882[(2)] = inst_36791);

(statearr_36834_36882[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (3))){
var inst_36750 = (state_36818[(9)]);
var state_36818__$1 = state_36818;
var statearr_36835_36883 = state_36818__$1;
(statearr_36835_36883[(2)] = inst_36750);

(statearr_36835_36883[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (12))){
var inst_36791 = (state_36818[(14)]);
var inst_36769 = (state_36818[(15)]);
var inst_36776 = (state_36818[(16)]);
var inst_36791__$1 = (function (){var G__36836 = inst_36776;
return (inst_36769.cljs$core$IFn$_invoke$arity$1 ? inst_36769.cljs$core$IFn$_invoke$arity$1(G__36836) : inst_36769.call(null,G__36836));
})();
var state_36818__$1 = (function (){var statearr_36837 = state_36818;
(statearr_36837[(14)] = inst_36791__$1);

return statearr_36837;
})();
if(cljs.core.truth_(inst_36791__$1)){
var statearr_36838_36884 = state_36818__$1;
(statearr_36838_36884[(1)] = (17));

} else {
var statearr_36839_36885 = state_36818__$1;
(statearr_36839_36885[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (2))){
var inst_36750 = (state_36818[(9)]);
var inst_36753 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36750);
var state_36818__$1 = state_36818;
var statearr_36840_36886 = state_36818__$1;
(statearr_36840_36886[(2)] = inst_36753);

(statearr_36840_36886[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (23))){
var inst_36803 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
if(cljs.core.truth_(inst_36803)){
var statearr_36841_36887 = state_36818__$1;
(statearr_36841_36887[(1)] = (24));

} else {
var statearr_36842_36888 = state_36818__$1;
(statearr_36842_36888[(1)] = (25));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (19))){
var inst_36800 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
if(cljs.core.truth_(inst_36800)){
var statearr_36843_36889 = state_36818__$1;
(statearr_36843_36889[(1)] = (20));

} else {
var statearr_36844_36890 = state_36818__$1;
(statearr_36844_36890[(1)] = (21));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (11))){
var inst_36775 = (state_36818[(8)]);
var inst_36781 = (inst_36775 == null);
var state_36818__$1 = state_36818;
if(cljs.core.truth_(inst_36781)){
var statearr_36845_36891 = state_36818__$1;
(statearr_36845_36891[(1)] = (14));

} else {
var statearr_36846_36892 = state_36818__$1;
(statearr_36846_36892[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (9))){
var inst_36768 = (state_36818[(10)]);
var inst_36768__$1 = (state_36818[(2)]);
var inst_36769 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36768__$1,cljs.core.constant$keyword$solos);
var inst_36770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36768__$1,cljs.core.constant$keyword$mutes);
var inst_36771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36768__$1,cljs.core.constant$keyword$reads);
var state_36818__$1 = (function (){var statearr_36847 = state_36818;
(statearr_36847[(10)] = inst_36768__$1);

(statearr_36847[(17)] = inst_36770);

(statearr_36847[(15)] = inst_36769);

return statearr_36847;
})();
return cljs.core.async.ioc_alts_BANG_(state_36818__$1,(10),inst_36771);
} else {
if((state_val_36819 === (5))){
var inst_36760 = (state_36818[(7)]);
var inst_36763 = cljs.core.seq_QMARK_(inst_36760);
var state_36818__$1 = state_36818;
if(inst_36763){
var statearr_36848_36893 = state_36818__$1;
(statearr_36848_36893[(1)] = (7));

} else {
var statearr_36849_36894 = state_36818__$1;
(statearr_36849_36894[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (14))){
var inst_36776 = (state_36818[(16)]);
var inst_36783 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_36776);
var state_36818__$1 = state_36818;
var statearr_36850_36895 = state_36818__$1;
(statearr_36850_36895[(2)] = inst_36783);

(statearr_36850_36895[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (26))){
var inst_36808 = (state_36818[(2)]);
var state_36818__$1 = state_36818;
var statearr_36851_36896 = state_36818__$1;
(statearr_36851_36896[(2)] = inst_36808);

(statearr_36851_36896[(1)] = (22));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (16))){
var inst_36786 = (state_36818[(2)]);
var inst_36787 = calc_state();
var inst_36760 = inst_36787;
var state_36818__$1 = (function (){var statearr_36852 = state_36818;
(statearr_36852[(18)] = inst_36786);

(statearr_36852[(7)] = inst_36760);

return statearr_36852;
})();
var statearr_36853_36897 = state_36818__$1;
(statearr_36853_36897[(2)] = null);

(statearr_36853_36897[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (10))){
var inst_36776 = (state_36818[(16)]);
var inst_36775 = (state_36818[(8)]);
var inst_36774 = (state_36818[(2)]);
var inst_36775__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36774,(0),null);
var inst_36776__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36774,(1),null);
var inst_36777 = (inst_36775__$1 == null);
var inst_36778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36776__$1,change);
var inst_36779 = (inst_36777) || (inst_36778);
var state_36818__$1 = (function (){var statearr_36854 = state_36818;
(statearr_36854[(16)] = inst_36776__$1);

(statearr_36854[(8)] = inst_36775__$1);

return statearr_36854;
})();
if(cljs.core.truth_(inst_36779)){
var statearr_36855_36898 = state_36818__$1;
(statearr_36855_36898[(1)] = (11));

} else {
var statearr_36856_36899 = state_36818__$1;
(statearr_36856_36899[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (18))){
var inst_36770 = (state_36818[(17)]);
var inst_36769 = (state_36818[(15)]);
var inst_36776 = (state_36818[(16)]);
var inst_36795 = cljs.core.empty_QMARK_(inst_36769);
var inst_36796 = (function (){var G__36857 = inst_36776;
return (inst_36770.cljs$core$IFn$_invoke$arity$1 ? inst_36770.cljs$core$IFn$_invoke$arity$1(G__36857) : inst_36770.call(null,G__36857));
})();
var inst_36797 = cljs.core.not(inst_36796);
var inst_36798 = (inst_36795) && (inst_36797);
var state_36818__$1 = state_36818;
var statearr_36858_36900 = state_36818__$1;
(statearr_36858_36900[(2)] = inst_36798);

(statearr_36858_36900[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_36819 === (8))){
var inst_36760 = (state_36818[(7)]);
var state_36818__$1 = state_36818;
var statearr_36859_36901 = state_36818__$1;
(statearr_36859_36901[(2)] = inst_36760);

(statearr_36859_36901[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11560__auto__,c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11561__auto__ = null;
var cljs$core$async$mix_$_state_machine__11561__auto____0 = (function (){
var statearr_36863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36863[(0)] = cljs$core$async$mix_$_state_machine__11561__auto__);

(statearr_36863[(1)] = (1));

return statearr_36863;
});
var cljs$core$async$mix_$_state_machine__11561__auto____1 = (function (state_36818){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_36818);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e36864){if((e36864 instanceof Object)){
var ex__11564__auto__ = e36864;
var statearr_36865_36902 = state_36818;
(statearr_36865_36902[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36818);

return cljs.core.constant$keyword$recur;
} else {
throw e36864;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__36903 = state_36818;
state_36818 = G__36903;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11561__auto__ = function(state_36818){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11561__auto____1.call(this,state_36818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11561__auto____0;
cljs$core$async$mix_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11561__auto____1;
return cljs$core$async$mix_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11624__auto__ = (function (){var statearr_36866 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_36866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___36871);

return statearr_36866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___36871,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = (function (){var obj36905 = {};
return obj36905;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__8170__auto__ = p;
if(and__8170__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__8170__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8818__auto__ = (((p == null))?null:p);
return (function (){var or__8182__auto__ = (cljs.core.async.sub_STAR_[(function (){var G__36909 = x__8818__auto__;
return goog.typeOf(G__36909);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__8170__auto__ = p;
if(and__8170__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__8170__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8818__auto__ = (((p == null))?null:p);
return (function (){var or__8182__auto__ = (cljs.core.async.unsub_STAR_[(function (){var G__36913 = x__8818__auto__;
return goog.typeOf(G__36913);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__36915 = arguments.length;
switch (G__36915) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__8170__auto__ = p;
if(and__8170__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__8170__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8818__auto__ = (((p == null))?null:p);
return (function (){var or__8182__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__36917 = x__8818__auto__;
return goog.typeOf(G__36917);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__8170__auto__ = p;
if(and__8170__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__8170__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8818__auto__ = (((p == null))?null:p);
return (function (){var or__8182__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__36919 = x__8818__auto__;
return goog.typeOf(G__36919);
})()]);
if(or__8182__auto__){
return or__8182__auto__;
} else {
var or__8182__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__8182__auto____$1){
return or__8182__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__36923 = arguments.length;
switch (G__36923) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__36924 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36924) : cljs.core.atom.call(null,G__36924));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__8182__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__36926 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36926) : cljs.core.deref.call(null,G__36926));
})(),topic);
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8182__auto__,mults){
return (function (p1__36921_SHARP_){
if(cljs.core.truth_((function (){var G__36927 = topic;
return (p1__36921_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__36921_SHARP_.cljs$core$IFn$_invoke$arity$1(G__36927) : p1__36921_SHARP_.call(null,G__36927));
})())){
return p1__36921_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__36921_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((function (){var G__36928 = topic;
return (buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(G__36928) : buf_fn.call(null,G__36928));
})())));
}
});})(or__8182__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t36929 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t36929 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta36930){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta36930 = meta36930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t36929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_36931,meta36930__$1){
var self__ = this;
var _36931__$1 = this;
return (new cljs.core.async.t36929(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta36930__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_36931){
var self__ = this;
var _36931__$1 = this;
return self__.meta36930;
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t36929.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t36929.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (function (){var G__36932 = topic;
return (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(G__36932) : self__.ensure_mult.call(null,G__36932));
})();
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__36933 = self__.mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__36933) : cljs.core.deref.call(null,G__36933));
})(),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__36934 = self__.mults;
var G__36935 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__36934,G__36935) : cljs.core.reset_BANG_.call(null,G__36934,G__36935));
});})(mults,ensure_mult))
;

cljs.core.async.t36929.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t36929.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta36930","meta36930",-1097172633,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t36929.cljs$lang$type = true;

cljs.core.async.t36929.cljs$lang$ctorStr = "cljs.core.async/t36929";

cljs.core.async.t36929.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t36929");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t36929 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t36929(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta36930){
return (new cljs.core.async.t36929(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta36930));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t36929(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11622__auto___37059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37059,mults,ensure_mult,p){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37059,mults,ensure_mult,p){
return (function (state_37007){
var state_val_37008 = (state_37007[(1)]);
if((state_val_37008 === (7))){
var inst_37003 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37009_37060 = state_37007__$1;
(statearr_37009_37060[(2)] = inst_37003);

(statearr_37009_37060[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (20))){
var state_37007__$1 = state_37007;
var statearr_37010_37061 = state_37007__$1;
(statearr_37010_37061[(2)] = null);

(statearr_37010_37061[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (1))){
var state_37007__$1 = state_37007;
var statearr_37011_37062 = state_37007__$1;
(statearr_37011_37062[(2)] = null);

(statearr_37011_37062[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (24))){
var inst_36986 = (state_37007[(7)]);
var inst_36995 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_36986);
var state_37007__$1 = state_37007;
var statearr_37012_37063 = state_37007__$1;
(statearr_37012_37063[(2)] = inst_36995);

(statearr_37012_37063[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (4))){
var inst_36938 = (state_37007[(8)]);
var inst_36938__$1 = (state_37007[(2)]);
var inst_36939 = (inst_36938__$1 == null);
var state_37007__$1 = (function (){var statearr_37013 = state_37007;
(statearr_37013[(8)] = inst_36938__$1);

return statearr_37013;
})();
if(cljs.core.truth_(inst_36939)){
var statearr_37014_37064 = state_37007__$1;
(statearr_37014_37064[(1)] = (5));

} else {
var statearr_37015_37065 = state_37007__$1;
(statearr_37015_37065[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (15))){
var inst_36980 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37016_37066 = state_37007__$1;
(statearr_37016_37066[(2)] = inst_36980);

(statearr_37016_37066[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (21))){
var inst_37000 = (state_37007[(2)]);
var state_37007__$1 = (function (){var statearr_37017 = state_37007;
(statearr_37017[(9)] = inst_37000);

return statearr_37017;
})();
var statearr_37018_37067 = state_37007__$1;
(statearr_37018_37067[(2)] = null);

(statearr_37018_37067[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (13))){
var inst_36962 = (state_37007[(10)]);
var inst_36964 = cljs.core.chunked_seq_QMARK_(inst_36962);
var state_37007__$1 = state_37007;
if(inst_36964){
var statearr_37019_37068 = state_37007__$1;
(statearr_37019_37068[(1)] = (16));

} else {
var statearr_37020_37069 = state_37007__$1;
(statearr_37020_37069[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (22))){
var inst_36992 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
if(cljs.core.truth_(inst_36992)){
var statearr_37021_37070 = state_37007__$1;
(statearr_37021_37070[(1)] = (23));

} else {
var statearr_37022_37071 = state_37007__$1;
(statearr_37022_37071[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (6))){
var inst_36938 = (state_37007[(8)]);
var inst_36988 = (state_37007[(11)]);
var inst_36986 = (state_37007[(7)]);
var inst_36986__$1 = (function (){var G__37023 = inst_36938;
return (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(G__37023) : topic_fn.call(null,G__37023));
})();
var inst_36987 = (function (){var G__37024 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__37024) : cljs.core.deref.call(null,G__37024));
})();
var inst_36988__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36987,inst_36986__$1);
var state_37007__$1 = (function (){var statearr_37025 = state_37007;
(statearr_37025[(11)] = inst_36988__$1);

(statearr_37025[(7)] = inst_36986__$1);

return statearr_37025;
})();
if(cljs.core.truth_(inst_36988__$1)){
var statearr_37026_37072 = state_37007__$1;
(statearr_37026_37072[(1)] = (19));

} else {
var statearr_37027_37073 = state_37007__$1;
(statearr_37027_37073[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (25))){
var inst_36997 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37028_37074 = state_37007__$1;
(statearr_37028_37074[(2)] = inst_36997);

(statearr_37028_37074[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (17))){
var inst_36962 = (state_37007[(10)]);
var inst_36971 = cljs.core.first(inst_36962);
var inst_36972 = cljs.core.async.muxch_STAR_(inst_36971);
var inst_36973 = cljs.core.async.close_BANG_(inst_36972);
var inst_36974 = cljs.core.next(inst_36962);
var inst_36948 = inst_36974;
var inst_36949 = null;
var inst_36950 = (0);
var inst_36951 = (0);
var state_37007__$1 = (function (){var statearr_37029 = state_37007;
(statearr_37029[(12)] = inst_36973);

(statearr_37029[(13)] = inst_36948);

(statearr_37029[(14)] = inst_36951);

(statearr_37029[(15)] = inst_36950);

(statearr_37029[(16)] = inst_36949);

return statearr_37029;
})();
var statearr_37030_37075 = state_37007__$1;
(statearr_37030_37075[(2)] = null);

(statearr_37030_37075[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (3))){
var inst_37005 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37007__$1,inst_37005);
} else {
if((state_val_37008 === (12))){
var inst_36982 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37031_37076 = state_37007__$1;
(statearr_37031_37076[(2)] = inst_36982);

(statearr_37031_37076[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (2))){
var state_37007__$1 = state_37007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37007__$1,(4),ch);
} else {
if((state_val_37008 === (23))){
var state_37007__$1 = state_37007;
var statearr_37032_37077 = state_37007__$1;
(statearr_37032_37077[(2)] = null);

(statearr_37032_37077[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (19))){
var inst_36938 = (state_37007[(8)]);
var inst_36988 = (state_37007[(11)]);
var inst_36990 = cljs.core.async.muxch_STAR_(inst_36988);
var state_37007__$1 = state_37007;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37007__$1,(22),inst_36990,inst_36938);
} else {
if((state_val_37008 === (11))){
var inst_36962 = (state_37007[(10)]);
var inst_36948 = (state_37007[(13)]);
var inst_36962__$1 = cljs.core.seq(inst_36948);
var state_37007__$1 = (function (){var statearr_37033 = state_37007;
(statearr_37033[(10)] = inst_36962__$1);

return statearr_37033;
})();
if(inst_36962__$1){
var statearr_37034_37078 = state_37007__$1;
(statearr_37034_37078[(1)] = (13));

} else {
var statearr_37035_37079 = state_37007__$1;
(statearr_37035_37079[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (9))){
var inst_36984 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37036_37080 = state_37007__$1;
(statearr_37036_37080[(2)] = inst_36984);

(statearr_37036_37080[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (5))){
var inst_36945 = (function (){var G__37037 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__37037) : cljs.core.deref.call(null,G__37037));
})();
var inst_36946 = cljs.core.vals(inst_36945);
var inst_36947 = cljs.core.seq(inst_36946);
var inst_36948 = inst_36947;
var inst_36949 = null;
var inst_36950 = (0);
var inst_36951 = (0);
var state_37007__$1 = (function (){var statearr_37038 = state_37007;
(statearr_37038[(13)] = inst_36948);

(statearr_37038[(14)] = inst_36951);

(statearr_37038[(15)] = inst_36950);

(statearr_37038[(16)] = inst_36949);

return statearr_37038;
})();
var statearr_37039_37081 = state_37007__$1;
(statearr_37039_37081[(2)] = null);

(statearr_37039_37081[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (14))){
var state_37007__$1 = state_37007;
var statearr_37043_37082 = state_37007__$1;
(statearr_37043_37082[(2)] = null);

(statearr_37043_37082[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (16))){
var inst_36962 = (state_37007[(10)]);
var inst_36966 = cljs.core.chunk_first(inst_36962);
var inst_36967 = cljs.core.chunk_rest(inst_36962);
var inst_36968 = cljs.core.count(inst_36966);
var inst_36948 = inst_36967;
var inst_36949 = inst_36966;
var inst_36950 = inst_36968;
var inst_36951 = (0);
var state_37007__$1 = (function (){var statearr_37044 = state_37007;
(statearr_37044[(13)] = inst_36948);

(statearr_37044[(14)] = inst_36951);

(statearr_37044[(15)] = inst_36950);

(statearr_37044[(16)] = inst_36949);

return statearr_37044;
})();
var statearr_37045_37083 = state_37007__$1;
(statearr_37045_37083[(2)] = null);

(statearr_37045_37083[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (10))){
var inst_36948 = (state_37007[(13)]);
var inst_36951 = (state_37007[(14)]);
var inst_36950 = (state_37007[(15)]);
var inst_36949 = (state_37007[(16)]);
var inst_36956 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_36949,inst_36951);
var inst_36957 = cljs.core.async.muxch_STAR_(inst_36956);
var inst_36958 = cljs.core.async.close_BANG_(inst_36957);
var inst_36959 = (inst_36951 + (1));
var tmp37040 = inst_36948;
var tmp37041 = inst_36950;
var tmp37042 = inst_36949;
var inst_36948__$1 = tmp37040;
var inst_36949__$1 = tmp37042;
var inst_36950__$1 = tmp37041;
var inst_36951__$1 = inst_36959;
var state_37007__$1 = (function (){var statearr_37046 = state_37007;
(statearr_37046[(13)] = inst_36948__$1);

(statearr_37046[(17)] = inst_36958);

(statearr_37046[(14)] = inst_36951__$1);

(statearr_37046[(15)] = inst_36950__$1);

(statearr_37046[(16)] = inst_36949__$1);

return statearr_37046;
})();
var statearr_37047_37084 = state_37007__$1;
(statearr_37047_37084[(2)] = null);

(statearr_37047_37084[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (18))){
var inst_36977 = (state_37007[(2)]);
var state_37007__$1 = state_37007;
var statearr_37048_37085 = state_37007__$1;
(statearr_37048_37085[(2)] = inst_36977);

(statearr_37048_37085[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37008 === (8))){
var inst_36951 = (state_37007[(14)]);
var inst_36950 = (state_37007[(15)]);
var inst_36953 = (inst_36951 < inst_36950);
var inst_36954 = inst_36953;
var state_37007__$1 = state_37007;
if(cljs.core.truth_(inst_36954)){
var statearr_37049_37086 = state_37007__$1;
(statearr_37049_37086[(1)] = (10));

} else {
var statearr_37050_37087 = state_37007__$1;
(statearr_37050_37087[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37059,mults,ensure_mult,p))
;
return ((function (switch__11560__auto__,c__11622__auto___37059,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37054[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37054[(1)] = (1));

return statearr_37054;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37007){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37007);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37055){if((e37055 instanceof Object)){
var ex__11564__auto__ = e37055;
var statearr_37056_37088 = state_37007;
(statearr_37056_37088[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37007);

return cljs.core.constant$keyword$recur;
} else {
throw e37055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37089 = state_37007;
state_37007 = G__37089;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37007){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37059,mults,ensure_mult,p))
})();
var state__11624__auto__ = (function (){var statearr_37057 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37059);

return statearr_37057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37059,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__37091 = arguments.length;
switch (G__37091) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__37094 = arguments.length;
switch (G__37094) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__37097 = arguments.length;
switch (G__37097) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__37098 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__37098) : cljs.core.atom.call(null,G__37098));
})();
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11622__auto___37172 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_37137){
var state_val_37138 = (state_37137[(1)]);
if((state_val_37138 === (7))){
var state_37137__$1 = state_37137;
var statearr_37139_37173 = state_37137__$1;
(statearr_37139_37173[(2)] = null);

(statearr_37139_37173[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (1))){
var state_37137__$1 = state_37137;
var statearr_37140_37174 = state_37137__$1;
(statearr_37140_37174[(2)] = null);

(statearr_37140_37174[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (4))){
var inst_37101 = (state_37137[(7)]);
var inst_37103 = (inst_37101 < cnt);
var state_37137__$1 = state_37137;
if(cljs.core.truth_(inst_37103)){
var statearr_37141_37175 = state_37137__$1;
(statearr_37141_37175[(1)] = (6));

} else {
var statearr_37142_37176 = state_37137__$1;
(statearr_37142_37176[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (15))){
var inst_37133 = (state_37137[(2)]);
var state_37137__$1 = state_37137;
var statearr_37143_37177 = state_37137__$1;
(statearr_37143_37177[(2)] = inst_37133);

(statearr_37143_37177[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (13))){
var inst_37126 = cljs.core.async.close_BANG_(out);
var state_37137__$1 = state_37137;
var statearr_37144_37178 = state_37137__$1;
(statearr_37144_37178[(2)] = inst_37126);

(statearr_37144_37178[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (6))){
var state_37137__$1 = state_37137;
var statearr_37145_37179 = state_37137__$1;
(statearr_37145_37179[(2)] = null);

(statearr_37145_37179[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (3))){
var inst_37135 = (state_37137[(2)]);
var state_37137__$1 = state_37137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37137__$1,inst_37135);
} else {
if((state_val_37138 === (12))){
var inst_37123 = (state_37137[(8)]);
var inst_37123__$1 = (state_37137[(2)]);
var inst_37124 = cljs.core.some(cljs.core.nil_QMARK_,inst_37123__$1);
var state_37137__$1 = (function (){var statearr_37146 = state_37137;
(statearr_37146[(8)] = inst_37123__$1);

return statearr_37146;
})();
if(cljs.core.truth_(inst_37124)){
var statearr_37147_37180 = state_37137__$1;
(statearr_37147_37180[(1)] = (13));

} else {
var statearr_37148_37181 = state_37137__$1;
(statearr_37148_37181[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (2))){
var inst_37100 = (function (){var G__37149 = dctr;
var G__37150 = cnt;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__37149,G__37150) : cljs.core.reset_BANG_.call(null,G__37149,G__37150));
})();
var inst_37101 = (0);
var state_37137__$1 = (function (){var statearr_37151 = state_37137;
(statearr_37151[(7)] = inst_37101);

(statearr_37151[(9)] = inst_37100);

return statearr_37151;
})();
var statearr_37152_37182 = state_37137__$1;
(statearr_37152_37182[(2)] = null);

(statearr_37152_37182[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (11))){
var inst_37101 = (state_37137[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_37137,(10),Object,null,(9));
var inst_37110 = (function (){var G__37153 = inst_37101;
return (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(G__37153) : chs__$1.call(null,G__37153));
})();
var inst_37111 = (function (){var G__37154 = inst_37101;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__37154) : done.call(null,G__37154));
})();
var inst_37112 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_37110,inst_37111);
var state_37137__$1 = state_37137;
var statearr_37155_37183 = state_37137__$1;
(statearr_37155_37183[(2)] = inst_37112);


cljs.core.async.impl.ioc_helpers.process_exception(state_37137__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (9))){
var inst_37101 = (state_37137[(7)]);
var inst_37114 = (state_37137[(2)]);
var inst_37115 = (inst_37101 + (1));
var inst_37101__$1 = inst_37115;
var state_37137__$1 = (function (){var statearr_37156 = state_37137;
(statearr_37156[(10)] = inst_37114);

(statearr_37156[(7)] = inst_37101__$1);

return statearr_37156;
})();
var statearr_37157_37184 = state_37137__$1;
(statearr_37157_37184[(2)] = null);

(statearr_37157_37184[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (5))){
var inst_37121 = (state_37137[(2)]);
var state_37137__$1 = (function (){var statearr_37158 = state_37137;
(statearr_37158[(11)] = inst_37121);

return statearr_37158;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37137__$1,(12),dchan);
} else {
if((state_val_37138 === (14))){
var inst_37123 = (state_37137[(8)]);
var inst_37128 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_37123);
var state_37137__$1 = state_37137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37137__$1,(16),out,inst_37128);
} else {
if((state_val_37138 === (16))){
var inst_37130 = (state_37137[(2)]);
var state_37137__$1 = (function (){var statearr_37159 = state_37137;
(statearr_37159[(12)] = inst_37130);

return statearr_37159;
})();
var statearr_37160_37185 = state_37137__$1;
(statearr_37160_37185[(2)] = null);

(statearr_37160_37185[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (10))){
var inst_37105 = (state_37137[(2)]);
var inst_37106 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_37137__$1 = (function (){var statearr_37161 = state_37137;
(statearr_37161[(13)] = inst_37105);

return statearr_37161;
})();
var statearr_37162_37186 = state_37137__$1;
(statearr_37162_37186[(2)] = inst_37106);


cljs.core.async.impl.ioc_helpers.process_exception(state_37137__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37138 === (8))){
var inst_37119 = (state_37137[(2)]);
var state_37137__$1 = state_37137;
var statearr_37163_37187 = state_37137__$1;
(statearr_37163_37187[(2)] = inst_37119);

(statearr_37163_37187[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11560__auto__,c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37167 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37167[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37167[(1)] = (1));

return statearr_37167;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37137){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37137);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37168){if((e37168 instanceof Object)){
var ex__11564__auto__ = e37168;
var statearr_37169_37188 = state_37137;
(statearr_37169_37188[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37137);

return cljs.core.constant$keyword$recur;
} else {
throw e37168;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37189 = state_37137;
state_37137 = G__37189;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11624__auto__ = (function (){var statearr_37170 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37170[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37172);

return statearr_37170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37172,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__37192 = arguments.length;
switch (G__37192) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37247 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37247,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37247,out){
return (function (state_37222){
var state_val_37223 = (state_37222[(1)]);
if((state_val_37223 === (7))){
var inst_37202 = (state_37222[(7)]);
var inst_37201 = (state_37222[(8)]);
var inst_37201__$1 = (state_37222[(2)]);
var inst_37202__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37201__$1,(0),null);
var inst_37203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37201__$1,(1),null);
var inst_37204 = (inst_37202__$1 == null);
var state_37222__$1 = (function (){var statearr_37224 = state_37222;
(statearr_37224[(7)] = inst_37202__$1);

(statearr_37224[(9)] = inst_37203);

(statearr_37224[(8)] = inst_37201__$1);

return statearr_37224;
})();
if(cljs.core.truth_(inst_37204)){
var statearr_37225_37248 = state_37222__$1;
(statearr_37225_37248[(1)] = (8));

} else {
var statearr_37226_37249 = state_37222__$1;
(statearr_37226_37249[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (1))){
var inst_37193 = cljs.core.vec(chs);
var inst_37194 = inst_37193;
var state_37222__$1 = (function (){var statearr_37227 = state_37222;
(statearr_37227[(10)] = inst_37194);

return statearr_37227;
})();
var statearr_37228_37250 = state_37222__$1;
(statearr_37228_37250[(2)] = null);

(statearr_37228_37250[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (4))){
var inst_37194 = (state_37222[(10)]);
var state_37222__$1 = state_37222;
return cljs.core.async.ioc_alts_BANG_(state_37222__$1,(7),inst_37194);
} else {
if((state_val_37223 === (6))){
var inst_37218 = (state_37222[(2)]);
var state_37222__$1 = state_37222;
var statearr_37229_37251 = state_37222__$1;
(statearr_37229_37251[(2)] = inst_37218);

(statearr_37229_37251[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (3))){
var inst_37220 = (state_37222[(2)]);
var state_37222__$1 = state_37222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37222__$1,inst_37220);
} else {
if((state_val_37223 === (2))){
var inst_37194 = (state_37222[(10)]);
var inst_37196 = cljs.core.count(inst_37194);
var inst_37197 = (inst_37196 > (0));
var state_37222__$1 = state_37222;
if(cljs.core.truth_(inst_37197)){
var statearr_37231_37252 = state_37222__$1;
(statearr_37231_37252[(1)] = (4));

} else {
var statearr_37232_37253 = state_37222__$1;
(statearr_37232_37253[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (11))){
var inst_37194 = (state_37222[(10)]);
var inst_37211 = (state_37222[(2)]);
var tmp37230 = inst_37194;
var inst_37194__$1 = tmp37230;
var state_37222__$1 = (function (){var statearr_37233 = state_37222;
(statearr_37233[(11)] = inst_37211);

(statearr_37233[(10)] = inst_37194__$1);

return statearr_37233;
})();
var statearr_37234_37254 = state_37222__$1;
(statearr_37234_37254[(2)] = null);

(statearr_37234_37254[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (9))){
var inst_37202 = (state_37222[(7)]);
var state_37222__$1 = state_37222;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37222__$1,(11),out,inst_37202);
} else {
if((state_val_37223 === (5))){
var inst_37216 = cljs.core.async.close_BANG_(out);
var state_37222__$1 = state_37222;
var statearr_37235_37255 = state_37222__$1;
(statearr_37235_37255[(2)] = inst_37216);

(statearr_37235_37255[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (10))){
var inst_37214 = (state_37222[(2)]);
var state_37222__$1 = state_37222;
var statearr_37236_37256 = state_37222__$1;
(statearr_37236_37256[(2)] = inst_37214);

(statearr_37236_37256[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37223 === (8))){
var inst_37194 = (state_37222[(10)]);
var inst_37202 = (state_37222[(7)]);
var inst_37203 = (state_37222[(9)]);
var inst_37201 = (state_37222[(8)]);
var inst_37206 = (function (){var cs = inst_37194;
var vec__37199 = inst_37201;
var v = inst_37202;
var c = inst_37203;
return ((function (cs,vec__37199,v,c,inst_37194,inst_37202,inst_37203,inst_37201,state_val_37223,c__11622__auto___37247,out){
return (function (p1__37190_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__37190_SHARP_);
});
;})(cs,vec__37199,v,c,inst_37194,inst_37202,inst_37203,inst_37201,state_val_37223,c__11622__auto___37247,out))
})();
var inst_37207 = cljs.core.filterv(inst_37206,inst_37194);
var inst_37194__$1 = inst_37207;
var state_37222__$1 = (function (){var statearr_37237 = state_37222;
(statearr_37237[(10)] = inst_37194__$1);

return statearr_37237;
})();
var statearr_37238_37257 = state_37222__$1;
(statearr_37238_37257[(2)] = null);

(statearr_37238_37257[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37247,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37247,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37242 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37242[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37242[(1)] = (1));

return statearr_37242;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37222){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37222);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37243){if((e37243 instanceof Object)){
var ex__11564__auto__ = e37243;
var statearr_37244_37258 = state_37222;
(statearr_37244_37258[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37222);

return cljs.core.constant$keyword$recur;
} else {
throw e37243;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37259 = state_37222;
state_37222 = G__37259;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37222){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37247,out))
})();
var state__11624__auto__ = (function (){var statearr_37245 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37245[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37247);

return statearr_37245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37247,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__37261 = arguments.length;
switch (G__37261) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37309 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37309,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37309,out){
return (function (state_37285){
var state_val_37286 = (state_37285[(1)]);
if((state_val_37286 === (7))){
var inst_37267 = (state_37285[(7)]);
var inst_37267__$1 = (state_37285[(2)]);
var inst_37268 = (inst_37267__$1 == null);
var inst_37269 = cljs.core.not(inst_37268);
var state_37285__$1 = (function (){var statearr_37287 = state_37285;
(statearr_37287[(7)] = inst_37267__$1);

return statearr_37287;
})();
if(inst_37269){
var statearr_37288_37310 = state_37285__$1;
(statearr_37288_37310[(1)] = (8));

} else {
var statearr_37289_37311 = state_37285__$1;
(statearr_37289_37311[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (1))){
var inst_37262 = (0);
var state_37285__$1 = (function (){var statearr_37290 = state_37285;
(statearr_37290[(8)] = inst_37262);

return statearr_37290;
})();
var statearr_37291_37312 = state_37285__$1;
(statearr_37291_37312[(2)] = null);

(statearr_37291_37312[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (4))){
var state_37285__$1 = state_37285;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37285__$1,(7),ch);
} else {
if((state_val_37286 === (6))){
var inst_37280 = (state_37285[(2)]);
var state_37285__$1 = state_37285;
var statearr_37292_37313 = state_37285__$1;
(statearr_37292_37313[(2)] = inst_37280);

(statearr_37292_37313[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (3))){
var inst_37282 = (state_37285[(2)]);
var inst_37283 = cljs.core.async.close_BANG_(out);
var state_37285__$1 = (function (){var statearr_37293 = state_37285;
(statearr_37293[(9)] = inst_37282);

return statearr_37293;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37285__$1,inst_37283);
} else {
if((state_val_37286 === (2))){
var inst_37262 = (state_37285[(8)]);
var inst_37264 = (inst_37262 < n);
var state_37285__$1 = state_37285;
if(cljs.core.truth_(inst_37264)){
var statearr_37294_37314 = state_37285__$1;
(statearr_37294_37314[(1)] = (4));

} else {
var statearr_37295_37315 = state_37285__$1;
(statearr_37295_37315[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (11))){
var inst_37262 = (state_37285[(8)]);
var inst_37272 = (state_37285[(2)]);
var inst_37273 = (inst_37262 + (1));
var inst_37262__$1 = inst_37273;
var state_37285__$1 = (function (){var statearr_37296 = state_37285;
(statearr_37296[(8)] = inst_37262__$1);

(statearr_37296[(10)] = inst_37272);

return statearr_37296;
})();
var statearr_37297_37316 = state_37285__$1;
(statearr_37297_37316[(2)] = null);

(statearr_37297_37316[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (9))){
var state_37285__$1 = state_37285;
var statearr_37298_37317 = state_37285__$1;
(statearr_37298_37317[(2)] = null);

(statearr_37298_37317[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (5))){
var state_37285__$1 = state_37285;
var statearr_37299_37318 = state_37285__$1;
(statearr_37299_37318[(2)] = null);

(statearr_37299_37318[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (10))){
var inst_37277 = (state_37285[(2)]);
var state_37285__$1 = state_37285;
var statearr_37300_37319 = state_37285__$1;
(statearr_37300_37319[(2)] = inst_37277);

(statearr_37300_37319[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37286 === (8))){
var inst_37267 = (state_37285[(7)]);
var state_37285__$1 = state_37285;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37285__$1,(11),out,inst_37267);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37309,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37309,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37304 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37304[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37304[(1)] = (1));

return statearr_37304;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37285){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37285);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37305){if((e37305 instanceof Object)){
var ex__11564__auto__ = e37305;
var statearr_37306_37320 = state_37285;
(statearr_37306_37320[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37285);

return cljs.core.constant$keyword$recur;
} else {
throw e37305;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37321 = state_37285;
state_37285 = G__37321;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37285){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37309,out))
})();
var state__11624__auto__ = (function (){var statearr_37307 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37307[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37309);

return statearr_37307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37309,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t37334 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t37334 = (function (map_LT_,f,ch,meta37335){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta37335 = meta37335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t37334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37336,meta37335__$1){
var self__ = this;
var _37336__$1 = this;
return (new cljs.core.async.t37334(self__.map_LT_,self__.f,self__.ch,meta37335__$1));
});

cljs.core.async.t37334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37336){
var self__ = this;
var _37336__$1 = this;
return self__.meta37335;
});

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t37337 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t37337 = (function (map_LT_,f,ch,meta37335,_,fn1,meta37338){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta37335 = meta37335;
this._ = _;
this.fn1 = fn1;
this.meta37338 = meta37338;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t37337.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_37339,meta37338__$1){
var self__ = this;
var _37339__$1 = this;
return (new cljs.core.async.t37337(self__.map_LT_,self__.f,self__.ch,self__.meta37335,self__._,self__.fn1,meta37338__$1));
});})(___$1))
;

cljs.core.async.t37337.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_37339){
var self__ = this;
var _37339__$1 = this;
return self__.meta37338;
});})(___$1))
;

cljs.core.async.t37337.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t37337.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t37337.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__37322_SHARP_){
var G__37340 = (((p1__37322_SHARP_ == null))?null:(function (){var G__37341 = p1__37322_SHARP_;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__37341) : self__.f.call(null,G__37341));
})());
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__37340) : f1.call(null,G__37340));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t37337.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta37335","meta37335",181790675,null),new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta37338","meta37338",1352193220,null)], null);
});})(___$1))
;

cljs.core.async.t37337.cljs$lang$type = true;

cljs.core.async.t37337.cljs$lang$ctorStr = "cljs.core.async/t37337";

cljs.core.async.t37337.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t37337");
});})(___$1))
;

cljs.core.async.__GT_t37337 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t37337(map_LT___$1,f__$1,ch__$1,meta37335__$1,___$2,fn1__$1,meta37338){
return (new cljs.core.async.t37337(map_LT___$1,f__$1,ch__$1,meta37335__$1,___$2,fn1__$1,meta37338));
});})(___$1))
;

}

return (new cljs.core.async.t37337(self__.map_LT_,self__.f,self__.ch,self__.meta37335,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8170__auto__ = ret;
if(cljs.core.truth_(and__8170__auto__)){
return !(((function (){var G__37342 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__37342) : cljs.core.deref.call(null,G__37342));
})() == null));
} else {
return and__8170__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__37343 = (function (){var G__37344 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__37344) : cljs.core.deref.call(null,G__37344));
})();
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__37343) : self__.f.call(null,G__37343));
})());
} else {
return ret;
}
});

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t37334.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t37334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta37335","meta37335",181790675,null)], null);
});

cljs.core.async.t37334.cljs$lang$type = true;

cljs.core.async.t37334.cljs$lang$ctorStr = "cljs.core.async/t37334";

cljs.core.async.t37334.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t37334");
});

cljs.core.async.__GT_t37334 = (function cljs$core$async$map_LT__$___GT_t37334(map_LT___$1,f__$1,ch__$1,meta37335){
return (new cljs.core.async.t37334(map_LT___$1,f__$1,ch__$1,meta37335));
});

}

return (new cljs.core.async.t37334(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t37349 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t37349 = (function (map_GT_,f,ch,meta37350){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta37350 = meta37350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t37349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37351,meta37350__$1){
var self__ = this;
var _37351__$1 = this;
return (new cljs.core.async.t37349(self__.map_GT_,self__.f,self__.ch,meta37350__$1));
});

cljs.core.async.t37349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37351){
var self__ = this;
var _37351__$1 = this;
return self__.meta37350;
});

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t37349.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(function (){var G__37352 = val;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__37352) : self__.f.call(null,G__37352));
})(),fn1);
});

cljs.core.async.t37349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta37350","meta37350",-1087980408,null)], null);
});

cljs.core.async.t37349.cljs$lang$type = true;

cljs.core.async.t37349.cljs$lang$ctorStr = "cljs.core.async/t37349";

cljs.core.async.t37349.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t37349");
});

cljs.core.async.__GT_t37349 = (function cljs$core$async$map_GT__$___GT_t37349(map_GT___$1,f__$1,ch__$1,meta37350){
return (new cljs.core.async.t37349(map_GT___$1,f__$1,ch__$1,meta37350));
});

}

return (new cljs.core.async.t37349(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t37357 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t37357 = (function (filter_GT_,p,ch,meta37358){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta37358 = meta37358;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t37357.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37359,meta37358__$1){
var self__ = this;
var _37359__$1 = this;
return (new cljs.core.async.t37357(self__.filter_GT_,self__.p,self__.ch,meta37358__$1));
});

cljs.core.async.t37357.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37359){
var self__ = this;
var _37359__$1 = this;
return self__.meta37358;
});

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t37357.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__37360 = val;
return (self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(G__37360) : self__.p.call(null,G__37360));
})())){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t37357.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta37358","meta37358",-1438399201,null)], null);
});

cljs.core.async.t37357.cljs$lang$type = true;

cljs.core.async.t37357.cljs$lang$ctorStr = "cljs.core.async/t37357";

cljs.core.async.t37357.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cljs.core.async/t37357");
});

cljs.core.async.__GT_t37357 = (function cljs$core$async$filter_GT__$___GT_t37357(filter_GT___$1,p__$1,ch__$1,meta37358){
return (new cljs.core.async.t37357(filter_GT___$1,p__$1,ch__$1,meta37358));
});

}

return (new cljs.core.async.t37357(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__37362 = arguments.length;
switch (G__37362) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37406 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37406,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37406,out){
return (function (state_37383){
var state_val_37384 = (state_37383[(1)]);
if((state_val_37384 === (7))){
var inst_37379 = (state_37383[(2)]);
var state_37383__$1 = state_37383;
var statearr_37385_37407 = state_37383__$1;
(statearr_37385_37407[(2)] = inst_37379);

(statearr_37385_37407[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (1))){
var state_37383__$1 = state_37383;
var statearr_37386_37408 = state_37383__$1;
(statearr_37386_37408[(2)] = null);

(statearr_37386_37408[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (4))){
var inst_37365 = (state_37383[(7)]);
var inst_37365__$1 = (state_37383[(2)]);
var inst_37366 = (inst_37365__$1 == null);
var state_37383__$1 = (function (){var statearr_37387 = state_37383;
(statearr_37387[(7)] = inst_37365__$1);

return statearr_37387;
})();
if(cljs.core.truth_(inst_37366)){
var statearr_37388_37409 = state_37383__$1;
(statearr_37388_37409[(1)] = (5));

} else {
var statearr_37389_37410 = state_37383__$1;
(statearr_37389_37410[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (6))){
var inst_37365 = (state_37383[(7)]);
var inst_37370 = (function (){var G__37390 = inst_37365;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__37390) : p.call(null,G__37390));
})();
var state_37383__$1 = state_37383;
if(cljs.core.truth_(inst_37370)){
var statearr_37391_37411 = state_37383__$1;
(statearr_37391_37411[(1)] = (8));

} else {
var statearr_37392_37412 = state_37383__$1;
(statearr_37392_37412[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (3))){
var inst_37381 = (state_37383[(2)]);
var state_37383__$1 = state_37383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37383__$1,inst_37381);
} else {
if((state_val_37384 === (2))){
var state_37383__$1 = state_37383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37383__$1,(4),ch);
} else {
if((state_val_37384 === (11))){
var inst_37373 = (state_37383[(2)]);
var state_37383__$1 = state_37383;
var statearr_37393_37413 = state_37383__$1;
(statearr_37393_37413[(2)] = inst_37373);

(statearr_37393_37413[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (9))){
var state_37383__$1 = state_37383;
var statearr_37394_37414 = state_37383__$1;
(statearr_37394_37414[(2)] = null);

(statearr_37394_37414[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (5))){
var inst_37368 = cljs.core.async.close_BANG_(out);
var state_37383__$1 = state_37383;
var statearr_37395_37415 = state_37383__$1;
(statearr_37395_37415[(2)] = inst_37368);

(statearr_37395_37415[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (10))){
var inst_37376 = (state_37383[(2)]);
var state_37383__$1 = (function (){var statearr_37396 = state_37383;
(statearr_37396[(8)] = inst_37376);

return statearr_37396;
})();
var statearr_37397_37416 = state_37383__$1;
(statearr_37397_37416[(2)] = null);

(statearr_37397_37416[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37384 === (8))){
var inst_37365 = (state_37383[(7)]);
var state_37383__$1 = state_37383;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37383__$1,(11),out,inst_37365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37406,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37406,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37401 = [null,null,null,null,null,null,null,null,null];
(statearr_37401[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37401[(1)] = (1));

return statearr_37401;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37383){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37383);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37402){if((e37402 instanceof Object)){
var ex__11564__auto__ = e37402;
var statearr_37403_37417 = state_37383;
(statearr_37403_37417[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37383);

return cljs.core.constant$keyword$recur;
} else {
throw e37402;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37418 = state_37383;
state_37383 = G__37418;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37383){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37406,out))
})();
var state__11624__auto__ = (function (){var statearr_37404 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37404[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37406);

return statearr_37404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37406,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__37420 = arguments.length;
switch (G__37420) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__){
return (function (state_37588){
var state_val_37589 = (state_37588[(1)]);
if((state_val_37589 === (7))){
var inst_37584 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37590_37632 = state_37588__$1;
(statearr_37590_37632[(2)] = inst_37584);

(statearr_37590_37632[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (20))){
var inst_37554 = (state_37588[(7)]);
var inst_37565 = (state_37588[(2)]);
var inst_37566 = cljs.core.next(inst_37554);
var inst_37540 = inst_37566;
var inst_37541 = null;
var inst_37542 = (0);
var inst_37543 = (0);
var state_37588__$1 = (function (){var statearr_37591 = state_37588;
(statearr_37591[(8)] = inst_37565);

(statearr_37591[(9)] = inst_37542);

(statearr_37591[(10)] = inst_37540);

(statearr_37591[(11)] = inst_37541);

(statearr_37591[(12)] = inst_37543);

return statearr_37591;
})();
var statearr_37592_37633 = state_37588__$1;
(statearr_37592_37633[(2)] = null);

(statearr_37592_37633[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (1))){
var state_37588__$1 = state_37588;
var statearr_37593_37634 = state_37588__$1;
(statearr_37593_37634[(2)] = null);

(statearr_37593_37634[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (4))){
var inst_37529 = (state_37588[(13)]);
var inst_37529__$1 = (state_37588[(2)]);
var inst_37530 = (inst_37529__$1 == null);
var state_37588__$1 = (function (){var statearr_37594 = state_37588;
(statearr_37594[(13)] = inst_37529__$1);

return statearr_37594;
})();
if(cljs.core.truth_(inst_37530)){
var statearr_37595_37635 = state_37588__$1;
(statearr_37595_37635[(1)] = (5));

} else {
var statearr_37596_37636 = state_37588__$1;
(statearr_37596_37636[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (15))){
var state_37588__$1 = state_37588;
var statearr_37600_37637 = state_37588__$1;
(statearr_37600_37637[(2)] = null);

(statearr_37600_37637[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (21))){
var state_37588__$1 = state_37588;
var statearr_37601_37638 = state_37588__$1;
(statearr_37601_37638[(2)] = null);

(statearr_37601_37638[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (13))){
var inst_37542 = (state_37588[(9)]);
var inst_37540 = (state_37588[(10)]);
var inst_37541 = (state_37588[(11)]);
var inst_37543 = (state_37588[(12)]);
var inst_37550 = (state_37588[(2)]);
var inst_37551 = (inst_37543 + (1));
var tmp37597 = inst_37542;
var tmp37598 = inst_37540;
var tmp37599 = inst_37541;
var inst_37540__$1 = tmp37598;
var inst_37541__$1 = tmp37599;
var inst_37542__$1 = tmp37597;
var inst_37543__$1 = inst_37551;
var state_37588__$1 = (function (){var statearr_37602 = state_37588;
(statearr_37602[(9)] = inst_37542__$1);

(statearr_37602[(10)] = inst_37540__$1);

(statearr_37602[(11)] = inst_37541__$1);

(statearr_37602[(12)] = inst_37543__$1);

(statearr_37602[(14)] = inst_37550);

return statearr_37602;
})();
var statearr_37603_37639 = state_37588__$1;
(statearr_37603_37639[(2)] = null);

(statearr_37603_37639[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (22))){
var state_37588__$1 = state_37588;
var statearr_37604_37640 = state_37588__$1;
(statearr_37604_37640[(2)] = null);

(statearr_37604_37640[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (6))){
var inst_37529 = (state_37588[(13)]);
var inst_37538 = (function (){var G__37605 = inst_37529;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__37605) : f.call(null,G__37605));
})();
var inst_37539 = cljs.core.seq(inst_37538);
var inst_37540 = inst_37539;
var inst_37541 = null;
var inst_37542 = (0);
var inst_37543 = (0);
var state_37588__$1 = (function (){var statearr_37606 = state_37588;
(statearr_37606[(9)] = inst_37542);

(statearr_37606[(10)] = inst_37540);

(statearr_37606[(11)] = inst_37541);

(statearr_37606[(12)] = inst_37543);

return statearr_37606;
})();
var statearr_37607_37641 = state_37588__$1;
(statearr_37607_37641[(2)] = null);

(statearr_37607_37641[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (17))){
var inst_37554 = (state_37588[(7)]);
var inst_37558 = cljs.core.chunk_first(inst_37554);
var inst_37559 = cljs.core.chunk_rest(inst_37554);
var inst_37560 = cljs.core.count(inst_37558);
var inst_37540 = inst_37559;
var inst_37541 = inst_37558;
var inst_37542 = inst_37560;
var inst_37543 = (0);
var state_37588__$1 = (function (){var statearr_37608 = state_37588;
(statearr_37608[(9)] = inst_37542);

(statearr_37608[(10)] = inst_37540);

(statearr_37608[(11)] = inst_37541);

(statearr_37608[(12)] = inst_37543);

return statearr_37608;
})();
var statearr_37609_37642 = state_37588__$1;
(statearr_37609_37642[(2)] = null);

(statearr_37609_37642[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (3))){
var inst_37586 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37588__$1,inst_37586);
} else {
if((state_val_37589 === (12))){
var inst_37574 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37610_37643 = state_37588__$1;
(statearr_37610_37643[(2)] = inst_37574);

(statearr_37610_37643[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (2))){
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37588__$1,(4),in$);
} else {
if((state_val_37589 === (23))){
var inst_37582 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37611_37644 = state_37588__$1;
(statearr_37611_37644[(2)] = inst_37582);

(statearr_37611_37644[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (19))){
var inst_37569 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37612_37645 = state_37588__$1;
(statearr_37612_37645[(2)] = inst_37569);

(statearr_37612_37645[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (11))){
var inst_37554 = (state_37588[(7)]);
var inst_37540 = (state_37588[(10)]);
var inst_37554__$1 = cljs.core.seq(inst_37540);
var state_37588__$1 = (function (){var statearr_37613 = state_37588;
(statearr_37613[(7)] = inst_37554__$1);

return statearr_37613;
})();
if(inst_37554__$1){
var statearr_37614_37646 = state_37588__$1;
(statearr_37614_37646[(1)] = (14));

} else {
var statearr_37615_37647 = state_37588__$1;
(statearr_37615_37647[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (9))){
var inst_37576 = (state_37588[(2)]);
var inst_37577 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_37588__$1 = (function (){var statearr_37616 = state_37588;
(statearr_37616[(15)] = inst_37576);

return statearr_37616;
})();
if(cljs.core.truth_(inst_37577)){
var statearr_37617_37648 = state_37588__$1;
(statearr_37617_37648[(1)] = (21));

} else {
var statearr_37618_37649 = state_37588__$1;
(statearr_37618_37649[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (5))){
var inst_37532 = cljs.core.async.close_BANG_(out);
var state_37588__$1 = state_37588;
var statearr_37619_37650 = state_37588__$1;
(statearr_37619_37650[(2)] = inst_37532);

(statearr_37619_37650[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (14))){
var inst_37554 = (state_37588[(7)]);
var inst_37556 = cljs.core.chunked_seq_QMARK_(inst_37554);
var state_37588__$1 = state_37588;
if(inst_37556){
var statearr_37620_37651 = state_37588__$1;
(statearr_37620_37651[(1)] = (17));

} else {
var statearr_37621_37652 = state_37588__$1;
(statearr_37621_37652[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (16))){
var inst_37572 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37622_37653 = state_37588__$1;
(statearr_37622_37653[(2)] = inst_37572);

(statearr_37622_37653[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37589 === (10))){
var inst_37541 = (state_37588[(11)]);
var inst_37543 = (state_37588[(12)]);
var inst_37548 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_37541,inst_37543);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37588__$1,(13),out,inst_37548);
} else {
if((state_val_37589 === (18))){
var inst_37554 = (state_37588[(7)]);
var inst_37563 = cljs.core.first(inst_37554);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37588__$1,(20),out,inst_37563);
} else {
if((state_val_37589 === (8))){
var inst_37542 = (state_37588[(9)]);
var inst_37543 = (state_37588[(12)]);
var inst_37545 = (inst_37543 < inst_37542);
var inst_37546 = inst_37545;
var state_37588__$1 = state_37588;
if(cljs.core.truth_(inst_37546)){
var statearr_37623_37654 = state_37588__$1;
(statearr_37623_37654[(1)] = (10));

} else {
var statearr_37624_37655 = state_37588__$1;
(statearr_37624_37655[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto__))
;
return ((function (switch__11560__auto__,c__11622__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0 = (function (){
var statearr_37628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37628[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__);

(statearr_37628[(1)] = (1));

return statearr_37628;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1 = (function (state_37588){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37588);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37629){if((e37629 instanceof Object)){
var ex__11564__auto__ = e37629;
var statearr_37630_37656 = state_37588;
(statearr_37630_37656[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37588);

return cljs.core.constant$keyword$recur;
} else {
throw e37629;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37657 = state_37588;
state_37588 = G__37657;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__ = function(state_37588){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1.call(this,state_37588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11561__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__))
})();
var state__11624__auto__ = (function (){var statearr_37631 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_37631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__))
);

return c__11622__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__37659 = arguments.length;
switch (G__37659) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__37662 = arguments.length;
switch (G__37662) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__37665 = arguments.length;
switch (G__37665) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37715,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37715,out){
return (function (state_37689){
var state_val_37690 = (state_37689[(1)]);
if((state_val_37690 === (7))){
var inst_37684 = (state_37689[(2)]);
var state_37689__$1 = state_37689;
var statearr_37691_37716 = state_37689__$1;
(statearr_37691_37716[(2)] = inst_37684);

(statearr_37691_37716[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (1))){
var inst_37666 = null;
var state_37689__$1 = (function (){var statearr_37692 = state_37689;
(statearr_37692[(7)] = inst_37666);

return statearr_37692;
})();
var statearr_37693_37717 = state_37689__$1;
(statearr_37693_37717[(2)] = null);

(statearr_37693_37717[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (4))){
var inst_37669 = (state_37689[(8)]);
var inst_37669__$1 = (state_37689[(2)]);
var inst_37670 = (inst_37669__$1 == null);
var inst_37671 = cljs.core.not(inst_37670);
var state_37689__$1 = (function (){var statearr_37694 = state_37689;
(statearr_37694[(8)] = inst_37669__$1);

return statearr_37694;
})();
if(inst_37671){
var statearr_37695_37718 = state_37689__$1;
(statearr_37695_37718[(1)] = (5));

} else {
var statearr_37696_37719 = state_37689__$1;
(statearr_37696_37719[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (6))){
var state_37689__$1 = state_37689;
var statearr_37697_37720 = state_37689__$1;
(statearr_37697_37720[(2)] = null);

(statearr_37697_37720[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (3))){
var inst_37686 = (state_37689[(2)]);
var inst_37687 = cljs.core.async.close_BANG_(out);
var state_37689__$1 = (function (){var statearr_37698 = state_37689;
(statearr_37698[(9)] = inst_37686);

return statearr_37698;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37689__$1,inst_37687);
} else {
if((state_val_37690 === (2))){
var state_37689__$1 = state_37689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37689__$1,(4),ch);
} else {
if((state_val_37690 === (11))){
var inst_37669 = (state_37689[(8)]);
var inst_37678 = (state_37689[(2)]);
var inst_37666 = inst_37669;
var state_37689__$1 = (function (){var statearr_37699 = state_37689;
(statearr_37699[(10)] = inst_37678);

(statearr_37699[(7)] = inst_37666);

return statearr_37699;
})();
var statearr_37700_37721 = state_37689__$1;
(statearr_37700_37721[(2)] = null);

(statearr_37700_37721[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (9))){
var inst_37669 = (state_37689[(8)]);
var state_37689__$1 = state_37689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37689__$1,(11),out,inst_37669);
} else {
if((state_val_37690 === (5))){
var inst_37669 = (state_37689[(8)]);
var inst_37666 = (state_37689[(7)]);
var inst_37673 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37669,inst_37666);
var state_37689__$1 = state_37689;
if(inst_37673){
var statearr_37702_37722 = state_37689__$1;
(statearr_37702_37722[(1)] = (8));

} else {
var statearr_37703_37723 = state_37689__$1;
(statearr_37703_37723[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (10))){
var inst_37681 = (state_37689[(2)]);
var state_37689__$1 = state_37689;
var statearr_37704_37724 = state_37689__$1;
(statearr_37704_37724[(2)] = inst_37681);

(statearr_37704_37724[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37690 === (8))){
var inst_37666 = (state_37689[(7)]);
var tmp37701 = inst_37666;
var inst_37666__$1 = tmp37701;
var state_37689__$1 = (function (){var statearr_37705 = state_37689;
(statearr_37705[(7)] = inst_37666__$1);

return statearr_37705;
})();
var statearr_37706_37725 = state_37689__$1;
(statearr_37706_37725[(2)] = null);

(statearr_37706_37725[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37715,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37715,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37710 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37710[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37710[(1)] = (1));

return statearr_37710;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37689){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37689);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37711){if((e37711 instanceof Object)){
var ex__11564__auto__ = e37711;
var statearr_37712_37726 = state_37689;
(statearr_37712_37726[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37689);

return cljs.core.constant$keyword$recur;
} else {
throw e37711;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37727 = state_37689;
state_37689 = G__37727;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37715,out))
})();
var state__11624__auto__ = (function (){var statearr_37713 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37715);

return statearr_37713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37715,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__37729 = arguments.length;
switch (G__37729) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37798 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37798,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37798,out){
return (function (state_37767){
var state_val_37768 = (state_37767[(1)]);
if((state_val_37768 === (7))){
var inst_37763 = (state_37767[(2)]);
var state_37767__$1 = state_37767;
var statearr_37769_37799 = state_37767__$1;
(statearr_37769_37799[(2)] = inst_37763);

(statearr_37769_37799[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (1))){
var inst_37730 = (new Array(n));
var inst_37731 = inst_37730;
var inst_37732 = (0);
var state_37767__$1 = (function (){var statearr_37770 = state_37767;
(statearr_37770[(7)] = inst_37732);

(statearr_37770[(8)] = inst_37731);

return statearr_37770;
})();
var statearr_37771_37800 = state_37767__$1;
(statearr_37771_37800[(2)] = null);

(statearr_37771_37800[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (4))){
var inst_37735 = (state_37767[(9)]);
var inst_37735__$1 = (state_37767[(2)]);
var inst_37736 = (inst_37735__$1 == null);
var inst_37737 = cljs.core.not(inst_37736);
var state_37767__$1 = (function (){var statearr_37772 = state_37767;
(statearr_37772[(9)] = inst_37735__$1);

return statearr_37772;
})();
if(inst_37737){
var statearr_37773_37801 = state_37767__$1;
(statearr_37773_37801[(1)] = (5));

} else {
var statearr_37774_37802 = state_37767__$1;
(statearr_37774_37802[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (15))){
var inst_37757 = (state_37767[(2)]);
var state_37767__$1 = state_37767;
var statearr_37775_37803 = state_37767__$1;
(statearr_37775_37803[(2)] = inst_37757);

(statearr_37775_37803[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (13))){
var state_37767__$1 = state_37767;
var statearr_37776_37804 = state_37767__$1;
(statearr_37776_37804[(2)] = null);

(statearr_37776_37804[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (6))){
var inst_37732 = (state_37767[(7)]);
var inst_37753 = (inst_37732 > (0));
var state_37767__$1 = state_37767;
if(cljs.core.truth_(inst_37753)){
var statearr_37777_37805 = state_37767__$1;
(statearr_37777_37805[(1)] = (12));

} else {
var statearr_37778_37806 = state_37767__$1;
(statearr_37778_37806[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (3))){
var inst_37765 = (state_37767[(2)]);
var state_37767__$1 = state_37767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37767__$1,inst_37765);
} else {
if((state_val_37768 === (12))){
var inst_37731 = (state_37767[(8)]);
var inst_37755 = cljs.core.vec(inst_37731);
var state_37767__$1 = state_37767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37767__$1,(15),out,inst_37755);
} else {
if((state_val_37768 === (2))){
var state_37767__$1 = state_37767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37767__$1,(4),ch);
} else {
if((state_val_37768 === (11))){
var inst_37747 = (state_37767[(2)]);
var inst_37748 = (new Array(n));
var inst_37731 = inst_37748;
var inst_37732 = (0);
var state_37767__$1 = (function (){var statearr_37779 = state_37767;
(statearr_37779[(7)] = inst_37732);

(statearr_37779[(10)] = inst_37747);

(statearr_37779[(8)] = inst_37731);

return statearr_37779;
})();
var statearr_37780_37807 = state_37767__$1;
(statearr_37780_37807[(2)] = null);

(statearr_37780_37807[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (9))){
var inst_37731 = (state_37767[(8)]);
var inst_37745 = cljs.core.vec(inst_37731);
var state_37767__$1 = state_37767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37767__$1,(11),out,inst_37745);
} else {
if((state_val_37768 === (5))){
var inst_37732 = (state_37767[(7)]);
var inst_37735 = (state_37767[(9)]);
var inst_37731 = (state_37767[(8)]);
var inst_37740 = (state_37767[(11)]);
var inst_37739 = (inst_37731[inst_37732] = inst_37735);
var inst_37740__$1 = (inst_37732 + (1));
var inst_37741 = (inst_37740__$1 < n);
var state_37767__$1 = (function (){var statearr_37781 = state_37767;
(statearr_37781[(12)] = inst_37739);

(statearr_37781[(11)] = inst_37740__$1);

return statearr_37781;
})();
if(cljs.core.truth_(inst_37741)){
var statearr_37782_37808 = state_37767__$1;
(statearr_37782_37808[(1)] = (8));

} else {
var statearr_37783_37809 = state_37767__$1;
(statearr_37783_37809[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (14))){
var inst_37760 = (state_37767[(2)]);
var inst_37761 = cljs.core.async.close_BANG_(out);
var state_37767__$1 = (function (){var statearr_37785 = state_37767;
(statearr_37785[(13)] = inst_37760);

return statearr_37785;
})();
var statearr_37786_37810 = state_37767__$1;
(statearr_37786_37810[(2)] = inst_37761);

(statearr_37786_37810[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (10))){
var inst_37751 = (state_37767[(2)]);
var state_37767__$1 = state_37767;
var statearr_37787_37811 = state_37767__$1;
(statearr_37787_37811[(2)] = inst_37751);

(statearr_37787_37811[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37768 === (8))){
var inst_37731 = (state_37767[(8)]);
var inst_37740 = (state_37767[(11)]);
var tmp37784 = inst_37731;
var inst_37731__$1 = tmp37784;
var inst_37732 = inst_37740;
var state_37767__$1 = (function (){var statearr_37788 = state_37767;
(statearr_37788[(7)] = inst_37732);

(statearr_37788[(8)] = inst_37731__$1);

return statearr_37788;
})();
var statearr_37789_37812 = state_37767__$1;
(statearr_37789_37812[(2)] = null);

(statearr_37789_37812[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37798,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37798,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37793[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37793[(1)] = (1));

return statearr_37793;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37767){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37767);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37794){if((e37794 instanceof Object)){
var ex__11564__auto__ = e37794;
var statearr_37795_37813 = state_37767;
(statearr_37795_37813[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37767);

return cljs.core.constant$keyword$recur;
} else {
throw e37794;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37814 = state_37767;
state_37767 = G__37814;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37798,out))
})();
var state__11624__auto__ = (function (){var statearr_37796 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37798);

return statearr_37796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37798,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__37816 = arguments.length;
switch (G__37816) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11622__auto___37890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto___37890,out){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto___37890,out){
return (function (state_37858){
var state_val_37859 = (state_37858[(1)]);
if((state_val_37859 === (7))){
var inst_37854 = (state_37858[(2)]);
var state_37858__$1 = state_37858;
var statearr_37860_37891 = state_37858__$1;
(statearr_37860_37891[(2)] = inst_37854);

(statearr_37860_37891[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (1))){
var inst_37817 = [];
var inst_37818 = inst_37817;
var inst_37819 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_37858__$1 = (function (){var statearr_37861 = state_37858;
(statearr_37861[(7)] = inst_37819);

(statearr_37861[(8)] = inst_37818);

return statearr_37861;
})();
var statearr_37862_37892 = state_37858__$1;
(statearr_37862_37892[(2)] = null);

(statearr_37862_37892[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (4))){
var inst_37822 = (state_37858[(9)]);
var inst_37822__$1 = (state_37858[(2)]);
var inst_37823 = (inst_37822__$1 == null);
var inst_37824 = cljs.core.not(inst_37823);
var state_37858__$1 = (function (){var statearr_37863 = state_37858;
(statearr_37863[(9)] = inst_37822__$1);

return statearr_37863;
})();
if(inst_37824){
var statearr_37864_37893 = state_37858__$1;
(statearr_37864_37893[(1)] = (5));

} else {
var statearr_37865_37894 = state_37858__$1;
(statearr_37865_37894[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (15))){
var inst_37848 = (state_37858[(2)]);
var state_37858__$1 = state_37858;
var statearr_37866_37895 = state_37858__$1;
(statearr_37866_37895[(2)] = inst_37848);

(statearr_37866_37895[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (13))){
var state_37858__$1 = state_37858;
var statearr_37867_37896 = state_37858__$1;
(statearr_37867_37896[(2)] = null);

(statearr_37867_37896[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (6))){
var inst_37818 = (state_37858[(8)]);
var inst_37843 = inst_37818.length;
var inst_37844 = (inst_37843 > (0));
var state_37858__$1 = state_37858;
if(cljs.core.truth_(inst_37844)){
var statearr_37868_37897 = state_37858__$1;
(statearr_37868_37897[(1)] = (12));

} else {
var statearr_37869_37898 = state_37858__$1;
(statearr_37869_37898[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (3))){
var inst_37856 = (state_37858[(2)]);
var state_37858__$1 = state_37858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37858__$1,inst_37856);
} else {
if((state_val_37859 === (12))){
var inst_37818 = (state_37858[(8)]);
var inst_37846 = cljs.core.vec(inst_37818);
var state_37858__$1 = state_37858;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37858__$1,(15),out,inst_37846);
} else {
if((state_val_37859 === (2))){
var state_37858__$1 = state_37858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37858__$1,(4),ch);
} else {
if((state_val_37859 === (11))){
var inst_37826 = (state_37858[(10)]);
var inst_37822 = (state_37858[(9)]);
var inst_37836 = (state_37858[(2)]);
var inst_37837 = [];
var inst_37838 = inst_37837.push(inst_37822);
var inst_37818 = inst_37837;
var inst_37819 = inst_37826;
var state_37858__$1 = (function (){var statearr_37870 = state_37858;
(statearr_37870[(7)] = inst_37819);

(statearr_37870[(8)] = inst_37818);

(statearr_37870[(11)] = inst_37838);

(statearr_37870[(12)] = inst_37836);

return statearr_37870;
})();
var statearr_37871_37899 = state_37858__$1;
(statearr_37871_37899[(2)] = null);

(statearr_37871_37899[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (9))){
var inst_37818 = (state_37858[(8)]);
var inst_37834 = cljs.core.vec(inst_37818);
var state_37858__$1 = state_37858;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37858__$1,(11),out,inst_37834);
} else {
if((state_val_37859 === (5))){
var inst_37819 = (state_37858[(7)]);
var inst_37826 = (state_37858[(10)]);
var inst_37822 = (state_37858[(9)]);
var inst_37826__$1 = (function (){var G__37872 = inst_37822;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__37872) : f.call(null,G__37872));
})();
var inst_37827 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37826__$1,inst_37819);
var inst_37828 = cljs.core.keyword_identical_QMARK_(inst_37819,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_37829 = (inst_37827) || (inst_37828);
var state_37858__$1 = (function (){var statearr_37873 = state_37858;
(statearr_37873[(10)] = inst_37826__$1);

return statearr_37873;
})();
if(cljs.core.truth_(inst_37829)){
var statearr_37874_37900 = state_37858__$1;
(statearr_37874_37900[(1)] = (8));

} else {
var statearr_37875_37901 = state_37858__$1;
(statearr_37875_37901[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (14))){
var inst_37851 = (state_37858[(2)]);
var inst_37852 = cljs.core.async.close_BANG_(out);
var state_37858__$1 = (function (){var statearr_37877 = state_37858;
(statearr_37877[(13)] = inst_37851);

return statearr_37877;
})();
var statearr_37878_37902 = state_37858__$1;
(statearr_37878_37902[(2)] = inst_37852);

(statearr_37878_37902[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (10))){
var inst_37841 = (state_37858[(2)]);
var state_37858__$1 = state_37858;
var statearr_37879_37903 = state_37858__$1;
(statearr_37879_37903[(2)] = inst_37841);

(statearr_37879_37903[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_37859 === (8))){
var inst_37818 = (state_37858[(8)]);
var inst_37826 = (state_37858[(10)]);
var inst_37822 = (state_37858[(9)]);
var inst_37831 = inst_37818.push(inst_37822);
var tmp37876 = inst_37818;
var inst_37818__$1 = tmp37876;
var inst_37819 = inst_37826;
var state_37858__$1 = (function (){var statearr_37880 = state_37858;
(statearr_37880[(7)] = inst_37819);

(statearr_37880[(8)] = inst_37818__$1);

(statearr_37880[(14)] = inst_37831);

return statearr_37880;
})();
var statearr_37881_37904 = state_37858__$1;
(statearr_37881_37904[(2)] = null);

(statearr_37881_37904[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto___37890,out))
;
return ((function (switch__11560__auto__,c__11622__auto___37890,out){
return (function() {
var cljs$core$async$state_machine__11561__auto__ = null;
var cljs$core$async$state_machine__11561__auto____0 = (function (){
var statearr_37885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37885[(0)] = cljs$core$async$state_machine__11561__auto__);

(statearr_37885[(1)] = (1));

return statearr_37885;
});
var cljs$core$async$state_machine__11561__auto____1 = (function (state_37858){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_37858);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e37886){if((e37886 instanceof Object)){
var ex__11564__auto__ = e37886;
var statearr_37887_37905 = state_37858;
(statearr_37887_37905[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37858);

return cljs.core.constant$keyword$recur;
} else {
throw e37886;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__37906 = state_37858;
state_37858 = G__37906;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs$core$async$state_machine__11561__auto__ = function(state_37858){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11561__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11561__auto____1.call(this,state_37858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11561__auto____0;
cljs$core$async$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11561__auto____1;
return cljs$core$async$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto___37890,out))
})();
var state__11624__auto__ = (function (){var statearr_37888 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_37888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto___37890);

return statearr_37888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto___37890,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
