// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like.call(null,elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__11037 = arguments.length;
switch (G__11037) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__11038 = dommy.template.__GT_node_like.call(null,parent);
G__11038.appendChild(dommy.template.__GT_node_like.call(null,child));

return G__11038;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11039_11044 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11040_11045 = null;
var count__11041_11046 = (0);
var i__11042_11047 = (0);
while(true){
if((i__11042_11047 < count__11041_11046)){
var c_11048 = cljs.core._nth.call(null,chunk__11040_11045,i__11042_11047);
dommy.core.append_BANG_.call(null,parent__$1,c_11048);

var G__11049 = seq__11039_11044;
var G__11050 = chunk__11040_11045;
var G__11051 = count__11041_11046;
var G__11052 = (i__11042_11047 + (1));
seq__11039_11044 = G__11049;
chunk__11040_11045 = G__11050;
count__11041_11046 = G__11051;
i__11042_11047 = G__11052;
continue;
} else {
var temp__4126__auto___11053 = cljs.core.seq.call(null,seq__11039_11044);
if(temp__4126__auto___11053){
var seq__11039_11054__$1 = temp__4126__auto___11053;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11039_11054__$1)){
var c__5061__auto___11055 = cljs.core.chunk_first.call(null,seq__11039_11054__$1);
var G__11056 = cljs.core.chunk_rest.call(null,seq__11039_11054__$1);
var G__11057 = c__5061__auto___11055;
var G__11058 = cljs.core.count.call(null,c__5061__auto___11055);
var G__11059 = (0);
seq__11039_11044 = G__11056;
chunk__11040_11045 = G__11057;
count__11041_11046 = G__11058;
i__11042_11047 = G__11059;
continue;
} else {
var c_11060 = cljs.core.first.call(null,seq__11039_11054__$1);
dommy.core.append_BANG_.call(null,parent__$1,c_11060);

var G__11061 = cljs.core.next.call(null,seq__11039_11054__$1);
var G__11062 = null;
var G__11063 = (0);
var G__11064 = (0);
seq__11039_11044 = G__11061;
chunk__11040_11045 = G__11062;
count__11041_11046 = G__11063;
i__11042_11047 = G__11064;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq11033){
var G__11034 = cljs.core.first.call(null,seq11033);
var seq11033__$1 = cljs.core.next.call(null,seq11033);
var G__11035 = cljs.core.first.call(null,seq11033__$1);
var seq11033__$2 = cljs.core.next.call(null,seq11033__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11034,G__11035,seq11033__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__11069 = arguments.length;
switch (G__11069) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like.call(null,child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11070_11075 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11071_11076 = null;
var count__11072_11077 = (0);
var i__11073_11078 = (0);
while(true){
if((i__11073_11078 < count__11072_11077)){
var c_11079 = cljs.core._nth.call(null,chunk__11071_11076,i__11073_11078);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11079);

var G__11080 = seq__11070_11075;
var G__11081 = chunk__11071_11076;
var G__11082 = count__11072_11077;
var G__11083 = (i__11073_11078 + (1));
seq__11070_11075 = G__11080;
chunk__11071_11076 = G__11081;
count__11072_11077 = G__11082;
i__11073_11078 = G__11083;
continue;
} else {
var temp__4126__auto___11084 = cljs.core.seq.call(null,seq__11070_11075);
if(temp__4126__auto___11084){
var seq__11070_11085__$1 = temp__4126__auto___11084;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11070_11085__$1)){
var c__5061__auto___11086 = cljs.core.chunk_first.call(null,seq__11070_11085__$1);
var G__11087 = cljs.core.chunk_rest.call(null,seq__11070_11085__$1);
var G__11088 = c__5061__auto___11086;
var G__11089 = cljs.core.count.call(null,c__5061__auto___11086);
var G__11090 = (0);
seq__11070_11075 = G__11087;
chunk__11071_11076 = G__11088;
count__11072_11077 = G__11089;
i__11073_11078 = G__11090;
continue;
} else {
var c_11091 = cljs.core.first.call(null,seq__11070_11085__$1);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11091);

var G__11092 = cljs.core.next.call(null,seq__11070_11085__$1);
var G__11093 = null;
var G__11094 = (0);
var G__11095 = (0);
seq__11070_11075 = G__11092;
chunk__11071_11076 = G__11093;
count__11072_11077 = G__11094;
i__11073_11078 = G__11095;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq11065){
var G__11066 = cljs.core.first.call(null,seq11065);
var seq11065__$1 = cljs.core.next.call(null,seq11065);
var G__11067 = cljs.core.first.call(null,seq11065__$1);
var seq11065__$2 = cljs.core.next.call(null,seq11065__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11066,G__11067,seq11065__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
var parent = other__$1.parentNode;
var temp__4124__auto___11096 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___11096)){
var next_11097 = temp__4124__auto___11096;
parent.insertBefore(actual_node,next_11097);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like.call(null,new$);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__11099 = dommy.template.__GT_node_like.call(null,parent);
G__11099.innerHTML = "";

dommy.core.append_BANG_.call(null,G__11099,node_like);

return G__11099;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var G__11101 = elem__$1.parentNode;
G__11101.removeChild(elem__$1);

return G__11101;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like.call(null,template);
if(!(cljs.core.contains_QMARK_.call(null,key_selectors_map,new cljs.core.Keyword(null,"container","container",-1736937707)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),new cljs.core.Keyword(null,"container","container",-1736937707)))))].join('')));
}

return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container","container",-1736937707),container], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (container){
return (function (p__11107){
var vec__11108 = p__11107;
var k = cljs.core.nth.call(null,vec__11108,(0),null);
var v = cljs.core.nth.call(null,vec__11108,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(new cljs.core.Keyword(null,"live","live",-1610148039).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))?(function (){
if(typeof dommy.core.t11109 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t11109 = (function (v,k,vec__11108,p__11107,container,key_selectors_map,template,selector_map,meta11110){
this.v = v;
this.k = k;
this.vec__11108 = vec__11108;
this.p__11107 = p__11107;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta11110 = meta11110;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t11109.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__11108,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,self__.container).querySelectorAll(dommy.core.selector.call(null,self__.v)));
});})(vec__11108,k,v,container))
;

dommy.core.t11109.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__11108,k,v,container){
return (function (_11111){
var self__ = this;
var _11111__$1 = this;
return self__.meta11110;
});})(vec__11108,k,v,container))
;

dommy.core.t11109.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__11108,k,v,container){
return (function (_11111,meta11110__$1){
var self__ = this;
var _11111__$1 = this;
return (new dommy.core.t11109(self__.v,self__.k,self__.vec__11108,self__.p__11107,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta11110__$1));
});})(vec__11108,k,v,container))
;

dommy.core.t11109.cljs$lang$type = true;

dommy.core.t11109.cljs$lang$ctorStr = "dommy.core/t11109";

dommy.core.t11109.cljs$lang$ctorPrWriter = ((function (vec__11108,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"dommy.core/t11109");
});})(vec__11108,k,v,container))
;

dommy.core.__GT_t11109 = ((function (vec__11108,k,v,container){
return (function dommy$core$selector_map_$___GT_t11109(v__$1,k__$1,vec__11108__$1,p__11107__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11110){
return (new dommy.core.t11109(v__$1,k__$1,vec__11108__$1,p__11107__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11110));
});})(vec__11108,k,v,container))
;

}

return (new dommy.core.t11109(v,k,vec__11108,p__11107,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like.call(null,container).querySelector(dommy.core.selector.call(null,v)))], null);
});})(container))
,key_selectors_map)));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,(function (p1__11112_SHARP_){
return p1__11112_SHARP_.parentNode;
}),dommy.template.__GT_node_like.call(null,elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__11114 = arguments.length;
switch (G__11114) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,dommy.template.__GT_node_like.call(null,base)).querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__11118 = arguments.length;
switch (G__11118) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like.call(null,base);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base__$1,selector),cljs.core.take_while.call(null,((function (base__$1,elem__$1){
return (function (p1__11116_SHARP_){
return !((p1__11116_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes.call(null,elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,selector),dommy.core.ancestor_nodes.call(null,dommy.template.__GT_node_like.call(null,elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like.call(null,descendant);
var ancestor__$1 = dommy.template.__GT_node_like.call(null,ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__11120){
var vec__11121 = p__11120;
var special_mouse_event = cljs.core.nth.call(null,vec__11121,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__11121,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__11121,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__11121,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__11121,special_mouse_event,real_mouse_event))
});})(vec__11121,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,dommy.template.__GT_node_like.call(null,elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like.call(null,elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq11122){
var G__11123 = cljs.core.first.call(null,seq11122);
var seq11122__$1 = cljs.core.next.call(null,seq11122);
var G__11124 = cljs.core.first.call(null,seq11122__$1);
var seq11122__$2 = cljs.core.next.call(null,seq11122__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11123,G__11124,seq11122__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,(function (p1__11125_SHARP_){
return dommy.template.__GT_node_like.call(null,cljs.core.first.call(null,p1__11125_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like.call(null,elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11128_11151 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11152 = cljs.core.nth.call(null,vec__11128_11151,(0),null);
var selector_11153 = cljs.core.nth.call(null,vec__11128_11151,(1),null);
var seq__11129_11154 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11136_11155 = null;
var count__11137_11156 = (0);
var i__11138_11157 = (0);
while(true){
if((i__11138_11157 < count__11137_11156)){
var vec__11145_11158 = cljs.core._nth.call(null,chunk__11136_11155,i__11138_11157);
var orig_type_11159 = cljs.core.nth.call(null,vec__11145_11158,(0),null);
var f_11160 = cljs.core.nth.call(null,vec__11145_11158,(1),null);
var seq__11139_11161 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11159,new cljs.core.PersistentArrayMap.fromArray([orig_type_11159,cljs.core.identity], true, false)));
var chunk__11141_11162 = null;
var count__11142_11163 = (0);
var i__11143_11164 = (0);
while(true){
if((i__11143_11164 < count__11142_11163)){
var vec__11146_11165 = cljs.core._nth.call(null,chunk__11141_11162,i__11143_11164);
var actual_type_11166 = cljs.core.nth.call(null,vec__11146_11165,(0),null);
var factory_11167 = cljs.core.nth.call(null,vec__11146_11165,(1),null);
var canonical_f_11168 = (cljs.core.truth_(selector_11153)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11152,selector_11153):cljs.core.identity).call(null,factory_11167.call(null,f_11160));
dommy.core.update_event_listeners_BANG_.call(null,elem_11152,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11153,actual_type_11166,f_11160], null),canonical_f_11168);

if(cljs.core.truth_(elem_11152.addEventListener)){
elem_11152.addEventListener(cljs.core.name.call(null,actual_type_11166),canonical_f_11168);
} else {
elem_11152.attachEvent(cljs.core.name.call(null,actual_type_11166),canonical_f_11168);
}

var G__11169 = seq__11139_11161;
var G__11170 = chunk__11141_11162;
var G__11171 = count__11142_11163;
var G__11172 = (i__11143_11164 + (1));
seq__11139_11161 = G__11169;
chunk__11141_11162 = G__11170;
count__11142_11163 = G__11171;
i__11143_11164 = G__11172;
continue;
} else {
var temp__4126__auto___11173 = cljs.core.seq.call(null,seq__11139_11161);
if(temp__4126__auto___11173){
var seq__11139_11174__$1 = temp__4126__auto___11173;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11139_11174__$1)){
var c__5061__auto___11175 = cljs.core.chunk_first.call(null,seq__11139_11174__$1);
var G__11176 = cljs.core.chunk_rest.call(null,seq__11139_11174__$1);
var G__11177 = c__5061__auto___11175;
var G__11178 = cljs.core.count.call(null,c__5061__auto___11175);
var G__11179 = (0);
seq__11139_11161 = G__11176;
chunk__11141_11162 = G__11177;
count__11142_11163 = G__11178;
i__11143_11164 = G__11179;
continue;
} else {
var vec__11147_11180 = cljs.core.first.call(null,seq__11139_11174__$1);
var actual_type_11181 = cljs.core.nth.call(null,vec__11147_11180,(0),null);
var factory_11182 = cljs.core.nth.call(null,vec__11147_11180,(1),null);
var canonical_f_11183 = (cljs.core.truth_(selector_11153)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11152,selector_11153):cljs.core.identity).call(null,factory_11182.call(null,f_11160));
dommy.core.update_event_listeners_BANG_.call(null,elem_11152,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11153,actual_type_11181,f_11160], null),canonical_f_11183);

if(cljs.core.truth_(elem_11152.addEventListener)){
elem_11152.addEventListener(cljs.core.name.call(null,actual_type_11181),canonical_f_11183);
} else {
elem_11152.attachEvent(cljs.core.name.call(null,actual_type_11181),canonical_f_11183);
}

var G__11184 = cljs.core.next.call(null,seq__11139_11174__$1);
var G__11185 = null;
var G__11186 = (0);
var G__11187 = (0);
seq__11139_11161 = G__11184;
chunk__11141_11162 = G__11185;
count__11142_11163 = G__11186;
i__11143_11164 = G__11187;
continue;
}
} else {
}
}
break;
}

var G__11188 = seq__11129_11154;
var G__11189 = chunk__11136_11155;
var G__11190 = count__11137_11156;
var G__11191 = (i__11138_11157 + (1));
seq__11129_11154 = G__11188;
chunk__11136_11155 = G__11189;
count__11137_11156 = G__11190;
i__11138_11157 = G__11191;
continue;
} else {
var temp__4126__auto___11192 = cljs.core.seq.call(null,seq__11129_11154);
if(temp__4126__auto___11192){
var seq__11129_11193__$1 = temp__4126__auto___11192;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11129_11193__$1)){
var c__5061__auto___11194 = cljs.core.chunk_first.call(null,seq__11129_11193__$1);
var G__11195 = cljs.core.chunk_rest.call(null,seq__11129_11193__$1);
var G__11196 = c__5061__auto___11194;
var G__11197 = cljs.core.count.call(null,c__5061__auto___11194);
var G__11198 = (0);
seq__11129_11154 = G__11195;
chunk__11136_11155 = G__11196;
count__11137_11156 = G__11197;
i__11138_11157 = G__11198;
continue;
} else {
var vec__11148_11199 = cljs.core.first.call(null,seq__11129_11193__$1);
var orig_type_11200 = cljs.core.nth.call(null,vec__11148_11199,(0),null);
var f_11201 = cljs.core.nth.call(null,vec__11148_11199,(1),null);
var seq__11130_11202 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11200,new cljs.core.PersistentArrayMap.fromArray([orig_type_11200,cljs.core.identity], true, false)));
var chunk__11132_11203 = null;
var count__11133_11204 = (0);
var i__11134_11205 = (0);
while(true){
if((i__11134_11205 < count__11133_11204)){
var vec__11149_11206 = cljs.core._nth.call(null,chunk__11132_11203,i__11134_11205);
var actual_type_11207 = cljs.core.nth.call(null,vec__11149_11206,(0),null);
var factory_11208 = cljs.core.nth.call(null,vec__11149_11206,(1),null);
var canonical_f_11209 = (cljs.core.truth_(selector_11153)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11152,selector_11153):cljs.core.identity).call(null,factory_11208.call(null,f_11201));
dommy.core.update_event_listeners_BANG_.call(null,elem_11152,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11153,actual_type_11207,f_11201], null),canonical_f_11209);

if(cljs.core.truth_(elem_11152.addEventListener)){
elem_11152.addEventListener(cljs.core.name.call(null,actual_type_11207),canonical_f_11209);
} else {
elem_11152.attachEvent(cljs.core.name.call(null,actual_type_11207),canonical_f_11209);
}

var G__11210 = seq__11130_11202;
var G__11211 = chunk__11132_11203;
var G__11212 = count__11133_11204;
var G__11213 = (i__11134_11205 + (1));
seq__11130_11202 = G__11210;
chunk__11132_11203 = G__11211;
count__11133_11204 = G__11212;
i__11134_11205 = G__11213;
continue;
} else {
var temp__4126__auto___11214__$1 = cljs.core.seq.call(null,seq__11130_11202);
if(temp__4126__auto___11214__$1){
var seq__11130_11215__$1 = temp__4126__auto___11214__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11130_11215__$1)){
var c__5061__auto___11216 = cljs.core.chunk_first.call(null,seq__11130_11215__$1);
var G__11217 = cljs.core.chunk_rest.call(null,seq__11130_11215__$1);
var G__11218 = c__5061__auto___11216;
var G__11219 = cljs.core.count.call(null,c__5061__auto___11216);
var G__11220 = (0);
seq__11130_11202 = G__11217;
chunk__11132_11203 = G__11218;
count__11133_11204 = G__11219;
i__11134_11205 = G__11220;
continue;
} else {
var vec__11150_11221 = cljs.core.first.call(null,seq__11130_11215__$1);
var actual_type_11222 = cljs.core.nth.call(null,vec__11150_11221,(0),null);
var factory_11223 = cljs.core.nth.call(null,vec__11150_11221,(1),null);
var canonical_f_11224 = (cljs.core.truth_(selector_11153)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11152,selector_11153):cljs.core.identity).call(null,factory_11223.call(null,f_11201));
dommy.core.update_event_listeners_BANG_.call(null,elem_11152,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11153,actual_type_11222,f_11201], null),canonical_f_11224);

if(cljs.core.truth_(elem_11152.addEventListener)){
elem_11152.addEventListener(cljs.core.name.call(null,actual_type_11222),canonical_f_11224);
} else {
elem_11152.attachEvent(cljs.core.name.call(null,actual_type_11222),canonical_f_11224);
}

var G__11225 = cljs.core.next.call(null,seq__11130_11215__$1);
var G__11226 = null;
var G__11227 = (0);
var G__11228 = (0);
seq__11130_11202 = G__11225;
chunk__11132_11203 = G__11226;
count__11133_11204 = G__11227;
i__11134_11205 = G__11228;
continue;
}
} else {
}
}
break;
}

var G__11229 = cljs.core.next.call(null,seq__11129_11193__$1);
var G__11230 = null;
var G__11231 = (0);
var G__11232 = (0);
seq__11129_11154 = G__11229;
chunk__11136_11155 = G__11230;
count__11137_11156 = G__11231;
i__11138_11157 = G__11232;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq11126){
var G__11127 = cljs.core.first.call(null,seq11126);
var seq11126__$1 = cljs.core.next.call(null,seq11126);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11127,seq11126__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11235_11258 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11259 = cljs.core.nth.call(null,vec__11235_11258,(0),null);
var selector_11260 = cljs.core.nth.call(null,vec__11235_11258,(1),null);
var seq__11236_11261 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11243_11262 = null;
var count__11244_11263 = (0);
var i__11245_11264 = (0);
while(true){
if((i__11245_11264 < count__11244_11263)){
var vec__11252_11265 = cljs.core._nth.call(null,chunk__11243_11262,i__11245_11264);
var orig_type_11266 = cljs.core.nth.call(null,vec__11252_11265,(0),null);
var f_11267 = cljs.core.nth.call(null,vec__11252_11265,(1),null);
var seq__11246_11268 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11266,new cljs.core.PersistentArrayMap.fromArray([orig_type_11266,cljs.core.identity], true, false)));
var chunk__11248_11269 = null;
var count__11249_11270 = (0);
var i__11250_11271 = (0);
while(true){
if((i__11250_11271 < count__11249_11270)){
var vec__11253_11272 = cljs.core._nth.call(null,chunk__11248_11269,i__11250_11271);
var actual_type_11273 = cljs.core.nth.call(null,vec__11253_11272,(0),null);
var __11274 = cljs.core.nth.call(null,vec__11253_11272,(1),null);
var keys_11275 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11260,actual_type_11273,f_11267], null);
var canonical_f_11276 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11259),keys_11275);
dommy.core.update_event_listeners_BANG_.call(null,elem_11259,dommy.utils.dissoc_in,keys_11275);

if(cljs.core.truth_(elem_11259.removeEventListener)){
elem_11259.removeEventListener(cljs.core.name.call(null,actual_type_11273),canonical_f_11276);
} else {
elem_11259.detachEvent(cljs.core.name.call(null,actual_type_11273),canonical_f_11276);
}

var G__11277 = seq__11246_11268;
var G__11278 = chunk__11248_11269;
var G__11279 = count__11249_11270;
var G__11280 = (i__11250_11271 + (1));
seq__11246_11268 = G__11277;
chunk__11248_11269 = G__11278;
count__11249_11270 = G__11279;
i__11250_11271 = G__11280;
continue;
} else {
var temp__4126__auto___11281 = cljs.core.seq.call(null,seq__11246_11268);
if(temp__4126__auto___11281){
var seq__11246_11282__$1 = temp__4126__auto___11281;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11246_11282__$1)){
var c__5061__auto___11283 = cljs.core.chunk_first.call(null,seq__11246_11282__$1);
var G__11284 = cljs.core.chunk_rest.call(null,seq__11246_11282__$1);
var G__11285 = c__5061__auto___11283;
var G__11286 = cljs.core.count.call(null,c__5061__auto___11283);
var G__11287 = (0);
seq__11246_11268 = G__11284;
chunk__11248_11269 = G__11285;
count__11249_11270 = G__11286;
i__11250_11271 = G__11287;
continue;
} else {
var vec__11254_11288 = cljs.core.first.call(null,seq__11246_11282__$1);
var actual_type_11289 = cljs.core.nth.call(null,vec__11254_11288,(0),null);
var __11290 = cljs.core.nth.call(null,vec__11254_11288,(1),null);
var keys_11291 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11260,actual_type_11289,f_11267], null);
var canonical_f_11292 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11259),keys_11291);
dommy.core.update_event_listeners_BANG_.call(null,elem_11259,dommy.utils.dissoc_in,keys_11291);

if(cljs.core.truth_(elem_11259.removeEventListener)){
elem_11259.removeEventListener(cljs.core.name.call(null,actual_type_11289),canonical_f_11292);
} else {
elem_11259.detachEvent(cljs.core.name.call(null,actual_type_11289),canonical_f_11292);
}

var G__11293 = cljs.core.next.call(null,seq__11246_11282__$1);
var G__11294 = null;
var G__11295 = (0);
var G__11296 = (0);
seq__11246_11268 = G__11293;
chunk__11248_11269 = G__11294;
count__11249_11270 = G__11295;
i__11250_11271 = G__11296;
continue;
}
} else {
}
}
break;
}

var G__11297 = seq__11236_11261;
var G__11298 = chunk__11243_11262;
var G__11299 = count__11244_11263;
var G__11300 = (i__11245_11264 + (1));
seq__11236_11261 = G__11297;
chunk__11243_11262 = G__11298;
count__11244_11263 = G__11299;
i__11245_11264 = G__11300;
continue;
} else {
var temp__4126__auto___11301 = cljs.core.seq.call(null,seq__11236_11261);
if(temp__4126__auto___11301){
var seq__11236_11302__$1 = temp__4126__auto___11301;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11236_11302__$1)){
var c__5061__auto___11303 = cljs.core.chunk_first.call(null,seq__11236_11302__$1);
var G__11304 = cljs.core.chunk_rest.call(null,seq__11236_11302__$1);
var G__11305 = c__5061__auto___11303;
var G__11306 = cljs.core.count.call(null,c__5061__auto___11303);
var G__11307 = (0);
seq__11236_11261 = G__11304;
chunk__11243_11262 = G__11305;
count__11244_11263 = G__11306;
i__11245_11264 = G__11307;
continue;
} else {
var vec__11255_11308 = cljs.core.first.call(null,seq__11236_11302__$1);
var orig_type_11309 = cljs.core.nth.call(null,vec__11255_11308,(0),null);
var f_11310 = cljs.core.nth.call(null,vec__11255_11308,(1),null);
var seq__11237_11311 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11309,new cljs.core.PersistentArrayMap.fromArray([orig_type_11309,cljs.core.identity], true, false)));
var chunk__11239_11312 = null;
var count__11240_11313 = (0);
var i__11241_11314 = (0);
while(true){
if((i__11241_11314 < count__11240_11313)){
var vec__11256_11315 = cljs.core._nth.call(null,chunk__11239_11312,i__11241_11314);
var actual_type_11316 = cljs.core.nth.call(null,vec__11256_11315,(0),null);
var __11317 = cljs.core.nth.call(null,vec__11256_11315,(1),null);
var keys_11318 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11260,actual_type_11316,f_11310], null);
var canonical_f_11319 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11259),keys_11318);
dommy.core.update_event_listeners_BANG_.call(null,elem_11259,dommy.utils.dissoc_in,keys_11318);

if(cljs.core.truth_(elem_11259.removeEventListener)){
elem_11259.removeEventListener(cljs.core.name.call(null,actual_type_11316),canonical_f_11319);
} else {
elem_11259.detachEvent(cljs.core.name.call(null,actual_type_11316),canonical_f_11319);
}

var G__11320 = seq__11237_11311;
var G__11321 = chunk__11239_11312;
var G__11322 = count__11240_11313;
var G__11323 = (i__11241_11314 + (1));
seq__11237_11311 = G__11320;
chunk__11239_11312 = G__11321;
count__11240_11313 = G__11322;
i__11241_11314 = G__11323;
continue;
} else {
var temp__4126__auto___11324__$1 = cljs.core.seq.call(null,seq__11237_11311);
if(temp__4126__auto___11324__$1){
var seq__11237_11325__$1 = temp__4126__auto___11324__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11237_11325__$1)){
var c__5061__auto___11326 = cljs.core.chunk_first.call(null,seq__11237_11325__$1);
var G__11327 = cljs.core.chunk_rest.call(null,seq__11237_11325__$1);
var G__11328 = c__5061__auto___11326;
var G__11329 = cljs.core.count.call(null,c__5061__auto___11326);
var G__11330 = (0);
seq__11237_11311 = G__11327;
chunk__11239_11312 = G__11328;
count__11240_11313 = G__11329;
i__11241_11314 = G__11330;
continue;
} else {
var vec__11257_11331 = cljs.core.first.call(null,seq__11237_11325__$1);
var actual_type_11332 = cljs.core.nth.call(null,vec__11257_11331,(0),null);
var __11333 = cljs.core.nth.call(null,vec__11257_11331,(1),null);
var keys_11334 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11260,actual_type_11332,f_11310], null);
var canonical_f_11335 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11259),keys_11334);
dommy.core.update_event_listeners_BANG_.call(null,elem_11259,dommy.utils.dissoc_in,keys_11334);

if(cljs.core.truth_(elem_11259.removeEventListener)){
elem_11259.removeEventListener(cljs.core.name.call(null,actual_type_11332),canonical_f_11335);
} else {
elem_11259.detachEvent(cljs.core.name.call(null,actual_type_11332),canonical_f_11335);
}

var G__11336 = cljs.core.next.call(null,seq__11237_11325__$1);
var G__11337 = null;
var G__11338 = (0);
var G__11339 = (0);
seq__11237_11311 = G__11336;
chunk__11239_11312 = G__11337;
count__11240_11313 = G__11338;
i__11241_11314 = G__11339;
continue;
}
} else {
}
}
break;
}

var G__11340 = cljs.core.next.call(null,seq__11236_11302__$1);
var G__11341 = null;
var G__11342 = (0);
var G__11343 = (0);
seq__11236_11261 = G__11340;
chunk__11243_11262 = G__11341;
count__11244_11263 = G__11342;
i__11245_11264 = G__11343;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq11233){
var G__11234 = cljs.core.first.call(null,seq11233);
var seq11233__$1 = cljs.core.next.call(null,seq11233);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11234,seq11233__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11346_11353 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11354 = cljs.core.nth.call(null,vec__11346_11353,(0),null);
var selector_11355 = cljs.core.nth.call(null,vec__11346_11353,(1),null);
var seq__11347_11356 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11348_11357 = null;
var count__11349_11358 = (0);
var i__11350_11359 = (0);
while(true){
if((i__11350_11359 < count__11349_11358)){
var vec__11351_11360 = cljs.core._nth.call(null,chunk__11348_11357,i__11350_11359);
var type_11361 = cljs.core.nth.call(null,vec__11351_11360,(0),null);
var f_11362 = cljs.core.nth.call(null,vec__11351_11360,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11361,((function (seq__11347_11356,chunk__11348_11357,count__11349_11358,i__11350_11359,vec__11351_11360,type_11361,f_11362,vec__11346_11353,elem_11354,selector_11355){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11361,dommy$core$this_fn);

return f_11362.call(null,e);
});})(seq__11347_11356,chunk__11348_11357,count__11349_11358,i__11350_11359,vec__11351_11360,type_11361,f_11362,vec__11346_11353,elem_11354,selector_11355))
);

var G__11363 = seq__11347_11356;
var G__11364 = chunk__11348_11357;
var G__11365 = count__11349_11358;
var G__11366 = (i__11350_11359 + (1));
seq__11347_11356 = G__11363;
chunk__11348_11357 = G__11364;
count__11349_11358 = G__11365;
i__11350_11359 = G__11366;
continue;
} else {
var temp__4126__auto___11367 = cljs.core.seq.call(null,seq__11347_11356);
if(temp__4126__auto___11367){
var seq__11347_11368__$1 = temp__4126__auto___11367;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11347_11368__$1)){
var c__5061__auto___11369 = cljs.core.chunk_first.call(null,seq__11347_11368__$1);
var G__11370 = cljs.core.chunk_rest.call(null,seq__11347_11368__$1);
var G__11371 = c__5061__auto___11369;
var G__11372 = cljs.core.count.call(null,c__5061__auto___11369);
var G__11373 = (0);
seq__11347_11356 = G__11370;
chunk__11348_11357 = G__11371;
count__11349_11358 = G__11372;
i__11350_11359 = G__11373;
continue;
} else {
var vec__11352_11374 = cljs.core.first.call(null,seq__11347_11368__$1);
var type_11375 = cljs.core.nth.call(null,vec__11352_11374,(0),null);
var f_11376 = cljs.core.nth.call(null,vec__11352_11374,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11375,((function (seq__11347_11356,chunk__11348_11357,count__11349_11358,i__11350_11359,vec__11352_11374,type_11375,f_11376,seq__11347_11368__$1,temp__4126__auto___11367,vec__11346_11353,elem_11354,selector_11355){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11375,dommy$core$this_fn);

return f_11376.call(null,e);
});})(seq__11347_11356,chunk__11348_11357,count__11349_11358,i__11350_11359,vec__11352_11374,type_11375,f_11376,seq__11347_11368__$1,temp__4126__auto___11367,vec__11346_11353,elem_11354,selector_11355))
);

var G__11377 = cljs.core.next.call(null,seq__11347_11368__$1);
var G__11378 = null;
var G__11379 = (0);
var G__11380 = (0);
seq__11347_11356 = G__11377;
chunk__11348_11357 = G__11378;
count__11349_11358 = G__11379;
i__11350_11359 = G__11380;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq11344){
var G__11345 = cljs.core.first.call(null,seq11344);
var seq11344__$1 = cljs.core.next.call(null,seq11344);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11345,seq11344__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__11384){
var vec__11385 = p__11384;
var update_event_BANG_ = cljs.core.nth.call(null,vec__11385,(0),null);
if(dommy.core.descendant_QMARK_.call(null,node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name.call(null,event_type),true,true);

return node.dispatchEvent(update_event_BANG___$1.call(null,event));
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name.call(null,event_type))].join(''),update_event_BANG___$1.call(null,document.createEventObject()));
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq11381){
var G__11382 = cljs.core.first.call(null,seq11381);
var seq11381__$1 = cljs.core.next.call(null,seq11381);
var G__11383 = cljs.core.first.call(null,seq11381__$1);
var seq11381__$2 = cljs.core.next.call(null,seq11381__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11382,G__11383,seq11381__$2);
});
