// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t12355 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12355 = (function (f,fn_handler,meta12356){
this.f = f;
this.fn_handler = fn_handler;
this.meta12356 = meta12356;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12355.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12355.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t12355.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t12355.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12357){
var self__ = this;
var _12357__$1 = this;
return self__.meta12356;
});

cljs.core.async.t12355.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12357,meta12356__$1){
var self__ = this;
var _12357__$1 = this;
return (new cljs.core.async.t12355(self__.f,self__.fn_handler,meta12356__$1));
});

cljs.core.async.t12355.cljs$lang$type = true;

cljs.core.async.t12355.cljs$lang$ctorStr = "cljs.core.async/t12355";

cljs.core.async.t12355.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12355");
});

cljs.core.async.__GT_t12355 = (function cljs$core$async$fn_handler_$___GT_t12355(f__$1,fn_handler__$1,meta12356){
return (new cljs.core.async.t12355(f__$1,fn_handler__$1,meta12356));
});

}

return (new cljs.core.async.t12355(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__12359 = buff;
if(G__12359){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__12359.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__12359.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12359);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12359);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__12361 = arguments.length;
switch (G__12361) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__12364 = arguments.length;
switch (G__12364) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12366 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12366);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12366,ret){
return (function (){
return fn1.call(null,val_12366);
});})(val_12366,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__12368 = arguments.length;
switch (G__12368) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___12370 = n;
var x_12371 = (0);
while(true){
if((x_12371 < n__5161__auto___12370)){
(a[x_12371] = (0));

var G__12372 = (x_12371 + (1));
x_12371 = G__12372;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12373 = (i + (1));
i = G__12373;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t12377 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12377 = (function (flag,alt_flag,meta12378){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta12378 = meta12378;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12377.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12377.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t12377.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t12377.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12379){
var self__ = this;
var _12379__$1 = this;
return self__.meta12378;
});})(flag))
;

cljs.core.async.t12377.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12379,meta12378__$1){
var self__ = this;
var _12379__$1 = this;
return (new cljs.core.async.t12377(self__.flag,self__.alt_flag,meta12378__$1));
});})(flag))
;

cljs.core.async.t12377.cljs$lang$type = true;

cljs.core.async.t12377.cljs$lang$ctorStr = "cljs.core.async/t12377";

cljs.core.async.t12377.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12377");
});})(flag))
;

cljs.core.async.__GT_t12377 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t12377(flag__$1,alt_flag__$1,meta12378){
return (new cljs.core.async.t12377(flag__$1,alt_flag__$1,meta12378));
});})(flag))
;

}

return (new cljs.core.async.t12377(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t12383 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12383 = (function (cb,flag,alt_handler,meta12384){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta12384 = meta12384;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12383.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12383.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t12383.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t12383.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12385){
var self__ = this;
var _12385__$1 = this;
return self__.meta12384;
});

cljs.core.async.t12383.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12385,meta12384__$1){
var self__ = this;
var _12385__$1 = this;
return (new cljs.core.async.t12383(self__.cb,self__.flag,self__.alt_handler,meta12384__$1));
});

cljs.core.async.t12383.cljs$lang$type = true;

cljs.core.async.t12383.cljs$lang$ctorStr = "cljs.core.async/t12383";

cljs.core.async.t12383.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12383");
});

cljs.core.async.__GT_t12383 = (function cljs$core$async$alt_handler_$___GT_t12383(cb__$1,flag__$1,alt_handler__$1,meta12384){
return (new cljs.core.async.t12383(cb__$1,flag__$1,alt_handler__$1,meta12384));
});

}

return (new cljs.core.async.t12383(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12386_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12386_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12387_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12387_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12388 = (i + (1));
i = G__12388;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12391){
var map__12392 = p__12391;
var map__12392__$1 = ((cljs.core.seq_QMARK_.call(null,map__12392))?cljs.core.apply.call(null,cljs.core.hash_map,map__12392):map__12392);
var opts = map__12392__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12389){
var G__12390 = cljs.core.first.call(null,seq12389);
var seq12389__$1 = cljs.core.next.call(null,seq12389);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12390,seq12389__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__12394 = arguments.length;
switch (G__12394) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___12443 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12443){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12443){
return (function (state_12418){
var state_val_12419 = (state_12418[(1)]);
if((state_val_12419 === (7))){
var inst_12414 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
var statearr_12420_12444 = state_12418__$1;
(statearr_12420_12444[(2)] = inst_12414);

(statearr_12420_12444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (1))){
var state_12418__$1 = state_12418;
var statearr_12421_12445 = state_12418__$1;
(statearr_12421_12445[(2)] = null);

(statearr_12421_12445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (4))){
var inst_12397 = (state_12418[(7)]);
var inst_12397__$1 = (state_12418[(2)]);
var inst_12398 = (inst_12397__$1 == null);
var state_12418__$1 = (function (){var statearr_12422 = state_12418;
(statearr_12422[(7)] = inst_12397__$1);

return statearr_12422;
})();
if(cljs.core.truth_(inst_12398)){
var statearr_12423_12446 = state_12418__$1;
(statearr_12423_12446[(1)] = (5));

} else {
var statearr_12424_12447 = state_12418__$1;
(statearr_12424_12447[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (13))){
var state_12418__$1 = state_12418;
var statearr_12425_12448 = state_12418__$1;
(statearr_12425_12448[(2)] = null);

(statearr_12425_12448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (6))){
var inst_12397 = (state_12418[(7)]);
var state_12418__$1 = state_12418;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12418__$1,(11),to,inst_12397);
} else {
if((state_val_12419 === (3))){
var inst_12416 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12418__$1,inst_12416);
} else {
if((state_val_12419 === (12))){
var state_12418__$1 = state_12418;
var statearr_12426_12449 = state_12418__$1;
(statearr_12426_12449[(2)] = null);

(statearr_12426_12449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (2))){
var state_12418__$1 = state_12418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12418__$1,(4),from);
} else {
if((state_val_12419 === (11))){
var inst_12407 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
if(cljs.core.truth_(inst_12407)){
var statearr_12427_12450 = state_12418__$1;
(statearr_12427_12450[(1)] = (12));

} else {
var statearr_12428_12451 = state_12418__$1;
(statearr_12428_12451[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (9))){
var state_12418__$1 = state_12418;
var statearr_12429_12452 = state_12418__$1;
(statearr_12429_12452[(2)] = null);

(statearr_12429_12452[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (5))){
var state_12418__$1 = state_12418;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12430_12453 = state_12418__$1;
(statearr_12430_12453[(1)] = (8));

} else {
var statearr_12431_12454 = state_12418__$1;
(statearr_12431_12454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (14))){
var inst_12412 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
var statearr_12432_12455 = state_12418__$1;
(statearr_12432_12455[(2)] = inst_12412);

(statearr_12432_12455[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (10))){
var inst_12404 = (state_12418[(2)]);
var state_12418__$1 = state_12418;
var statearr_12433_12456 = state_12418__$1;
(statearr_12433_12456[(2)] = inst_12404);

(statearr_12433_12456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12419 === (8))){
var inst_12401 = cljs.core.async.close_BANG_.call(null,to);
var state_12418__$1 = state_12418;
var statearr_12434_12457 = state_12418__$1;
(statearr_12434_12457[(2)] = inst_12401);

(statearr_12434_12457[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12443))
;
return ((function (switch__7647__auto__,c__7709__auto___12443){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12438 = [null,null,null,null,null,null,null,null];
(statearr_12438[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12438[(1)] = (1));

return statearr_12438;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12418){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12439){if((e12439 instanceof Object)){
var ex__7651__auto__ = e12439;
var statearr_12440_12458 = state_12418;
(statearr_12440_12458[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12418);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12459 = state_12418;
state_12418 = G__12459;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12418){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12443))
})();
var state__7711__auto__ = (function (){var statearr_12441 = f__7710__auto__.call(null);
(statearr_12441[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12443);

return statearr_12441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12443))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12643){
var vec__12644 = p__12643;
var v = cljs.core.nth.call(null,vec__12644,(0),null);
var p = cljs.core.nth.call(null,vec__12644,(1),null);
var job = vec__12644;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7709__auto___12826 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results){
return (function (state_12649){
var state_val_12650 = (state_12649[(1)]);
if((state_val_12650 === (2))){
var inst_12646 = (state_12649[(2)]);
var inst_12647 = cljs.core.async.close_BANG_.call(null,res);
var state_12649__$1 = (function (){var statearr_12651 = state_12649;
(statearr_12651[(7)] = inst_12646);

return statearr_12651;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12649__$1,inst_12647);
} else {
if((state_val_12650 === (1))){
var state_12649__$1 = state_12649;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12649__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12655 = [null,null,null,null,null,null,null,null];
(statearr_12655[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12655[(1)] = (1));

return statearr_12655;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12649){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12656){if((e12656 instanceof Object)){
var ex__7651__auto__ = e12656;
var statearr_12657_12827 = state_12649;
(statearr_12657_12827[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12828 = state_12649;
state_12649 = G__12828;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12649){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_12658 = f__7710__auto__.call(null);
(statearr_12658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12826);

return statearr_12658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12826,res,vec__12644,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12659){
var vec__12660 = p__12659;
var v = cljs.core.nth.call(null,vec__12660,(0),null);
var p = cljs.core.nth.call(null,vec__12660,(1),null);
var job = vec__12660;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___12829 = n;
var __12830 = (0);
while(true){
if((__12830 < n__5161__auto___12829)){
var G__12661_12831 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12661_12831) {
case "async":
var c__7709__auto___12833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12830,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12830,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function (state_12674){
var state_val_12675 = (state_12674[(1)]);
if((state_val_12675 === (7))){
var inst_12670 = (state_12674[(2)]);
var state_12674__$1 = state_12674;
var statearr_12676_12834 = state_12674__$1;
(statearr_12676_12834[(2)] = inst_12670);

(statearr_12676_12834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12675 === (6))){
var state_12674__$1 = state_12674;
var statearr_12677_12835 = state_12674__$1;
(statearr_12677_12835[(2)] = null);

(statearr_12677_12835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12675 === (5))){
var state_12674__$1 = state_12674;
var statearr_12678_12836 = state_12674__$1;
(statearr_12678_12836[(2)] = null);

(statearr_12678_12836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12675 === (4))){
var inst_12664 = (state_12674[(2)]);
var inst_12665 = async.call(null,inst_12664);
var state_12674__$1 = state_12674;
if(cljs.core.truth_(inst_12665)){
var statearr_12679_12837 = state_12674__$1;
(statearr_12679_12837[(1)] = (5));

} else {
var statearr_12680_12838 = state_12674__$1;
(statearr_12680_12838[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12675 === (3))){
var inst_12672 = (state_12674[(2)]);
var state_12674__$1 = state_12674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12674__$1,inst_12672);
} else {
if((state_val_12675 === (2))){
var state_12674__$1 = state_12674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12674__$1,(4),jobs);
} else {
if((state_val_12675 === (1))){
var state_12674__$1 = state_12674;
var statearr_12681_12839 = state_12674__$1;
(statearr_12681_12839[(2)] = null);

(statearr_12681_12839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12830,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
;
return ((function (__12830,switch__7647__auto__,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12685 = [null,null,null,null,null,null,null];
(statearr_12685[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12685[(1)] = (1));

return statearr_12685;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12674){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12686){if((e12686 instanceof Object)){
var ex__7651__auto__ = e12686;
var statearr_12687_12840 = state_12674;
(statearr_12687_12840[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12674);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12686;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12841 = state_12674;
state_12674 = G__12841;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12674){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12830,switch__7647__auto__,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12688 = f__7710__auto__.call(null);
(statearr_12688[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12833);

return statearr_12688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12830,c__7709__auto___12833,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___12842 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12830,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12830,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function (state_12701){
var state_val_12702 = (state_12701[(1)]);
if((state_val_12702 === (7))){
var inst_12697 = (state_12701[(2)]);
var state_12701__$1 = state_12701;
var statearr_12703_12843 = state_12701__$1;
(statearr_12703_12843[(2)] = inst_12697);

(statearr_12703_12843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12702 === (6))){
var state_12701__$1 = state_12701;
var statearr_12704_12844 = state_12701__$1;
(statearr_12704_12844[(2)] = null);

(statearr_12704_12844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12702 === (5))){
var state_12701__$1 = state_12701;
var statearr_12705_12845 = state_12701__$1;
(statearr_12705_12845[(2)] = null);

(statearr_12705_12845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12702 === (4))){
var inst_12691 = (state_12701[(2)]);
var inst_12692 = process.call(null,inst_12691);
var state_12701__$1 = state_12701;
if(cljs.core.truth_(inst_12692)){
var statearr_12706_12846 = state_12701__$1;
(statearr_12706_12846[(1)] = (5));

} else {
var statearr_12707_12847 = state_12701__$1;
(statearr_12707_12847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12702 === (3))){
var inst_12699 = (state_12701[(2)]);
var state_12701__$1 = state_12701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12701__$1,inst_12699);
} else {
if((state_val_12702 === (2))){
var state_12701__$1 = state_12701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12701__$1,(4),jobs);
} else {
if((state_val_12702 === (1))){
var state_12701__$1 = state_12701;
var statearr_12708_12848 = state_12701__$1;
(statearr_12708_12848[(2)] = null);

(statearr_12708_12848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12830,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
;
return ((function (__12830,switch__7647__auto__,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12712 = [null,null,null,null,null,null,null];
(statearr_12712[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12712[(1)] = (1));

return statearr_12712;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12701){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12713){if((e12713 instanceof Object)){
var ex__7651__auto__ = e12713;
var statearr_12714_12849 = state_12701;
(statearr_12714_12849[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12850 = state_12701;
state_12701 = G__12850;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12701){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12830,switch__7647__auto__,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12715 = f__7710__auto__.call(null);
(statearr_12715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12842);

return statearr_12715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12830,c__7709__auto___12842,G__12661_12831,n__5161__auto___12829,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12851 = (__12830 + (1));
__12830 = G__12851;
continue;
} else {
}
break;
}

var c__7709__auto___12852 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12852,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12852,jobs,results,process,async){
return (function (state_12737){
var state_val_12738 = (state_12737[(1)]);
if((state_val_12738 === (9))){
var inst_12730 = (state_12737[(2)]);
var state_12737__$1 = (function (){var statearr_12739 = state_12737;
(statearr_12739[(7)] = inst_12730);

return statearr_12739;
})();
var statearr_12740_12853 = state_12737__$1;
(statearr_12740_12853[(2)] = null);

(statearr_12740_12853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (8))){
var inst_12723 = (state_12737[(8)]);
var inst_12728 = (state_12737[(2)]);
var state_12737__$1 = (function (){var statearr_12741 = state_12737;
(statearr_12741[(9)] = inst_12728);

return statearr_12741;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12737__$1,(9),results,inst_12723);
} else {
if((state_val_12738 === (7))){
var inst_12733 = (state_12737[(2)]);
var state_12737__$1 = state_12737;
var statearr_12742_12854 = state_12737__$1;
(statearr_12742_12854[(2)] = inst_12733);

(statearr_12742_12854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (6))){
var inst_12718 = (state_12737[(10)]);
var inst_12723 = (state_12737[(8)]);
var inst_12723__$1 = cljs.core.async.chan.call(null,(1));
var inst_12724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12725 = [inst_12718,inst_12723__$1];
var inst_12726 = (new cljs.core.PersistentVector(null,2,(5),inst_12724,inst_12725,null));
var state_12737__$1 = (function (){var statearr_12743 = state_12737;
(statearr_12743[(8)] = inst_12723__$1);

return statearr_12743;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12737__$1,(8),jobs,inst_12726);
} else {
if((state_val_12738 === (5))){
var inst_12721 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12737__$1 = state_12737;
var statearr_12744_12855 = state_12737__$1;
(statearr_12744_12855[(2)] = inst_12721);

(statearr_12744_12855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (4))){
var inst_12718 = (state_12737[(10)]);
var inst_12718__$1 = (state_12737[(2)]);
var inst_12719 = (inst_12718__$1 == null);
var state_12737__$1 = (function (){var statearr_12745 = state_12737;
(statearr_12745[(10)] = inst_12718__$1);

return statearr_12745;
})();
if(cljs.core.truth_(inst_12719)){
var statearr_12746_12856 = state_12737__$1;
(statearr_12746_12856[(1)] = (5));

} else {
var statearr_12747_12857 = state_12737__$1;
(statearr_12747_12857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (3))){
var inst_12735 = (state_12737[(2)]);
var state_12737__$1 = state_12737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12737__$1,inst_12735);
} else {
if((state_val_12738 === (2))){
var state_12737__$1 = state_12737;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12737__$1,(4),from);
} else {
if((state_val_12738 === (1))){
var state_12737__$1 = state_12737;
var statearr_12748_12858 = state_12737__$1;
(statearr_12748_12858[(2)] = null);

(statearr_12748_12858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12852,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___12852,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12752 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12752[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12752[(1)] = (1));

return statearr_12752;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12737){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12753){if((e12753 instanceof Object)){
var ex__7651__auto__ = e12753;
var statearr_12754_12859 = state_12737;
(statearr_12754_12859[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12737);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12753;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12860 = state_12737;
state_12737 = G__12860;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12737){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12852,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12755 = f__7710__auto__.call(null);
(statearr_12755[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12852);

return statearr_12755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12852,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_12793){
var state_val_12794 = (state_12793[(1)]);
if((state_val_12794 === (7))){
var inst_12789 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
var statearr_12795_12861 = state_12793__$1;
(statearr_12795_12861[(2)] = inst_12789);

(statearr_12795_12861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (20))){
var state_12793__$1 = state_12793;
var statearr_12796_12862 = state_12793__$1;
(statearr_12796_12862[(2)] = null);

(statearr_12796_12862[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (1))){
var state_12793__$1 = state_12793;
var statearr_12797_12863 = state_12793__$1;
(statearr_12797_12863[(2)] = null);

(statearr_12797_12863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (4))){
var inst_12758 = (state_12793[(7)]);
var inst_12758__$1 = (state_12793[(2)]);
var inst_12759 = (inst_12758__$1 == null);
var state_12793__$1 = (function (){var statearr_12798 = state_12793;
(statearr_12798[(7)] = inst_12758__$1);

return statearr_12798;
})();
if(cljs.core.truth_(inst_12759)){
var statearr_12799_12864 = state_12793__$1;
(statearr_12799_12864[(1)] = (5));

} else {
var statearr_12800_12865 = state_12793__$1;
(statearr_12800_12865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (15))){
var inst_12771 = (state_12793[(8)]);
var state_12793__$1 = state_12793;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12793__$1,(18),to,inst_12771);
} else {
if((state_val_12794 === (21))){
var inst_12784 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
var statearr_12801_12866 = state_12793__$1;
(statearr_12801_12866[(2)] = inst_12784);

(statearr_12801_12866[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (13))){
var inst_12786 = (state_12793[(2)]);
var state_12793__$1 = (function (){var statearr_12802 = state_12793;
(statearr_12802[(9)] = inst_12786);

return statearr_12802;
})();
var statearr_12803_12867 = state_12793__$1;
(statearr_12803_12867[(2)] = null);

(statearr_12803_12867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (6))){
var inst_12758 = (state_12793[(7)]);
var state_12793__$1 = state_12793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12793__$1,(11),inst_12758);
} else {
if((state_val_12794 === (17))){
var inst_12779 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
if(cljs.core.truth_(inst_12779)){
var statearr_12804_12868 = state_12793__$1;
(statearr_12804_12868[(1)] = (19));

} else {
var statearr_12805_12869 = state_12793__$1;
(statearr_12805_12869[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (3))){
var inst_12791 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12793__$1,inst_12791);
} else {
if((state_val_12794 === (12))){
var inst_12768 = (state_12793[(10)]);
var state_12793__$1 = state_12793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12793__$1,(14),inst_12768);
} else {
if((state_val_12794 === (2))){
var state_12793__$1 = state_12793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12793__$1,(4),results);
} else {
if((state_val_12794 === (19))){
var state_12793__$1 = state_12793;
var statearr_12806_12870 = state_12793__$1;
(statearr_12806_12870[(2)] = null);

(statearr_12806_12870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (11))){
var inst_12768 = (state_12793[(2)]);
var state_12793__$1 = (function (){var statearr_12807 = state_12793;
(statearr_12807[(10)] = inst_12768);

return statearr_12807;
})();
var statearr_12808_12871 = state_12793__$1;
(statearr_12808_12871[(2)] = null);

(statearr_12808_12871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (9))){
var state_12793__$1 = state_12793;
var statearr_12809_12872 = state_12793__$1;
(statearr_12809_12872[(2)] = null);

(statearr_12809_12872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (5))){
var state_12793__$1 = state_12793;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12810_12873 = state_12793__$1;
(statearr_12810_12873[(1)] = (8));

} else {
var statearr_12811_12874 = state_12793__$1;
(statearr_12811_12874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (14))){
var inst_12773 = (state_12793[(11)]);
var inst_12771 = (state_12793[(8)]);
var inst_12771__$1 = (state_12793[(2)]);
var inst_12772 = (inst_12771__$1 == null);
var inst_12773__$1 = cljs.core.not.call(null,inst_12772);
var state_12793__$1 = (function (){var statearr_12812 = state_12793;
(statearr_12812[(11)] = inst_12773__$1);

(statearr_12812[(8)] = inst_12771__$1);

return statearr_12812;
})();
if(inst_12773__$1){
var statearr_12813_12875 = state_12793__$1;
(statearr_12813_12875[(1)] = (15));

} else {
var statearr_12814_12876 = state_12793__$1;
(statearr_12814_12876[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (16))){
var inst_12773 = (state_12793[(11)]);
var state_12793__$1 = state_12793;
var statearr_12815_12877 = state_12793__$1;
(statearr_12815_12877[(2)] = inst_12773);

(statearr_12815_12877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (10))){
var inst_12765 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
var statearr_12816_12878 = state_12793__$1;
(statearr_12816_12878[(2)] = inst_12765);

(statearr_12816_12878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (18))){
var inst_12776 = (state_12793[(2)]);
var state_12793__$1 = state_12793;
var statearr_12817_12879 = state_12793__$1;
(statearr_12817_12879[(2)] = inst_12776);

(statearr_12817_12879[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12794 === (8))){
var inst_12762 = cljs.core.async.close_BANG_.call(null,to);
var state_12793__$1 = state_12793;
var statearr_12818_12880 = state_12793__$1;
(statearr_12818_12880[(2)] = inst_12762);

(statearr_12818_12880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12822 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12822[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12822[(1)] = (1));

return statearr_12822;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12793){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12823){if((e12823 instanceof Object)){
var ex__7651__auto__ = e12823;
var statearr_12824_12881 = state_12793;
(statearr_12824_12881[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12793);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12823;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12882 = state_12793;
state_12793 = G__12882;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12793){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12825 = f__7710__auto__.call(null);
(statearr_12825[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_12825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__12884 = arguments.length;
switch (G__12884) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__12887 = arguments.length;
switch (G__12887) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__12890 = arguments.length;
switch (G__12890) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7709__auto___12942 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12942,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12942,tc,fc){
return (function (state_12916){
var state_val_12917 = (state_12916[(1)]);
if((state_val_12917 === (7))){
var inst_12912 = (state_12916[(2)]);
var state_12916__$1 = state_12916;
var statearr_12918_12943 = state_12916__$1;
(statearr_12918_12943[(2)] = inst_12912);

(statearr_12918_12943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (1))){
var state_12916__$1 = state_12916;
var statearr_12919_12944 = state_12916__$1;
(statearr_12919_12944[(2)] = null);

(statearr_12919_12944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (4))){
var inst_12893 = (state_12916[(7)]);
var inst_12893__$1 = (state_12916[(2)]);
var inst_12894 = (inst_12893__$1 == null);
var state_12916__$1 = (function (){var statearr_12920 = state_12916;
(statearr_12920[(7)] = inst_12893__$1);

return statearr_12920;
})();
if(cljs.core.truth_(inst_12894)){
var statearr_12921_12945 = state_12916__$1;
(statearr_12921_12945[(1)] = (5));

} else {
var statearr_12922_12946 = state_12916__$1;
(statearr_12922_12946[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (13))){
var state_12916__$1 = state_12916;
var statearr_12923_12947 = state_12916__$1;
(statearr_12923_12947[(2)] = null);

(statearr_12923_12947[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (6))){
var inst_12893 = (state_12916[(7)]);
var inst_12899 = p.call(null,inst_12893);
var state_12916__$1 = state_12916;
if(cljs.core.truth_(inst_12899)){
var statearr_12924_12948 = state_12916__$1;
(statearr_12924_12948[(1)] = (9));

} else {
var statearr_12925_12949 = state_12916__$1;
(statearr_12925_12949[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (3))){
var inst_12914 = (state_12916[(2)]);
var state_12916__$1 = state_12916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12916__$1,inst_12914);
} else {
if((state_val_12917 === (12))){
var state_12916__$1 = state_12916;
var statearr_12926_12950 = state_12916__$1;
(statearr_12926_12950[(2)] = null);

(statearr_12926_12950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (2))){
var state_12916__$1 = state_12916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12916__$1,(4),ch);
} else {
if((state_val_12917 === (11))){
var inst_12893 = (state_12916[(7)]);
var inst_12903 = (state_12916[(2)]);
var state_12916__$1 = state_12916;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12916__$1,(8),inst_12903,inst_12893);
} else {
if((state_val_12917 === (9))){
var state_12916__$1 = state_12916;
var statearr_12927_12951 = state_12916__$1;
(statearr_12927_12951[(2)] = tc);

(statearr_12927_12951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (5))){
var inst_12896 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12897 = cljs.core.async.close_BANG_.call(null,fc);
var state_12916__$1 = (function (){var statearr_12928 = state_12916;
(statearr_12928[(8)] = inst_12896);

return statearr_12928;
})();
var statearr_12929_12952 = state_12916__$1;
(statearr_12929_12952[(2)] = inst_12897);

(statearr_12929_12952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (14))){
var inst_12910 = (state_12916[(2)]);
var state_12916__$1 = state_12916;
var statearr_12930_12953 = state_12916__$1;
(statearr_12930_12953[(2)] = inst_12910);

(statearr_12930_12953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (10))){
var state_12916__$1 = state_12916;
var statearr_12931_12954 = state_12916__$1;
(statearr_12931_12954[(2)] = fc);

(statearr_12931_12954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12917 === (8))){
var inst_12905 = (state_12916[(2)]);
var state_12916__$1 = state_12916;
if(cljs.core.truth_(inst_12905)){
var statearr_12932_12955 = state_12916__$1;
(statearr_12932_12955[(1)] = (12));

} else {
var statearr_12933_12956 = state_12916__$1;
(statearr_12933_12956[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12942,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___12942,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12937 = [null,null,null,null,null,null,null,null,null];
(statearr_12937[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12937[(1)] = (1));

return statearr_12937;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12916){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12938){if((e12938 instanceof Object)){
var ex__7651__auto__ = e12938;
var statearr_12939_12957 = state_12916;
(statearr_12939_12957[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12958 = state_12916;
state_12916 = G__12958;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12916){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12942,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_12940 = f__7710__auto__.call(null);
(statearr_12940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12942);

return statearr_12940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12942,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13005){
var state_val_13006 = (state_13005[(1)]);
if((state_val_13006 === (7))){
var inst_13001 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
var statearr_13007_13023 = state_13005__$1;
(statearr_13007_13023[(2)] = inst_13001);

(statearr_13007_13023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (6))){
var inst_12991 = (state_13005[(7)]);
var inst_12994 = (state_13005[(8)]);
var inst_12998 = f.call(null,inst_12991,inst_12994);
var inst_12991__$1 = inst_12998;
var state_13005__$1 = (function (){var statearr_13008 = state_13005;
(statearr_13008[(7)] = inst_12991__$1);

return statearr_13008;
})();
var statearr_13009_13024 = state_13005__$1;
(statearr_13009_13024[(2)] = null);

(statearr_13009_13024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (5))){
var inst_12991 = (state_13005[(7)]);
var state_13005__$1 = state_13005;
var statearr_13010_13025 = state_13005__$1;
(statearr_13010_13025[(2)] = inst_12991);

(statearr_13010_13025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (4))){
var inst_12994 = (state_13005[(8)]);
var inst_12994__$1 = (state_13005[(2)]);
var inst_12995 = (inst_12994__$1 == null);
var state_13005__$1 = (function (){var statearr_13011 = state_13005;
(statearr_13011[(8)] = inst_12994__$1);

return statearr_13011;
})();
if(cljs.core.truth_(inst_12995)){
var statearr_13012_13026 = state_13005__$1;
(statearr_13012_13026[(1)] = (5));

} else {
var statearr_13013_13027 = state_13005__$1;
(statearr_13013_13027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (3))){
var inst_13003 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13005__$1,inst_13003);
} else {
if((state_val_13006 === (2))){
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13005__$1,(4),ch);
} else {
if((state_val_13006 === (1))){
var inst_12991 = init;
var state_13005__$1 = (function (){var statearr_13014 = state_13005;
(statearr_13014[(7)] = inst_12991);

return statearr_13014;
})();
var statearr_13015_13028 = state_13005__$1;
(statearr_13015_13028[(2)] = null);

(statearr_13015_13028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_13019 = [null,null,null,null,null,null,null,null,null];
(statearr_13019[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_13019[(1)] = (1));

return statearr_13019;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_13005){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13020){if((e13020 instanceof Object)){
var ex__7651__auto__ = e13020;
var statearr_13021_13029 = state_13005;
(statearr_13021_13029[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13030 = state_13005;
state_13005 = G__13030;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_13005){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_13005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13022 = f__7710__auto__.call(null);
(statearr_13022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__13032 = arguments.length;
switch (G__13032) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13057){
var state_val_13058 = (state_13057[(1)]);
if((state_val_13058 === (7))){
var inst_13039 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
var statearr_13059_13083 = state_13057__$1;
(statearr_13059_13083[(2)] = inst_13039);

(statearr_13059_13083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (1))){
var inst_13033 = cljs.core.seq.call(null,coll);
var inst_13034 = inst_13033;
var state_13057__$1 = (function (){var statearr_13060 = state_13057;
(statearr_13060[(7)] = inst_13034);

return statearr_13060;
})();
var statearr_13061_13084 = state_13057__$1;
(statearr_13061_13084[(2)] = null);

(statearr_13061_13084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (4))){
var inst_13034 = (state_13057[(7)]);
var inst_13037 = cljs.core.first.call(null,inst_13034);
var state_13057__$1 = state_13057;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13057__$1,(7),ch,inst_13037);
} else {
if((state_val_13058 === (13))){
var inst_13051 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
var statearr_13062_13085 = state_13057__$1;
(statearr_13062_13085[(2)] = inst_13051);

(statearr_13062_13085[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (6))){
var inst_13042 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
if(cljs.core.truth_(inst_13042)){
var statearr_13063_13086 = state_13057__$1;
(statearr_13063_13086[(1)] = (8));

} else {
var statearr_13064_13087 = state_13057__$1;
(statearr_13064_13087[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (3))){
var inst_13055 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13057__$1,inst_13055);
} else {
if((state_val_13058 === (12))){
var state_13057__$1 = state_13057;
var statearr_13065_13088 = state_13057__$1;
(statearr_13065_13088[(2)] = null);

(statearr_13065_13088[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (2))){
var inst_13034 = (state_13057[(7)]);
var state_13057__$1 = state_13057;
if(cljs.core.truth_(inst_13034)){
var statearr_13066_13089 = state_13057__$1;
(statearr_13066_13089[(1)] = (4));

} else {
var statearr_13067_13090 = state_13057__$1;
(statearr_13067_13090[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (11))){
var inst_13048 = cljs.core.async.close_BANG_.call(null,ch);
var state_13057__$1 = state_13057;
var statearr_13068_13091 = state_13057__$1;
(statearr_13068_13091[(2)] = inst_13048);

(statearr_13068_13091[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (9))){
var state_13057__$1 = state_13057;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13069_13092 = state_13057__$1;
(statearr_13069_13092[(1)] = (11));

} else {
var statearr_13070_13093 = state_13057__$1;
(statearr_13070_13093[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (5))){
var inst_13034 = (state_13057[(7)]);
var state_13057__$1 = state_13057;
var statearr_13071_13094 = state_13057__$1;
(statearr_13071_13094[(2)] = inst_13034);

(statearr_13071_13094[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (10))){
var inst_13053 = (state_13057[(2)]);
var state_13057__$1 = state_13057;
var statearr_13072_13095 = state_13057__$1;
(statearr_13072_13095[(2)] = inst_13053);

(statearr_13072_13095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13058 === (8))){
var inst_13034 = (state_13057[(7)]);
var inst_13044 = cljs.core.next.call(null,inst_13034);
var inst_13034__$1 = inst_13044;
var state_13057__$1 = (function (){var statearr_13073 = state_13057;
(statearr_13073[(7)] = inst_13034__$1);

return statearr_13073;
})();
var statearr_13074_13096 = state_13057__$1;
(statearr_13074_13096[(2)] = null);

(statearr_13074_13096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_13078 = [null,null,null,null,null,null,null,null];
(statearr_13078[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_13078[(1)] = (1));

return statearr_13078;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13057){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13079){if((e13079 instanceof Object)){
var ex__7651__auto__ = e13079;
var statearr_13080_13097 = state_13057;
(statearr_13080_13097[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13079;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13098 = state_13057;
state_13057 = G__13098;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13081 = f__7710__auto__.call(null);
(statearr_13081[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj13100 = {};
return obj13100;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj13102 = {};
return obj13102;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t13324 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13324 = (function (cs,ch,mult,meta13325){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta13325 = meta13325;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13324.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t13324.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t13324.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t13324.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t13324.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13324.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t13324.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13326){
var self__ = this;
var _13326__$1 = this;
return self__.meta13325;
});})(cs))
;

cljs.core.async.t13324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13326,meta13325__$1){
var self__ = this;
var _13326__$1 = this;
return (new cljs.core.async.t13324(self__.cs,self__.ch,self__.mult,meta13325__$1));
});})(cs))
;

cljs.core.async.t13324.cljs$lang$type = true;

cljs.core.async.t13324.cljs$lang$ctorStr = "cljs.core.async/t13324";

cljs.core.async.t13324.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13324");
});})(cs))
;

cljs.core.async.__GT_t13324 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t13324(cs__$1,ch__$1,mult__$1,meta13325){
return (new cljs.core.async.t13324(cs__$1,ch__$1,mult__$1,meta13325));
});})(cs))
;

}

return (new cljs.core.async.t13324(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___13545 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13545,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13545,cs,m,dchan,dctr,done){
return (function (state_13457){
var state_val_13458 = (state_13457[(1)]);
if((state_val_13458 === (7))){
var inst_13453 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13459_13546 = state_13457__$1;
(statearr_13459_13546[(2)] = inst_13453);

(statearr_13459_13546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (20))){
var inst_13358 = (state_13457[(7)]);
var inst_13368 = cljs.core.first.call(null,inst_13358);
var inst_13369 = cljs.core.nth.call(null,inst_13368,(0),null);
var inst_13370 = cljs.core.nth.call(null,inst_13368,(1),null);
var state_13457__$1 = (function (){var statearr_13460 = state_13457;
(statearr_13460[(8)] = inst_13369);

return statearr_13460;
})();
if(cljs.core.truth_(inst_13370)){
var statearr_13461_13547 = state_13457__$1;
(statearr_13461_13547[(1)] = (22));

} else {
var statearr_13462_13548 = state_13457__$1;
(statearr_13462_13548[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (27))){
var inst_13398 = (state_13457[(9)]);
var inst_13400 = (state_13457[(10)]);
var inst_13329 = (state_13457[(11)]);
var inst_13405 = (state_13457[(12)]);
var inst_13405__$1 = cljs.core._nth.call(null,inst_13398,inst_13400);
var inst_13406 = cljs.core.async.put_BANG_.call(null,inst_13405__$1,inst_13329,done);
var state_13457__$1 = (function (){var statearr_13463 = state_13457;
(statearr_13463[(12)] = inst_13405__$1);

return statearr_13463;
})();
if(cljs.core.truth_(inst_13406)){
var statearr_13464_13549 = state_13457__$1;
(statearr_13464_13549[(1)] = (30));

} else {
var statearr_13465_13550 = state_13457__$1;
(statearr_13465_13550[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (1))){
var state_13457__$1 = state_13457;
var statearr_13466_13551 = state_13457__$1;
(statearr_13466_13551[(2)] = null);

(statearr_13466_13551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (24))){
var inst_13358 = (state_13457[(7)]);
var inst_13375 = (state_13457[(2)]);
var inst_13376 = cljs.core.next.call(null,inst_13358);
var inst_13338 = inst_13376;
var inst_13339 = null;
var inst_13340 = (0);
var inst_13341 = (0);
var state_13457__$1 = (function (){var statearr_13467 = state_13457;
(statearr_13467[(13)] = inst_13340);

(statearr_13467[(14)] = inst_13338);

(statearr_13467[(15)] = inst_13341);

(statearr_13467[(16)] = inst_13375);

(statearr_13467[(17)] = inst_13339);

return statearr_13467;
})();
var statearr_13468_13552 = state_13457__$1;
(statearr_13468_13552[(2)] = null);

(statearr_13468_13552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (39))){
var state_13457__$1 = state_13457;
var statearr_13472_13553 = state_13457__$1;
(statearr_13472_13553[(2)] = null);

(statearr_13472_13553[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (4))){
var inst_13329 = (state_13457[(11)]);
var inst_13329__$1 = (state_13457[(2)]);
var inst_13330 = (inst_13329__$1 == null);
var state_13457__$1 = (function (){var statearr_13473 = state_13457;
(statearr_13473[(11)] = inst_13329__$1);

return statearr_13473;
})();
if(cljs.core.truth_(inst_13330)){
var statearr_13474_13554 = state_13457__$1;
(statearr_13474_13554[(1)] = (5));

} else {
var statearr_13475_13555 = state_13457__$1;
(statearr_13475_13555[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (15))){
var inst_13340 = (state_13457[(13)]);
var inst_13338 = (state_13457[(14)]);
var inst_13341 = (state_13457[(15)]);
var inst_13339 = (state_13457[(17)]);
var inst_13354 = (state_13457[(2)]);
var inst_13355 = (inst_13341 + (1));
var tmp13469 = inst_13340;
var tmp13470 = inst_13338;
var tmp13471 = inst_13339;
var inst_13338__$1 = tmp13470;
var inst_13339__$1 = tmp13471;
var inst_13340__$1 = tmp13469;
var inst_13341__$1 = inst_13355;
var state_13457__$1 = (function (){var statearr_13476 = state_13457;
(statearr_13476[(13)] = inst_13340__$1);

(statearr_13476[(14)] = inst_13338__$1);

(statearr_13476[(15)] = inst_13341__$1);

(statearr_13476[(18)] = inst_13354);

(statearr_13476[(17)] = inst_13339__$1);

return statearr_13476;
})();
var statearr_13477_13556 = state_13457__$1;
(statearr_13477_13556[(2)] = null);

(statearr_13477_13556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (21))){
var inst_13379 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13481_13557 = state_13457__$1;
(statearr_13481_13557[(2)] = inst_13379);

(statearr_13481_13557[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (31))){
var inst_13405 = (state_13457[(12)]);
var inst_13409 = done.call(null,null);
var inst_13410 = cljs.core.async.untap_STAR_.call(null,m,inst_13405);
var state_13457__$1 = (function (){var statearr_13482 = state_13457;
(statearr_13482[(19)] = inst_13409);

return statearr_13482;
})();
var statearr_13483_13558 = state_13457__$1;
(statearr_13483_13558[(2)] = inst_13410);

(statearr_13483_13558[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (32))){
var inst_13399 = (state_13457[(20)]);
var inst_13398 = (state_13457[(9)]);
var inst_13400 = (state_13457[(10)]);
var inst_13397 = (state_13457[(21)]);
var inst_13412 = (state_13457[(2)]);
var inst_13413 = (inst_13400 + (1));
var tmp13478 = inst_13399;
var tmp13479 = inst_13398;
var tmp13480 = inst_13397;
var inst_13397__$1 = tmp13480;
var inst_13398__$1 = tmp13479;
var inst_13399__$1 = tmp13478;
var inst_13400__$1 = inst_13413;
var state_13457__$1 = (function (){var statearr_13484 = state_13457;
(statearr_13484[(20)] = inst_13399__$1);

(statearr_13484[(9)] = inst_13398__$1);

(statearr_13484[(10)] = inst_13400__$1);

(statearr_13484[(21)] = inst_13397__$1);

(statearr_13484[(22)] = inst_13412);

return statearr_13484;
})();
var statearr_13485_13559 = state_13457__$1;
(statearr_13485_13559[(2)] = null);

(statearr_13485_13559[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (40))){
var inst_13425 = (state_13457[(23)]);
var inst_13429 = done.call(null,null);
var inst_13430 = cljs.core.async.untap_STAR_.call(null,m,inst_13425);
var state_13457__$1 = (function (){var statearr_13486 = state_13457;
(statearr_13486[(24)] = inst_13429);

return statearr_13486;
})();
var statearr_13487_13560 = state_13457__$1;
(statearr_13487_13560[(2)] = inst_13430);

(statearr_13487_13560[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (33))){
var inst_13416 = (state_13457[(25)]);
var inst_13418 = cljs.core.chunked_seq_QMARK_.call(null,inst_13416);
var state_13457__$1 = state_13457;
if(inst_13418){
var statearr_13488_13561 = state_13457__$1;
(statearr_13488_13561[(1)] = (36));

} else {
var statearr_13489_13562 = state_13457__$1;
(statearr_13489_13562[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (13))){
var inst_13348 = (state_13457[(26)]);
var inst_13351 = cljs.core.async.close_BANG_.call(null,inst_13348);
var state_13457__$1 = state_13457;
var statearr_13490_13563 = state_13457__$1;
(statearr_13490_13563[(2)] = inst_13351);

(statearr_13490_13563[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (22))){
var inst_13369 = (state_13457[(8)]);
var inst_13372 = cljs.core.async.close_BANG_.call(null,inst_13369);
var state_13457__$1 = state_13457;
var statearr_13491_13564 = state_13457__$1;
(statearr_13491_13564[(2)] = inst_13372);

(statearr_13491_13564[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (36))){
var inst_13416 = (state_13457[(25)]);
var inst_13420 = cljs.core.chunk_first.call(null,inst_13416);
var inst_13421 = cljs.core.chunk_rest.call(null,inst_13416);
var inst_13422 = cljs.core.count.call(null,inst_13420);
var inst_13397 = inst_13421;
var inst_13398 = inst_13420;
var inst_13399 = inst_13422;
var inst_13400 = (0);
var state_13457__$1 = (function (){var statearr_13492 = state_13457;
(statearr_13492[(20)] = inst_13399);

(statearr_13492[(9)] = inst_13398);

(statearr_13492[(10)] = inst_13400);

(statearr_13492[(21)] = inst_13397);

return statearr_13492;
})();
var statearr_13493_13565 = state_13457__$1;
(statearr_13493_13565[(2)] = null);

(statearr_13493_13565[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (41))){
var inst_13416 = (state_13457[(25)]);
var inst_13432 = (state_13457[(2)]);
var inst_13433 = cljs.core.next.call(null,inst_13416);
var inst_13397 = inst_13433;
var inst_13398 = null;
var inst_13399 = (0);
var inst_13400 = (0);
var state_13457__$1 = (function (){var statearr_13494 = state_13457;
(statearr_13494[(27)] = inst_13432);

(statearr_13494[(20)] = inst_13399);

(statearr_13494[(9)] = inst_13398);

(statearr_13494[(10)] = inst_13400);

(statearr_13494[(21)] = inst_13397);

return statearr_13494;
})();
var statearr_13495_13566 = state_13457__$1;
(statearr_13495_13566[(2)] = null);

(statearr_13495_13566[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (43))){
var state_13457__$1 = state_13457;
var statearr_13496_13567 = state_13457__$1;
(statearr_13496_13567[(2)] = null);

(statearr_13496_13567[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (29))){
var inst_13441 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13497_13568 = state_13457__$1;
(statearr_13497_13568[(2)] = inst_13441);

(statearr_13497_13568[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (44))){
var inst_13450 = (state_13457[(2)]);
var state_13457__$1 = (function (){var statearr_13498 = state_13457;
(statearr_13498[(28)] = inst_13450);

return statearr_13498;
})();
var statearr_13499_13569 = state_13457__$1;
(statearr_13499_13569[(2)] = null);

(statearr_13499_13569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (6))){
var inst_13389 = (state_13457[(29)]);
var inst_13388 = cljs.core.deref.call(null,cs);
var inst_13389__$1 = cljs.core.keys.call(null,inst_13388);
var inst_13390 = cljs.core.count.call(null,inst_13389__$1);
var inst_13391 = cljs.core.reset_BANG_.call(null,dctr,inst_13390);
var inst_13396 = cljs.core.seq.call(null,inst_13389__$1);
var inst_13397 = inst_13396;
var inst_13398 = null;
var inst_13399 = (0);
var inst_13400 = (0);
var state_13457__$1 = (function (){var statearr_13500 = state_13457;
(statearr_13500[(20)] = inst_13399);

(statearr_13500[(9)] = inst_13398);

(statearr_13500[(30)] = inst_13391);

(statearr_13500[(10)] = inst_13400);

(statearr_13500[(21)] = inst_13397);

(statearr_13500[(29)] = inst_13389__$1);

return statearr_13500;
})();
var statearr_13501_13570 = state_13457__$1;
(statearr_13501_13570[(2)] = null);

(statearr_13501_13570[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (28))){
var inst_13397 = (state_13457[(21)]);
var inst_13416 = (state_13457[(25)]);
var inst_13416__$1 = cljs.core.seq.call(null,inst_13397);
var state_13457__$1 = (function (){var statearr_13502 = state_13457;
(statearr_13502[(25)] = inst_13416__$1);

return statearr_13502;
})();
if(inst_13416__$1){
var statearr_13503_13571 = state_13457__$1;
(statearr_13503_13571[(1)] = (33));

} else {
var statearr_13504_13572 = state_13457__$1;
(statearr_13504_13572[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (25))){
var inst_13399 = (state_13457[(20)]);
var inst_13400 = (state_13457[(10)]);
var inst_13402 = (inst_13400 < inst_13399);
var inst_13403 = inst_13402;
var state_13457__$1 = state_13457;
if(cljs.core.truth_(inst_13403)){
var statearr_13505_13573 = state_13457__$1;
(statearr_13505_13573[(1)] = (27));

} else {
var statearr_13506_13574 = state_13457__$1;
(statearr_13506_13574[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (34))){
var state_13457__$1 = state_13457;
var statearr_13507_13575 = state_13457__$1;
(statearr_13507_13575[(2)] = null);

(statearr_13507_13575[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (17))){
var state_13457__$1 = state_13457;
var statearr_13508_13576 = state_13457__$1;
(statearr_13508_13576[(2)] = null);

(statearr_13508_13576[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (3))){
var inst_13455 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13457__$1,inst_13455);
} else {
if((state_val_13458 === (12))){
var inst_13384 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13509_13577 = state_13457__$1;
(statearr_13509_13577[(2)] = inst_13384);

(statearr_13509_13577[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (2))){
var state_13457__$1 = state_13457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13457__$1,(4),ch);
} else {
if((state_val_13458 === (23))){
var state_13457__$1 = state_13457;
var statearr_13510_13578 = state_13457__$1;
(statearr_13510_13578[(2)] = null);

(statearr_13510_13578[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (35))){
var inst_13439 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13511_13579 = state_13457__$1;
(statearr_13511_13579[(2)] = inst_13439);

(statearr_13511_13579[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (19))){
var inst_13358 = (state_13457[(7)]);
var inst_13362 = cljs.core.chunk_first.call(null,inst_13358);
var inst_13363 = cljs.core.chunk_rest.call(null,inst_13358);
var inst_13364 = cljs.core.count.call(null,inst_13362);
var inst_13338 = inst_13363;
var inst_13339 = inst_13362;
var inst_13340 = inst_13364;
var inst_13341 = (0);
var state_13457__$1 = (function (){var statearr_13512 = state_13457;
(statearr_13512[(13)] = inst_13340);

(statearr_13512[(14)] = inst_13338);

(statearr_13512[(15)] = inst_13341);

(statearr_13512[(17)] = inst_13339);

return statearr_13512;
})();
var statearr_13513_13580 = state_13457__$1;
(statearr_13513_13580[(2)] = null);

(statearr_13513_13580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (11))){
var inst_13338 = (state_13457[(14)]);
var inst_13358 = (state_13457[(7)]);
var inst_13358__$1 = cljs.core.seq.call(null,inst_13338);
var state_13457__$1 = (function (){var statearr_13514 = state_13457;
(statearr_13514[(7)] = inst_13358__$1);

return statearr_13514;
})();
if(inst_13358__$1){
var statearr_13515_13581 = state_13457__$1;
(statearr_13515_13581[(1)] = (16));

} else {
var statearr_13516_13582 = state_13457__$1;
(statearr_13516_13582[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (9))){
var inst_13386 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13517_13583 = state_13457__$1;
(statearr_13517_13583[(2)] = inst_13386);

(statearr_13517_13583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (5))){
var inst_13336 = cljs.core.deref.call(null,cs);
var inst_13337 = cljs.core.seq.call(null,inst_13336);
var inst_13338 = inst_13337;
var inst_13339 = null;
var inst_13340 = (0);
var inst_13341 = (0);
var state_13457__$1 = (function (){var statearr_13518 = state_13457;
(statearr_13518[(13)] = inst_13340);

(statearr_13518[(14)] = inst_13338);

(statearr_13518[(15)] = inst_13341);

(statearr_13518[(17)] = inst_13339);

return statearr_13518;
})();
var statearr_13519_13584 = state_13457__$1;
(statearr_13519_13584[(2)] = null);

(statearr_13519_13584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (14))){
var state_13457__$1 = state_13457;
var statearr_13520_13585 = state_13457__$1;
(statearr_13520_13585[(2)] = null);

(statearr_13520_13585[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (45))){
var inst_13447 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13521_13586 = state_13457__$1;
(statearr_13521_13586[(2)] = inst_13447);

(statearr_13521_13586[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (26))){
var inst_13389 = (state_13457[(29)]);
var inst_13443 = (state_13457[(2)]);
var inst_13444 = cljs.core.seq.call(null,inst_13389);
var state_13457__$1 = (function (){var statearr_13522 = state_13457;
(statearr_13522[(31)] = inst_13443);

return statearr_13522;
})();
if(inst_13444){
var statearr_13523_13587 = state_13457__$1;
(statearr_13523_13587[(1)] = (42));

} else {
var statearr_13524_13588 = state_13457__$1;
(statearr_13524_13588[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (16))){
var inst_13358 = (state_13457[(7)]);
var inst_13360 = cljs.core.chunked_seq_QMARK_.call(null,inst_13358);
var state_13457__$1 = state_13457;
if(inst_13360){
var statearr_13525_13589 = state_13457__$1;
(statearr_13525_13589[(1)] = (19));

} else {
var statearr_13526_13590 = state_13457__$1;
(statearr_13526_13590[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (38))){
var inst_13436 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13527_13591 = state_13457__$1;
(statearr_13527_13591[(2)] = inst_13436);

(statearr_13527_13591[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (30))){
var state_13457__$1 = state_13457;
var statearr_13528_13592 = state_13457__$1;
(statearr_13528_13592[(2)] = null);

(statearr_13528_13592[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (10))){
var inst_13341 = (state_13457[(15)]);
var inst_13339 = (state_13457[(17)]);
var inst_13347 = cljs.core._nth.call(null,inst_13339,inst_13341);
var inst_13348 = cljs.core.nth.call(null,inst_13347,(0),null);
var inst_13349 = cljs.core.nth.call(null,inst_13347,(1),null);
var state_13457__$1 = (function (){var statearr_13529 = state_13457;
(statearr_13529[(26)] = inst_13348);

return statearr_13529;
})();
if(cljs.core.truth_(inst_13349)){
var statearr_13530_13593 = state_13457__$1;
(statearr_13530_13593[(1)] = (13));

} else {
var statearr_13531_13594 = state_13457__$1;
(statearr_13531_13594[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (18))){
var inst_13382 = (state_13457[(2)]);
var state_13457__$1 = state_13457;
var statearr_13532_13595 = state_13457__$1;
(statearr_13532_13595[(2)] = inst_13382);

(statearr_13532_13595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (42))){
var state_13457__$1 = state_13457;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13457__$1,(45),dchan);
} else {
if((state_val_13458 === (37))){
var inst_13416 = (state_13457[(25)]);
var inst_13329 = (state_13457[(11)]);
var inst_13425 = (state_13457[(23)]);
var inst_13425__$1 = cljs.core.first.call(null,inst_13416);
var inst_13426 = cljs.core.async.put_BANG_.call(null,inst_13425__$1,inst_13329,done);
var state_13457__$1 = (function (){var statearr_13533 = state_13457;
(statearr_13533[(23)] = inst_13425__$1);

return statearr_13533;
})();
if(cljs.core.truth_(inst_13426)){
var statearr_13534_13596 = state_13457__$1;
(statearr_13534_13596[(1)] = (39));

} else {
var statearr_13535_13597 = state_13457__$1;
(statearr_13535_13597[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13458 === (8))){
var inst_13340 = (state_13457[(13)]);
var inst_13341 = (state_13457[(15)]);
var inst_13343 = (inst_13341 < inst_13340);
var inst_13344 = inst_13343;
var state_13457__$1 = state_13457;
if(cljs.core.truth_(inst_13344)){
var statearr_13536_13598 = state_13457__$1;
(statearr_13536_13598[(1)] = (10));

} else {
var statearr_13537_13599 = state_13457__$1;
(statearr_13537_13599[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13545,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___13545,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_13541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13541[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_13541[(1)] = (1));

return statearr_13541;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_13457){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13542){if((e13542 instanceof Object)){
var ex__7651__auto__ = e13542;
var statearr_13543_13600 = state_13457;
(statearr_13543_13600[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13457);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13601 = state_13457;
state_13457 = G__13601;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_13457){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_13457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13545,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_13544 = f__7710__auto__.call(null);
(statearr_13544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13545);

return statearr_13544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13545,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__13603 = arguments.length;
switch (G__13603) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj13606 = {};
return obj13606;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13611){
var map__13612 = p__13611;
var map__13612__$1 = ((cljs.core.seq_QMARK_.call(null,map__13612))?cljs.core.apply.call(null,cljs.core.hash_map,map__13612):map__13612);
var opts = map__13612__$1;
var statearr_13613_13616 = state;
(statearr_13613_13616[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__13612,map__13612__$1,opts){
return (function (val){
var statearr_13614_13617 = state;
(statearr_13614_13617[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13612,map__13612__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_13615_13618 = state;
(statearr_13615_13618[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13607){
var G__13608 = cljs.core.first.call(null,seq13607);
var seq13607__$1 = cljs.core.next.call(null,seq13607);
var G__13609 = cljs.core.first.call(null,seq13607__$1);
var seq13607__$2 = cljs.core.next.call(null,seq13607__$1);
var G__13610 = cljs.core.first.call(null,seq13607__$2);
var seq13607__$3 = cljs.core.next.call(null,seq13607__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13608,G__13609,G__13610,seq13607__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t13738 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13738 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13739){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13739 = meta13739;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13738.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t13738.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13738.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13740){
var self__ = this;
var _13740__$1 = this;
return self__.meta13739;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13740,meta13739__$1){
var self__ = this;
var _13740__$1 = this;
return (new cljs.core.async.t13738(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13739__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13738.cljs$lang$type = true;

cljs.core.async.t13738.cljs$lang$ctorStr = "cljs.core.async/t13738";

cljs.core.async.t13738.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13738");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t13738 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t13738(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13739){
return (new cljs.core.async.t13738(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13739));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t13738(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___13857 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13810){
var state_val_13811 = (state_13810[(1)]);
if((state_val_13811 === (7))){
var inst_13754 = (state_13810[(7)]);
var inst_13759 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13754);
var state_13810__$1 = state_13810;
var statearr_13812_13858 = state_13810__$1;
(statearr_13812_13858[(2)] = inst_13759);

(statearr_13812_13858[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (20))){
var inst_13769 = (state_13810[(8)]);
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13810__$1,(23),out,inst_13769);
} else {
if((state_val_13811 === (1))){
var inst_13744 = (state_13810[(9)]);
var inst_13744__$1 = calc_state.call(null);
var inst_13745 = cljs.core.seq_QMARK_.call(null,inst_13744__$1);
var state_13810__$1 = (function (){var statearr_13813 = state_13810;
(statearr_13813[(9)] = inst_13744__$1);

return statearr_13813;
})();
if(inst_13745){
var statearr_13814_13859 = state_13810__$1;
(statearr_13814_13859[(1)] = (2));

} else {
var statearr_13815_13860 = state_13810__$1;
(statearr_13815_13860[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (24))){
var inst_13762 = (state_13810[(10)]);
var inst_13754 = inst_13762;
var state_13810__$1 = (function (){var statearr_13816 = state_13810;
(statearr_13816[(7)] = inst_13754);

return statearr_13816;
})();
var statearr_13817_13861 = state_13810__$1;
(statearr_13817_13861[(2)] = null);

(statearr_13817_13861[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (4))){
var inst_13744 = (state_13810[(9)]);
var inst_13750 = (state_13810[(2)]);
var inst_13751 = cljs.core.get.call(null,inst_13750,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13752 = cljs.core.get.call(null,inst_13750,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13753 = cljs.core.get.call(null,inst_13750,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13754 = inst_13744;
var state_13810__$1 = (function (){var statearr_13818 = state_13810;
(statearr_13818[(11)] = inst_13753);

(statearr_13818[(12)] = inst_13751);

(statearr_13818[(13)] = inst_13752);

(statearr_13818[(7)] = inst_13754);

return statearr_13818;
})();
var statearr_13819_13862 = state_13810__$1;
(statearr_13819_13862[(2)] = null);

(statearr_13819_13862[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (15))){
var state_13810__$1 = state_13810;
var statearr_13820_13863 = state_13810__$1;
(statearr_13820_13863[(2)] = null);

(statearr_13820_13863[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (21))){
var inst_13762 = (state_13810[(10)]);
var inst_13754 = inst_13762;
var state_13810__$1 = (function (){var statearr_13821 = state_13810;
(statearr_13821[(7)] = inst_13754);

return statearr_13821;
})();
var statearr_13822_13864 = state_13810__$1;
(statearr_13822_13864[(2)] = null);

(statearr_13822_13864[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (13))){
var inst_13806 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13823_13865 = state_13810__$1;
(statearr_13823_13865[(2)] = inst_13806);

(statearr_13823_13865[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (22))){
var inst_13804 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13824_13866 = state_13810__$1;
(statearr_13824_13866[(2)] = inst_13804);

(statearr_13824_13866[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (6))){
var inst_13808 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13810__$1,inst_13808);
} else {
if((state_val_13811 === (25))){
var state_13810__$1 = state_13810;
var statearr_13825_13867 = state_13810__$1;
(statearr_13825_13867[(2)] = null);

(statearr_13825_13867[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (17))){
var inst_13784 = (state_13810[(14)]);
var state_13810__$1 = state_13810;
var statearr_13826_13868 = state_13810__$1;
(statearr_13826_13868[(2)] = inst_13784);

(statearr_13826_13868[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (3))){
var inst_13744 = (state_13810[(9)]);
var state_13810__$1 = state_13810;
var statearr_13827_13869 = state_13810__$1;
(statearr_13827_13869[(2)] = inst_13744);

(statearr_13827_13869[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (12))){
var inst_13765 = (state_13810[(15)]);
var inst_13770 = (state_13810[(16)]);
var inst_13784 = (state_13810[(14)]);
var inst_13784__$1 = inst_13765.call(null,inst_13770);
var state_13810__$1 = (function (){var statearr_13828 = state_13810;
(statearr_13828[(14)] = inst_13784__$1);

return statearr_13828;
})();
if(cljs.core.truth_(inst_13784__$1)){
var statearr_13829_13870 = state_13810__$1;
(statearr_13829_13870[(1)] = (17));

} else {
var statearr_13830_13871 = state_13810__$1;
(statearr_13830_13871[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (2))){
var inst_13744 = (state_13810[(9)]);
var inst_13747 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13744);
var state_13810__$1 = state_13810;
var statearr_13831_13872 = state_13810__$1;
(statearr_13831_13872[(2)] = inst_13747);

(statearr_13831_13872[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (23))){
var inst_13795 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
if(cljs.core.truth_(inst_13795)){
var statearr_13832_13873 = state_13810__$1;
(statearr_13832_13873[(1)] = (24));

} else {
var statearr_13833_13874 = state_13810__$1;
(statearr_13833_13874[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (19))){
var inst_13792 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
if(cljs.core.truth_(inst_13792)){
var statearr_13834_13875 = state_13810__$1;
(statearr_13834_13875[(1)] = (20));

} else {
var statearr_13835_13876 = state_13810__$1;
(statearr_13835_13876[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (11))){
var inst_13769 = (state_13810[(8)]);
var inst_13775 = (inst_13769 == null);
var state_13810__$1 = state_13810;
if(cljs.core.truth_(inst_13775)){
var statearr_13836_13877 = state_13810__$1;
(statearr_13836_13877[(1)] = (14));

} else {
var statearr_13837_13878 = state_13810__$1;
(statearr_13837_13878[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (9))){
var inst_13762 = (state_13810[(10)]);
var inst_13762__$1 = (state_13810[(2)]);
var inst_13763 = cljs.core.get.call(null,inst_13762__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13764 = cljs.core.get.call(null,inst_13762__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13765 = cljs.core.get.call(null,inst_13762__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_13810__$1 = (function (){var statearr_13838 = state_13810;
(statearr_13838[(15)] = inst_13765);

(statearr_13838[(17)] = inst_13764);

(statearr_13838[(10)] = inst_13762__$1);

return statearr_13838;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13810__$1,(10),inst_13763);
} else {
if((state_val_13811 === (5))){
var inst_13754 = (state_13810[(7)]);
var inst_13757 = cljs.core.seq_QMARK_.call(null,inst_13754);
var state_13810__$1 = state_13810;
if(inst_13757){
var statearr_13839_13879 = state_13810__$1;
(statearr_13839_13879[(1)] = (7));

} else {
var statearr_13840_13880 = state_13810__$1;
(statearr_13840_13880[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (14))){
var inst_13770 = (state_13810[(16)]);
var inst_13777 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13770);
var state_13810__$1 = state_13810;
var statearr_13841_13881 = state_13810__$1;
(statearr_13841_13881[(2)] = inst_13777);

(statearr_13841_13881[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (26))){
var inst_13800 = (state_13810[(2)]);
var state_13810__$1 = state_13810;
var statearr_13842_13882 = state_13810__$1;
(statearr_13842_13882[(2)] = inst_13800);

(statearr_13842_13882[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (16))){
var inst_13780 = (state_13810[(2)]);
var inst_13781 = calc_state.call(null);
var inst_13754 = inst_13781;
var state_13810__$1 = (function (){var statearr_13843 = state_13810;
(statearr_13843[(18)] = inst_13780);

(statearr_13843[(7)] = inst_13754);

return statearr_13843;
})();
var statearr_13844_13883 = state_13810__$1;
(statearr_13844_13883[(2)] = null);

(statearr_13844_13883[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (10))){
var inst_13769 = (state_13810[(8)]);
var inst_13770 = (state_13810[(16)]);
var inst_13768 = (state_13810[(2)]);
var inst_13769__$1 = cljs.core.nth.call(null,inst_13768,(0),null);
var inst_13770__$1 = cljs.core.nth.call(null,inst_13768,(1),null);
var inst_13771 = (inst_13769__$1 == null);
var inst_13772 = cljs.core._EQ_.call(null,inst_13770__$1,change);
var inst_13773 = (inst_13771) || (inst_13772);
var state_13810__$1 = (function (){var statearr_13845 = state_13810;
(statearr_13845[(8)] = inst_13769__$1);

(statearr_13845[(16)] = inst_13770__$1);

return statearr_13845;
})();
if(cljs.core.truth_(inst_13773)){
var statearr_13846_13884 = state_13810__$1;
(statearr_13846_13884[(1)] = (11));

} else {
var statearr_13847_13885 = state_13810__$1;
(statearr_13847_13885[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (18))){
var inst_13765 = (state_13810[(15)]);
var inst_13764 = (state_13810[(17)]);
var inst_13770 = (state_13810[(16)]);
var inst_13787 = cljs.core.empty_QMARK_.call(null,inst_13765);
var inst_13788 = inst_13764.call(null,inst_13770);
var inst_13789 = cljs.core.not.call(null,inst_13788);
var inst_13790 = (inst_13787) && (inst_13789);
var state_13810__$1 = state_13810;
var statearr_13848_13886 = state_13810__$1;
(statearr_13848_13886[(2)] = inst_13790);

(statearr_13848_13886[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13811 === (8))){
var inst_13754 = (state_13810[(7)]);
var state_13810__$1 = state_13810;
var statearr_13849_13887 = state_13810__$1;
(statearr_13849_13887[(2)] = inst_13754);

(statearr_13849_13887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_13853 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13853[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_13853[(1)] = (1));

return statearr_13853;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_13810){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13854){if((e13854 instanceof Object)){
var ex__7651__auto__ = e13854;
var statearr_13855_13888 = state_13810;
(statearr_13855_13888[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13854;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13889 = state_13810;
state_13810 = G__13889;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_13810){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_13810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_13856 = f__7710__auto__.call(null);
(statearr_13856[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13857);

return statearr_13856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13857,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj13891 = {};
return obj13891;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__13893 = arguments.length;
switch (G__13893) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__13897 = arguments.length;
switch (G__13897) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4276__auto__,mults){
return (function (p1__13895_SHARP_){
if(cljs.core.truth_(p1__13895_SHARP_.call(null,topic))){
return p1__13895_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13895_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t13898 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13898 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta13899){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta13899 = meta13899;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13898.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t13898.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13898.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13900){
var self__ = this;
var _13900__$1 = this;
return self__.meta13899;
});})(mults,ensure_mult))
;

cljs.core.async.t13898.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13900,meta13899__$1){
var self__ = this;
var _13900__$1 = this;
return (new cljs.core.async.t13898(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta13899__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t13898.cljs$lang$type = true;

cljs.core.async.t13898.cljs$lang$ctorStr = "cljs.core.async/t13898";

cljs.core.async.t13898.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13898");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t13898 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t13898(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13899){
return (new cljs.core.async.t13898(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13899));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t13898(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___14021 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14021,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14021,mults,ensure_mult,p){
return (function (state_13972){
var state_val_13973 = (state_13972[(1)]);
if((state_val_13973 === (7))){
var inst_13968 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_13974_14022 = state_13972__$1;
(statearr_13974_14022[(2)] = inst_13968);

(statearr_13974_14022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (20))){
var state_13972__$1 = state_13972;
var statearr_13975_14023 = state_13972__$1;
(statearr_13975_14023[(2)] = null);

(statearr_13975_14023[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (1))){
var state_13972__$1 = state_13972;
var statearr_13976_14024 = state_13972__$1;
(statearr_13976_14024[(2)] = null);

(statearr_13976_14024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (24))){
var inst_13951 = (state_13972[(7)]);
var inst_13960 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13951);
var state_13972__$1 = state_13972;
var statearr_13977_14025 = state_13972__$1;
(statearr_13977_14025[(2)] = inst_13960);

(statearr_13977_14025[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (4))){
var inst_13903 = (state_13972[(8)]);
var inst_13903__$1 = (state_13972[(2)]);
var inst_13904 = (inst_13903__$1 == null);
var state_13972__$1 = (function (){var statearr_13978 = state_13972;
(statearr_13978[(8)] = inst_13903__$1);

return statearr_13978;
})();
if(cljs.core.truth_(inst_13904)){
var statearr_13979_14026 = state_13972__$1;
(statearr_13979_14026[(1)] = (5));

} else {
var statearr_13980_14027 = state_13972__$1;
(statearr_13980_14027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (15))){
var inst_13945 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_13981_14028 = state_13972__$1;
(statearr_13981_14028[(2)] = inst_13945);

(statearr_13981_14028[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (21))){
var inst_13965 = (state_13972[(2)]);
var state_13972__$1 = (function (){var statearr_13982 = state_13972;
(statearr_13982[(9)] = inst_13965);

return statearr_13982;
})();
var statearr_13983_14029 = state_13972__$1;
(statearr_13983_14029[(2)] = null);

(statearr_13983_14029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (13))){
var inst_13927 = (state_13972[(10)]);
var inst_13929 = cljs.core.chunked_seq_QMARK_.call(null,inst_13927);
var state_13972__$1 = state_13972;
if(inst_13929){
var statearr_13984_14030 = state_13972__$1;
(statearr_13984_14030[(1)] = (16));

} else {
var statearr_13985_14031 = state_13972__$1;
(statearr_13985_14031[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (22))){
var inst_13957 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
if(cljs.core.truth_(inst_13957)){
var statearr_13986_14032 = state_13972__$1;
(statearr_13986_14032[(1)] = (23));

} else {
var statearr_13987_14033 = state_13972__$1;
(statearr_13987_14033[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (6))){
var inst_13953 = (state_13972[(11)]);
var inst_13903 = (state_13972[(8)]);
var inst_13951 = (state_13972[(7)]);
var inst_13951__$1 = topic_fn.call(null,inst_13903);
var inst_13952 = cljs.core.deref.call(null,mults);
var inst_13953__$1 = cljs.core.get.call(null,inst_13952,inst_13951__$1);
var state_13972__$1 = (function (){var statearr_13988 = state_13972;
(statearr_13988[(11)] = inst_13953__$1);

(statearr_13988[(7)] = inst_13951__$1);

return statearr_13988;
})();
if(cljs.core.truth_(inst_13953__$1)){
var statearr_13989_14034 = state_13972__$1;
(statearr_13989_14034[(1)] = (19));

} else {
var statearr_13990_14035 = state_13972__$1;
(statearr_13990_14035[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (25))){
var inst_13962 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_13991_14036 = state_13972__$1;
(statearr_13991_14036[(2)] = inst_13962);

(statearr_13991_14036[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (17))){
var inst_13927 = (state_13972[(10)]);
var inst_13936 = cljs.core.first.call(null,inst_13927);
var inst_13937 = cljs.core.async.muxch_STAR_.call(null,inst_13936);
var inst_13938 = cljs.core.async.close_BANG_.call(null,inst_13937);
var inst_13939 = cljs.core.next.call(null,inst_13927);
var inst_13913 = inst_13939;
var inst_13914 = null;
var inst_13915 = (0);
var inst_13916 = (0);
var state_13972__$1 = (function (){var statearr_13992 = state_13972;
(statearr_13992[(12)] = inst_13915);

(statearr_13992[(13)] = inst_13914);

(statearr_13992[(14)] = inst_13938);

(statearr_13992[(15)] = inst_13916);

(statearr_13992[(16)] = inst_13913);

return statearr_13992;
})();
var statearr_13993_14037 = state_13972__$1;
(statearr_13993_14037[(2)] = null);

(statearr_13993_14037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (3))){
var inst_13970 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13972__$1,inst_13970);
} else {
if((state_val_13973 === (12))){
var inst_13947 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_13994_14038 = state_13972__$1;
(statearr_13994_14038[(2)] = inst_13947);

(statearr_13994_14038[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (2))){
var state_13972__$1 = state_13972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13972__$1,(4),ch);
} else {
if((state_val_13973 === (23))){
var state_13972__$1 = state_13972;
var statearr_13995_14039 = state_13972__$1;
(statearr_13995_14039[(2)] = null);

(statearr_13995_14039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (19))){
var inst_13953 = (state_13972[(11)]);
var inst_13903 = (state_13972[(8)]);
var inst_13955 = cljs.core.async.muxch_STAR_.call(null,inst_13953);
var state_13972__$1 = state_13972;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13972__$1,(22),inst_13955,inst_13903);
} else {
if((state_val_13973 === (11))){
var inst_13913 = (state_13972[(16)]);
var inst_13927 = (state_13972[(10)]);
var inst_13927__$1 = cljs.core.seq.call(null,inst_13913);
var state_13972__$1 = (function (){var statearr_13996 = state_13972;
(statearr_13996[(10)] = inst_13927__$1);

return statearr_13996;
})();
if(inst_13927__$1){
var statearr_13997_14040 = state_13972__$1;
(statearr_13997_14040[(1)] = (13));

} else {
var statearr_13998_14041 = state_13972__$1;
(statearr_13998_14041[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (9))){
var inst_13949 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_13999_14042 = state_13972__$1;
(statearr_13999_14042[(2)] = inst_13949);

(statearr_13999_14042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (5))){
var inst_13910 = cljs.core.deref.call(null,mults);
var inst_13911 = cljs.core.vals.call(null,inst_13910);
var inst_13912 = cljs.core.seq.call(null,inst_13911);
var inst_13913 = inst_13912;
var inst_13914 = null;
var inst_13915 = (0);
var inst_13916 = (0);
var state_13972__$1 = (function (){var statearr_14000 = state_13972;
(statearr_14000[(12)] = inst_13915);

(statearr_14000[(13)] = inst_13914);

(statearr_14000[(15)] = inst_13916);

(statearr_14000[(16)] = inst_13913);

return statearr_14000;
})();
var statearr_14001_14043 = state_13972__$1;
(statearr_14001_14043[(2)] = null);

(statearr_14001_14043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (14))){
var state_13972__$1 = state_13972;
var statearr_14005_14044 = state_13972__$1;
(statearr_14005_14044[(2)] = null);

(statearr_14005_14044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (16))){
var inst_13927 = (state_13972[(10)]);
var inst_13931 = cljs.core.chunk_first.call(null,inst_13927);
var inst_13932 = cljs.core.chunk_rest.call(null,inst_13927);
var inst_13933 = cljs.core.count.call(null,inst_13931);
var inst_13913 = inst_13932;
var inst_13914 = inst_13931;
var inst_13915 = inst_13933;
var inst_13916 = (0);
var state_13972__$1 = (function (){var statearr_14006 = state_13972;
(statearr_14006[(12)] = inst_13915);

(statearr_14006[(13)] = inst_13914);

(statearr_14006[(15)] = inst_13916);

(statearr_14006[(16)] = inst_13913);

return statearr_14006;
})();
var statearr_14007_14045 = state_13972__$1;
(statearr_14007_14045[(2)] = null);

(statearr_14007_14045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (10))){
var inst_13915 = (state_13972[(12)]);
var inst_13914 = (state_13972[(13)]);
var inst_13916 = (state_13972[(15)]);
var inst_13913 = (state_13972[(16)]);
var inst_13921 = cljs.core._nth.call(null,inst_13914,inst_13916);
var inst_13922 = cljs.core.async.muxch_STAR_.call(null,inst_13921);
var inst_13923 = cljs.core.async.close_BANG_.call(null,inst_13922);
var inst_13924 = (inst_13916 + (1));
var tmp14002 = inst_13915;
var tmp14003 = inst_13914;
var tmp14004 = inst_13913;
var inst_13913__$1 = tmp14004;
var inst_13914__$1 = tmp14003;
var inst_13915__$1 = tmp14002;
var inst_13916__$1 = inst_13924;
var state_13972__$1 = (function (){var statearr_14008 = state_13972;
(statearr_14008[(17)] = inst_13923);

(statearr_14008[(12)] = inst_13915__$1);

(statearr_14008[(13)] = inst_13914__$1);

(statearr_14008[(15)] = inst_13916__$1);

(statearr_14008[(16)] = inst_13913__$1);

return statearr_14008;
})();
var statearr_14009_14046 = state_13972__$1;
(statearr_14009_14046[(2)] = null);

(statearr_14009_14046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (18))){
var inst_13942 = (state_13972[(2)]);
var state_13972__$1 = state_13972;
var statearr_14010_14047 = state_13972__$1;
(statearr_14010_14047[(2)] = inst_13942);

(statearr_14010_14047[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13973 === (8))){
var inst_13915 = (state_13972[(12)]);
var inst_13916 = (state_13972[(15)]);
var inst_13918 = (inst_13916 < inst_13915);
var inst_13919 = inst_13918;
var state_13972__$1 = state_13972;
if(cljs.core.truth_(inst_13919)){
var statearr_14011_14048 = state_13972__$1;
(statearr_14011_14048[(1)] = (10));

} else {
var statearr_14012_14049 = state_13972__$1;
(statearr_14012_14049[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14021,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___14021,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14016 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14016[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14016[(1)] = (1));

return statearr_14016;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13972){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14017){if((e14017 instanceof Object)){
var ex__7651__auto__ = e14017;
var statearr_14018_14050 = state_13972;
(statearr_14018_14050[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13972);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14017;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14051 = state_13972;
state_13972 = G__14051;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13972){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14021,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_14019 = f__7710__auto__.call(null);
(statearr_14019[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14021);

return statearr_14019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14021,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__14053 = arguments.length;
switch (G__14053) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__14056 = arguments.length;
switch (G__14056) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__14059 = arguments.length;
switch (G__14059) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7709__auto___14129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14098){
var state_val_14099 = (state_14098[(1)]);
if((state_val_14099 === (7))){
var state_14098__$1 = state_14098;
var statearr_14100_14130 = state_14098__$1;
(statearr_14100_14130[(2)] = null);

(statearr_14100_14130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (1))){
var state_14098__$1 = state_14098;
var statearr_14101_14131 = state_14098__$1;
(statearr_14101_14131[(2)] = null);

(statearr_14101_14131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (4))){
var inst_14062 = (state_14098[(7)]);
var inst_14064 = (inst_14062 < cnt);
var state_14098__$1 = state_14098;
if(cljs.core.truth_(inst_14064)){
var statearr_14102_14132 = state_14098__$1;
(statearr_14102_14132[(1)] = (6));

} else {
var statearr_14103_14133 = state_14098__$1;
(statearr_14103_14133[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (15))){
var inst_14094 = (state_14098[(2)]);
var state_14098__$1 = state_14098;
var statearr_14104_14134 = state_14098__$1;
(statearr_14104_14134[(2)] = inst_14094);

(statearr_14104_14134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (13))){
var inst_14087 = cljs.core.async.close_BANG_.call(null,out);
var state_14098__$1 = state_14098;
var statearr_14105_14135 = state_14098__$1;
(statearr_14105_14135[(2)] = inst_14087);

(statearr_14105_14135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (6))){
var state_14098__$1 = state_14098;
var statearr_14106_14136 = state_14098__$1;
(statearr_14106_14136[(2)] = null);

(statearr_14106_14136[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (3))){
var inst_14096 = (state_14098[(2)]);
var state_14098__$1 = state_14098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14098__$1,inst_14096);
} else {
if((state_val_14099 === (12))){
var inst_14084 = (state_14098[(8)]);
var inst_14084__$1 = (state_14098[(2)]);
var inst_14085 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14084__$1);
var state_14098__$1 = (function (){var statearr_14107 = state_14098;
(statearr_14107[(8)] = inst_14084__$1);

return statearr_14107;
})();
if(cljs.core.truth_(inst_14085)){
var statearr_14108_14137 = state_14098__$1;
(statearr_14108_14137[(1)] = (13));

} else {
var statearr_14109_14138 = state_14098__$1;
(statearr_14109_14138[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (2))){
var inst_14061 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14062 = (0);
var state_14098__$1 = (function (){var statearr_14110 = state_14098;
(statearr_14110[(7)] = inst_14062);

(statearr_14110[(9)] = inst_14061);

return statearr_14110;
})();
var statearr_14111_14139 = state_14098__$1;
(statearr_14111_14139[(2)] = null);

(statearr_14111_14139[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (11))){
var inst_14062 = (state_14098[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14098,(10),Object,null,(9));
var inst_14071 = chs__$1.call(null,inst_14062);
var inst_14072 = done.call(null,inst_14062);
var inst_14073 = cljs.core.async.take_BANG_.call(null,inst_14071,inst_14072);
var state_14098__$1 = state_14098;
var statearr_14112_14140 = state_14098__$1;
(statearr_14112_14140[(2)] = inst_14073);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14098__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (9))){
var inst_14062 = (state_14098[(7)]);
var inst_14075 = (state_14098[(2)]);
var inst_14076 = (inst_14062 + (1));
var inst_14062__$1 = inst_14076;
var state_14098__$1 = (function (){var statearr_14113 = state_14098;
(statearr_14113[(10)] = inst_14075);

(statearr_14113[(7)] = inst_14062__$1);

return statearr_14113;
})();
var statearr_14114_14141 = state_14098__$1;
(statearr_14114_14141[(2)] = null);

(statearr_14114_14141[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (5))){
var inst_14082 = (state_14098[(2)]);
var state_14098__$1 = (function (){var statearr_14115 = state_14098;
(statearr_14115[(11)] = inst_14082);

return statearr_14115;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14098__$1,(12),dchan);
} else {
if((state_val_14099 === (14))){
var inst_14084 = (state_14098[(8)]);
var inst_14089 = cljs.core.apply.call(null,f,inst_14084);
var state_14098__$1 = state_14098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14098__$1,(16),out,inst_14089);
} else {
if((state_val_14099 === (16))){
var inst_14091 = (state_14098[(2)]);
var state_14098__$1 = (function (){var statearr_14116 = state_14098;
(statearr_14116[(12)] = inst_14091);

return statearr_14116;
})();
var statearr_14117_14142 = state_14098__$1;
(statearr_14117_14142[(2)] = null);

(statearr_14117_14142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (10))){
var inst_14066 = (state_14098[(2)]);
var inst_14067 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14098__$1 = (function (){var statearr_14118 = state_14098;
(statearr_14118[(13)] = inst_14066);

return statearr_14118;
})();
var statearr_14119_14143 = state_14098__$1;
(statearr_14119_14143[(2)] = inst_14067);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14098__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14099 === (8))){
var inst_14080 = (state_14098[(2)]);
var state_14098__$1 = state_14098;
var statearr_14120_14144 = state_14098__$1;
(statearr_14120_14144[(2)] = inst_14080);

(statearr_14120_14144[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14124[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14124[(1)] = (1));

return statearr_14124;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14098){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14125){if((e14125 instanceof Object)){
var ex__7651__auto__ = e14125;
var statearr_14126_14145 = state_14098;
(statearr_14126_14145[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14146 = state_14098;
state_14098 = G__14146;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_14127 = f__7710__auto__.call(null);
(statearr_14127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14129);

return statearr_14127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14129,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__14149 = arguments.length;
switch (G__14149) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14204 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14204,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14204,out){
return (function (state_14179){
var state_val_14180 = (state_14179[(1)]);
if((state_val_14180 === (7))){
var inst_14159 = (state_14179[(7)]);
var inst_14158 = (state_14179[(8)]);
var inst_14158__$1 = (state_14179[(2)]);
var inst_14159__$1 = cljs.core.nth.call(null,inst_14158__$1,(0),null);
var inst_14160 = cljs.core.nth.call(null,inst_14158__$1,(1),null);
var inst_14161 = (inst_14159__$1 == null);
var state_14179__$1 = (function (){var statearr_14181 = state_14179;
(statearr_14181[(9)] = inst_14160);

(statearr_14181[(7)] = inst_14159__$1);

(statearr_14181[(8)] = inst_14158__$1);

return statearr_14181;
})();
if(cljs.core.truth_(inst_14161)){
var statearr_14182_14205 = state_14179__$1;
(statearr_14182_14205[(1)] = (8));

} else {
var statearr_14183_14206 = state_14179__$1;
(statearr_14183_14206[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (1))){
var inst_14150 = cljs.core.vec.call(null,chs);
var inst_14151 = inst_14150;
var state_14179__$1 = (function (){var statearr_14184 = state_14179;
(statearr_14184[(10)] = inst_14151);

return statearr_14184;
})();
var statearr_14185_14207 = state_14179__$1;
(statearr_14185_14207[(2)] = null);

(statearr_14185_14207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (4))){
var inst_14151 = (state_14179[(10)]);
var state_14179__$1 = state_14179;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14179__$1,(7),inst_14151);
} else {
if((state_val_14180 === (6))){
var inst_14175 = (state_14179[(2)]);
var state_14179__$1 = state_14179;
var statearr_14186_14208 = state_14179__$1;
(statearr_14186_14208[(2)] = inst_14175);

(statearr_14186_14208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (3))){
var inst_14177 = (state_14179[(2)]);
var state_14179__$1 = state_14179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14179__$1,inst_14177);
} else {
if((state_val_14180 === (2))){
var inst_14151 = (state_14179[(10)]);
var inst_14153 = cljs.core.count.call(null,inst_14151);
var inst_14154 = (inst_14153 > (0));
var state_14179__$1 = state_14179;
if(cljs.core.truth_(inst_14154)){
var statearr_14188_14209 = state_14179__$1;
(statearr_14188_14209[(1)] = (4));

} else {
var statearr_14189_14210 = state_14179__$1;
(statearr_14189_14210[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (11))){
var inst_14151 = (state_14179[(10)]);
var inst_14168 = (state_14179[(2)]);
var tmp14187 = inst_14151;
var inst_14151__$1 = tmp14187;
var state_14179__$1 = (function (){var statearr_14190 = state_14179;
(statearr_14190[(11)] = inst_14168);

(statearr_14190[(10)] = inst_14151__$1);

return statearr_14190;
})();
var statearr_14191_14211 = state_14179__$1;
(statearr_14191_14211[(2)] = null);

(statearr_14191_14211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (9))){
var inst_14159 = (state_14179[(7)]);
var state_14179__$1 = state_14179;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14179__$1,(11),out,inst_14159);
} else {
if((state_val_14180 === (5))){
var inst_14173 = cljs.core.async.close_BANG_.call(null,out);
var state_14179__$1 = state_14179;
var statearr_14192_14212 = state_14179__$1;
(statearr_14192_14212[(2)] = inst_14173);

(statearr_14192_14212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (10))){
var inst_14171 = (state_14179[(2)]);
var state_14179__$1 = state_14179;
var statearr_14193_14213 = state_14179__$1;
(statearr_14193_14213[(2)] = inst_14171);

(statearr_14193_14213[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14180 === (8))){
var inst_14160 = (state_14179[(9)]);
var inst_14159 = (state_14179[(7)]);
var inst_14151 = (state_14179[(10)]);
var inst_14158 = (state_14179[(8)]);
var inst_14163 = (function (){var c = inst_14160;
var v = inst_14159;
var vec__14156 = inst_14158;
var cs = inst_14151;
return ((function (c,v,vec__14156,cs,inst_14160,inst_14159,inst_14151,inst_14158,state_val_14180,c__7709__auto___14204,out){
return (function (p1__14147_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14147_SHARP_);
});
;})(c,v,vec__14156,cs,inst_14160,inst_14159,inst_14151,inst_14158,state_val_14180,c__7709__auto___14204,out))
})();
var inst_14164 = cljs.core.filterv.call(null,inst_14163,inst_14151);
var inst_14151__$1 = inst_14164;
var state_14179__$1 = (function (){var statearr_14194 = state_14179;
(statearr_14194[(10)] = inst_14151__$1);

return statearr_14194;
})();
var statearr_14195_14214 = state_14179__$1;
(statearr_14195_14214[(2)] = null);

(statearr_14195_14214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14204,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14204,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14199 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14199[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14199[(1)] = (1));

return statearr_14199;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14179){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14200){if((e14200 instanceof Object)){
var ex__7651__auto__ = e14200;
var statearr_14201_14215 = state_14179;
(statearr_14201_14215[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14216 = state_14179;
state_14179 = G__14216;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14204,out))
})();
var state__7711__auto__ = (function (){var statearr_14202 = f__7710__auto__.call(null);
(statearr_14202[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14204);

return statearr_14202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14204,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__14218 = arguments.length;
switch (G__14218) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14266 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14266,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14266,out){
return (function (state_14242){
var state_val_14243 = (state_14242[(1)]);
if((state_val_14243 === (7))){
var inst_14224 = (state_14242[(7)]);
var inst_14224__$1 = (state_14242[(2)]);
var inst_14225 = (inst_14224__$1 == null);
var inst_14226 = cljs.core.not.call(null,inst_14225);
var state_14242__$1 = (function (){var statearr_14244 = state_14242;
(statearr_14244[(7)] = inst_14224__$1);

return statearr_14244;
})();
if(inst_14226){
var statearr_14245_14267 = state_14242__$1;
(statearr_14245_14267[(1)] = (8));

} else {
var statearr_14246_14268 = state_14242__$1;
(statearr_14246_14268[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (1))){
var inst_14219 = (0);
var state_14242__$1 = (function (){var statearr_14247 = state_14242;
(statearr_14247[(8)] = inst_14219);

return statearr_14247;
})();
var statearr_14248_14269 = state_14242__$1;
(statearr_14248_14269[(2)] = null);

(statearr_14248_14269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (4))){
var state_14242__$1 = state_14242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14242__$1,(7),ch);
} else {
if((state_val_14243 === (6))){
var inst_14237 = (state_14242[(2)]);
var state_14242__$1 = state_14242;
var statearr_14249_14270 = state_14242__$1;
(statearr_14249_14270[(2)] = inst_14237);

(statearr_14249_14270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (3))){
var inst_14239 = (state_14242[(2)]);
var inst_14240 = cljs.core.async.close_BANG_.call(null,out);
var state_14242__$1 = (function (){var statearr_14250 = state_14242;
(statearr_14250[(9)] = inst_14239);

return statearr_14250;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14242__$1,inst_14240);
} else {
if((state_val_14243 === (2))){
var inst_14219 = (state_14242[(8)]);
var inst_14221 = (inst_14219 < n);
var state_14242__$1 = state_14242;
if(cljs.core.truth_(inst_14221)){
var statearr_14251_14271 = state_14242__$1;
(statearr_14251_14271[(1)] = (4));

} else {
var statearr_14252_14272 = state_14242__$1;
(statearr_14252_14272[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (11))){
var inst_14219 = (state_14242[(8)]);
var inst_14229 = (state_14242[(2)]);
var inst_14230 = (inst_14219 + (1));
var inst_14219__$1 = inst_14230;
var state_14242__$1 = (function (){var statearr_14253 = state_14242;
(statearr_14253[(10)] = inst_14229);

(statearr_14253[(8)] = inst_14219__$1);

return statearr_14253;
})();
var statearr_14254_14273 = state_14242__$1;
(statearr_14254_14273[(2)] = null);

(statearr_14254_14273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (9))){
var state_14242__$1 = state_14242;
var statearr_14255_14274 = state_14242__$1;
(statearr_14255_14274[(2)] = null);

(statearr_14255_14274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (5))){
var state_14242__$1 = state_14242;
var statearr_14256_14275 = state_14242__$1;
(statearr_14256_14275[(2)] = null);

(statearr_14256_14275[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (10))){
var inst_14234 = (state_14242[(2)]);
var state_14242__$1 = state_14242;
var statearr_14257_14276 = state_14242__$1;
(statearr_14257_14276[(2)] = inst_14234);

(statearr_14257_14276[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14243 === (8))){
var inst_14224 = (state_14242[(7)]);
var state_14242__$1 = state_14242;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14242__$1,(11),out,inst_14224);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14266,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14266,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14261 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14261[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14261[(1)] = (1));

return statearr_14261;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14242){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14262){if((e14262 instanceof Object)){
var ex__7651__auto__ = e14262;
var statearr_14263_14277 = state_14242;
(statearr_14263_14277[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14242);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14262;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14278 = state_14242;
state_14242 = G__14278;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14242){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14266,out))
})();
var state__7711__auto__ = (function (){var statearr_14264 = f__7710__auto__.call(null);
(statearr_14264[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14266);

return statearr_14264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14266,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t14286 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14286 = (function (ch,f,map_LT_,meta14287){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta14287 = meta14287;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t14289 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14289 = (function (fn1,_,meta14287,map_LT_,f,ch,meta14290){
this.fn1 = fn1;
this._ = _;
this.meta14287 = meta14287;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14290 = meta14290;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14279_SHARP_){
return f1.call(null,(((p1__14279_SHARP_ == null))?null:self__.f.call(null,p1__14279_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t14289.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14291){
var self__ = this;
var _14291__$1 = this;
return self__.meta14290;
});})(___$1))
;

cljs.core.async.t14289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14291,meta14290__$1){
var self__ = this;
var _14291__$1 = this;
return (new cljs.core.async.t14289(self__.fn1,self__._,self__.meta14287,self__.map_LT_,self__.f,self__.ch,meta14290__$1));
});})(___$1))
;

cljs.core.async.t14289.cljs$lang$type = true;

cljs.core.async.t14289.cljs$lang$ctorStr = "cljs.core.async/t14289";

cljs.core.async.t14289.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14289");
});})(___$1))
;

cljs.core.async.__GT_t14289 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t14289(fn1__$1,___$2,meta14287__$1,map_LT___$1,f__$1,ch__$1,meta14290){
return (new cljs.core.async.t14289(fn1__$1,___$2,meta14287__$1,map_LT___$1,f__$1,ch__$1,meta14290));
});})(___$1))
;

}

return (new cljs.core.async.t14289(fn1,___$1,self__.meta14287,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14286.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14286.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14288){
var self__ = this;
var _14288__$1 = this;
return self__.meta14287;
});

cljs.core.async.t14286.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14288,meta14287__$1){
var self__ = this;
var _14288__$1 = this;
return (new cljs.core.async.t14286(self__.ch,self__.f,self__.map_LT_,meta14287__$1));
});

cljs.core.async.t14286.cljs$lang$type = true;

cljs.core.async.t14286.cljs$lang$ctorStr = "cljs.core.async/t14286";

cljs.core.async.t14286.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14286");
});

cljs.core.async.__GT_t14286 = (function cljs$core$async$map_LT__$___GT_t14286(ch__$1,f__$1,map_LT___$1,meta14287){
return (new cljs.core.async.t14286(ch__$1,f__$1,map_LT___$1,meta14287));
});

}

return (new cljs.core.async.t14286(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t14295 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14295 = (function (ch,f,map_GT_,meta14296){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta14296 = meta14296;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14295.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14295.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14297){
var self__ = this;
var _14297__$1 = this;
return self__.meta14296;
});

cljs.core.async.t14295.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14297,meta14296__$1){
var self__ = this;
var _14297__$1 = this;
return (new cljs.core.async.t14295(self__.ch,self__.f,self__.map_GT_,meta14296__$1));
});

cljs.core.async.t14295.cljs$lang$type = true;

cljs.core.async.t14295.cljs$lang$ctorStr = "cljs.core.async/t14295";

cljs.core.async.t14295.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14295");
});

cljs.core.async.__GT_t14295 = (function cljs$core$async$map_GT__$___GT_t14295(ch__$1,f__$1,map_GT___$1,meta14296){
return (new cljs.core.async.t14295(ch__$1,f__$1,map_GT___$1,meta14296));
});

}

return (new cljs.core.async.t14295(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t14301 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14301 = (function (ch,p,filter_GT_,meta14302){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta14302 = meta14302;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14301.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14301.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14303){
var self__ = this;
var _14303__$1 = this;
return self__.meta14302;
});

cljs.core.async.t14301.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14303,meta14302__$1){
var self__ = this;
var _14303__$1 = this;
return (new cljs.core.async.t14301(self__.ch,self__.p,self__.filter_GT_,meta14302__$1));
});

cljs.core.async.t14301.cljs$lang$type = true;

cljs.core.async.t14301.cljs$lang$ctorStr = "cljs.core.async/t14301";

cljs.core.async.t14301.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14301");
});

cljs.core.async.__GT_t14301 = (function cljs$core$async$filter_GT__$___GT_t14301(ch__$1,p__$1,filter_GT___$1,meta14302){
return (new cljs.core.async.t14301(ch__$1,p__$1,filter_GT___$1,meta14302));
});

}

return (new cljs.core.async.t14301(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__14305 = arguments.length;
switch (G__14305) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14348 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14348,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14348,out){
return (function (state_14326){
var state_val_14327 = (state_14326[(1)]);
if((state_val_14327 === (7))){
var inst_14322 = (state_14326[(2)]);
var state_14326__$1 = state_14326;
var statearr_14328_14349 = state_14326__$1;
(statearr_14328_14349[(2)] = inst_14322);

(statearr_14328_14349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (1))){
var state_14326__$1 = state_14326;
var statearr_14329_14350 = state_14326__$1;
(statearr_14329_14350[(2)] = null);

(statearr_14329_14350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (4))){
var inst_14308 = (state_14326[(7)]);
var inst_14308__$1 = (state_14326[(2)]);
var inst_14309 = (inst_14308__$1 == null);
var state_14326__$1 = (function (){var statearr_14330 = state_14326;
(statearr_14330[(7)] = inst_14308__$1);

return statearr_14330;
})();
if(cljs.core.truth_(inst_14309)){
var statearr_14331_14351 = state_14326__$1;
(statearr_14331_14351[(1)] = (5));

} else {
var statearr_14332_14352 = state_14326__$1;
(statearr_14332_14352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (6))){
var inst_14308 = (state_14326[(7)]);
var inst_14313 = p.call(null,inst_14308);
var state_14326__$1 = state_14326;
if(cljs.core.truth_(inst_14313)){
var statearr_14333_14353 = state_14326__$1;
(statearr_14333_14353[(1)] = (8));

} else {
var statearr_14334_14354 = state_14326__$1;
(statearr_14334_14354[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (3))){
var inst_14324 = (state_14326[(2)]);
var state_14326__$1 = state_14326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14326__$1,inst_14324);
} else {
if((state_val_14327 === (2))){
var state_14326__$1 = state_14326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14326__$1,(4),ch);
} else {
if((state_val_14327 === (11))){
var inst_14316 = (state_14326[(2)]);
var state_14326__$1 = state_14326;
var statearr_14335_14355 = state_14326__$1;
(statearr_14335_14355[(2)] = inst_14316);

(statearr_14335_14355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (9))){
var state_14326__$1 = state_14326;
var statearr_14336_14356 = state_14326__$1;
(statearr_14336_14356[(2)] = null);

(statearr_14336_14356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (5))){
var inst_14311 = cljs.core.async.close_BANG_.call(null,out);
var state_14326__$1 = state_14326;
var statearr_14337_14357 = state_14326__$1;
(statearr_14337_14357[(2)] = inst_14311);

(statearr_14337_14357[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (10))){
var inst_14319 = (state_14326[(2)]);
var state_14326__$1 = (function (){var statearr_14338 = state_14326;
(statearr_14338[(8)] = inst_14319);

return statearr_14338;
})();
var statearr_14339_14358 = state_14326__$1;
(statearr_14339_14358[(2)] = null);

(statearr_14339_14358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14327 === (8))){
var inst_14308 = (state_14326[(7)]);
var state_14326__$1 = state_14326;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14326__$1,(11),out,inst_14308);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14348,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14348,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14343 = [null,null,null,null,null,null,null,null,null];
(statearr_14343[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14343[(1)] = (1));

return statearr_14343;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14326){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14344){if((e14344 instanceof Object)){
var ex__7651__auto__ = e14344;
var statearr_14345_14359 = state_14326;
(statearr_14345_14359[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14326);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14360 = state_14326;
state_14326 = G__14360;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14326){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14348,out))
})();
var state__7711__auto__ = (function (){var statearr_14346 = f__7710__auto__.call(null);
(statearr_14346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14348);

return statearr_14346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14348,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__14362 = arguments.length;
switch (G__14362) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_14529){
var state_val_14530 = (state_14529[(1)]);
if((state_val_14530 === (7))){
var inst_14525 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
var statearr_14531_14572 = state_14529__$1;
(statearr_14531_14572[(2)] = inst_14525);

(statearr_14531_14572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (20))){
var inst_14495 = (state_14529[(7)]);
var inst_14506 = (state_14529[(2)]);
var inst_14507 = cljs.core.next.call(null,inst_14495);
var inst_14481 = inst_14507;
var inst_14482 = null;
var inst_14483 = (0);
var inst_14484 = (0);
var state_14529__$1 = (function (){var statearr_14532 = state_14529;
(statearr_14532[(8)] = inst_14506);

(statearr_14532[(9)] = inst_14482);

(statearr_14532[(10)] = inst_14484);

(statearr_14532[(11)] = inst_14483);

(statearr_14532[(12)] = inst_14481);

return statearr_14532;
})();
var statearr_14533_14573 = state_14529__$1;
(statearr_14533_14573[(2)] = null);

(statearr_14533_14573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (1))){
var state_14529__$1 = state_14529;
var statearr_14534_14574 = state_14529__$1;
(statearr_14534_14574[(2)] = null);

(statearr_14534_14574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (4))){
var inst_14470 = (state_14529[(13)]);
var inst_14470__$1 = (state_14529[(2)]);
var inst_14471 = (inst_14470__$1 == null);
var state_14529__$1 = (function (){var statearr_14535 = state_14529;
(statearr_14535[(13)] = inst_14470__$1);

return statearr_14535;
})();
if(cljs.core.truth_(inst_14471)){
var statearr_14536_14575 = state_14529__$1;
(statearr_14536_14575[(1)] = (5));

} else {
var statearr_14537_14576 = state_14529__$1;
(statearr_14537_14576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (15))){
var state_14529__$1 = state_14529;
var statearr_14541_14577 = state_14529__$1;
(statearr_14541_14577[(2)] = null);

(statearr_14541_14577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (21))){
var state_14529__$1 = state_14529;
var statearr_14542_14578 = state_14529__$1;
(statearr_14542_14578[(2)] = null);

(statearr_14542_14578[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (13))){
var inst_14482 = (state_14529[(9)]);
var inst_14484 = (state_14529[(10)]);
var inst_14483 = (state_14529[(11)]);
var inst_14481 = (state_14529[(12)]);
var inst_14491 = (state_14529[(2)]);
var inst_14492 = (inst_14484 + (1));
var tmp14538 = inst_14482;
var tmp14539 = inst_14483;
var tmp14540 = inst_14481;
var inst_14481__$1 = tmp14540;
var inst_14482__$1 = tmp14538;
var inst_14483__$1 = tmp14539;
var inst_14484__$1 = inst_14492;
var state_14529__$1 = (function (){var statearr_14543 = state_14529;
(statearr_14543[(14)] = inst_14491);

(statearr_14543[(9)] = inst_14482__$1);

(statearr_14543[(10)] = inst_14484__$1);

(statearr_14543[(11)] = inst_14483__$1);

(statearr_14543[(12)] = inst_14481__$1);

return statearr_14543;
})();
var statearr_14544_14579 = state_14529__$1;
(statearr_14544_14579[(2)] = null);

(statearr_14544_14579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (22))){
var state_14529__$1 = state_14529;
var statearr_14545_14580 = state_14529__$1;
(statearr_14545_14580[(2)] = null);

(statearr_14545_14580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (6))){
var inst_14470 = (state_14529[(13)]);
var inst_14479 = f.call(null,inst_14470);
var inst_14480 = cljs.core.seq.call(null,inst_14479);
var inst_14481 = inst_14480;
var inst_14482 = null;
var inst_14483 = (0);
var inst_14484 = (0);
var state_14529__$1 = (function (){var statearr_14546 = state_14529;
(statearr_14546[(9)] = inst_14482);

(statearr_14546[(10)] = inst_14484);

(statearr_14546[(11)] = inst_14483);

(statearr_14546[(12)] = inst_14481);

return statearr_14546;
})();
var statearr_14547_14581 = state_14529__$1;
(statearr_14547_14581[(2)] = null);

(statearr_14547_14581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (17))){
var inst_14495 = (state_14529[(7)]);
var inst_14499 = cljs.core.chunk_first.call(null,inst_14495);
var inst_14500 = cljs.core.chunk_rest.call(null,inst_14495);
var inst_14501 = cljs.core.count.call(null,inst_14499);
var inst_14481 = inst_14500;
var inst_14482 = inst_14499;
var inst_14483 = inst_14501;
var inst_14484 = (0);
var state_14529__$1 = (function (){var statearr_14548 = state_14529;
(statearr_14548[(9)] = inst_14482);

(statearr_14548[(10)] = inst_14484);

(statearr_14548[(11)] = inst_14483);

(statearr_14548[(12)] = inst_14481);

return statearr_14548;
})();
var statearr_14549_14582 = state_14529__$1;
(statearr_14549_14582[(2)] = null);

(statearr_14549_14582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (3))){
var inst_14527 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14529__$1,inst_14527);
} else {
if((state_val_14530 === (12))){
var inst_14515 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
var statearr_14550_14583 = state_14529__$1;
(statearr_14550_14583[(2)] = inst_14515);

(statearr_14550_14583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (2))){
var state_14529__$1 = state_14529;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14529__$1,(4),in$);
} else {
if((state_val_14530 === (23))){
var inst_14523 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
var statearr_14551_14584 = state_14529__$1;
(statearr_14551_14584[(2)] = inst_14523);

(statearr_14551_14584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (19))){
var inst_14510 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
var statearr_14552_14585 = state_14529__$1;
(statearr_14552_14585[(2)] = inst_14510);

(statearr_14552_14585[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (11))){
var inst_14481 = (state_14529[(12)]);
var inst_14495 = (state_14529[(7)]);
var inst_14495__$1 = cljs.core.seq.call(null,inst_14481);
var state_14529__$1 = (function (){var statearr_14553 = state_14529;
(statearr_14553[(7)] = inst_14495__$1);

return statearr_14553;
})();
if(inst_14495__$1){
var statearr_14554_14586 = state_14529__$1;
(statearr_14554_14586[(1)] = (14));

} else {
var statearr_14555_14587 = state_14529__$1;
(statearr_14555_14587[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (9))){
var inst_14517 = (state_14529[(2)]);
var inst_14518 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14529__$1 = (function (){var statearr_14556 = state_14529;
(statearr_14556[(15)] = inst_14517);

return statearr_14556;
})();
if(cljs.core.truth_(inst_14518)){
var statearr_14557_14588 = state_14529__$1;
(statearr_14557_14588[(1)] = (21));

} else {
var statearr_14558_14589 = state_14529__$1;
(statearr_14558_14589[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (5))){
var inst_14473 = cljs.core.async.close_BANG_.call(null,out);
var state_14529__$1 = state_14529;
var statearr_14559_14590 = state_14529__$1;
(statearr_14559_14590[(2)] = inst_14473);

(statearr_14559_14590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (14))){
var inst_14495 = (state_14529[(7)]);
var inst_14497 = cljs.core.chunked_seq_QMARK_.call(null,inst_14495);
var state_14529__$1 = state_14529;
if(inst_14497){
var statearr_14560_14591 = state_14529__$1;
(statearr_14560_14591[(1)] = (17));

} else {
var statearr_14561_14592 = state_14529__$1;
(statearr_14561_14592[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (16))){
var inst_14513 = (state_14529[(2)]);
var state_14529__$1 = state_14529;
var statearr_14562_14593 = state_14529__$1;
(statearr_14562_14593[(2)] = inst_14513);

(statearr_14562_14593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14530 === (10))){
var inst_14482 = (state_14529[(9)]);
var inst_14484 = (state_14529[(10)]);
var inst_14489 = cljs.core._nth.call(null,inst_14482,inst_14484);
var state_14529__$1 = state_14529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14529__$1,(13),out,inst_14489);
} else {
if((state_val_14530 === (18))){
var inst_14495 = (state_14529[(7)]);
var inst_14504 = cljs.core.first.call(null,inst_14495);
var state_14529__$1 = state_14529;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14529__$1,(20),out,inst_14504);
} else {
if((state_val_14530 === (8))){
var inst_14484 = (state_14529[(10)]);
var inst_14483 = (state_14529[(11)]);
var inst_14486 = (inst_14484 < inst_14483);
var inst_14487 = inst_14486;
var state_14529__$1 = state_14529;
if(cljs.core.truth_(inst_14487)){
var statearr_14563_14594 = state_14529__$1;
(statearr_14563_14594[(1)] = (10));

} else {
var statearr_14564_14595 = state_14529__$1;
(statearr_14564_14595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_14568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14568[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_14568[(1)] = (1));

return statearr_14568;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_14529){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14569){if((e14569 instanceof Object)){
var ex__7651__auto__ = e14569;
var statearr_14570_14596 = state_14529;
(statearr_14570_14596[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14529);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14597 = state_14529;
state_14529 = G__14597;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_14529){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_14529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_14571 = f__7710__auto__.call(null);
(statearr_14571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_14571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__14599 = arguments.length;
switch (G__14599) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__14602 = arguments.length;
switch (G__14602) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__14605 = arguments.length;
switch (G__14605) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14655 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14655,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14655,out){
return (function (state_14629){
var state_val_14630 = (state_14629[(1)]);
if((state_val_14630 === (7))){
var inst_14624 = (state_14629[(2)]);
var state_14629__$1 = state_14629;
var statearr_14631_14656 = state_14629__$1;
(statearr_14631_14656[(2)] = inst_14624);

(statearr_14631_14656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (1))){
var inst_14606 = null;
var state_14629__$1 = (function (){var statearr_14632 = state_14629;
(statearr_14632[(7)] = inst_14606);

return statearr_14632;
})();
var statearr_14633_14657 = state_14629__$1;
(statearr_14633_14657[(2)] = null);

(statearr_14633_14657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (4))){
var inst_14609 = (state_14629[(8)]);
var inst_14609__$1 = (state_14629[(2)]);
var inst_14610 = (inst_14609__$1 == null);
var inst_14611 = cljs.core.not.call(null,inst_14610);
var state_14629__$1 = (function (){var statearr_14634 = state_14629;
(statearr_14634[(8)] = inst_14609__$1);

return statearr_14634;
})();
if(inst_14611){
var statearr_14635_14658 = state_14629__$1;
(statearr_14635_14658[(1)] = (5));

} else {
var statearr_14636_14659 = state_14629__$1;
(statearr_14636_14659[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (6))){
var state_14629__$1 = state_14629;
var statearr_14637_14660 = state_14629__$1;
(statearr_14637_14660[(2)] = null);

(statearr_14637_14660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (3))){
var inst_14626 = (state_14629[(2)]);
var inst_14627 = cljs.core.async.close_BANG_.call(null,out);
var state_14629__$1 = (function (){var statearr_14638 = state_14629;
(statearr_14638[(9)] = inst_14626);

return statearr_14638;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14629__$1,inst_14627);
} else {
if((state_val_14630 === (2))){
var state_14629__$1 = state_14629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14629__$1,(4),ch);
} else {
if((state_val_14630 === (11))){
var inst_14609 = (state_14629[(8)]);
var inst_14618 = (state_14629[(2)]);
var inst_14606 = inst_14609;
var state_14629__$1 = (function (){var statearr_14639 = state_14629;
(statearr_14639[(10)] = inst_14618);

(statearr_14639[(7)] = inst_14606);

return statearr_14639;
})();
var statearr_14640_14661 = state_14629__$1;
(statearr_14640_14661[(2)] = null);

(statearr_14640_14661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (9))){
var inst_14609 = (state_14629[(8)]);
var state_14629__$1 = state_14629;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14629__$1,(11),out,inst_14609);
} else {
if((state_val_14630 === (5))){
var inst_14606 = (state_14629[(7)]);
var inst_14609 = (state_14629[(8)]);
var inst_14613 = cljs.core._EQ_.call(null,inst_14609,inst_14606);
var state_14629__$1 = state_14629;
if(inst_14613){
var statearr_14642_14662 = state_14629__$1;
(statearr_14642_14662[(1)] = (8));

} else {
var statearr_14643_14663 = state_14629__$1;
(statearr_14643_14663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (10))){
var inst_14621 = (state_14629[(2)]);
var state_14629__$1 = state_14629;
var statearr_14644_14664 = state_14629__$1;
(statearr_14644_14664[(2)] = inst_14621);

(statearr_14644_14664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14630 === (8))){
var inst_14606 = (state_14629[(7)]);
var tmp14641 = inst_14606;
var inst_14606__$1 = tmp14641;
var state_14629__$1 = (function (){var statearr_14645 = state_14629;
(statearr_14645[(7)] = inst_14606__$1);

return statearr_14645;
})();
var statearr_14646_14665 = state_14629__$1;
(statearr_14646_14665[(2)] = null);

(statearr_14646_14665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14655,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14655,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14650 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14650[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14650[(1)] = (1));

return statearr_14650;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14629){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14651){if((e14651 instanceof Object)){
var ex__7651__auto__ = e14651;
var statearr_14652_14666 = state_14629;
(statearr_14652_14666[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14629);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14667 = state_14629;
state_14629 = G__14667;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14629){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14655,out))
})();
var state__7711__auto__ = (function (){var statearr_14653 = f__7710__auto__.call(null);
(statearr_14653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14655);

return statearr_14653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14655,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__14669 = arguments.length;
switch (G__14669) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14738 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14738,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14738,out){
return (function (state_14707){
var state_val_14708 = (state_14707[(1)]);
if((state_val_14708 === (7))){
var inst_14703 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14709_14739 = state_14707__$1;
(statearr_14709_14739[(2)] = inst_14703);

(statearr_14709_14739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (1))){
var inst_14670 = (new Array(n));
var inst_14671 = inst_14670;
var inst_14672 = (0);
var state_14707__$1 = (function (){var statearr_14710 = state_14707;
(statearr_14710[(7)] = inst_14672);

(statearr_14710[(8)] = inst_14671);

return statearr_14710;
})();
var statearr_14711_14740 = state_14707__$1;
(statearr_14711_14740[(2)] = null);

(statearr_14711_14740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (4))){
var inst_14675 = (state_14707[(9)]);
var inst_14675__$1 = (state_14707[(2)]);
var inst_14676 = (inst_14675__$1 == null);
var inst_14677 = cljs.core.not.call(null,inst_14676);
var state_14707__$1 = (function (){var statearr_14712 = state_14707;
(statearr_14712[(9)] = inst_14675__$1);

return statearr_14712;
})();
if(inst_14677){
var statearr_14713_14741 = state_14707__$1;
(statearr_14713_14741[(1)] = (5));

} else {
var statearr_14714_14742 = state_14707__$1;
(statearr_14714_14742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (15))){
var inst_14697 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14715_14743 = state_14707__$1;
(statearr_14715_14743[(2)] = inst_14697);

(statearr_14715_14743[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (13))){
var state_14707__$1 = state_14707;
var statearr_14716_14744 = state_14707__$1;
(statearr_14716_14744[(2)] = null);

(statearr_14716_14744[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (6))){
var inst_14672 = (state_14707[(7)]);
var inst_14693 = (inst_14672 > (0));
var state_14707__$1 = state_14707;
if(cljs.core.truth_(inst_14693)){
var statearr_14717_14745 = state_14707__$1;
(statearr_14717_14745[(1)] = (12));

} else {
var statearr_14718_14746 = state_14707__$1;
(statearr_14718_14746[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (3))){
var inst_14705 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14707__$1,inst_14705);
} else {
if((state_val_14708 === (12))){
var inst_14671 = (state_14707[(8)]);
var inst_14695 = cljs.core.vec.call(null,inst_14671);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14707__$1,(15),out,inst_14695);
} else {
if((state_val_14708 === (2))){
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14707__$1,(4),ch);
} else {
if((state_val_14708 === (11))){
var inst_14687 = (state_14707[(2)]);
var inst_14688 = (new Array(n));
var inst_14671 = inst_14688;
var inst_14672 = (0);
var state_14707__$1 = (function (){var statearr_14719 = state_14707;
(statearr_14719[(7)] = inst_14672);

(statearr_14719[(10)] = inst_14687);

(statearr_14719[(8)] = inst_14671);

return statearr_14719;
})();
var statearr_14720_14747 = state_14707__$1;
(statearr_14720_14747[(2)] = null);

(statearr_14720_14747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (9))){
var inst_14671 = (state_14707[(8)]);
var inst_14685 = cljs.core.vec.call(null,inst_14671);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14707__$1,(11),out,inst_14685);
} else {
if((state_val_14708 === (5))){
var inst_14675 = (state_14707[(9)]);
var inst_14672 = (state_14707[(7)]);
var inst_14680 = (state_14707[(11)]);
var inst_14671 = (state_14707[(8)]);
var inst_14679 = (inst_14671[inst_14672] = inst_14675);
var inst_14680__$1 = (inst_14672 + (1));
var inst_14681 = (inst_14680__$1 < n);
var state_14707__$1 = (function (){var statearr_14721 = state_14707;
(statearr_14721[(11)] = inst_14680__$1);

(statearr_14721[(12)] = inst_14679);

return statearr_14721;
})();
if(cljs.core.truth_(inst_14681)){
var statearr_14722_14748 = state_14707__$1;
(statearr_14722_14748[(1)] = (8));

} else {
var statearr_14723_14749 = state_14707__$1;
(statearr_14723_14749[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (14))){
var inst_14700 = (state_14707[(2)]);
var inst_14701 = cljs.core.async.close_BANG_.call(null,out);
var state_14707__$1 = (function (){var statearr_14725 = state_14707;
(statearr_14725[(13)] = inst_14700);

return statearr_14725;
})();
var statearr_14726_14750 = state_14707__$1;
(statearr_14726_14750[(2)] = inst_14701);

(statearr_14726_14750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (10))){
var inst_14691 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14727_14751 = state_14707__$1;
(statearr_14727_14751[(2)] = inst_14691);

(statearr_14727_14751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (8))){
var inst_14680 = (state_14707[(11)]);
var inst_14671 = (state_14707[(8)]);
var tmp14724 = inst_14671;
var inst_14671__$1 = tmp14724;
var inst_14672 = inst_14680;
var state_14707__$1 = (function (){var statearr_14728 = state_14707;
(statearr_14728[(7)] = inst_14672);

(statearr_14728[(8)] = inst_14671__$1);

return statearr_14728;
})();
var statearr_14729_14752 = state_14707__$1;
(statearr_14729_14752[(2)] = null);

(statearr_14729_14752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14738,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14738,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14733[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14733[(1)] = (1));

return statearr_14733;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14707){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14734){if((e14734 instanceof Object)){
var ex__7651__auto__ = e14734;
var statearr_14735_14753 = state_14707;
(statearr_14735_14753[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14707);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14754 = state_14707;
state_14707 = G__14754;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14707){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14738,out))
})();
var state__7711__auto__ = (function (){var statearr_14736 = f__7710__auto__.call(null);
(statearr_14736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14738);

return statearr_14736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14738,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__14756 = arguments.length;
switch (G__14756) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14829,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14829,out){
return (function (state_14798){
var state_val_14799 = (state_14798[(1)]);
if((state_val_14799 === (7))){
var inst_14794 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14800_14830 = state_14798__$1;
(statearr_14800_14830[(2)] = inst_14794);

(statearr_14800_14830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (1))){
var inst_14757 = [];
var inst_14758 = inst_14757;
var inst_14759 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14798__$1 = (function (){var statearr_14801 = state_14798;
(statearr_14801[(7)] = inst_14759);

(statearr_14801[(8)] = inst_14758);

return statearr_14801;
})();
var statearr_14802_14831 = state_14798__$1;
(statearr_14802_14831[(2)] = null);

(statearr_14802_14831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (4))){
var inst_14762 = (state_14798[(9)]);
var inst_14762__$1 = (state_14798[(2)]);
var inst_14763 = (inst_14762__$1 == null);
var inst_14764 = cljs.core.not.call(null,inst_14763);
var state_14798__$1 = (function (){var statearr_14803 = state_14798;
(statearr_14803[(9)] = inst_14762__$1);

return statearr_14803;
})();
if(inst_14764){
var statearr_14804_14832 = state_14798__$1;
(statearr_14804_14832[(1)] = (5));

} else {
var statearr_14805_14833 = state_14798__$1;
(statearr_14805_14833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (15))){
var inst_14788 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14806_14834 = state_14798__$1;
(statearr_14806_14834[(2)] = inst_14788);

(statearr_14806_14834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (13))){
var state_14798__$1 = state_14798;
var statearr_14807_14835 = state_14798__$1;
(statearr_14807_14835[(2)] = null);

(statearr_14807_14835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (6))){
var inst_14758 = (state_14798[(8)]);
var inst_14783 = inst_14758.length;
var inst_14784 = (inst_14783 > (0));
var state_14798__$1 = state_14798;
if(cljs.core.truth_(inst_14784)){
var statearr_14808_14836 = state_14798__$1;
(statearr_14808_14836[(1)] = (12));

} else {
var statearr_14809_14837 = state_14798__$1;
(statearr_14809_14837[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (3))){
var inst_14796 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14798__$1,inst_14796);
} else {
if((state_val_14799 === (12))){
var inst_14758 = (state_14798[(8)]);
var inst_14786 = cljs.core.vec.call(null,inst_14758);
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14798__$1,(15),out,inst_14786);
} else {
if((state_val_14799 === (2))){
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14798__$1,(4),ch);
} else {
if((state_val_14799 === (11))){
var inst_14762 = (state_14798[(9)]);
var inst_14766 = (state_14798[(10)]);
var inst_14776 = (state_14798[(2)]);
var inst_14777 = [];
var inst_14778 = inst_14777.push(inst_14762);
var inst_14758 = inst_14777;
var inst_14759 = inst_14766;
var state_14798__$1 = (function (){var statearr_14810 = state_14798;
(statearr_14810[(7)] = inst_14759);

(statearr_14810[(11)] = inst_14776);

(statearr_14810[(12)] = inst_14778);

(statearr_14810[(8)] = inst_14758);

return statearr_14810;
})();
var statearr_14811_14838 = state_14798__$1;
(statearr_14811_14838[(2)] = null);

(statearr_14811_14838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (9))){
var inst_14758 = (state_14798[(8)]);
var inst_14774 = cljs.core.vec.call(null,inst_14758);
var state_14798__$1 = state_14798;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14798__$1,(11),out,inst_14774);
} else {
if((state_val_14799 === (5))){
var inst_14762 = (state_14798[(9)]);
var inst_14759 = (state_14798[(7)]);
var inst_14766 = (state_14798[(10)]);
var inst_14766__$1 = f.call(null,inst_14762);
var inst_14767 = cljs.core._EQ_.call(null,inst_14766__$1,inst_14759);
var inst_14768 = cljs.core.keyword_identical_QMARK_.call(null,inst_14759,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14769 = (inst_14767) || (inst_14768);
var state_14798__$1 = (function (){var statearr_14812 = state_14798;
(statearr_14812[(10)] = inst_14766__$1);

return statearr_14812;
})();
if(cljs.core.truth_(inst_14769)){
var statearr_14813_14839 = state_14798__$1;
(statearr_14813_14839[(1)] = (8));

} else {
var statearr_14814_14840 = state_14798__$1;
(statearr_14814_14840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (14))){
var inst_14791 = (state_14798[(2)]);
var inst_14792 = cljs.core.async.close_BANG_.call(null,out);
var state_14798__$1 = (function (){var statearr_14816 = state_14798;
(statearr_14816[(13)] = inst_14791);

return statearr_14816;
})();
var statearr_14817_14841 = state_14798__$1;
(statearr_14817_14841[(2)] = inst_14792);

(statearr_14817_14841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (10))){
var inst_14781 = (state_14798[(2)]);
var state_14798__$1 = state_14798;
var statearr_14818_14842 = state_14798__$1;
(statearr_14818_14842[(2)] = inst_14781);

(statearr_14818_14842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14799 === (8))){
var inst_14762 = (state_14798[(9)]);
var inst_14758 = (state_14798[(8)]);
var inst_14766 = (state_14798[(10)]);
var inst_14771 = inst_14758.push(inst_14762);
var tmp14815 = inst_14758;
var inst_14758__$1 = tmp14815;
var inst_14759 = inst_14766;
var state_14798__$1 = (function (){var statearr_14819 = state_14798;
(statearr_14819[(14)] = inst_14771);

(statearr_14819[(7)] = inst_14759);

(statearr_14819[(8)] = inst_14758__$1);

return statearr_14819;
})();
var statearr_14820_14843 = state_14798__$1;
(statearr_14820_14843[(2)] = null);

(statearr_14820_14843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14829,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14829,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14824 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14824[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14824[(1)] = (1));

return statearr_14824;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14798){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14825){if((e14825 instanceof Object)){
var ex__7651__auto__ = e14825;
var statearr_14826_14844 = state_14798;
(statearr_14826_14844[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14845 = state_14798;
state_14798 = G__14845;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14798){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14829,out))
})();
var state__7711__auto__ = (function (){var statearr_14827 = f__7710__auto__.call(null);
(statearr_14827[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14829);

return statearr_14827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14829,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
