// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('milia.utils.url');
goog.require('clojure.string');
milia.utils.remote.hosts = (function (){var G__42510 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$ui,"beta.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$j2x,"j2x.ona.io",cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__42510) : cljs.core.atom.call(null,G__42510));
})();
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol.cljs$core$IFn$_invoke$arity$1((function (){var G__42512 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__42512) : cljs.core.deref.call(null,G__42512));
})()),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((function (){var G__42514 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__42514) : cljs.core.deref.call(null,G__42514));
})()))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq42513){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42513));
});
/**
 * Build a Zebra url.
 */
milia.utils.remote.make_zebra_url = (function milia$utils$remote$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$ui.cljs$core$IFn$_invoke$arity$1((function (){var G__42516 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__42516) : cljs.core.deref.call(null,G__42516));
})()),"/"], null)),postfix);
});

milia.utils.remote.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_zebra_url.cljs$lang$applyTo = (function (seq42515){
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42515));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.constant$keyword$j2x.cljs$core$IFn$_invoke$arity$1((function (){var G__42518 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__42518) : cljs.core.deref.call(null,G__42518));
})())),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq42517){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42517));
});
