// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_(class_name,class$,i)){
return i;
} else {
var G__43050 = (i + class$.length);
start_from = G__43050;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index(class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__43055 = arguments.length;
switch (G__43055) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var classes__$1 = clojure.string.trim(cljs.core.name(classes));
if(cljs.core.seq(classes__$1)){
var temp__4124__auto___43069 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___43069)){
var class_list_43070 = temp__4124__auto___43069;
var seq__43056_43071 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__43057_43072 = null;
var count__43058_43073 = (0);
var i__43059_43074 = (0);
while(true){
if((i__43059_43074 < count__43058_43073)){
var class_43075 = chunk__43057_43072.cljs$core$IIndexed$_nth$arity$2(null,i__43059_43074);
class_list_43070.add(class_43075);

var G__43076 = seq__43056_43071;
var G__43077 = chunk__43057_43072;
var G__43078 = count__43058_43073;
var G__43079 = (i__43059_43074 + (1));
seq__43056_43071 = G__43076;
chunk__43057_43072 = G__43077;
count__43058_43073 = G__43078;
i__43059_43074 = G__43079;
continue;
} else {
var temp__4126__auto___43080 = cljs.core.seq(seq__43056_43071);
if(temp__4126__auto___43080){
var seq__43056_43081__$1 = temp__4126__auto___43080;
if(cljs.core.chunked_seq_QMARK_(seq__43056_43081__$1)){
var c__5061__auto___43082 = cljs.core.chunk_first(seq__43056_43081__$1);
var G__43083 = cljs.core.chunk_rest(seq__43056_43081__$1);
var G__43084 = c__5061__auto___43082;
var G__43085 = cljs.core.count(c__5061__auto___43082);
var G__43086 = (0);
seq__43056_43071 = G__43083;
chunk__43057_43072 = G__43084;
count__43058_43073 = G__43085;
i__43059_43074 = G__43086;
continue;
} else {
var class_43087 = cljs.core.first(seq__43056_43081__$1);
class_list_43070.add(class_43087);

var G__43088 = cljs.core.next(seq__43056_43081__$1);
var G__43089 = null;
var G__43090 = (0);
var G__43091 = (0);
seq__43056_43071 = G__43088;
chunk__43057_43072 = G__43089;
count__43058_43073 = G__43090;
i__43059_43074 = G__43091;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_43092 = elem__$1.className;
var seq__43060_43093 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__43061_43094 = null;
var count__43062_43095 = (0);
var i__43063_43096 = (0);
while(true){
if((i__43063_43096 < count__43062_43095)){
var class_43097 = chunk__43061_43094.cljs$core$IIndexed$_nth$arity$2(null,i__43063_43096);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_43092,class_43097))){
} else {
elem__$1.className = (((class_name_43092 === ""))?class_43097:[cljs.core.str(class_name_43092),cljs.core.str(" "),cljs.core.str(class_43097)].join(''));
}

var G__43098 = seq__43060_43093;
var G__43099 = chunk__43061_43094;
var G__43100 = count__43062_43095;
var G__43101 = (i__43063_43096 + (1));
seq__43060_43093 = G__43098;
chunk__43061_43094 = G__43099;
count__43062_43095 = G__43100;
i__43063_43096 = G__43101;
continue;
} else {
var temp__4126__auto___43102 = cljs.core.seq(seq__43060_43093);
if(temp__4126__auto___43102){
var seq__43060_43103__$1 = temp__4126__auto___43102;
if(cljs.core.chunked_seq_QMARK_(seq__43060_43103__$1)){
var c__5061__auto___43104 = cljs.core.chunk_first(seq__43060_43103__$1);
var G__43105 = cljs.core.chunk_rest(seq__43060_43103__$1);
var G__43106 = c__5061__auto___43104;
var G__43107 = cljs.core.count(c__5061__auto___43104);
var G__43108 = (0);
seq__43060_43093 = G__43105;
chunk__43061_43094 = G__43106;
count__43062_43095 = G__43107;
i__43063_43096 = G__43108;
continue;
} else {
var class_43109 = cljs.core.first(seq__43060_43103__$1);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_43092,class_43109))){
} else {
elem__$1.className = (((class_name_43092 === ""))?class_43109:[cljs.core.str(class_name_43092),cljs.core.str(" "),cljs.core.str(class_43109)].join(''));
}

var G__43110 = cljs.core.next(seq__43060_43103__$1);
var G__43111 = null;
var G__43112 = (0);
var G__43113 = (0);
seq__43060_43093 = G__43110;
chunk__43061_43094 = G__43111;
count__43062_43095 = G__43112;
i__43063_43096 = G__43113;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__43064_43114 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__43065_43115 = null;
var count__43066_43116 = (0);
var i__43067_43117 = (0);
while(true){
if((i__43067_43117 < count__43066_43116)){
var c_43118 = chunk__43065_43115.cljs$core$IIndexed$_nth$arity$2(null,i__43067_43117);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_43118);

var G__43119 = seq__43064_43114;
var G__43120 = chunk__43065_43115;
var G__43121 = count__43066_43116;
var G__43122 = (i__43067_43117 + (1));
seq__43064_43114 = G__43119;
chunk__43065_43115 = G__43120;
count__43066_43116 = G__43121;
i__43067_43117 = G__43122;
continue;
} else {
var temp__4126__auto___43123 = cljs.core.seq(seq__43064_43114);
if(temp__4126__auto___43123){
var seq__43064_43124__$1 = temp__4126__auto___43123;
if(cljs.core.chunked_seq_QMARK_(seq__43064_43124__$1)){
var c__5061__auto___43125 = cljs.core.chunk_first(seq__43064_43124__$1);
var G__43126 = cljs.core.chunk_rest(seq__43064_43124__$1);
var G__43127 = c__5061__auto___43125;
var G__43128 = cljs.core.count(c__5061__auto___43125);
var G__43129 = (0);
seq__43064_43114 = G__43126;
chunk__43065_43115 = G__43127;
count__43066_43116 = G__43128;
i__43067_43117 = G__43129;
continue;
} else {
var c_43130 = cljs.core.first(seq__43064_43124__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_43130);

var G__43131 = cljs.core.next(seq__43064_43124__$1);
var G__43132 = null;
var G__43133 = (0);
var G__43134 = (0);
seq__43064_43114 = G__43131;
chunk__43065_43115 = G__43132;
count__43066_43116 = G__43133;
i__43067_43117 = G__43134;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq43051){
var G__43052 = cljs.core.first(seq43051);
var seq43051__$1 = cljs.core.next(seq43051);
var G__43053 = cljs.core.first(seq43051__$1);
var seq43051__$2 = cljs.core.next(seq43051__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43052,G__43053,seq43051__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index(class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__43135 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__43135;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__43140 = arguments.length;
switch (G__43140) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___43146 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___43146)){
var class_list_43147 = temp__4124__auto___43146;
class_list_43147.remove(class$__$1);
} else {
var class_name_43148 = elem__$1.className;
var new_class_name_43149 = dommy.attrs.remove_class_str(class_name_43148,class$__$1);
if((class_name_43148 === new_class_name_43149)){
} else {
elem__$1.className = new_class_name_43149;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__43141 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__43142 = null;
var count__43143 = (0);
var i__43144 = (0);
while(true){
if((i__43144 < count__43143)){
var c = chunk__43142.cljs$core$IIndexed$_nth$arity$2(null,i__43144);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__43150 = seq__43141;
var G__43151 = chunk__43142;
var G__43152 = count__43143;
var G__43153 = (i__43144 + (1));
seq__43141 = G__43150;
chunk__43142 = G__43151;
count__43143 = G__43152;
i__43144 = G__43153;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__43141);
if(temp__4126__auto__){
var seq__43141__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43141__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__43141__$1);
var G__43154 = cljs.core.chunk_rest(seq__43141__$1);
var G__43155 = c__5061__auto__;
var G__43156 = cljs.core.count(c__5061__auto__);
var G__43157 = (0);
seq__43141 = G__43154;
chunk__43142 = G__43155;
count__43143 = G__43156;
i__43144 = G__43157;
continue;
} else {
var c = cljs.core.first(seq__43141__$1);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__43158 = cljs.core.next(seq__43141__$1);
var G__43159 = null;
var G__43160 = (0);
var G__43161 = (0);
seq__43141 = G__43158;
chunk__43142 = G__43159;
count__43143 = G__43160;
i__43144 = G__43161;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq43136){
var G__43137 = cljs.core.first(seq43136);
var seq43136__$1 = cljs.core.next(seq43136);
var G__43138 = cljs.core.first(seq43136__$1);
var seq43136__$2 = cljs.core.next(seq43136__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43137,G__43138,seq43136__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__43163 = arguments.length;
switch (G__43163) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___43165 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___43165)){
var class_list_43166 = temp__4124__auto___43165;
class_list_43166.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_(elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__43169){
var vec__43170 = p__43169;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43170,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43170,(1),null);
return [cljs.core.str(cljs.core.name(k)),cljs.core.str(":"),cljs.core.str(cljs.core.name(v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var style = elem__$1.style;
var seq__43173_43179 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__43174_43180 = null;
var count__43175_43181 = (0);
var i__43176_43182 = (0);
while(true){
if((i__43176_43182 < count__43175_43181)){
var vec__43177_43183 = chunk__43174_43180.cljs$core$IIndexed$_nth$arity$2(null,i__43176_43182);
var k_43184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43177_43183,(0),null);
var v_43185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43177_43183,(1),null);
(style[cljs.core.name(k_43184)] = v_43185);

var G__43186 = seq__43173_43179;
var G__43187 = chunk__43174_43180;
var G__43188 = count__43175_43181;
var G__43189 = (i__43176_43182 + (1));
seq__43173_43179 = G__43186;
chunk__43174_43180 = G__43187;
count__43175_43181 = G__43188;
i__43176_43182 = G__43189;
continue;
} else {
var temp__4126__auto___43190 = cljs.core.seq(seq__43173_43179);
if(temp__4126__auto___43190){
var seq__43173_43191__$1 = temp__4126__auto___43190;
if(cljs.core.chunked_seq_QMARK_(seq__43173_43191__$1)){
var c__5061__auto___43192 = cljs.core.chunk_first(seq__43173_43191__$1);
var G__43193 = cljs.core.chunk_rest(seq__43173_43191__$1);
var G__43194 = c__5061__auto___43192;
var G__43195 = cljs.core.count(c__5061__auto___43192);
var G__43196 = (0);
seq__43173_43179 = G__43193;
chunk__43174_43180 = G__43194;
count__43175_43181 = G__43195;
i__43176_43182 = G__43196;
continue;
} else {
var vec__43178_43197 = cljs.core.first(seq__43173_43191__$1);
var k_43198 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43178_43197,(0),null);
var v_43199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43178_43197,(1),null);
(style[cljs.core.name(k_43198)] = v_43199);

var G__43200 = cljs.core.next(seq__43173_43191__$1);
var G__43201 = null;
var G__43202 = (0);
var G__43203 = (0);
seq__43173_43179 = G__43200;
chunk__43174_43180 = G__43201;
count__43175_43181 = G__43202;
i__43176_43182 = G__43203;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq43171){
var G__43172 = cljs.core.first(seq43171);
var seq43171__$1 = cljs.core.next(seq43171);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43172,seq43171__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"k","k",-505765866,null)], 0)))].join('')));
}

return ((function (){var G__43205 = dommy.template.__GT_node_like(elem);
return window.getComputedStyle(G__43205);
})()[cljs.core.name(k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__43208_43214 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__43209_43215 = null;
var count__43210_43216 = (0);
var i__43211_43217 = (0);
while(true){
if((i__43211_43217 < count__43210_43216)){
var vec__43212_43218 = chunk__43209_43215.cljs$core$IIndexed$_nth$arity$2(null,i__43211_43217);
var k_43219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43212_43218,(0),null);
var v_43220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43212_43218,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_43219,[cljs.core.str(v_43220),cljs.core.str("px")].join('')], 0));

var G__43221 = seq__43208_43214;
var G__43222 = chunk__43209_43215;
var G__43223 = count__43210_43216;
var G__43224 = (i__43211_43217 + (1));
seq__43208_43214 = G__43221;
chunk__43209_43215 = G__43222;
count__43210_43216 = G__43223;
i__43211_43217 = G__43224;
continue;
} else {
var temp__4126__auto___43225 = cljs.core.seq(seq__43208_43214);
if(temp__4126__auto___43225){
var seq__43208_43226__$1 = temp__4126__auto___43225;
if(cljs.core.chunked_seq_QMARK_(seq__43208_43226__$1)){
var c__5061__auto___43227 = cljs.core.chunk_first(seq__43208_43226__$1);
var G__43228 = cljs.core.chunk_rest(seq__43208_43226__$1);
var G__43229 = c__5061__auto___43227;
var G__43230 = cljs.core.count(c__5061__auto___43227);
var G__43231 = (0);
seq__43208_43214 = G__43228;
chunk__43209_43215 = G__43229;
count__43210_43216 = G__43230;
i__43211_43217 = G__43231;
continue;
} else {
var vec__43213_43232 = cljs.core.first(seq__43208_43226__$1);
var k_43233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43213_43232,(0),null);
var v_43234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43213_43232,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_43233,[cljs.core.str(v_43234),cljs.core.str("px")].join('')], 0));

var G__43235 = cljs.core.next(seq__43208_43226__$1);
var G__43236 = null;
var G__43237 = (0);
var G__43238 = (0);
seq__43208_43214 = G__43235;
chunk__43209_43215 = G__43236;
count__43210_43216 = G__43237;
i__43211_43217 = G__43238;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq43206){
var G__43207 = cljs.core.first(seq43206);
var seq43206__$1 = cljs.core.next(seq43206);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43207,seq43206__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style(dommy.template.__GT_node_like(elem),k);
if(cljs.core.seq(pixels)){
var G__43240 = pixels;
return parseInt(G__43240);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__43246 = arguments.length;
switch (G__43246) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__43247 = dommy.template.__GT_node_like(elem);
(G__43247[cljs.core.name(k)] = v);

return G__43247;
} else {
var G__43248 = dommy.template.__GT_node_like(elem);
G__43248.setAttribute(cljs.core.name(k),(((k === cljs.core.constant$keyword$style))?dommy.attrs.style_str(v):v));

return G__43248;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__43249_43256 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__43250_43257 = null;
var count__43251_43258 = (0);
var i__43252_43259 = (0);
while(true){
if((i__43252_43259 < count__43251_43258)){
var vec__43253_43260 = chunk__43250_43257.cljs$core$IIndexed$_nth$arity$2(null,i__43252_43259);
var k_43261__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43253_43260,(0),null);
var v_43262__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43253_43260,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_43261__$1,v_43262__$1);

var G__43263 = seq__43249_43256;
var G__43264 = chunk__43250_43257;
var G__43265 = count__43251_43258;
var G__43266 = (i__43252_43259 + (1));
seq__43249_43256 = G__43263;
chunk__43250_43257 = G__43264;
count__43251_43258 = G__43265;
i__43252_43259 = G__43266;
continue;
} else {
var temp__4126__auto___43267 = cljs.core.seq(seq__43249_43256);
if(temp__4126__auto___43267){
var seq__43249_43268__$1 = temp__4126__auto___43267;
if(cljs.core.chunked_seq_QMARK_(seq__43249_43268__$1)){
var c__5061__auto___43269 = cljs.core.chunk_first(seq__43249_43268__$1);
var G__43270 = cljs.core.chunk_rest(seq__43249_43268__$1);
var G__43271 = c__5061__auto___43269;
var G__43272 = cljs.core.count(c__5061__auto___43269);
var G__43273 = (0);
seq__43249_43256 = G__43270;
chunk__43250_43257 = G__43271;
count__43251_43258 = G__43272;
i__43252_43259 = G__43273;
continue;
} else {
var vec__43254_43274 = cljs.core.first(seq__43249_43268__$1);
var k_43275__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43254_43274,(0),null);
var v_43276__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43254_43274,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_43275__$1,v_43276__$1);

var G__43277 = cljs.core.next(seq__43249_43268__$1);
var G__43278 = null;
var G__43279 = (0);
var G__43280 = (0);
seq__43249_43256 = G__43277;
chunk__43250_43257 = G__43278;
count__43251_43258 = G__43279;
i__43252_43259 = G__43280;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq43241){
var G__43242 = cljs.core.first(seq43241);
var seq43241__$1 = cljs.core.next(seq43241);
var G__43243 = cljs.core.first(seq43241__$1);
var seq43241__$2 = cljs.core.next(seq43241__$1);
var G__43244 = cljs.core.first(seq43241__$2);
var seq43241__$3 = cljs.core.next(seq43241__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43242,G__43243,G__43244,seq43241__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__43285 = arguments.length;
switch (G__43285) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$class,null,cljs.core.constant$keyword$classes,null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name(k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__43286_43291 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__43287_43292 = null;
var count__43288_43293 = (0);
var i__43289_43294 = (0);
while(true){
if((i__43289_43294 < count__43288_43293)){
var k_43295__$1 = chunk__43287_43292.cljs$core$IIndexed$_nth$arity$2(null,i__43289_43294);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_43295__$1);

var G__43296 = seq__43286_43291;
var G__43297 = chunk__43287_43292;
var G__43298 = count__43288_43293;
var G__43299 = (i__43289_43294 + (1));
seq__43286_43291 = G__43296;
chunk__43287_43292 = G__43297;
count__43288_43293 = G__43298;
i__43289_43294 = G__43299;
continue;
} else {
var temp__4126__auto___43300 = cljs.core.seq(seq__43286_43291);
if(temp__4126__auto___43300){
var seq__43286_43301__$1 = temp__4126__auto___43300;
if(cljs.core.chunked_seq_QMARK_(seq__43286_43301__$1)){
var c__5061__auto___43302 = cljs.core.chunk_first(seq__43286_43301__$1);
var G__43303 = cljs.core.chunk_rest(seq__43286_43301__$1);
var G__43304 = c__5061__auto___43302;
var G__43305 = cljs.core.count(c__5061__auto___43302);
var G__43306 = (0);
seq__43286_43291 = G__43303;
chunk__43287_43292 = G__43304;
count__43288_43293 = G__43305;
i__43289_43294 = G__43306;
continue;
} else {
var k_43307__$1 = cljs.core.first(seq__43286_43301__$1);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_43307__$1);

var G__43308 = cljs.core.next(seq__43286_43301__$1);
var G__43309 = null;
var G__43310 = (0);
var G__43311 = (0);
seq__43286_43291 = G__43308;
chunk__43287_43292 = G__43309;
count__43288_43293 = G__43310;
i__43289_43294 = G__43311;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq43281){
var G__43282 = cljs.core.first(seq43281);
var seq43281__$1 = cljs.core.next(seq43281);
var G__43283 = cljs.core.first(seq43281__$1);
var seq43281__$2 = cljs.core.next(seq43281__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43282,G__43283,seq43281__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like(elem).getAttribute(cljs.core.name(k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__43313 = arguments.length;
switch (G__43313) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.attrs.attr(elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like(elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__43316 = arguments.length;
switch (G__43316) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__43317 = dommy.template.__GT_node_like(elem);
G__43317.style.display = ((show_QMARK_)?"":"none");

return G__43317;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,dommy.attrs.hidden_QMARK_(elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__43320 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__43320,false);

return G__43320;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__43322 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__43322,true);

return G__43322;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__43324 = dommy.template.__GT_node_like(elem).getBoundingClientRect();
(G__43324["constructor"] = Object);

return G__43324;
})(),cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0));
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
var top = cljs.core.constant$keyword$top.cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect(elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
