// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('goog.math.Long');
goog.require('com.cognitect.transit.eq');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv(other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__43520 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__43520) : com.cognitect.transit.eq.hashCode.call(null,G__43520));
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__43521 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__43521) : com.cognitect.transit.eq.hashCode.call(null,G__43521));
});

goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__43522 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__43522) : com.cognitect.transit.eq.hashCode.call(null,G__43522));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__43527_43531 = cljs.core.seq(cljs.core.js_keys(b));
var chunk__43528_43532 = null;
var count__43529_43533 = (0);
var i__43530_43534 = (0);
while(true){
if((i__43530_43534 < count__43529_43533)){
var k_43535 = chunk__43528_43532.cljs$core$IIndexed$_nth$arity$2(null,i__43530_43534);
var v_43536 = (b[k_43535]);
(a[k_43535] = v_43536);

var G__43537 = seq__43527_43531;
var G__43538 = chunk__43528_43532;
var G__43539 = count__43529_43533;
var G__43540 = (i__43530_43534 + (1));
seq__43527_43531 = G__43537;
chunk__43528_43532 = G__43538;
count__43529_43533 = G__43539;
i__43530_43534 = G__43540;
continue;
} else {
var temp__4126__auto___43541 = cljs.core.seq(seq__43527_43531);
if(temp__4126__auto___43541){
var seq__43527_43542__$1 = temp__4126__auto___43541;
if(cljs.core.chunked_seq_QMARK_(seq__43527_43542__$1)){
var c__5061__auto___43543 = cljs.core.chunk_first(seq__43527_43542__$1);
var G__43544 = cljs.core.chunk_rest(seq__43527_43542__$1);
var G__43545 = c__5061__auto___43543;
var G__43546 = cljs.core.count(c__5061__auto___43543);
var G__43547 = (0);
seq__43527_43531 = G__43544;
chunk__43528_43532 = G__43545;
count__43529_43533 = G__43546;
i__43530_43534 = G__43547;
continue;
} else {
var k_43548 = cljs.core.first(seq__43527_43542__$1);
var v_43549 = (b[k_43548]);
(a[k_43548] = v_43549);

var G__43550 = cljs.core.next(seq__43527_43542__$1);
var G__43551 = null;
var G__43552 = (0);
var G__43553 = (0);
seq__43527_43531 = G__43550;
chunk__43528_43532 = G__43551;
count__43529_43533 = G__43552;
i__43530_43534 = G__43553;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__43554 = arr;
var G__43555 = true;
var G__43556 = true;
return (cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3 ? cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3(G__43554,G__43555,G__43556) : cljs.core.PersistentArrayMap.fromArray.call(null,G__43554,G__43555,G__43556));
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__43557 = arr;
var G__43558 = true;
return (cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2 ? cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2(G__43557,G__43558) : cljs.core.PersistentVector.fromArray.call(null,G__43557,G__43558));
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var G__43560 = arguments.length;
switch (G__43560) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var G__43561 = cljs.core.name(type);
var G__43562 = cognitect.transit.opts_merge({"prefersStrings": false, "arrayBuilder": (new cognitect.transit.VectorBuilder()), "mapBuilder": (new cognitect.transit.MapBuilder()), "handlers": cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 5, ["$",((function (G__43561){
return (function (v){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(v);
});})(G__43561))
,":",((function (G__43561){
return (function (v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(G__43561))
,"set",((function (G__43561){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,v);
});})(G__43561))
,"list",((function (G__43561){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.List.EMPTY,v.reverse());
});})(G__43561))
,"cmap",((function (G__43561){
return (function (v){
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__43564 = (i + (2));
var G__43565 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,(v[i]),(v[(i + (1))]));
i = G__43564;
ret = G__43565;
continue;
} else {
return cljs.core.persistent_BANG_(ret);
}
break;
}
});})(G__43561))
], null),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0)))},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(G__43561,G__43562) : com.cognitect.transit.reader.call(null,G__43561,G__43562));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__43566_43572 = cljs.core.seq(v);
var chunk__43567_43573 = null;
var count__43568_43574 = (0);
var i__43569_43575 = (0);
while(true){
if((i__43569_43575 < count__43568_43574)){
var x_43576 = chunk__43567_43573.cljs$core$IIndexed$_nth$arity$2(null,i__43569_43575);
ret.push(x_43576);

var G__43577 = seq__43566_43572;
var G__43578 = chunk__43567_43573;
var G__43579 = count__43568_43574;
var G__43580 = (i__43569_43575 + (1));
seq__43566_43572 = G__43577;
chunk__43567_43573 = G__43578;
count__43568_43574 = G__43579;
i__43569_43575 = G__43580;
continue;
} else {
var temp__4126__auto___43581 = cljs.core.seq(seq__43566_43572);
if(temp__4126__auto___43581){
var seq__43566_43582__$1 = temp__4126__auto___43581;
if(cljs.core.chunked_seq_QMARK_(seq__43566_43582__$1)){
var c__5061__auto___43583 = cljs.core.chunk_first(seq__43566_43582__$1);
var G__43584 = cljs.core.chunk_rest(seq__43566_43582__$1);
var G__43585 = c__5061__auto___43583;
var G__43586 = cljs.core.count(c__5061__auto___43583);
var G__43587 = (0);
seq__43566_43572 = G__43584;
chunk__43567_43573 = G__43585;
count__43568_43574 = G__43586;
i__43569_43575 = G__43587;
continue;
} else {
var x_43588 = cljs.core.first(seq__43566_43582__$1);
ret.push(x_43588);

var G__43589 = cljs.core.next(seq__43566_43582__$1);
var G__43590 = null;
var G__43591 = (0);
var G__43592 = (0);
seq__43566_43572 = G__43589;
chunk__43567_43573 = G__43590;
count__43568_43574 = G__43591;
i__43569_43575 = G__43592;
continue;
}
} else {
}
}
break;
}

var G__43570 = "array";
var G__43571 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__43570,G__43571) : com.cognitect.transit.tagged.call(null,G__43570,G__43571));
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__43593_43599 = cljs.core.seq(v);
var chunk__43594_43600 = null;
var count__43595_43601 = (0);
var i__43596_43602 = (0);
while(true){
if((i__43596_43602 < count__43595_43601)){
var x_43603 = chunk__43594_43600.cljs$core$IIndexed$_nth$arity$2(null,i__43596_43602);
ret.push(x_43603);

var G__43604 = seq__43593_43599;
var G__43605 = chunk__43594_43600;
var G__43606 = count__43595_43601;
var G__43607 = (i__43596_43602 + (1));
seq__43593_43599 = G__43604;
chunk__43594_43600 = G__43605;
count__43595_43601 = G__43606;
i__43596_43602 = G__43607;
continue;
} else {
var temp__4126__auto___43608 = cljs.core.seq(seq__43593_43599);
if(temp__4126__auto___43608){
var seq__43593_43609__$1 = temp__4126__auto___43608;
if(cljs.core.chunked_seq_QMARK_(seq__43593_43609__$1)){
var c__5061__auto___43610 = cljs.core.chunk_first(seq__43593_43609__$1);
var G__43611 = cljs.core.chunk_rest(seq__43593_43609__$1);
var G__43612 = c__5061__auto___43610;
var G__43613 = cljs.core.count(c__5061__auto___43610);
var G__43614 = (0);
seq__43593_43599 = G__43611;
chunk__43594_43600 = G__43612;
count__43595_43601 = G__43613;
i__43596_43602 = G__43614;
continue;
} else {
var x_43615 = cljs.core.first(seq__43593_43609__$1);
ret.push(x_43615);

var G__43616 = cljs.core.next(seq__43593_43609__$1);
var G__43617 = null;
var G__43618 = (0);
var G__43619 = (0);
seq__43593_43599 = G__43616;
chunk__43594_43600 = G__43617;
count__43595_43601 = G__43618;
i__43596_43602 = G__43619;
continue;
}
} else {
}
}
break;
}

var G__43597 = "array";
var G__43598 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__43597,G__43598) : com.cognitect.transit.tagged.call(null,G__43597,G__43598));
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__43620_43624 = cljs.core.seq(v);
var chunk__43621_43625 = null;
var count__43622_43626 = (0);
var i__43623_43627 = (0);
while(true){
if((i__43623_43627 < count__43622_43626)){
var x_43628 = chunk__43621_43625.cljs$core$IIndexed$_nth$arity$2(null,i__43623_43627);
ret.push(x_43628);

var G__43629 = seq__43620_43624;
var G__43630 = chunk__43621_43625;
var G__43631 = count__43622_43626;
var G__43632 = (i__43623_43627 + (1));
seq__43620_43624 = G__43629;
chunk__43621_43625 = G__43630;
count__43622_43626 = G__43631;
i__43623_43627 = G__43632;
continue;
} else {
var temp__4126__auto___43633 = cljs.core.seq(seq__43620_43624);
if(temp__4126__auto___43633){
var seq__43620_43634__$1 = temp__4126__auto___43633;
if(cljs.core.chunked_seq_QMARK_(seq__43620_43634__$1)){
var c__5061__auto___43635 = cljs.core.chunk_first(seq__43620_43634__$1);
var G__43636 = cljs.core.chunk_rest(seq__43620_43634__$1);
var G__43637 = c__5061__auto___43635;
var G__43638 = cljs.core.count(c__5061__auto___43635);
var G__43639 = (0);
seq__43620_43624 = G__43636;
chunk__43621_43625 = G__43637;
count__43622_43626 = G__43638;
i__43623_43627 = G__43639;
continue;
} else {
var x_43640 = cljs.core.first(seq__43620_43634__$1);
ret.push(x_43640);

var G__43641 = cljs.core.next(seq__43620_43634__$1);
var G__43642 = null;
var G__43643 = (0);
var G__43644 = (0);
seq__43620_43624 = G__43641;
chunk__43621_43625 = G__43642;
count__43622_43626 = G__43643;
i__43623_43627 = G__43644;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a JavaScript
 * array of interleaved type constructors and handler instances for those
 * type constructors.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var G__43646 = arguments.length;
switch (G__43646) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0));
var G__43647 = cljs.core.name(type);
var G__43648 = cognitect.transit.opts_merge({"unpack": ((function (G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x43652 = cljs.core.clone(handlers);
x43652.forEach = ((function (x43652,G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__43653 = cljs.core.seq(coll);
var chunk__43654 = null;
var count__43655 = (0);
var i__43656 = (0);
while(true){
if((i__43656 < count__43655)){
var vec__43657 = chunk__43654.cljs$core$IIndexed$_nth$arity$2(null,i__43656);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43657,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43657,(1),null);
var G__43658_43664 = v;
var G__43659_43665 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43658_43664,G__43659_43665) : f.call(null,G__43658_43664,G__43659_43665));

var G__43666 = seq__43653;
var G__43667 = chunk__43654;
var G__43668 = count__43655;
var G__43669 = (i__43656 + (1));
seq__43653 = G__43666;
chunk__43654 = G__43667;
count__43655 = G__43668;
i__43656 = G__43669;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__43653);
if(temp__4126__auto__){
var seq__43653__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43653__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__43653__$1);
var G__43670 = cljs.core.chunk_rest(seq__43653__$1);
var G__43671 = c__5061__auto__;
var G__43672 = cljs.core.count(c__5061__auto__);
var G__43673 = (0);
seq__43653 = G__43670;
chunk__43654 = G__43671;
count__43655 = G__43672;
i__43656 = G__43673;
continue;
} else {
var vec__43660 = cljs.core.first(seq__43653__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43660,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43660,(1),null);
var G__43661_43674 = v;
var G__43662_43675 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43661_43674,G__43662_43675) : f.call(null,G__43661_43674,G__43662_43675));

var G__43676 = cljs.core.next(seq__43653__$1);
var G__43677 = null;
var G__43678 = (0);
var G__43679 = (0);
seq__43653 = G__43676;
chunk__43654 = G__43677;
count__43655 = G__43678;
i__43656 = G__43679;
continue;
}
} else {
return null;
}
}
break;
}
});})(x43652,G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x43652;
})(), "objectBuilder": ((function (G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv(((function (G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__43649 = obj;
G__43649.push((function (){var G__43650 = k;
return (kfn.cljs$core$IFn$_invoke$arity$1 ? kfn.cljs$core$IFn$_invoke$arity$1(G__43650) : kfn.call(null,G__43650));
})(),(function (){var G__43651 = v;
return (vfn.cljs$core$IFn$_invoke$arity$1 ? vfn.cljs$core$IFn$_invoke$arity$1(G__43651) : vfn.call(null,G__43651));
})());

return G__43649;
});})(G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(G__43647,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(G__43647,G__43648) : com.cognitect.transit.writer.call(null,G__43647,G__43648));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var G__43681 = arguments.length;
switch (G__43681) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t43682 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t43682 = (function (verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,meta43683){
this.verbose_handler_fn = verbose_handler_fn;
this.str_rep_fn = str_rep_fn;
this.rep_fn = rep_fn;
this.tag_fn = tag_fn;
this.meta43683 = meta43683;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cognitect.transit.t43682.prototype.tag = (function (o){
var self__ = this;
var _ = this;
var G__43685 = o;
return (self__.tag_fn.cljs$core$IFn$_invoke$arity$1 ? self__.tag_fn.cljs$core$IFn$_invoke$arity$1(G__43685) : self__.tag_fn.call(null,G__43685));
});

cognitect.transit.t43682.prototype.rep = (function (o){
var self__ = this;
var _ = this;
var G__43686 = o;
return (self__.rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.rep_fn.cljs$core$IFn$_invoke$arity$1(G__43686) : self__.rep_fn.call(null,G__43686));
});

cognitect.transit.t43682.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
var G__43687 = o;
return (self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1(G__43687) : self__.str_rep_fn.call(null,G__43687));
} else {
return null;
}
});

cognitect.transit.t43682.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return (self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0 ? self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0() : self__.verbose_handler_fn.call(null));
} else {
return null;
}
});

cognitect.transit.t43682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43684){
var self__ = this;
var _43684__$1 = this;
return self__.meta43683;
});

cognitect.transit.t43682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43684,meta43683__$1){
var self__ = this;
var _43684__$1 = this;
return (new cognitect.transit.t43682(self__.verbose_handler_fn,self__.str_rep_fn,self__.rep_fn,self__.tag_fn,meta43683__$1));
});

cognitect.transit.t43682.cljs$lang$type = true;

cognitect.transit.t43682.cljs$lang$ctorStr = "cognitect.transit/t43682";

cognitect.transit.t43682.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/t43682");
});

cognitect.transit.__GT_t43682 = (function cognitect$transit$__GT_t43682(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta43683){
return (new cognitect.transit.t43682(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta43683));
});

}

return (new cognitect.transit.t43682(verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
var G__43691 = tag;
var G__43692 = rep;
return (com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2(G__43691,G__43692) : com.cognitect.transit.types.taggedValue.call(null,G__43691,G__43692));
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
var G__43694 = x;
return (com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1(G__43694) : com.cognitect.transit.types.isTaggedValue.call(null,G__43694));
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
var G__43696 = s;
return (com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1(G__43696) : com.cognitect.transit.types.integer.call(null,G__43696));
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
var G__43698 = x;
return (com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1(G__43698) : com.cognitect.transit.types.isInteger.call(null,G__43698));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
var G__43700 = s;
return (com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1(G__43700) : com.cognitect.transit.types.bigInteger.call(null,G__43700));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
var G__43702 = x;
return (com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1(G__43702) : com.cognitect.transit.types.isBigInteger.call(null,G__43702));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
var G__43704 = s;
return (com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1(G__43704) : com.cognitect.transit.types.bigDecimalValue.call(null,G__43704));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
var G__43706 = x;
return (com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1(G__43706) : com.cognitect.transit.types.isBigDecimal.call(null,G__43706));
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
var G__43708 = s;
return (com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1(G__43708) : com.cognitect.transit.types.uri.call(null,G__43708));
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
var G__43710 = x;
return (com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1(G__43710) : com.cognitect.transit.types.isURI.call(null,G__43710));
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
var G__43712 = s;
return (com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1(G__43712) : com.cognitect.transit.types.uuid.call(null,G__43712));
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var G__43714 = x;
return (com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1(G__43714) : com.cognitect.transit.types.isUUID.call(null,G__43714));
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
var G__43716 = s;
return (com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1(G__43716) : com.cognitect.transit.types.binary.call(null,G__43716));
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
var G__43718 = x;
return (com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1(G__43718) : com.cognitect.transit.types.isBinary.call(null,G__43718));
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
var G__43720 = x;
return (com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1(G__43720) : com.cognitect.transit.types.quoted.call(null,G__43720));
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
var G__43722 = x;
return (com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1(G__43722) : com.cognitect.transit.types.isQuoted.call(null,G__43722));
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
var G__43724 = x;
return (com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1(G__43724) : com.cognitect.transit.types.link.call(null,G__43724));
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
var G__43726 = x;
return (com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1(G__43726) : com.cognitect.transit.types.isLink.call(null,G__43726));
});
