// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t44360 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t44360 = (function (f,fn_handler,meta44361){
this.f = f;
this.fn_handler = fn_handler;
this.meta44361 = meta44361;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t44360.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t44360.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t44360.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t44360.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44362){
var self__ = this;
var _44362__$1 = this;
return self__.meta44361;
});

cljs.core.async.t44360.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44362,meta44361__$1){
var self__ = this;
var _44362__$1 = this;
return (new cljs.core.async.t44360(self__.f,self__.fn_handler,meta44361__$1));
});

cljs.core.async.t44360.cljs$lang$type = true;

cljs.core.async.t44360.cljs$lang$ctorStr = "cljs.core.async/t44360";

cljs.core.async.t44360.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t44360");
});

cljs.core.async.__GT_t44360 = (function cljs$core$async$fn_handler_$___GT_t44360(f__$1,fn_handler__$1,meta44361){
return (new cljs.core.async.t44360(f__$1,fn_handler__$1,meta44361));
});

}

return (new cljs.core.async.t44360(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__44364 = buff;
if(G__44364){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__44364.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__44364.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__44364);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__44364);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__44366 = arguments.length;
switch (G__44366) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__44369 = arguments.length;
switch (G__44369) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_44374 = (function (){var G__44370 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__44370) : cljs.core.deref.call(null,G__44370));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__44371_44375 = val_44374;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__44371_44375) : fn1.call(null,G__44371_44375));
} else {
cljs.core.async.impl.dispatch.run(((function (val_44374,ret){
return (function (){
var G__44372 = val_44374;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__44372) : fn1.call(null,G__44372));
});})(val_44374,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__44377 = arguments.length;
switch (G__44377) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
var G__44378 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__44378) : cljs.core.deref.call(null,G__44378));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = (function (){var G__44379 = retb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__44379) : cljs.core.deref.call(null,G__44379));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__44380_44383 = ret;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__44380_44383) : fn1.call(null,G__44380_44383));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4124__auto__){
return (function (){
var G__44381 = ret;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__44381) : fn1.call(null,G__44381));
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___44384 = n;
var x_44385 = (0);
while(true){
if((x_44385 < n__5161__auto___44384)){
(a[x_44385] = (0));

var G__44386 = (x_44385 + (1));
x_44385 = G__44386;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__44387 = (i + (1));
i = G__44387;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (function (){var G__44395 = true;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__44395) : cljs.core.atom.call(null,G__44395));
})();
if(typeof cljs.core.async.t44396 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t44396 = (function (flag,alt_flag,meta44397){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta44397 = meta44397;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t44396.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t44396.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__44399 = self__.flag;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__44399) : cljs.core.deref.call(null,G__44399));
});})(flag))
;

cljs.core.async.t44396.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__44400_44402 = self__.flag;
var G__44401_44403 = null;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__44400_44402,G__44401_44403) : cljs.core.reset_BANG_.call(null,G__44400_44402,G__44401_44403));

return true;
});})(flag))
;

cljs.core.async.t44396.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_44398){
var self__ = this;
var _44398__$1 = this;
return self__.meta44397;
});})(flag))
;

cljs.core.async.t44396.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_44398,meta44397__$1){
var self__ = this;
var _44398__$1 = this;
return (new cljs.core.async.t44396(self__.flag,self__.alt_flag,meta44397__$1));
});})(flag))
;

cljs.core.async.t44396.cljs$lang$type = true;

cljs.core.async.t44396.cljs$lang$ctorStr = "cljs.core.async/t44396";

cljs.core.async.t44396.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t44396");
});})(flag))
;

cljs.core.async.__GT_t44396 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t44396(flag__$1,alt_flag__$1,meta44397){
return (new cljs.core.async.t44396(flag__$1,alt_flag__$1,meta44397));
});})(flag))
;

}

return (new cljs.core.async.t44396(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t44407 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t44407 = (function (cb,flag,alt_handler,meta44408){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta44408 = meta44408;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t44407.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t44407.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t44407.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t44407.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44409){
var self__ = this;
var _44409__$1 = this;
return self__.meta44408;
});

cljs.core.async.t44407.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44409,meta44408__$1){
var self__ = this;
var _44409__$1 = this;
return (new cljs.core.async.t44407(self__.cb,self__.flag,self__.alt_handler,meta44408__$1));
});

cljs.core.async.t44407.cljs$lang$type = true;

cljs.core.async.t44407.cljs$lang$ctorStr = "cljs.core.async/t44407";

cljs.core.async.t44407.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t44407");
});

cljs.core.async.__GT_t44407 = (function cljs$core$async$alt_handler_$___GT_t44407(cb__$1,flag__$1,alt_handler__$1,meta44408){
return (new cljs.core.async.t44407(cb__$1,flag__$1,alt_handler__$1,meta44408));
});

}

return (new cljs.core.async.t44407(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(function (){var G__44417 = (0);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__44417) : port.call(null,G__44417));
})():null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (function (){var G__44418 = (1);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__44418) : port.call(null,G__44418));
})();
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44410_SHARP_){
var G__44419 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44410_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44419) : fret.call(null,G__44419));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44411_SHARP_){
var G__44420 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44411_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44420) : fret.call(null,G__44420));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__44421 = vbox;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__44421) : cljs.core.deref.call(null,G__44421));
})(),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__44422 = (i + (1));
i = G__44422;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44425){
var map__44426 = p__44425;
var map__44426__$1 = ((cljs.core.seq_QMARK_(map__44426))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44426):map__44426);
var opts = map__44426__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44423){
var G__44424 = cljs.core.first(seq44423);
var seq44423__$1 = cljs.core.next(seq44423);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__44424,seq44423__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__44428 = arguments.length;
switch (G__44428) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___44477 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44477){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44477){
return (function (state_44452){
var state_val_44453 = (state_44452[(1)]);
if((state_val_44453 === (7))){
var inst_44448 = (state_44452[(2)]);
var state_44452__$1 = state_44452;
var statearr_44454_44478 = state_44452__$1;
(statearr_44454_44478[(2)] = inst_44448);

(statearr_44454_44478[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (1))){
var state_44452__$1 = state_44452;
var statearr_44455_44479 = state_44452__$1;
(statearr_44455_44479[(2)] = null);

(statearr_44455_44479[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (4))){
var inst_44431 = (state_44452[(7)]);
var inst_44431__$1 = (state_44452[(2)]);
var inst_44432 = (inst_44431__$1 == null);
var state_44452__$1 = (function (){var statearr_44456 = state_44452;
(statearr_44456[(7)] = inst_44431__$1);

return statearr_44456;
})();
if(cljs.core.truth_(inst_44432)){
var statearr_44457_44480 = state_44452__$1;
(statearr_44457_44480[(1)] = (5));

} else {
var statearr_44458_44481 = state_44452__$1;
(statearr_44458_44481[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (13))){
var state_44452__$1 = state_44452;
var statearr_44459_44482 = state_44452__$1;
(statearr_44459_44482[(2)] = null);

(statearr_44459_44482[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (6))){
var inst_44431 = (state_44452[(7)]);
var state_44452__$1 = state_44452;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44452__$1,(11),to,inst_44431);
} else {
if((state_val_44453 === (3))){
var inst_44450 = (state_44452[(2)]);
var state_44452__$1 = state_44452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44452__$1,inst_44450);
} else {
if((state_val_44453 === (12))){
var state_44452__$1 = state_44452;
var statearr_44460_44483 = state_44452__$1;
(statearr_44460_44483[(2)] = null);

(statearr_44460_44483[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (2))){
var state_44452__$1 = state_44452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44452__$1,(4),from);
} else {
if((state_val_44453 === (11))){
var inst_44441 = (state_44452[(2)]);
var state_44452__$1 = state_44452;
if(cljs.core.truth_(inst_44441)){
var statearr_44461_44484 = state_44452__$1;
(statearr_44461_44484[(1)] = (12));

} else {
var statearr_44462_44485 = state_44452__$1;
(statearr_44462_44485[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (9))){
var state_44452__$1 = state_44452;
var statearr_44463_44486 = state_44452__$1;
(statearr_44463_44486[(2)] = null);

(statearr_44463_44486[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (5))){
var state_44452__$1 = state_44452;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44464_44487 = state_44452__$1;
(statearr_44464_44487[(1)] = (8));

} else {
var statearr_44465_44488 = state_44452__$1;
(statearr_44465_44488[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (14))){
var inst_44446 = (state_44452[(2)]);
var state_44452__$1 = state_44452;
var statearr_44466_44489 = state_44452__$1;
(statearr_44466_44489[(2)] = inst_44446);

(statearr_44466_44489[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (10))){
var inst_44438 = (state_44452[(2)]);
var state_44452__$1 = state_44452;
var statearr_44467_44490 = state_44452__$1;
(statearr_44467_44490[(2)] = inst_44438);

(statearr_44467_44490[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44453 === (8))){
var inst_44435 = cljs.core.async.close_BANG_(to);
var state_44452__$1 = state_44452;
var statearr_44468_44491 = state_44452__$1;
(statearr_44468_44491[(2)] = inst_44435);

(statearr_44468_44491[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___44477))
;
return ((function (switch__7647__auto__,c__7709__auto___44477){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_44472 = [null,null,null,null,null,null,null,null];
(statearr_44472[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_44472[(1)] = (1));

return statearr_44472;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_44452){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44452);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44473){if((e44473 instanceof Object)){
var ex__7651__auto__ = e44473;
var statearr_44474_44492 = state_44452;
(statearr_44474_44492[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44452);

return cljs.core.constant$keyword$recur;
} else {
throw e44473;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44493 = state_44452;
state_44452 = G__44493;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_44452){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_44452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44477))
})();
var state__7711__auto__ = (function (){var statearr_44475 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44475[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44477);

return statearr_44475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44477))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__44679){
var vec__44680 = p__44679;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44680,(1),null);
var job = vec__44680;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__7709__auto___44864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results){
return (function (state_44685){
var state_val_44686 = (state_44685[(1)]);
if((state_val_44686 === (2))){
var inst_44682 = (state_44685[(2)]);
var inst_44683 = cljs.core.async.close_BANG_(res);
var state_44685__$1 = (function (){var statearr_44687 = state_44685;
(statearr_44687[(7)] = inst_44682);

return statearr_44687;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44685__$1,inst_44683);
} else {
if((state_val_44686 === (1))){
var state_44685__$1 = state_44685;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44685__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_44691 = [null,null,null,null,null,null,null,null];
(statearr_44691[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_44691[(1)] = (1));

return statearr_44691;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_44685){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44685);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44692){if((e44692 instanceof Object)){
var ex__7651__auto__ = e44692;
var statearr_44693_44865 = state_44685;
(statearr_44693_44865[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44685);

return cljs.core.constant$keyword$recur;
} else {
throw e44692;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44866 = state_44685;
state_44685 = G__44866;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_44685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_44685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_44694 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44694[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44864);

return statearr_44694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44864,res,vec__44680,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__44695){
var vec__44696 = p__44695;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44696,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44696,(1),null);
var job = vec__44696;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var G__44697_44867 = v;
var G__44698_44868 = res;
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(G__44697_44867,G__44698_44868) : xf.call(null,G__44697_44867,G__44698_44868));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___44869 = n;
var __44870 = (0);
while(true){
if((__44870 < n__5161__auto___44869)){
var G__44699_44871 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__44699_44871) {
case "async":
var c__7709__auto___44873 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__44870,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__44870,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function (state_44712){
var state_val_44713 = (state_44712[(1)]);
if((state_val_44713 === (7))){
var inst_44708 = (state_44712[(2)]);
var state_44712__$1 = state_44712;
var statearr_44714_44874 = state_44712__$1;
(statearr_44714_44874[(2)] = inst_44708);

(statearr_44714_44874[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44713 === (6))){
var state_44712__$1 = state_44712;
var statearr_44715_44875 = state_44712__$1;
(statearr_44715_44875[(2)] = null);

(statearr_44715_44875[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44713 === (5))){
var state_44712__$1 = state_44712;
var statearr_44716_44876 = state_44712__$1;
(statearr_44716_44876[(2)] = null);

(statearr_44716_44876[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44713 === (4))){
var inst_44702 = (state_44712[(2)]);
var inst_44703 = async(inst_44702);
var state_44712__$1 = state_44712;
if(cljs.core.truth_(inst_44703)){
var statearr_44717_44877 = state_44712__$1;
(statearr_44717_44877[(1)] = (5));

} else {
var statearr_44718_44878 = state_44712__$1;
(statearr_44718_44878[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44713 === (3))){
var inst_44710 = (state_44712[(2)]);
var state_44712__$1 = state_44712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44712__$1,inst_44710);
} else {
if((state_val_44713 === (2))){
var state_44712__$1 = state_44712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44712__$1,(4),jobs);
} else {
if((state_val_44713 === (1))){
var state_44712__$1 = state_44712;
var statearr_44719_44879 = state_44712__$1;
(statearr_44719_44879[(2)] = null);

(statearr_44719_44879[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__44870,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
;
return ((function (__44870,switch__7647__auto__,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_44723 = [null,null,null,null,null,null,null];
(statearr_44723[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_44723[(1)] = (1));

return statearr_44723;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_44712){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44712);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44724){if((e44724 instanceof Object)){
var ex__7651__auto__ = e44724;
var statearr_44725_44880 = state_44712;
(statearr_44725_44880[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44712);

return cljs.core.constant$keyword$recur;
} else {
throw e44724;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44881 = state_44712;
state_44712 = G__44881;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_44712){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_44712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__44870,switch__7647__auto__,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_44726 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44726[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44873);

return statearr_44726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(__44870,c__7709__auto___44873,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___44882 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__44870,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__44870,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function (state_44739){
var state_val_44740 = (state_44739[(1)]);
if((state_val_44740 === (7))){
var inst_44735 = (state_44739[(2)]);
var state_44739__$1 = state_44739;
var statearr_44741_44883 = state_44739__$1;
(statearr_44741_44883[(2)] = inst_44735);

(statearr_44741_44883[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44740 === (6))){
var state_44739__$1 = state_44739;
var statearr_44742_44884 = state_44739__$1;
(statearr_44742_44884[(2)] = null);

(statearr_44742_44884[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44740 === (5))){
var state_44739__$1 = state_44739;
var statearr_44743_44885 = state_44739__$1;
(statearr_44743_44885[(2)] = null);

(statearr_44743_44885[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44740 === (4))){
var inst_44729 = (state_44739[(2)]);
var inst_44730 = process(inst_44729);
var state_44739__$1 = state_44739;
if(cljs.core.truth_(inst_44730)){
var statearr_44744_44886 = state_44739__$1;
(statearr_44744_44886[(1)] = (5));

} else {
var statearr_44745_44887 = state_44739__$1;
(statearr_44745_44887[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44740 === (3))){
var inst_44737 = (state_44739[(2)]);
var state_44739__$1 = state_44739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44739__$1,inst_44737);
} else {
if((state_val_44740 === (2))){
var state_44739__$1 = state_44739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44739__$1,(4),jobs);
} else {
if((state_val_44740 === (1))){
var state_44739__$1 = state_44739;
var statearr_44746_44888 = state_44739__$1;
(statearr_44746_44888[(2)] = null);

(statearr_44746_44888[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__44870,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
;
return ((function (__44870,switch__7647__auto__,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_44750 = [null,null,null,null,null,null,null];
(statearr_44750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_44750[(1)] = (1));

return statearr_44750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_44739){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44739);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44751){if((e44751 instanceof Object)){
var ex__7651__auto__ = e44751;
var statearr_44752_44889 = state_44739;
(statearr_44752_44889[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44739);

return cljs.core.constant$keyword$recur;
} else {
throw e44751;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44890 = state_44739;
state_44739 = G__44890;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_44739){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_44739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__44870,switch__7647__auto__,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_44753 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44753[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44882);

return statearr_44753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(__44870,c__7709__auto___44882,G__44699_44871,n__5161__auto___44869,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__44891 = (__44870 + (1));
__44870 = G__44891;
continue;
} else {
}
break;
}

var c__7709__auto___44892 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44892,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44892,jobs,results,process,async){
return (function (state_44775){
var state_val_44776 = (state_44775[(1)]);
if((state_val_44776 === (9))){
var inst_44768 = (state_44775[(2)]);
var state_44775__$1 = (function (){var statearr_44777 = state_44775;
(statearr_44777[(7)] = inst_44768);

return statearr_44777;
})();
var statearr_44778_44893 = state_44775__$1;
(statearr_44778_44893[(2)] = null);

(statearr_44778_44893[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44776 === (8))){
var inst_44761 = (state_44775[(8)]);
var inst_44766 = (state_44775[(2)]);
var state_44775__$1 = (function (){var statearr_44779 = state_44775;
(statearr_44779[(9)] = inst_44766);

return statearr_44779;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44775__$1,(9),results,inst_44761);
} else {
if((state_val_44776 === (7))){
var inst_44771 = (state_44775[(2)]);
var state_44775__$1 = state_44775;
var statearr_44780_44894 = state_44775__$1;
(statearr_44780_44894[(2)] = inst_44771);

(statearr_44780_44894[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44776 === (6))){
var inst_44756 = (state_44775[(10)]);
var inst_44761 = (state_44775[(8)]);
var inst_44761__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44763 = [inst_44756,inst_44761__$1];
var inst_44764 = (new cljs.core.PersistentVector(null,2,(5),inst_44762,inst_44763,null));
var state_44775__$1 = (function (){var statearr_44781 = state_44775;
(statearr_44781[(8)] = inst_44761__$1);

return statearr_44781;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44775__$1,(8),jobs,inst_44764);
} else {
if((state_val_44776 === (5))){
var inst_44759 = cljs.core.async.close_BANG_(jobs);
var state_44775__$1 = state_44775;
var statearr_44782_44895 = state_44775__$1;
(statearr_44782_44895[(2)] = inst_44759);

(statearr_44782_44895[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44776 === (4))){
var inst_44756 = (state_44775[(10)]);
var inst_44756__$1 = (state_44775[(2)]);
var inst_44757 = (inst_44756__$1 == null);
var state_44775__$1 = (function (){var statearr_44783 = state_44775;
(statearr_44783[(10)] = inst_44756__$1);

return statearr_44783;
})();
if(cljs.core.truth_(inst_44757)){
var statearr_44784_44896 = state_44775__$1;
(statearr_44784_44896[(1)] = (5));

} else {
var statearr_44785_44897 = state_44775__$1;
(statearr_44785_44897[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44776 === (3))){
var inst_44773 = (state_44775[(2)]);
var state_44775__$1 = state_44775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44775__$1,inst_44773);
} else {
if((state_val_44776 === (2))){
var state_44775__$1 = state_44775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44775__$1,(4),from);
} else {
if((state_val_44776 === (1))){
var state_44775__$1 = state_44775;
var statearr_44786_44898 = state_44775__$1;
(statearr_44786_44898[(2)] = null);

(statearr_44786_44898[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___44892,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___44892,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_44790 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44790[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_44790[(1)] = (1));

return statearr_44790;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_44775){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44775);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44791){if((e44791 instanceof Object)){
var ex__7651__auto__ = e44791;
var statearr_44792_44899 = state_44775;
(statearr_44792_44899[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44775);

return cljs.core.constant$keyword$recur;
} else {
throw e44791;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44900 = state_44775;
state_44775 = G__44900;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_44775){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_44775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44892,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_44793 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44892);

return statearr_44793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44892,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_44831){
var state_val_44832 = (state_44831[(1)]);
if((state_val_44832 === (7))){
var inst_44827 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
var statearr_44833_44901 = state_44831__$1;
(statearr_44833_44901[(2)] = inst_44827);

(statearr_44833_44901[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (20))){
var state_44831__$1 = state_44831;
var statearr_44834_44902 = state_44831__$1;
(statearr_44834_44902[(2)] = null);

(statearr_44834_44902[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (1))){
var state_44831__$1 = state_44831;
var statearr_44835_44903 = state_44831__$1;
(statearr_44835_44903[(2)] = null);

(statearr_44835_44903[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (4))){
var inst_44796 = (state_44831[(7)]);
var inst_44796__$1 = (state_44831[(2)]);
var inst_44797 = (inst_44796__$1 == null);
var state_44831__$1 = (function (){var statearr_44836 = state_44831;
(statearr_44836[(7)] = inst_44796__$1);

return statearr_44836;
})();
if(cljs.core.truth_(inst_44797)){
var statearr_44837_44904 = state_44831__$1;
(statearr_44837_44904[(1)] = (5));

} else {
var statearr_44838_44905 = state_44831__$1;
(statearr_44838_44905[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (15))){
var inst_44809 = (state_44831[(8)]);
var state_44831__$1 = state_44831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44831__$1,(18),to,inst_44809);
} else {
if((state_val_44832 === (21))){
var inst_44822 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
var statearr_44839_44906 = state_44831__$1;
(statearr_44839_44906[(2)] = inst_44822);

(statearr_44839_44906[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (13))){
var inst_44824 = (state_44831[(2)]);
var state_44831__$1 = (function (){var statearr_44840 = state_44831;
(statearr_44840[(9)] = inst_44824);

return statearr_44840;
})();
var statearr_44841_44907 = state_44831__$1;
(statearr_44841_44907[(2)] = null);

(statearr_44841_44907[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (6))){
var inst_44796 = (state_44831[(7)]);
var state_44831__$1 = state_44831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44831__$1,(11),inst_44796);
} else {
if((state_val_44832 === (17))){
var inst_44817 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
if(cljs.core.truth_(inst_44817)){
var statearr_44842_44908 = state_44831__$1;
(statearr_44842_44908[(1)] = (19));

} else {
var statearr_44843_44909 = state_44831__$1;
(statearr_44843_44909[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (3))){
var inst_44829 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44831__$1,inst_44829);
} else {
if((state_val_44832 === (12))){
var inst_44806 = (state_44831[(10)]);
var state_44831__$1 = state_44831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44831__$1,(14),inst_44806);
} else {
if((state_val_44832 === (2))){
var state_44831__$1 = state_44831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44831__$1,(4),results);
} else {
if((state_val_44832 === (19))){
var state_44831__$1 = state_44831;
var statearr_44844_44910 = state_44831__$1;
(statearr_44844_44910[(2)] = null);

(statearr_44844_44910[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (11))){
var inst_44806 = (state_44831[(2)]);
var state_44831__$1 = (function (){var statearr_44845 = state_44831;
(statearr_44845[(10)] = inst_44806);

return statearr_44845;
})();
var statearr_44846_44911 = state_44831__$1;
(statearr_44846_44911[(2)] = null);

(statearr_44846_44911[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (9))){
var state_44831__$1 = state_44831;
var statearr_44847_44912 = state_44831__$1;
(statearr_44847_44912[(2)] = null);

(statearr_44847_44912[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (5))){
var state_44831__$1 = state_44831;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44848_44913 = state_44831__$1;
(statearr_44848_44913[(1)] = (8));

} else {
var statearr_44849_44914 = state_44831__$1;
(statearr_44849_44914[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (14))){
var inst_44811 = (state_44831[(11)]);
var inst_44809 = (state_44831[(8)]);
var inst_44809__$1 = (state_44831[(2)]);
var inst_44810 = (inst_44809__$1 == null);
var inst_44811__$1 = cljs.core.not(inst_44810);
var state_44831__$1 = (function (){var statearr_44850 = state_44831;
(statearr_44850[(11)] = inst_44811__$1);

(statearr_44850[(8)] = inst_44809__$1);

return statearr_44850;
})();
if(inst_44811__$1){
var statearr_44851_44915 = state_44831__$1;
(statearr_44851_44915[(1)] = (15));

} else {
var statearr_44852_44916 = state_44831__$1;
(statearr_44852_44916[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (16))){
var inst_44811 = (state_44831[(11)]);
var state_44831__$1 = state_44831;
var statearr_44853_44917 = state_44831__$1;
(statearr_44853_44917[(2)] = inst_44811);

(statearr_44853_44917[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (10))){
var inst_44803 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
var statearr_44854_44918 = state_44831__$1;
(statearr_44854_44918[(2)] = inst_44803);

(statearr_44854_44918[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (18))){
var inst_44814 = (state_44831[(2)]);
var state_44831__$1 = state_44831;
var statearr_44855_44919 = state_44831__$1;
(statearr_44855_44919[(2)] = inst_44814);

(statearr_44855_44919[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44832 === (8))){
var inst_44800 = cljs.core.async.close_BANG_(to);
var state_44831__$1 = state_44831;
var statearr_44856_44920 = state_44831__$1;
(statearr_44856_44920[(2)] = inst_44800);

(statearr_44856_44920[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_44860 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44860[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_44860[(1)] = (1));

return statearr_44860;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_44831){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44831);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44861){if((e44861 instanceof Object)){
var ex__7651__auto__ = e44861;
var statearr_44862_44921 = state_44831;
(statearr_44862_44921[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44831);

return cljs.core.constant$keyword$recur;
} else {
throw e44861;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44922 = state_44831;
state_44831 = G__44922;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_44831){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_44831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_44863 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44863[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_44863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__44924 = arguments.length;
switch (G__44924) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__44927 = arguments.length;
switch (G__44927) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__44930 = arguments.length;
switch (G__44930) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__7709__auto___44983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44983,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44983,tc,fc){
return (function (state_44956){
var state_val_44957 = (state_44956[(1)]);
if((state_val_44957 === (7))){
var inst_44952 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_44958_44984 = state_44956__$1;
(statearr_44958_44984[(2)] = inst_44952);

(statearr_44958_44984[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (1))){
var state_44956__$1 = state_44956;
var statearr_44959_44985 = state_44956__$1;
(statearr_44959_44985[(2)] = null);

(statearr_44959_44985[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (4))){
var inst_44933 = (state_44956[(7)]);
var inst_44933__$1 = (state_44956[(2)]);
var inst_44934 = (inst_44933__$1 == null);
var state_44956__$1 = (function (){var statearr_44960 = state_44956;
(statearr_44960[(7)] = inst_44933__$1);

return statearr_44960;
})();
if(cljs.core.truth_(inst_44934)){
var statearr_44961_44986 = state_44956__$1;
(statearr_44961_44986[(1)] = (5));

} else {
var statearr_44962_44987 = state_44956__$1;
(statearr_44962_44987[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (13))){
var state_44956__$1 = state_44956;
var statearr_44963_44988 = state_44956__$1;
(statearr_44963_44988[(2)] = null);

(statearr_44963_44988[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (6))){
var inst_44933 = (state_44956[(7)]);
var inst_44939 = (function (){var G__44964 = inst_44933;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__44964) : p.call(null,G__44964));
})();
var state_44956__$1 = state_44956;
if(cljs.core.truth_(inst_44939)){
var statearr_44965_44989 = state_44956__$1;
(statearr_44965_44989[(1)] = (9));

} else {
var statearr_44966_44990 = state_44956__$1;
(statearr_44966_44990[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (3))){
var inst_44954 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44956__$1,inst_44954);
} else {
if((state_val_44957 === (12))){
var state_44956__$1 = state_44956;
var statearr_44967_44991 = state_44956__$1;
(statearr_44967_44991[(2)] = null);

(statearr_44967_44991[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (2))){
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44956__$1,(4),ch);
} else {
if((state_val_44957 === (11))){
var inst_44933 = (state_44956[(7)]);
var inst_44943 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44956__$1,(8),inst_44943,inst_44933);
} else {
if((state_val_44957 === (9))){
var state_44956__$1 = state_44956;
var statearr_44968_44992 = state_44956__$1;
(statearr_44968_44992[(2)] = tc);

(statearr_44968_44992[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (5))){
var inst_44936 = cljs.core.async.close_BANG_(tc);
var inst_44937 = cljs.core.async.close_BANG_(fc);
var state_44956__$1 = (function (){var statearr_44969 = state_44956;
(statearr_44969[(8)] = inst_44936);

return statearr_44969;
})();
var statearr_44970_44993 = state_44956__$1;
(statearr_44970_44993[(2)] = inst_44937);

(statearr_44970_44993[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (14))){
var inst_44950 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
var statearr_44971_44994 = state_44956__$1;
(statearr_44971_44994[(2)] = inst_44950);

(statearr_44971_44994[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (10))){
var state_44956__$1 = state_44956;
var statearr_44972_44995 = state_44956__$1;
(statearr_44972_44995[(2)] = fc);

(statearr_44972_44995[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_44957 === (8))){
var inst_44945 = (state_44956[(2)]);
var state_44956__$1 = state_44956;
if(cljs.core.truth_(inst_44945)){
var statearr_44973_44996 = state_44956__$1;
(statearr_44973_44996[(1)] = (12));

} else {
var statearr_44974_44997 = state_44956__$1;
(statearr_44974_44997[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___44983,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___44983,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_44978 = [null,null,null,null,null,null,null,null,null];
(statearr_44978[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_44978[(1)] = (1));

return statearr_44978;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_44956){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44956);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44979){if((e44979 instanceof Object)){
var ex__7651__auto__ = e44979;
var statearr_44980_44998 = state_44956;
(statearr_44980_44998[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44956);

return cljs.core.constant$keyword$recur;
} else {
throw e44979;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44999 = state_44956;
state_44956 = G__44999;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_44956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_44956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44983,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_44981 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44981[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44983);

return statearr_44981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44983,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_45048){
var state_val_45049 = (state_45048[(1)]);
if((state_val_45049 === (7))){
var inst_45044 = (state_45048[(2)]);
var state_45048__$1 = state_45048;
var statearr_45050_45068 = state_45048__$1;
(statearr_45050_45068[(2)] = inst_45044);

(statearr_45050_45068[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45049 === (6))){
var inst_45034 = (state_45048[(7)]);
var inst_45037 = (state_45048[(8)]);
var inst_45041 = (function (){var G__45051 = inst_45034;
var G__45052 = inst_45037;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__45051,G__45052) : f.call(null,G__45051,G__45052));
})();
var inst_45034__$1 = inst_45041;
var state_45048__$1 = (function (){var statearr_45053 = state_45048;
(statearr_45053[(7)] = inst_45034__$1);

return statearr_45053;
})();
var statearr_45054_45069 = state_45048__$1;
(statearr_45054_45069[(2)] = null);

(statearr_45054_45069[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45049 === (5))){
var inst_45034 = (state_45048[(7)]);
var state_45048__$1 = state_45048;
var statearr_45055_45070 = state_45048__$1;
(statearr_45055_45070[(2)] = inst_45034);

(statearr_45055_45070[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45049 === (4))){
var inst_45037 = (state_45048[(8)]);
var inst_45037__$1 = (state_45048[(2)]);
var inst_45038 = (inst_45037__$1 == null);
var state_45048__$1 = (function (){var statearr_45056 = state_45048;
(statearr_45056[(8)] = inst_45037__$1);

return statearr_45056;
})();
if(cljs.core.truth_(inst_45038)){
var statearr_45057_45071 = state_45048__$1;
(statearr_45057_45071[(1)] = (5));

} else {
var statearr_45058_45072 = state_45048__$1;
(statearr_45058_45072[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45049 === (3))){
var inst_45046 = (state_45048[(2)]);
var state_45048__$1 = state_45048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45048__$1,inst_45046);
} else {
if((state_val_45049 === (2))){
var state_45048__$1 = state_45048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45048__$1,(4),ch);
} else {
if((state_val_45049 === (1))){
var inst_45034 = init;
var state_45048__$1 = (function (){var statearr_45059 = state_45048;
(statearr_45059[(7)] = inst_45034);

return statearr_45059;
})();
var statearr_45060_45073 = state_45048__$1;
(statearr_45060_45073[(2)] = null);

(statearr_45060_45073[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_45064 = [null,null,null,null,null,null,null,null,null];
(statearr_45064[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_45064[(1)] = (1));

return statearr_45064;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_45048){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_45048);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e45065){if((e45065 instanceof Object)){
var ex__7651__auto__ = e45065;
var statearr_45066_45074 = state_45048;
(statearr_45066_45074[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45048);

return cljs.core.constant$keyword$recur;
} else {
throw e45065;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__45075 = state_45048;
state_45048 = G__45075;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_45048){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_45048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_45067 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_45067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_45067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__45077 = arguments.length;
switch (G__45077) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_45102){
var state_val_45103 = (state_45102[(1)]);
if((state_val_45103 === (7))){
var inst_45084 = (state_45102[(2)]);
var state_45102__$1 = state_45102;
var statearr_45104_45128 = state_45102__$1;
(statearr_45104_45128[(2)] = inst_45084);

(statearr_45104_45128[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (1))){
var inst_45078 = cljs.core.seq(coll);
var inst_45079 = inst_45078;
var state_45102__$1 = (function (){var statearr_45105 = state_45102;
(statearr_45105[(7)] = inst_45079);

return statearr_45105;
})();
var statearr_45106_45129 = state_45102__$1;
(statearr_45106_45129[(2)] = null);

(statearr_45106_45129[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (4))){
var inst_45079 = (state_45102[(7)]);
var inst_45082 = cljs.core.first(inst_45079);
var state_45102__$1 = state_45102;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45102__$1,(7),ch,inst_45082);
} else {
if((state_val_45103 === (13))){
var inst_45096 = (state_45102[(2)]);
var state_45102__$1 = state_45102;
var statearr_45107_45130 = state_45102__$1;
(statearr_45107_45130[(2)] = inst_45096);

(statearr_45107_45130[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (6))){
var inst_45087 = (state_45102[(2)]);
var state_45102__$1 = state_45102;
if(cljs.core.truth_(inst_45087)){
var statearr_45108_45131 = state_45102__$1;
(statearr_45108_45131[(1)] = (8));

} else {
var statearr_45109_45132 = state_45102__$1;
(statearr_45109_45132[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (3))){
var inst_45100 = (state_45102[(2)]);
var state_45102__$1 = state_45102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45102__$1,inst_45100);
} else {
if((state_val_45103 === (12))){
var state_45102__$1 = state_45102;
var statearr_45110_45133 = state_45102__$1;
(statearr_45110_45133[(2)] = null);

(statearr_45110_45133[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (2))){
var inst_45079 = (state_45102[(7)]);
var state_45102__$1 = state_45102;
if(cljs.core.truth_(inst_45079)){
var statearr_45111_45134 = state_45102__$1;
(statearr_45111_45134[(1)] = (4));

} else {
var statearr_45112_45135 = state_45102__$1;
(statearr_45112_45135[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (11))){
var inst_45093 = cljs.core.async.close_BANG_(ch);
var state_45102__$1 = state_45102;
var statearr_45113_45136 = state_45102__$1;
(statearr_45113_45136[(2)] = inst_45093);

(statearr_45113_45136[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (9))){
var state_45102__$1 = state_45102;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45114_45137 = state_45102__$1;
(statearr_45114_45137[(1)] = (11));

} else {
var statearr_45115_45138 = state_45102__$1;
(statearr_45115_45138[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (5))){
var inst_45079 = (state_45102[(7)]);
var state_45102__$1 = state_45102;
var statearr_45116_45139 = state_45102__$1;
(statearr_45116_45139[(2)] = inst_45079);

(statearr_45116_45139[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (10))){
var inst_45098 = (state_45102[(2)]);
var state_45102__$1 = state_45102;
var statearr_45117_45140 = state_45102__$1;
(statearr_45117_45140[(2)] = inst_45098);

(statearr_45117_45140[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45103 === (8))){
var inst_45079 = (state_45102[(7)]);
var inst_45089 = cljs.core.next(inst_45079);
var inst_45079__$1 = inst_45089;
var state_45102__$1 = (function (){var statearr_45118 = state_45102;
(statearr_45118[(7)] = inst_45079__$1);

return statearr_45118;
})();
var statearr_45119_45141 = state_45102__$1;
(statearr_45119_45141[(2)] = null);

(statearr_45119_45141[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_45123 = [null,null,null,null,null,null,null,null];
(statearr_45123[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_45123[(1)] = (1));

return statearr_45123;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_45102){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_45102);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e45124){if((e45124 instanceof Object)){
var ex__7651__auto__ = e45124;
var statearr_45125_45142 = state_45102;
(statearr_45125_45142[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45102);

return cljs.core.constant$keyword$recur;
} else {
throw e45124;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__45143 = state_45102;
state_45102 = G__45143;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_45102){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_45102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_45126 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_45126[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_45126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj45145 = {};
return obj45145;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[(function (){var G__45149 = x__4912__auto__;
return goog.typeOf(G__45149);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj45151 = {};
return obj45151;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[(function (){var G__45155 = x__4912__auto__;
return goog.typeOf(G__45155);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[(function (){var G__45159 = x__4912__auto__;
return goog.typeOf(G__45159);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[(function (){var G__45163 = x__4912__auto__;
return goog.typeOf(G__45163);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__45393 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__45393) : cljs.core.atom.call(null,G__45393));
})();
var m = (function (){
if(typeof cljs.core.async.t45394 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t45394 = (function (cs,ch,mult,meta45395){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta45395 = meta45395;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t45394.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t45394.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t45394.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t45394.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__45397_45622 = self__.cs;
var G__45398_45623 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__45397_45622,G__45398_45623) : cljs.core.reset_BANG_.call(null,G__45397_45622,G__45398_45623));

return null;
});})(cs))
;

cljs.core.async.t45394.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t45394.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t45394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_45396){
var self__ = this;
var _45396__$1 = this;
return self__.meta45395;
});})(cs))
;

cljs.core.async.t45394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_45396,meta45395__$1){
var self__ = this;
var _45396__$1 = this;
return (new cljs.core.async.t45394(self__.cs,self__.ch,self__.mult,meta45395__$1));
});})(cs))
;

cljs.core.async.t45394.cljs$lang$type = true;

cljs.core.async.t45394.cljs$lang$ctorStr = "cljs.core.async/t45394";

cljs.core.async.t45394.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t45394");
});})(cs))
;

cljs.core.async.__GT_t45394 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t45394(cs__$1,ch__$1,mult__$1,meta45395){
return (new cljs.core.async.t45394(cs__$1,ch__$1,mult__$1,meta45395));
});})(cs))
;

}

return (new cljs.core.async.t45394(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__45399 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__45399) : cljs.core.atom.call(null,G__45399));
})();
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___45624 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___45624,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___45624,cs,m,dchan,dctr,done){
return (function (state_45530){
var state_val_45531 = (state_45530[(1)]);
if((state_val_45531 === (7))){
var inst_45526 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45532_45625 = state_45530__$1;
(statearr_45532_45625[(2)] = inst_45526);

(statearr_45532_45625[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (20))){
var inst_45431 = (state_45530[(7)]);
var inst_45441 = cljs.core.first(inst_45431);
var inst_45442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45441,(0),null);
var inst_45443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45441,(1),null);
var state_45530__$1 = (function (){var statearr_45533 = state_45530;
(statearr_45533[(8)] = inst_45442);

return statearr_45533;
})();
if(cljs.core.truth_(inst_45443)){
var statearr_45534_45626 = state_45530__$1;
(statearr_45534_45626[(1)] = (22));

} else {
var statearr_45535_45627 = state_45530__$1;
(statearr_45535_45627[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (27))){
var inst_45478 = (state_45530[(9)]);
var inst_45473 = (state_45530[(10)]);
var inst_45402 = (state_45530[(11)]);
var inst_45471 = (state_45530[(12)]);
var inst_45478__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_45471,inst_45473);
var inst_45479 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45478__$1,inst_45402,done);
var state_45530__$1 = (function (){var statearr_45536 = state_45530;
(statearr_45536[(9)] = inst_45478__$1);

return statearr_45536;
})();
if(cljs.core.truth_(inst_45479)){
var statearr_45537_45628 = state_45530__$1;
(statearr_45537_45628[(1)] = (30));

} else {
var statearr_45538_45629 = state_45530__$1;
(statearr_45538_45629[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (1))){
var state_45530__$1 = state_45530;
var statearr_45539_45630 = state_45530__$1;
(statearr_45539_45630[(2)] = null);

(statearr_45539_45630[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (24))){
var inst_45431 = (state_45530[(7)]);
var inst_45448 = (state_45530[(2)]);
var inst_45449 = cljs.core.next(inst_45431);
var inst_45411 = inst_45449;
var inst_45412 = null;
var inst_45413 = (0);
var inst_45414 = (0);
var state_45530__$1 = (function (){var statearr_45540 = state_45530;
(statearr_45540[(13)] = inst_45414);

(statearr_45540[(14)] = inst_45413);

(statearr_45540[(15)] = inst_45448);

(statearr_45540[(16)] = inst_45411);

(statearr_45540[(17)] = inst_45412);

return statearr_45540;
})();
var statearr_45541_45631 = state_45530__$1;
(statearr_45541_45631[(2)] = null);

(statearr_45541_45631[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (39))){
var state_45530__$1 = state_45530;
var statearr_45545_45632 = state_45530__$1;
(statearr_45545_45632[(2)] = null);

(statearr_45545_45632[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (4))){
var inst_45402 = (state_45530[(11)]);
var inst_45402__$1 = (state_45530[(2)]);
var inst_45403 = (inst_45402__$1 == null);
var state_45530__$1 = (function (){var statearr_45546 = state_45530;
(statearr_45546[(11)] = inst_45402__$1);

return statearr_45546;
})();
if(cljs.core.truth_(inst_45403)){
var statearr_45547_45633 = state_45530__$1;
(statearr_45547_45633[(1)] = (5));

} else {
var statearr_45548_45634 = state_45530__$1;
(statearr_45548_45634[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (15))){
var inst_45414 = (state_45530[(13)]);
var inst_45413 = (state_45530[(14)]);
var inst_45411 = (state_45530[(16)]);
var inst_45412 = (state_45530[(17)]);
var inst_45427 = (state_45530[(2)]);
var inst_45428 = (inst_45414 + (1));
var tmp45542 = inst_45413;
var tmp45543 = inst_45411;
var tmp45544 = inst_45412;
var inst_45411__$1 = tmp45543;
var inst_45412__$1 = tmp45544;
var inst_45413__$1 = tmp45542;
var inst_45414__$1 = inst_45428;
var state_45530__$1 = (function (){var statearr_45549 = state_45530;
(statearr_45549[(13)] = inst_45414__$1);

(statearr_45549[(14)] = inst_45413__$1);

(statearr_45549[(18)] = inst_45427);

(statearr_45549[(16)] = inst_45411__$1);

(statearr_45549[(17)] = inst_45412__$1);

return statearr_45549;
})();
var statearr_45550_45635 = state_45530__$1;
(statearr_45550_45635[(2)] = null);

(statearr_45550_45635[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (21))){
var inst_45452 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45554_45636 = state_45530__$1;
(statearr_45554_45636[(2)] = inst_45452);

(statearr_45554_45636[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (31))){
var inst_45478 = (state_45530[(9)]);
var inst_45482 = done(null);
var inst_45483 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45478);
var state_45530__$1 = (function (){var statearr_45555 = state_45530;
(statearr_45555[(19)] = inst_45482);

return statearr_45555;
})();
var statearr_45556_45637 = state_45530__$1;
(statearr_45556_45637[(2)] = inst_45483);

(statearr_45556_45637[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (32))){
var inst_45473 = (state_45530[(10)]);
var inst_45470 = (state_45530[(20)]);
var inst_45471 = (state_45530[(12)]);
var inst_45472 = (state_45530[(21)]);
var inst_45485 = (state_45530[(2)]);
var inst_45486 = (inst_45473 + (1));
var tmp45551 = inst_45470;
var tmp45552 = inst_45471;
var tmp45553 = inst_45472;
var inst_45470__$1 = tmp45551;
var inst_45471__$1 = tmp45552;
var inst_45472__$1 = tmp45553;
var inst_45473__$1 = inst_45486;
var state_45530__$1 = (function (){var statearr_45557 = state_45530;
(statearr_45557[(10)] = inst_45473__$1);

(statearr_45557[(20)] = inst_45470__$1);

(statearr_45557[(22)] = inst_45485);

(statearr_45557[(12)] = inst_45471__$1);

(statearr_45557[(21)] = inst_45472__$1);

return statearr_45557;
})();
var statearr_45558_45638 = state_45530__$1;
(statearr_45558_45638[(2)] = null);

(statearr_45558_45638[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (40))){
var inst_45498 = (state_45530[(23)]);
var inst_45502 = done(null);
var inst_45503 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45498);
var state_45530__$1 = (function (){var statearr_45559 = state_45530;
(statearr_45559[(24)] = inst_45502);

return statearr_45559;
})();
var statearr_45560_45639 = state_45530__$1;
(statearr_45560_45639[(2)] = inst_45503);

(statearr_45560_45639[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (33))){
var inst_45489 = (state_45530[(25)]);
var inst_45491 = cljs.core.chunked_seq_QMARK_(inst_45489);
var state_45530__$1 = state_45530;
if(inst_45491){
var statearr_45561_45640 = state_45530__$1;
(statearr_45561_45640[(1)] = (36));

} else {
var statearr_45562_45641 = state_45530__$1;
(statearr_45562_45641[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (13))){
var inst_45421 = (state_45530[(26)]);
var inst_45424 = cljs.core.async.close_BANG_(inst_45421);
var state_45530__$1 = state_45530;
var statearr_45563_45642 = state_45530__$1;
(statearr_45563_45642[(2)] = inst_45424);

(statearr_45563_45642[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (22))){
var inst_45442 = (state_45530[(8)]);
var inst_45445 = cljs.core.async.close_BANG_(inst_45442);
var state_45530__$1 = state_45530;
var statearr_45564_45643 = state_45530__$1;
(statearr_45564_45643[(2)] = inst_45445);

(statearr_45564_45643[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (36))){
var inst_45489 = (state_45530[(25)]);
var inst_45493 = cljs.core.chunk_first(inst_45489);
var inst_45494 = cljs.core.chunk_rest(inst_45489);
var inst_45495 = cljs.core.count(inst_45493);
var inst_45470 = inst_45494;
var inst_45471 = inst_45493;
var inst_45472 = inst_45495;
var inst_45473 = (0);
var state_45530__$1 = (function (){var statearr_45565 = state_45530;
(statearr_45565[(10)] = inst_45473);

(statearr_45565[(20)] = inst_45470);

(statearr_45565[(12)] = inst_45471);

(statearr_45565[(21)] = inst_45472);

return statearr_45565;
})();
var statearr_45566_45644 = state_45530__$1;
(statearr_45566_45644[(2)] = null);

(statearr_45566_45644[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (41))){
var inst_45489 = (state_45530[(25)]);
var inst_45505 = (state_45530[(2)]);
var inst_45506 = cljs.core.next(inst_45489);
var inst_45470 = inst_45506;
var inst_45471 = null;
var inst_45472 = (0);
var inst_45473 = (0);
var state_45530__$1 = (function (){var statearr_45567 = state_45530;
(statearr_45567[(27)] = inst_45505);

(statearr_45567[(10)] = inst_45473);

(statearr_45567[(20)] = inst_45470);

(statearr_45567[(12)] = inst_45471);

(statearr_45567[(21)] = inst_45472);

return statearr_45567;
})();
var statearr_45568_45645 = state_45530__$1;
(statearr_45568_45645[(2)] = null);

(statearr_45568_45645[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (43))){
var state_45530__$1 = state_45530;
var statearr_45569_45646 = state_45530__$1;
(statearr_45569_45646[(2)] = null);

(statearr_45569_45646[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (29))){
var inst_45514 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45570_45647 = state_45530__$1;
(statearr_45570_45647[(2)] = inst_45514);

(statearr_45570_45647[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (44))){
var inst_45523 = (state_45530[(2)]);
var state_45530__$1 = (function (){var statearr_45571 = state_45530;
(statearr_45571[(28)] = inst_45523);

return statearr_45571;
})();
var statearr_45572_45648 = state_45530__$1;
(statearr_45572_45648[(2)] = null);

(statearr_45572_45648[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (6))){
var inst_45462 = (state_45530[(29)]);
var inst_45461 = (function (){var G__45573 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45573) : cljs.core.deref.call(null,G__45573));
})();
var inst_45462__$1 = cljs.core.keys(inst_45461);
var inst_45463 = cljs.core.count(inst_45462__$1);
var inst_45464 = (function (){var G__45574 = dctr;
var G__45575 = inst_45463;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__45574,G__45575) : cljs.core.reset_BANG_.call(null,G__45574,G__45575));
})();
var inst_45469 = cljs.core.seq(inst_45462__$1);
var inst_45470 = inst_45469;
var inst_45471 = null;
var inst_45472 = (0);
var inst_45473 = (0);
var state_45530__$1 = (function (){var statearr_45576 = state_45530;
(statearr_45576[(10)] = inst_45473);

(statearr_45576[(20)] = inst_45470);

(statearr_45576[(12)] = inst_45471);

(statearr_45576[(21)] = inst_45472);

(statearr_45576[(29)] = inst_45462__$1);

(statearr_45576[(30)] = inst_45464);

return statearr_45576;
})();
var statearr_45577_45649 = state_45530__$1;
(statearr_45577_45649[(2)] = null);

(statearr_45577_45649[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (28))){
var inst_45470 = (state_45530[(20)]);
var inst_45489 = (state_45530[(25)]);
var inst_45489__$1 = cljs.core.seq(inst_45470);
var state_45530__$1 = (function (){var statearr_45578 = state_45530;
(statearr_45578[(25)] = inst_45489__$1);

return statearr_45578;
})();
if(inst_45489__$1){
var statearr_45579_45650 = state_45530__$1;
(statearr_45579_45650[(1)] = (33));

} else {
var statearr_45580_45651 = state_45530__$1;
(statearr_45580_45651[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (25))){
var inst_45473 = (state_45530[(10)]);
var inst_45472 = (state_45530[(21)]);
var inst_45475 = (inst_45473 < inst_45472);
var inst_45476 = inst_45475;
var state_45530__$1 = state_45530;
if(cljs.core.truth_(inst_45476)){
var statearr_45581_45652 = state_45530__$1;
(statearr_45581_45652[(1)] = (27));

} else {
var statearr_45582_45653 = state_45530__$1;
(statearr_45582_45653[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (34))){
var state_45530__$1 = state_45530;
var statearr_45583_45654 = state_45530__$1;
(statearr_45583_45654[(2)] = null);

(statearr_45583_45654[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (17))){
var state_45530__$1 = state_45530;
var statearr_45584_45655 = state_45530__$1;
(statearr_45584_45655[(2)] = null);

(statearr_45584_45655[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (3))){
var inst_45528 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45530__$1,inst_45528);
} else {
if((state_val_45531 === (12))){
var inst_45457 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45585_45656 = state_45530__$1;
(statearr_45585_45656[(2)] = inst_45457);

(statearr_45585_45656[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (2))){
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45530__$1,(4),ch);
} else {
if((state_val_45531 === (23))){
var state_45530__$1 = state_45530;
var statearr_45586_45657 = state_45530__$1;
(statearr_45586_45657[(2)] = null);

(statearr_45586_45657[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (35))){
var inst_45512 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45587_45658 = state_45530__$1;
(statearr_45587_45658[(2)] = inst_45512);

(statearr_45587_45658[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (19))){
var inst_45431 = (state_45530[(7)]);
var inst_45435 = cljs.core.chunk_first(inst_45431);
var inst_45436 = cljs.core.chunk_rest(inst_45431);
var inst_45437 = cljs.core.count(inst_45435);
var inst_45411 = inst_45436;
var inst_45412 = inst_45435;
var inst_45413 = inst_45437;
var inst_45414 = (0);
var state_45530__$1 = (function (){var statearr_45588 = state_45530;
(statearr_45588[(13)] = inst_45414);

(statearr_45588[(14)] = inst_45413);

(statearr_45588[(16)] = inst_45411);

(statearr_45588[(17)] = inst_45412);

return statearr_45588;
})();
var statearr_45589_45659 = state_45530__$1;
(statearr_45589_45659[(2)] = null);

(statearr_45589_45659[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (11))){
var inst_45411 = (state_45530[(16)]);
var inst_45431 = (state_45530[(7)]);
var inst_45431__$1 = cljs.core.seq(inst_45411);
var state_45530__$1 = (function (){var statearr_45590 = state_45530;
(statearr_45590[(7)] = inst_45431__$1);

return statearr_45590;
})();
if(inst_45431__$1){
var statearr_45591_45660 = state_45530__$1;
(statearr_45591_45660[(1)] = (16));

} else {
var statearr_45592_45661 = state_45530__$1;
(statearr_45592_45661[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (9))){
var inst_45459 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45593_45662 = state_45530__$1;
(statearr_45593_45662[(2)] = inst_45459);

(statearr_45593_45662[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (5))){
var inst_45409 = (function (){var G__45594 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45594) : cljs.core.deref.call(null,G__45594));
})();
var inst_45410 = cljs.core.seq(inst_45409);
var inst_45411 = inst_45410;
var inst_45412 = null;
var inst_45413 = (0);
var inst_45414 = (0);
var state_45530__$1 = (function (){var statearr_45595 = state_45530;
(statearr_45595[(13)] = inst_45414);

(statearr_45595[(14)] = inst_45413);

(statearr_45595[(16)] = inst_45411);

(statearr_45595[(17)] = inst_45412);

return statearr_45595;
})();
var statearr_45596_45663 = state_45530__$1;
(statearr_45596_45663[(2)] = null);

(statearr_45596_45663[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (14))){
var state_45530__$1 = state_45530;
var statearr_45597_45664 = state_45530__$1;
(statearr_45597_45664[(2)] = null);

(statearr_45597_45664[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (45))){
var inst_45520 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45598_45665 = state_45530__$1;
(statearr_45598_45665[(2)] = inst_45520);

(statearr_45598_45665[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (26))){
var inst_45462 = (state_45530[(29)]);
var inst_45516 = (state_45530[(2)]);
var inst_45517 = cljs.core.seq(inst_45462);
var state_45530__$1 = (function (){var statearr_45599 = state_45530;
(statearr_45599[(31)] = inst_45516);

return statearr_45599;
})();
if(inst_45517){
var statearr_45600_45666 = state_45530__$1;
(statearr_45600_45666[(1)] = (42));

} else {
var statearr_45601_45667 = state_45530__$1;
(statearr_45601_45667[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (16))){
var inst_45431 = (state_45530[(7)]);
var inst_45433 = cljs.core.chunked_seq_QMARK_(inst_45431);
var state_45530__$1 = state_45530;
if(inst_45433){
var statearr_45602_45668 = state_45530__$1;
(statearr_45602_45668[(1)] = (19));

} else {
var statearr_45603_45669 = state_45530__$1;
(statearr_45603_45669[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (38))){
var inst_45509 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45604_45670 = state_45530__$1;
(statearr_45604_45670[(2)] = inst_45509);

(statearr_45604_45670[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (30))){
var state_45530__$1 = state_45530;
var statearr_45605_45671 = state_45530__$1;
(statearr_45605_45671[(2)] = null);

(statearr_45605_45671[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (10))){
var inst_45414 = (state_45530[(13)]);
var inst_45412 = (state_45530[(17)]);
var inst_45420 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_45412,inst_45414);
var inst_45421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45420,(0),null);
var inst_45422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45420,(1),null);
var state_45530__$1 = (function (){var statearr_45606 = state_45530;
(statearr_45606[(26)] = inst_45421);

return statearr_45606;
})();
if(cljs.core.truth_(inst_45422)){
var statearr_45607_45672 = state_45530__$1;
(statearr_45607_45672[(1)] = (13));

} else {
var statearr_45608_45673 = state_45530__$1;
(statearr_45608_45673[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (18))){
var inst_45455 = (state_45530[(2)]);
var state_45530__$1 = state_45530;
var statearr_45609_45674 = state_45530__$1;
(statearr_45609_45674[(2)] = inst_45455);

(statearr_45609_45674[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (42))){
var state_45530__$1 = state_45530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45530__$1,(45),dchan);
} else {
if((state_val_45531 === (37))){
var inst_45498 = (state_45530[(23)]);
var inst_45402 = (state_45530[(11)]);
var inst_45489 = (state_45530[(25)]);
var inst_45498__$1 = cljs.core.first(inst_45489);
var inst_45499 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45498__$1,inst_45402,done);
var state_45530__$1 = (function (){var statearr_45610 = state_45530;
(statearr_45610[(23)] = inst_45498__$1);

return statearr_45610;
})();
if(cljs.core.truth_(inst_45499)){
var statearr_45611_45675 = state_45530__$1;
(statearr_45611_45675[(1)] = (39));

} else {
var statearr_45612_45676 = state_45530__$1;
(statearr_45612_45676[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45531 === (8))){
var inst_45414 = (state_45530[(13)]);
var inst_45413 = (state_45530[(14)]);
var inst_45416 = (inst_45414 < inst_45413);
var inst_45417 = inst_45416;
var state_45530__$1 = state_45530;
if(cljs.core.truth_(inst_45417)){
var statearr_45613_45677 = state_45530__$1;
(statearr_45613_45677[(1)] = (10));

} else {
var statearr_45614_45678 = state_45530__$1;
(statearr_45614_45678[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___45624,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___45624,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_45618 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45618[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_45618[(1)] = (1));

return statearr_45618;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_45530){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_45530);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e45619){if((e45619 instanceof Object)){
var ex__7651__auto__ = e45619;
var statearr_45620_45679 = state_45530;
(statearr_45620_45679[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45530);

return cljs.core.constant$keyword$recur;
} else {
throw e45619;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__45680 = state_45530;
state_45530 = G__45680;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_45530){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_45530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___45624,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_45621 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_45621[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___45624);

return statearr_45621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___45624,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__45682 = arguments.length;
switch (G__45682) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = (function (){var obj45685 = {};
return obj45685;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[(function (){var G__45689 = x__4912__auto__;
return goog.typeOf(G__45689);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[(function (){var G__45693 = x__4912__auto__;
return goog.typeOf(G__45693);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[(function (){var G__45697 = x__4912__auto__;
return goog.typeOf(G__45697);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[(function (){var G__45701 = x__4912__auto__;
return goog.typeOf(G__45701);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[(function (){var G__45705 = x__4912__auto__;
return goog.typeOf(G__45705);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45710){
var map__45711 = p__45710;
var map__45711__$1 = ((cljs.core.seq_QMARK_(map__45711))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45711):map__45711);
var opts = map__45711__$1;
var statearr_45712_45716 = state;
(statearr_45712_45716[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts(((function (map__45711,map__45711__$1,opts){
return (function (val){
var statearr_45713_45717 = state;
(statearr_45713_45717[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__45711,map__45711__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_45714_45718 = state;
(statearr_45714_45718[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__45715 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45715) : cljs.core.deref.call(null,G__45715));
})());


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45706){
var G__45707 = cljs.core.first(seq45706);
var seq45706__$1 = cljs.core.next(seq45706);
var G__45708 = cljs.core.first(seq45706__$1);
var seq45706__$2 = cljs.core.next(seq45706__$1);
var G__45709 = cljs.core.first(seq45706__$2);
var seq45706__$3 = cljs.core.next(seq45706__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__45707,G__45708,G__45709,seq45706__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__45852 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__45852) : cljs.core.atom.call(null,G__45852));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (function (){var G__45853 = cljs.core.constant$keyword$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__45853) : cljs.core.atom.call(null,G__45853));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((function (){var G__45854 = v;
return (attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(G__45854) : attr.call(null,G__45854));
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (function (){var G__45855 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45855) : cljs.core.deref.call(null,G__45855));
})();
var mode = (function (){var G__45856 = solo_mode;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45856) : cljs.core.deref.call(null,G__45856));
})();
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t45857 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t45857 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45858){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45858 = meta45858;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t45857.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t45857.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__45860_45985 = self__.cs;
var G__45861_45986 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__45860_45985,G__45861_45986) : cljs.core.reset_BANG_.call(null,G__45860_45985,G__45861_45986));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__45862 = mode;
return (self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(G__45862) : self__.solo_modes.call(null,G__45862));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

var G__45863_45987 = self__.solo_mode;
var G__45864_45988 = mode;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__45863_45987,G__45864_45988) : cljs.core.reset_BANG_.call(null,G__45863_45987,G__45864_45988));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t45857.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_45859){
var self__ = this;
var _45859__$1 = this;
return self__.meta45858;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_45859,meta45858__$1){
var self__ = this;
var _45859__$1 = this;
return (new cljs.core.async.t45857(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45858__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t45857.cljs$lang$type = true;

cljs.core.async.t45857.cljs$lang$ctorStr = "cljs.core.async/t45857";

cljs.core.async.t45857.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t45857");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t45857 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t45857(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45858){
return (new cljs.core.async.t45857(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45858));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t45857(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___45989 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_45936){
var state_val_45937 = (state_45936[(1)]);
if((state_val_45937 === (7))){
var inst_45878 = (state_45936[(7)]);
var inst_45883 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45878);
var state_45936__$1 = state_45936;
var statearr_45938_45990 = state_45936__$1;
(statearr_45938_45990[(2)] = inst_45883);

(statearr_45938_45990[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (20))){
var inst_45893 = (state_45936[(8)]);
var state_45936__$1 = state_45936;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45936__$1,(23),out,inst_45893);
} else {
if((state_val_45937 === (1))){
var inst_45868 = (state_45936[(9)]);
var inst_45868__$1 = calc_state();
var inst_45869 = cljs.core.seq_QMARK_(inst_45868__$1);
var state_45936__$1 = (function (){var statearr_45939 = state_45936;
(statearr_45939[(9)] = inst_45868__$1);

return statearr_45939;
})();
if(inst_45869){
var statearr_45940_45991 = state_45936__$1;
(statearr_45940_45991[(1)] = (2));

} else {
var statearr_45941_45992 = state_45936__$1;
(statearr_45941_45992[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (24))){
var inst_45886 = (state_45936[(10)]);
var inst_45878 = inst_45886;
var state_45936__$1 = (function (){var statearr_45942 = state_45936;
(statearr_45942[(7)] = inst_45878);

return statearr_45942;
})();
var statearr_45943_45993 = state_45936__$1;
(statearr_45943_45993[(2)] = null);

(statearr_45943_45993[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (4))){
var inst_45868 = (state_45936[(9)]);
var inst_45874 = (state_45936[(2)]);
var inst_45875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45874,cljs.core.constant$keyword$reads);
var inst_45876 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45874,cljs.core.constant$keyword$mutes);
var inst_45877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45874,cljs.core.constant$keyword$solos);
var inst_45878 = inst_45868;
var state_45936__$1 = (function (){var statearr_45944 = state_45936;
(statearr_45944[(11)] = inst_45877);

(statearr_45944[(7)] = inst_45878);

(statearr_45944[(12)] = inst_45876);

(statearr_45944[(13)] = inst_45875);

return statearr_45944;
})();
var statearr_45945_45994 = state_45936__$1;
(statearr_45945_45994[(2)] = null);

(statearr_45945_45994[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (15))){
var state_45936__$1 = state_45936;
var statearr_45946_45995 = state_45936__$1;
(statearr_45946_45995[(2)] = null);

(statearr_45946_45995[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (21))){
var inst_45886 = (state_45936[(10)]);
var inst_45878 = inst_45886;
var state_45936__$1 = (function (){var statearr_45947 = state_45936;
(statearr_45947[(7)] = inst_45878);

return statearr_45947;
})();
var statearr_45948_45996 = state_45936__$1;
(statearr_45948_45996[(2)] = null);

(statearr_45948_45996[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (13))){
var inst_45932 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
var statearr_45949_45997 = state_45936__$1;
(statearr_45949_45997[(2)] = inst_45932);

(statearr_45949_45997[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (22))){
var inst_45930 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
var statearr_45950_45998 = state_45936__$1;
(statearr_45950_45998[(2)] = inst_45930);

(statearr_45950_45998[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (6))){
var inst_45934 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45936__$1,inst_45934);
} else {
if((state_val_45937 === (25))){
var state_45936__$1 = state_45936;
var statearr_45951_45999 = state_45936__$1;
(statearr_45951_45999[(2)] = null);

(statearr_45951_45999[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (17))){
var inst_45909 = (state_45936[(14)]);
var state_45936__$1 = state_45936;
var statearr_45952_46000 = state_45936__$1;
(statearr_45952_46000[(2)] = inst_45909);

(statearr_45952_46000[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (3))){
var inst_45868 = (state_45936[(9)]);
var state_45936__$1 = state_45936;
var statearr_45953_46001 = state_45936__$1;
(statearr_45953_46001[(2)] = inst_45868);

(statearr_45953_46001[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (12))){
var inst_45894 = (state_45936[(15)]);
var inst_45909 = (state_45936[(14)]);
var inst_45889 = (state_45936[(16)]);
var inst_45909__$1 = (function (){var G__45954 = inst_45894;
return (inst_45889.cljs$core$IFn$_invoke$arity$1 ? inst_45889.cljs$core$IFn$_invoke$arity$1(G__45954) : inst_45889.call(null,G__45954));
})();
var state_45936__$1 = (function (){var statearr_45955 = state_45936;
(statearr_45955[(14)] = inst_45909__$1);

return statearr_45955;
})();
if(cljs.core.truth_(inst_45909__$1)){
var statearr_45956_46002 = state_45936__$1;
(statearr_45956_46002[(1)] = (17));

} else {
var statearr_45957_46003 = state_45936__$1;
(statearr_45957_46003[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (2))){
var inst_45868 = (state_45936[(9)]);
var inst_45871 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45868);
var state_45936__$1 = state_45936;
var statearr_45958_46004 = state_45936__$1;
(statearr_45958_46004[(2)] = inst_45871);

(statearr_45958_46004[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (23))){
var inst_45921 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
if(cljs.core.truth_(inst_45921)){
var statearr_45959_46005 = state_45936__$1;
(statearr_45959_46005[(1)] = (24));

} else {
var statearr_45960_46006 = state_45936__$1;
(statearr_45960_46006[(1)] = (25));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (19))){
var inst_45918 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
if(cljs.core.truth_(inst_45918)){
var statearr_45961_46007 = state_45936__$1;
(statearr_45961_46007[(1)] = (20));

} else {
var statearr_45962_46008 = state_45936__$1;
(statearr_45962_46008[(1)] = (21));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (11))){
var inst_45893 = (state_45936[(8)]);
var inst_45899 = (inst_45893 == null);
var state_45936__$1 = state_45936;
if(cljs.core.truth_(inst_45899)){
var statearr_45963_46009 = state_45936__$1;
(statearr_45963_46009[(1)] = (14));

} else {
var statearr_45964_46010 = state_45936__$1;
(statearr_45964_46010[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (9))){
var inst_45886 = (state_45936[(10)]);
var inst_45886__$1 = (state_45936[(2)]);
var inst_45887 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45886__$1,cljs.core.constant$keyword$reads);
var inst_45888 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45886__$1,cljs.core.constant$keyword$mutes);
var inst_45889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45886__$1,cljs.core.constant$keyword$solos);
var state_45936__$1 = (function (){var statearr_45965 = state_45936;
(statearr_45965[(10)] = inst_45886__$1);

(statearr_45965[(17)] = inst_45888);

(statearr_45965[(16)] = inst_45889);

return statearr_45965;
})();
return cljs.core.async.ioc_alts_BANG_(state_45936__$1,(10),inst_45887);
} else {
if((state_val_45937 === (5))){
var inst_45878 = (state_45936[(7)]);
var inst_45881 = cljs.core.seq_QMARK_(inst_45878);
var state_45936__$1 = state_45936;
if(inst_45881){
var statearr_45966_46011 = state_45936__$1;
(statearr_45966_46011[(1)] = (7));

} else {
var statearr_45967_46012 = state_45936__$1;
(statearr_45967_46012[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (14))){
var inst_45894 = (state_45936[(15)]);
var inst_45901 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45894);
var state_45936__$1 = state_45936;
var statearr_45968_46013 = state_45936__$1;
(statearr_45968_46013[(2)] = inst_45901);

(statearr_45968_46013[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (26))){
var inst_45926 = (state_45936[(2)]);
var state_45936__$1 = state_45936;
var statearr_45969_46014 = state_45936__$1;
(statearr_45969_46014[(2)] = inst_45926);

(statearr_45969_46014[(1)] = (22));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (16))){
var inst_45904 = (state_45936[(2)]);
var inst_45905 = calc_state();
var inst_45878 = inst_45905;
var state_45936__$1 = (function (){var statearr_45970 = state_45936;
(statearr_45970[(7)] = inst_45878);

(statearr_45970[(18)] = inst_45904);

return statearr_45970;
})();
var statearr_45971_46015 = state_45936__$1;
(statearr_45971_46015[(2)] = null);

(statearr_45971_46015[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (10))){
var inst_45894 = (state_45936[(15)]);
var inst_45893 = (state_45936[(8)]);
var inst_45892 = (state_45936[(2)]);
var inst_45893__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45892,(0),null);
var inst_45894__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45892,(1),null);
var inst_45895 = (inst_45893__$1 == null);
var inst_45896 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45894__$1,change);
var inst_45897 = (inst_45895) || (inst_45896);
var state_45936__$1 = (function (){var statearr_45972 = state_45936;
(statearr_45972[(15)] = inst_45894__$1);

(statearr_45972[(8)] = inst_45893__$1);

return statearr_45972;
})();
if(cljs.core.truth_(inst_45897)){
var statearr_45973_46016 = state_45936__$1;
(statearr_45973_46016[(1)] = (11));

} else {
var statearr_45974_46017 = state_45936__$1;
(statearr_45974_46017[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (18))){
var inst_45894 = (state_45936[(15)]);
var inst_45888 = (state_45936[(17)]);
var inst_45889 = (state_45936[(16)]);
var inst_45913 = cljs.core.empty_QMARK_(inst_45889);
var inst_45914 = (function (){var G__45975 = inst_45894;
return (inst_45888.cljs$core$IFn$_invoke$arity$1 ? inst_45888.cljs$core$IFn$_invoke$arity$1(G__45975) : inst_45888.call(null,G__45975));
})();
var inst_45915 = cljs.core.not(inst_45914);
var inst_45916 = (inst_45913) && (inst_45915);
var state_45936__$1 = state_45936;
var statearr_45976_46018 = state_45936__$1;
(statearr_45976_46018[(2)] = inst_45916);

(statearr_45976_46018[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_45937 === (8))){
var inst_45878 = (state_45936[(7)]);
var state_45936__$1 = state_45936;
var statearr_45977_46019 = state_45936__$1;
(statearr_45977_46019[(2)] = inst_45878);

(statearr_45977_46019[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_45981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45981[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_45981[(1)] = (1));

return statearr_45981;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_45936){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_45936);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e45982){if((e45982 instanceof Object)){
var ex__7651__auto__ = e45982;
var statearr_45983_46020 = state_45936;
(statearr_45983_46020[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45936);

return cljs.core.constant$keyword$recur;
} else {
throw e45982;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46021 = state_45936;
state_45936 = G__46021;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_45936){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_45936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_45984 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_45984[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___45989);

return statearr_45984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___45989,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = (function (){var obj46023 = {};
return obj46023;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[(function (){var G__46027 = x__4912__auto__;
return goog.typeOf(G__46027);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[(function (){var G__46031 = x__4912__auto__;
return goog.typeOf(G__46031);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__46033 = arguments.length;
switch (G__46033) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__46035 = x__4912__auto__;
return goog.typeOf(G__46035);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__46037 = x__4912__auto__;
return goog.typeOf(G__46037);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__46041 = arguments.length;
switch (G__46041) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__46042 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__46042) : cljs.core.atom.call(null,G__46042));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__46044 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46044) : cljs.core.deref.call(null,G__46044));
})(),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4276__auto__,mults){
return (function (p1__46039_SHARP_){
if(cljs.core.truth_((function (){var G__46045 = topic;
return (p1__46039_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46039_SHARP_.cljs$core$IFn$_invoke$arity$1(G__46045) : p1__46039_SHARP_.call(null,G__46045));
})())){
return p1__46039_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46039_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((function (){var G__46046 = topic;
return (buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(G__46046) : buf_fn.call(null,G__46046));
})())));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t46047 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t46047 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta46048){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta46048 = meta46048;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t46047.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t46047.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (function (){var G__46050 = topic;
return (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(G__46050) : self__.ensure_mult.call(null,G__46050));
})();
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__46051 = self__.mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46051) : cljs.core.deref.call(null,G__46051));
})(),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__46052 = self__.mults;
var G__46053 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__46052,G__46053) : cljs.core.reset_BANG_.call(null,G__46052,G__46053));
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t46047.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_46049){
var self__ = this;
var _46049__$1 = this;
return self__.meta46048;
});})(mults,ensure_mult))
;

cljs.core.async.t46047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_46049,meta46048__$1){
var self__ = this;
var _46049__$1 = this;
return (new cljs.core.async.t46047(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta46048__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t46047.cljs$lang$type = true;

cljs.core.async.t46047.cljs$lang$ctorStr = "cljs.core.async/t46047";

cljs.core.async.t46047.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t46047");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t46047 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t46047(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta46048){
return (new cljs.core.async.t46047(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta46048));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t46047(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___46177 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46177,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46177,mults,ensure_mult,p){
return (function (state_46125){
var state_val_46126 = (state_46125[(1)]);
if((state_val_46126 === (7))){
var inst_46121 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46127_46178 = state_46125__$1;
(statearr_46127_46178[(2)] = inst_46121);

(statearr_46127_46178[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (20))){
var state_46125__$1 = state_46125;
var statearr_46128_46179 = state_46125__$1;
(statearr_46128_46179[(2)] = null);

(statearr_46128_46179[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (1))){
var state_46125__$1 = state_46125;
var statearr_46129_46180 = state_46125__$1;
(statearr_46129_46180[(2)] = null);

(statearr_46129_46180[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (24))){
var inst_46104 = (state_46125[(7)]);
var inst_46113 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46104);
var state_46125__$1 = state_46125;
var statearr_46130_46181 = state_46125__$1;
(statearr_46130_46181[(2)] = inst_46113);

(statearr_46130_46181[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (4))){
var inst_46056 = (state_46125[(8)]);
var inst_46056__$1 = (state_46125[(2)]);
var inst_46057 = (inst_46056__$1 == null);
var state_46125__$1 = (function (){var statearr_46131 = state_46125;
(statearr_46131[(8)] = inst_46056__$1);

return statearr_46131;
})();
if(cljs.core.truth_(inst_46057)){
var statearr_46132_46182 = state_46125__$1;
(statearr_46132_46182[(1)] = (5));

} else {
var statearr_46133_46183 = state_46125__$1;
(statearr_46133_46183[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (15))){
var inst_46098 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46134_46184 = state_46125__$1;
(statearr_46134_46184[(2)] = inst_46098);

(statearr_46134_46184[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (21))){
var inst_46118 = (state_46125[(2)]);
var state_46125__$1 = (function (){var statearr_46135 = state_46125;
(statearr_46135[(9)] = inst_46118);

return statearr_46135;
})();
var statearr_46136_46185 = state_46125__$1;
(statearr_46136_46185[(2)] = null);

(statearr_46136_46185[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (13))){
var inst_46080 = (state_46125[(10)]);
var inst_46082 = cljs.core.chunked_seq_QMARK_(inst_46080);
var state_46125__$1 = state_46125;
if(inst_46082){
var statearr_46137_46186 = state_46125__$1;
(statearr_46137_46186[(1)] = (16));

} else {
var statearr_46138_46187 = state_46125__$1;
(statearr_46138_46187[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (22))){
var inst_46110 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
if(cljs.core.truth_(inst_46110)){
var statearr_46139_46188 = state_46125__$1;
(statearr_46139_46188[(1)] = (23));

} else {
var statearr_46140_46189 = state_46125__$1;
(statearr_46140_46189[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (6))){
var inst_46104 = (state_46125[(7)]);
var inst_46106 = (state_46125[(11)]);
var inst_46056 = (state_46125[(8)]);
var inst_46104__$1 = (function (){var G__46141 = inst_46056;
return (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(G__46141) : topic_fn.call(null,G__46141));
})();
var inst_46105 = (function (){var G__46142 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46142) : cljs.core.deref.call(null,G__46142));
})();
var inst_46106__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46105,inst_46104__$1);
var state_46125__$1 = (function (){var statearr_46143 = state_46125;
(statearr_46143[(7)] = inst_46104__$1);

(statearr_46143[(11)] = inst_46106__$1);

return statearr_46143;
})();
if(cljs.core.truth_(inst_46106__$1)){
var statearr_46144_46190 = state_46125__$1;
(statearr_46144_46190[(1)] = (19));

} else {
var statearr_46145_46191 = state_46125__$1;
(statearr_46145_46191[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (25))){
var inst_46115 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46146_46192 = state_46125__$1;
(statearr_46146_46192[(2)] = inst_46115);

(statearr_46146_46192[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (17))){
var inst_46080 = (state_46125[(10)]);
var inst_46089 = cljs.core.first(inst_46080);
var inst_46090 = cljs.core.async.muxch_STAR_(inst_46089);
var inst_46091 = cljs.core.async.close_BANG_(inst_46090);
var inst_46092 = cljs.core.next(inst_46080);
var inst_46066 = inst_46092;
var inst_46067 = null;
var inst_46068 = (0);
var inst_46069 = (0);
var state_46125__$1 = (function (){var statearr_46147 = state_46125;
(statearr_46147[(12)] = inst_46067);

(statearr_46147[(13)] = inst_46068);

(statearr_46147[(14)] = inst_46066);

(statearr_46147[(15)] = inst_46091);

(statearr_46147[(16)] = inst_46069);

return statearr_46147;
})();
var statearr_46148_46193 = state_46125__$1;
(statearr_46148_46193[(2)] = null);

(statearr_46148_46193[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (3))){
var inst_46123 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46125__$1,inst_46123);
} else {
if((state_val_46126 === (12))){
var inst_46100 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46149_46194 = state_46125__$1;
(statearr_46149_46194[(2)] = inst_46100);

(statearr_46149_46194[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (2))){
var state_46125__$1 = state_46125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46125__$1,(4),ch);
} else {
if((state_val_46126 === (23))){
var state_46125__$1 = state_46125;
var statearr_46150_46195 = state_46125__$1;
(statearr_46150_46195[(2)] = null);

(statearr_46150_46195[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (19))){
var inst_46106 = (state_46125[(11)]);
var inst_46056 = (state_46125[(8)]);
var inst_46108 = cljs.core.async.muxch_STAR_(inst_46106);
var state_46125__$1 = state_46125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46125__$1,(22),inst_46108,inst_46056);
} else {
if((state_val_46126 === (11))){
var inst_46066 = (state_46125[(14)]);
var inst_46080 = (state_46125[(10)]);
var inst_46080__$1 = cljs.core.seq(inst_46066);
var state_46125__$1 = (function (){var statearr_46151 = state_46125;
(statearr_46151[(10)] = inst_46080__$1);

return statearr_46151;
})();
if(inst_46080__$1){
var statearr_46152_46196 = state_46125__$1;
(statearr_46152_46196[(1)] = (13));

} else {
var statearr_46153_46197 = state_46125__$1;
(statearr_46153_46197[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (9))){
var inst_46102 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46154_46198 = state_46125__$1;
(statearr_46154_46198[(2)] = inst_46102);

(statearr_46154_46198[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (5))){
var inst_46063 = (function (){var G__46155 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46155) : cljs.core.deref.call(null,G__46155));
})();
var inst_46064 = cljs.core.vals(inst_46063);
var inst_46065 = cljs.core.seq(inst_46064);
var inst_46066 = inst_46065;
var inst_46067 = null;
var inst_46068 = (0);
var inst_46069 = (0);
var state_46125__$1 = (function (){var statearr_46156 = state_46125;
(statearr_46156[(12)] = inst_46067);

(statearr_46156[(13)] = inst_46068);

(statearr_46156[(14)] = inst_46066);

(statearr_46156[(16)] = inst_46069);

return statearr_46156;
})();
var statearr_46157_46199 = state_46125__$1;
(statearr_46157_46199[(2)] = null);

(statearr_46157_46199[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (14))){
var state_46125__$1 = state_46125;
var statearr_46161_46200 = state_46125__$1;
(statearr_46161_46200[(2)] = null);

(statearr_46161_46200[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (16))){
var inst_46080 = (state_46125[(10)]);
var inst_46084 = cljs.core.chunk_first(inst_46080);
var inst_46085 = cljs.core.chunk_rest(inst_46080);
var inst_46086 = cljs.core.count(inst_46084);
var inst_46066 = inst_46085;
var inst_46067 = inst_46084;
var inst_46068 = inst_46086;
var inst_46069 = (0);
var state_46125__$1 = (function (){var statearr_46162 = state_46125;
(statearr_46162[(12)] = inst_46067);

(statearr_46162[(13)] = inst_46068);

(statearr_46162[(14)] = inst_46066);

(statearr_46162[(16)] = inst_46069);

return statearr_46162;
})();
var statearr_46163_46201 = state_46125__$1;
(statearr_46163_46201[(2)] = null);

(statearr_46163_46201[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (10))){
var inst_46067 = (state_46125[(12)]);
var inst_46068 = (state_46125[(13)]);
var inst_46066 = (state_46125[(14)]);
var inst_46069 = (state_46125[(16)]);
var inst_46074 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_46067,inst_46069);
var inst_46075 = cljs.core.async.muxch_STAR_(inst_46074);
var inst_46076 = cljs.core.async.close_BANG_(inst_46075);
var inst_46077 = (inst_46069 + (1));
var tmp46158 = inst_46067;
var tmp46159 = inst_46068;
var tmp46160 = inst_46066;
var inst_46066__$1 = tmp46160;
var inst_46067__$1 = tmp46158;
var inst_46068__$1 = tmp46159;
var inst_46069__$1 = inst_46077;
var state_46125__$1 = (function (){var statearr_46164 = state_46125;
(statearr_46164[(12)] = inst_46067__$1);

(statearr_46164[(13)] = inst_46068__$1);

(statearr_46164[(14)] = inst_46066__$1);

(statearr_46164[(17)] = inst_46076);

(statearr_46164[(16)] = inst_46069__$1);

return statearr_46164;
})();
var statearr_46165_46202 = state_46125__$1;
(statearr_46165_46202[(2)] = null);

(statearr_46165_46202[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (18))){
var inst_46095 = (state_46125[(2)]);
var state_46125__$1 = state_46125;
var statearr_46166_46203 = state_46125__$1;
(statearr_46166_46203[(2)] = inst_46095);

(statearr_46166_46203[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46126 === (8))){
var inst_46068 = (state_46125[(13)]);
var inst_46069 = (state_46125[(16)]);
var inst_46071 = (inst_46069 < inst_46068);
var inst_46072 = inst_46071;
var state_46125__$1 = state_46125;
if(cljs.core.truth_(inst_46072)){
var statearr_46167_46204 = state_46125__$1;
(statearr_46167_46204[(1)] = (10));

} else {
var statearr_46168_46205 = state_46125__$1;
(statearr_46168_46205[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46177,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___46177,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46172[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46172[(1)] = (1));

return statearr_46172;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46125){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46125);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46173){if((e46173 instanceof Object)){
var ex__7651__auto__ = e46173;
var statearr_46174_46206 = state_46125;
(statearr_46174_46206[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46125);

return cljs.core.constant$keyword$recur;
} else {
throw e46173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46207 = state_46125;
state_46125 = G__46207;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46125){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46177,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_46175 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46175[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46177);

return statearr_46175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46177,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__46209 = arguments.length;
switch (G__46209) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__46212 = arguments.length;
switch (G__46212) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__46215 = arguments.length;
switch (G__46215) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__46216 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__46216) : cljs.core.atom.call(null,G__46216));
})();
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__7709__auto___46290 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_46255){
var state_val_46256 = (state_46255[(1)]);
if((state_val_46256 === (7))){
var state_46255__$1 = state_46255;
var statearr_46257_46291 = state_46255__$1;
(statearr_46257_46291[(2)] = null);

(statearr_46257_46291[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (1))){
var state_46255__$1 = state_46255;
var statearr_46258_46292 = state_46255__$1;
(statearr_46258_46292[(2)] = null);

(statearr_46258_46292[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (4))){
var inst_46219 = (state_46255[(7)]);
var inst_46221 = (inst_46219 < cnt);
var state_46255__$1 = state_46255;
if(cljs.core.truth_(inst_46221)){
var statearr_46259_46293 = state_46255__$1;
(statearr_46259_46293[(1)] = (6));

} else {
var statearr_46260_46294 = state_46255__$1;
(statearr_46260_46294[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (15))){
var inst_46251 = (state_46255[(2)]);
var state_46255__$1 = state_46255;
var statearr_46261_46295 = state_46255__$1;
(statearr_46261_46295[(2)] = inst_46251);

(statearr_46261_46295[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (13))){
var inst_46244 = cljs.core.async.close_BANG_(out);
var state_46255__$1 = state_46255;
var statearr_46262_46296 = state_46255__$1;
(statearr_46262_46296[(2)] = inst_46244);

(statearr_46262_46296[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (6))){
var state_46255__$1 = state_46255;
var statearr_46263_46297 = state_46255__$1;
(statearr_46263_46297[(2)] = null);

(statearr_46263_46297[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (3))){
var inst_46253 = (state_46255[(2)]);
var state_46255__$1 = state_46255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46255__$1,inst_46253);
} else {
if((state_val_46256 === (12))){
var inst_46241 = (state_46255[(8)]);
var inst_46241__$1 = (state_46255[(2)]);
var inst_46242 = cljs.core.some(cljs.core.nil_QMARK_,inst_46241__$1);
var state_46255__$1 = (function (){var statearr_46264 = state_46255;
(statearr_46264[(8)] = inst_46241__$1);

return statearr_46264;
})();
if(cljs.core.truth_(inst_46242)){
var statearr_46265_46298 = state_46255__$1;
(statearr_46265_46298[(1)] = (13));

} else {
var statearr_46266_46299 = state_46255__$1;
(statearr_46266_46299[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (2))){
var inst_46218 = (function (){var G__46267 = dctr;
var G__46268 = cnt;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__46267,G__46268) : cljs.core.reset_BANG_.call(null,G__46267,G__46268));
})();
var inst_46219 = (0);
var state_46255__$1 = (function (){var statearr_46269 = state_46255;
(statearr_46269[(9)] = inst_46218);

(statearr_46269[(7)] = inst_46219);

return statearr_46269;
})();
var statearr_46270_46300 = state_46255__$1;
(statearr_46270_46300[(2)] = null);

(statearr_46270_46300[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (11))){
var inst_46219 = (state_46255[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_46255,(10),Object,null,(9));
var inst_46228 = (function (){var G__46271 = inst_46219;
return (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(G__46271) : chs__$1.call(null,G__46271));
})();
var inst_46229 = (function (){var G__46272 = inst_46219;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__46272) : done.call(null,G__46272));
})();
var inst_46230 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46228,inst_46229);
var state_46255__$1 = state_46255;
var statearr_46273_46301 = state_46255__$1;
(statearr_46273_46301[(2)] = inst_46230);


cljs.core.async.impl.ioc_helpers.process_exception(state_46255__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (9))){
var inst_46219 = (state_46255[(7)]);
var inst_46232 = (state_46255[(2)]);
var inst_46233 = (inst_46219 + (1));
var inst_46219__$1 = inst_46233;
var state_46255__$1 = (function (){var statearr_46274 = state_46255;
(statearr_46274[(10)] = inst_46232);

(statearr_46274[(7)] = inst_46219__$1);

return statearr_46274;
})();
var statearr_46275_46302 = state_46255__$1;
(statearr_46275_46302[(2)] = null);

(statearr_46275_46302[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (5))){
var inst_46239 = (state_46255[(2)]);
var state_46255__$1 = (function (){var statearr_46276 = state_46255;
(statearr_46276[(11)] = inst_46239);

return statearr_46276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46255__$1,(12),dchan);
} else {
if((state_val_46256 === (14))){
var inst_46241 = (state_46255[(8)]);
var inst_46246 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46241);
var state_46255__$1 = state_46255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46255__$1,(16),out,inst_46246);
} else {
if((state_val_46256 === (16))){
var inst_46248 = (state_46255[(2)]);
var state_46255__$1 = (function (){var statearr_46277 = state_46255;
(statearr_46277[(12)] = inst_46248);

return statearr_46277;
})();
var statearr_46278_46303 = state_46255__$1;
(statearr_46278_46303[(2)] = null);

(statearr_46278_46303[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (10))){
var inst_46223 = (state_46255[(2)]);
var inst_46224 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46255__$1 = (function (){var statearr_46279 = state_46255;
(statearr_46279[(13)] = inst_46223);

return statearr_46279;
})();
var statearr_46280_46304 = state_46255__$1;
(statearr_46280_46304[(2)] = inst_46224);


cljs.core.async.impl.ioc_helpers.process_exception(state_46255__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46256 === (8))){
var inst_46237 = (state_46255[(2)]);
var state_46255__$1 = state_46255;
var statearr_46281_46305 = state_46255__$1;
(statearr_46281_46305[(2)] = inst_46237);

(statearr_46281_46305[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46285[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46285[(1)] = (1));

return statearr_46285;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46255){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46255);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46286){if((e46286 instanceof Object)){
var ex__7651__auto__ = e46286;
var statearr_46287_46306 = state_46255;
(statearr_46287_46306[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46255);

return cljs.core.constant$keyword$recur;
} else {
throw e46286;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46307 = state_46255;
state_46255 = G__46307;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_46288 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46288[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46290);

return statearr_46288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46290,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__46310 = arguments.length;
switch (G__46310) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___46365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46365,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46365,out){
return (function (state_46340){
var state_val_46341 = (state_46340[(1)]);
if((state_val_46341 === (7))){
var inst_46319 = (state_46340[(7)]);
var inst_46320 = (state_46340[(8)]);
var inst_46319__$1 = (state_46340[(2)]);
var inst_46320__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46319__$1,(0),null);
var inst_46321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46319__$1,(1),null);
var inst_46322 = (inst_46320__$1 == null);
var state_46340__$1 = (function (){var statearr_46342 = state_46340;
(statearr_46342[(9)] = inst_46321);

(statearr_46342[(7)] = inst_46319__$1);

(statearr_46342[(8)] = inst_46320__$1);

return statearr_46342;
})();
if(cljs.core.truth_(inst_46322)){
var statearr_46343_46366 = state_46340__$1;
(statearr_46343_46366[(1)] = (8));

} else {
var statearr_46344_46367 = state_46340__$1;
(statearr_46344_46367[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (1))){
var inst_46311 = cljs.core.vec(chs);
var inst_46312 = inst_46311;
var state_46340__$1 = (function (){var statearr_46345 = state_46340;
(statearr_46345[(10)] = inst_46312);

return statearr_46345;
})();
var statearr_46346_46368 = state_46340__$1;
(statearr_46346_46368[(2)] = null);

(statearr_46346_46368[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (4))){
var inst_46312 = (state_46340[(10)]);
var state_46340__$1 = state_46340;
return cljs.core.async.ioc_alts_BANG_(state_46340__$1,(7),inst_46312);
} else {
if((state_val_46341 === (6))){
var inst_46336 = (state_46340[(2)]);
var state_46340__$1 = state_46340;
var statearr_46347_46369 = state_46340__$1;
(statearr_46347_46369[(2)] = inst_46336);

(statearr_46347_46369[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (3))){
var inst_46338 = (state_46340[(2)]);
var state_46340__$1 = state_46340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46340__$1,inst_46338);
} else {
if((state_val_46341 === (2))){
var inst_46312 = (state_46340[(10)]);
var inst_46314 = cljs.core.count(inst_46312);
var inst_46315 = (inst_46314 > (0));
var state_46340__$1 = state_46340;
if(cljs.core.truth_(inst_46315)){
var statearr_46349_46370 = state_46340__$1;
(statearr_46349_46370[(1)] = (4));

} else {
var statearr_46350_46371 = state_46340__$1;
(statearr_46350_46371[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (11))){
var inst_46312 = (state_46340[(10)]);
var inst_46329 = (state_46340[(2)]);
var tmp46348 = inst_46312;
var inst_46312__$1 = tmp46348;
var state_46340__$1 = (function (){var statearr_46351 = state_46340;
(statearr_46351[(10)] = inst_46312__$1);

(statearr_46351[(11)] = inst_46329);

return statearr_46351;
})();
var statearr_46352_46372 = state_46340__$1;
(statearr_46352_46372[(2)] = null);

(statearr_46352_46372[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (9))){
var inst_46320 = (state_46340[(8)]);
var state_46340__$1 = state_46340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46340__$1,(11),out,inst_46320);
} else {
if((state_val_46341 === (5))){
var inst_46334 = cljs.core.async.close_BANG_(out);
var state_46340__$1 = state_46340;
var statearr_46353_46373 = state_46340__$1;
(statearr_46353_46373[(2)] = inst_46334);

(statearr_46353_46373[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (10))){
var inst_46332 = (state_46340[(2)]);
var state_46340__$1 = state_46340;
var statearr_46354_46374 = state_46340__$1;
(statearr_46354_46374[(2)] = inst_46332);

(statearr_46354_46374[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46341 === (8))){
var inst_46312 = (state_46340[(10)]);
var inst_46321 = (state_46340[(9)]);
var inst_46319 = (state_46340[(7)]);
var inst_46320 = (state_46340[(8)]);
var inst_46324 = (function (){var c = inst_46321;
var v = inst_46320;
var vec__46317 = inst_46319;
var cs = inst_46312;
return ((function (c,v,vec__46317,cs,inst_46312,inst_46321,inst_46319,inst_46320,state_val_46341,c__7709__auto___46365,out){
return (function (p1__46308_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46308_SHARP_);
});
;})(c,v,vec__46317,cs,inst_46312,inst_46321,inst_46319,inst_46320,state_val_46341,c__7709__auto___46365,out))
})();
var inst_46325 = cljs.core.filterv(inst_46324,inst_46312);
var inst_46312__$1 = inst_46325;
var state_46340__$1 = (function (){var statearr_46355 = state_46340;
(statearr_46355[(10)] = inst_46312__$1);

return statearr_46355;
})();
var statearr_46356_46375 = state_46340__$1;
(statearr_46356_46375[(2)] = null);

(statearr_46356_46375[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46365,out))
;
return ((function (switch__7647__auto__,c__7709__auto___46365,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46360 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46360[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46360[(1)] = (1));

return statearr_46360;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46340){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46340);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46361){if((e46361 instanceof Object)){
var ex__7651__auto__ = e46361;
var statearr_46362_46376 = state_46340;
(statearr_46362_46376[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46340);

return cljs.core.constant$keyword$recur;
} else {
throw e46361;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46377 = state_46340;
state_46340 = G__46377;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46365,out))
})();
var state__7711__auto__ = (function (){var statearr_46363 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46363[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46365);

return statearr_46363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46365,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__46379 = arguments.length;
switch (G__46379) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___46427 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46427,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46427,out){
return (function (state_46403){
var state_val_46404 = (state_46403[(1)]);
if((state_val_46404 === (7))){
var inst_46385 = (state_46403[(7)]);
var inst_46385__$1 = (state_46403[(2)]);
var inst_46386 = (inst_46385__$1 == null);
var inst_46387 = cljs.core.not(inst_46386);
var state_46403__$1 = (function (){var statearr_46405 = state_46403;
(statearr_46405[(7)] = inst_46385__$1);

return statearr_46405;
})();
if(inst_46387){
var statearr_46406_46428 = state_46403__$1;
(statearr_46406_46428[(1)] = (8));

} else {
var statearr_46407_46429 = state_46403__$1;
(statearr_46407_46429[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (1))){
var inst_46380 = (0);
var state_46403__$1 = (function (){var statearr_46408 = state_46403;
(statearr_46408[(8)] = inst_46380);

return statearr_46408;
})();
var statearr_46409_46430 = state_46403__$1;
(statearr_46409_46430[(2)] = null);

(statearr_46409_46430[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (4))){
var state_46403__$1 = state_46403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46403__$1,(7),ch);
} else {
if((state_val_46404 === (6))){
var inst_46398 = (state_46403[(2)]);
var state_46403__$1 = state_46403;
var statearr_46410_46431 = state_46403__$1;
(statearr_46410_46431[(2)] = inst_46398);

(statearr_46410_46431[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (3))){
var inst_46400 = (state_46403[(2)]);
var inst_46401 = cljs.core.async.close_BANG_(out);
var state_46403__$1 = (function (){var statearr_46411 = state_46403;
(statearr_46411[(9)] = inst_46400);

return statearr_46411;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46403__$1,inst_46401);
} else {
if((state_val_46404 === (2))){
var inst_46380 = (state_46403[(8)]);
var inst_46382 = (inst_46380 < n);
var state_46403__$1 = state_46403;
if(cljs.core.truth_(inst_46382)){
var statearr_46412_46432 = state_46403__$1;
(statearr_46412_46432[(1)] = (4));

} else {
var statearr_46413_46433 = state_46403__$1;
(statearr_46413_46433[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (11))){
var inst_46380 = (state_46403[(8)]);
var inst_46390 = (state_46403[(2)]);
var inst_46391 = (inst_46380 + (1));
var inst_46380__$1 = inst_46391;
var state_46403__$1 = (function (){var statearr_46414 = state_46403;
(statearr_46414[(10)] = inst_46390);

(statearr_46414[(8)] = inst_46380__$1);

return statearr_46414;
})();
var statearr_46415_46434 = state_46403__$1;
(statearr_46415_46434[(2)] = null);

(statearr_46415_46434[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (9))){
var state_46403__$1 = state_46403;
var statearr_46416_46435 = state_46403__$1;
(statearr_46416_46435[(2)] = null);

(statearr_46416_46435[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (5))){
var state_46403__$1 = state_46403;
var statearr_46417_46436 = state_46403__$1;
(statearr_46417_46436[(2)] = null);

(statearr_46417_46436[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (10))){
var inst_46395 = (state_46403[(2)]);
var state_46403__$1 = state_46403;
var statearr_46418_46437 = state_46403__$1;
(statearr_46418_46437[(2)] = inst_46395);

(statearr_46418_46437[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46404 === (8))){
var inst_46385 = (state_46403[(7)]);
var state_46403__$1 = state_46403;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46403__$1,(11),out,inst_46385);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46427,out))
;
return ((function (switch__7647__auto__,c__7709__auto___46427,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46422 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46422[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46422[(1)] = (1));

return statearr_46422;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46403){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46403);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46423){if((e46423 instanceof Object)){
var ex__7651__auto__ = e46423;
var statearr_46424_46438 = state_46403;
(statearr_46424_46438[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46403);

return cljs.core.constant$keyword$recur;
} else {
throw e46423;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46439 = state_46403;
state_46403 = G__46439;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46403){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46427,out))
})();
var state__7711__auto__ = (function (){var statearr_46425 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46427);

return statearr_46425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46427,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t46452 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t46452 = (function (ch,f,map_LT_,meta46453){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta46453 = meta46453;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t46455 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t46455 = (function (fn1,_,meta46453,map_LT_,f,ch,meta46456){
this.fn1 = fn1;
this._ = _;
this.meta46453 = meta46453;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta46456 = meta46456;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t46455.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t46455.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t46455.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__46440_SHARP_){
var G__46458 = (((p1__46440_SHARP_ == null))?null:(function (){var G__46459 = p1__46440_SHARP_;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46459) : self__.f.call(null,G__46459));
})());
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__46458) : f1.call(null,G__46458));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t46455.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_46457){
var self__ = this;
var _46457__$1 = this;
return self__.meta46456;
});})(___$1))
;

cljs.core.async.t46455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_46457,meta46456__$1){
var self__ = this;
var _46457__$1 = this;
return (new cljs.core.async.t46455(self__.fn1,self__._,self__.meta46453,self__.map_LT_,self__.f,self__.ch,meta46456__$1));
});})(___$1))
;

cljs.core.async.t46455.cljs$lang$type = true;

cljs.core.async.t46455.cljs$lang$ctorStr = "cljs.core.async/t46455";

cljs.core.async.t46455.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t46455");
});})(___$1))
;

cljs.core.async.__GT_t46455 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t46455(fn1__$1,___$2,meta46453__$1,map_LT___$1,f__$1,ch__$1,meta46456){
return (new cljs.core.async.t46455(fn1__$1,___$2,meta46453__$1,map_LT___$1,f__$1,ch__$1,meta46456));
});})(___$1))
;

}

return (new cljs.core.async.t46455(fn1,___$1,self__.meta46453,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !(((function (){var G__46460 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46460) : cljs.core.deref.call(null,G__46460));
})() == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__46461 = (function (){var G__46462 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__46462) : cljs.core.deref.call(null,G__46462));
})();
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46461) : self__.f.call(null,G__46461));
})());
} else {
return ret;
}
});

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t46452.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t46452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46454){
var self__ = this;
var _46454__$1 = this;
return self__.meta46453;
});

cljs.core.async.t46452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46454,meta46453__$1){
var self__ = this;
var _46454__$1 = this;
return (new cljs.core.async.t46452(self__.ch,self__.f,self__.map_LT_,meta46453__$1));
});

cljs.core.async.t46452.cljs$lang$type = true;

cljs.core.async.t46452.cljs$lang$ctorStr = "cljs.core.async/t46452";

cljs.core.async.t46452.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t46452");
});

cljs.core.async.__GT_t46452 = (function cljs$core$async$map_LT__$___GT_t46452(ch__$1,f__$1,map_LT___$1,meta46453){
return (new cljs.core.async.t46452(ch__$1,f__$1,map_LT___$1,meta46453));
});

}

return (new cljs.core.async.t46452(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t46467 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t46467 = (function (ch,f,map_GT_,meta46468){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta46468 = meta46468;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(function (){var G__46470 = val;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46470) : self__.f.call(null,G__46470));
})(),fn1);
});

cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t46467.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t46467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46469){
var self__ = this;
var _46469__$1 = this;
return self__.meta46468;
});

cljs.core.async.t46467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46469,meta46468__$1){
var self__ = this;
var _46469__$1 = this;
return (new cljs.core.async.t46467(self__.ch,self__.f,self__.map_GT_,meta46468__$1));
});

cljs.core.async.t46467.cljs$lang$type = true;

cljs.core.async.t46467.cljs$lang$ctorStr = "cljs.core.async/t46467";

cljs.core.async.t46467.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t46467");
});

cljs.core.async.__GT_t46467 = (function cljs$core$async$map_GT__$___GT_t46467(ch__$1,f__$1,map_GT___$1,meta46468){
return (new cljs.core.async.t46467(ch__$1,f__$1,map_GT___$1,meta46468));
});

}

return (new cljs.core.async.t46467(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t46475 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t46475 = (function (ch,p,filter_GT_,meta46476){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta46476 = meta46476;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__46478 = val;
return (self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(G__46478) : self__.p.call(null,G__46478));
})())){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t46475.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t46475.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46477){
var self__ = this;
var _46477__$1 = this;
return self__.meta46476;
});

cljs.core.async.t46475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46477,meta46476__$1){
var self__ = this;
var _46477__$1 = this;
return (new cljs.core.async.t46475(self__.ch,self__.p,self__.filter_GT_,meta46476__$1));
});

cljs.core.async.t46475.cljs$lang$type = true;

cljs.core.async.t46475.cljs$lang$ctorStr = "cljs.core.async/t46475";

cljs.core.async.t46475.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t46475");
});

cljs.core.async.__GT_t46475 = (function cljs$core$async$filter_GT__$___GT_t46475(ch__$1,p__$1,filter_GT___$1,meta46476){
return (new cljs.core.async.t46475(ch__$1,p__$1,filter_GT___$1,meta46476));
});

}

return (new cljs.core.async.t46475(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__46480 = arguments.length;
switch (G__46480) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___46524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46524,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46524,out){
return (function (state_46501){
var state_val_46502 = (state_46501[(1)]);
if((state_val_46502 === (7))){
var inst_46497 = (state_46501[(2)]);
var state_46501__$1 = state_46501;
var statearr_46503_46525 = state_46501__$1;
(statearr_46503_46525[(2)] = inst_46497);

(statearr_46503_46525[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (1))){
var state_46501__$1 = state_46501;
var statearr_46504_46526 = state_46501__$1;
(statearr_46504_46526[(2)] = null);

(statearr_46504_46526[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (4))){
var inst_46483 = (state_46501[(7)]);
var inst_46483__$1 = (state_46501[(2)]);
var inst_46484 = (inst_46483__$1 == null);
var state_46501__$1 = (function (){var statearr_46505 = state_46501;
(statearr_46505[(7)] = inst_46483__$1);

return statearr_46505;
})();
if(cljs.core.truth_(inst_46484)){
var statearr_46506_46527 = state_46501__$1;
(statearr_46506_46527[(1)] = (5));

} else {
var statearr_46507_46528 = state_46501__$1;
(statearr_46507_46528[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (6))){
var inst_46483 = (state_46501[(7)]);
var inst_46488 = (function (){var G__46508 = inst_46483;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__46508) : p.call(null,G__46508));
})();
var state_46501__$1 = state_46501;
if(cljs.core.truth_(inst_46488)){
var statearr_46509_46529 = state_46501__$1;
(statearr_46509_46529[(1)] = (8));

} else {
var statearr_46510_46530 = state_46501__$1;
(statearr_46510_46530[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (3))){
var inst_46499 = (state_46501[(2)]);
var state_46501__$1 = state_46501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46501__$1,inst_46499);
} else {
if((state_val_46502 === (2))){
var state_46501__$1 = state_46501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46501__$1,(4),ch);
} else {
if((state_val_46502 === (11))){
var inst_46491 = (state_46501[(2)]);
var state_46501__$1 = state_46501;
var statearr_46511_46531 = state_46501__$1;
(statearr_46511_46531[(2)] = inst_46491);

(statearr_46511_46531[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (9))){
var state_46501__$1 = state_46501;
var statearr_46512_46532 = state_46501__$1;
(statearr_46512_46532[(2)] = null);

(statearr_46512_46532[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (5))){
var inst_46486 = cljs.core.async.close_BANG_(out);
var state_46501__$1 = state_46501;
var statearr_46513_46533 = state_46501__$1;
(statearr_46513_46533[(2)] = inst_46486);

(statearr_46513_46533[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (10))){
var inst_46494 = (state_46501[(2)]);
var state_46501__$1 = (function (){var statearr_46514 = state_46501;
(statearr_46514[(8)] = inst_46494);

return statearr_46514;
})();
var statearr_46515_46534 = state_46501__$1;
(statearr_46515_46534[(2)] = null);

(statearr_46515_46534[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46502 === (8))){
var inst_46483 = (state_46501[(7)]);
var state_46501__$1 = state_46501;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46501__$1,(11),out,inst_46483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46524,out))
;
return ((function (switch__7647__auto__,c__7709__auto___46524,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46519 = [null,null,null,null,null,null,null,null,null];
(statearr_46519[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46519[(1)] = (1));

return statearr_46519;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46501){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46501);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46520){if((e46520 instanceof Object)){
var ex__7651__auto__ = e46520;
var statearr_46521_46535 = state_46501;
(statearr_46521_46535[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46501);

return cljs.core.constant$keyword$recur;
} else {
throw e46520;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46536 = state_46501;
state_46501 = G__46536;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46524,out))
})();
var state__7711__auto__ = (function (){var statearr_46522 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46522[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46524);

return statearr_46522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46524,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__46538 = arguments.length;
switch (G__46538) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_46706){
var state_val_46707 = (state_46706[(1)]);
if((state_val_46707 === (7))){
var inst_46702 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46708_46750 = state_46706__$1;
(statearr_46708_46750[(2)] = inst_46702);

(statearr_46708_46750[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (20))){
var inst_46672 = (state_46706[(7)]);
var inst_46683 = (state_46706[(2)]);
var inst_46684 = cljs.core.next(inst_46672);
var inst_46658 = inst_46684;
var inst_46659 = null;
var inst_46660 = (0);
var inst_46661 = (0);
var state_46706__$1 = (function (){var statearr_46709 = state_46706;
(statearr_46709[(8)] = inst_46658);

(statearr_46709[(9)] = inst_46660);

(statearr_46709[(10)] = inst_46661);

(statearr_46709[(11)] = inst_46659);

(statearr_46709[(12)] = inst_46683);

return statearr_46709;
})();
var statearr_46710_46751 = state_46706__$1;
(statearr_46710_46751[(2)] = null);

(statearr_46710_46751[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (1))){
var state_46706__$1 = state_46706;
var statearr_46711_46752 = state_46706__$1;
(statearr_46711_46752[(2)] = null);

(statearr_46711_46752[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (4))){
var inst_46647 = (state_46706[(13)]);
var inst_46647__$1 = (state_46706[(2)]);
var inst_46648 = (inst_46647__$1 == null);
var state_46706__$1 = (function (){var statearr_46712 = state_46706;
(statearr_46712[(13)] = inst_46647__$1);

return statearr_46712;
})();
if(cljs.core.truth_(inst_46648)){
var statearr_46713_46753 = state_46706__$1;
(statearr_46713_46753[(1)] = (5));

} else {
var statearr_46714_46754 = state_46706__$1;
(statearr_46714_46754[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (15))){
var state_46706__$1 = state_46706;
var statearr_46718_46755 = state_46706__$1;
(statearr_46718_46755[(2)] = null);

(statearr_46718_46755[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (21))){
var state_46706__$1 = state_46706;
var statearr_46719_46756 = state_46706__$1;
(statearr_46719_46756[(2)] = null);

(statearr_46719_46756[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (13))){
var inst_46658 = (state_46706[(8)]);
var inst_46660 = (state_46706[(9)]);
var inst_46661 = (state_46706[(10)]);
var inst_46659 = (state_46706[(11)]);
var inst_46668 = (state_46706[(2)]);
var inst_46669 = (inst_46661 + (1));
var tmp46715 = inst_46658;
var tmp46716 = inst_46660;
var tmp46717 = inst_46659;
var inst_46658__$1 = tmp46715;
var inst_46659__$1 = tmp46717;
var inst_46660__$1 = tmp46716;
var inst_46661__$1 = inst_46669;
var state_46706__$1 = (function (){var statearr_46720 = state_46706;
(statearr_46720[(8)] = inst_46658__$1);

(statearr_46720[(9)] = inst_46660__$1);

(statearr_46720[(14)] = inst_46668);

(statearr_46720[(10)] = inst_46661__$1);

(statearr_46720[(11)] = inst_46659__$1);

return statearr_46720;
})();
var statearr_46721_46757 = state_46706__$1;
(statearr_46721_46757[(2)] = null);

(statearr_46721_46757[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (22))){
var state_46706__$1 = state_46706;
var statearr_46722_46758 = state_46706__$1;
(statearr_46722_46758[(2)] = null);

(statearr_46722_46758[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (6))){
var inst_46647 = (state_46706[(13)]);
var inst_46656 = (function (){var G__46723 = inst_46647;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__46723) : f.call(null,G__46723));
})();
var inst_46657 = cljs.core.seq(inst_46656);
var inst_46658 = inst_46657;
var inst_46659 = null;
var inst_46660 = (0);
var inst_46661 = (0);
var state_46706__$1 = (function (){var statearr_46724 = state_46706;
(statearr_46724[(8)] = inst_46658);

(statearr_46724[(9)] = inst_46660);

(statearr_46724[(10)] = inst_46661);

(statearr_46724[(11)] = inst_46659);

return statearr_46724;
})();
var statearr_46725_46759 = state_46706__$1;
(statearr_46725_46759[(2)] = null);

(statearr_46725_46759[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (17))){
var inst_46672 = (state_46706[(7)]);
var inst_46676 = cljs.core.chunk_first(inst_46672);
var inst_46677 = cljs.core.chunk_rest(inst_46672);
var inst_46678 = cljs.core.count(inst_46676);
var inst_46658 = inst_46677;
var inst_46659 = inst_46676;
var inst_46660 = inst_46678;
var inst_46661 = (0);
var state_46706__$1 = (function (){var statearr_46726 = state_46706;
(statearr_46726[(8)] = inst_46658);

(statearr_46726[(9)] = inst_46660);

(statearr_46726[(10)] = inst_46661);

(statearr_46726[(11)] = inst_46659);

return statearr_46726;
})();
var statearr_46727_46760 = state_46706__$1;
(statearr_46727_46760[(2)] = null);

(statearr_46727_46760[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (3))){
var inst_46704 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46706__$1,inst_46704);
} else {
if((state_val_46707 === (12))){
var inst_46692 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46728_46761 = state_46706__$1;
(statearr_46728_46761[(2)] = inst_46692);

(statearr_46728_46761[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (2))){
var state_46706__$1 = state_46706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46706__$1,(4),in$);
} else {
if((state_val_46707 === (23))){
var inst_46700 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46729_46762 = state_46706__$1;
(statearr_46729_46762[(2)] = inst_46700);

(statearr_46729_46762[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (19))){
var inst_46687 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46730_46763 = state_46706__$1;
(statearr_46730_46763[(2)] = inst_46687);

(statearr_46730_46763[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (11))){
var inst_46658 = (state_46706[(8)]);
var inst_46672 = (state_46706[(7)]);
var inst_46672__$1 = cljs.core.seq(inst_46658);
var state_46706__$1 = (function (){var statearr_46731 = state_46706;
(statearr_46731[(7)] = inst_46672__$1);

return statearr_46731;
})();
if(inst_46672__$1){
var statearr_46732_46764 = state_46706__$1;
(statearr_46732_46764[(1)] = (14));

} else {
var statearr_46733_46765 = state_46706__$1;
(statearr_46733_46765[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (9))){
var inst_46694 = (state_46706[(2)]);
var inst_46695 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46706__$1 = (function (){var statearr_46734 = state_46706;
(statearr_46734[(15)] = inst_46694);

return statearr_46734;
})();
if(cljs.core.truth_(inst_46695)){
var statearr_46735_46766 = state_46706__$1;
(statearr_46735_46766[(1)] = (21));

} else {
var statearr_46736_46767 = state_46706__$1;
(statearr_46736_46767[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (5))){
var inst_46650 = cljs.core.async.close_BANG_(out);
var state_46706__$1 = state_46706;
var statearr_46737_46768 = state_46706__$1;
(statearr_46737_46768[(2)] = inst_46650);

(statearr_46737_46768[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (14))){
var inst_46672 = (state_46706[(7)]);
var inst_46674 = cljs.core.chunked_seq_QMARK_(inst_46672);
var state_46706__$1 = state_46706;
if(inst_46674){
var statearr_46738_46769 = state_46706__$1;
(statearr_46738_46769[(1)] = (17));

} else {
var statearr_46739_46770 = state_46706__$1;
(statearr_46739_46770[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (16))){
var inst_46690 = (state_46706[(2)]);
var state_46706__$1 = state_46706;
var statearr_46740_46771 = state_46706__$1;
(statearr_46740_46771[(2)] = inst_46690);

(statearr_46740_46771[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46707 === (10))){
var inst_46661 = (state_46706[(10)]);
var inst_46659 = (state_46706[(11)]);
var inst_46666 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_46659,inst_46661);
var state_46706__$1 = state_46706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46706__$1,(13),out,inst_46666);
} else {
if((state_val_46707 === (18))){
var inst_46672 = (state_46706[(7)]);
var inst_46681 = cljs.core.first(inst_46672);
var state_46706__$1 = state_46706;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46706__$1,(20),out,inst_46681);
} else {
if((state_val_46707 === (8))){
var inst_46660 = (state_46706[(9)]);
var inst_46661 = (state_46706[(10)]);
var inst_46663 = (inst_46661 < inst_46660);
var inst_46664 = inst_46663;
var state_46706__$1 = state_46706;
if(cljs.core.truth_(inst_46664)){
var statearr_46741_46772 = state_46706__$1;
(statearr_46741_46772[(1)] = (10));

} else {
var statearr_46742_46773 = state_46706__$1;
(statearr_46742_46773[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_46746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46746[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_46746[(1)] = (1));

return statearr_46746;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_46706){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46706);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46747){if((e46747 instanceof Object)){
var ex__7651__auto__ = e46747;
var statearr_46748_46774 = state_46706;
(statearr_46748_46774[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46706);

return cljs.core.constant$keyword$recur;
} else {
throw e46747;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46775 = state_46706;
state_46706 = G__46775;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_46706){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_46706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_46749 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_46749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__46777 = arguments.length;
switch (G__46777) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__46780 = arguments.length;
switch (G__46780) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__46783 = arguments.length;
switch (G__46783) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___46833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46833,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46833,out){
return (function (state_46807){
var state_val_46808 = (state_46807[(1)]);
if((state_val_46808 === (7))){
var inst_46802 = (state_46807[(2)]);
var state_46807__$1 = state_46807;
var statearr_46809_46834 = state_46807__$1;
(statearr_46809_46834[(2)] = inst_46802);

(statearr_46809_46834[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (1))){
var inst_46784 = null;
var state_46807__$1 = (function (){var statearr_46810 = state_46807;
(statearr_46810[(7)] = inst_46784);

return statearr_46810;
})();
var statearr_46811_46835 = state_46807__$1;
(statearr_46811_46835[(2)] = null);

(statearr_46811_46835[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (4))){
var inst_46787 = (state_46807[(8)]);
var inst_46787__$1 = (state_46807[(2)]);
var inst_46788 = (inst_46787__$1 == null);
var inst_46789 = cljs.core.not(inst_46788);
var state_46807__$1 = (function (){var statearr_46812 = state_46807;
(statearr_46812[(8)] = inst_46787__$1);

return statearr_46812;
})();
if(inst_46789){
var statearr_46813_46836 = state_46807__$1;
(statearr_46813_46836[(1)] = (5));

} else {
var statearr_46814_46837 = state_46807__$1;
(statearr_46814_46837[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (6))){
var state_46807__$1 = state_46807;
var statearr_46815_46838 = state_46807__$1;
(statearr_46815_46838[(2)] = null);

(statearr_46815_46838[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (3))){
var inst_46804 = (state_46807[(2)]);
var inst_46805 = cljs.core.async.close_BANG_(out);
var state_46807__$1 = (function (){var statearr_46816 = state_46807;
(statearr_46816[(9)] = inst_46804);

return statearr_46816;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46807__$1,inst_46805);
} else {
if((state_val_46808 === (2))){
var state_46807__$1 = state_46807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46807__$1,(4),ch);
} else {
if((state_val_46808 === (11))){
var inst_46787 = (state_46807[(8)]);
var inst_46796 = (state_46807[(2)]);
var inst_46784 = inst_46787;
var state_46807__$1 = (function (){var statearr_46817 = state_46807;
(statearr_46817[(10)] = inst_46796);

(statearr_46817[(7)] = inst_46784);

return statearr_46817;
})();
var statearr_46818_46839 = state_46807__$1;
(statearr_46818_46839[(2)] = null);

(statearr_46818_46839[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (9))){
var inst_46787 = (state_46807[(8)]);
var state_46807__$1 = state_46807;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46807__$1,(11),out,inst_46787);
} else {
if((state_val_46808 === (5))){
var inst_46787 = (state_46807[(8)]);
var inst_46784 = (state_46807[(7)]);
var inst_46791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46787,inst_46784);
var state_46807__$1 = state_46807;
if(inst_46791){
var statearr_46820_46840 = state_46807__$1;
(statearr_46820_46840[(1)] = (8));

} else {
var statearr_46821_46841 = state_46807__$1;
(statearr_46821_46841[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (10))){
var inst_46799 = (state_46807[(2)]);
var state_46807__$1 = state_46807;
var statearr_46822_46842 = state_46807__$1;
(statearr_46822_46842[(2)] = inst_46799);

(statearr_46822_46842[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46808 === (8))){
var inst_46784 = (state_46807[(7)]);
var tmp46819 = inst_46784;
var inst_46784__$1 = tmp46819;
var state_46807__$1 = (function (){var statearr_46823 = state_46807;
(statearr_46823[(7)] = inst_46784__$1);

return statearr_46823;
})();
var statearr_46824_46843 = state_46807__$1;
(statearr_46824_46843[(2)] = null);

(statearr_46824_46843[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46833,out))
;
return ((function (switch__7647__auto__,c__7709__auto___46833,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46828 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46828[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46828[(1)] = (1));

return statearr_46828;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46807){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46807);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46829){if((e46829 instanceof Object)){
var ex__7651__auto__ = e46829;
var statearr_46830_46844 = state_46807;
(statearr_46830_46844[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46807);

return cljs.core.constant$keyword$recur;
} else {
throw e46829;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46845 = state_46807;
state_46807 = G__46845;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46807){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46833,out))
})();
var state__7711__auto__ = (function (){var statearr_46831 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46831[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46833);

return statearr_46831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46833,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__46847 = arguments.length;
switch (G__46847) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___46916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___46916,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___46916,out){
return (function (state_46885){
var state_val_46886 = (state_46885[(1)]);
if((state_val_46886 === (7))){
var inst_46881 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46887_46917 = state_46885__$1;
(statearr_46887_46917[(2)] = inst_46881);

(statearr_46887_46917[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (1))){
var inst_46848 = (new Array(n));
var inst_46849 = inst_46848;
var inst_46850 = (0);
var state_46885__$1 = (function (){var statearr_46888 = state_46885;
(statearr_46888[(7)] = inst_46849);

(statearr_46888[(8)] = inst_46850);

return statearr_46888;
})();
var statearr_46889_46918 = state_46885__$1;
(statearr_46889_46918[(2)] = null);

(statearr_46889_46918[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (4))){
var inst_46853 = (state_46885[(9)]);
var inst_46853__$1 = (state_46885[(2)]);
var inst_46854 = (inst_46853__$1 == null);
var inst_46855 = cljs.core.not(inst_46854);
var state_46885__$1 = (function (){var statearr_46890 = state_46885;
(statearr_46890[(9)] = inst_46853__$1);

return statearr_46890;
})();
if(inst_46855){
var statearr_46891_46919 = state_46885__$1;
(statearr_46891_46919[(1)] = (5));

} else {
var statearr_46892_46920 = state_46885__$1;
(statearr_46892_46920[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (15))){
var inst_46875 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46893_46921 = state_46885__$1;
(statearr_46893_46921[(2)] = inst_46875);

(statearr_46893_46921[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (13))){
var state_46885__$1 = state_46885;
var statearr_46894_46922 = state_46885__$1;
(statearr_46894_46922[(2)] = null);

(statearr_46894_46922[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (6))){
var inst_46850 = (state_46885[(8)]);
var inst_46871 = (inst_46850 > (0));
var state_46885__$1 = state_46885;
if(cljs.core.truth_(inst_46871)){
var statearr_46895_46923 = state_46885__$1;
(statearr_46895_46923[(1)] = (12));

} else {
var statearr_46896_46924 = state_46885__$1;
(statearr_46896_46924[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (3))){
var inst_46883 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46885__$1,inst_46883);
} else {
if((state_val_46886 === (12))){
var inst_46849 = (state_46885[(7)]);
var inst_46873 = cljs.core.vec(inst_46849);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46885__$1,(15),out,inst_46873);
} else {
if((state_val_46886 === (2))){
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46885__$1,(4),ch);
} else {
if((state_val_46886 === (11))){
var inst_46865 = (state_46885[(2)]);
var inst_46866 = (new Array(n));
var inst_46849 = inst_46866;
var inst_46850 = (0);
var state_46885__$1 = (function (){var statearr_46897 = state_46885;
(statearr_46897[(7)] = inst_46849);

(statearr_46897[(10)] = inst_46865);

(statearr_46897[(8)] = inst_46850);

return statearr_46897;
})();
var statearr_46898_46925 = state_46885__$1;
(statearr_46898_46925[(2)] = null);

(statearr_46898_46925[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (9))){
var inst_46849 = (state_46885[(7)]);
var inst_46863 = cljs.core.vec(inst_46849);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46885__$1,(11),out,inst_46863);
} else {
if((state_val_46886 === (5))){
var inst_46853 = (state_46885[(9)]);
var inst_46849 = (state_46885[(7)]);
var inst_46858 = (state_46885[(11)]);
var inst_46850 = (state_46885[(8)]);
var inst_46857 = (inst_46849[inst_46850] = inst_46853);
var inst_46858__$1 = (inst_46850 + (1));
var inst_46859 = (inst_46858__$1 < n);
var state_46885__$1 = (function (){var statearr_46899 = state_46885;
(statearr_46899[(12)] = inst_46857);

(statearr_46899[(11)] = inst_46858__$1);

return statearr_46899;
})();
if(cljs.core.truth_(inst_46859)){
var statearr_46900_46926 = state_46885__$1;
(statearr_46900_46926[(1)] = (8));

} else {
var statearr_46901_46927 = state_46885__$1;
(statearr_46901_46927[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (14))){
var inst_46878 = (state_46885[(2)]);
var inst_46879 = cljs.core.async.close_BANG_(out);
var state_46885__$1 = (function (){var statearr_46903 = state_46885;
(statearr_46903[(13)] = inst_46878);

return statearr_46903;
})();
var statearr_46904_46928 = state_46885__$1;
(statearr_46904_46928[(2)] = inst_46879);

(statearr_46904_46928[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (10))){
var inst_46869 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46905_46929 = state_46885__$1;
(statearr_46905_46929[(2)] = inst_46869);

(statearr_46905_46929[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46886 === (8))){
var inst_46849 = (state_46885[(7)]);
var inst_46858 = (state_46885[(11)]);
var tmp46902 = inst_46849;
var inst_46849__$1 = tmp46902;
var inst_46850 = inst_46858;
var state_46885__$1 = (function (){var statearr_46906 = state_46885;
(statearr_46906[(7)] = inst_46849__$1);

(statearr_46906[(8)] = inst_46850);

return statearr_46906;
})();
var statearr_46907_46930 = state_46885__$1;
(statearr_46907_46930[(2)] = null);

(statearr_46907_46930[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___46916,out))
;
return ((function (switch__7647__auto__,c__7709__auto___46916,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_46911 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46911[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_46911[(1)] = (1));

return statearr_46911;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46885){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46885);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e46912){if((e46912 instanceof Object)){
var ex__7651__auto__ = e46912;
var statearr_46913_46931 = state_46885;
(statearr_46913_46931[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46885);

return cljs.core.constant$keyword$recur;
} else {
throw e46912;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__46932 = state_46885;
state_46885 = G__46932;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46885){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___46916,out))
})();
var state__7711__auto__ = (function (){var statearr_46914 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_46914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___46916);

return statearr_46914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___46916,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__46934 = arguments.length;
switch (G__46934) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___47008 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___47008,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___47008,out){
return (function (state_46976){
var state_val_46977 = (state_46976[(1)]);
if((state_val_46977 === (7))){
var inst_46972 = (state_46976[(2)]);
var state_46976__$1 = state_46976;
var statearr_46978_47009 = state_46976__$1;
(statearr_46978_47009[(2)] = inst_46972);

(statearr_46978_47009[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (1))){
var inst_46935 = [];
var inst_46936 = inst_46935;
var inst_46937 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_46976__$1 = (function (){var statearr_46979 = state_46976;
(statearr_46979[(7)] = inst_46937);

(statearr_46979[(8)] = inst_46936);

return statearr_46979;
})();
var statearr_46980_47010 = state_46976__$1;
(statearr_46980_47010[(2)] = null);

(statearr_46980_47010[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (4))){
var inst_46940 = (state_46976[(9)]);
var inst_46940__$1 = (state_46976[(2)]);
var inst_46941 = (inst_46940__$1 == null);
var inst_46942 = cljs.core.not(inst_46941);
var state_46976__$1 = (function (){var statearr_46981 = state_46976;
(statearr_46981[(9)] = inst_46940__$1);

return statearr_46981;
})();
if(inst_46942){
var statearr_46982_47011 = state_46976__$1;
(statearr_46982_47011[(1)] = (5));

} else {
var statearr_46983_47012 = state_46976__$1;
(statearr_46983_47012[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (15))){
var inst_46966 = (state_46976[(2)]);
var state_46976__$1 = state_46976;
var statearr_46984_47013 = state_46976__$1;
(statearr_46984_47013[(2)] = inst_46966);

(statearr_46984_47013[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (13))){
var state_46976__$1 = state_46976;
var statearr_46985_47014 = state_46976__$1;
(statearr_46985_47014[(2)] = null);

(statearr_46985_47014[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (6))){
var inst_46936 = (state_46976[(8)]);
var inst_46961 = inst_46936.length;
var inst_46962 = (inst_46961 > (0));
var state_46976__$1 = state_46976;
if(cljs.core.truth_(inst_46962)){
var statearr_46986_47015 = state_46976__$1;
(statearr_46986_47015[(1)] = (12));

} else {
var statearr_46987_47016 = state_46976__$1;
(statearr_46987_47016[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (3))){
var inst_46974 = (state_46976[(2)]);
var state_46976__$1 = state_46976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46976__$1,inst_46974);
} else {
if((state_val_46977 === (12))){
var inst_46936 = (state_46976[(8)]);
var inst_46964 = cljs.core.vec(inst_46936);
var state_46976__$1 = state_46976;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46976__$1,(15),out,inst_46964);
} else {
if((state_val_46977 === (2))){
var state_46976__$1 = state_46976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46976__$1,(4),ch);
} else {
if((state_val_46977 === (11))){
var inst_46940 = (state_46976[(9)]);
var inst_46944 = (state_46976[(10)]);
var inst_46954 = (state_46976[(2)]);
var inst_46955 = [];
var inst_46956 = inst_46955.push(inst_46940);
var inst_46936 = inst_46955;
var inst_46937 = inst_46944;
var state_46976__$1 = (function (){var statearr_46988 = state_46976;
(statearr_46988[(7)] = inst_46937);

(statearr_46988[(11)] = inst_46954);

(statearr_46988[(12)] = inst_46956);

(statearr_46988[(8)] = inst_46936);

return statearr_46988;
})();
var statearr_46989_47017 = state_46976__$1;
(statearr_46989_47017[(2)] = null);

(statearr_46989_47017[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (9))){
var inst_46936 = (state_46976[(8)]);
var inst_46952 = cljs.core.vec(inst_46936);
var state_46976__$1 = state_46976;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46976__$1,(11),out,inst_46952);
} else {
if((state_val_46977 === (5))){
var inst_46937 = (state_46976[(7)]);
var inst_46940 = (state_46976[(9)]);
var inst_46944 = (state_46976[(10)]);
var inst_46944__$1 = (function (){var G__46990 = inst_46940;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__46990) : f.call(null,G__46990));
})();
var inst_46945 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46944__$1,inst_46937);
var inst_46946 = cljs.core.keyword_identical_QMARK_(inst_46937,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_46947 = (inst_46945) || (inst_46946);
var state_46976__$1 = (function (){var statearr_46991 = state_46976;
(statearr_46991[(10)] = inst_46944__$1);

return statearr_46991;
})();
if(cljs.core.truth_(inst_46947)){
var statearr_46992_47018 = state_46976__$1;
(statearr_46992_47018[(1)] = (8));

} else {
var statearr_46993_47019 = state_46976__$1;
(statearr_46993_47019[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (14))){
var inst_46969 = (state_46976[(2)]);
var inst_46970 = cljs.core.async.close_BANG_(out);
var state_46976__$1 = (function (){var statearr_46995 = state_46976;
(statearr_46995[(13)] = inst_46969);

return statearr_46995;
})();
var statearr_46996_47020 = state_46976__$1;
(statearr_46996_47020[(2)] = inst_46970);

(statearr_46996_47020[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (10))){
var inst_46959 = (state_46976[(2)]);
var state_46976__$1 = state_46976;
var statearr_46997_47021 = state_46976__$1;
(statearr_46997_47021[(2)] = inst_46959);

(statearr_46997_47021[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_46977 === (8))){
var inst_46940 = (state_46976[(9)]);
var inst_46944 = (state_46976[(10)]);
var inst_46936 = (state_46976[(8)]);
var inst_46949 = inst_46936.push(inst_46940);
var tmp46994 = inst_46936;
var inst_46936__$1 = tmp46994;
var inst_46937 = inst_46944;
var state_46976__$1 = (function (){var statearr_46998 = state_46976;
(statearr_46998[(7)] = inst_46937);

(statearr_46998[(14)] = inst_46949);

(statearr_46998[(8)] = inst_46936__$1);

return statearr_46998;
})();
var statearr_46999_47022 = state_46976__$1;
(statearr_46999_47022[(2)] = null);

(statearr_46999_47022[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___47008,out))
;
return ((function (switch__7647__auto__,c__7709__auto___47008,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_47003 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47003[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_47003[(1)] = (1));

return statearr_47003;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_46976){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_46976);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e47004){if((e47004 instanceof Object)){
var ex__7651__auto__ = e47004;
var statearr_47005_47023 = state_46976;
(statearr_47005_47023[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46976);

return cljs.core.constant$keyword$recur;
} else {
throw e47004;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__47024 = state_46976;
state_46976 = G__47024;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_46976){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_46976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___47008,out))
})();
var state__7711__auto__ = (function (){var statearr_47006 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_47006[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___47008);

return statearr_47006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___47008,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
