// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like(elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like(elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like(elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__42673 = arguments.length;
switch (G__42673) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__42674 = dommy.template.__GT_node_like(parent);
G__42674.appendChild(dommy.template.__GT_node_like(child));

return G__42674;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__42675_42680 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__42676_42681 = null;
var count__42677_42682 = (0);
var i__42678_42683 = (0);
while(true){
if((i__42678_42683 < count__42677_42682)){
var c_42684 = chunk__42676_42681.cljs$core$IIndexed$_nth$arity$2(null,i__42678_42683);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_42684);

var G__42685 = seq__42675_42680;
var G__42686 = chunk__42676_42681;
var G__42687 = count__42677_42682;
var G__42688 = (i__42678_42683 + (1));
seq__42675_42680 = G__42685;
chunk__42676_42681 = G__42686;
count__42677_42682 = G__42687;
i__42678_42683 = G__42688;
continue;
} else {
var temp__4126__auto___42689 = cljs.core.seq(seq__42675_42680);
if(temp__4126__auto___42689){
var seq__42675_42690__$1 = temp__4126__auto___42689;
if(cljs.core.chunked_seq_QMARK_(seq__42675_42690__$1)){
var c__5061__auto___42691 = cljs.core.chunk_first(seq__42675_42690__$1);
var G__42692 = cljs.core.chunk_rest(seq__42675_42690__$1);
var G__42693 = c__5061__auto___42691;
var G__42694 = cljs.core.count(c__5061__auto___42691);
var G__42695 = (0);
seq__42675_42680 = G__42692;
chunk__42676_42681 = G__42693;
count__42677_42682 = G__42694;
i__42678_42683 = G__42695;
continue;
} else {
var c_42696 = cljs.core.first(seq__42675_42690__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_42696);

var G__42697 = cljs.core.next(seq__42675_42690__$1);
var G__42698 = null;
var G__42699 = (0);
var G__42700 = (0);
seq__42675_42680 = G__42697;
chunk__42676_42681 = G__42698;
count__42677_42682 = G__42699;
i__42678_42683 = G__42700;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq42669){
var G__42670 = cljs.core.first(seq42669);
var seq42669__$1 = cljs.core.next(seq42669);
var G__42671 = cljs.core.first(seq42669__$1);
var seq42669__$2 = cljs.core.next(seq42669__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42670,G__42671,seq42669__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__42705 = arguments.length;
switch (G__42705) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like(parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like(child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__42706_42711 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__42707_42712 = null;
var count__42708_42713 = (0);
var i__42709_42714 = (0);
while(true){
if((i__42709_42714 < count__42708_42713)){
var c_42715 = chunk__42707_42712.cljs$core$IIndexed$_nth$arity$2(null,i__42709_42714);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_42715);

var G__42716 = seq__42706_42711;
var G__42717 = chunk__42707_42712;
var G__42718 = count__42708_42713;
var G__42719 = (i__42709_42714 + (1));
seq__42706_42711 = G__42716;
chunk__42707_42712 = G__42717;
count__42708_42713 = G__42718;
i__42709_42714 = G__42719;
continue;
} else {
var temp__4126__auto___42720 = cljs.core.seq(seq__42706_42711);
if(temp__4126__auto___42720){
var seq__42706_42721__$1 = temp__4126__auto___42720;
if(cljs.core.chunked_seq_QMARK_(seq__42706_42721__$1)){
var c__5061__auto___42722 = cljs.core.chunk_first(seq__42706_42721__$1);
var G__42723 = cljs.core.chunk_rest(seq__42706_42721__$1);
var G__42724 = c__5061__auto___42722;
var G__42725 = cljs.core.count(c__5061__auto___42722);
var G__42726 = (0);
seq__42706_42711 = G__42723;
chunk__42707_42712 = G__42724;
count__42708_42713 = G__42725;
i__42709_42714 = G__42726;
continue;
} else {
var c_42727 = cljs.core.first(seq__42706_42721__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_42727);

var G__42728 = cljs.core.next(seq__42706_42721__$1);
var G__42729 = null;
var G__42730 = (0);
var G__42731 = (0);
seq__42706_42711 = G__42728;
chunk__42707_42712 = G__42729;
count__42708_42713 = G__42730;
i__42709_42714 = G__42731;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq42701){
var G__42702 = cljs.core.first(seq42701);
var seq42701__$1 = cljs.core.next(seq42701);
var G__42703 = cljs.core.first(seq42701__$1);
var seq42701__$2 = cljs.core.next(seq42701__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42702,G__42703,seq42701__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))], 0)))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
var parent = other__$1.parentNode;
var temp__4124__auto___42732 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___42732)){
var next_42733 = temp__4124__auto___42732;
parent.insertBefore(actual_node,next_42733);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like(new$);
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))], 0)))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__42735 = dommy.template.__GT_node_like(parent);
G__42735.innerHTML = "";

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(G__42735,node_like);

return G__42735;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
var G__42737 = elem__$1.parentNode;
G__42737.removeChild(elem__$1);

return G__42737;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like(elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like(template);
if(!(cljs.core.contains_QMARK_(key_selectors_map,cljs.core.constant$keyword$container))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),cljs.core.constant$keyword$container))], 0)))].join('')));
}

return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$container,container], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (container){
return (function (p__42743){
var vec__42744 = p__42743;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42744,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42744,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(cljs.core.constant$keyword$live.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))?(function (){
if(typeof dommy.core.t42745 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t42745 = (function (v,k,vec__42744,p__42743,container,key_selectors_map,template,selector_map,meta42746){
this.v = v;
this.k = k;
this.vec__42744 = vec__42744;
this.p__42743 = p__42743;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta42746 = meta42746;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t42745.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__42744,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array(dommy.template.__GT_node_like(self__.container).querySelectorAll(dommy.core.selector(self__.v)));
});})(vec__42744,k,v,container))
;

dommy.core.t42745.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__42744,k,v,container){
return (function (_42747){
var self__ = this;
var _42747__$1 = this;
return self__.meta42746;
});})(vec__42744,k,v,container))
;

dommy.core.t42745.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__42744,k,v,container){
return (function (_42747,meta42746__$1){
var self__ = this;
var _42747__$1 = this;
return (new dommy.core.t42745(self__.v,self__.k,self__.vec__42744,self__.p__42743,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta42746__$1));
});})(vec__42744,k,v,container))
;

dommy.core.t42745.cljs$lang$type = true;

dommy.core.t42745.cljs$lang$ctorStr = "dommy.core/t42745";

dommy.core.t42745.cljs$lang$ctorPrWriter = ((function (vec__42744,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"dommy.core/t42745");
});})(vec__42744,k,v,container))
;

dommy.core.__GT_t42745 = ((function (vec__42744,k,v,container){
return (function dommy$core$selector_map_$___GT_t42745(v__$1,k__$1,vec__42744__$1,p__42743__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta42746){
return (new dommy.core.t42745(v__$1,k__$1,vec__42744__$1,p__42743__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta42746));
});})(vec__42744,k,v,container))
;

}

return (new dommy.core.t42745(v,k,vec__42744,p__42743,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like(container).querySelector(dommy.core.selector(v)))], null);
});})(container))
,key_selectors_map))], 0));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate((function (p1__42748_SHARP_){
return p1__42748_SHARP_.parentNode;
}),dommy.template.__GT_node_like(elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__42750 = arguments.length;
switch (G__42750) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(dommy.template.__GT_node_like(dommy.template.__GT_node_like(base)).querySelectorAll(dommy.core.selector(selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__42754 = arguments.length;
switch (G__42754) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like(base);
var elem__$1 = dommy.template.__GT_node_like(elem);
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base__$1,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (base__$1,elem__$1){
return (function (p1__42752_SHARP_){
return !((p1__42752_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes(elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1(selector),dommy.core.ancestor_nodes(dommy.template.__GT_node_like(elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like(descendant);
var ancestor__$1 = dommy.template.__GT_node_like(ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__42756){
var vec__42757 = p__42756;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42757,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42757,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__42757,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__42757,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
var G__42758 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__42758) : f.call(null,G__42758));
}
});
;})(vec__42757,special_mouse_event,real_mouse_event))
});})(vec__42757,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$mouseenter,cljs.core.constant$keyword$mouseover,cljs.core.constant$keyword$mouseleave,cljs.core.constant$keyword$mouseout], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not((function (){var G__42762 = selected_target;
var G__42763 = cljs.core.constant$keyword$disabled;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42762,G__42763) : dommy.core.attr.call(null,G__42762,G__42763));
})());
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

var G__42764 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__42764) : f.call(null,G__42764));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like(elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like(elem);
return elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq42765){
var G__42766 = cljs.core.first(seq42765);
var seq42765__$1 = cljs.core.next(seq42765);
var G__42767 = cljs.core.first(seq42765__$1);
var seq42765__$2 = cljs.core.next(seq42765__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42766,G__42767,seq42765__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((function (p1__42768_SHARP_){
return dommy.template.__GT_node_like(cljs.core.first(p1__42768_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like(elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__42771_42798 = dommy.core.elem_and_selector(elem_sel);
var elem_42799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42771_42798,(0),null);
var selector_42800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42771_42798,(1),null);
var seq__42772_42801 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__42779_42802 = null;
var count__42780_42803 = (0);
var i__42781_42804 = (0);
while(true){
if((i__42781_42804 < count__42780_42803)){
var vec__42788_42805 = chunk__42779_42802.cljs$core$IIndexed$_nth$arity$2(null,i__42781_42804);
var orig_type_42806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42788_42805,(0),null);
var f_42807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42788_42805,(1),null);
var seq__42782_42808 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_42806,new cljs.core.PersistentArrayMap.fromArray([orig_type_42806,cljs.core.identity], true, false)));
var chunk__42784_42809 = null;
var count__42785_42810 = (0);
var i__42786_42811 = (0);
while(true){
if((i__42786_42811 < count__42785_42810)){
var vec__42789_42812 = chunk__42784_42809.cljs$core$IIndexed$_nth$arity$2(null,i__42786_42811);
var actual_type_42813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42789_42812,(0),null);
var factory_42814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42789_42812,(1),null);
var canonical_f_42815 = (cljs.core.truth_(selector_42800)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_42799,selector_42800):cljs.core.identity).call(null,(function (){var G__42790 = f_42807;
return (factory_42814.cljs$core$IFn$_invoke$arity$1 ? factory_42814.cljs$core$IFn$_invoke$arity$1(G__42790) : factory_42814.call(null,G__42790));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42799,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42800,actual_type_42813,f_42807], null),canonical_f_42815], 0));

if(cljs.core.truth_(elem_42799.addEventListener)){
elem_42799.addEventListener(cljs.core.name(actual_type_42813),canonical_f_42815);
} else {
elem_42799.attachEvent(cljs.core.name(actual_type_42813),canonical_f_42815);
}

var G__42816 = seq__42782_42808;
var G__42817 = chunk__42784_42809;
var G__42818 = count__42785_42810;
var G__42819 = (i__42786_42811 + (1));
seq__42782_42808 = G__42816;
chunk__42784_42809 = G__42817;
count__42785_42810 = G__42818;
i__42786_42811 = G__42819;
continue;
} else {
var temp__4126__auto___42820 = cljs.core.seq(seq__42782_42808);
if(temp__4126__auto___42820){
var seq__42782_42821__$1 = temp__4126__auto___42820;
if(cljs.core.chunked_seq_QMARK_(seq__42782_42821__$1)){
var c__5061__auto___42822 = cljs.core.chunk_first(seq__42782_42821__$1);
var G__42823 = cljs.core.chunk_rest(seq__42782_42821__$1);
var G__42824 = c__5061__auto___42822;
var G__42825 = cljs.core.count(c__5061__auto___42822);
var G__42826 = (0);
seq__42782_42808 = G__42823;
chunk__42784_42809 = G__42824;
count__42785_42810 = G__42825;
i__42786_42811 = G__42826;
continue;
} else {
var vec__42791_42827 = cljs.core.first(seq__42782_42821__$1);
var actual_type_42828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42791_42827,(0),null);
var factory_42829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42791_42827,(1),null);
var canonical_f_42830 = (cljs.core.truth_(selector_42800)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_42799,selector_42800):cljs.core.identity).call(null,(function (){var G__42792 = f_42807;
return (factory_42829.cljs$core$IFn$_invoke$arity$1 ? factory_42829.cljs$core$IFn$_invoke$arity$1(G__42792) : factory_42829.call(null,G__42792));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42799,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42800,actual_type_42828,f_42807], null),canonical_f_42830], 0));

if(cljs.core.truth_(elem_42799.addEventListener)){
elem_42799.addEventListener(cljs.core.name(actual_type_42828),canonical_f_42830);
} else {
elem_42799.attachEvent(cljs.core.name(actual_type_42828),canonical_f_42830);
}

var G__42831 = cljs.core.next(seq__42782_42821__$1);
var G__42832 = null;
var G__42833 = (0);
var G__42834 = (0);
seq__42782_42808 = G__42831;
chunk__42784_42809 = G__42832;
count__42785_42810 = G__42833;
i__42786_42811 = G__42834;
continue;
}
} else {
}
}
break;
}

var G__42835 = seq__42772_42801;
var G__42836 = chunk__42779_42802;
var G__42837 = count__42780_42803;
var G__42838 = (i__42781_42804 + (1));
seq__42772_42801 = G__42835;
chunk__42779_42802 = G__42836;
count__42780_42803 = G__42837;
i__42781_42804 = G__42838;
continue;
} else {
var temp__4126__auto___42839 = cljs.core.seq(seq__42772_42801);
if(temp__4126__auto___42839){
var seq__42772_42840__$1 = temp__4126__auto___42839;
if(cljs.core.chunked_seq_QMARK_(seq__42772_42840__$1)){
var c__5061__auto___42841 = cljs.core.chunk_first(seq__42772_42840__$1);
var G__42842 = cljs.core.chunk_rest(seq__42772_42840__$1);
var G__42843 = c__5061__auto___42841;
var G__42844 = cljs.core.count(c__5061__auto___42841);
var G__42845 = (0);
seq__42772_42801 = G__42842;
chunk__42779_42802 = G__42843;
count__42780_42803 = G__42844;
i__42781_42804 = G__42845;
continue;
} else {
var vec__42793_42846 = cljs.core.first(seq__42772_42840__$1);
var orig_type_42847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42793_42846,(0),null);
var f_42848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42793_42846,(1),null);
var seq__42773_42849 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_42847,new cljs.core.PersistentArrayMap.fromArray([orig_type_42847,cljs.core.identity], true, false)));
var chunk__42775_42850 = null;
var count__42776_42851 = (0);
var i__42777_42852 = (0);
while(true){
if((i__42777_42852 < count__42776_42851)){
var vec__42794_42853 = chunk__42775_42850.cljs$core$IIndexed$_nth$arity$2(null,i__42777_42852);
var actual_type_42854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42794_42853,(0),null);
var factory_42855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42794_42853,(1),null);
var canonical_f_42856 = (cljs.core.truth_(selector_42800)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_42799,selector_42800):cljs.core.identity).call(null,(function (){var G__42795 = f_42848;
return (factory_42855.cljs$core$IFn$_invoke$arity$1 ? factory_42855.cljs$core$IFn$_invoke$arity$1(G__42795) : factory_42855.call(null,G__42795));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42799,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42800,actual_type_42854,f_42848], null),canonical_f_42856], 0));

if(cljs.core.truth_(elem_42799.addEventListener)){
elem_42799.addEventListener(cljs.core.name(actual_type_42854),canonical_f_42856);
} else {
elem_42799.attachEvent(cljs.core.name(actual_type_42854),canonical_f_42856);
}

var G__42857 = seq__42773_42849;
var G__42858 = chunk__42775_42850;
var G__42859 = count__42776_42851;
var G__42860 = (i__42777_42852 + (1));
seq__42773_42849 = G__42857;
chunk__42775_42850 = G__42858;
count__42776_42851 = G__42859;
i__42777_42852 = G__42860;
continue;
} else {
var temp__4126__auto___42861__$1 = cljs.core.seq(seq__42773_42849);
if(temp__4126__auto___42861__$1){
var seq__42773_42862__$1 = temp__4126__auto___42861__$1;
if(cljs.core.chunked_seq_QMARK_(seq__42773_42862__$1)){
var c__5061__auto___42863 = cljs.core.chunk_first(seq__42773_42862__$1);
var G__42864 = cljs.core.chunk_rest(seq__42773_42862__$1);
var G__42865 = c__5061__auto___42863;
var G__42866 = cljs.core.count(c__5061__auto___42863);
var G__42867 = (0);
seq__42773_42849 = G__42864;
chunk__42775_42850 = G__42865;
count__42776_42851 = G__42866;
i__42777_42852 = G__42867;
continue;
} else {
var vec__42796_42868 = cljs.core.first(seq__42773_42862__$1);
var actual_type_42869 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42796_42868,(0),null);
var factory_42870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42796_42868,(1),null);
var canonical_f_42871 = (cljs.core.truth_(selector_42800)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_42799,selector_42800):cljs.core.identity).call(null,(function (){var G__42797 = f_42848;
return (factory_42870.cljs$core$IFn$_invoke$arity$1 ? factory_42870.cljs$core$IFn$_invoke$arity$1(G__42797) : factory_42870.call(null,G__42797));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42799,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42800,actual_type_42869,f_42848], null),canonical_f_42871], 0));

if(cljs.core.truth_(elem_42799.addEventListener)){
elem_42799.addEventListener(cljs.core.name(actual_type_42869),canonical_f_42871);
} else {
elem_42799.attachEvent(cljs.core.name(actual_type_42869),canonical_f_42871);
}

var G__42872 = cljs.core.next(seq__42773_42862__$1);
var G__42873 = null;
var G__42874 = (0);
var G__42875 = (0);
seq__42773_42849 = G__42872;
chunk__42775_42850 = G__42873;
count__42776_42851 = G__42874;
i__42777_42852 = G__42875;
continue;
}
} else {
}
}
break;
}

var G__42876 = cljs.core.next(seq__42772_42840__$1);
var G__42877 = null;
var G__42878 = (0);
var G__42879 = (0);
seq__42772_42801 = G__42876;
chunk__42779_42802 = G__42877;
count__42780_42803 = G__42878;
i__42781_42804 = G__42879;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq42769){
var G__42770 = cljs.core.first(seq42769);
var seq42769__$1 = cljs.core.next(seq42769);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42770,seq42769__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__42882_42905 = dommy.core.elem_and_selector(elem_sel);
var elem_42906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42882_42905,(0),null);
var selector_42907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42882_42905,(1),null);
var seq__42883_42908 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__42890_42909 = null;
var count__42891_42910 = (0);
var i__42892_42911 = (0);
while(true){
if((i__42892_42911 < count__42891_42910)){
var vec__42899_42912 = chunk__42890_42909.cljs$core$IIndexed$_nth$arity$2(null,i__42892_42911);
var orig_type_42913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42899_42912,(0),null);
var f_42914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42899_42912,(1),null);
var seq__42893_42915 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_42913,new cljs.core.PersistentArrayMap.fromArray([orig_type_42913,cljs.core.identity], true, false)));
var chunk__42895_42916 = null;
var count__42896_42917 = (0);
var i__42897_42918 = (0);
while(true){
if((i__42897_42918 < count__42896_42917)){
var vec__42900_42919 = chunk__42895_42916.cljs$core$IIndexed$_nth$arity$2(null,i__42897_42918);
var actual_type_42920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42900_42919,(0),null);
var __42921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42900_42919,(1),null);
var keys_42922 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42907,actual_type_42920,f_42914], null);
var canonical_f_42923 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_42906),keys_42922);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42906,dommy.utils.dissoc_in,cljs.core.array_seq([keys_42922], 0));

if(cljs.core.truth_(elem_42906.removeEventListener)){
elem_42906.removeEventListener(cljs.core.name(actual_type_42920),canonical_f_42923);
} else {
elem_42906.detachEvent(cljs.core.name(actual_type_42920),canonical_f_42923);
}

var G__42924 = seq__42893_42915;
var G__42925 = chunk__42895_42916;
var G__42926 = count__42896_42917;
var G__42927 = (i__42897_42918 + (1));
seq__42893_42915 = G__42924;
chunk__42895_42916 = G__42925;
count__42896_42917 = G__42926;
i__42897_42918 = G__42927;
continue;
} else {
var temp__4126__auto___42928 = cljs.core.seq(seq__42893_42915);
if(temp__4126__auto___42928){
var seq__42893_42929__$1 = temp__4126__auto___42928;
if(cljs.core.chunked_seq_QMARK_(seq__42893_42929__$1)){
var c__5061__auto___42930 = cljs.core.chunk_first(seq__42893_42929__$1);
var G__42931 = cljs.core.chunk_rest(seq__42893_42929__$1);
var G__42932 = c__5061__auto___42930;
var G__42933 = cljs.core.count(c__5061__auto___42930);
var G__42934 = (0);
seq__42893_42915 = G__42931;
chunk__42895_42916 = G__42932;
count__42896_42917 = G__42933;
i__42897_42918 = G__42934;
continue;
} else {
var vec__42901_42935 = cljs.core.first(seq__42893_42929__$1);
var actual_type_42936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42901_42935,(0),null);
var __42937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42901_42935,(1),null);
var keys_42938 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42907,actual_type_42936,f_42914], null);
var canonical_f_42939 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_42906),keys_42938);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42906,dommy.utils.dissoc_in,cljs.core.array_seq([keys_42938], 0));

if(cljs.core.truth_(elem_42906.removeEventListener)){
elem_42906.removeEventListener(cljs.core.name(actual_type_42936),canonical_f_42939);
} else {
elem_42906.detachEvent(cljs.core.name(actual_type_42936),canonical_f_42939);
}

var G__42940 = cljs.core.next(seq__42893_42929__$1);
var G__42941 = null;
var G__42942 = (0);
var G__42943 = (0);
seq__42893_42915 = G__42940;
chunk__42895_42916 = G__42941;
count__42896_42917 = G__42942;
i__42897_42918 = G__42943;
continue;
}
} else {
}
}
break;
}

var G__42944 = seq__42883_42908;
var G__42945 = chunk__42890_42909;
var G__42946 = count__42891_42910;
var G__42947 = (i__42892_42911 + (1));
seq__42883_42908 = G__42944;
chunk__42890_42909 = G__42945;
count__42891_42910 = G__42946;
i__42892_42911 = G__42947;
continue;
} else {
var temp__4126__auto___42948 = cljs.core.seq(seq__42883_42908);
if(temp__4126__auto___42948){
var seq__42883_42949__$1 = temp__4126__auto___42948;
if(cljs.core.chunked_seq_QMARK_(seq__42883_42949__$1)){
var c__5061__auto___42950 = cljs.core.chunk_first(seq__42883_42949__$1);
var G__42951 = cljs.core.chunk_rest(seq__42883_42949__$1);
var G__42952 = c__5061__auto___42950;
var G__42953 = cljs.core.count(c__5061__auto___42950);
var G__42954 = (0);
seq__42883_42908 = G__42951;
chunk__42890_42909 = G__42952;
count__42891_42910 = G__42953;
i__42892_42911 = G__42954;
continue;
} else {
var vec__42902_42955 = cljs.core.first(seq__42883_42949__$1);
var orig_type_42956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42902_42955,(0),null);
var f_42957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42902_42955,(1),null);
var seq__42884_42958 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_42956,new cljs.core.PersistentArrayMap.fromArray([orig_type_42956,cljs.core.identity], true, false)));
var chunk__42886_42959 = null;
var count__42887_42960 = (0);
var i__42888_42961 = (0);
while(true){
if((i__42888_42961 < count__42887_42960)){
var vec__42903_42962 = chunk__42886_42959.cljs$core$IIndexed$_nth$arity$2(null,i__42888_42961);
var actual_type_42963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42903_42962,(0),null);
var __42964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42903_42962,(1),null);
var keys_42965 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42907,actual_type_42963,f_42957], null);
var canonical_f_42966 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_42906),keys_42965);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42906,dommy.utils.dissoc_in,cljs.core.array_seq([keys_42965], 0));

if(cljs.core.truth_(elem_42906.removeEventListener)){
elem_42906.removeEventListener(cljs.core.name(actual_type_42963),canonical_f_42966);
} else {
elem_42906.detachEvent(cljs.core.name(actual_type_42963),canonical_f_42966);
}

var G__42967 = seq__42884_42958;
var G__42968 = chunk__42886_42959;
var G__42969 = count__42887_42960;
var G__42970 = (i__42888_42961 + (1));
seq__42884_42958 = G__42967;
chunk__42886_42959 = G__42968;
count__42887_42960 = G__42969;
i__42888_42961 = G__42970;
continue;
} else {
var temp__4126__auto___42971__$1 = cljs.core.seq(seq__42884_42958);
if(temp__4126__auto___42971__$1){
var seq__42884_42972__$1 = temp__4126__auto___42971__$1;
if(cljs.core.chunked_seq_QMARK_(seq__42884_42972__$1)){
var c__5061__auto___42973 = cljs.core.chunk_first(seq__42884_42972__$1);
var G__42974 = cljs.core.chunk_rest(seq__42884_42972__$1);
var G__42975 = c__5061__auto___42973;
var G__42976 = cljs.core.count(c__5061__auto___42973);
var G__42977 = (0);
seq__42884_42958 = G__42974;
chunk__42886_42959 = G__42975;
count__42887_42960 = G__42976;
i__42888_42961 = G__42977;
continue;
} else {
var vec__42904_42978 = cljs.core.first(seq__42884_42972__$1);
var actual_type_42979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42904_42978,(0),null);
var __42980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42904_42978,(1),null);
var keys_42981 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_42907,actual_type_42979,f_42957], null);
var canonical_f_42982 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_42906),keys_42981);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_42906,dommy.utils.dissoc_in,cljs.core.array_seq([keys_42981], 0));

if(cljs.core.truth_(elem_42906.removeEventListener)){
elem_42906.removeEventListener(cljs.core.name(actual_type_42979),canonical_f_42982);
} else {
elem_42906.detachEvent(cljs.core.name(actual_type_42979),canonical_f_42982);
}

var G__42983 = cljs.core.next(seq__42884_42972__$1);
var G__42984 = null;
var G__42985 = (0);
var G__42986 = (0);
seq__42884_42958 = G__42983;
chunk__42886_42959 = G__42984;
count__42887_42960 = G__42985;
i__42888_42961 = G__42986;
continue;
}
} else {
}
}
break;
}

var G__42987 = cljs.core.next(seq__42883_42949__$1);
var G__42988 = null;
var G__42989 = (0);
var G__42990 = (0);
seq__42883_42908 = G__42987;
chunk__42890_42909 = G__42988;
count__42891_42910 = G__42989;
i__42892_42911 = G__42990;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq42880){
var G__42881 = cljs.core.first(seq42880);
var seq42880__$1 = cljs.core.next(seq42880);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42881,seq42880__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__42993_43004 = dommy.core.elem_and_selector(elem_sel);
var elem_43005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42993_43004,(0),null);
var selector_43006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42993_43004,(1),null);
var seq__42994_43007 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__42995_43008 = null;
var count__42996_43009 = (0);
var i__42997_43010 = (0);
while(true){
if((i__42997_43010 < count__42996_43009)){
var vec__42998_43011 = chunk__42995_43008.cljs$core$IIndexed$_nth$arity$2(null,i__42997_43010);
var type_43012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42998_43011,(0),null);
var f_43013 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42998_43011,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_43012,((function (seq__42994_43007,chunk__42995_43008,count__42996_43009,i__42997_43010,vec__42998_43011,type_43012,f_43013,vec__42993_43004,elem_43005,selector_43006){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_43012,dommy$core$this_fn], 0));

var G__43000 = e;
return (f_43013.cljs$core$IFn$_invoke$arity$1 ? f_43013.cljs$core$IFn$_invoke$arity$1(G__43000) : f_43013.call(null,G__43000));
});})(seq__42994_43007,chunk__42995_43008,count__42996_43009,i__42997_43010,vec__42998_43011,type_43012,f_43013,vec__42993_43004,elem_43005,selector_43006))
], 0));

var G__43014 = seq__42994_43007;
var G__43015 = chunk__42995_43008;
var G__43016 = count__42996_43009;
var G__43017 = (i__42997_43010 + (1));
seq__42994_43007 = G__43014;
chunk__42995_43008 = G__43015;
count__42996_43009 = G__43016;
i__42997_43010 = G__43017;
continue;
} else {
var temp__4126__auto___43018 = cljs.core.seq(seq__42994_43007);
if(temp__4126__auto___43018){
var seq__42994_43019__$1 = temp__4126__auto___43018;
if(cljs.core.chunked_seq_QMARK_(seq__42994_43019__$1)){
var c__5061__auto___43020 = cljs.core.chunk_first(seq__42994_43019__$1);
var G__43021 = cljs.core.chunk_rest(seq__42994_43019__$1);
var G__43022 = c__5061__auto___43020;
var G__43023 = cljs.core.count(c__5061__auto___43020);
var G__43024 = (0);
seq__42994_43007 = G__43021;
chunk__42995_43008 = G__43022;
count__42996_43009 = G__43023;
i__42997_43010 = G__43024;
continue;
} else {
var vec__43001_43025 = cljs.core.first(seq__42994_43019__$1);
var type_43026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43001_43025,(0),null);
var f_43027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43001_43025,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_43026,((function (seq__42994_43007,chunk__42995_43008,count__42996_43009,i__42997_43010,vec__43001_43025,type_43026,f_43027,seq__42994_43019__$1,temp__4126__auto___43018,vec__42993_43004,elem_43005,selector_43006){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_43026,dommy$core$this_fn], 0));

var G__43003 = e;
return (f_43027.cljs$core$IFn$_invoke$arity$1 ? f_43027.cljs$core$IFn$_invoke$arity$1(G__43003) : f_43027.call(null,G__43003));
});})(seq__42994_43007,chunk__42995_43008,count__42996_43009,i__42997_43010,vec__43001_43025,type_43026,f_43027,seq__42994_43019__$1,temp__4126__auto___43018,vec__42993_43004,elem_43005,selector_43006))
], 0));

var G__43028 = cljs.core.next(seq__42994_43019__$1);
var G__43029 = null;
var G__43030 = (0);
var G__43031 = (0);
seq__42994_43007 = G__43028;
chunk__42995_43008 = G__43029;
count__42996_43009 = G__43030;
i__42997_43010 = G__43031;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq42991){
var G__42992 = cljs.core.first(seq42991);
var seq42991__$1 = cljs.core.next(seq42991);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42992,seq42991__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__43035){
var vec__43036 = p__43035;
var update_event_BANG_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43036,(0),null);
if(dommy.core.descendant_QMARK_(node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))], 0)))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name(event_type),true,true);

return node.dispatchEvent((function (){var G__43037 = event;
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__43037) : update_event_BANG___$1.call(null,G__43037));
})());
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name(event_type))].join(''),(function (){var G__43038 = document.createEventObject();
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__43038) : update_event_BANG___$1.call(null,G__43038));
})());
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq43032){
var G__43033 = cljs.core.first(seq43032);
var seq43032__$1 = cljs.core.next(seq43032);
var G__43034 = cljs.core.first(seq43032__$1);
var seq43032__$2 = cljs.core.next(seq43032__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__43033,G__43034,seq43032__$2);
});
