// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(account,params){
var url = (function (){var G__42532 = "dataviews";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42532) : milia.api.io.make_url.call(null,G__42532));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,options);
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.show = (function milia$api$dataview$show(account,dataview_id){
var url = (function (){var G__42535 = "dataviews";
var G__42536 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42535,G__42536) : milia.api.io.make_url.call(null,G__42535,G__42536));
})();
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Retrieves dataview data using dataview id
 */
milia.api.dataview.data = (function milia$api$dataview$data(account,dataview_id){
var url = (function (){var G__42540 = "dataviews";
var G__42541 = dataview_id;
var G__42542 = "data.json";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42540,G__42541,G__42542) : milia.api.io.make_url.call(null,G__42540,G__42541,G__42542));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$raw_DASH_response_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(account,dataview_id){
var url = (function (){var G__42546 = "dataviews";
var G__42547 = dataview_id;
var G__42548 = "data";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42546,G__42547,G__42548) : milia.api.io.make_url.call(null,G__42546,G__42547,G__42548));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(account){
var url = (function (){var G__42550 = "dataviews";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42550) : milia.api.io.make_url.call(null,G__42550));
})();
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(account,dataview_id,params){
var url = (function (){var G__42553 = "dataviews";
var G__42554 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42553,G__42554) : milia.api.io.make_url.call(null,G__42553,G__42554));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,options);
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(account,dataview_id){
var url = (function (){var G__42557 = "dataviews";
var G__42558 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42557,G__42558) : milia.api.io.make_url.call(null,G__42557,G__42558));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$delete,url,account);
});
