// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__4264__auto__ = v;
if(cljs.core.truth_(and__4264__auto__)){
return (v > (0));
} else {
return and__4264__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__44107_SHARP_,p2__44106_SHARP_){
var vec__44109 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__44106_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44109,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44109,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44107_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = (function (){var G__44111 = url;
return goog.Uri.parse(G__44111);
})();
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44112_SHARP_){
return cljs_http.client.encode_val(k,p1__44112_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__44113){
var vec__44115 = p__44113;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44115,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44115,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__44116_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__44116_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__4264__auto__){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__44119 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44119) : client.call(null,G__44119));
} else {
var G__44120 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44120) : client.call(null,G__44120));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7709__auto___44159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44159,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44159,channel){
return (function (state_44148){
var state_val_44149 = (state_44148[(1)]);
if((state_val_44149 === (2))){
var inst_44142 = (state_44148[(2)]);
var inst_44143 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_44144 = cljs_http.client.decode_body(inst_44142,cljs.reader.read_string,"application/edn",inst_44143);
var inst_44145 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_44144);
var inst_44146 = cljs.core.async.close_BANG_(channel);
var state_44148__$1 = (function (){var statearr_44150 = state_44148;
(statearr_44150[(7)] = inst_44145);

return statearr_44150;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44148__$1,inst_44146);
} else {
if((state_val_44149 === (1))){
var inst_44140 = (function (){var G__44151 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44151) : client.call(null,G__44151));
})();
var state_44148__$1 = state_44148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44148__$1,(2),inst_44140);
} else {
return null;
}
}
});})(c__7709__auto___44159,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___44159,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0 = (function (){
var statearr_44155 = [null,null,null,null,null,null,null,null];
(statearr_44155[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__);

(statearr_44155[(1)] = (1));

return statearr_44155;
});
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1 = (function (state_44148){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44148);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44156){if((e44156 instanceof Object)){
var ex__7651__auto__ = e44156;
var statearr_44157_44160 = state_44148;
(statearr_44157_44160[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44148);

return cljs.core.constant$keyword$recur;
} else {
throw e44156;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44161 = state_44148;
state_44148 = G__44161;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = function(state_44148){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1.call(this,state_44148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44159,channel))
})();
var state__7711__auto__ = (function (){var statearr_44158 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44158[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44159);

return statearr_44158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44159,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__44164){
var vec__44165 = p__44164;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44165,(0),null);
return ((function (vec__44165,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
var G__44166 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44166) : client.call(null,G__44166));
} else {
var G__44167 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44167) : client.call(null,G__44167));
}
});
;})(vec__44165,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq44162){
var G__44163 = cljs.core.first(seq44162);
var seq44162__$1 = cljs.core.next(seq44162);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__44163,seq44162__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__44170){
var vec__44171 = p__44170;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44171,(0),null);
return ((function (vec__44171,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
var G__44172 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44172) : client.call(null,G__44172));
} else {
var G__44173 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44173) : client.call(null,G__44173));
}
});
;})(vec__44171,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq44168){
var G__44169 = cljs.core.first(seq44168);
var seq44168__$1 = cljs.core.next(seq44168);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__44169,seq44168__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__44177 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__44177__$1 = ((cljs.core.seq_QMARK_(map__44177))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44177):map__44177);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44177__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44177__$1,cljs.core.constant$keyword$encoding);
var G__44178 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44178) : client.call(null,G__44178));
} else {
var G__44179 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44179) : client.call(null,G__44179));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var map__44202 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__44202__$1 = ((cljs.core.seq_QMARK_(map__44202))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44202):map__44202);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44202__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44202__$1,cljs.core.constant$keyword$decoding);
var c__7709__auto___44223 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding){
return (function (state_44212){
var state_val_44213 = (state_44212[(1)]);
if((state_val_44213 === (2))){
var inst_44205 = (state_44212[(2)]);
var inst_44206 = (function (){var response = inst_44205;
return ((function (response,inst_44205,state_val_44213,c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding){
return (function (p1__44180_SHARP_){
return cljs_http.util.transit_decode(p1__44180_SHARP_,decoding,decoding_opts);
});
;})(response,inst_44205,state_val_44213,c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding))
})();
var inst_44207 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_44208 = cljs_http.client.decode_body(inst_44205,inst_44206,"application/transit+json",inst_44207);
var inst_44209 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_44208);
var inst_44210 = cljs.core.async.close_BANG_(channel);
var state_44212__$1 = (function (){var statearr_44214 = state_44212;
(statearr_44214[(7)] = inst_44209);

return statearr_44214;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44212__$1,inst_44210);
} else {
if((state_val_44213 === (1))){
var inst_44203 = (function (){var G__44215 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44215) : client.call(null,G__44215));
})();
var state_44212__$1 = state_44212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44212__$1,(2),inst_44203);
} else {
return null;
}
}
});})(c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding))
;
return ((function (switch__7647__auto__,c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0 = (function (){
var statearr_44219 = [null,null,null,null,null,null,null,null];
(statearr_44219[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__);

(statearr_44219[(1)] = (1));

return statearr_44219;
});
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1 = (function (state_44212){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44212);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44220){if((e44220 instanceof Object)){
var ex__7651__auto__ = e44220;
var statearr_44221_44224 = state_44212;
(statearr_44221_44224[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44212);

return cljs.core.constant$keyword$recur;
} else {
throw e44220;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44225 = state_44212;
state_44212 = G__44225;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = function(state_44212){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1.call(this,state_44212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding))
})();
var state__7711__auto__ = (function (){var statearr_44222 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44222[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44223);

return statearr_44222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44223,channel,map__44202,map__44202__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__44228 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44228) : client.call(null,G__44228));
} else {
var G__44229 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44229) : client.call(null,G__44229));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7709__auto___44268 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___44268,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___44268,channel){
return (function (state_44257){
var state_val_44258 = (state_44257[(1)]);
if((state_val_44258 === (2))){
var inst_44251 = (state_44257[(2)]);
var inst_44252 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_44253 = cljs_http.client.decode_body(inst_44251,cljs_http.util.json_decode,"application/json",inst_44252);
var inst_44254 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_44253);
var inst_44255 = cljs.core.async.close_BANG_(channel);
var state_44257__$1 = (function (){var statearr_44259 = state_44257;
(statearr_44259[(7)] = inst_44254);

return statearr_44259;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44257__$1,inst_44255);
} else {
if((state_val_44258 === (1))){
var inst_44249 = (function (){var G__44260 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44260) : client.call(null,G__44260));
})();
var state_44257__$1 = state_44257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44257__$1,(2),inst_44249);
} else {
return null;
}
}
});})(c__7709__auto___44268,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___44268,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0 = (function (){
var statearr_44264 = [null,null,null,null,null,null,null,null];
(statearr_44264[(0)] = cljs_http$client$wrap_json_response_$_state_machine__7648__auto__);

(statearr_44264[(1)] = (1));

return statearr_44264;
});
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1 = (function (state_44257){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_44257);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e44265){if((e44265 instanceof Object)){
var ex__7651__auto__ = e44265;
var statearr_44266_44269 = state_44257;
(statearr_44266_44269[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44257);

return cljs.core.constant$keyword$recur;
} else {
throw e44265;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__44270 = state_44257;
state_44257 = G__44270;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = function(state_44257){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1.call(this,state_44257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___44268,channel))
})();
var state__7711__auto__ = (function (){var statearr_44267 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_44267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___44268);

return statearr_44267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___44268,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__44275){
var map__44276 = p__44275;
var map__44276__$1 = ((cljs.core.seq_QMARK_(map__44276))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44276):map__44276);
var req = map__44276__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44276__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__44277 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44277) : client.call(null,G__44277));
} else {
var G__44278 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44278) : client.call(null,G__44278));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__44283){
var map__44284 = p__44283;
var map__44284__$1 = ((cljs.core.seq_QMARK_(map__44284))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44284):map__44284);
var request = map__44284__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44284__$1,cljs.core.constant$keyword$request_DASH_method);
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44284__$1,cljs.core.constant$keyword$form_DASH_params);
if(cljs.core.truth_((function (){var and__4264__auto__ = form_params;
if(cljs.core.truth_(and__4264__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__4264__auto__;
}
})())){
var G__44285 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44285) : client.call(null,G__44285));
} else {
var G__44286 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44286) : client.call(null,G__44286));
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
var G__44288 = (cljs.core.truth_(cljs_http.util.android_QMARK_())?cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$android], null),(function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})()):request);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44288) : client.call(null,G__44288));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
var G__44291 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44291) : client.call(null,G__44291));
} else {
var G__44292 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44292) : client.call(null,G__44292));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__44293_SHARP_){
var G__44295 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__44293_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44295) : client.call(null,G__44295));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__44301){
var map__44302 = p__44301;
var map__44302__$1 = ((cljs.core.seq_QMARK_(map__44302))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44302):map__44302);
var req = map__44302__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44302__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4124__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
var G__44303 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4124__auto__,map__44302,map__44302__$1,req,query_params){
return (function (p1__44296_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__44296_SHARP_,query_params], 0));
});})(spec,temp__4124__auto__,map__44302,map__44302__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44303) : client.call(null,G__44303));
} else {
var G__44304 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44304) : client.call(null,G__44304));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__44307){
var vec__44308 = p__44307;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44308,(0),null);
return ((function (vec__44308,credentials){
return (function (req){
var credentials__$1 = (function (){var or__4276__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__44309 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44309) : client.call(null,G__44309));
} else {
var G__44310 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44310) : client.call(null,G__44310));
}
});
;})(vec__44308,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq44305){
var G__44306 = cljs.core.first(seq44305);
var seq44305__$1 = cljs.core.next(seq44305);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__44306,seq44305__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
var G__44313 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44313) : client.call(null,G__44313));
} else {
var G__44314 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__44314) : client.call(null,G__44314));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44317){
var vec__44318 = p__44317;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44318,(0),null);
var G__44319 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44319) : cljs_http.client.request.call(null,G__44319));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq44315){
var G__44316 = cljs.core.first(seq44315);
var seq44315__$1 = cljs.core.next(seq44315);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__44316,seq44315__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44322){
var vec__44323 = p__44322;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44323,(0),null);
var G__44324 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44324) : cljs_http.client.request.call(null,G__44324));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq44320){
var G__44321 = cljs.core.first(seq44320);
var seq44320__$1 = cljs.core.next(seq44320);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__44321,seq44320__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44327){
var vec__44328 = p__44327;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44328,(0),null);
var G__44329 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44329) : cljs_http.client.request.call(null,G__44329));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq44325){
var G__44326 = cljs.core.first(seq44325);
var seq44325__$1 = cljs.core.next(seq44325);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__44326,seq44325__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44332){
var vec__44333 = p__44332;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44333,(0),null);
var G__44334 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44334) : cljs_http.client.request.call(null,G__44334));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq44330){
var G__44331 = cljs.core.first(seq44330);
var seq44330__$1 = cljs.core.next(seq44330);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__44331,seq44330__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44337){
var vec__44338 = p__44337;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44338,(0),null);
var G__44339 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44339) : cljs_http.client.request.call(null,G__44339));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq44335){
var G__44336 = cljs.core.first(seq44335);
var seq44335__$1 = cljs.core.next(seq44335);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__44336,seq44335__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44342){
var vec__44343 = p__44342;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343,(0),null);
var G__44344 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44344) : cljs_http.client.request.call(null,G__44344));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq44340){
var G__44341 = cljs.core.first(seq44340);
var seq44340__$1 = cljs.core.next(seq44340);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__44341,seq44340__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44347){
var vec__44348 = p__44347;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44348,(0),null);
var G__44349 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44349) : cljs_http.client.request.call(null,G__44349));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq44345){
var G__44346 = cljs.core.first(seq44345);
var seq44345__$1 = cljs.core.next(seq44345);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__44346,seq44345__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__44352){
var vec__44353 = p__44352;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44353,(0),null);
var G__44354 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__44354) : cljs_http.client.request.call(null,G__44354));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq44350){
var G__44351 = cljs.core.first(seq44350);
var seq44350__$1 = cljs.core.next(seq44350);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__44351,seq44350__$1);
});
