// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.EventType');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__43492 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__43492) : cljs.core.atom.call(null,G__43492));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4126__auto__ = (function (){var G__43494 = cljs_http.core.pending_requests;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__43494) : cljs.core.deref.call(null,G__43494));
})().call(null,channel);
if(cljs.core.truth_(temp__4126__auto__)){
var xhr = temp__4126__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

return xhr.abort();
} else {
return null;
}
});
cljs_http.core.channel_for_request = (function cljs_http$core$channel_for_request(request){
var or__4276__auto__ = cljs.core.constant$keyword$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__43496){
var map__43499 = p__43496;
var map__43499__$1 = ((cljs.core.seq_QMARK_(map__43499))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43499):map__43499);
var request__$1 = map__43499__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43499__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43499__$1,cljs.core.constant$keyword$body);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43499__$1,cljs.core.constant$keyword$headers);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43499__$1,cljs.core.constant$keyword$request_DASH_method);
var channel = cljs_http.core.channel_for_request(request__$1);
var request_url = cljs_http.util.build_url(request__$1);
var method = cljs.core.name((function (){var or__4276__auto__ = request_method;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var timeout = (function (){var or__4276__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return (0);
}
})();
var headers__$1 = cljs_http.util.build_headers(headers);
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var xhr = (function (){var G__43500 = (new goog.net.XhrIo());
G__43500.setTimeoutInterval(timeout);

G__43500.setWithCredentials(send_credentials);

return G__43500;
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,timeout,headers__$1,send_credentials,xhr,map__43499,map__43499__$1,request__$1,with_credentials_QMARK_,body,headers,request_method){
return (function (p1__43495_SHARP_){
var target = p1__43495_SHARP_.target;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponseText(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null)], null));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,timeout,headers__$1,send_credentials,xhr,map__43499,map__43499__$1,request__$1,with_credentials_QMARK_,body,headers,request_method))
);

xhr.send(request_url,method,body,headers__$1);

return channel;
});
