// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq41911){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41911));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq41912){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41912));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41915){
var vec__41916 = p__41915;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41916,(0),null);

var G__41917 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__41917) : milia.api.io.raw_request.call(null,G__41917));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq41913){
var G__41914 = cljs.core.first(seq41913);
var seq41913__$1 = cljs.core.next(seq41913);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__41914,seq41913__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41920){
var vec__41921 = p__41920;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41921,(0),null);

var G__41922 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__41922) : milia.api.io.raw_request.call(null,G__41922));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq41918){
var G__41919 = cljs.core.first(seq41918);
var seq41918__$1 = cljs.core.next(seq41918);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__41919,seq41918__$1);
});
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var G__41924 = arguments.length;
switch (G__41924) {
case 1:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,false);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__41925 = "csrftoken";
return goog.net.cookies.get(G__41925);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__41939 = null;
var G__41939__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__41939__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__41939__4 = (function() { 
var G__41940__delegate = function (url,query_params,token,p__41934){
var map__41935 = p__41934;
var map__41935__$1 = ((cljs.core.seq_QMARK_(map__41935))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41935):map__41935);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41935__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,token),cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__41936 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__41936) : cljs_hash.md5.md5.call(null,G__41936));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__41937 = url;
var G__41938 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__41937,G__41938) : http_method.call(null,G__41937,G__41938));
};
var G__41940 = function (url,query_params,token,var_args){
var p__41934 = null;
if (arguments.length > 3) {
var G__41941__i = 0, G__41941__a = new Array(arguments.length -  3);
while (G__41941__i < G__41941__a.length) {G__41941__a[G__41941__i] = arguments[G__41941__i + 3]; ++G__41941__i;}
  p__41934 = new cljs.core.IndexedSeq(G__41941__a,0);
} 
return G__41940__delegate.call(this,url,query_params,token,p__41934);};
G__41940.cljs$lang$maxFixedArity = 3;
G__41940.cljs$lang$applyTo = (function (arglist__41942){
var url = cljs.core.first(arglist__41942);
arglist__41942 = cljs.core.next(arglist__41942);
var query_params = cljs.core.first(arglist__41942);
arglist__41942 = cljs.core.next(arglist__41942);
var token = cljs.core.first(arglist__41942);
var p__41934 = cljs.core.rest(arglist__41942);
return G__41940__delegate(url,query_params,token,p__41934);
});
G__41940.cljs$core$IFn$_invoke$arity$variadic = G__41940__delegate;
return G__41940;
})()
;
G__41939 = function(url,query_params,token,var_args){
var p__41934 = var_args;
switch(arguments.length){
case 1:
return G__41939__1.call(this,url);
case 2:
return G__41939__2.call(this,url,query_params);
default:
var G__41943 = null;
if (arguments.length > 3) {
var G__41944__i = 0, G__41944__a = new Array(arguments.length -  3);
while (G__41944__i < G__41944__a.length) {G__41944__a[G__41944__i] = arguments[G__41944__i + 3]; ++G__41944__i;}
G__41943 = new cljs.core.IndexedSeq(G__41944__a,0);
}
return G__41939__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__41943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__41939.cljs$lang$maxFixedArity = 3;
G__41939.cljs$lang$applyTo = G__41939__4.cljs$lang$applyTo;
G__41939.cljs$core$IFn$_invoke$arity$1 = G__41939__1;
G__41939.cljs$core$IFn$_invoke$arity$2 = G__41939__2;
G__41939.cljs$core$IFn$_invoke$arity$variadic = G__41939__4.cljs$core$IFn$_invoke$arity$variadic;
return G__41939;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__41952 = arguments.length;
switch (G__41952) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_41963){
var state_val_41964 = (state_41963[(1)]);
if((state_val_41964 === (5))){
var inst_41961 = (state_41963[(2)]);
var state_41963__$1 = state_41963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41963__$1,inst_41961);
} else {
if((state_val_41964 === (4))){
var state_41963__$1 = state_41963;
var statearr_41965_41983 = state_41963__$1;
(statearr_41965_41983[(2)] = null);

(statearr_41965_41983[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_41964 === (3))){
var inst_41956 = (state_41963[(7)]);
var inst_41958 = (function (){var G__41966 = inst_41956;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__41966) : callback.call(null,G__41966));
})();
var state_41963__$1 = state_41963;
var statearr_41967_41984 = state_41963__$1;
(statearr_41967_41984[(2)] = inst_41958);

(statearr_41967_41984[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_41964 === (2))){
var inst_41956 = (state_41963[(2)]);
var state_41963__$1 = (function (){var statearr_41968 = state_41963;
(statearr_41968[(7)] = inst_41956);

return statearr_41968;
})();
if(cljs.core.truth_(callback)){
var statearr_41969_41985 = state_41963__$1;
(statearr_41969_41985[(1)] = (3));

} else {
var statearr_41970_41986 = state_41963__$1;
(statearr_41970_41986[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_41964 === (1))){
var inst_41953 = milia.api.io.query_helper(method);
var inst_41954 = (function (){var G__41971 = url;
var G__41972 = query_params;
var G__41973 = token;
var G__41974 = opts;
return (inst_41953.cljs$core$IFn$_invoke$arity$4 ? inst_41953.cljs$core$IFn$_invoke$arity$4(G__41971,G__41972,G__41973,G__41974) : inst_41953.call(null,G__41971,G__41972,G__41973,G__41974));
})();
var state_41963__$1 = state_41963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41963__$1,(2),inst_41954);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_41978 = [null,null,null,null,null,null,null,null];
(statearr_41978[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_41978[(1)] = (1));

return statearr_41978;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_41963){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_41963);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e41979){if((e41979 instanceof Object)){
var ex__7651__auto__ = e41979;
var statearr_41980_41987 = state_41963;
(statearr_41980_41987[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41963);

return cljs.core.constant$keyword$recur;
} else {
throw e41979;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__41988 = state_41963;
state_41963 = G__41988;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_41963){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_41963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_41981 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_41981[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_41981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq41945){
var G__41946 = cljs.core.first(seq41945);
var seq41945__$1 = cljs.core.next(seq41945);
var G__41947 = cljs.core.first(seq41945__$1);
var seq41945__$2 = cljs.core.next(seq41945__$1);
var G__41948 = cljs.core.first(seq41945__$2);
var seq41945__$3 = cljs.core.next(seq41945__$2);
var G__41949 = cljs.core.first(seq41945__$3);
var seq41945__$4 = cljs.core.next(seq41945__$3);
var G__41950 = cljs.core.first(seq41945__$4);
var seq41945__$5 = cljs.core.next(seq41945__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__41946,G__41947,G__41948,G__41949,G__41950,seq41945__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__41990 = arguments.length;
switch (G__41990) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__41991 = event.target;
var G__41992 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__41991,G__41992) : dommy.core.attr.call(null,G__41991,G__41992));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__41993 = event.target.form;
var G__41994 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__41993,G__41994) : dommy.core.attr.call(null,G__41993,G__41994));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__41997 = arguments.length;
switch (G__41997) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__41998 = event.target;
var G__41999 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__41998,G__41999) : dommy.core.attr.call(null,G__41998,G__41999));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42134){
var state_val_42135 = (state_42134[(1)]);
if((state_val_42135 === (7))){
var inst_42099 = (state_42134[(2)]);
var state_42134__$1 = state_42134;
var statearr_42136_42181 = state_42134__$1;
(statearr_42136_42181[(2)] = inst_42099);

(statearr_42136_42181[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (20))){
var state_42134__$1 = state_42134;
var statearr_42137_42182 = state_42134__$1;
(statearr_42137_42182[(2)] = null);

(statearr_42137_42182[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (1))){
var inst_42091 = (state_42134[(7)]);
var inst_42091__$1 = (auth_token == null);
var state_42134__$1 = (function (){var statearr_42138 = state_42134;
(statearr_42138[(7)] = inst_42091__$1);

return statearr_42138;
})();
if(cljs.core.truth_(inst_42091__$1)){
var statearr_42139_42183 = state_42134__$1;
(statearr_42139_42183[(1)] = (2));

} else {
var statearr_42140_42184 = state_42134__$1;
(statearr_42140_42184[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (4))){
var inst_42101 = (state_42134[(2)]);
var state_42134__$1 = state_42134;
if(cljs.core.truth_(inst_42101)){
var statearr_42141_42185 = state_42134__$1;
(statearr_42141_42185[(1)] = (8));

} else {
var statearr_42142_42186 = state_42134__$1;
(statearr_42142_42186[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (15))){
var inst_42114 = (state_42134[(8)]);
var inst_42114__$1 = (state_42134[(2)]);
var inst_42115 = cljs.core.seq_QMARK_(inst_42114__$1);
var state_42134__$1 = (function (){var statearr_42143 = state_42134;
(statearr_42143[(8)] = inst_42114__$1);

return statearr_42143;
})();
if(inst_42115){
var statearr_42144_42187 = state_42134__$1;
(statearr_42144_42187[(1)] = (16));

} else {
var statearr_42145_42188 = state_42134__$1;
(statearr_42145_42188[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (21))){
var inst_42127 = (state_42134[(2)]);
var state_42134__$1 = state_42134;
var statearr_42146_42189 = state_42134__$1;
(statearr_42146_42189[(2)] = inst_42127);

(statearr_42146_42189[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (13))){
var state_42134__$1 = state_42134;
var statearr_42147_42190 = state_42134__$1;
(statearr_42147_42190[(2)] = auth_token);

(statearr_42147_42190[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (6))){
var inst_42097 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_42134__$1 = state_42134;
var statearr_42148_42191 = state_42134__$1;
(statearr_42148_42191[(2)] = inst_42097);

(statearr_42148_42191[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (17))){
var inst_42114 = (state_42134[(8)]);
var state_42134__$1 = state_42134;
var statearr_42149_42192 = state_42134__$1;
(statearr_42149_42192[(2)] = inst_42114);

(statearr_42149_42192[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (3))){
var inst_42094 = (state_42134[(9)]);
var inst_42094__$1 = clojure.string.blank_QMARK_(auth_token);
var state_42134__$1 = (function (){var statearr_42150 = state_42134;
(statearr_42150[(9)] = inst_42094__$1);

return statearr_42150;
})();
if(cljs.core.truth_(inst_42094__$1)){
var statearr_42151_42193 = state_42134__$1;
(statearr_42151_42193[(1)] = (5));

} else {
var statearr_42152_42194 = state_42134__$1;
(statearr_42152_42194[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (12))){
var inst_42111 = milia.api.io.refresh_token_url(username);
var inst_42112 = (function (){var G__42153 = inst_42111;
var G__42154 = null;
var G__42155 = null;
var G__42156 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42157 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42153,G__42154,G__42155,G__42156,G__42157) : milia.api.io.get_url.call(null,G__42153,G__42154,G__42155,G__42156,G__42157));
})();
var state_42134__$1 = state_42134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42134__$1,(15),inst_42112);
} else {
if((state_val_42135 === (2))){
var inst_42091 = (state_42134[(7)]);
var state_42134__$1 = state_42134;
var statearr_42158_42195 = state_42134__$1;
(statearr_42158_42195[(2)] = inst_42091);

(statearr_42158_42195[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (19))){
var inst_42121 = (state_42134[(10)]);
var state_42134__$1 = state_42134;
var statearr_42159_42196 = state_42134__$1;
(statearr_42159_42196[(2)] = inst_42121);

(statearr_42159_42196[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (11))){
var inst_42107 = (state_42134[(2)]);
var inst_42108 = milia.api.io.invalid_token_QMARK_(inst_42107);
var state_42134__$1 = state_42134;
if(cljs.core.truth_(inst_42108)){
var statearr_42160_42197 = state_42134__$1;
(statearr_42160_42197[(1)] = (12));

} else {
var statearr_42161_42198 = state_42134__$1;
(statearr_42161_42198[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (9))){
var inst_42104 = milia.api.io.validate_token_url(username);
var inst_42105 = (function (){var G__42162 = inst_42104;
var G__42163 = null;
var G__42164 = null;
var G__42165 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42166 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42162,G__42163,G__42164,G__42165,G__42166) : milia.api.io.get_url.call(null,G__42162,G__42163,G__42164,G__42165,G__42166));
})();
var state_42134__$1 = state_42134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42134__$1,(11),inst_42105);
} else {
if((state_val_42135 === (5))){
var inst_42094 = (state_42134[(9)]);
var state_42134__$1 = state_42134;
var statearr_42167_42199 = state_42134__$1;
(statearr_42167_42199[(2)] = inst_42094);

(statearr_42167_42199[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (14))){
var inst_42130 = (state_42134[(2)]);
var state_42134__$1 = state_42134;
var statearr_42168_42200 = state_42134__$1;
(statearr_42168_42200[(2)] = inst_42130);

(statearr_42168_42200[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (16))){
var inst_42114 = (state_42134[(8)]);
var inst_42117 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42114);
var state_42134__$1 = state_42134;
var statearr_42169_42201 = state_42134__$1;
(statearr_42169_42201[(2)] = inst_42117);

(statearr_42169_42201[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (10))){
var inst_42132 = (state_42134[(2)]);
var state_42134__$1 = state_42134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42134__$1,inst_42132);
} else {
if((state_val_42135 === (18))){
var inst_42120 = (state_42134[(2)]);
var inst_42121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42120,cljs.core.constant$keyword$body);
var inst_42122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42120,cljs.core.constant$keyword$status);
var inst_42123 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42122,(200));
var state_42134__$1 = (function (){var statearr_42170 = state_42134;
(statearr_42170[(10)] = inst_42121);

return statearr_42170;
})();
if(inst_42123){
var statearr_42171_42202 = state_42134__$1;
(statearr_42171_42202[(1)] = (19));

} else {
var statearr_42172_42203 = state_42134__$1;
(statearr_42172_42203[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42135 === (8))){
var state_42134__$1 = state_42134;
var statearr_42173_42204 = state_42134__$1;
(statearr_42173_42204[(2)] = null);

(statearr_42173_42204[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_42177 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42177[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_42177[(1)] = (1));

return statearr_42177;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_42134){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42134);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42178){if((e42178 instanceof Object)){
var ex__7651__auto__ = e42178;
var statearr_42179_42205 = state_42134;
(statearr_42179_42205[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42134);

return cljs.core.constant$keyword$recur;
} else {
throw e42178;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42206 = state_42134;
state_42134 = G__42206;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_42134){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_42134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42180 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__42213_42219 = io_obj;
var G__42214_42220 = goog.net.EventType.SUCCESS;
var G__42215_42221 = ((function (G__42213_42219,G__42214_42220,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42213_42219,G__42214_42220,io_obj,url))
;
goog.events.listen(G__42213_42219,G__42214_42220,G__42215_42221);

var G__42216_42222 = io_obj;
var G__42217_42223 = goog.net.EventType.ERROR;
var G__42218_42224 = ((function (G__42216_42222,G__42217_42223,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42216_42222,G__42217_42223,io_obj,url))
;
goog.events.listen(G__42216_42222,G__42217_42223,G__42218_42224);

return io_obj.sendFromForm(form,url);
});
