// Compiled by ClojureScript 0.0-3196 {}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('milia.utils.url');
goog.require('clojure.string');
milia.utils.remote.hosts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"ui","ui",-469653645),"beta.ona.io",new cljs.core.Keyword(null,"data","data",-232669377),"stage.ona.io",new cljs.core.Keyword(null,"j2x","j2x",2112415912),"j2x.ona.io",new cljs.core.Keyword(null,"ona-api-server-protocol","ona-api-server-protocol",1305279248),"https"], null));
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.call(null,cljs.core.flatten.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ona-api-server-protocol","ona-api-server-protocol",1305279248).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)),"://",resources], null)));
});
milia.utils.remote.thumbor_server = "https://images.ona.io";
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.call(null,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.call(null,milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,[cljs.core.str(milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq10963){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10963));
});
/**
 * Build a Zebra url.
 */
milia.utils.remote.make_zebra_url = (function milia$utils$remote$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,milia.utils.remote.protocol_prefixed.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)),"/"], null)),postfix);
});

milia.utils.remote.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_zebra_url.cljs$lang$applyTo = (function (seq10964){
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10964));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"j2x","j2x",2112415912).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq10965){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10965));
});
