// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like.call(null,elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__11040 = arguments.length;
switch (G__11040) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__11041 = dommy.template.__GT_node_like.call(null,parent);
G__11041.appendChild(dommy.template.__GT_node_like.call(null,child));

return G__11041;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11042_11047 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11043_11048 = null;
var count__11044_11049 = (0);
var i__11045_11050 = (0);
while(true){
if((i__11045_11050 < count__11044_11049)){
var c_11051 = cljs.core._nth.call(null,chunk__11043_11048,i__11045_11050);
dommy.core.append_BANG_.call(null,parent__$1,c_11051);

var G__11052 = seq__11042_11047;
var G__11053 = chunk__11043_11048;
var G__11054 = count__11044_11049;
var G__11055 = (i__11045_11050 + (1));
seq__11042_11047 = G__11052;
chunk__11043_11048 = G__11053;
count__11044_11049 = G__11054;
i__11045_11050 = G__11055;
continue;
} else {
var temp__4126__auto___11056 = cljs.core.seq.call(null,seq__11042_11047);
if(temp__4126__auto___11056){
var seq__11042_11057__$1 = temp__4126__auto___11056;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11042_11057__$1)){
var c__5061__auto___11058 = cljs.core.chunk_first.call(null,seq__11042_11057__$1);
var G__11059 = cljs.core.chunk_rest.call(null,seq__11042_11057__$1);
var G__11060 = c__5061__auto___11058;
var G__11061 = cljs.core.count.call(null,c__5061__auto___11058);
var G__11062 = (0);
seq__11042_11047 = G__11059;
chunk__11043_11048 = G__11060;
count__11044_11049 = G__11061;
i__11045_11050 = G__11062;
continue;
} else {
var c_11063 = cljs.core.first.call(null,seq__11042_11057__$1);
dommy.core.append_BANG_.call(null,parent__$1,c_11063);

var G__11064 = cljs.core.next.call(null,seq__11042_11057__$1);
var G__11065 = null;
var G__11066 = (0);
var G__11067 = (0);
seq__11042_11047 = G__11064;
chunk__11043_11048 = G__11065;
count__11044_11049 = G__11066;
i__11045_11050 = G__11067;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq11036){
var G__11037 = cljs.core.first.call(null,seq11036);
var seq11036__$1 = cljs.core.next.call(null,seq11036);
var G__11038 = cljs.core.first.call(null,seq11036__$1);
var seq11036__$2 = cljs.core.next.call(null,seq11036__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11037,G__11038,seq11036__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__11072 = arguments.length;
switch (G__11072) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like.call(null,child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11073_11078 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11074_11079 = null;
var count__11075_11080 = (0);
var i__11076_11081 = (0);
while(true){
if((i__11076_11081 < count__11075_11080)){
var c_11082 = cljs.core._nth.call(null,chunk__11074_11079,i__11076_11081);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11082);

var G__11083 = seq__11073_11078;
var G__11084 = chunk__11074_11079;
var G__11085 = count__11075_11080;
var G__11086 = (i__11076_11081 + (1));
seq__11073_11078 = G__11083;
chunk__11074_11079 = G__11084;
count__11075_11080 = G__11085;
i__11076_11081 = G__11086;
continue;
} else {
var temp__4126__auto___11087 = cljs.core.seq.call(null,seq__11073_11078);
if(temp__4126__auto___11087){
var seq__11073_11088__$1 = temp__4126__auto___11087;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11073_11088__$1)){
var c__5061__auto___11089 = cljs.core.chunk_first.call(null,seq__11073_11088__$1);
var G__11090 = cljs.core.chunk_rest.call(null,seq__11073_11088__$1);
var G__11091 = c__5061__auto___11089;
var G__11092 = cljs.core.count.call(null,c__5061__auto___11089);
var G__11093 = (0);
seq__11073_11078 = G__11090;
chunk__11074_11079 = G__11091;
count__11075_11080 = G__11092;
i__11076_11081 = G__11093;
continue;
} else {
var c_11094 = cljs.core.first.call(null,seq__11073_11088__$1);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11094);

var G__11095 = cljs.core.next.call(null,seq__11073_11088__$1);
var G__11096 = null;
var G__11097 = (0);
var G__11098 = (0);
seq__11073_11078 = G__11095;
chunk__11074_11079 = G__11096;
count__11075_11080 = G__11097;
i__11076_11081 = G__11098;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq11068){
var G__11069 = cljs.core.first.call(null,seq11068);
var seq11068__$1 = cljs.core.next.call(null,seq11068);
var G__11070 = cljs.core.first.call(null,seq11068__$1);
var seq11068__$2 = cljs.core.next.call(null,seq11068__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11069,G__11070,seq11068__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
var parent = other__$1.parentNode;
var temp__4124__auto___11099 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___11099)){
var next_11100 = temp__4124__auto___11099;
parent.insertBefore(actual_node,next_11100);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like.call(null,new$);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__11102 = dommy.template.__GT_node_like.call(null,parent);
G__11102.innerHTML = "";

dommy.core.append_BANG_.call(null,G__11102,node_like);

return G__11102;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var G__11104 = elem__$1.parentNode;
G__11104.removeChild(elem__$1);

return G__11104;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like.call(null,template);
if(!(cljs.core.contains_QMARK_.call(null,key_selectors_map,new cljs.core.Keyword(null,"container","container",-1736937707)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),new cljs.core.Keyword(null,"container","container",-1736937707)))))].join('')));
}

return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container","container",-1736937707),container], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (container){
return (function (p__11110){
var vec__11111 = p__11110;
var k = cljs.core.nth.call(null,vec__11111,(0),null);
var v = cljs.core.nth.call(null,vec__11111,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(new cljs.core.Keyword(null,"live","live",-1610148039).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))?(function (){
if(typeof dommy.core.t11112 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t11112 = (function (v,k,vec__11111,p__11110,container,key_selectors_map,template,selector_map,meta11113){
this.v = v;
this.k = k;
this.vec__11111 = vec__11111;
this.p__11110 = p__11110;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta11113 = meta11113;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t11112.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__11111,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,self__.container).querySelectorAll(dommy.core.selector.call(null,self__.v)));
});})(vec__11111,k,v,container))
;

dommy.core.t11112.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__11111,k,v,container){
return (function (_11114){
var self__ = this;
var _11114__$1 = this;
return self__.meta11113;
});})(vec__11111,k,v,container))
;

dommy.core.t11112.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__11111,k,v,container){
return (function (_11114,meta11113__$1){
var self__ = this;
var _11114__$1 = this;
return (new dommy.core.t11112(self__.v,self__.k,self__.vec__11111,self__.p__11110,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta11113__$1));
});})(vec__11111,k,v,container))
;

dommy.core.t11112.cljs$lang$type = true;

dommy.core.t11112.cljs$lang$ctorStr = "dommy.core/t11112";

dommy.core.t11112.cljs$lang$ctorPrWriter = ((function (vec__11111,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"dommy.core/t11112");
});})(vec__11111,k,v,container))
;

dommy.core.__GT_t11112 = ((function (vec__11111,k,v,container){
return (function dommy$core$selector_map_$___GT_t11112(v__$1,k__$1,vec__11111__$1,p__11110__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11113){
return (new dommy.core.t11112(v__$1,k__$1,vec__11111__$1,p__11110__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11113));
});})(vec__11111,k,v,container))
;

}

return (new dommy.core.t11112(v,k,vec__11111,p__11110,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like.call(null,container).querySelector(dommy.core.selector.call(null,v)))], null);
});})(container))
,key_selectors_map)));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,(function (p1__11115_SHARP_){
return p1__11115_SHARP_.parentNode;
}),dommy.template.__GT_node_like.call(null,elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__11117 = arguments.length;
switch (G__11117) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,dommy.template.__GT_node_like.call(null,base)).querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__11121 = arguments.length;
switch (G__11121) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like.call(null,base);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base__$1,selector),cljs.core.take_while.call(null,((function (base__$1,elem__$1){
return (function (p1__11119_SHARP_){
return !((p1__11119_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes.call(null,elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,selector),dommy.core.ancestor_nodes.call(null,dommy.template.__GT_node_like.call(null,elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like.call(null,descendant);
var ancestor__$1 = dommy.template.__GT_node_like.call(null,ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__11123){
var vec__11124 = p__11123;
var special_mouse_event = cljs.core.nth.call(null,vec__11124,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__11124,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__11124,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__11124,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__11124,special_mouse_event,real_mouse_event))
});})(vec__11124,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,dommy.template.__GT_node_like.call(null,elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like.call(null,elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq11125){
var G__11126 = cljs.core.first.call(null,seq11125);
var seq11125__$1 = cljs.core.next.call(null,seq11125);
var G__11127 = cljs.core.first.call(null,seq11125__$1);
var seq11125__$2 = cljs.core.next.call(null,seq11125__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11126,G__11127,seq11125__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,(function (p1__11128_SHARP_){
return dommy.template.__GT_node_like.call(null,cljs.core.first.call(null,p1__11128_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like.call(null,elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11131_11154 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11155 = cljs.core.nth.call(null,vec__11131_11154,(0),null);
var selector_11156 = cljs.core.nth.call(null,vec__11131_11154,(1),null);
var seq__11132_11157 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11139_11158 = null;
var count__11140_11159 = (0);
var i__11141_11160 = (0);
while(true){
if((i__11141_11160 < count__11140_11159)){
var vec__11148_11161 = cljs.core._nth.call(null,chunk__11139_11158,i__11141_11160);
var orig_type_11162 = cljs.core.nth.call(null,vec__11148_11161,(0),null);
var f_11163 = cljs.core.nth.call(null,vec__11148_11161,(1),null);
var seq__11142_11164 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11162,new cljs.core.PersistentArrayMap.fromArray([orig_type_11162,cljs.core.identity], true, false)));
var chunk__11144_11165 = null;
var count__11145_11166 = (0);
var i__11146_11167 = (0);
while(true){
if((i__11146_11167 < count__11145_11166)){
var vec__11149_11168 = cljs.core._nth.call(null,chunk__11144_11165,i__11146_11167);
var actual_type_11169 = cljs.core.nth.call(null,vec__11149_11168,(0),null);
var factory_11170 = cljs.core.nth.call(null,vec__11149_11168,(1),null);
var canonical_f_11171 = (cljs.core.truth_(selector_11156)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11155,selector_11156):cljs.core.identity).call(null,factory_11170.call(null,f_11163));
dommy.core.update_event_listeners_BANG_.call(null,elem_11155,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11156,actual_type_11169,f_11163], null),canonical_f_11171);

if(cljs.core.truth_(elem_11155.addEventListener)){
elem_11155.addEventListener(cljs.core.name.call(null,actual_type_11169),canonical_f_11171);
} else {
elem_11155.attachEvent(cljs.core.name.call(null,actual_type_11169),canonical_f_11171);
}

var G__11172 = seq__11142_11164;
var G__11173 = chunk__11144_11165;
var G__11174 = count__11145_11166;
var G__11175 = (i__11146_11167 + (1));
seq__11142_11164 = G__11172;
chunk__11144_11165 = G__11173;
count__11145_11166 = G__11174;
i__11146_11167 = G__11175;
continue;
} else {
var temp__4126__auto___11176 = cljs.core.seq.call(null,seq__11142_11164);
if(temp__4126__auto___11176){
var seq__11142_11177__$1 = temp__4126__auto___11176;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11142_11177__$1)){
var c__5061__auto___11178 = cljs.core.chunk_first.call(null,seq__11142_11177__$1);
var G__11179 = cljs.core.chunk_rest.call(null,seq__11142_11177__$1);
var G__11180 = c__5061__auto___11178;
var G__11181 = cljs.core.count.call(null,c__5061__auto___11178);
var G__11182 = (0);
seq__11142_11164 = G__11179;
chunk__11144_11165 = G__11180;
count__11145_11166 = G__11181;
i__11146_11167 = G__11182;
continue;
} else {
var vec__11150_11183 = cljs.core.first.call(null,seq__11142_11177__$1);
var actual_type_11184 = cljs.core.nth.call(null,vec__11150_11183,(0),null);
var factory_11185 = cljs.core.nth.call(null,vec__11150_11183,(1),null);
var canonical_f_11186 = (cljs.core.truth_(selector_11156)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11155,selector_11156):cljs.core.identity).call(null,factory_11185.call(null,f_11163));
dommy.core.update_event_listeners_BANG_.call(null,elem_11155,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11156,actual_type_11184,f_11163], null),canonical_f_11186);

if(cljs.core.truth_(elem_11155.addEventListener)){
elem_11155.addEventListener(cljs.core.name.call(null,actual_type_11184),canonical_f_11186);
} else {
elem_11155.attachEvent(cljs.core.name.call(null,actual_type_11184),canonical_f_11186);
}

var G__11187 = cljs.core.next.call(null,seq__11142_11177__$1);
var G__11188 = null;
var G__11189 = (0);
var G__11190 = (0);
seq__11142_11164 = G__11187;
chunk__11144_11165 = G__11188;
count__11145_11166 = G__11189;
i__11146_11167 = G__11190;
continue;
}
} else {
}
}
break;
}

var G__11191 = seq__11132_11157;
var G__11192 = chunk__11139_11158;
var G__11193 = count__11140_11159;
var G__11194 = (i__11141_11160 + (1));
seq__11132_11157 = G__11191;
chunk__11139_11158 = G__11192;
count__11140_11159 = G__11193;
i__11141_11160 = G__11194;
continue;
} else {
var temp__4126__auto___11195 = cljs.core.seq.call(null,seq__11132_11157);
if(temp__4126__auto___11195){
var seq__11132_11196__$1 = temp__4126__auto___11195;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11132_11196__$1)){
var c__5061__auto___11197 = cljs.core.chunk_first.call(null,seq__11132_11196__$1);
var G__11198 = cljs.core.chunk_rest.call(null,seq__11132_11196__$1);
var G__11199 = c__5061__auto___11197;
var G__11200 = cljs.core.count.call(null,c__5061__auto___11197);
var G__11201 = (0);
seq__11132_11157 = G__11198;
chunk__11139_11158 = G__11199;
count__11140_11159 = G__11200;
i__11141_11160 = G__11201;
continue;
} else {
var vec__11151_11202 = cljs.core.first.call(null,seq__11132_11196__$1);
var orig_type_11203 = cljs.core.nth.call(null,vec__11151_11202,(0),null);
var f_11204 = cljs.core.nth.call(null,vec__11151_11202,(1),null);
var seq__11133_11205 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11203,new cljs.core.PersistentArrayMap.fromArray([orig_type_11203,cljs.core.identity], true, false)));
var chunk__11135_11206 = null;
var count__11136_11207 = (0);
var i__11137_11208 = (0);
while(true){
if((i__11137_11208 < count__11136_11207)){
var vec__11152_11209 = cljs.core._nth.call(null,chunk__11135_11206,i__11137_11208);
var actual_type_11210 = cljs.core.nth.call(null,vec__11152_11209,(0),null);
var factory_11211 = cljs.core.nth.call(null,vec__11152_11209,(1),null);
var canonical_f_11212 = (cljs.core.truth_(selector_11156)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11155,selector_11156):cljs.core.identity).call(null,factory_11211.call(null,f_11204));
dommy.core.update_event_listeners_BANG_.call(null,elem_11155,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11156,actual_type_11210,f_11204], null),canonical_f_11212);

if(cljs.core.truth_(elem_11155.addEventListener)){
elem_11155.addEventListener(cljs.core.name.call(null,actual_type_11210),canonical_f_11212);
} else {
elem_11155.attachEvent(cljs.core.name.call(null,actual_type_11210),canonical_f_11212);
}

var G__11213 = seq__11133_11205;
var G__11214 = chunk__11135_11206;
var G__11215 = count__11136_11207;
var G__11216 = (i__11137_11208 + (1));
seq__11133_11205 = G__11213;
chunk__11135_11206 = G__11214;
count__11136_11207 = G__11215;
i__11137_11208 = G__11216;
continue;
} else {
var temp__4126__auto___11217__$1 = cljs.core.seq.call(null,seq__11133_11205);
if(temp__4126__auto___11217__$1){
var seq__11133_11218__$1 = temp__4126__auto___11217__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11133_11218__$1)){
var c__5061__auto___11219 = cljs.core.chunk_first.call(null,seq__11133_11218__$1);
var G__11220 = cljs.core.chunk_rest.call(null,seq__11133_11218__$1);
var G__11221 = c__5061__auto___11219;
var G__11222 = cljs.core.count.call(null,c__5061__auto___11219);
var G__11223 = (0);
seq__11133_11205 = G__11220;
chunk__11135_11206 = G__11221;
count__11136_11207 = G__11222;
i__11137_11208 = G__11223;
continue;
} else {
var vec__11153_11224 = cljs.core.first.call(null,seq__11133_11218__$1);
var actual_type_11225 = cljs.core.nth.call(null,vec__11153_11224,(0),null);
var factory_11226 = cljs.core.nth.call(null,vec__11153_11224,(1),null);
var canonical_f_11227 = (cljs.core.truth_(selector_11156)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11155,selector_11156):cljs.core.identity).call(null,factory_11226.call(null,f_11204));
dommy.core.update_event_listeners_BANG_.call(null,elem_11155,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11156,actual_type_11225,f_11204], null),canonical_f_11227);

if(cljs.core.truth_(elem_11155.addEventListener)){
elem_11155.addEventListener(cljs.core.name.call(null,actual_type_11225),canonical_f_11227);
} else {
elem_11155.attachEvent(cljs.core.name.call(null,actual_type_11225),canonical_f_11227);
}

var G__11228 = cljs.core.next.call(null,seq__11133_11218__$1);
var G__11229 = null;
var G__11230 = (0);
var G__11231 = (0);
seq__11133_11205 = G__11228;
chunk__11135_11206 = G__11229;
count__11136_11207 = G__11230;
i__11137_11208 = G__11231;
continue;
}
} else {
}
}
break;
}

var G__11232 = cljs.core.next.call(null,seq__11132_11196__$1);
var G__11233 = null;
var G__11234 = (0);
var G__11235 = (0);
seq__11132_11157 = G__11232;
chunk__11139_11158 = G__11233;
count__11140_11159 = G__11234;
i__11141_11160 = G__11235;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq11129){
var G__11130 = cljs.core.first.call(null,seq11129);
var seq11129__$1 = cljs.core.next.call(null,seq11129);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11130,seq11129__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11238_11261 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11262 = cljs.core.nth.call(null,vec__11238_11261,(0),null);
var selector_11263 = cljs.core.nth.call(null,vec__11238_11261,(1),null);
var seq__11239_11264 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11246_11265 = null;
var count__11247_11266 = (0);
var i__11248_11267 = (0);
while(true){
if((i__11248_11267 < count__11247_11266)){
var vec__11255_11268 = cljs.core._nth.call(null,chunk__11246_11265,i__11248_11267);
var orig_type_11269 = cljs.core.nth.call(null,vec__11255_11268,(0),null);
var f_11270 = cljs.core.nth.call(null,vec__11255_11268,(1),null);
var seq__11249_11271 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11269,new cljs.core.PersistentArrayMap.fromArray([orig_type_11269,cljs.core.identity], true, false)));
var chunk__11251_11272 = null;
var count__11252_11273 = (0);
var i__11253_11274 = (0);
while(true){
if((i__11253_11274 < count__11252_11273)){
var vec__11256_11275 = cljs.core._nth.call(null,chunk__11251_11272,i__11253_11274);
var actual_type_11276 = cljs.core.nth.call(null,vec__11256_11275,(0),null);
var __11277 = cljs.core.nth.call(null,vec__11256_11275,(1),null);
var keys_11278 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11263,actual_type_11276,f_11270], null);
var canonical_f_11279 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11262),keys_11278);
dommy.core.update_event_listeners_BANG_.call(null,elem_11262,dommy.utils.dissoc_in,keys_11278);

if(cljs.core.truth_(elem_11262.removeEventListener)){
elem_11262.removeEventListener(cljs.core.name.call(null,actual_type_11276),canonical_f_11279);
} else {
elem_11262.detachEvent(cljs.core.name.call(null,actual_type_11276),canonical_f_11279);
}

var G__11280 = seq__11249_11271;
var G__11281 = chunk__11251_11272;
var G__11282 = count__11252_11273;
var G__11283 = (i__11253_11274 + (1));
seq__11249_11271 = G__11280;
chunk__11251_11272 = G__11281;
count__11252_11273 = G__11282;
i__11253_11274 = G__11283;
continue;
} else {
var temp__4126__auto___11284 = cljs.core.seq.call(null,seq__11249_11271);
if(temp__4126__auto___11284){
var seq__11249_11285__$1 = temp__4126__auto___11284;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11249_11285__$1)){
var c__5061__auto___11286 = cljs.core.chunk_first.call(null,seq__11249_11285__$1);
var G__11287 = cljs.core.chunk_rest.call(null,seq__11249_11285__$1);
var G__11288 = c__5061__auto___11286;
var G__11289 = cljs.core.count.call(null,c__5061__auto___11286);
var G__11290 = (0);
seq__11249_11271 = G__11287;
chunk__11251_11272 = G__11288;
count__11252_11273 = G__11289;
i__11253_11274 = G__11290;
continue;
} else {
var vec__11257_11291 = cljs.core.first.call(null,seq__11249_11285__$1);
var actual_type_11292 = cljs.core.nth.call(null,vec__11257_11291,(0),null);
var __11293 = cljs.core.nth.call(null,vec__11257_11291,(1),null);
var keys_11294 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11263,actual_type_11292,f_11270], null);
var canonical_f_11295 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11262),keys_11294);
dommy.core.update_event_listeners_BANG_.call(null,elem_11262,dommy.utils.dissoc_in,keys_11294);

if(cljs.core.truth_(elem_11262.removeEventListener)){
elem_11262.removeEventListener(cljs.core.name.call(null,actual_type_11292),canonical_f_11295);
} else {
elem_11262.detachEvent(cljs.core.name.call(null,actual_type_11292),canonical_f_11295);
}

var G__11296 = cljs.core.next.call(null,seq__11249_11285__$1);
var G__11297 = null;
var G__11298 = (0);
var G__11299 = (0);
seq__11249_11271 = G__11296;
chunk__11251_11272 = G__11297;
count__11252_11273 = G__11298;
i__11253_11274 = G__11299;
continue;
}
} else {
}
}
break;
}

var G__11300 = seq__11239_11264;
var G__11301 = chunk__11246_11265;
var G__11302 = count__11247_11266;
var G__11303 = (i__11248_11267 + (1));
seq__11239_11264 = G__11300;
chunk__11246_11265 = G__11301;
count__11247_11266 = G__11302;
i__11248_11267 = G__11303;
continue;
} else {
var temp__4126__auto___11304 = cljs.core.seq.call(null,seq__11239_11264);
if(temp__4126__auto___11304){
var seq__11239_11305__$1 = temp__4126__auto___11304;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11239_11305__$1)){
var c__5061__auto___11306 = cljs.core.chunk_first.call(null,seq__11239_11305__$1);
var G__11307 = cljs.core.chunk_rest.call(null,seq__11239_11305__$1);
var G__11308 = c__5061__auto___11306;
var G__11309 = cljs.core.count.call(null,c__5061__auto___11306);
var G__11310 = (0);
seq__11239_11264 = G__11307;
chunk__11246_11265 = G__11308;
count__11247_11266 = G__11309;
i__11248_11267 = G__11310;
continue;
} else {
var vec__11258_11311 = cljs.core.first.call(null,seq__11239_11305__$1);
var orig_type_11312 = cljs.core.nth.call(null,vec__11258_11311,(0),null);
var f_11313 = cljs.core.nth.call(null,vec__11258_11311,(1),null);
var seq__11240_11314 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11312,new cljs.core.PersistentArrayMap.fromArray([orig_type_11312,cljs.core.identity], true, false)));
var chunk__11242_11315 = null;
var count__11243_11316 = (0);
var i__11244_11317 = (0);
while(true){
if((i__11244_11317 < count__11243_11316)){
var vec__11259_11318 = cljs.core._nth.call(null,chunk__11242_11315,i__11244_11317);
var actual_type_11319 = cljs.core.nth.call(null,vec__11259_11318,(0),null);
var __11320 = cljs.core.nth.call(null,vec__11259_11318,(1),null);
var keys_11321 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11263,actual_type_11319,f_11313], null);
var canonical_f_11322 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11262),keys_11321);
dommy.core.update_event_listeners_BANG_.call(null,elem_11262,dommy.utils.dissoc_in,keys_11321);

if(cljs.core.truth_(elem_11262.removeEventListener)){
elem_11262.removeEventListener(cljs.core.name.call(null,actual_type_11319),canonical_f_11322);
} else {
elem_11262.detachEvent(cljs.core.name.call(null,actual_type_11319),canonical_f_11322);
}

var G__11323 = seq__11240_11314;
var G__11324 = chunk__11242_11315;
var G__11325 = count__11243_11316;
var G__11326 = (i__11244_11317 + (1));
seq__11240_11314 = G__11323;
chunk__11242_11315 = G__11324;
count__11243_11316 = G__11325;
i__11244_11317 = G__11326;
continue;
} else {
var temp__4126__auto___11327__$1 = cljs.core.seq.call(null,seq__11240_11314);
if(temp__4126__auto___11327__$1){
var seq__11240_11328__$1 = temp__4126__auto___11327__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11240_11328__$1)){
var c__5061__auto___11329 = cljs.core.chunk_first.call(null,seq__11240_11328__$1);
var G__11330 = cljs.core.chunk_rest.call(null,seq__11240_11328__$1);
var G__11331 = c__5061__auto___11329;
var G__11332 = cljs.core.count.call(null,c__5061__auto___11329);
var G__11333 = (0);
seq__11240_11314 = G__11330;
chunk__11242_11315 = G__11331;
count__11243_11316 = G__11332;
i__11244_11317 = G__11333;
continue;
} else {
var vec__11260_11334 = cljs.core.first.call(null,seq__11240_11328__$1);
var actual_type_11335 = cljs.core.nth.call(null,vec__11260_11334,(0),null);
var __11336 = cljs.core.nth.call(null,vec__11260_11334,(1),null);
var keys_11337 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11263,actual_type_11335,f_11313], null);
var canonical_f_11338 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11262),keys_11337);
dommy.core.update_event_listeners_BANG_.call(null,elem_11262,dommy.utils.dissoc_in,keys_11337);

if(cljs.core.truth_(elem_11262.removeEventListener)){
elem_11262.removeEventListener(cljs.core.name.call(null,actual_type_11335),canonical_f_11338);
} else {
elem_11262.detachEvent(cljs.core.name.call(null,actual_type_11335),canonical_f_11338);
}

var G__11339 = cljs.core.next.call(null,seq__11240_11328__$1);
var G__11340 = null;
var G__11341 = (0);
var G__11342 = (0);
seq__11240_11314 = G__11339;
chunk__11242_11315 = G__11340;
count__11243_11316 = G__11341;
i__11244_11317 = G__11342;
continue;
}
} else {
}
}
break;
}

var G__11343 = cljs.core.next.call(null,seq__11239_11305__$1);
var G__11344 = null;
var G__11345 = (0);
var G__11346 = (0);
seq__11239_11264 = G__11343;
chunk__11246_11265 = G__11344;
count__11247_11266 = G__11345;
i__11248_11267 = G__11346;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq11236){
var G__11237 = cljs.core.first.call(null,seq11236);
var seq11236__$1 = cljs.core.next.call(null,seq11236);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11237,seq11236__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11349_11356 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11357 = cljs.core.nth.call(null,vec__11349_11356,(0),null);
var selector_11358 = cljs.core.nth.call(null,vec__11349_11356,(1),null);
var seq__11350_11359 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11351_11360 = null;
var count__11352_11361 = (0);
var i__11353_11362 = (0);
while(true){
if((i__11353_11362 < count__11352_11361)){
var vec__11354_11363 = cljs.core._nth.call(null,chunk__11351_11360,i__11353_11362);
var type_11364 = cljs.core.nth.call(null,vec__11354_11363,(0),null);
var f_11365 = cljs.core.nth.call(null,vec__11354_11363,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11364,((function (seq__11350_11359,chunk__11351_11360,count__11352_11361,i__11353_11362,vec__11354_11363,type_11364,f_11365,vec__11349_11356,elem_11357,selector_11358){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11364,dommy$core$this_fn);

return f_11365.call(null,e);
});})(seq__11350_11359,chunk__11351_11360,count__11352_11361,i__11353_11362,vec__11354_11363,type_11364,f_11365,vec__11349_11356,elem_11357,selector_11358))
);

var G__11366 = seq__11350_11359;
var G__11367 = chunk__11351_11360;
var G__11368 = count__11352_11361;
var G__11369 = (i__11353_11362 + (1));
seq__11350_11359 = G__11366;
chunk__11351_11360 = G__11367;
count__11352_11361 = G__11368;
i__11353_11362 = G__11369;
continue;
} else {
var temp__4126__auto___11370 = cljs.core.seq.call(null,seq__11350_11359);
if(temp__4126__auto___11370){
var seq__11350_11371__$1 = temp__4126__auto___11370;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11350_11371__$1)){
var c__5061__auto___11372 = cljs.core.chunk_first.call(null,seq__11350_11371__$1);
var G__11373 = cljs.core.chunk_rest.call(null,seq__11350_11371__$1);
var G__11374 = c__5061__auto___11372;
var G__11375 = cljs.core.count.call(null,c__5061__auto___11372);
var G__11376 = (0);
seq__11350_11359 = G__11373;
chunk__11351_11360 = G__11374;
count__11352_11361 = G__11375;
i__11353_11362 = G__11376;
continue;
} else {
var vec__11355_11377 = cljs.core.first.call(null,seq__11350_11371__$1);
var type_11378 = cljs.core.nth.call(null,vec__11355_11377,(0),null);
var f_11379 = cljs.core.nth.call(null,vec__11355_11377,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11378,((function (seq__11350_11359,chunk__11351_11360,count__11352_11361,i__11353_11362,vec__11355_11377,type_11378,f_11379,seq__11350_11371__$1,temp__4126__auto___11370,vec__11349_11356,elem_11357,selector_11358){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11378,dommy$core$this_fn);

return f_11379.call(null,e);
});})(seq__11350_11359,chunk__11351_11360,count__11352_11361,i__11353_11362,vec__11355_11377,type_11378,f_11379,seq__11350_11371__$1,temp__4126__auto___11370,vec__11349_11356,elem_11357,selector_11358))
);

var G__11380 = cljs.core.next.call(null,seq__11350_11371__$1);
var G__11381 = null;
var G__11382 = (0);
var G__11383 = (0);
seq__11350_11359 = G__11380;
chunk__11351_11360 = G__11381;
count__11352_11361 = G__11382;
i__11353_11362 = G__11383;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq11347){
var G__11348 = cljs.core.first.call(null,seq11347);
var seq11347__$1 = cljs.core.next.call(null,seq11347);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11348,seq11347__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__11387){
var vec__11388 = p__11387;
var update_event_BANG_ = cljs.core.nth.call(null,vec__11388,(0),null);
if(dommy.core.descendant_QMARK_.call(null,node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name.call(null,event_type),true,true);

return node.dispatchEvent(update_event_BANG___$1.call(null,event));
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name.call(null,event_type))].join(''),update_event_BANG___$1.call(null,document.createEventObject()));
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq11384){
var G__11385 = cljs.core.first.call(null,seq11384);
var seq11384__$1 = cljs.core.next.call(null,seq11384);
var G__11386 = cljs.core.first.call(null,seq11384__$1);
var seq11384__$2 = cljs.core.next.call(null,seq11384__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11385,G__11386,seq11384__$2);
});
