// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_.call(null,class_name,class$,i)){
return i;
} else {
var G__11396 = (i + class$.length);
start_from = G__11396;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index.call(null,class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__11401 = arguments.length;
switch (G__11401) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var classes__$1 = clojure.string.trim.call(null,cljs.core.name.call(null,classes));
if(cljs.core.seq.call(null,classes__$1)){
var temp__4124__auto___11415 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11415)){
var class_list_11416 = temp__4124__auto___11415;
var seq__11402_11417 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11403_11418 = null;
var count__11404_11419 = (0);
var i__11405_11420 = (0);
while(true){
if((i__11405_11420 < count__11404_11419)){
var class_11421 = cljs.core._nth.call(null,chunk__11403_11418,i__11405_11420);
class_list_11416.add(class_11421);

var G__11422 = seq__11402_11417;
var G__11423 = chunk__11403_11418;
var G__11424 = count__11404_11419;
var G__11425 = (i__11405_11420 + (1));
seq__11402_11417 = G__11422;
chunk__11403_11418 = G__11423;
count__11404_11419 = G__11424;
i__11405_11420 = G__11425;
continue;
} else {
var temp__4126__auto___11426 = cljs.core.seq.call(null,seq__11402_11417);
if(temp__4126__auto___11426){
var seq__11402_11427__$1 = temp__4126__auto___11426;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11402_11427__$1)){
var c__5061__auto___11428 = cljs.core.chunk_first.call(null,seq__11402_11427__$1);
var G__11429 = cljs.core.chunk_rest.call(null,seq__11402_11427__$1);
var G__11430 = c__5061__auto___11428;
var G__11431 = cljs.core.count.call(null,c__5061__auto___11428);
var G__11432 = (0);
seq__11402_11417 = G__11429;
chunk__11403_11418 = G__11430;
count__11404_11419 = G__11431;
i__11405_11420 = G__11432;
continue;
} else {
var class_11433 = cljs.core.first.call(null,seq__11402_11427__$1);
class_list_11416.add(class_11433);

var G__11434 = cljs.core.next.call(null,seq__11402_11427__$1);
var G__11435 = null;
var G__11436 = (0);
var G__11437 = (0);
seq__11402_11417 = G__11434;
chunk__11403_11418 = G__11435;
count__11404_11419 = G__11436;
i__11405_11420 = G__11437;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_11438 = elem__$1.className;
var seq__11406_11439 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11407_11440 = null;
var count__11408_11441 = (0);
var i__11409_11442 = (0);
while(true){
if((i__11409_11442 < count__11408_11441)){
var class_11443 = cljs.core._nth.call(null,chunk__11407_11440,i__11409_11442);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11438,class_11443))){
} else {
elem__$1.className = (((class_name_11438 === ""))?class_11443:[cljs.core.str(class_name_11438),cljs.core.str(" "),cljs.core.str(class_11443)].join(''));
}

var G__11444 = seq__11406_11439;
var G__11445 = chunk__11407_11440;
var G__11446 = count__11408_11441;
var G__11447 = (i__11409_11442 + (1));
seq__11406_11439 = G__11444;
chunk__11407_11440 = G__11445;
count__11408_11441 = G__11446;
i__11409_11442 = G__11447;
continue;
} else {
var temp__4126__auto___11448 = cljs.core.seq.call(null,seq__11406_11439);
if(temp__4126__auto___11448){
var seq__11406_11449__$1 = temp__4126__auto___11448;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11406_11449__$1)){
var c__5061__auto___11450 = cljs.core.chunk_first.call(null,seq__11406_11449__$1);
var G__11451 = cljs.core.chunk_rest.call(null,seq__11406_11449__$1);
var G__11452 = c__5061__auto___11450;
var G__11453 = cljs.core.count.call(null,c__5061__auto___11450);
var G__11454 = (0);
seq__11406_11439 = G__11451;
chunk__11407_11440 = G__11452;
count__11408_11441 = G__11453;
i__11409_11442 = G__11454;
continue;
} else {
var class_11455 = cljs.core.first.call(null,seq__11406_11449__$1);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11438,class_11455))){
} else {
elem__$1.className = (((class_name_11438 === ""))?class_11455:[cljs.core.str(class_name_11438),cljs.core.str(" "),cljs.core.str(class_11455)].join(''));
}

var G__11456 = cljs.core.next.call(null,seq__11406_11449__$1);
var G__11457 = null;
var G__11458 = (0);
var G__11459 = (0);
seq__11406_11439 = G__11456;
chunk__11407_11440 = G__11457;
count__11408_11441 = G__11458;
i__11409_11442 = G__11459;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11410_11460 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__11411_11461 = null;
var count__11412_11462 = (0);
var i__11413_11463 = (0);
while(true){
if((i__11413_11463 < count__11412_11462)){
var c_11464 = cljs.core._nth.call(null,chunk__11411_11461,i__11413_11463);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11464);

var G__11465 = seq__11410_11460;
var G__11466 = chunk__11411_11461;
var G__11467 = count__11412_11462;
var G__11468 = (i__11413_11463 + (1));
seq__11410_11460 = G__11465;
chunk__11411_11461 = G__11466;
count__11412_11462 = G__11467;
i__11413_11463 = G__11468;
continue;
} else {
var temp__4126__auto___11469 = cljs.core.seq.call(null,seq__11410_11460);
if(temp__4126__auto___11469){
var seq__11410_11470__$1 = temp__4126__auto___11469;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11410_11470__$1)){
var c__5061__auto___11471 = cljs.core.chunk_first.call(null,seq__11410_11470__$1);
var G__11472 = cljs.core.chunk_rest.call(null,seq__11410_11470__$1);
var G__11473 = c__5061__auto___11471;
var G__11474 = cljs.core.count.call(null,c__5061__auto___11471);
var G__11475 = (0);
seq__11410_11460 = G__11472;
chunk__11411_11461 = G__11473;
count__11412_11462 = G__11474;
i__11413_11463 = G__11475;
continue;
} else {
var c_11476 = cljs.core.first.call(null,seq__11410_11470__$1);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11476);

var G__11477 = cljs.core.next.call(null,seq__11410_11470__$1);
var G__11478 = null;
var G__11479 = (0);
var G__11480 = (0);
seq__11410_11460 = G__11477;
chunk__11411_11461 = G__11478;
count__11412_11462 = G__11479;
i__11413_11463 = G__11480;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq11397){
var G__11398 = cljs.core.first.call(null,seq11397);
var seq11397__$1 = cljs.core.next.call(null,seq11397);
var G__11399 = cljs.core.first.call(null,seq11397__$1);
var seq11397__$2 = cljs.core.next.call(null,seq11397__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11398,G__11399,seq11397__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index.call(null,class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__11481 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__11481;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__11486 = arguments.length;
switch (G__11486) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11492 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11492)){
var class_list_11493 = temp__4124__auto___11492;
class_list_11493.remove(class$__$1);
} else {
var class_name_11494 = elem__$1.className;
var new_class_name_11495 = dommy.attrs.remove_class_str.call(null,class_name_11494,class$__$1);
if((class_name_11494 === new_class_name_11495)){
} else {
elem__$1.className = new_class_name_11495;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11487 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__11488 = null;
var count__11489 = (0);
var i__11490 = (0);
while(true){
if((i__11490 < count__11489)){
var c = cljs.core._nth.call(null,chunk__11488,i__11490);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11496 = seq__11487;
var G__11497 = chunk__11488;
var G__11498 = count__11489;
var G__11499 = (i__11490 + (1));
seq__11487 = G__11496;
chunk__11488 = G__11497;
count__11489 = G__11498;
i__11490 = G__11499;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq.call(null,seq__11487);
if(temp__4126__auto__){
var seq__11487__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11487__$1)){
var c__5061__auto__ = cljs.core.chunk_first.call(null,seq__11487__$1);
var G__11500 = cljs.core.chunk_rest.call(null,seq__11487__$1);
var G__11501 = c__5061__auto__;
var G__11502 = cljs.core.count.call(null,c__5061__auto__);
var G__11503 = (0);
seq__11487 = G__11500;
chunk__11488 = G__11501;
count__11489 = G__11502;
i__11490 = G__11503;
continue;
} else {
var c = cljs.core.first.call(null,seq__11487__$1);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11504 = cljs.core.next.call(null,seq__11487__$1);
var G__11505 = null;
var G__11506 = (0);
var G__11507 = (0);
seq__11487 = G__11504;
chunk__11488 = G__11505;
count__11489 = G__11506;
i__11490 = G__11507;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq11482){
var G__11483 = cljs.core.first.call(null,seq11482);
var seq11482__$1 = cljs.core.next.call(null,seq11482);
var G__11484 = cljs.core.first.call(null,seq11482__$1);
var seq11482__$2 = cljs.core.next.call(null,seq11482__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11483,G__11484,seq11482__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__11509 = arguments.length;
switch (G__11509) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11511 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11511)){
var class_list_11512 = temp__4124__auto___11511;
class_list_11512.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.call(null,elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_.call(null,elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.call(null,elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.call(null,elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p__11515){
var vec__11516 = p__11515;
var k = cljs.core.nth.call(null,vec__11516,(0),null);
var v = cljs.core.nth.call(null,vec__11516,(1),null);
return [cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str(":"),cljs.core.str(cljs.core.name.call(null,v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var style = elem__$1.style;
var seq__11519_11525 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11520_11526 = null;
var count__11521_11527 = (0);
var i__11522_11528 = (0);
while(true){
if((i__11522_11528 < count__11521_11527)){
var vec__11523_11529 = cljs.core._nth.call(null,chunk__11520_11526,i__11522_11528);
var k_11530 = cljs.core.nth.call(null,vec__11523_11529,(0),null);
var v_11531 = cljs.core.nth.call(null,vec__11523_11529,(1),null);
(style[cljs.core.name.call(null,k_11530)] = v_11531);

var G__11532 = seq__11519_11525;
var G__11533 = chunk__11520_11526;
var G__11534 = count__11521_11527;
var G__11535 = (i__11522_11528 + (1));
seq__11519_11525 = G__11532;
chunk__11520_11526 = G__11533;
count__11521_11527 = G__11534;
i__11522_11528 = G__11535;
continue;
} else {
var temp__4126__auto___11536 = cljs.core.seq.call(null,seq__11519_11525);
if(temp__4126__auto___11536){
var seq__11519_11537__$1 = temp__4126__auto___11536;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11519_11537__$1)){
var c__5061__auto___11538 = cljs.core.chunk_first.call(null,seq__11519_11537__$1);
var G__11539 = cljs.core.chunk_rest.call(null,seq__11519_11537__$1);
var G__11540 = c__5061__auto___11538;
var G__11541 = cljs.core.count.call(null,c__5061__auto___11538);
var G__11542 = (0);
seq__11519_11525 = G__11539;
chunk__11520_11526 = G__11540;
count__11521_11527 = G__11541;
i__11522_11528 = G__11542;
continue;
} else {
var vec__11524_11543 = cljs.core.first.call(null,seq__11519_11537__$1);
var k_11544 = cljs.core.nth.call(null,vec__11524_11543,(0),null);
var v_11545 = cljs.core.nth.call(null,vec__11524_11543,(1),null);
(style[cljs.core.name.call(null,k_11544)] = v_11545);

var G__11546 = cljs.core.next.call(null,seq__11519_11537__$1);
var G__11547 = null;
var G__11548 = (0);
var G__11549 = (0);
seq__11519_11525 = G__11546;
chunk__11520_11526 = G__11547;
count__11521_11527 = G__11548;
i__11522_11528 = G__11549;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq11517){
var G__11518 = cljs.core.first.call(null,seq11517);
var seq11517__$1 = cljs.core.next.call(null,seq11517);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11518,seq11517__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"k","k",-505765866,null)))].join('')));
}

return (window.getComputedStyle(dommy.template.__GT_node_like.call(null,elem))[cljs.core.name.call(null,k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11552_11558 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11553_11559 = null;
var count__11554_11560 = (0);
var i__11555_11561 = (0);
while(true){
if((i__11555_11561 < count__11554_11560)){
var vec__11556_11562 = cljs.core._nth.call(null,chunk__11553_11559,i__11555_11561);
var k_11563 = cljs.core.nth.call(null,vec__11556_11562,(0),null);
var v_11564 = cljs.core.nth.call(null,vec__11556_11562,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11563,[cljs.core.str(v_11564),cljs.core.str("px")].join(''));

var G__11565 = seq__11552_11558;
var G__11566 = chunk__11553_11559;
var G__11567 = count__11554_11560;
var G__11568 = (i__11555_11561 + (1));
seq__11552_11558 = G__11565;
chunk__11553_11559 = G__11566;
count__11554_11560 = G__11567;
i__11555_11561 = G__11568;
continue;
} else {
var temp__4126__auto___11569 = cljs.core.seq.call(null,seq__11552_11558);
if(temp__4126__auto___11569){
var seq__11552_11570__$1 = temp__4126__auto___11569;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11552_11570__$1)){
var c__5061__auto___11571 = cljs.core.chunk_first.call(null,seq__11552_11570__$1);
var G__11572 = cljs.core.chunk_rest.call(null,seq__11552_11570__$1);
var G__11573 = c__5061__auto___11571;
var G__11574 = cljs.core.count.call(null,c__5061__auto___11571);
var G__11575 = (0);
seq__11552_11558 = G__11572;
chunk__11553_11559 = G__11573;
count__11554_11560 = G__11574;
i__11555_11561 = G__11575;
continue;
} else {
var vec__11557_11576 = cljs.core.first.call(null,seq__11552_11570__$1);
var k_11577 = cljs.core.nth.call(null,vec__11557_11576,(0),null);
var v_11578 = cljs.core.nth.call(null,vec__11557_11576,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11577,[cljs.core.str(v_11578),cljs.core.str("px")].join(''));

var G__11579 = cljs.core.next.call(null,seq__11552_11570__$1);
var G__11580 = null;
var G__11581 = (0);
var G__11582 = (0);
seq__11552_11558 = G__11579;
chunk__11553_11559 = G__11580;
count__11554_11560 = G__11581;
i__11555_11561 = G__11582;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq11550){
var G__11551 = cljs.core.first.call(null,seq11550);
var seq11550__$1 = cljs.core.next.call(null,seq11550);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11551,seq11550__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style.call(null,dommy.template.__GT_node_like.call(null,elem),k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__11588 = arguments.length;
switch (G__11588) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.call(null,dommy.template.__GT_node_like.call(null,elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__11589 = dommy.template.__GT_node_like.call(null,elem);
(G__11589[cljs.core.name.call(null,k)] = v);

return G__11589;
} else {
var G__11590 = dommy.template.__GT_node_like.call(null,elem);
G__11590.setAttribute(cljs.core.name.call(null,k),(((k === new cljs.core.Keyword(null,"style","style",-496642736)))?dommy.attrs.style_str.call(null,v):v));

return G__11590;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11591_11598 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__11592_11599 = null;
var count__11593_11600 = (0);
var i__11594_11601 = (0);
while(true){
if((i__11594_11601 < count__11593_11600)){
var vec__11595_11602 = cljs.core._nth.call(null,chunk__11592_11599,i__11594_11601);
var k_11603__$1 = cljs.core.nth.call(null,vec__11595_11602,(0),null);
var v_11604__$1 = cljs.core.nth.call(null,vec__11595_11602,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11603__$1,v_11604__$1);

var G__11605 = seq__11591_11598;
var G__11606 = chunk__11592_11599;
var G__11607 = count__11593_11600;
var G__11608 = (i__11594_11601 + (1));
seq__11591_11598 = G__11605;
chunk__11592_11599 = G__11606;
count__11593_11600 = G__11607;
i__11594_11601 = G__11608;
continue;
} else {
var temp__4126__auto___11609 = cljs.core.seq.call(null,seq__11591_11598);
if(temp__4126__auto___11609){
var seq__11591_11610__$1 = temp__4126__auto___11609;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11591_11610__$1)){
var c__5061__auto___11611 = cljs.core.chunk_first.call(null,seq__11591_11610__$1);
var G__11612 = cljs.core.chunk_rest.call(null,seq__11591_11610__$1);
var G__11613 = c__5061__auto___11611;
var G__11614 = cljs.core.count.call(null,c__5061__auto___11611);
var G__11615 = (0);
seq__11591_11598 = G__11612;
chunk__11592_11599 = G__11613;
count__11593_11600 = G__11614;
i__11594_11601 = G__11615;
continue;
} else {
var vec__11596_11616 = cljs.core.first.call(null,seq__11591_11610__$1);
var k_11617__$1 = cljs.core.nth.call(null,vec__11596_11616,(0),null);
var v_11618__$1 = cljs.core.nth.call(null,vec__11596_11616,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11617__$1,v_11618__$1);

var G__11619 = cljs.core.next.call(null,seq__11591_11610__$1);
var G__11620 = null;
var G__11621 = (0);
var G__11622 = (0);
seq__11591_11598 = G__11619;
chunk__11592_11599 = G__11620;
count__11593_11600 = G__11621;
i__11594_11601 = G__11622;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq11583){
var G__11584 = cljs.core.first.call(null,seq11583);
var seq11583__$1 = cljs.core.next.call(null,seq11583);
var G__11585 = cljs.core.first.call(null,seq11583__$1);
var seq11583__$2 = cljs.core.next.call(null,seq11583__$1);
var G__11586 = cljs.core.first.call(null,seq11583__$2);
var seq11583__$3 = cljs.core.next.call(null,seq11583__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11584,G__11585,G__11586,seq11583__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__11627 = arguments.length;
switch (G__11627) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),null,new cljs.core.Keyword(null,"classes","classes",2037804510),null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name.call(null,k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11628_11633 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__11629_11634 = null;
var count__11630_11635 = (0);
var i__11631_11636 = (0);
while(true){
if((i__11631_11636 < count__11630_11635)){
var k_11637__$1 = cljs.core._nth.call(null,chunk__11629_11634,i__11631_11636);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11637__$1);

var G__11638 = seq__11628_11633;
var G__11639 = chunk__11629_11634;
var G__11640 = count__11630_11635;
var G__11641 = (i__11631_11636 + (1));
seq__11628_11633 = G__11638;
chunk__11629_11634 = G__11639;
count__11630_11635 = G__11640;
i__11631_11636 = G__11641;
continue;
} else {
var temp__4126__auto___11642 = cljs.core.seq.call(null,seq__11628_11633);
if(temp__4126__auto___11642){
var seq__11628_11643__$1 = temp__4126__auto___11642;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11628_11643__$1)){
var c__5061__auto___11644 = cljs.core.chunk_first.call(null,seq__11628_11643__$1);
var G__11645 = cljs.core.chunk_rest.call(null,seq__11628_11643__$1);
var G__11646 = c__5061__auto___11644;
var G__11647 = cljs.core.count.call(null,c__5061__auto___11644);
var G__11648 = (0);
seq__11628_11633 = G__11645;
chunk__11629_11634 = G__11646;
count__11630_11635 = G__11647;
i__11631_11636 = G__11648;
continue;
} else {
var k_11649__$1 = cljs.core.first.call(null,seq__11628_11643__$1);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11649__$1);

var G__11650 = cljs.core.next.call(null,seq__11628_11643__$1);
var G__11651 = null;
var G__11652 = (0);
var G__11653 = (0);
seq__11628_11633 = G__11650;
chunk__11629_11634 = G__11651;
count__11630_11635 = G__11652;
i__11631_11636 = G__11653;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq11623){
var G__11624 = cljs.core.first.call(null,seq11623);
var seq11623__$1 = cljs.core.next.call(null,seq11623);
var G__11625 = cljs.core.first.call(null,seq11623__$1);
var seq11623__$2 = cljs.core.next.call(null,seq11623__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11624,G__11625,seq11623__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like.call(null,elem).getAttribute(cljs.core.name.call(null,k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__11655 = arguments.length;
switch (G__11655) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.attrs.attr.call(null,elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.call(null,elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like.call(null,elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__11658 = arguments.length;
switch (G__11658) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__11659 = dommy.template.__GT_node_like.call(null,elem);
G__11659.style.display = ((show_QMARK_)?"":"none");

return G__11659;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,elem__$1,dommy.attrs.hidden_QMARK_.call(null,elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__11662 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11662,false);

return G__11662;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__11664 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11664,true);

return G__11664;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.call(null,(function (){var G__11666 = dommy.template.__GT_node_like.call(null,elem).getBoundingClientRect();
(G__11666["constructor"] = Object);

return G__11666;
})(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect.call(null,elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
