// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq41917){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41917));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq41918){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41918));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41921){
var vec__41922 = p__41921;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41922,(0),null);

var G__41923 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__41923) : milia.api.io.raw_request.call(null,G__41923));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq41919){
var G__41920 = cljs.core.first(seq41919);
var seq41919__$1 = cljs.core.next(seq41919);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__41920,seq41919__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41926){
var vec__41927 = p__41926;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41927,(0),null);

var G__41928 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__41928) : milia.api.io.raw_request.call(null,G__41928));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq41924){
var G__41925 = cljs.core.first(seq41924);
var seq41924__$1 = cljs.core.next(seq41924);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__41925,seq41924__$1);
});
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__41933){
var map__41934 = p__41933;
var map__41934__$1 = ((cljs.core.seq_QMARK_(map__41934))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41934):map__41934);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41934__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41934__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41934__$1,cljs.core.constant$keyword$token);
var Authorization = ((function (map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__41929_SHARP_){
if(cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__41929_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join(''));
} else {
return null;
}
});})(map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
var Cache_control = ((function (Authorization,map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__41930_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__41930_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(Authorization,map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
var X_CSRFToken = ((function (Authorization,Cache_control,map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__41931_SHARP_){
var temp__4126__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__41935 = "csrftoken";
return goog.net.cookies.get(G__41935);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var crsf_token = temp__4126__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__41931_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(Authorization,Cache_control,map__41934,map__41934__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(Authorization,Cache_control,X_CSRFToken).call(null),cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq41932){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41932));
});
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__41948 = null;
var G__41948__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__41948__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__41948__4 = (function() { 
var G__41949__delegate = function (url,query_params,token,p__41943){
var map__41944 = p__41943;
var map__41944__$1 = ((cljs.core.seq_QMARK_(map__41944))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41944):map__41944);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41944__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$token,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,token),cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$)], 0));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__41945 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__41945) : cljs_hash.md5.md5.call(null,G__41945));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__41946 = url;
var G__41947 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__41946,G__41947) : http_method.call(null,G__41946,G__41947));
};
var G__41949 = function (url,query_params,token,var_args){
var p__41943 = null;
if (arguments.length > 3) {
var G__41950__i = 0, G__41950__a = new Array(arguments.length -  3);
while (G__41950__i < G__41950__a.length) {G__41950__a[G__41950__i] = arguments[G__41950__i + 3]; ++G__41950__i;}
  p__41943 = new cljs.core.IndexedSeq(G__41950__a,0);
} 
return G__41949__delegate.call(this,url,query_params,token,p__41943);};
G__41949.cljs$lang$maxFixedArity = 3;
G__41949.cljs$lang$applyTo = (function (arglist__41951){
var url = cljs.core.first(arglist__41951);
arglist__41951 = cljs.core.next(arglist__41951);
var query_params = cljs.core.first(arglist__41951);
arglist__41951 = cljs.core.next(arglist__41951);
var token = cljs.core.first(arglist__41951);
var p__41943 = cljs.core.rest(arglist__41951);
return G__41949__delegate(url,query_params,token,p__41943);
});
G__41949.cljs$core$IFn$_invoke$arity$variadic = G__41949__delegate;
return G__41949;
})()
;
G__41948 = function(url,query_params,token,var_args){
var p__41943 = var_args;
switch(arguments.length){
case 1:
return G__41948__1.call(this,url);
case 2:
return G__41948__2.call(this,url,query_params);
default:
var G__41952 = null;
if (arguments.length > 3) {
var G__41953__i = 0, G__41953__a = new Array(arguments.length -  3);
while (G__41953__i < G__41953__a.length) {G__41953__a[G__41953__i] = arguments[G__41953__i + 3]; ++G__41953__i;}
G__41952 = new cljs.core.IndexedSeq(G__41953__a,0);
}
return G__41948__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__41952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__41948.cljs$lang$maxFixedArity = 3;
G__41948.cljs$lang$applyTo = G__41948__4.cljs$lang$applyTo;
G__41948.cljs$core$IFn$_invoke$arity$1 = G__41948__1;
G__41948.cljs$core$IFn$_invoke$arity$2 = G__41948__2;
G__41948.cljs$core$IFn$_invoke$arity$variadic = G__41948__4.cljs$core$IFn$_invoke$arity$variadic;
return G__41948;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__41961 = arguments.length;
switch (G__41961) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_41972){
var state_val_41973 = (state_41972[(1)]);
if((state_val_41973 === (5))){
var inst_41970 = (state_41972[(2)]);
var state_41972__$1 = state_41972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41972__$1,inst_41970);
} else {
if((state_val_41973 === (4))){
var state_41972__$1 = state_41972;
var statearr_41974_41992 = state_41972__$1;
(statearr_41974_41992[(2)] = null);

(statearr_41974_41992[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_41973 === (3))){
var inst_41965 = (state_41972[(7)]);
var inst_41967 = (function (){var G__41975 = inst_41965;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__41975) : callback.call(null,G__41975));
})();
var state_41972__$1 = state_41972;
var statearr_41976_41993 = state_41972__$1;
(statearr_41976_41993[(2)] = inst_41967);

(statearr_41976_41993[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_41973 === (2))){
var inst_41965 = (state_41972[(2)]);
var state_41972__$1 = (function (){var statearr_41977 = state_41972;
(statearr_41977[(7)] = inst_41965);

return statearr_41977;
})();
if(cljs.core.truth_(callback)){
var statearr_41978_41994 = state_41972__$1;
(statearr_41978_41994[(1)] = (3));

} else {
var statearr_41979_41995 = state_41972__$1;
(statearr_41979_41995[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_41973 === (1))){
var inst_41962 = milia.api.io.query_helper(method);
var inst_41963 = (function (){var G__41980 = url;
var G__41981 = query_params;
var G__41982 = token;
var G__41983 = opts;
return (inst_41962.cljs$core$IFn$_invoke$arity$4 ? inst_41962.cljs$core$IFn$_invoke$arity$4(G__41980,G__41981,G__41982,G__41983) : inst_41962.call(null,G__41980,G__41981,G__41982,G__41983));
})();
var state_41972__$1 = state_41972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41972__$1,(2),inst_41963);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_41987 = [null,null,null,null,null,null,null,null];
(statearr_41987[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_41987[(1)] = (1));

return statearr_41987;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_41972){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_41972);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e41988){if((e41988 instanceof Object)){
var ex__7651__auto__ = e41988;
var statearr_41989_41996 = state_41972;
(statearr_41989_41996[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41972);

return cljs.core.constant$keyword$recur;
} else {
throw e41988;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__41997 = state_41972;
state_41972 = G__41997;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_41972){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_41972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_41990 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_41990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_41990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq41954){
var G__41955 = cljs.core.first(seq41954);
var seq41954__$1 = cljs.core.next(seq41954);
var G__41956 = cljs.core.first(seq41954__$1);
var seq41954__$2 = cljs.core.next(seq41954__$1);
var G__41957 = cljs.core.first(seq41954__$2);
var seq41954__$3 = cljs.core.next(seq41954__$2);
var G__41958 = cljs.core.first(seq41954__$3);
var seq41954__$4 = cljs.core.next(seq41954__$3);
var G__41959 = cljs.core.first(seq41954__$4);
var seq41954__$5 = cljs.core.next(seq41954__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__41955,G__41956,G__41957,G__41958,G__41959,seq41954__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__41999 = arguments.length;
switch (G__41999) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42000 = event.target;
var G__42001 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42000,G__42001) : dommy.core.attr.call(null,G__42000,G__42001));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__42002 = event.target.form;
var G__42003 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42002,G__42003) : dommy.core.attr.call(null,G__42002,G__42003));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__42006 = arguments.length;
switch (G__42006) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42007 = event.target;
var G__42008 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42007,G__42008) : dommy.core.attr.call(null,G__42007,G__42008));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42143){
var state_val_42144 = (state_42143[(1)]);
if((state_val_42144 === (7))){
var inst_42108 = (state_42143[(2)]);
var state_42143__$1 = state_42143;
var statearr_42145_42190 = state_42143__$1;
(statearr_42145_42190[(2)] = inst_42108);

(statearr_42145_42190[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (20))){
var state_42143__$1 = state_42143;
var statearr_42146_42191 = state_42143__$1;
(statearr_42146_42191[(2)] = null);

(statearr_42146_42191[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (1))){
var inst_42100 = (state_42143[(7)]);
var inst_42100__$1 = (auth_token == null);
var state_42143__$1 = (function (){var statearr_42147 = state_42143;
(statearr_42147[(7)] = inst_42100__$1);

return statearr_42147;
})();
if(cljs.core.truth_(inst_42100__$1)){
var statearr_42148_42192 = state_42143__$1;
(statearr_42148_42192[(1)] = (2));

} else {
var statearr_42149_42193 = state_42143__$1;
(statearr_42149_42193[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (4))){
var inst_42110 = (state_42143[(2)]);
var state_42143__$1 = state_42143;
if(cljs.core.truth_(inst_42110)){
var statearr_42150_42194 = state_42143__$1;
(statearr_42150_42194[(1)] = (8));

} else {
var statearr_42151_42195 = state_42143__$1;
(statearr_42151_42195[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (15))){
var inst_42123 = (state_42143[(8)]);
var inst_42123__$1 = (state_42143[(2)]);
var inst_42124 = cljs.core.seq_QMARK_(inst_42123__$1);
var state_42143__$1 = (function (){var statearr_42152 = state_42143;
(statearr_42152[(8)] = inst_42123__$1);

return statearr_42152;
})();
if(inst_42124){
var statearr_42153_42196 = state_42143__$1;
(statearr_42153_42196[(1)] = (16));

} else {
var statearr_42154_42197 = state_42143__$1;
(statearr_42154_42197[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (21))){
var inst_42136 = (state_42143[(2)]);
var state_42143__$1 = state_42143;
var statearr_42155_42198 = state_42143__$1;
(statearr_42155_42198[(2)] = inst_42136);

(statearr_42155_42198[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (13))){
var state_42143__$1 = state_42143;
var statearr_42156_42199 = state_42143__$1;
(statearr_42156_42199[(2)] = auth_token);

(statearr_42156_42199[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (6))){
var inst_42106 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_42143__$1 = state_42143;
var statearr_42157_42200 = state_42143__$1;
(statearr_42157_42200[(2)] = inst_42106);

(statearr_42157_42200[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (17))){
var inst_42123 = (state_42143[(8)]);
var state_42143__$1 = state_42143;
var statearr_42158_42201 = state_42143__$1;
(statearr_42158_42201[(2)] = inst_42123);

(statearr_42158_42201[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (3))){
var inst_42103 = (state_42143[(9)]);
var inst_42103__$1 = clojure.string.blank_QMARK_(auth_token);
var state_42143__$1 = (function (){var statearr_42159 = state_42143;
(statearr_42159[(9)] = inst_42103__$1);

return statearr_42159;
})();
if(cljs.core.truth_(inst_42103__$1)){
var statearr_42160_42202 = state_42143__$1;
(statearr_42160_42202[(1)] = (5));

} else {
var statearr_42161_42203 = state_42143__$1;
(statearr_42161_42203[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (12))){
var inst_42120 = milia.api.io.refresh_token_url(username);
var inst_42121 = (function (){var G__42162 = inst_42120;
var G__42163 = null;
var G__42164 = null;
var G__42165 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42166 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42162,G__42163,G__42164,G__42165,G__42166) : milia.api.io.get_url.call(null,G__42162,G__42163,G__42164,G__42165,G__42166));
})();
var state_42143__$1 = state_42143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42143__$1,(15),inst_42121);
} else {
if((state_val_42144 === (2))){
var inst_42100 = (state_42143[(7)]);
var state_42143__$1 = state_42143;
var statearr_42167_42204 = state_42143__$1;
(statearr_42167_42204[(2)] = inst_42100);

(statearr_42167_42204[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (19))){
var inst_42130 = (state_42143[(10)]);
var state_42143__$1 = state_42143;
var statearr_42168_42205 = state_42143__$1;
(statearr_42168_42205[(2)] = inst_42130);

(statearr_42168_42205[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (11))){
var inst_42116 = (state_42143[(2)]);
var inst_42117 = milia.api.io.invalid_token_QMARK_(inst_42116);
var state_42143__$1 = state_42143;
if(cljs.core.truth_(inst_42117)){
var statearr_42169_42206 = state_42143__$1;
(statearr_42169_42206[(1)] = (12));

} else {
var statearr_42170_42207 = state_42143__$1;
(statearr_42170_42207[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (9))){
var inst_42113 = milia.api.io.validate_token_url(username);
var inst_42114 = (function (){var G__42171 = inst_42113;
var G__42172 = null;
var G__42173 = null;
var G__42174 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42175 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42171,G__42172,G__42173,G__42174,G__42175) : milia.api.io.get_url.call(null,G__42171,G__42172,G__42173,G__42174,G__42175));
})();
var state_42143__$1 = state_42143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42143__$1,(11),inst_42114);
} else {
if((state_val_42144 === (5))){
var inst_42103 = (state_42143[(9)]);
var state_42143__$1 = state_42143;
var statearr_42176_42208 = state_42143__$1;
(statearr_42176_42208[(2)] = inst_42103);

(statearr_42176_42208[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (14))){
var inst_42139 = (state_42143[(2)]);
var state_42143__$1 = state_42143;
var statearr_42177_42209 = state_42143__$1;
(statearr_42177_42209[(2)] = inst_42139);

(statearr_42177_42209[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (16))){
var inst_42123 = (state_42143[(8)]);
var inst_42126 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42123);
var state_42143__$1 = state_42143;
var statearr_42178_42210 = state_42143__$1;
(statearr_42178_42210[(2)] = inst_42126);

(statearr_42178_42210[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (10))){
var inst_42141 = (state_42143[(2)]);
var state_42143__$1 = state_42143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42143__$1,inst_42141);
} else {
if((state_val_42144 === (18))){
var inst_42129 = (state_42143[(2)]);
var inst_42130 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42129,cljs.core.constant$keyword$body);
var inst_42131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42129,cljs.core.constant$keyword$status);
var inst_42132 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42131,(200));
var state_42143__$1 = (function (){var statearr_42179 = state_42143;
(statearr_42179[(10)] = inst_42130);

return statearr_42179;
})();
if(inst_42132){
var statearr_42180_42211 = state_42143__$1;
(statearr_42180_42211[(1)] = (19));

} else {
var statearr_42181_42212 = state_42143__$1;
(statearr_42181_42212[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42144 === (8))){
var state_42143__$1 = state_42143;
var statearr_42182_42213 = state_42143__$1;
(statearr_42182_42213[(2)] = null);

(statearr_42182_42213[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_42186 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42186[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_42186[(1)] = (1));

return statearr_42186;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_42143){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42143);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42187){if((e42187 instanceof Object)){
var ex__7651__auto__ = e42187;
var statearr_42188_42214 = state_42143;
(statearr_42188_42214[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42143);

return cljs.core.constant$keyword$recur;
} else {
throw e42187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42215 = state_42143;
state_42143 = G__42215;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_42143){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_42143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42189 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__42222_42228 = io_obj;
var G__42223_42229 = goog.net.EventType.SUCCESS;
var G__42224_42230 = ((function (G__42222_42228,G__42223_42229,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42222_42228,G__42223_42229,io_obj,url))
;
goog.events.listen(G__42222_42228,G__42223_42229,G__42224_42230);

var G__42225_42231 = io_obj;
var G__42226_42232 = goog.net.EventType.ERROR;
var G__42227_42233 = ((function (G__42225_42231,G__42226_42232,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42225_42231,G__42226_42232,io_obj,url))
;
goog.events.listen(G__42225_42231,G__42226_42232,G__42227_42233);

return io_obj.sendFromForm(form,url);
});
