// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq42563){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42563));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq42564){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42564));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__42567){
var vec__42568 = p__42567;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42568,(0),null);

var G__42569 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__42569) : milia.api.io.raw_request.call(null,G__42569));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq42565){
var G__42566 = cljs.core.first(seq42565);
var seq42565__$1 = cljs.core.next(seq42565);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__42566,seq42565__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__42572){
var vec__42573 = p__42572;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42573,(0),null);

var G__42574 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__42574) : milia.api.io.raw_request.call(null,G__42574));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq42570){
var G__42571 = cljs.core.first(seq42570);
var seq42570__$1 = cljs.core.next(seq42570);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__42571,seq42570__$1);
});
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var G__42576 = arguments.length;
switch (G__42576) {
case 1:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,false);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__42577 = "csrftoken";
return goog.net.cookies.get(G__42577);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__42591 = null;
var G__42591__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__42591__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__42591__4 = (function() { 
var G__42592__delegate = function (url,query_params,token,p__42586){
var map__42587 = p__42586;
var map__42587__$1 = ((cljs.core.seq_QMARK_(map__42587))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42587):map__42587);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42587__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,token),cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__42588 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__42588) : cljs_hash.md5.md5.call(null,G__42588));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__42589 = url;
var G__42590 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__42589,G__42590) : http_method.call(null,G__42589,G__42590));
};
var G__42592 = function (url,query_params,token,var_args){
var p__42586 = null;
if (arguments.length > 3) {
var G__42593__i = 0, G__42593__a = new Array(arguments.length -  3);
while (G__42593__i < G__42593__a.length) {G__42593__a[G__42593__i] = arguments[G__42593__i + 3]; ++G__42593__i;}
  p__42586 = new cljs.core.IndexedSeq(G__42593__a,0);
} 
return G__42592__delegate.call(this,url,query_params,token,p__42586);};
G__42592.cljs$lang$maxFixedArity = 3;
G__42592.cljs$lang$applyTo = (function (arglist__42594){
var url = cljs.core.first(arglist__42594);
arglist__42594 = cljs.core.next(arglist__42594);
var query_params = cljs.core.first(arglist__42594);
arglist__42594 = cljs.core.next(arglist__42594);
var token = cljs.core.first(arglist__42594);
var p__42586 = cljs.core.rest(arglist__42594);
return G__42592__delegate(url,query_params,token,p__42586);
});
G__42592.cljs$core$IFn$_invoke$arity$variadic = G__42592__delegate;
return G__42592;
})()
;
G__42591 = function(url,query_params,token,var_args){
var p__42586 = var_args;
switch(arguments.length){
case 1:
return G__42591__1.call(this,url);
case 2:
return G__42591__2.call(this,url,query_params);
default:
var G__42595 = null;
if (arguments.length > 3) {
var G__42596__i = 0, G__42596__a = new Array(arguments.length -  3);
while (G__42596__i < G__42596__a.length) {G__42596__a[G__42596__i] = arguments[G__42596__i + 3]; ++G__42596__i;}
G__42595 = new cljs.core.IndexedSeq(G__42596__a,0);
}
return G__42591__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__42595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42591.cljs$lang$maxFixedArity = 3;
G__42591.cljs$lang$applyTo = G__42591__4.cljs$lang$applyTo;
G__42591.cljs$core$IFn$_invoke$arity$1 = G__42591__1;
G__42591.cljs$core$IFn$_invoke$arity$2 = G__42591__2;
G__42591.cljs$core$IFn$_invoke$arity$variadic = G__42591__4.cljs$core$IFn$_invoke$arity$variadic;
return G__42591;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__42604 = arguments.length;
switch (G__42604) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42615){
var state_val_42616 = (state_42615[(1)]);
if((state_val_42616 === (5))){
var inst_42613 = (state_42615[(2)]);
var state_42615__$1 = state_42615;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42615__$1,inst_42613);
} else {
if((state_val_42616 === (4))){
var state_42615__$1 = state_42615;
var statearr_42617_42635 = state_42615__$1;
(statearr_42617_42635[(2)] = null);

(statearr_42617_42635[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42616 === (3))){
var inst_42608 = (state_42615[(7)]);
var inst_42610 = (function (){var G__42618 = inst_42608;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__42618) : callback.call(null,G__42618));
})();
var state_42615__$1 = state_42615;
var statearr_42619_42636 = state_42615__$1;
(statearr_42619_42636[(2)] = inst_42610);

(statearr_42619_42636[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42616 === (2))){
var inst_42608 = (state_42615[(2)]);
var state_42615__$1 = (function (){var statearr_42620 = state_42615;
(statearr_42620[(7)] = inst_42608);

return statearr_42620;
})();
if(cljs.core.truth_(callback)){
var statearr_42621_42637 = state_42615__$1;
(statearr_42621_42637[(1)] = (3));

} else {
var statearr_42622_42638 = state_42615__$1;
(statearr_42622_42638[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42616 === (1))){
var inst_42605 = milia.api.io.query_helper(method);
var inst_42606 = (function (){var G__42623 = url;
var G__42624 = query_params;
var G__42625 = token;
var G__42626 = opts;
return (inst_42605.cljs$core$IFn$_invoke$arity$4 ? inst_42605.cljs$core$IFn$_invoke$arity$4(G__42623,G__42624,G__42625,G__42626) : inst_42605.call(null,G__42623,G__42624,G__42625,G__42626));
})();
var state_42615__$1 = state_42615;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42615__$1,(2),inst_42606);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_42630 = [null,null,null,null,null,null,null,null];
(statearr_42630[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_42630[(1)] = (1));

return statearr_42630;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_42615){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42615);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42631){if((e42631 instanceof Object)){
var ex__7651__auto__ = e42631;
var statearr_42632_42639 = state_42615;
(statearr_42632_42639[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42615);

return cljs.core.constant$keyword$recur;
} else {
throw e42631;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42640 = state_42615;
state_42615 = G__42640;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_42615){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_42615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42633 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42633[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq42597){
var G__42598 = cljs.core.first(seq42597);
var seq42597__$1 = cljs.core.next(seq42597);
var G__42599 = cljs.core.first(seq42597__$1);
var seq42597__$2 = cljs.core.next(seq42597__$1);
var G__42600 = cljs.core.first(seq42597__$2);
var seq42597__$3 = cljs.core.next(seq42597__$2);
var G__42601 = cljs.core.first(seq42597__$3);
var seq42597__$4 = cljs.core.next(seq42597__$3);
var G__42602 = cljs.core.first(seq42597__$4);
var seq42597__$5 = cljs.core.next(seq42597__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42598,G__42599,G__42600,G__42601,G__42602,seq42597__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__42642 = arguments.length;
switch (G__42642) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42643 = event.target;
var G__42644 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42643,G__42644) : dommy.core.attr.call(null,G__42643,G__42644));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__42645 = event.target.form;
var G__42646 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42645,G__42646) : dommy.core.attr.call(null,G__42645,G__42646));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__42649 = arguments.length;
switch (G__42649) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42650 = event.target;
var G__42651 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42650,G__42651) : dommy.core.attr.call(null,G__42650,G__42651));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42786){
var state_val_42787 = (state_42786[(1)]);
if((state_val_42787 === (7))){
var inst_42751 = (state_42786[(2)]);
var state_42786__$1 = state_42786;
var statearr_42788_42833 = state_42786__$1;
(statearr_42788_42833[(2)] = inst_42751);

(statearr_42788_42833[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (20))){
var state_42786__$1 = state_42786;
var statearr_42789_42834 = state_42786__$1;
(statearr_42789_42834[(2)] = null);

(statearr_42789_42834[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (1))){
var inst_42743 = (state_42786[(7)]);
var inst_42743__$1 = (auth_token == null);
var state_42786__$1 = (function (){var statearr_42790 = state_42786;
(statearr_42790[(7)] = inst_42743__$1);

return statearr_42790;
})();
if(cljs.core.truth_(inst_42743__$1)){
var statearr_42791_42835 = state_42786__$1;
(statearr_42791_42835[(1)] = (2));

} else {
var statearr_42792_42836 = state_42786__$1;
(statearr_42792_42836[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (4))){
var inst_42753 = (state_42786[(2)]);
var state_42786__$1 = state_42786;
if(cljs.core.truth_(inst_42753)){
var statearr_42793_42837 = state_42786__$1;
(statearr_42793_42837[(1)] = (8));

} else {
var statearr_42794_42838 = state_42786__$1;
(statearr_42794_42838[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (15))){
var inst_42766 = (state_42786[(8)]);
var inst_42766__$1 = (state_42786[(2)]);
var inst_42767 = cljs.core.seq_QMARK_(inst_42766__$1);
var state_42786__$1 = (function (){var statearr_42795 = state_42786;
(statearr_42795[(8)] = inst_42766__$1);

return statearr_42795;
})();
if(inst_42767){
var statearr_42796_42839 = state_42786__$1;
(statearr_42796_42839[(1)] = (16));

} else {
var statearr_42797_42840 = state_42786__$1;
(statearr_42797_42840[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (21))){
var inst_42779 = (state_42786[(2)]);
var state_42786__$1 = state_42786;
var statearr_42798_42841 = state_42786__$1;
(statearr_42798_42841[(2)] = inst_42779);

(statearr_42798_42841[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (13))){
var state_42786__$1 = state_42786;
var statearr_42799_42842 = state_42786__$1;
(statearr_42799_42842[(2)] = auth_token);

(statearr_42799_42842[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (6))){
var inst_42749 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_42786__$1 = state_42786;
var statearr_42800_42843 = state_42786__$1;
(statearr_42800_42843[(2)] = inst_42749);

(statearr_42800_42843[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (17))){
var inst_42766 = (state_42786[(8)]);
var state_42786__$1 = state_42786;
var statearr_42801_42844 = state_42786__$1;
(statearr_42801_42844[(2)] = inst_42766);

(statearr_42801_42844[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (3))){
var inst_42746 = (state_42786[(9)]);
var inst_42746__$1 = clojure.string.blank_QMARK_(auth_token);
var state_42786__$1 = (function (){var statearr_42802 = state_42786;
(statearr_42802[(9)] = inst_42746__$1);

return statearr_42802;
})();
if(cljs.core.truth_(inst_42746__$1)){
var statearr_42803_42845 = state_42786__$1;
(statearr_42803_42845[(1)] = (5));

} else {
var statearr_42804_42846 = state_42786__$1;
(statearr_42804_42846[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (12))){
var inst_42763 = milia.api.io.refresh_token_url(username);
var inst_42764 = (function (){var G__42805 = inst_42763;
var G__42806 = null;
var G__42807 = null;
var G__42808 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42809 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42805,G__42806,G__42807,G__42808,G__42809) : milia.api.io.get_url.call(null,G__42805,G__42806,G__42807,G__42808,G__42809));
})();
var state_42786__$1 = state_42786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42786__$1,(15),inst_42764);
} else {
if((state_val_42787 === (2))){
var inst_42743 = (state_42786[(7)]);
var state_42786__$1 = state_42786;
var statearr_42810_42847 = state_42786__$1;
(statearr_42810_42847[(2)] = inst_42743);

(statearr_42810_42847[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (19))){
var inst_42773 = (state_42786[(10)]);
var state_42786__$1 = state_42786;
var statearr_42811_42848 = state_42786__$1;
(statearr_42811_42848[(2)] = inst_42773);

(statearr_42811_42848[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (11))){
var inst_42759 = (state_42786[(2)]);
var inst_42760 = milia.api.io.invalid_token_QMARK_(inst_42759);
var state_42786__$1 = state_42786;
if(cljs.core.truth_(inst_42760)){
var statearr_42812_42849 = state_42786__$1;
(statearr_42812_42849[(1)] = (12));

} else {
var statearr_42813_42850 = state_42786__$1;
(statearr_42813_42850[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (9))){
var inst_42756 = milia.api.io.validate_token_url(username);
var inst_42757 = (function (){var G__42814 = inst_42756;
var G__42815 = null;
var G__42816 = null;
var G__42817 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42818 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42814,G__42815,G__42816,G__42817,G__42818) : milia.api.io.get_url.call(null,G__42814,G__42815,G__42816,G__42817,G__42818));
})();
var state_42786__$1 = state_42786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42786__$1,(11),inst_42757);
} else {
if((state_val_42787 === (5))){
var inst_42746 = (state_42786[(9)]);
var state_42786__$1 = state_42786;
var statearr_42819_42851 = state_42786__$1;
(statearr_42819_42851[(2)] = inst_42746);

(statearr_42819_42851[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (14))){
var inst_42782 = (state_42786[(2)]);
var state_42786__$1 = state_42786;
var statearr_42820_42852 = state_42786__$1;
(statearr_42820_42852[(2)] = inst_42782);

(statearr_42820_42852[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (16))){
var inst_42766 = (state_42786[(8)]);
var inst_42769 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42766);
var state_42786__$1 = state_42786;
var statearr_42821_42853 = state_42786__$1;
(statearr_42821_42853[(2)] = inst_42769);

(statearr_42821_42853[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (10))){
var inst_42784 = (state_42786[(2)]);
var state_42786__$1 = state_42786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42786__$1,inst_42784);
} else {
if((state_val_42787 === (18))){
var inst_42772 = (state_42786[(2)]);
var inst_42773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42772,cljs.core.constant$keyword$body);
var inst_42774 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42772,cljs.core.constant$keyword$status);
var inst_42775 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42774,(200));
var state_42786__$1 = (function (){var statearr_42822 = state_42786;
(statearr_42822[(10)] = inst_42773);

return statearr_42822;
})();
if(inst_42775){
var statearr_42823_42854 = state_42786__$1;
(statearr_42823_42854[(1)] = (19));

} else {
var statearr_42824_42855 = state_42786__$1;
(statearr_42824_42855[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42787 === (8))){
var state_42786__$1 = state_42786;
var statearr_42825_42856 = state_42786__$1;
(statearr_42825_42856[(2)] = null);

(statearr_42825_42856[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_42829 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42829[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_42829[(1)] = (1));

return statearr_42829;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_42786){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42786);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42830){if((e42830 instanceof Object)){
var ex__7651__auto__ = e42830;
var statearr_42831_42857 = state_42786;
(statearr_42831_42857[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42786);

return cljs.core.constant$keyword$recur;
} else {
throw e42830;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42858 = state_42786;
state_42786 = G__42858;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_42786){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_42786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42832 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42832[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__42865_42871 = io_obj;
var G__42866_42872 = goog.net.EventType.SUCCESS;
var G__42867_42873 = ((function (G__42865_42871,G__42866_42872,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42865_42871,G__42866_42872,io_obj,url))
;
goog.events.listen(G__42865_42871,G__42866_42872,G__42867_42873);

var G__42868_42874 = io_obj;
var G__42869_42875 = goog.net.EventType.ERROR;
var G__42870_42876 = ((function (G__42868_42874,G__42869_42875,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42868_42874,G__42869_42875,io_obj,url))
;
goog.events.listen(G__42868_42874,G__42869_42875,G__42870_42876);

return io_obj.sendFromForm(form,url);
});
