// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_.call(null,class_name,class$,i)){
return i;
} else {
var G__11391 = (i + class$.length);
start_from = G__11391;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index.call(null,class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__11396 = arguments.length;
switch (G__11396) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var classes__$1 = clojure.string.trim.call(null,cljs.core.name.call(null,classes));
if(cljs.core.seq.call(null,classes__$1)){
var temp__4124__auto___11410 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11410)){
var class_list_11411 = temp__4124__auto___11410;
var seq__11397_11412 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11398_11413 = null;
var count__11399_11414 = (0);
var i__11400_11415 = (0);
while(true){
if((i__11400_11415 < count__11399_11414)){
var class_11416 = cljs.core._nth.call(null,chunk__11398_11413,i__11400_11415);
class_list_11411.add(class_11416);

var G__11417 = seq__11397_11412;
var G__11418 = chunk__11398_11413;
var G__11419 = count__11399_11414;
var G__11420 = (i__11400_11415 + (1));
seq__11397_11412 = G__11417;
chunk__11398_11413 = G__11418;
count__11399_11414 = G__11419;
i__11400_11415 = G__11420;
continue;
} else {
var temp__4126__auto___11421 = cljs.core.seq.call(null,seq__11397_11412);
if(temp__4126__auto___11421){
var seq__11397_11422__$1 = temp__4126__auto___11421;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11397_11422__$1)){
var c__5061__auto___11423 = cljs.core.chunk_first.call(null,seq__11397_11422__$1);
var G__11424 = cljs.core.chunk_rest.call(null,seq__11397_11422__$1);
var G__11425 = c__5061__auto___11423;
var G__11426 = cljs.core.count.call(null,c__5061__auto___11423);
var G__11427 = (0);
seq__11397_11412 = G__11424;
chunk__11398_11413 = G__11425;
count__11399_11414 = G__11426;
i__11400_11415 = G__11427;
continue;
} else {
var class_11428 = cljs.core.first.call(null,seq__11397_11422__$1);
class_list_11411.add(class_11428);

var G__11429 = cljs.core.next.call(null,seq__11397_11422__$1);
var G__11430 = null;
var G__11431 = (0);
var G__11432 = (0);
seq__11397_11412 = G__11429;
chunk__11398_11413 = G__11430;
count__11399_11414 = G__11431;
i__11400_11415 = G__11432;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_11433 = elem__$1.className;
var seq__11401_11434 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11402_11435 = null;
var count__11403_11436 = (0);
var i__11404_11437 = (0);
while(true){
if((i__11404_11437 < count__11403_11436)){
var class_11438 = cljs.core._nth.call(null,chunk__11402_11435,i__11404_11437);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11433,class_11438))){
} else {
elem__$1.className = (((class_name_11433 === ""))?class_11438:[cljs.core.str(class_name_11433),cljs.core.str(" "),cljs.core.str(class_11438)].join(''));
}

var G__11439 = seq__11401_11434;
var G__11440 = chunk__11402_11435;
var G__11441 = count__11403_11436;
var G__11442 = (i__11404_11437 + (1));
seq__11401_11434 = G__11439;
chunk__11402_11435 = G__11440;
count__11403_11436 = G__11441;
i__11404_11437 = G__11442;
continue;
} else {
var temp__4126__auto___11443 = cljs.core.seq.call(null,seq__11401_11434);
if(temp__4126__auto___11443){
var seq__11401_11444__$1 = temp__4126__auto___11443;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11401_11444__$1)){
var c__5061__auto___11445 = cljs.core.chunk_first.call(null,seq__11401_11444__$1);
var G__11446 = cljs.core.chunk_rest.call(null,seq__11401_11444__$1);
var G__11447 = c__5061__auto___11445;
var G__11448 = cljs.core.count.call(null,c__5061__auto___11445);
var G__11449 = (0);
seq__11401_11434 = G__11446;
chunk__11402_11435 = G__11447;
count__11403_11436 = G__11448;
i__11404_11437 = G__11449;
continue;
} else {
var class_11450 = cljs.core.first.call(null,seq__11401_11444__$1);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11433,class_11450))){
} else {
elem__$1.className = (((class_name_11433 === ""))?class_11450:[cljs.core.str(class_name_11433),cljs.core.str(" "),cljs.core.str(class_11450)].join(''));
}

var G__11451 = cljs.core.next.call(null,seq__11401_11444__$1);
var G__11452 = null;
var G__11453 = (0);
var G__11454 = (0);
seq__11401_11434 = G__11451;
chunk__11402_11435 = G__11452;
count__11403_11436 = G__11453;
i__11404_11437 = G__11454;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11405_11455 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__11406_11456 = null;
var count__11407_11457 = (0);
var i__11408_11458 = (0);
while(true){
if((i__11408_11458 < count__11407_11457)){
var c_11459 = cljs.core._nth.call(null,chunk__11406_11456,i__11408_11458);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11459);

var G__11460 = seq__11405_11455;
var G__11461 = chunk__11406_11456;
var G__11462 = count__11407_11457;
var G__11463 = (i__11408_11458 + (1));
seq__11405_11455 = G__11460;
chunk__11406_11456 = G__11461;
count__11407_11457 = G__11462;
i__11408_11458 = G__11463;
continue;
} else {
var temp__4126__auto___11464 = cljs.core.seq.call(null,seq__11405_11455);
if(temp__4126__auto___11464){
var seq__11405_11465__$1 = temp__4126__auto___11464;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11405_11465__$1)){
var c__5061__auto___11466 = cljs.core.chunk_first.call(null,seq__11405_11465__$1);
var G__11467 = cljs.core.chunk_rest.call(null,seq__11405_11465__$1);
var G__11468 = c__5061__auto___11466;
var G__11469 = cljs.core.count.call(null,c__5061__auto___11466);
var G__11470 = (0);
seq__11405_11455 = G__11467;
chunk__11406_11456 = G__11468;
count__11407_11457 = G__11469;
i__11408_11458 = G__11470;
continue;
} else {
var c_11471 = cljs.core.first.call(null,seq__11405_11465__$1);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11471);

var G__11472 = cljs.core.next.call(null,seq__11405_11465__$1);
var G__11473 = null;
var G__11474 = (0);
var G__11475 = (0);
seq__11405_11455 = G__11472;
chunk__11406_11456 = G__11473;
count__11407_11457 = G__11474;
i__11408_11458 = G__11475;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq11392){
var G__11393 = cljs.core.first.call(null,seq11392);
var seq11392__$1 = cljs.core.next.call(null,seq11392);
var G__11394 = cljs.core.first.call(null,seq11392__$1);
var seq11392__$2 = cljs.core.next.call(null,seq11392__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11393,G__11394,seq11392__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index.call(null,class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__11476 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__11476;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__11481 = arguments.length;
switch (G__11481) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11487 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11487)){
var class_list_11488 = temp__4124__auto___11487;
class_list_11488.remove(class$__$1);
} else {
var class_name_11489 = elem__$1.className;
var new_class_name_11490 = dommy.attrs.remove_class_str.call(null,class_name_11489,class$__$1);
if((class_name_11489 === new_class_name_11490)){
} else {
elem__$1.className = new_class_name_11490;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11482 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__11483 = null;
var count__11484 = (0);
var i__11485 = (0);
while(true){
if((i__11485 < count__11484)){
var c = cljs.core._nth.call(null,chunk__11483,i__11485);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11491 = seq__11482;
var G__11492 = chunk__11483;
var G__11493 = count__11484;
var G__11494 = (i__11485 + (1));
seq__11482 = G__11491;
chunk__11483 = G__11492;
count__11484 = G__11493;
i__11485 = G__11494;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq.call(null,seq__11482);
if(temp__4126__auto__){
var seq__11482__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11482__$1)){
var c__5061__auto__ = cljs.core.chunk_first.call(null,seq__11482__$1);
var G__11495 = cljs.core.chunk_rest.call(null,seq__11482__$1);
var G__11496 = c__5061__auto__;
var G__11497 = cljs.core.count.call(null,c__5061__auto__);
var G__11498 = (0);
seq__11482 = G__11495;
chunk__11483 = G__11496;
count__11484 = G__11497;
i__11485 = G__11498;
continue;
} else {
var c = cljs.core.first.call(null,seq__11482__$1);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11499 = cljs.core.next.call(null,seq__11482__$1);
var G__11500 = null;
var G__11501 = (0);
var G__11502 = (0);
seq__11482 = G__11499;
chunk__11483 = G__11500;
count__11484 = G__11501;
i__11485 = G__11502;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq11477){
var G__11478 = cljs.core.first.call(null,seq11477);
var seq11477__$1 = cljs.core.next.call(null,seq11477);
var G__11479 = cljs.core.first.call(null,seq11477__$1);
var seq11477__$2 = cljs.core.next.call(null,seq11477__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11478,G__11479,seq11477__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__11504 = arguments.length;
switch (G__11504) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11506 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11506)){
var class_list_11507 = temp__4124__auto___11506;
class_list_11507.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.call(null,elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_.call(null,elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.call(null,elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.call(null,elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p__11510){
var vec__11511 = p__11510;
var k = cljs.core.nth.call(null,vec__11511,(0),null);
var v = cljs.core.nth.call(null,vec__11511,(1),null);
return [cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str(":"),cljs.core.str(cljs.core.name.call(null,v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var style = elem__$1.style;
var seq__11514_11520 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11515_11521 = null;
var count__11516_11522 = (0);
var i__11517_11523 = (0);
while(true){
if((i__11517_11523 < count__11516_11522)){
var vec__11518_11524 = cljs.core._nth.call(null,chunk__11515_11521,i__11517_11523);
var k_11525 = cljs.core.nth.call(null,vec__11518_11524,(0),null);
var v_11526 = cljs.core.nth.call(null,vec__11518_11524,(1),null);
(style[cljs.core.name.call(null,k_11525)] = v_11526);

var G__11527 = seq__11514_11520;
var G__11528 = chunk__11515_11521;
var G__11529 = count__11516_11522;
var G__11530 = (i__11517_11523 + (1));
seq__11514_11520 = G__11527;
chunk__11515_11521 = G__11528;
count__11516_11522 = G__11529;
i__11517_11523 = G__11530;
continue;
} else {
var temp__4126__auto___11531 = cljs.core.seq.call(null,seq__11514_11520);
if(temp__4126__auto___11531){
var seq__11514_11532__$1 = temp__4126__auto___11531;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11514_11532__$1)){
var c__5061__auto___11533 = cljs.core.chunk_first.call(null,seq__11514_11532__$1);
var G__11534 = cljs.core.chunk_rest.call(null,seq__11514_11532__$1);
var G__11535 = c__5061__auto___11533;
var G__11536 = cljs.core.count.call(null,c__5061__auto___11533);
var G__11537 = (0);
seq__11514_11520 = G__11534;
chunk__11515_11521 = G__11535;
count__11516_11522 = G__11536;
i__11517_11523 = G__11537;
continue;
} else {
var vec__11519_11538 = cljs.core.first.call(null,seq__11514_11532__$1);
var k_11539 = cljs.core.nth.call(null,vec__11519_11538,(0),null);
var v_11540 = cljs.core.nth.call(null,vec__11519_11538,(1),null);
(style[cljs.core.name.call(null,k_11539)] = v_11540);

var G__11541 = cljs.core.next.call(null,seq__11514_11532__$1);
var G__11542 = null;
var G__11543 = (0);
var G__11544 = (0);
seq__11514_11520 = G__11541;
chunk__11515_11521 = G__11542;
count__11516_11522 = G__11543;
i__11517_11523 = G__11544;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq11512){
var G__11513 = cljs.core.first.call(null,seq11512);
var seq11512__$1 = cljs.core.next.call(null,seq11512);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11513,seq11512__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"k","k",-505765866,null)))].join('')));
}

return (window.getComputedStyle(dommy.template.__GT_node_like.call(null,elem))[cljs.core.name.call(null,k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11547_11553 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11548_11554 = null;
var count__11549_11555 = (0);
var i__11550_11556 = (0);
while(true){
if((i__11550_11556 < count__11549_11555)){
var vec__11551_11557 = cljs.core._nth.call(null,chunk__11548_11554,i__11550_11556);
var k_11558 = cljs.core.nth.call(null,vec__11551_11557,(0),null);
var v_11559 = cljs.core.nth.call(null,vec__11551_11557,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11558,[cljs.core.str(v_11559),cljs.core.str("px")].join(''));

var G__11560 = seq__11547_11553;
var G__11561 = chunk__11548_11554;
var G__11562 = count__11549_11555;
var G__11563 = (i__11550_11556 + (1));
seq__11547_11553 = G__11560;
chunk__11548_11554 = G__11561;
count__11549_11555 = G__11562;
i__11550_11556 = G__11563;
continue;
} else {
var temp__4126__auto___11564 = cljs.core.seq.call(null,seq__11547_11553);
if(temp__4126__auto___11564){
var seq__11547_11565__$1 = temp__4126__auto___11564;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11547_11565__$1)){
var c__5061__auto___11566 = cljs.core.chunk_first.call(null,seq__11547_11565__$1);
var G__11567 = cljs.core.chunk_rest.call(null,seq__11547_11565__$1);
var G__11568 = c__5061__auto___11566;
var G__11569 = cljs.core.count.call(null,c__5061__auto___11566);
var G__11570 = (0);
seq__11547_11553 = G__11567;
chunk__11548_11554 = G__11568;
count__11549_11555 = G__11569;
i__11550_11556 = G__11570;
continue;
} else {
var vec__11552_11571 = cljs.core.first.call(null,seq__11547_11565__$1);
var k_11572 = cljs.core.nth.call(null,vec__11552_11571,(0),null);
var v_11573 = cljs.core.nth.call(null,vec__11552_11571,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11572,[cljs.core.str(v_11573),cljs.core.str("px")].join(''));

var G__11574 = cljs.core.next.call(null,seq__11547_11565__$1);
var G__11575 = null;
var G__11576 = (0);
var G__11577 = (0);
seq__11547_11553 = G__11574;
chunk__11548_11554 = G__11575;
count__11549_11555 = G__11576;
i__11550_11556 = G__11577;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq11545){
var G__11546 = cljs.core.first.call(null,seq11545);
var seq11545__$1 = cljs.core.next.call(null,seq11545);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11546,seq11545__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style.call(null,dommy.template.__GT_node_like.call(null,elem),k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__11583 = arguments.length;
switch (G__11583) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.call(null,dommy.template.__GT_node_like.call(null,elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__11584 = dommy.template.__GT_node_like.call(null,elem);
(G__11584[cljs.core.name.call(null,k)] = v);

return G__11584;
} else {
var G__11585 = dommy.template.__GT_node_like.call(null,elem);
G__11585.setAttribute(cljs.core.name.call(null,k),(((k === new cljs.core.Keyword(null,"style","style",-496642736)))?dommy.attrs.style_str.call(null,v):v));

return G__11585;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11586_11593 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__11587_11594 = null;
var count__11588_11595 = (0);
var i__11589_11596 = (0);
while(true){
if((i__11589_11596 < count__11588_11595)){
var vec__11590_11597 = cljs.core._nth.call(null,chunk__11587_11594,i__11589_11596);
var k_11598__$1 = cljs.core.nth.call(null,vec__11590_11597,(0),null);
var v_11599__$1 = cljs.core.nth.call(null,vec__11590_11597,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11598__$1,v_11599__$1);

var G__11600 = seq__11586_11593;
var G__11601 = chunk__11587_11594;
var G__11602 = count__11588_11595;
var G__11603 = (i__11589_11596 + (1));
seq__11586_11593 = G__11600;
chunk__11587_11594 = G__11601;
count__11588_11595 = G__11602;
i__11589_11596 = G__11603;
continue;
} else {
var temp__4126__auto___11604 = cljs.core.seq.call(null,seq__11586_11593);
if(temp__4126__auto___11604){
var seq__11586_11605__$1 = temp__4126__auto___11604;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11586_11605__$1)){
var c__5061__auto___11606 = cljs.core.chunk_first.call(null,seq__11586_11605__$1);
var G__11607 = cljs.core.chunk_rest.call(null,seq__11586_11605__$1);
var G__11608 = c__5061__auto___11606;
var G__11609 = cljs.core.count.call(null,c__5061__auto___11606);
var G__11610 = (0);
seq__11586_11593 = G__11607;
chunk__11587_11594 = G__11608;
count__11588_11595 = G__11609;
i__11589_11596 = G__11610;
continue;
} else {
var vec__11591_11611 = cljs.core.first.call(null,seq__11586_11605__$1);
var k_11612__$1 = cljs.core.nth.call(null,vec__11591_11611,(0),null);
var v_11613__$1 = cljs.core.nth.call(null,vec__11591_11611,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11612__$1,v_11613__$1);

var G__11614 = cljs.core.next.call(null,seq__11586_11605__$1);
var G__11615 = null;
var G__11616 = (0);
var G__11617 = (0);
seq__11586_11593 = G__11614;
chunk__11587_11594 = G__11615;
count__11588_11595 = G__11616;
i__11589_11596 = G__11617;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq11578){
var G__11579 = cljs.core.first.call(null,seq11578);
var seq11578__$1 = cljs.core.next.call(null,seq11578);
var G__11580 = cljs.core.first.call(null,seq11578__$1);
var seq11578__$2 = cljs.core.next.call(null,seq11578__$1);
var G__11581 = cljs.core.first.call(null,seq11578__$2);
var seq11578__$3 = cljs.core.next.call(null,seq11578__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11579,G__11580,G__11581,seq11578__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__11622 = arguments.length;
switch (G__11622) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),null,new cljs.core.Keyword(null,"classes","classes",2037804510),null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name.call(null,k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11623_11628 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__11624_11629 = null;
var count__11625_11630 = (0);
var i__11626_11631 = (0);
while(true){
if((i__11626_11631 < count__11625_11630)){
var k_11632__$1 = cljs.core._nth.call(null,chunk__11624_11629,i__11626_11631);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11632__$1);

var G__11633 = seq__11623_11628;
var G__11634 = chunk__11624_11629;
var G__11635 = count__11625_11630;
var G__11636 = (i__11626_11631 + (1));
seq__11623_11628 = G__11633;
chunk__11624_11629 = G__11634;
count__11625_11630 = G__11635;
i__11626_11631 = G__11636;
continue;
} else {
var temp__4126__auto___11637 = cljs.core.seq.call(null,seq__11623_11628);
if(temp__4126__auto___11637){
var seq__11623_11638__$1 = temp__4126__auto___11637;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11623_11638__$1)){
var c__5061__auto___11639 = cljs.core.chunk_first.call(null,seq__11623_11638__$1);
var G__11640 = cljs.core.chunk_rest.call(null,seq__11623_11638__$1);
var G__11641 = c__5061__auto___11639;
var G__11642 = cljs.core.count.call(null,c__5061__auto___11639);
var G__11643 = (0);
seq__11623_11628 = G__11640;
chunk__11624_11629 = G__11641;
count__11625_11630 = G__11642;
i__11626_11631 = G__11643;
continue;
} else {
var k_11644__$1 = cljs.core.first.call(null,seq__11623_11638__$1);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11644__$1);

var G__11645 = cljs.core.next.call(null,seq__11623_11638__$1);
var G__11646 = null;
var G__11647 = (0);
var G__11648 = (0);
seq__11623_11628 = G__11645;
chunk__11624_11629 = G__11646;
count__11625_11630 = G__11647;
i__11626_11631 = G__11648;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq11618){
var G__11619 = cljs.core.first.call(null,seq11618);
var seq11618__$1 = cljs.core.next.call(null,seq11618);
var G__11620 = cljs.core.first.call(null,seq11618__$1);
var seq11618__$2 = cljs.core.next.call(null,seq11618__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11619,G__11620,seq11618__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like.call(null,elem).getAttribute(cljs.core.name.call(null,k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__11650 = arguments.length;
switch (G__11650) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.attrs.attr.call(null,elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.call(null,elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like.call(null,elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__11653 = arguments.length;
switch (G__11653) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__11654 = dommy.template.__GT_node_like.call(null,elem);
G__11654.style.display = ((show_QMARK_)?"":"none");

return G__11654;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,elem__$1,dommy.attrs.hidden_QMARK_.call(null,elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__11657 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11657,false);

return G__11657;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__11659 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11659,true);

return G__11659;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.call(null,(function (){var G__11661 = dommy.template.__GT_node_like.call(null,elem).getBoundingClientRect();
(G__11661["constructor"] = Object);

return G__11661;
})(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect.call(null,elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
