// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t12353 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12353 = (function (f,fn_handler,meta12354){
this.f = f;
this.fn_handler = fn_handler;
this.meta12354 = meta12354;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12353.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12353.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t12353.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t12353.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12355){
var self__ = this;
var _12355__$1 = this;
return self__.meta12354;
});

cljs.core.async.t12353.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12355,meta12354__$1){
var self__ = this;
var _12355__$1 = this;
return (new cljs.core.async.t12353(self__.f,self__.fn_handler,meta12354__$1));
});

cljs.core.async.t12353.cljs$lang$type = true;

cljs.core.async.t12353.cljs$lang$ctorStr = "cljs.core.async/t12353";

cljs.core.async.t12353.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12353");
});

cljs.core.async.__GT_t12353 = (function cljs$core$async$fn_handler_$___GT_t12353(f__$1,fn_handler__$1,meta12354){
return (new cljs.core.async.t12353(f__$1,fn_handler__$1,meta12354));
});

}

return (new cljs.core.async.t12353(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__12357 = buff;
if(G__12357){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__12357.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__12357.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12357);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12357);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__12359 = arguments.length;
switch (G__12359) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__12362 = arguments.length;
switch (G__12362) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12364 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12364);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12364,ret){
return (function (){
return fn1.call(null,val_12364);
});})(val_12364,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__12366 = arguments.length;
switch (G__12366) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___12368 = n;
var x_12369 = (0);
while(true){
if((x_12369 < n__5161__auto___12368)){
(a[x_12369] = (0));

var G__12370 = (x_12369 + (1));
x_12369 = G__12370;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12371 = (i + (1));
i = G__12371;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t12375 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12375 = (function (flag,alt_flag,meta12376){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta12376 = meta12376;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12375.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12375.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t12375.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t12375.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12377){
var self__ = this;
var _12377__$1 = this;
return self__.meta12376;
});})(flag))
;

cljs.core.async.t12375.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12377,meta12376__$1){
var self__ = this;
var _12377__$1 = this;
return (new cljs.core.async.t12375(self__.flag,self__.alt_flag,meta12376__$1));
});})(flag))
;

cljs.core.async.t12375.cljs$lang$type = true;

cljs.core.async.t12375.cljs$lang$ctorStr = "cljs.core.async/t12375";

cljs.core.async.t12375.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12375");
});})(flag))
;

cljs.core.async.__GT_t12375 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t12375(flag__$1,alt_flag__$1,meta12376){
return (new cljs.core.async.t12375(flag__$1,alt_flag__$1,meta12376));
});})(flag))
;

}

return (new cljs.core.async.t12375(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t12381 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12381 = (function (cb,flag,alt_handler,meta12382){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta12382 = meta12382;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12381.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12381.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t12381.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t12381.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12383){
var self__ = this;
var _12383__$1 = this;
return self__.meta12382;
});

cljs.core.async.t12381.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12383,meta12382__$1){
var self__ = this;
var _12383__$1 = this;
return (new cljs.core.async.t12381(self__.cb,self__.flag,self__.alt_handler,meta12382__$1));
});

cljs.core.async.t12381.cljs$lang$type = true;

cljs.core.async.t12381.cljs$lang$ctorStr = "cljs.core.async/t12381";

cljs.core.async.t12381.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12381");
});

cljs.core.async.__GT_t12381 = (function cljs$core$async$alt_handler_$___GT_t12381(cb__$1,flag__$1,alt_handler__$1,meta12382){
return (new cljs.core.async.t12381(cb__$1,flag__$1,alt_handler__$1,meta12382));
});

}

return (new cljs.core.async.t12381(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12384_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12384_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12385_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12385_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12386 = (i + (1));
i = G__12386;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12389){
var map__12390 = p__12389;
var map__12390__$1 = ((cljs.core.seq_QMARK_.call(null,map__12390))?cljs.core.apply.call(null,cljs.core.hash_map,map__12390):map__12390);
var opts = map__12390__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12387){
var G__12388 = cljs.core.first.call(null,seq12387);
var seq12387__$1 = cljs.core.next.call(null,seq12387);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12388,seq12387__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__12392 = arguments.length;
switch (G__12392) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___12441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12441){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12441){
return (function (state_12416){
var state_val_12417 = (state_12416[(1)]);
if((state_val_12417 === (7))){
var inst_12412 = (state_12416[(2)]);
var state_12416__$1 = state_12416;
var statearr_12418_12442 = state_12416__$1;
(statearr_12418_12442[(2)] = inst_12412);

(statearr_12418_12442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (1))){
var state_12416__$1 = state_12416;
var statearr_12419_12443 = state_12416__$1;
(statearr_12419_12443[(2)] = null);

(statearr_12419_12443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (4))){
var inst_12395 = (state_12416[(7)]);
var inst_12395__$1 = (state_12416[(2)]);
var inst_12396 = (inst_12395__$1 == null);
var state_12416__$1 = (function (){var statearr_12420 = state_12416;
(statearr_12420[(7)] = inst_12395__$1);

return statearr_12420;
})();
if(cljs.core.truth_(inst_12396)){
var statearr_12421_12444 = state_12416__$1;
(statearr_12421_12444[(1)] = (5));

} else {
var statearr_12422_12445 = state_12416__$1;
(statearr_12422_12445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (13))){
var state_12416__$1 = state_12416;
var statearr_12423_12446 = state_12416__$1;
(statearr_12423_12446[(2)] = null);

(statearr_12423_12446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (6))){
var inst_12395 = (state_12416[(7)]);
var state_12416__$1 = state_12416;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12416__$1,(11),to,inst_12395);
} else {
if((state_val_12417 === (3))){
var inst_12414 = (state_12416[(2)]);
var state_12416__$1 = state_12416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12416__$1,inst_12414);
} else {
if((state_val_12417 === (12))){
var state_12416__$1 = state_12416;
var statearr_12424_12447 = state_12416__$1;
(statearr_12424_12447[(2)] = null);

(statearr_12424_12447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (2))){
var state_12416__$1 = state_12416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12416__$1,(4),from);
} else {
if((state_val_12417 === (11))){
var inst_12405 = (state_12416[(2)]);
var state_12416__$1 = state_12416;
if(cljs.core.truth_(inst_12405)){
var statearr_12425_12448 = state_12416__$1;
(statearr_12425_12448[(1)] = (12));

} else {
var statearr_12426_12449 = state_12416__$1;
(statearr_12426_12449[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (9))){
var state_12416__$1 = state_12416;
var statearr_12427_12450 = state_12416__$1;
(statearr_12427_12450[(2)] = null);

(statearr_12427_12450[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (5))){
var state_12416__$1 = state_12416;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12428_12451 = state_12416__$1;
(statearr_12428_12451[(1)] = (8));

} else {
var statearr_12429_12452 = state_12416__$1;
(statearr_12429_12452[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (14))){
var inst_12410 = (state_12416[(2)]);
var state_12416__$1 = state_12416;
var statearr_12430_12453 = state_12416__$1;
(statearr_12430_12453[(2)] = inst_12410);

(statearr_12430_12453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (10))){
var inst_12402 = (state_12416[(2)]);
var state_12416__$1 = state_12416;
var statearr_12431_12454 = state_12416__$1;
(statearr_12431_12454[(2)] = inst_12402);

(statearr_12431_12454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12417 === (8))){
var inst_12399 = cljs.core.async.close_BANG_.call(null,to);
var state_12416__$1 = state_12416;
var statearr_12432_12455 = state_12416__$1;
(statearr_12432_12455[(2)] = inst_12399);

(statearr_12432_12455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12441))
;
return ((function (switch__7647__auto__,c__7709__auto___12441){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12436 = [null,null,null,null,null,null,null,null];
(statearr_12436[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12436[(1)] = (1));

return statearr_12436;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12416){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12437){if((e12437 instanceof Object)){
var ex__7651__auto__ = e12437;
var statearr_12438_12456 = state_12416;
(statearr_12438_12456[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12437;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12457 = state_12416;
state_12416 = G__12457;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12416){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12441))
})();
var state__7711__auto__ = (function (){var statearr_12439 = f__7710__auto__.call(null);
(statearr_12439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12441);

return statearr_12439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12441))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12641){
var vec__12642 = p__12641;
var v = cljs.core.nth.call(null,vec__12642,(0),null);
var p = cljs.core.nth.call(null,vec__12642,(1),null);
var job = vec__12642;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7709__auto___12824 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results){
return (function (state_12647){
var state_val_12648 = (state_12647[(1)]);
if((state_val_12648 === (2))){
var inst_12644 = (state_12647[(2)]);
var inst_12645 = cljs.core.async.close_BANG_.call(null,res);
var state_12647__$1 = (function (){var statearr_12649 = state_12647;
(statearr_12649[(7)] = inst_12644);

return statearr_12649;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12647__$1,inst_12645);
} else {
if((state_val_12648 === (1))){
var state_12647__$1 = state_12647;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12647__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12653 = [null,null,null,null,null,null,null,null];
(statearr_12653[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12653[(1)] = (1));

return statearr_12653;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12647){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12654){if((e12654 instanceof Object)){
var ex__7651__auto__ = e12654;
var statearr_12655_12825 = state_12647;
(statearr_12655_12825[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12647);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12654;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12826 = state_12647;
state_12647 = G__12826;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12647){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_12656 = f__7710__auto__.call(null);
(statearr_12656[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12824);

return statearr_12656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12824,res,vec__12642,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12657){
var vec__12658 = p__12657;
var v = cljs.core.nth.call(null,vec__12658,(0),null);
var p = cljs.core.nth.call(null,vec__12658,(1),null);
var job = vec__12658;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___12827 = n;
var __12828 = (0);
while(true){
if((__12828 < n__5161__auto___12827)){
var G__12659_12829 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12659_12829) {
case "async":
var c__7709__auto___12831 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12828,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12828,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function (state_12672){
var state_val_12673 = (state_12672[(1)]);
if((state_val_12673 === (7))){
var inst_12668 = (state_12672[(2)]);
var state_12672__$1 = state_12672;
var statearr_12674_12832 = state_12672__$1;
(statearr_12674_12832[(2)] = inst_12668);

(statearr_12674_12832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12673 === (6))){
var state_12672__$1 = state_12672;
var statearr_12675_12833 = state_12672__$1;
(statearr_12675_12833[(2)] = null);

(statearr_12675_12833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12673 === (5))){
var state_12672__$1 = state_12672;
var statearr_12676_12834 = state_12672__$1;
(statearr_12676_12834[(2)] = null);

(statearr_12676_12834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12673 === (4))){
var inst_12662 = (state_12672[(2)]);
var inst_12663 = async.call(null,inst_12662);
var state_12672__$1 = state_12672;
if(cljs.core.truth_(inst_12663)){
var statearr_12677_12835 = state_12672__$1;
(statearr_12677_12835[(1)] = (5));

} else {
var statearr_12678_12836 = state_12672__$1;
(statearr_12678_12836[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12673 === (3))){
var inst_12670 = (state_12672[(2)]);
var state_12672__$1 = state_12672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12672__$1,inst_12670);
} else {
if((state_val_12673 === (2))){
var state_12672__$1 = state_12672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12672__$1,(4),jobs);
} else {
if((state_val_12673 === (1))){
var state_12672__$1 = state_12672;
var statearr_12679_12837 = state_12672__$1;
(statearr_12679_12837[(2)] = null);

(statearr_12679_12837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12828,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
;
return ((function (__12828,switch__7647__auto__,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12683 = [null,null,null,null,null,null,null];
(statearr_12683[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12683[(1)] = (1));

return statearr_12683;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12672){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12684){if((e12684 instanceof Object)){
var ex__7651__auto__ = e12684;
var statearr_12685_12838 = state_12672;
(statearr_12685_12838[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12672);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12684;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12839 = state_12672;
state_12672 = G__12839;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12672){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12828,switch__7647__auto__,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12686 = f__7710__auto__.call(null);
(statearr_12686[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12831);

return statearr_12686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12828,c__7709__auto___12831,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___12840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12828,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12828,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function (state_12699){
var state_val_12700 = (state_12699[(1)]);
if((state_val_12700 === (7))){
var inst_12695 = (state_12699[(2)]);
var state_12699__$1 = state_12699;
var statearr_12701_12841 = state_12699__$1;
(statearr_12701_12841[(2)] = inst_12695);

(statearr_12701_12841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12700 === (6))){
var state_12699__$1 = state_12699;
var statearr_12702_12842 = state_12699__$1;
(statearr_12702_12842[(2)] = null);

(statearr_12702_12842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12700 === (5))){
var state_12699__$1 = state_12699;
var statearr_12703_12843 = state_12699__$1;
(statearr_12703_12843[(2)] = null);

(statearr_12703_12843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12700 === (4))){
var inst_12689 = (state_12699[(2)]);
var inst_12690 = process.call(null,inst_12689);
var state_12699__$1 = state_12699;
if(cljs.core.truth_(inst_12690)){
var statearr_12704_12844 = state_12699__$1;
(statearr_12704_12844[(1)] = (5));

} else {
var statearr_12705_12845 = state_12699__$1;
(statearr_12705_12845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12700 === (3))){
var inst_12697 = (state_12699[(2)]);
var state_12699__$1 = state_12699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12699__$1,inst_12697);
} else {
if((state_val_12700 === (2))){
var state_12699__$1 = state_12699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12699__$1,(4),jobs);
} else {
if((state_val_12700 === (1))){
var state_12699__$1 = state_12699;
var statearr_12706_12846 = state_12699__$1;
(statearr_12706_12846[(2)] = null);

(statearr_12706_12846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12828,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
;
return ((function (__12828,switch__7647__auto__,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12710 = [null,null,null,null,null,null,null];
(statearr_12710[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12710[(1)] = (1));

return statearr_12710;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12699){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12711){if((e12711 instanceof Object)){
var ex__7651__auto__ = e12711;
var statearr_12712_12847 = state_12699;
(statearr_12712_12847[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12711;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12848 = state_12699;
state_12699 = G__12848;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12699){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12828,switch__7647__auto__,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12713 = f__7710__auto__.call(null);
(statearr_12713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12840);

return statearr_12713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12828,c__7709__auto___12840,G__12659_12829,n__5161__auto___12827,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12849 = (__12828 + (1));
__12828 = G__12849;
continue;
} else {
}
break;
}

var c__7709__auto___12850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12850,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12850,jobs,results,process,async){
return (function (state_12735){
var state_val_12736 = (state_12735[(1)]);
if((state_val_12736 === (9))){
var inst_12728 = (state_12735[(2)]);
var state_12735__$1 = (function (){var statearr_12737 = state_12735;
(statearr_12737[(7)] = inst_12728);

return statearr_12737;
})();
var statearr_12738_12851 = state_12735__$1;
(statearr_12738_12851[(2)] = null);

(statearr_12738_12851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12736 === (8))){
var inst_12721 = (state_12735[(8)]);
var inst_12726 = (state_12735[(2)]);
var state_12735__$1 = (function (){var statearr_12739 = state_12735;
(statearr_12739[(9)] = inst_12726);

return statearr_12739;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12735__$1,(9),results,inst_12721);
} else {
if((state_val_12736 === (7))){
var inst_12731 = (state_12735[(2)]);
var state_12735__$1 = state_12735;
var statearr_12740_12852 = state_12735__$1;
(statearr_12740_12852[(2)] = inst_12731);

(statearr_12740_12852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12736 === (6))){
var inst_12721 = (state_12735[(8)]);
var inst_12716 = (state_12735[(10)]);
var inst_12721__$1 = cljs.core.async.chan.call(null,(1));
var inst_12722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12723 = [inst_12716,inst_12721__$1];
var inst_12724 = (new cljs.core.PersistentVector(null,2,(5),inst_12722,inst_12723,null));
var state_12735__$1 = (function (){var statearr_12741 = state_12735;
(statearr_12741[(8)] = inst_12721__$1);

return statearr_12741;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12735__$1,(8),jobs,inst_12724);
} else {
if((state_val_12736 === (5))){
var inst_12719 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12735__$1 = state_12735;
var statearr_12742_12853 = state_12735__$1;
(statearr_12742_12853[(2)] = inst_12719);

(statearr_12742_12853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12736 === (4))){
var inst_12716 = (state_12735[(10)]);
var inst_12716__$1 = (state_12735[(2)]);
var inst_12717 = (inst_12716__$1 == null);
var state_12735__$1 = (function (){var statearr_12743 = state_12735;
(statearr_12743[(10)] = inst_12716__$1);

return statearr_12743;
})();
if(cljs.core.truth_(inst_12717)){
var statearr_12744_12854 = state_12735__$1;
(statearr_12744_12854[(1)] = (5));

} else {
var statearr_12745_12855 = state_12735__$1;
(statearr_12745_12855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12736 === (3))){
var inst_12733 = (state_12735[(2)]);
var state_12735__$1 = state_12735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12735__$1,inst_12733);
} else {
if((state_val_12736 === (2))){
var state_12735__$1 = state_12735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12735__$1,(4),from);
} else {
if((state_val_12736 === (1))){
var state_12735__$1 = state_12735;
var statearr_12746_12856 = state_12735__$1;
(statearr_12746_12856[(2)] = null);

(statearr_12746_12856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12850,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___12850,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12750 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12750[(1)] = (1));

return statearr_12750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12735){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12751){if((e12751 instanceof Object)){
var ex__7651__auto__ = e12751;
var statearr_12752_12857 = state_12735;
(statearr_12752_12857[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12858 = state_12735;
state_12735 = G__12858;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12735){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12850,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12753 = f__7710__auto__.call(null);
(statearr_12753[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12850);

return statearr_12753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12850,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_12791){
var state_val_12792 = (state_12791[(1)]);
if((state_val_12792 === (7))){
var inst_12787 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
var statearr_12793_12859 = state_12791__$1;
(statearr_12793_12859[(2)] = inst_12787);

(statearr_12793_12859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (20))){
var state_12791__$1 = state_12791;
var statearr_12794_12860 = state_12791__$1;
(statearr_12794_12860[(2)] = null);

(statearr_12794_12860[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (1))){
var state_12791__$1 = state_12791;
var statearr_12795_12861 = state_12791__$1;
(statearr_12795_12861[(2)] = null);

(statearr_12795_12861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (4))){
var inst_12756 = (state_12791[(7)]);
var inst_12756__$1 = (state_12791[(2)]);
var inst_12757 = (inst_12756__$1 == null);
var state_12791__$1 = (function (){var statearr_12796 = state_12791;
(statearr_12796[(7)] = inst_12756__$1);

return statearr_12796;
})();
if(cljs.core.truth_(inst_12757)){
var statearr_12797_12862 = state_12791__$1;
(statearr_12797_12862[(1)] = (5));

} else {
var statearr_12798_12863 = state_12791__$1;
(statearr_12798_12863[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (15))){
var inst_12769 = (state_12791[(8)]);
var state_12791__$1 = state_12791;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12791__$1,(18),to,inst_12769);
} else {
if((state_val_12792 === (21))){
var inst_12782 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
var statearr_12799_12864 = state_12791__$1;
(statearr_12799_12864[(2)] = inst_12782);

(statearr_12799_12864[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (13))){
var inst_12784 = (state_12791[(2)]);
var state_12791__$1 = (function (){var statearr_12800 = state_12791;
(statearr_12800[(9)] = inst_12784);

return statearr_12800;
})();
var statearr_12801_12865 = state_12791__$1;
(statearr_12801_12865[(2)] = null);

(statearr_12801_12865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (6))){
var inst_12756 = (state_12791[(7)]);
var state_12791__$1 = state_12791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12791__$1,(11),inst_12756);
} else {
if((state_val_12792 === (17))){
var inst_12777 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
if(cljs.core.truth_(inst_12777)){
var statearr_12802_12866 = state_12791__$1;
(statearr_12802_12866[(1)] = (19));

} else {
var statearr_12803_12867 = state_12791__$1;
(statearr_12803_12867[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (3))){
var inst_12789 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12791__$1,inst_12789);
} else {
if((state_val_12792 === (12))){
var inst_12766 = (state_12791[(10)]);
var state_12791__$1 = state_12791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12791__$1,(14),inst_12766);
} else {
if((state_val_12792 === (2))){
var state_12791__$1 = state_12791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12791__$1,(4),results);
} else {
if((state_val_12792 === (19))){
var state_12791__$1 = state_12791;
var statearr_12804_12868 = state_12791__$1;
(statearr_12804_12868[(2)] = null);

(statearr_12804_12868[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (11))){
var inst_12766 = (state_12791[(2)]);
var state_12791__$1 = (function (){var statearr_12805 = state_12791;
(statearr_12805[(10)] = inst_12766);

return statearr_12805;
})();
var statearr_12806_12869 = state_12791__$1;
(statearr_12806_12869[(2)] = null);

(statearr_12806_12869[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (9))){
var state_12791__$1 = state_12791;
var statearr_12807_12870 = state_12791__$1;
(statearr_12807_12870[(2)] = null);

(statearr_12807_12870[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (5))){
var state_12791__$1 = state_12791;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12808_12871 = state_12791__$1;
(statearr_12808_12871[(1)] = (8));

} else {
var statearr_12809_12872 = state_12791__$1;
(statearr_12809_12872[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (14))){
var inst_12771 = (state_12791[(11)]);
var inst_12769 = (state_12791[(8)]);
var inst_12769__$1 = (state_12791[(2)]);
var inst_12770 = (inst_12769__$1 == null);
var inst_12771__$1 = cljs.core.not.call(null,inst_12770);
var state_12791__$1 = (function (){var statearr_12810 = state_12791;
(statearr_12810[(11)] = inst_12771__$1);

(statearr_12810[(8)] = inst_12769__$1);

return statearr_12810;
})();
if(inst_12771__$1){
var statearr_12811_12873 = state_12791__$1;
(statearr_12811_12873[(1)] = (15));

} else {
var statearr_12812_12874 = state_12791__$1;
(statearr_12812_12874[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (16))){
var inst_12771 = (state_12791[(11)]);
var state_12791__$1 = state_12791;
var statearr_12813_12875 = state_12791__$1;
(statearr_12813_12875[(2)] = inst_12771);

(statearr_12813_12875[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (10))){
var inst_12763 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
var statearr_12814_12876 = state_12791__$1;
(statearr_12814_12876[(2)] = inst_12763);

(statearr_12814_12876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (18))){
var inst_12774 = (state_12791[(2)]);
var state_12791__$1 = state_12791;
var statearr_12815_12877 = state_12791__$1;
(statearr_12815_12877[(2)] = inst_12774);

(statearr_12815_12877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12792 === (8))){
var inst_12760 = cljs.core.async.close_BANG_.call(null,to);
var state_12791__$1 = state_12791;
var statearr_12816_12878 = state_12791__$1;
(statearr_12816_12878[(2)] = inst_12760);

(statearr_12816_12878[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12820 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12820[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12820[(1)] = (1));

return statearr_12820;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12791){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12821){if((e12821 instanceof Object)){
var ex__7651__auto__ = e12821;
var statearr_12822_12879 = state_12791;
(statearr_12822_12879[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12880 = state_12791;
state_12791 = G__12880;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12791){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12823 = f__7710__auto__.call(null);
(statearr_12823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_12823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__12882 = arguments.length;
switch (G__12882) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__12885 = arguments.length;
switch (G__12885) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__12888 = arguments.length;
switch (G__12888) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7709__auto___12940 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12940,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12940,tc,fc){
return (function (state_12914){
var state_val_12915 = (state_12914[(1)]);
if((state_val_12915 === (7))){
var inst_12910 = (state_12914[(2)]);
var state_12914__$1 = state_12914;
var statearr_12916_12941 = state_12914__$1;
(statearr_12916_12941[(2)] = inst_12910);

(statearr_12916_12941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (1))){
var state_12914__$1 = state_12914;
var statearr_12917_12942 = state_12914__$1;
(statearr_12917_12942[(2)] = null);

(statearr_12917_12942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (4))){
var inst_12891 = (state_12914[(7)]);
var inst_12891__$1 = (state_12914[(2)]);
var inst_12892 = (inst_12891__$1 == null);
var state_12914__$1 = (function (){var statearr_12918 = state_12914;
(statearr_12918[(7)] = inst_12891__$1);

return statearr_12918;
})();
if(cljs.core.truth_(inst_12892)){
var statearr_12919_12943 = state_12914__$1;
(statearr_12919_12943[(1)] = (5));

} else {
var statearr_12920_12944 = state_12914__$1;
(statearr_12920_12944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (13))){
var state_12914__$1 = state_12914;
var statearr_12921_12945 = state_12914__$1;
(statearr_12921_12945[(2)] = null);

(statearr_12921_12945[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (6))){
var inst_12891 = (state_12914[(7)]);
var inst_12897 = p.call(null,inst_12891);
var state_12914__$1 = state_12914;
if(cljs.core.truth_(inst_12897)){
var statearr_12922_12946 = state_12914__$1;
(statearr_12922_12946[(1)] = (9));

} else {
var statearr_12923_12947 = state_12914__$1;
(statearr_12923_12947[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (3))){
var inst_12912 = (state_12914[(2)]);
var state_12914__$1 = state_12914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12914__$1,inst_12912);
} else {
if((state_val_12915 === (12))){
var state_12914__$1 = state_12914;
var statearr_12924_12948 = state_12914__$1;
(statearr_12924_12948[(2)] = null);

(statearr_12924_12948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (2))){
var state_12914__$1 = state_12914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12914__$1,(4),ch);
} else {
if((state_val_12915 === (11))){
var inst_12891 = (state_12914[(7)]);
var inst_12901 = (state_12914[(2)]);
var state_12914__$1 = state_12914;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12914__$1,(8),inst_12901,inst_12891);
} else {
if((state_val_12915 === (9))){
var state_12914__$1 = state_12914;
var statearr_12925_12949 = state_12914__$1;
(statearr_12925_12949[(2)] = tc);

(statearr_12925_12949[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (5))){
var inst_12894 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12895 = cljs.core.async.close_BANG_.call(null,fc);
var state_12914__$1 = (function (){var statearr_12926 = state_12914;
(statearr_12926[(8)] = inst_12894);

return statearr_12926;
})();
var statearr_12927_12950 = state_12914__$1;
(statearr_12927_12950[(2)] = inst_12895);

(statearr_12927_12950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (14))){
var inst_12908 = (state_12914[(2)]);
var state_12914__$1 = state_12914;
var statearr_12928_12951 = state_12914__$1;
(statearr_12928_12951[(2)] = inst_12908);

(statearr_12928_12951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (10))){
var state_12914__$1 = state_12914;
var statearr_12929_12952 = state_12914__$1;
(statearr_12929_12952[(2)] = fc);

(statearr_12929_12952[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12915 === (8))){
var inst_12903 = (state_12914[(2)]);
var state_12914__$1 = state_12914;
if(cljs.core.truth_(inst_12903)){
var statearr_12930_12953 = state_12914__$1;
(statearr_12930_12953[(1)] = (12));

} else {
var statearr_12931_12954 = state_12914__$1;
(statearr_12931_12954[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12940,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___12940,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12935 = [null,null,null,null,null,null,null,null,null];
(statearr_12935[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12935[(1)] = (1));

return statearr_12935;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12914){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12936){if((e12936 instanceof Object)){
var ex__7651__auto__ = e12936;
var statearr_12937_12955 = state_12914;
(statearr_12937_12955[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12914);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12956 = state_12914;
state_12914 = G__12956;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12914){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12940,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_12938 = f__7710__auto__.call(null);
(statearr_12938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12940);

return statearr_12938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12940,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13003){
var state_val_13004 = (state_13003[(1)]);
if((state_val_13004 === (7))){
var inst_12999 = (state_13003[(2)]);
var state_13003__$1 = state_13003;
var statearr_13005_13021 = state_13003__$1;
(statearr_13005_13021[(2)] = inst_12999);

(statearr_13005_13021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13004 === (6))){
var inst_12989 = (state_13003[(7)]);
var inst_12992 = (state_13003[(8)]);
var inst_12996 = f.call(null,inst_12989,inst_12992);
var inst_12989__$1 = inst_12996;
var state_13003__$1 = (function (){var statearr_13006 = state_13003;
(statearr_13006[(7)] = inst_12989__$1);

return statearr_13006;
})();
var statearr_13007_13022 = state_13003__$1;
(statearr_13007_13022[(2)] = null);

(statearr_13007_13022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13004 === (5))){
var inst_12989 = (state_13003[(7)]);
var state_13003__$1 = state_13003;
var statearr_13008_13023 = state_13003__$1;
(statearr_13008_13023[(2)] = inst_12989);

(statearr_13008_13023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13004 === (4))){
var inst_12992 = (state_13003[(8)]);
var inst_12992__$1 = (state_13003[(2)]);
var inst_12993 = (inst_12992__$1 == null);
var state_13003__$1 = (function (){var statearr_13009 = state_13003;
(statearr_13009[(8)] = inst_12992__$1);

return statearr_13009;
})();
if(cljs.core.truth_(inst_12993)){
var statearr_13010_13024 = state_13003__$1;
(statearr_13010_13024[(1)] = (5));

} else {
var statearr_13011_13025 = state_13003__$1;
(statearr_13011_13025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13004 === (3))){
var inst_13001 = (state_13003[(2)]);
var state_13003__$1 = state_13003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13003__$1,inst_13001);
} else {
if((state_val_13004 === (2))){
var state_13003__$1 = state_13003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13003__$1,(4),ch);
} else {
if((state_val_13004 === (1))){
var inst_12989 = init;
var state_13003__$1 = (function (){var statearr_13012 = state_13003;
(statearr_13012[(7)] = inst_12989);

return statearr_13012;
})();
var statearr_13013_13026 = state_13003__$1;
(statearr_13013_13026[(2)] = null);

(statearr_13013_13026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_13017 = [null,null,null,null,null,null,null,null,null];
(statearr_13017[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_13017[(1)] = (1));

return statearr_13017;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_13003){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13018){if((e13018 instanceof Object)){
var ex__7651__auto__ = e13018;
var statearr_13019_13027 = state_13003;
(statearr_13019_13027[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13003);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13018;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13028 = state_13003;
state_13003 = G__13028;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_13003){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_13003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13020 = f__7710__auto__.call(null);
(statearr_13020[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__13030 = arguments.length;
switch (G__13030) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13055){
var state_val_13056 = (state_13055[(1)]);
if((state_val_13056 === (7))){
var inst_13037 = (state_13055[(2)]);
var state_13055__$1 = state_13055;
var statearr_13057_13081 = state_13055__$1;
(statearr_13057_13081[(2)] = inst_13037);

(statearr_13057_13081[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (1))){
var inst_13031 = cljs.core.seq.call(null,coll);
var inst_13032 = inst_13031;
var state_13055__$1 = (function (){var statearr_13058 = state_13055;
(statearr_13058[(7)] = inst_13032);

return statearr_13058;
})();
var statearr_13059_13082 = state_13055__$1;
(statearr_13059_13082[(2)] = null);

(statearr_13059_13082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (4))){
var inst_13032 = (state_13055[(7)]);
var inst_13035 = cljs.core.first.call(null,inst_13032);
var state_13055__$1 = state_13055;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13055__$1,(7),ch,inst_13035);
} else {
if((state_val_13056 === (13))){
var inst_13049 = (state_13055[(2)]);
var state_13055__$1 = state_13055;
var statearr_13060_13083 = state_13055__$1;
(statearr_13060_13083[(2)] = inst_13049);

(statearr_13060_13083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (6))){
var inst_13040 = (state_13055[(2)]);
var state_13055__$1 = state_13055;
if(cljs.core.truth_(inst_13040)){
var statearr_13061_13084 = state_13055__$1;
(statearr_13061_13084[(1)] = (8));

} else {
var statearr_13062_13085 = state_13055__$1;
(statearr_13062_13085[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (3))){
var inst_13053 = (state_13055[(2)]);
var state_13055__$1 = state_13055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13055__$1,inst_13053);
} else {
if((state_val_13056 === (12))){
var state_13055__$1 = state_13055;
var statearr_13063_13086 = state_13055__$1;
(statearr_13063_13086[(2)] = null);

(statearr_13063_13086[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (2))){
var inst_13032 = (state_13055[(7)]);
var state_13055__$1 = state_13055;
if(cljs.core.truth_(inst_13032)){
var statearr_13064_13087 = state_13055__$1;
(statearr_13064_13087[(1)] = (4));

} else {
var statearr_13065_13088 = state_13055__$1;
(statearr_13065_13088[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (11))){
var inst_13046 = cljs.core.async.close_BANG_.call(null,ch);
var state_13055__$1 = state_13055;
var statearr_13066_13089 = state_13055__$1;
(statearr_13066_13089[(2)] = inst_13046);

(statearr_13066_13089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (9))){
var state_13055__$1 = state_13055;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13067_13090 = state_13055__$1;
(statearr_13067_13090[(1)] = (11));

} else {
var statearr_13068_13091 = state_13055__$1;
(statearr_13068_13091[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (5))){
var inst_13032 = (state_13055[(7)]);
var state_13055__$1 = state_13055;
var statearr_13069_13092 = state_13055__$1;
(statearr_13069_13092[(2)] = inst_13032);

(statearr_13069_13092[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (10))){
var inst_13051 = (state_13055[(2)]);
var state_13055__$1 = state_13055;
var statearr_13070_13093 = state_13055__$1;
(statearr_13070_13093[(2)] = inst_13051);

(statearr_13070_13093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13056 === (8))){
var inst_13032 = (state_13055[(7)]);
var inst_13042 = cljs.core.next.call(null,inst_13032);
var inst_13032__$1 = inst_13042;
var state_13055__$1 = (function (){var statearr_13071 = state_13055;
(statearr_13071[(7)] = inst_13032__$1);

return statearr_13071;
})();
var statearr_13072_13094 = state_13055__$1;
(statearr_13072_13094[(2)] = null);

(statearr_13072_13094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_13076 = [null,null,null,null,null,null,null,null];
(statearr_13076[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_13076[(1)] = (1));

return statearr_13076;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13055){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13077){if((e13077 instanceof Object)){
var ex__7651__auto__ = e13077;
var statearr_13078_13095 = state_13055;
(statearr_13078_13095[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13096 = state_13055;
state_13055 = G__13096;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13079 = f__7710__auto__.call(null);
(statearr_13079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj13098 = {};
return obj13098;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj13100 = {};
return obj13100;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t13322 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13322 = (function (cs,ch,mult,meta13323){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta13323 = meta13323;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13322.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t13322.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t13322.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t13322.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t13322.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13322.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t13322.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13324){
var self__ = this;
var _13324__$1 = this;
return self__.meta13323;
});})(cs))
;

cljs.core.async.t13322.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13324,meta13323__$1){
var self__ = this;
var _13324__$1 = this;
return (new cljs.core.async.t13322(self__.cs,self__.ch,self__.mult,meta13323__$1));
});})(cs))
;

cljs.core.async.t13322.cljs$lang$type = true;

cljs.core.async.t13322.cljs$lang$ctorStr = "cljs.core.async/t13322";

cljs.core.async.t13322.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13322");
});})(cs))
;

cljs.core.async.__GT_t13322 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t13322(cs__$1,ch__$1,mult__$1,meta13323){
return (new cljs.core.async.t13322(cs__$1,ch__$1,mult__$1,meta13323));
});})(cs))
;

}

return (new cljs.core.async.t13322(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___13543 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13543,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13543,cs,m,dchan,dctr,done){
return (function (state_13455){
var state_val_13456 = (state_13455[(1)]);
if((state_val_13456 === (7))){
var inst_13451 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13457_13544 = state_13455__$1;
(statearr_13457_13544[(2)] = inst_13451);

(statearr_13457_13544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (20))){
var inst_13356 = (state_13455[(7)]);
var inst_13366 = cljs.core.first.call(null,inst_13356);
var inst_13367 = cljs.core.nth.call(null,inst_13366,(0),null);
var inst_13368 = cljs.core.nth.call(null,inst_13366,(1),null);
var state_13455__$1 = (function (){var statearr_13458 = state_13455;
(statearr_13458[(8)] = inst_13367);

return statearr_13458;
})();
if(cljs.core.truth_(inst_13368)){
var statearr_13459_13545 = state_13455__$1;
(statearr_13459_13545[(1)] = (22));

} else {
var statearr_13460_13546 = state_13455__$1;
(statearr_13460_13546[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (27))){
var inst_13398 = (state_13455[(9)]);
var inst_13396 = (state_13455[(10)]);
var inst_13403 = (state_13455[(11)]);
var inst_13327 = (state_13455[(12)]);
var inst_13403__$1 = cljs.core._nth.call(null,inst_13396,inst_13398);
var inst_13404 = cljs.core.async.put_BANG_.call(null,inst_13403__$1,inst_13327,done);
var state_13455__$1 = (function (){var statearr_13461 = state_13455;
(statearr_13461[(11)] = inst_13403__$1);

return statearr_13461;
})();
if(cljs.core.truth_(inst_13404)){
var statearr_13462_13547 = state_13455__$1;
(statearr_13462_13547[(1)] = (30));

} else {
var statearr_13463_13548 = state_13455__$1;
(statearr_13463_13548[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (1))){
var state_13455__$1 = state_13455;
var statearr_13464_13549 = state_13455__$1;
(statearr_13464_13549[(2)] = null);

(statearr_13464_13549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (24))){
var inst_13356 = (state_13455[(7)]);
var inst_13373 = (state_13455[(2)]);
var inst_13374 = cljs.core.next.call(null,inst_13356);
var inst_13336 = inst_13374;
var inst_13337 = null;
var inst_13338 = (0);
var inst_13339 = (0);
var state_13455__$1 = (function (){var statearr_13465 = state_13455;
(statearr_13465[(13)] = inst_13337);

(statearr_13465[(14)] = inst_13338);

(statearr_13465[(15)] = inst_13336);

(statearr_13465[(16)] = inst_13339);

(statearr_13465[(17)] = inst_13373);

return statearr_13465;
})();
var statearr_13466_13550 = state_13455__$1;
(statearr_13466_13550[(2)] = null);

(statearr_13466_13550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (39))){
var state_13455__$1 = state_13455;
var statearr_13470_13551 = state_13455__$1;
(statearr_13470_13551[(2)] = null);

(statearr_13470_13551[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (4))){
var inst_13327 = (state_13455[(12)]);
var inst_13327__$1 = (state_13455[(2)]);
var inst_13328 = (inst_13327__$1 == null);
var state_13455__$1 = (function (){var statearr_13471 = state_13455;
(statearr_13471[(12)] = inst_13327__$1);

return statearr_13471;
})();
if(cljs.core.truth_(inst_13328)){
var statearr_13472_13552 = state_13455__$1;
(statearr_13472_13552[(1)] = (5));

} else {
var statearr_13473_13553 = state_13455__$1;
(statearr_13473_13553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (15))){
var inst_13337 = (state_13455[(13)]);
var inst_13338 = (state_13455[(14)]);
var inst_13336 = (state_13455[(15)]);
var inst_13339 = (state_13455[(16)]);
var inst_13352 = (state_13455[(2)]);
var inst_13353 = (inst_13339 + (1));
var tmp13467 = inst_13337;
var tmp13468 = inst_13338;
var tmp13469 = inst_13336;
var inst_13336__$1 = tmp13469;
var inst_13337__$1 = tmp13467;
var inst_13338__$1 = tmp13468;
var inst_13339__$1 = inst_13353;
var state_13455__$1 = (function (){var statearr_13474 = state_13455;
(statearr_13474[(13)] = inst_13337__$1);

(statearr_13474[(14)] = inst_13338__$1);

(statearr_13474[(15)] = inst_13336__$1);

(statearr_13474[(18)] = inst_13352);

(statearr_13474[(16)] = inst_13339__$1);

return statearr_13474;
})();
var statearr_13475_13554 = state_13455__$1;
(statearr_13475_13554[(2)] = null);

(statearr_13475_13554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (21))){
var inst_13377 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13479_13555 = state_13455__$1;
(statearr_13479_13555[(2)] = inst_13377);

(statearr_13479_13555[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (31))){
var inst_13403 = (state_13455[(11)]);
var inst_13407 = done.call(null,null);
var inst_13408 = cljs.core.async.untap_STAR_.call(null,m,inst_13403);
var state_13455__$1 = (function (){var statearr_13480 = state_13455;
(statearr_13480[(19)] = inst_13407);

return statearr_13480;
})();
var statearr_13481_13556 = state_13455__$1;
(statearr_13481_13556[(2)] = inst_13408);

(statearr_13481_13556[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (32))){
var inst_13398 = (state_13455[(9)]);
var inst_13395 = (state_13455[(20)]);
var inst_13397 = (state_13455[(21)]);
var inst_13396 = (state_13455[(10)]);
var inst_13410 = (state_13455[(2)]);
var inst_13411 = (inst_13398 + (1));
var tmp13476 = inst_13395;
var tmp13477 = inst_13397;
var tmp13478 = inst_13396;
var inst_13395__$1 = tmp13476;
var inst_13396__$1 = tmp13478;
var inst_13397__$1 = tmp13477;
var inst_13398__$1 = inst_13411;
var state_13455__$1 = (function (){var statearr_13482 = state_13455;
(statearr_13482[(9)] = inst_13398__$1);

(statearr_13482[(20)] = inst_13395__$1);

(statearr_13482[(21)] = inst_13397__$1);

(statearr_13482[(10)] = inst_13396__$1);

(statearr_13482[(22)] = inst_13410);

return statearr_13482;
})();
var statearr_13483_13557 = state_13455__$1;
(statearr_13483_13557[(2)] = null);

(statearr_13483_13557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (40))){
var inst_13423 = (state_13455[(23)]);
var inst_13427 = done.call(null,null);
var inst_13428 = cljs.core.async.untap_STAR_.call(null,m,inst_13423);
var state_13455__$1 = (function (){var statearr_13484 = state_13455;
(statearr_13484[(24)] = inst_13427);

return statearr_13484;
})();
var statearr_13485_13558 = state_13455__$1;
(statearr_13485_13558[(2)] = inst_13428);

(statearr_13485_13558[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (33))){
var inst_13414 = (state_13455[(25)]);
var inst_13416 = cljs.core.chunked_seq_QMARK_.call(null,inst_13414);
var state_13455__$1 = state_13455;
if(inst_13416){
var statearr_13486_13559 = state_13455__$1;
(statearr_13486_13559[(1)] = (36));

} else {
var statearr_13487_13560 = state_13455__$1;
(statearr_13487_13560[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (13))){
var inst_13346 = (state_13455[(26)]);
var inst_13349 = cljs.core.async.close_BANG_.call(null,inst_13346);
var state_13455__$1 = state_13455;
var statearr_13488_13561 = state_13455__$1;
(statearr_13488_13561[(2)] = inst_13349);

(statearr_13488_13561[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (22))){
var inst_13367 = (state_13455[(8)]);
var inst_13370 = cljs.core.async.close_BANG_.call(null,inst_13367);
var state_13455__$1 = state_13455;
var statearr_13489_13562 = state_13455__$1;
(statearr_13489_13562[(2)] = inst_13370);

(statearr_13489_13562[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (36))){
var inst_13414 = (state_13455[(25)]);
var inst_13418 = cljs.core.chunk_first.call(null,inst_13414);
var inst_13419 = cljs.core.chunk_rest.call(null,inst_13414);
var inst_13420 = cljs.core.count.call(null,inst_13418);
var inst_13395 = inst_13419;
var inst_13396 = inst_13418;
var inst_13397 = inst_13420;
var inst_13398 = (0);
var state_13455__$1 = (function (){var statearr_13490 = state_13455;
(statearr_13490[(9)] = inst_13398);

(statearr_13490[(20)] = inst_13395);

(statearr_13490[(21)] = inst_13397);

(statearr_13490[(10)] = inst_13396);

return statearr_13490;
})();
var statearr_13491_13563 = state_13455__$1;
(statearr_13491_13563[(2)] = null);

(statearr_13491_13563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (41))){
var inst_13414 = (state_13455[(25)]);
var inst_13430 = (state_13455[(2)]);
var inst_13431 = cljs.core.next.call(null,inst_13414);
var inst_13395 = inst_13431;
var inst_13396 = null;
var inst_13397 = (0);
var inst_13398 = (0);
var state_13455__$1 = (function (){var statearr_13492 = state_13455;
(statearr_13492[(9)] = inst_13398);

(statearr_13492[(20)] = inst_13395);

(statearr_13492[(21)] = inst_13397);

(statearr_13492[(10)] = inst_13396);

(statearr_13492[(27)] = inst_13430);

return statearr_13492;
})();
var statearr_13493_13564 = state_13455__$1;
(statearr_13493_13564[(2)] = null);

(statearr_13493_13564[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (43))){
var state_13455__$1 = state_13455;
var statearr_13494_13565 = state_13455__$1;
(statearr_13494_13565[(2)] = null);

(statearr_13494_13565[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (29))){
var inst_13439 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13495_13566 = state_13455__$1;
(statearr_13495_13566[(2)] = inst_13439);

(statearr_13495_13566[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (44))){
var inst_13448 = (state_13455[(2)]);
var state_13455__$1 = (function (){var statearr_13496 = state_13455;
(statearr_13496[(28)] = inst_13448);

return statearr_13496;
})();
var statearr_13497_13567 = state_13455__$1;
(statearr_13497_13567[(2)] = null);

(statearr_13497_13567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (6))){
var inst_13387 = (state_13455[(29)]);
var inst_13386 = cljs.core.deref.call(null,cs);
var inst_13387__$1 = cljs.core.keys.call(null,inst_13386);
var inst_13388 = cljs.core.count.call(null,inst_13387__$1);
var inst_13389 = cljs.core.reset_BANG_.call(null,dctr,inst_13388);
var inst_13394 = cljs.core.seq.call(null,inst_13387__$1);
var inst_13395 = inst_13394;
var inst_13396 = null;
var inst_13397 = (0);
var inst_13398 = (0);
var state_13455__$1 = (function (){var statearr_13498 = state_13455;
(statearr_13498[(9)] = inst_13398);

(statearr_13498[(29)] = inst_13387__$1);

(statearr_13498[(20)] = inst_13395);

(statearr_13498[(21)] = inst_13397);

(statearr_13498[(10)] = inst_13396);

(statearr_13498[(30)] = inst_13389);

return statearr_13498;
})();
var statearr_13499_13568 = state_13455__$1;
(statearr_13499_13568[(2)] = null);

(statearr_13499_13568[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (28))){
var inst_13395 = (state_13455[(20)]);
var inst_13414 = (state_13455[(25)]);
var inst_13414__$1 = cljs.core.seq.call(null,inst_13395);
var state_13455__$1 = (function (){var statearr_13500 = state_13455;
(statearr_13500[(25)] = inst_13414__$1);

return statearr_13500;
})();
if(inst_13414__$1){
var statearr_13501_13569 = state_13455__$1;
(statearr_13501_13569[(1)] = (33));

} else {
var statearr_13502_13570 = state_13455__$1;
(statearr_13502_13570[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (25))){
var inst_13398 = (state_13455[(9)]);
var inst_13397 = (state_13455[(21)]);
var inst_13400 = (inst_13398 < inst_13397);
var inst_13401 = inst_13400;
var state_13455__$1 = state_13455;
if(cljs.core.truth_(inst_13401)){
var statearr_13503_13571 = state_13455__$1;
(statearr_13503_13571[(1)] = (27));

} else {
var statearr_13504_13572 = state_13455__$1;
(statearr_13504_13572[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (34))){
var state_13455__$1 = state_13455;
var statearr_13505_13573 = state_13455__$1;
(statearr_13505_13573[(2)] = null);

(statearr_13505_13573[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (17))){
var state_13455__$1 = state_13455;
var statearr_13506_13574 = state_13455__$1;
(statearr_13506_13574[(2)] = null);

(statearr_13506_13574[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (3))){
var inst_13453 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13455__$1,inst_13453);
} else {
if((state_val_13456 === (12))){
var inst_13382 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13507_13575 = state_13455__$1;
(statearr_13507_13575[(2)] = inst_13382);

(statearr_13507_13575[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (2))){
var state_13455__$1 = state_13455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13455__$1,(4),ch);
} else {
if((state_val_13456 === (23))){
var state_13455__$1 = state_13455;
var statearr_13508_13576 = state_13455__$1;
(statearr_13508_13576[(2)] = null);

(statearr_13508_13576[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (35))){
var inst_13437 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13509_13577 = state_13455__$1;
(statearr_13509_13577[(2)] = inst_13437);

(statearr_13509_13577[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (19))){
var inst_13356 = (state_13455[(7)]);
var inst_13360 = cljs.core.chunk_first.call(null,inst_13356);
var inst_13361 = cljs.core.chunk_rest.call(null,inst_13356);
var inst_13362 = cljs.core.count.call(null,inst_13360);
var inst_13336 = inst_13361;
var inst_13337 = inst_13360;
var inst_13338 = inst_13362;
var inst_13339 = (0);
var state_13455__$1 = (function (){var statearr_13510 = state_13455;
(statearr_13510[(13)] = inst_13337);

(statearr_13510[(14)] = inst_13338);

(statearr_13510[(15)] = inst_13336);

(statearr_13510[(16)] = inst_13339);

return statearr_13510;
})();
var statearr_13511_13578 = state_13455__$1;
(statearr_13511_13578[(2)] = null);

(statearr_13511_13578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (11))){
var inst_13356 = (state_13455[(7)]);
var inst_13336 = (state_13455[(15)]);
var inst_13356__$1 = cljs.core.seq.call(null,inst_13336);
var state_13455__$1 = (function (){var statearr_13512 = state_13455;
(statearr_13512[(7)] = inst_13356__$1);

return statearr_13512;
})();
if(inst_13356__$1){
var statearr_13513_13579 = state_13455__$1;
(statearr_13513_13579[(1)] = (16));

} else {
var statearr_13514_13580 = state_13455__$1;
(statearr_13514_13580[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (9))){
var inst_13384 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13515_13581 = state_13455__$1;
(statearr_13515_13581[(2)] = inst_13384);

(statearr_13515_13581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (5))){
var inst_13334 = cljs.core.deref.call(null,cs);
var inst_13335 = cljs.core.seq.call(null,inst_13334);
var inst_13336 = inst_13335;
var inst_13337 = null;
var inst_13338 = (0);
var inst_13339 = (0);
var state_13455__$1 = (function (){var statearr_13516 = state_13455;
(statearr_13516[(13)] = inst_13337);

(statearr_13516[(14)] = inst_13338);

(statearr_13516[(15)] = inst_13336);

(statearr_13516[(16)] = inst_13339);

return statearr_13516;
})();
var statearr_13517_13582 = state_13455__$1;
(statearr_13517_13582[(2)] = null);

(statearr_13517_13582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (14))){
var state_13455__$1 = state_13455;
var statearr_13518_13583 = state_13455__$1;
(statearr_13518_13583[(2)] = null);

(statearr_13518_13583[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (45))){
var inst_13445 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13519_13584 = state_13455__$1;
(statearr_13519_13584[(2)] = inst_13445);

(statearr_13519_13584[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (26))){
var inst_13387 = (state_13455[(29)]);
var inst_13441 = (state_13455[(2)]);
var inst_13442 = cljs.core.seq.call(null,inst_13387);
var state_13455__$1 = (function (){var statearr_13520 = state_13455;
(statearr_13520[(31)] = inst_13441);

return statearr_13520;
})();
if(inst_13442){
var statearr_13521_13585 = state_13455__$1;
(statearr_13521_13585[(1)] = (42));

} else {
var statearr_13522_13586 = state_13455__$1;
(statearr_13522_13586[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (16))){
var inst_13356 = (state_13455[(7)]);
var inst_13358 = cljs.core.chunked_seq_QMARK_.call(null,inst_13356);
var state_13455__$1 = state_13455;
if(inst_13358){
var statearr_13523_13587 = state_13455__$1;
(statearr_13523_13587[(1)] = (19));

} else {
var statearr_13524_13588 = state_13455__$1;
(statearr_13524_13588[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (38))){
var inst_13434 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13525_13589 = state_13455__$1;
(statearr_13525_13589[(2)] = inst_13434);

(statearr_13525_13589[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (30))){
var state_13455__$1 = state_13455;
var statearr_13526_13590 = state_13455__$1;
(statearr_13526_13590[(2)] = null);

(statearr_13526_13590[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (10))){
var inst_13337 = (state_13455[(13)]);
var inst_13339 = (state_13455[(16)]);
var inst_13345 = cljs.core._nth.call(null,inst_13337,inst_13339);
var inst_13346 = cljs.core.nth.call(null,inst_13345,(0),null);
var inst_13347 = cljs.core.nth.call(null,inst_13345,(1),null);
var state_13455__$1 = (function (){var statearr_13527 = state_13455;
(statearr_13527[(26)] = inst_13346);

return statearr_13527;
})();
if(cljs.core.truth_(inst_13347)){
var statearr_13528_13591 = state_13455__$1;
(statearr_13528_13591[(1)] = (13));

} else {
var statearr_13529_13592 = state_13455__$1;
(statearr_13529_13592[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (18))){
var inst_13380 = (state_13455[(2)]);
var state_13455__$1 = state_13455;
var statearr_13530_13593 = state_13455__$1;
(statearr_13530_13593[(2)] = inst_13380);

(statearr_13530_13593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (42))){
var state_13455__$1 = state_13455;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13455__$1,(45),dchan);
} else {
if((state_val_13456 === (37))){
var inst_13423 = (state_13455[(23)]);
var inst_13414 = (state_13455[(25)]);
var inst_13327 = (state_13455[(12)]);
var inst_13423__$1 = cljs.core.first.call(null,inst_13414);
var inst_13424 = cljs.core.async.put_BANG_.call(null,inst_13423__$1,inst_13327,done);
var state_13455__$1 = (function (){var statearr_13531 = state_13455;
(statearr_13531[(23)] = inst_13423__$1);

return statearr_13531;
})();
if(cljs.core.truth_(inst_13424)){
var statearr_13532_13594 = state_13455__$1;
(statearr_13532_13594[(1)] = (39));

} else {
var statearr_13533_13595 = state_13455__$1;
(statearr_13533_13595[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13456 === (8))){
var inst_13338 = (state_13455[(14)]);
var inst_13339 = (state_13455[(16)]);
var inst_13341 = (inst_13339 < inst_13338);
var inst_13342 = inst_13341;
var state_13455__$1 = state_13455;
if(cljs.core.truth_(inst_13342)){
var statearr_13534_13596 = state_13455__$1;
(statearr_13534_13596[(1)] = (10));

} else {
var statearr_13535_13597 = state_13455__$1;
(statearr_13535_13597[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13543,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___13543,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_13539 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13539[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_13539[(1)] = (1));

return statearr_13539;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_13455){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13455);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13540){if((e13540 instanceof Object)){
var ex__7651__auto__ = e13540;
var statearr_13541_13598 = state_13455;
(statearr_13541_13598[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13455);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13540;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13599 = state_13455;
state_13455 = G__13599;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_13455){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_13455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13543,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_13542 = f__7710__auto__.call(null);
(statearr_13542[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13543);

return statearr_13542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13543,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__13601 = arguments.length;
switch (G__13601) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj13604 = {};
return obj13604;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13609){
var map__13610 = p__13609;
var map__13610__$1 = ((cljs.core.seq_QMARK_.call(null,map__13610))?cljs.core.apply.call(null,cljs.core.hash_map,map__13610):map__13610);
var opts = map__13610__$1;
var statearr_13611_13614 = state;
(statearr_13611_13614[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__13610,map__13610__$1,opts){
return (function (val){
var statearr_13612_13615 = state;
(statearr_13612_13615[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13610,map__13610__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_13613_13616 = state;
(statearr_13613_13616[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13605){
var G__13606 = cljs.core.first.call(null,seq13605);
var seq13605__$1 = cljs.core.next.call(null,seq13605);
var G__13607 = cljs.core.first.call(null,seq13605__$1);
var seq13605__$2 = cljs.core.next.call(null,seq13605__$1);
var G__13608 = cljs.core.first.call(null,seq13605__$2);
var seq13605__$3 = cljs.core.next.call(null,seq13605__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13606,G__13607,G__13608,seq13605__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t13736 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13736 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13737){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13737 = meta13737;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13736.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t13736.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13736.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13738){
var self__ = this;
var _13738__$1 = this;
return self__.meta13737;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13738,meta13737__$1){
var self__ = this;
var _13738__$1 = this;
return (new cljs.core.async.t13736(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13737__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13736.cljs$lang$type = true;

cljs.core.async.t13736.cljs$lang$ctorStr = "cljs.core.async/t13736";

cljs.core.async.t13736.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13736");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t13736 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t13736(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13737){
return (new cljs.core.async.t13736(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13737));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t13736(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___13855 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13808){
var state_val_13809 = (state_13808[(1)]);
if((state_val_13809 === (7))){
var inst_13752 = (state_13808[(7)]);
var inst_13757 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13752);
var state_13808__$1 = state_13808;
var statearr_13810_13856 = state_13808__$1;
(statearr_13810_13856[(2)] = inst_13757);

(statearr_13810_13856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (20))){
var inst_13767 = (state_13808[(8)]);
var state_13808__$1 = state_13808;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13808__$1,(23),out,inst_13767);
} else {
if((state_val_13809 === (1))){
var inst_13742 = (state_13808[(9)]);
var inst_13742__$1 = calc_state.call(null);
var inst_13743 = cljs.core.seq_QMARK_.call(null,inst_13742__$1);
var state_13808__$1 = (function (){var statearr_13811 = state_13808;
(statearr_13811[(9)] = inst_13742__$1);

return statearr_13811;
})();
if(inst_13743){
var statearr_13812_13857 = state_13808__$1;
(statearr_13812_13857[(1)] = (2));

} else {
var statearr_13813_13858 = state_13808__$1;
(statearr_13813_13858[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (24))){
var inst_13760 = (state_13808[(10)]);
var inst_13752 = inst_13760;
var state_13808__$1 = (function (){var statearr_13814 = state_13808;
(statearr_13814[(7)] = inst_13752);

return statearr_13814;
})();
var statearr_13815_13859 = state_13808__$1;
(statearr_13815_13859[(2)] = null);

(statearr_13815_13859[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (4))){
var inst_13742 = (state_13808[(9)]);
var inst_13748 = (state_13808[(2)]);
var inst_13749 = cljs.core.get.call(null,inst_13748,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13750 = cljs.core.get.call(null,inst_13748,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13751 = cljs.core.get.call(null,inst_13748,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13752 = inst_13742;
var state_13808__$1 = (function (){var statearr_13816 = state_13808;
(statearr_13816[(11)] = inst_13751);

(statearr_13816[(12)] = inst_13750);

(statearr_13816[(7)] = inst_13752);

(statearr_13816[(13)] = inst_13749);

return statearr_13816;
})();
var statearr_13817_13860 = state_13808__$1;
(statearr_13817_13860[(2)] = null);

(statearr_13817_13860[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (15))){
var state_13808__$1 = state_13808;
var statearr_13818_13861 = state_13808__$1;
(statearr_13818_13861[(2)] = null);

(statearr_13818_13861[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (21))){
var inst_13760 = (state_13808[(10)]);
var inst_13752 = inst_13760;
var state_13808__$1 = (function (){var statearr_13819 = state_13808;
(statearr_13819[(7)] = inst_13752);

return statearr_13819;
})();
var statearr_13820_13862 = state_13808__$1;
(statearr_13820_13862[(2)] = null);

(statearr_13820_13862[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (13))){
var inst_13804 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
var statearr_13821_13863 = state_13808__$1;
(statearr_13821_13863[(2)] = inst_13804);

(statearr_13821_13863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (22))){
var inst_13802 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
var statearr_13822_13864 = state_13808__$1;
(statearr_13822_13864[(2)] = inst_13802);

(statearr_13822_13864[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (6))){
var inst_13806 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13808__$1,inst_13806);
} else {
if((state_val_13809 === (25))){
var state_13808__$1 = state_13808;
var statearr_13823_13865 = state_13808__$1;
(statearr_13823_13865[(2)] = null);

(statearr_13823_13865[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (17))){
var inst_13782 = (state_13808[(14)]);
var state_13808__$1 = state_13808;
var statearr_13824_13866 = state_13808__$1;
(statearr_13824_13866[(2)] = inst_13782);

(statearr_13824_13866[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (3))){
var inst_13742 = (state_13808[(9)]);
var state_13808__$1 = state_13808;
var statearr_13825_13867 = state_13808__$1;
(statearr_13825_13867[(2)] = inst_13742);

(statearr_13825_13867[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (12))){
var inst_13782 = (state_13808[(14)]);
var inst_13763 = (state_13808[(15)]);
var inst_13768 = (state_13808[(16)]);
var inst_13782__$1 = inst_13763.call(null,inst_13768);
var state_13808__$1 = (function (){var statearr_13826 = state_13808;
(statearr_13826[(14)] = inst_13782__$1);

return statearr_13826;
})();
if(cljs.core.truth_(inst_13782__$1)){
var statearr_13827_13868 = state_13808__$1;
(statearr_13827_13868[(1)] = (17));

} else {
var statearr_13828_13869 = state_13808__$1;
(statearr_13828_13869[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (2))){
var inst_13742 = (state_13808[(9)]);
var inst_13745 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13742);
var state_13808__$1 = state_13808;
var statearr_13829_13870 = state_13808__$1;
(statearr_13829_13870[(2)] = inst_13745);

(statearr_13829_13870[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (23))){
var inst_13793 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
if(cljs.core.truth_(inst_13793)){
var statearr_13830_13871 = state_13808__$1;
(statearr_13830_13871[(1)] = (24));

} else {
var statearr_13831_13872 = state_13808__$1;
(statearr_13831_13872[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (19))){
var inst_13790 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
if(cljs.core.truth_(inst_13790)){
var statearr_13832_13873 = state_13808__$1;
(statearr_13832_13873[(1)] = (20));

} else {
var statearr_13833_13874 = state_13808__$1;
(statearr_13833_13874[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (11))){
var inst_13767 = (state_13808[(8)]);
var inst_13773 = (inst_13767 == null);
var state_13808__$1 = state_13808;
if(cljs.core.truth_(inst_13773)){
var statearr_13834_13875 = state_13808__$1;
(statearr_13834_13875[(1)] = (14));

} else {
var statearr_13835_13876 = state_13808__$1;
(statearr_13835_13876[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (9))){
var inst_13760 = (state_13808[(10)]);
var inst_13760__$1 = (state_13808[(2)]);
var inst_13761 = cljs.core.get.call(null,inst_13760__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13762 = cljs.core.get.call(null,inst_13760__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13763 = cljs.core.get.call(null,inst_13760__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_13808__$1 = (function (){var statearr_13836 = state_13808;
(statearr_13836[(10)] = inst_13760__$1);

(statearr_13836[(17)] = inst_13762);

(statearr_13836[(15)] = inst_13763);

return statearr_13836;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13808__$1,(10),inst_13761);
} else {
if((state_val_13809 === (5))){
var inst_13752 = (state_13808[(7)]);
var inst_13755 = cljs.core.seq_QMARK_.call(null,inst_13752);
var state_13808__$1 = state_13808;
if(inst_13755){
var statearr_13837_13877 = state_13808__$1;
(statearr_13837_13877[(1)] = (7));

} else {
var statearr_13838_13878 = state_13808__$1;
(statearr_13838_13878[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (14))){
var inst_13768 = (state_13808[(16)]);
var inst_13775 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13768);
var state_13808__$1 = state_13808;
var statearr_13839_13879 = state_13808__$1;
(statearr_13839_13879[(2)] = inst_13775);

(statearr_13839_13879[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (26))){
var inst_13798 = (state_13808[(2)]);
var state_13808__$1 = state_13808;
var statearr_13840_13880 = state_13808__$1;
(statearr_13840_13880[(2)] = inst_13798);

(statearr_13840_13880[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (16))){
var inst_13778 = (state_13808[(2)]);
var inst_13779 = calc_state.call(null);
var inst_13752 = inst_13779;
var state_13808__$1 = (function (){var statearr_13841 = state_13808;
(statearr_13841[(18)] = inst_13778);

(statearr_13841[(7)] = inst_13752);

return statearr_13841;
})();
var statearr_13842_13881 = state_13808__$1;
(statearr_13842_13881[(2)] = null);

(statearr_13842_13881[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (10))){
var inst_13767 = (state_13808[(8)]);
var inst_13768 = (state_13808[(16)]);
var inst_13766 = (state_13808[(2)]);
var inst_13767__$1 = cljs.core.nth.call(null,inst_13766,(0),null);
var inst_13768__$1 = cljs.core.nth.call(null,inst_13766,(1),null);
var inst_13769 = (inst_13767__$1 == null);
var inst_13770 = cljs.core._EQ_.call(null,inst_13768__$1,change);
var inst_13771 = (inst_13769) || (inst_13770);
var state_13808__$1 = (function (){var statearr_13843 = state_13808;
(statearr_13843[(8)] = inst_13767__$1);

(statearr_13843[(16)] = inst_13768__$1);

return statearr_13843;
})();
if(cljs.core.truth_(inst_13771)){
var statearr_13844_13882 = state_13808__$1;
(statearr_13844_13882[(1)] = (11));

} else {
var statearr_13845_13883 = state_13808__$1;
(statearr_13845_13883[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (18))){
var inst_13762 = (state_13808[(17)]);
var inst_13763 = (state_13808[(15)]);
var inst_13768 = (state_13808[(16)]);
var inst_13785 = cljs.core.empty_QMARK_.call(null,inst_13763);
var inst_13786 = inst_13762.call(null,inst_13768);
var inst_13787 = cljs.core.not.call(null,inst_13786);
var inst_13788 = (inst_13785) && (inst_13787);
var state_13808__$1 = state_13808;
var statearr_13846_13884 = state_13808__$1;
(statearr_13846_13884[(2)] = inst_13788);

(statearr_13846_13884[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13809 === (8))){
var inst_13752 = (state_13808[(7)]);
var state_13808__$1 = state_13808;
var statearr_13847_13885 = state_13808__$1;
(statearr_13847_13885[(2)] = inst_13752);

(statearr_13847_13885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_13851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13851[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_13851[(1)] = (1));

return statearr_13851;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_13808){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13852){if((e13852 instanceof Object)){
var ex__7651__auto__ = e13852;
var statearr_13853_13886 = state_13808;
(statearr_13853_13886[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13808);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13852;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13887 = state_13808;
state_13808 = G__13887;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_13808){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_13808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_13854 = f__7710__auto__.call(null);
(statearr_13854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13855);

return statearr_13854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13855,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj13889 = {};
return obj13889;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__13891 = arguments.length;
switch (G__13891) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__13895 = arguments.length;
switch (G__13895) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4276__auto__,mults){
return (function (p1__13893_SHARP_){
if(cljs.core.truth_(p1__13893_SHARP_.call(null,topic))){
return p1__13893_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13893_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t13896 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13896 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta13897){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta13897 = meta13897;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13896.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t13896.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13896.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13898){
var self__ = this;
var _13898__$1 = this;
return self__.meta13897;
});})(mults,ensure_mult))
;

cljs.core.async.t13896.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13898,meta13897__$1){
var self__ = this;
var _13898__$1 = this;
return (new cljs.core.async.t13896(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta13897__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t13896.cljs$lang$type = true;

cljs.core.async.t13896.cljs$lang$ctorStr = "cljs.core.async/t13896";

cljs.core.async.t13896.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13896");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t13896 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t13896(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13897){
return (new cljs.core.async.t13896(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13897));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t13896(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___14019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14019,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14019,mults,ensure_mult,p){
return (function (state_13970){
var state_val_13971 = (state_13970[(1)]);
if((state_val_13971 === (7))){
var inst_13966 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_13972_14020 = state_13970__$1;
(statearr_13972_14020[(2)] = inst_13966);

(statearr_13972_14020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (20))){
var state_13970__$1 = state_13970;
var statearr_13973_14021 = state_13970__$1;
(statearr_13973_14021[(2)] = null);

(statearr_13973_14021[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (1))){
var state_13970__$1 = state_13970;
var statearr_13974_14022 = state_13970__$1;
(statearr_13974_14022[(2)] = null);

(statearr_13974_14022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (24))){
var inst_13949 = (state_13970[(7)]);
var inst_13958 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13949);
var state_13970__$1 = state_13970;
var statearr_13975_14023 = state_13970__$1;
(statearr_13975_14023[(2)] = inst_13958);

(statearr_13975_14023[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (4))){
var inst_13901 = (state_13970[(8)]);
var inst_13901__$1 = (state_13970[(2)]);
var inst_13902 = (inst_13901__$1 == null);
var state_13970__$1 = (function (){var statearr_13976 = state_13970;
(statearr_13976[(8)] = inst_13901__$1);

return statearr_13976;
})();
if(cljs.core.truth_(inst_13902)){
var statearr_13977_14024 = state_13970__$1;
(statearr_13977_14024[(1)] = (5));

} else {
var statearr_13978_14025 = state_13970__$1;
(statearr_13978_14025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (15))){
var inst_13943 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_13979_14026 = state_13970__$1;
(statearr_13979_14026[(2)] = inst_13943);

(statearr_13979_14026[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (21))){
var inst_13963 = (state_13970[(2)]);
var state_13970__$1 = (function (){var statearr_13980 = state_13970;
(statearr_13980[(9)] = inst_13963);

return statearr_13980;
})();
var statearr_13981_14027 = state_13970__$1;
(statearr_13981_14027[(2)] = null);

(statearr_13981_14027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (13))){
var inst_13925 = (state_13970[(10)]);
var inst_13927 = cljs.core.chunked_seq_QMARK_.call(null,inst_13925);
var state_13970__$1 = state_13970;
if(inst_13927){
var statearr_13982_14028 = state_13970__$1;
(statearr_13982_14028[(1)] = (16));

} else {
var statearr_13983_14029 = state_13970__$1;
(statearr_13983_14029[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (22))){
var inst_13955 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
if(cljs.core.truth_(inst_13955)){
var statearr_13984_14030 = state_13970__$1;
(statearr_13984_14030[(1)] = (23));

} else {
var statearr_13985_14031 = state_13970__$1;
(statearr_13985_14031[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (6))){
var inst_13949 = (state_13970[(7)]);
var inst_13901 = (state_13970[(8)]);
var inst_13951 = (state_13970[(11)]);
var inst_13949__$1 = topic_fn.call(null,inst_13901);
var inst_13950 = cljs.core.deref.call(null,mults);
var inst_13951__$1 = cljs.core.get.call(null,inst_13950,inst_13949__$1);
var state_13970__$1 = (function (){var statearr_13986 = state_13970;
(statearr_13986[(7)] = inst_13949__$1);

(statearr_13986[(11)] = inst_13951__$1);

return statearr_13986;
})();
if(cljs.core.truth_(inst_13951__$1)){
var statearr_13987_14032 = state_13970__$1;
(statearr_13987_14032[(1)] = (19));

} else {
var statearr_13988_14033 = state_13970__$1;
(statearr_13988_14033[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (25))){
var inst_13960 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_13989_14034 = state_13970__$1;
(statearr_13989_14034[(2)] = inst_13960);

(statearr_13989_14034[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (17))){
var inst_13925 = (state_13970[(10)]);
var inst_13934 = cljs.core.first.call(null,inst_13925);
var inst_13935 = cljs.core.async.muxch_STAR_.call(null,inst_13934);
var inst_13936 = cljs.core.async.close_BANG_.call(null,inst_13935);
var inst_13937 = cljs.core.next.call(null,inst_13925);
var inst_13911 = inst_13937;
var inst_13912 = null;
var inst_13913 = (0);
var inst_13914 = (0);
var state_13970__$1 = (function (){var statearr_13990 = state_13970;
(statearr_13990[(12)] = inst_13936);

(statearr_13990[(13)] = inst_13911);

(statearr_13990[(14)] = inst_13914);

(statearr_13990[(15)] = inst_13912);

(statearr_13990[(16)] = inst_13913);

return statearr_13990;
})();
var statearr_13991_14035 = state_13970__$1;
(statearr_13991_14035[(2)] = null);

(statearr_13991_14035[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (3))){
var inst_13968 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13970__$1,inst_13968);
} else {
if((state_val_13971 === (12))){
var inst_13945 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_13992_14036 = state_13970__$1;
(statearr_13992_14036[(2)] = inst_13945);

(statearr_13992_14036[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (2))){
var state_13970__$1 = state_13970;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13970__$1,(4),ch);
} else {
if((state_val_13971 === (23))){
var state_13970__$1 = state_13970;
var statearr_13993_14037 = state_13970__$1;
(statearr_13993_14037[(2)] = null);

(statearr_13993_14037[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (19))){
var inst_13901 = (state_13970[(8)]);
var inst_13951 = (state_13970[(11)]);
var inst_13953 = cljs.core.async.muxch_STAR_.call(null,inst_13951);
var state_13970__$1 = state_13970;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13970__$1,(22),inst_13953,inst_13901);
} else {
if((state_val_13971 === (11))){
var inst_13911 = (state_13970[(13)]);
var inst_13925 = (state_13970[(10)]);
var inst_13925__$1 = cljs.core.seq.call(null,inst_13911);
var state_13970__$1 = (function (){var statearr_13994 = state_13970;
(statearr_13994[(10)] = inst_13925__$1);

return statearr_13994;
})();
if(inst_13925__$1){
var statearr_13995_14038 = state_13970__$1;
(statearr_13995_14038[(1)] = (13));

} else {
var statearr_13996_14039 = state_13970__$1;
(statearr_13996_14039[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (9))){
var inst_13947 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_13997_14040 = state_13970__$1;
(statearr_13997_14040[(2)] = inst_13947);

(statearr_13997_14040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (5))){
var inst_13908 = cljs.core.deref.call(null,mults);
var inst_13909 = cljs.core.vals.call(null,inst_13908);
var inst_13910 = cljs.core.seq.call(null,inst_13909);
var inst_13911 = inst_13910;
var inst_13912 = null;
var inst_13913 = (0);
var inst_13914 = (0);
var state_13970__$1 = (function (){var statearr_13998 = state_13970;
(statearr_13998[(13)] = inst_13911);

(statearr_13998[(14)] = inst_13914);

(statearr_13998[(15)] = inst_13912);

(statearr_13998[(16)] = inst_13913);

return statearr_13998;
})();
var statearr_13999_14041 = state_13970__$1;
(statearr_13999_14041[(2)] = null);

(statearr_13999_14041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (14))){
var state_13970__$1 = state_13970;
var statearr_14003_14042 = state_13970__$1;
(statearr_14003_14042[(2)] = null);

(statearr_14003_14042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (16))){
var inst_13925 = (state_13970[(10)]);
var inst_13929 = cljs.core.chunk_first.call(null,inst_13925);
var inst_13930 = cljs.core.chunk_rest.call(null,inst_13925);
var inst_13931 = cljs.core.count.call(null,inst_13929);
var inst_13911 = inst_13930;
var inst_13912 = inst_13929;
var inst_13913 = inst_13931;
var inst_13914 = (0);
var state_13970__$1 = (function (){var statearr_14004 = state_13970;
(statearr_14004[(13)] = inst_13911);

(statearr_14004[(14)] = inst_13914);

(statearr_14004[(15)] = inst_13912);

(statearr_14004[(16)] = inst_13913);

return statearr_14004;
})();
var statearr_14005_14043 = state_13970__$1;
(statearr_14005_14043[(2)] = null);

(statearr_14005_14043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (10))){
var inst_13911 = (state_13970[(13)]);
var inst_13914 = (state_13970[(14)]);
var inst_13912 = (state_13970[(15)]);
var inst_13913 = (state_13970[(16)]);
var inst_13919 = cljs.core._nth.call(null,inst_13912,inst_13914);
var inst_13920 = cljs.core.async.muxch_STAR_.call(null,inst_13919);
var inst_13921 = cljs.core.async.close_BANG_.call(null,inst_13920);
var inst_13922 = (inst_13914 + (1));
var tmp14000 = inst_13911;
var tmp14001 = inst_13912;
var tmp14002 = inst_13913;
var inst_13911__$1 = tmp14000;
var inst_13912__$1 = tmp14001;
var inst_13913__$1 = tmp14002;
var inst_13914__$1 = inst_13922;
var state_13970__$1 = (function (){var statearr_14006 = state_13970;
(statearr_14006[(13)] = inst_13911__$1);

(statearr_14006[(17)] = inst_13921);

(statearr_14006[(14)] = inst_13914__$1);

(statearr_14006[(15)] = inst_13912__$1);

(statearr_14006[(16)] = inst_13913__$1);

return statearr_14006;
})();
var statearr_14007_14044 = state_13970__$1;
(statearr_14007_14044[(2)] = null);

(statearr_14007_14044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (18))){
var inst_13940 = (state_13970[(2)]);
var state_13970__$1 = state_13970;
var statearr_14008_14045 = state_13970__$1;
(statearr_14008_14045[(2)] = inst_13940);

(statearr_14008_14045[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13971 === (8))){
var inst_13914 = (state_13970[(14)]);
var inst_13913 = (state_13970[(16)]);
var inst_13916 = (inst_13914 < inst_13913);
var inst_13917 = inst_13916;
var state_13970__$1 = state_13970;
if(cljs.core.truth_(inst_13917)){
var statearr_14009_14046 = state_13970__$1;
(statearr_14009_14046[(1)] = (10));

} else {
var statearr_14010_14047 = state_13970__$1;
(statearr_14010_14047[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14019,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___14019,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14014[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14014[(1)] = (1));

return statearr_14014;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13970){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13970);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14015){if((e14015 instanceof Object)){
var ex__7651__auto__ = e14015;
var statearr_14016_14048 = state_13970;
(statearr_14016_14048[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13970);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14049 = state_13970;
state_13970 = G__14049;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13970){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14019,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_14017 = f__7710__auto__.call(null);
(statearr_14017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14019);

return statearr_14017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14019,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__14051 = arguments.length;
switch (G__14051) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__14054 = arguments.length;
switch (G__14054) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__14057 = arguments.length;
switch (G__14057) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7709__auto___14127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14096){
var state_val_14097 = (state_14096[(1)]);
if((state_val_14097 === (7))){
var state_14096__$1 = state_14096;
var statearr_14098_14128 = state_14096__$1;
(statearr_14098_14128[(2)] = null);

(statearr_14098_14128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (1))){
var state_14096__$1 = state_14096;
var statearr_14099_14129 = state_14096__$1;
(statearr_14099_14129[(2)] = null);

(statearr_14099_14129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (4))){
var inst_14060 = (state_14096[(7)]);
var inst_14062 = (inst_14060 < cnt);
var state_14096__$1 = state_14096;
if(cljs.core.truth_(inst_14062)){
var statearr_14100_14130 = state_14096__$1;
(statearr_14100_14130[(1)] = (6));

} else {
var statearr_14101_14131 = state_14096__$1;
(statearr_14101_14131[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (15))){
var inst_14092 = (state_14096[(2)]);
var state_14096__$1 = state_14096;
var statearr_14102_14132 = state_14096__$1;
(statearr_14102_14132[(2)] = inst_14092);

(statearr_14102_14132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (13))){
var inst_14085 = cljs.core.async.close_BANG_.call(null,out);
var state_14096__$1 = state_14096;
var statearr_14103_14133 = state_14096__$1;
(statearr_14103_14133[(2)] = inst_14085);

(statearr_14103_14133[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (6))){
var state_14096__$1 = state_14096;
var statearr_14104_14134 = state_14096__$1;
(statearr_14104_14134[(2)] = null);

(statearr_14104_14134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (3))){
var inst_14094 = (state_14096[(2)]);
var state_14096__$1 = state_14096;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14096__$1,inst_14094);
} else {
if((state_val_14097 === (12))){
var inst_14082 = (state_14096[(8)]);
var inst_14082__$1 = (state_14096[(2)]);
var inst_14083 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14082__$1);
var state_14096__$1 = (function (){var statearr_14105 = state_14096;
(statearr_14105[(8)] = inst_14082__$1);

return statearr_14105;
})();
if(cljs.core.truth_(inst_14083)){
var statearr_14106_14135 = state_14096__$1;
(statearr_14106_14135[(1)] = (13));

} else {
var statearr_14107_14136 = state_14096__$1;
(statearr_14107_14136[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (2))){
var inst_14059 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14060 = (0);
var state_14096__$1 = (function (){var statearr_14108 = state_14096;
(statearr_14108[(9)] = inst_14059);

(statearr_14108[(7)] = inst_14060);

return statearr_14108;
})();
var statearr_14109_14137 = state_14096__$1;
(statearr_14109_14137[(2)] = null);

(statearr_14109_14137[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (11))){
var inst_14060 = (state_14096[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14096,(10),Object,null,(9));
var inst_14069 = chs__$1.call(null,inst_14060);
var inst_14070 = done.call(null,inst_14060);
var inst_14071 = cljs.core.async.take_BANG_.call(null,inst_14069,inst_14070);
var state_14096__$1 = state_14096;
var statearr_14110_14138 = state_14096__$1;
(statearr_14110_14138[(2)] = inst_14071);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14096__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (9))){
var inst_14060 = (state_14096[(7)]);
var inst_14073 = (state_14096[(2)]);
var inst_14074 = (inst_14060 + (1));
var inst_14060__$1 = inst_14074;
var state_14096__$1 = (function (){var statearr_14111 = state_14096;
(statearr_14111[(7)] = inst_14060__$1);

(statearr_14111[(10)] = inst_14073);

return statearr_14111;
})();
var statearr_14112_14139 = state_14096__$1;
(statearr_14112_14139[(2)] = null);

(statearr_14112_14139[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (5))){
var inst_14080 = (state_14096[(2)]);
var state_14096__$1 = (function (){var statearr_14113 = state_14096;
(statearr_14113[(11)] = inst_14080);

return statearr_14113;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14096__$1,(12),dchan);
} else {
if((state_val_14097 === (14))){
var inst_14082 = (state_14096[(8)]);
var inst_14087 = cljs.core.apply.call(null,f,inst_14082);
var state_14096__$1 = state_14096;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14096__$1,(16),out,inst_14087);
} else {
if((state_val_14097 === (16))){
var inst_14089 = (state_14096[(2)]);
var state_14096__$1 = (function (){var statearr_14114 = state_14096;
(statearr_14114[(12)] = inst_14089);

return statearr_14114;
})();
var statearr_14115_14140 = state_14096__$1;
(statearr_14115_14140[(2)] = null);

(statearr_14115_14140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (10))){
var inst_14064 = (state_14096[(2)]);
var inst_14065 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14096__$1 = (function (){var statearr_14116 = state_14096;
(statearr_14116[(13)] = inst_14064);

return statearr_14116;
})();
var statearr_14117_14141 = state_14096__$1;
(statearr_14117_14141[(2)] = inst_14065);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14096__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14097 === (8))){
var inst_14078 = (state_14096[(2)]);
var state_14096__$1 = state_14096;
var statearr_14118_14142 = state_14096__$1;
(statearr_14118_14142[(2)] = inst_14078);

(statearr_14118_14142[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14122[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14122[(1)] = (1));

return statearr_14122;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14096){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14123){if((e14123 instanceof Object)){
var ex__7651__auto__ = e14123;
var statearr_14124_14143 = state_14096;
(statearr_14124_14143[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14144 = state_14096;
state_14096 = G__14144;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14096){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_14125 = f__7710__auto__.call(null);
(statearr_14125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14127);

return statearr_14125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14127,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__14147 = arguments.length;
switch (G__14147) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14202,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14202,out){
return (function (state_14177){
var state_val_14178 = (state_14177[(1)]);
if((state_val_14178 === (7))){
var inst_14156 = (state_14177[(7)]);
var inst_14157 = (state_14177[(8)]);
var inst_14156__$1 = (state_14177[(2)]);
var inst_14157__$1 = cljs.core.nth.call(null,inst_14156__$1,(0),null);
var inst_14158 = cljs.core.nth.call(null,inst_14156__$1,(1),null);
var inst_14159 = (inst_14157__$1 == null);
var state_14177__$1 = (function (){var statearr_14179 = state_14177;
(statearr_14179[(7)] = inst_14156__$1);

(statearr_14179[(8)] = inst_14157__$1);

(statearr_14179[(9)] = inst_14158);

return statearr_14179;
})();
if(cljs.core.truth_(inst_14159)){
var statearr_14180_14203 = state_14177__$1;
(statearr_14180_14203[(1)] = (8));

} else {
var statearr_14181_14204 = state_14177__$1;
(statearr_14181_14204[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (1))){
var inst_14148 = cljs.core.vec.call(null,chs);
var inst_14149 = inst_14148;
var state_14177__$1 = (function (){var statearr_14182 = state_14177;
(statearr_14182[(10)] = inst_14149);

return statearr_14182;
})();
var statearr_14183_14205 = state_14177__$1;
(statearr_14183_14205[(2)] = null);

(statearr_14183_14205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (4))){
var inst_14149 = (state_14177[(10)]);
var state_14177__$1 = state_14177;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14177__$1,(7),inst_14149);
} else {
if((state_val_14178 === (6))){
var inst_14173 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14184_14206 = state_14177__$1;
(statearr_14184_14206[(2)] = inst_14173);

(statearr_14184_14206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (3))){
var inst_14175 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14177__$1,inst_14175);
} else {
if((state_val_14178 === (2))){
var inst_14149 = (state_14177[(10)]);
var inst_14151 = cljs.core.count.call(null,inst_14149);
var inst_14152 = (inst_14151 > (0));
var state_14177__$1 = state_14177;
if(cljs.core.truth_(inst_14152)){
var statearr_14186_14207 = state_14177__$1;
(statearr_14186_14207[(1)] = (4));

} else {
var statearr_14187_14208 = state_14177__$1;
(statearr_14187_14208[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (11))){
var inst_14149 = (state_14177[(10)]);
var inst_14166 = (state_14177[(2)]);
var tmp14185 = inst_14149;
var inst_14149__$1 = tmp14185;
var state_14177__$1 = (function (){var statearr_14188 = state_14177;
(statearr_14188[(11)] = inst_14166);

(statearr_14188[(10)] = inst_14149__$1);

return statearr_14188;
})();
var statearr_14189_14209 = state_14177__$1;
(statearr_14189_14209[(2)] = null);

(statearr_14189_14209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (9))){
var inst_14157 = (state_14177[(8)]);
var state_14177__$1 = state_14177;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14177__$1,(11),out,inst_14157);
} else {
if((state_val_14178 === (5))){
var inst_14171 = cljs.core.async.close_BANG_.call(null,out);
var state_14177__$1 = state_14177;
var statearr_14190_14210 = state_14177__$1;
(statearr_14190_14210[(2)] = inst_14171);

(statearr_14190_14210[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (10))){
var inst_14169 = (state_14177[(2)]);
var state_14177__$1 = state_14177;
var statearr_14191_14211 = state_14177__$1;
(statearr_14191_14211[(2)] = inst_14169);

(statearr_14191_14211[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14178 === (8))){
var inst_14156 = (state_14177[(7)]);
var inst_14157 = (state_14177[(8)]);
var inst_14149 = (state_14177[(10)]);
var inst_14158 = (state_14177[(9)]);
var inst_14161 = (function (){var c = inst_14158;
var v = inst_14157;
var vec__14154 = inst_14156;
var cs = inst_14149;
return ((function (c,v,vec__14154,cs,inst_14156,inst_14157,inst_14149,inst_14158,state_val_14178,c__7709__auto___14202,out){
return (function (p1__14145_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14145_SHARP_);
});
;})(c,v,vec__14154,cs,inst_14156,inst_14157,inst_14149,inst_14158,state_val_14178,c__7709__auto___14202,out))
})();
var inst_14162 = cljs.core.filterv.call(null,inst_14161,inst_14149);
var inst_14149__$1 = inst_14162;
var state_14177__$1 = (function (){var statearr_14192 = state_14177;
(statearr_14192[(10)] = inst_14149__$1);

return statearr_14192;
})();
var statearr_14193_14212 = state_14177__$1;
(statearr_14193_14212[(2)] = null);

(statearr_14193_14212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14202,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14202,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14197 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14197[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14197[(1)] = (1));

return statearr_14197;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14177){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14198){if((e14198 instanceof Object)){
var ex__7651__auto__ = e14198;
var statearr_14199_14213 = state_14177;
(statearr_14199_14213[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14214 = state_14177;
state_14177 = G__14214;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14177){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14202,out))
})();
var state__7711__auto__ = (function (){var statearr_14200 = f__7710__auto__.call(null);
(statearr_14200[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14202);

return statearr_14200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14202,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__14216 = arguments.length;
switch (G__14216) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14264 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14264,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14264,out){
return (function (state_14240){
var state_val_14241 = (state_14240[(1)]);
if((state_val_14241 === (7))){
var inst_14222 = (state_14240[(7)]);
var inst_14222__$1 = (state_14240[(2)]);
var inst_14223 = (inst_14222__$1 == null);
var inst_14224 = cljs.core.not.call(null,inst_14223);
var state_14240__$1 = (function (){var statearr_14242 = state_14240;
(statearr_14242[(7)] = inst_14222__$1);

return statearr_14242;
})();
if(inst_14224){
var statearr_14243_14265 = state_14240__$1;
(statearr_14243_14265[(1)] = (8));

} else {
var statearr_14244_14266 = state_14240__$1;
(statearr_14244_14266[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (1))){
var inst_14217 = (0);
var state_14240__$1 = (function (){var statearr_14245 = state_14240;
(statearr_14245[(8)] = inst_14217);

return statearr_14245;
})();
var statearr_14246_14267 = state_14240__$1;
(statearr_14246_14267[(2)] = null);

(statearr_14246_14267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (4))){
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14240__$1,(7),ch);
} else {
if((state_val_14241 === (6))){
var inst_14235 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14247_14268 = state_14240__$1;
(statearr_14247_14268[(2)] = inst_14235);

(statearr_14247_14268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (3))){
var inst_14237 = (state_14240[(2)]);
var inst_14238 = cljs.core.async.close_BANG_.call(null,out);
var state_14240__$1 = (function (){var statearr_14248 = state_14240;
(statearr_14248[(9)] = inst_14237);

return statearr_14248;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14240__$1,inst_14238);
} else {
if((state_val_14241 === (2))){
var inst_14217 = (state_14240[(8)]);
var inst_14219 = (inst_14217 < n);
var state_14240__$1 = state_14240;
if(cljs.core.truth_(inst_14219)){
var statearr_14249_14269 = state_14240__$1;
(statearr_14249_14269[(1)] = (4));

} else {
var statearr_14250_14270 = state_14240__$1;
(statearr_14250_14270[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (11))){
var inst_14217 = (state_14240[(8)]);
var inst_14227 = (state_14240[(2)]);
var inst_14228 = (inst_14217 + (1));
var inst_14217__$1 = inst_14228;
var state_14240__$1 = (function (){var statearr_14251 = state_14240;
(statearr_14251[(8)] = inst_14217__$1);

(statearr_14251[(10)] = inst_14227);

return statearr_14251;
})();
var statearr_14252_14271 = state_14240__$1;
(statearr_14252_14271[(2)] = null);

(statearr_14252_14271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (9))){
var state_14240__$1 = state_14240;
var statearr_14253_14272 = state_14240__$1;
(statearr_14253_14272[(2)] = null);

(statearr_14253_14272[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (5))){
var state_14240__$1 = state_14240;
var statearr_14254_14273 = state_14240__$1;
(statearr_14254_14273[(2)] = null);

(statearr_14254_14273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (10))){
var inst_14232 = (state_14240[(2)]);
var state_14240__$1 = state_14240;
var statearr_14255_14274 = state_14240__$1;
(statearr_14255_14274[(2)] = inst_14232);

(statearr_14255_14274[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14241 === (8))){
var inst_14222 = (state_14240[(7)]);
var state_14240__$1 = state_14240;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14240__$1,(11),out,inst_14222);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14264,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14264,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14259 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14259[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14259[(1)] = (1));

return statearr_14259;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14240){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14260){if((e14260 instanceof Object)){
var ex__7651__auto__ = e14260;
var statearr_14261_14275 = state_14240;
(statearr_14261_14275[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14240);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14260;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14276 = state_14240;
state_14240 = G__14276;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14240){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14264,out))
})();
var state__7711__auto__ = (function (){var statearr_14262 = f__7710__auto__.call(null);
(statearr_14262[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14264);

return statearr_14262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14264,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t14284 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14284 = (function (ch,f,map_LT_,meta14285){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta14285 = meta14285;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t14287 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14287 = (function (fn1,_,meta14285,map_LT_,f,ch,meta14288){
this.fn1 = fn1;
this._ = _;
this.meta14285 = meta14285;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14288 = meta14288;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14287.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t14287.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t14287.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14277_SHARP_){
return f1.call(null,(((p1__14277_SHARP_ == null))?null:self__.f.call(null,p1__14277_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t14287.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14289){
var self__ = this;
var _14289__$1 = this;
return self__.meta14288;
});})(___$1))
;

cljs.core.async.t14287.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14289,meta14288__$1){
var self__ = this;
var _14289__$1 = this;
return (new cljs.core.async.t14287(self__.fn1,self__._,self__.meta14285,self__.map_LT_,self__.f,self__.ch,meta14288__$1));
});})(___$1))
;

cljs.core.async.t14287.cljs$lang$type = true;

cljs.core.async.t14287.cljs$lang$ctorStr = "cljs.core.async/t14287";

cljs.core.async.t14287.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14287");
});})(___$1))
;

cljs.core.async.__GT_t14287 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t14287(fn1__$1,___$2,meta14285__$1,map_LT___$1,f__$1,ch__$1,meta14288){
return (new cljs.core.async.t14287(fn1__$1,___$2,meta14285__$1,map_LT___$1,f__$1,ch__$1,meta14288));
});})(___$1))
;

}

return (new cljs.core.async.t14287(fn1,___$1,self__.meta14285,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14284.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14284.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14286){
var self__ = this;
var _14286__$1 = this;
return self__.meta14285;
});

cljs.core.async.t14284.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14286,meta14285__$1){
var self__ = this;
var _14286__$1 = this;
return (new cljs.core.async.t14284(self__.ch,self__.f,self__.map_LT_,meta14285__$1));
});

cljs.core.async.t14284.cljs$lang$type = true;

cljs.core.async.t14284.cljs$lang$ctorStr = "cljs.core.async/t14284";

cljs.core.async.t14284.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14284");
});

cljs.core.async.__GT_t14284 = (function cljs$core$async$map_LT__$___GT_t14284(ch__$1,f__$1,map_LT___$1,meta14285){
return (new cljs.core.async.t14284(ch__$1,f__$1,map_LT___$1,meta14285));
});

}

return (new cljs.core.async.t14284(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t14293 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14293 = (function (ch,f,map_GT_,meta14294){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta14294 = meta14294;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14293.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14295){
var self__ = this;
var _14295__$1 = this;
return self__.meta14294;
});

cljs.core.async.t14293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14295,meta14294__$1){
var self__ = this;
var _14295__$1 = this;
return (new cljs.core.async.t14293(self__.ch,self__.f,self__.map_GT_,meta14294__$1));
});

cljs.core.async.t14293.cljs$lang$type = true;

cljs.core.async.t14293.cljs$lang$ctorStr = "cljs.core.async/t14293";

cljs.core.async.t14293.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14293");
});

cljs.core.async.__GT_t14293 = (function cljs$core$async$map_GT__$___GT_t14293(ch__$1,f__$1,map_GT___$1,meta14294){
return (new cljs.core.async.t14293(ch__$1,f__$1,map_GT___$1,meta14294));
});

}

return (new cljs.core.async.t14293(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t14299 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14299 = (function (ch,p,filter_GT_,meta14300){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta14300 = meta14300;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14299.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14299.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14301){
var self__ = this;
var _14301__$1 = this;
return self__.meta14300;
});

cljs.core.async.t14299.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14301,meta14300__$1){
var self__ = this;
var _14301__$1 = this;
return (new cljs.core.async.t14299(self__.ch,self__.p,self__.filter_GT_,meta14300__$1));
});

cljs.core.async.t14299.cljs$lang$type = true;

cljs.core.async.t14299.cljs$lang$ctorStr = "cljs.core.async/t14299";

cljs.core.async.t14299.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14299");
});

cljs.core.async.__GT_t14299 = (function cljs$core$async$filter_GT__$___GT_t14299(ch__$1,p__$1,filter_GT___$1,meta14300){
return (new cljs.core.async.t14299(ch__$1,p__$1,filter_GT___$1,meta14300));
});

}

return (new cljs.core.async.t14299(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__14303 = arguments.length;
switch (G__14303) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14346 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14346,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14346,out){
return (function (state_14324){
var state_val_14325 = (state_14324[(1)]);
if((state_val_14325 === (7))){
var inst_14320 = (state_14324[(2)]);
var state_14324__$1 = state_14324;
var statearr_14326_14347 = state_14324__$1;
(statearr_14326_14347[(2)] = inst_14320);

(statearr_14326_14347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (1))){
var state_14324__$1 = state_14324;
var statearr_14327_14348 = state_14324__$1;
(statearr_14327_14348[(2)] = null);

(statearr_14327_14348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (4))){
var inst_14306 = (state_14324[(7)]);
var inst_14306__$1 = (state_14324[(2)]);
var inst_14307 = (inst_14306__$1 == null);
var state_14324__$1 = (function (){var statearr_14328 = state_14324;
(statearr_14328[(7)] = inst_14306__$1);

return statearr_14328;
})();
if(cljs.core.truth_(inst_14307)){
var statearr_14329_14349 = state_14324__$1;
(statearr_14329_14349[(1)] = (5));

} else {
var statearr_14330_14350 = state_14324__$1;
(statearr_14330_14350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (6))){
var inst_14306 = (state_14324[(7)]);
var inst_14311 = p.call(null,inst_14306);
var state_14324__$1 = state_14324;
if(cljs.core.truth_(inst_14311)){
var statearr_14331_14351 = state_14324__$1;
(statearr_14331_14351[(1)] = (8));

} else {
var statearr_14332_14352 = state_14324__$1;
(statearr_14332_14352[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (3))){
var inst_14322 = (state_14324[(2)]);
var state_14324__$1 = state_14324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14324__$1,inst_14322);
} else {
if((state_val_14325 === (2))){
var state_14324__$1 = state_14324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14324__$1,(4),ch);
} else {
if((state_val_14325 === (11))){
var inst_14314 = (state_14324[(2)]);
var state_14324__$1 = state_14324;
var statearr_14333_14353 = state_14324__$1;
(statearr_14333_14353[(2)] = inst_14314);

(statearr_14333_14353[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (9))){
var state_14324__$1 = state_14324;
var statearr_14334_14354 = state_14324__$1;
(statearr_14334_14354[(2)] = null);

(statearr_14334_14354[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (5))){
var inst_14309 = cljs.core.async.close_BANG_.call(null,out);
var state_14324__$1 = state_14324;
var statearr_14335_14355 = state_14324__$1;
(statearr_14335_14355[(2)] = inst_14309);

(statearr_14335_14355[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (10))){
var inst_14317 = (state_14324[(2)]);
var state_14324__$1 = (function (){var statearr_14336 = state_14324;
(statearr_14336[(8)] = inst_14317);

return statearr_14336;
})();
var statearr_14337_14356 = state_14324__$1;
(statearr_14337_14356[(2)] = null);

(statearr_14337_14356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14325 === (8))){
var inst_14306 = (state_14324[(7)]);
var state_14324__$1 = state_14324;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14324__$1,(11),out,inst_14306);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14346,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14346,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14341 = [null,null,null,null,null,null,null,null,null];
(statearr_14341[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14341[(1)] = (1));

return statearr_14341;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14324){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14342){if((e14342 instanceof Object)){
var ex__7651__auto__ = e14342;
var statearr_14343_14357 = state_14324;
(statearr_14343_14357[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14324);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14342;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14358 = state_14324;
state_14324 = G__14358;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14324){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14346,out))
})();
var state__7711__auto__ = (function (){var statearr_14344 = f__7710__auto__.call(null);
(statearr_14344[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14346);

return statearr_14344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14346,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__14360 = arguments.length;
switch (G__14360) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_14527){
var state_val_14528 = (state_14527[(1)]);
if((state_val_14528 === (7))){
var inst_14523 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
var statearr_14529_14570 = state_14527__$1;
(statearr_14529_14570[(2)] = inst_14523);

(statearr_14529_14570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (20))){
var inst_14493 = (state_14527[(7)]);
var inst_14504 = (state_14527[(2)]);
var inst_14505 = cljs.core.next.call(null,inst_14493);
var inst_14479 = inst_14505;
var inst_14480 = null;
var inst_14481 = (0);
var inst_14482 = (0);
var state_14527__$1 = (function (){var statearr_14530 = state_14527;
(statearr_14530[(8)] = inst_14482);

(statearr_14530[(9)] = inst_14479);

(statearr_14530[(10)] = inst_14481);

(statearr_14530[(11)] = inst_14504);

(statearr_14530[(12)] = inst_14480);

return statearr_14530;
})();
var statearr_14531_14571 = state_14527__$1;
(statearr_14531_14571[(2)] = null);

(statearr_14531_14571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (1))){
var state_14527__$1 = state_14527;
var statearr_14532_14572 = state_14527__$1;
(statearr_14532_14572[(2)] = null);

(statearr_14532_14572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (4))){
var inst_14468 = (state_14527[(13)]);
var inst_14468__$1 = (state_14527[(2)]);
var inst_14469 = (inst_14468__$1 == null);
var state_14527__$1 = (function (){var statearr_14533 = state_14527;
(statearr_14533[(13)] = inst_14468__$1);

return statearr_14533;
})();
if(cljs.core.truth_(inst_14469)){
var statearr_14534_14573 = state_14527__$1;
(statearr_14534_14573[(1)] = (5));

} else {
var statearr_14535_14574 = state_14527__$1;
(statearr_14535_14574[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (15))){
var state_14527__$1 = state_14527;
var statearr_14539_14575 = state_14527__$1;
(statearr_14539_14575[(2)] = null);

(statearr_14539_14575[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (21))){
var state_14527__$1 = state_14527;
var statearr_14540_14576 = state_14527__$1;
(statearr_14540_14576[(2)] = null);

(statearr_14540_14576[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (13))){
var inst_14482 = (state_14527[(8)]);
var inst_14479 = (state_14527[(9)]);
var inst_14481 = (state_14527[(10)]);
var inst_14480 = (state_14527[(12)]);
var inst_14489 = (state_14527[(2)]);
var inst_14490 = (inst_14482 + (1));
var tmp14536 = inst_14479;
var tmp14537 = inst_14481;
var tmp14538 = inst_14480;
var inst_14479__$1 = tmp14536;
var inst_14480__$1 = tmp14538;
var inst_14481__$1 = tmp14537;
var inst_14482__$1 = inst_14490;
var state_14527__$1 = (function (){var statearr_14541 = state_14527;
(statearr_14541[(8)] = inst_14482__$1);

(statearr_14541[(9)] = inst_14479__$1);

(statearr_14541[(14)] = inst_14489);

(statearr_14541[(10)] = inst_14481__$1);

(statearr_14541[(12)] = inst_14480__$1);

return statearr_14541;
})();
var statearr_14542_14577 = state_14527__$1;
(statearr_14542_14577[(2)] = null);

(statearr_14542_14577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (22))){
var state_14527__$1 = state_14527;
var statearr_14543_14578 = state_14527__$1;
(statearr_14543_14578[(2)] = null);

(statearr_14543_14578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (6))){
var inst_14468 = (state_14527[(13)]);
var inst_14477 = f.call(null,inst_14468);
var inst_14478 = cljs.core.seq.call(null,inst_14477);
var inst_14479 = inst_14478;
var inst_14480 = null;
var inst_14481 = (0);
var inst_14482 = (0);
var state_14527__$1 = (function (){var statearr_14544 = state_14527;
(statearr_14544[(8)] = inst_14482);

(statearr_14544[(9)] = inst_14479);

(statearr_14544[(10)] = inst_14481);

(statearr_14544[(12)] = inst_14480);

return statearr_14544;
})();
var statearr_14545_14579 = state_14527__$1;
(statearr_14545_14579[(2)] = null);

(statearr_14545_14579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (17))){
var inst_14493 = (state_14527[(7)]);
var inst_14497 = cljs.core.chunk_first.call(null,inst_14493);
var inst_14498 = cljs.core.chunk_rest.call(null,inst_14493);
var inst_14499 = cljs.core.count.call(null,inst_14497);
var inst_14479 = inst_14498;
var inst_14480 = inst_14497;
var inst_14481 = inst_14499;
var inst_14482 = (0);
var state_14527__$1 = (function (){var statearr_14546 = state_14527;
(statearr_14546[(8)] = inst_14482);

(statearr_14546[(9)] = inst_14479);

(statearr_14546[(10)] = inst_14481);

(statearr_14546[(12)] = inst_14480);

return statearr_14546;
})();
var statearr_14547_14580 = state_14527__$1;
(statearr_14547_14580[(2)] = null);

(statearr_14547_14580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (3))){
var inst_14525 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14527__$1,inst_14525);
} else {
if((state_val_14528 === (12))){
var inst_14513 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
var statearr_14548_14581 = state_14527__$1;
(statearr_14548_14581[(2)] = inst_14513);

(statearr_14548_14581[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (2))){
var state_14527__$1 = state_14527;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14527__$1,(4),in$);
} else {
if((state_val_14528 === (23))){
var inst_14521 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
var statearr_14549_14582 = state_14527__$1;
(statearr_14549_14582[(2)] = inst_14521);

(statearr_14549_14582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (19))){
var inst_14508 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
var statearr_14550_14583 = state_14527__$1;
(statearr_14550_14583[(2)] = inst_14508);

(statearr_14550_14583[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (11))){
var inst_14479 = (state_14527[(9)]);
var inst_14493 = (state_14527[(7)]);
var inst_14493__$1 = cljs.core.seq.call(null,inst_14479);
var state_14527__$1 = (function (){var statearr_14551 = state_14527;
(statearr_14551[(7)] = inst_14493__$1);

return statearr_14551;
})();
if(inst_14493__$1){
var statearr_14552_14584 = state_14527__$1;
(statearr_14552_14584[(1)] = (14));

} else {
var statearr_14553_14585 = state_14527__$1;
(statearr_14553_14585[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (9))){
var inst_14515 = (state_14527[(2)]);
var inst_14516 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14527__$1 = (function (){var statearr_14554 = state_14527;
(statearr_14554[(15)] = inst_14515);

return statearr_14554;
})();
if(cljs.core.truth_(inst_14516)){
var statearr_14555_14586 = state_14527__$1;
(statearr_14555_14586[(1)] = (21));

} else {
var statearr_14556_14587 = state_14527__$1;
(statearr_14556_14587[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (5))){
var inst_14471 = cljs.core.async.close_BANG_.call(null,out);
var state_14527__$1 = state_14527;
var statearr_14557_14588 = state_14527__$1;
(statearr_14557_14588[(2)] = inst_14471);

(statearr_14557_14588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (14))){
var inst_14493 = (state_14527[(7)]);
var inst_14495 = cljs.core.chunked_seq_QMARK_.call(null,inst_14493);
var state_14527__$1 = state_14527;
if(inst_14495){
var statearr_14558_14589 = state_14527__$1;
(statearr_14558_14589[(1)] = (17));

} else {
var statearr_14559_14590 = state_14527__$1;
(statearr_14559_14590[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (16))){
var inst_14511 = (state_14527[(2)]);
var state_14527__$1 = state_14527;
var statearr_14560_14591 = state_14527__$1;
(statearr_14560_14591[(2)] = inst_14511);

(statearr_14560_14591[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14528 === (10))){
var inst_14482 = (state_14527[(8)]);
var inst_14480 = (state_14527[(12)]);
var inst_14487 = cljs.core._nth.call(null,inst_14480,inst_14482);
var state_14527__$1 = state_14527;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14527__$1,(13),out,inst_14487);
} else {
if((state_val_14528 === (18))){
var inst_14493 = (state_14527[(7)]);
var inst_14502 = cljs.core.first.call(null,inst_14493);
var state_14527__$1 = state_14527;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14527__$1,(20),out,inst_14502);
} else {
if((state_val_14528 === (8))){
var inst_14482 = (state_14527[(8)]);
var inst_14481 = (state_14527[(10)]);
var inst_14484 = (inst_14482 < inst_14481);
var inst_14485 = inst_14484;
var state_14527__$1 = state_14527;
if(cljs.core.truth_(inst_14485)){
var statearr_14561_14592 = state_14527__$1;
(statearr_14561_14592[(1)] = (10));

} else {
var statearr_14562_14593 = state_14527__$1;
(statearr_14562_14593[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_14566 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14566[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_14566[(1)] = (1));

return statearr_14566;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_14527){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14527);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14567){if((e14567 instanceof Object)){
var ex__7651__auto__ = e14567;
var statearr_14568_14594 = state_14527;
(statearr_14568_14594[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14527);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14567;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14595 = state_14527;
state_14527 = G__14595;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_14527){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_14527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_14569 = f__7710__auto__.call(null);
(statearr_14569[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_14569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__14597 = arguments.length;
switch (G__14597) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__14600 = arguments.length;
switch (G__14600) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__14603 = arguments.length;
switch (G__14603) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14653 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14653,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14653,out){
return (function (state_14627){
var state_val_14628 = (state_14627[(1)]);
if((state_val_14628 === (7))){
var inst_14622 = (state_14627[(2)]);
var state_14627__$1 = state_14627;
var statearr_14629_14654 = state_14627__$1;
(statearr_14629_14654[(2)] = inst_14622);

(statearr_14629_14654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (1))){
var inst_14604 = null;
var state_14627__$1 = (function (){var statearr_14630 = state_14627;
(statearr_14630[(7)] = inst_14604);

return statearr_14630;
})();
var statearr_14631_14655 = state_14627__$1;
(statearr_14631_14655[(2)] = null);

(statearr_14631_14655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (4))){
var inst_14607 = (state_14627[(8)]);
var inst_14607__$1 = (state_14627[(2)]);
var inst_14608 = (inst_14607__$1 == null);
var inst_14609 = cljs.core.not.call(null,inst_14608);
var state_14627__$1 = (function (){var statearr_14632 = state_14627;
(statearr_14632[(8)] = inst_14607__$1);

return statearr_14632;
})();
if(inst_14609){
var statearr_14633_14656 = state_14627__$1;
(statearr_14633_14656[(1)] = (5));

} else {
var statearr_14634_14657 = state_14627__$1;
(statearr_14634_14657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (6))){
var state_14627__$1 = state_14627;
var statearr_14635_14658 = state_14627__$1;
(statearr_14635_14658[(2)] = null);

(statearr_14635_14658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (3))){
var inst_14624 = (state_14627[(2)]);
var inst_14625 = cljs.core.async.close_BANG_.call(null,out);
var state_14627__$1 = (function (){var statearr_14636 = state_14627;
(statearr_14636[(9)] = inst_14624);

return statearr_14636;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14627__$1,inst_14625);
} else {
if((state_val_14628 === (2))){
var state_14627__$1 = state_14627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14627__$1,(4),ch);
} else {
if((state_val_14628 === (11))){
var inst_14607 = (state_14627[(8)]);
var inst_14616 = (state_14627[(2)]);
var inst_14604 = inst_14607;
var state_14627__$1 = (function (){var statearr_14637 = state_14627;
(statearr_14637[(7)] = inst_14604);

(statearr_14637[(10)] = inst_14616);

return statearr_14637;
})();
var statearr_14638_14659 = state_14627__$1;
(statearr_14638_14659[(2)] = null);

(statearr_14638_14659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (9))){
var inst_14607 = (state_14627[(8)]);
var state_14627__$1 = state_14627;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14627__$1,(11),out,inst_14607);
} else {
if((state_val_14628 === (5))){
var inst_14607 = (state_14627[(8)]);
var inst_14604 = (state_14627[(7)]);
var inst_14611 = cljs.core._EQ_.call(null,inst_14607,inst_14604);
var state_14627__$1 = state_14627;
if(inst_14611){
var statearr_14640_14660 = state_14627__$1;
(statearr_14640_14660[(1)] = (8));

} else {
var statearr_14641_14661 = state_14627__$1;
(statearr_14641_14661[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (10))){
var inst_14619 = (state_14627[(2)]);
var state_14627__$1 = state_14627;
var statearr_14642_14662 = state_14627__$1;
(statearr_14642_14662[(2)] = inst_14619);

(statearr_14642_14662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14628 === (8))){
var inst_14604 = (state_14627[(7)]);
var tmp14639 = inst_14604;
var inst_14604__$1 = tmp14639;
var state_14627__$1 = (function (){var statearr_14643 = state_14627;
(statearr_14643[(7)] = inst_14604__$1);

return statearr_14643;
})();
var statearr_14644_14663 = state_14627__$1;
(statearr_14644_14663[(2)] = null);

(statearr_14644_14663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14653,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14653,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14648 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14648[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14648[(1)] = (1));

return statearr_14648;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14627){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14649){if((e14649 instanceof Object)){
var ex__7651__auto__ = e14649;
var statearr_14650_14664 = state_14627;
(statearr_14650_14664[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14627);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14665 = state_14627;
state_14627 = G__14665;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14627){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14653,out))
})();
var state__7711__auto__ = (function (){var statearr_14651 = f__7710__auto__.call(null);
(statearr_14651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14653);

return statearr_14651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14653,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__14667 = arguments.length;
switch (G__14667) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14736 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14736,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14736,out){
return (function (state_14705){
var state_val_14706 = (state_14705[(1)]);
if((state_val_14706 === (7))){
var inst_14701 = (state_14705[(2)]);
var state_14705__$1 = state_14705;
var statearr_14707_14737 = state_14705__$1;
(statearr_14707_14737[(2)] = inst_14701);

(statearr_14707_14737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (1))){
var inst_14668 = (new Array(n));
var inst_14669 = inst_14668;
var inst_14670 = (0);
var state_14705__$1 = (function (){var statearr_14708 = state_14705;
(statearr_14708[(7)] = inst_14669);

(statearr_14708[(8)] = inst_14670);

return statearr_14708;
})();
var statearr_14709_14738 = state_14705__$1;
(statearr_14709_14738[(2)] = null);

(statearr_14709_14738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (4))){
var inst_14673 = (state_14705[(9)]);
var inst_14673__$1 = (state_14705[(2)]);
var inst_14674 = (inst_14673__$1 == null);
var inst_14675 = cljs.core.not.call(null,inst_14674);
var state_14705__$1 = (function (){var statearr_14710 = state_14705;
(statearr_14710[(9)] = inst_14673__$1);

return statearr_14710;
})();
if(inst_14675){
var statearr_14711_14739 = state_14705__$1;
(statearr_14711_14739[(1)] = (5));

} else {
var statearr_14712_14740 = state_14705__$1;
(statearr_14712_14740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (15))){
var inst_14695 = (state_14705[(2)]);
var state_14705__$1 = state_14705;
var statearr_14713_14741 = state_14705__$1;
(statearr_14713_14741[(2)] = inst_14695);

(statearr_14713_14741[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (13))){
var state_14705__$1 = state_14705;
var statearr_14714_14742 = state_14705__$1;
(statearr_14714_14742[(2)] = null);

(statearr_14714_14742[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (6))){
var inst_14670 = (state_14705[(8)]);
var inst_14691 = (inst_14670 > (0));
var state_14705__$1 = state_14705;
if(cljs.core.truth_(inst_14691)){
var statearr_14715_14743 = state_14705__$1;
(statearr_14715_14743[(1)] = (12));

} else {
var statearr_14716_14744 = state_14705__$1;
(statearr_14716_14744[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (3))){
var inst_14703 = (state_14705[(2)]);
var state_14705__$1 = state_14705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14705__$1,inst_14703);
} else {
if((state_val_14706 === (12))){
var inst_14669 = (state_14705[(7)]);
var inst_14693 = cljs.core.vec.call(null,inst_14669);
var state_14705__$1 = state_14705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14705__$1,(15),out,inst_14693);
} else {
if((state_val_14706 === (2))){
var state_14705__$1 = state_14705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14705__$1,(4),ch);
} else {
if((state_val_14706 === (11))){
var inst_14685 = (state_14705[(2)]);
var inst_14686 = (new Array(n));
var inst_14669 = inst_14686;
var inst_14670 = (0);
var state_14705__$1 = (function (){var statearr_14717 = state_14705;
(statearr_14717[(7)] = inst_14669);

(statearr_14717[(8)] = inst_14670);

(statearr_14717[(10)] = inst_14685);

return statearr_14717;
})();
var statearr_14718_14745 = state_14705__$1;
(statearr_14718_14745[(2)] = null);

(statearr_14718_14745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (9))){
var inst_14669 = (state_14705[(7)]);
var inst_14683 = cljs.core.vec.call(null,inst_14669);
var state_14705__$1 = state_14705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14705__$1,(11),out,inst_14683);
} else {
if((state_val_14706 === (5))){
var inst_14669 = (state_14705[(7)]);
var inst_14670 = (state_14705[(8)]);
var inst_14678 = (state_14705[(11)]);
var inst_14673 = (state_14705[(9)]);
var inst_14677 = (inst_14669[inst_14670] = inst_14673);
var inst_14678__$1 = (inst_14670 + (1));
var inst_14679 = (inst_14678__$1 < n);
var state_14705__$1 = (function (){var statearr_14719 = state_14705;
(statearr_14719[(12)] = inst_14677);

(statearr_14719[(11)] = inst_14678__$1);

return statearr_14719;
})();
if(cljs.core.truth_(inst_14679)){
var statearr_14720_14746 = state_14705__$1;
(statearr_14720_14746[(1)] = (8));

} else {
var statearr_14721_14747 = state_14705__$1;
(statearr_14721_14747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (14))){
var inst_14698 = (state_14705[(2)]);
var inst_14699 = cljs.core.async.close_BANG_.call(null,out);
var state_14705__$1 = (function (){var statearr_14723 = state_14705;
(statearr_14723[(13)] = inst_14698);

return statearr_14723;
})();
var statearr_14724_14748 = state_14705__$1;
(statearr_14724_14748[(2)] = inst_14699);

(statearr_14724_14748[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (10))){
var inst_14689 = (state_14705[(2)]);
var state_14705__$1 = state_14705;
var statearr_14725_14749 = state_14705__$1;
(statearr_14725_14749[(2)] = inst_14689);

(statearr_14725_14749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14706 === (8))){
var inst_14669 = (state_14705[(7)]);
var inst_14678 = (state_14705[(11)]);
var tmp14722 = inst_14669;
var inst_14669__$1 = tmp14722;
var inst_14670 = inst_14678;
var state_14705__$1 = (function (){var statearr_14726 = state_14705;
(statearr_14726[(7)] = inst_14669__$1);

(statearr_14726[(8)] = inst_14670);

return statearr_14726;
})();
var statearr_14727_14750 = state_14705__$1;
(statearr_14727_14750[(2)] = null);

(statearr_14727_14750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14736,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14736,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14731 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14731[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14731[(1)] = (1));

return statearr_14731;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14705){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14732){if((e14732 instanceof Object)){
var ex__7651__auto__ = e14732;
var statearr_14733_14751 = state_14705;
(statearr_14733_14751[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14732;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14752 = state_14705;
state_14705 = G__14752;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14705){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14736,out))
})();
var state__7711__auto__ = (function (){var statearr_14734 = f__7710__auto__.call(null);
(statearr_14734[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14736);

return statearr_14734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14736,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__14754 = arguments.length;
switch (G__14754) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14827,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14827,out){
return (function (state_14796){
var state_val_14797 = (state_14796[(1)]);
if((state_val_14797 === (7))){
var inst_14792 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14798_14828 = state_14796__$1;
(statearr_14798_14828[(2)] = inst_14792);

(statearr_14798_14828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (1))){
var inst_14755 = [];
var inst_14756 = inst_14755;
var inst_14757 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14796__$1 = (function (){var statearr_14799 = state_14796;
(statearr_14799[(7)] = inst_14756);

(statearr_14799[(8)] = inst_14757);

return statearr_14799;
})();
var statearr_14800_14829 = state_14796__$1;
(statearr_14800_14829[(2)] = null);

(statearr_14800_14829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (4))){
var inst_14760 = (state_14796[(9)]);
var inst_14760__$1 = (state_14796[(2)]);
var inst_14761 = (inst_14760__$1 == null);
var inst_14762 = cljs.core.not.call(null,inst_14761);
var state_14796__$1 = (function (){var statearr_14801 = state_14796;
(statearr_14801[(9)] = inst_14760__$1);

return statearr_14801;
})();
if(inst_14762){
var statearr_14802_14830 = state_14796__$1;
(statearr_14802_14830[(1)] = (5));

} else {
var statearr_14803_14831 = state_14796__$1;
(statearr_14803_14831[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (15))){
var inst_14786 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14804_14832 = state_14796__$1;
(statearr_14804_14832[(2)] = inst_14786);

(statearr_14804_14832[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (13))){
var state_14796__$1 = state_14796;
var statearr_14805_14833 = state_14796__$1;
(statearr_14805_14833[(2)] = null);

(statearr_14805_14833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (6))){
var inst_14756 = (state_14796[(7)]);
var inst_14781 = inst_14756.length;
var inst_14782 = (inst_14781 > (0));
var state_14796__$1 = state_14796;
if(cljs.core.truth_(inst_14782)){
var statearr_14806_14834 = state_14796__$1;
(statearr_14806_14834[(1)] = (12));

} else {
var statearr_14807_14835 = state_14796__$1;
(statearr_14807_14835[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (3))){
var inst_14794 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14796__$1,inst_14794);
} else {
if((state_val_14797 === (12))){
var inst_14756 = (state_14796[(7)]);
var inst_14784 = cljs.core.vec.call(null,inst_14756);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14796__$1,(15),out,inst_14784);
} else {
if((state_val_14797 === (2))){
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14796__$1,(4),ch);
} else {
if((state_val_14797 === (11))){
var inst_14760 = (state_14796[(9)]);
var inst_14764 = (state_14796[(10)]);
var inst_14774 = (state_14796[(2)]);
var inst_14775 = [];
var inst_14776 = inst_14775.push(inst_14760);
var inst_14756 = inst_14775;
var inst_14757 = inst_14764;
var state_14796__$1 = (function (){var statearr_14808 = state_14796;
(statearr_14808[(11)] = inst_14774);

(statearr_14808[(12)] = inst_14776);

(statearr_14808[(7)] = inst_14756);

(statearr_14808[(8)] = inst_14757);

return statearr_14808;
})();
var statearr_14809_14836 = state_14796__$1;
(statearr_14809_14836[(2)] = null);

(statearr_14809_14836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (9))){
var inst_14756 = (state_14796[(7)]);
var inst_14772 = cljs.core.vec.call(null,inst_14756);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14796__$1,(11),out,inst_14772);
} else {
if((state_val_14797 === (5))){
var inst_14760 = (state_14796[(9)]);
var inst_14764 = (state_14796[(10)]);
var inst_14757 = (state_14796[(8)]);
var inst_14764__$1 = f.call(null,inst_14760);
var inst_14765 = cljs.core._EQ_.call(null,inst_14764__$1,inst_14757);
var inst_14766 = cljs.core.keyword_identical_QMARK_.call(null,inst_14757,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14767 = (inst_14765) || (inst_14766);
var state_14796__$1 = (function (){var statearr_14810 = state_14796;
(statearr_14810[(10)] = inst_14764__$1);

return statearr_14810;
})();
if(cljs.core.truth_(inst_14767)){
var statearr_14811_14837 = state_14796__$1;
(statearr_14811_14837[(1)] = (8));

} else {
var statearr_14812_14838 = state_14796__$1;
(statearr_14812_14838[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (14))){
var inst_14789 = (state_14796[(2)]);
var inst_14790 = cljs.core.async.close_BANG_.call(null,out);
var state_14796__$1 = (function (){var statearr_14814 = state_14796;
(statearr_14814[(13)] = inst_14789);

return statearr_14814;
})();
var statearr_14815_14839 = state_14796__$1;
(statearr_14815_14839[(2)] = inst_14790);

(statearr_14815_14839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (10))){
var inst_14779 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14816_14840 = state_14796__$1;
(statearr_14816_14840[(2)] = inst_14779);

(statearr_14816_14840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (8))){
var inst_14760 = (state_14796[(9)]);
var inst_14756 = (state_14796[(7)]);
var inst_14764 = (state_14796[(10)]);
var inst_14769 = inst_14756.push(inst_14760);
var tmp14813 = inst_14756;
var inst_14756__$1 = tmp14813;
var inst_14757 = inst_14764;
var state_14796__$1 = (function (){var statearr_14817 = state_14796;
(statearr_14817[(14)] = inst_14769);

(statearr_14817[(7)] = inst_14756__$1);

(statearr_14817[(8)] = inst_14757);

return statearr_14817;
})();
var statearr_14818_14841 = state_14796__$1;
(statearr_14818_14841[(2)] = null);

(statearr_14818_14841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14827,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14827,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14822[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14822[(1)] = (1));

return statearr_14822;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14796){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14823){if((e14823 instanceof Object)){
var ex__7651__auto__ = e14823;
var statearr_14824_14842 = state_14796;
(statearr_14824_14842[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14823;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14843 = state_14796;
state_14796 = G__14843;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14796){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14827,out))
})();
var state__7711__auto__ = (function (){var statearr_14825 = f__7710__auto__.call(null);
(statearr_14825[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14827);

return statearr_14825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14827,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
