// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(account){
var url = (function (){var G__42437 = [cljs.core.str("forms?owner="),cljs.core.str(cljs.core.constant$keyword$username.cljs$core$IFn$_invoke$arity$1(account))].join('');
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42437) : milia.api.io.make_url.call(null,G__42437));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(account,username){
var url = (function (){var G__42440 = "forms";
var G__42441 = username;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42440,G__42441) : milia.api.io.make_url.call(null,G__42440,G__42441));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(account,dataset_id,username){
var url = (function (){var G__42445 = "forms";
var G__42446 = dataset_id;
var G__42447 = "clone";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42445,G__42446,G__42447) : milia.api.io.make_url.call(null,G__42445,G__42446,G__42447));
})();
var params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$username,username], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(account,dataset_id,params){
if(cljs.core.truth_(milia.utils.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null))], 0)))].join('')));
}

var url = (function (){var G__42450 = "forms";
var G__42451 = dataset_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42450,G__42451) : milia.api.io.make_url.call(null,G__42450,G__42451));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(account,dataset_id,params){
var url = (function (){var G__42454 = "forms";
var G__42455 = dataset_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42454,G__42455) : milia.api.io.make_url.call(null,G__42454,G__42455));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (account,dataset_id,p__42459){
var map__42460 = p__42459;
var map__42460__$1 = ((cljs.core.seq_QMARK_(map__42460))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42460):map__42460);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42460__$1,cljs.core.constant$keyword$raw_QMARK_);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__42460__$1,cljs.core.constant$keyword$format,"json");
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = (function (){var G__42461 = "data";
var G__42462 = dataset_suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42461,G__42462) : milia.api.io.make_url.call(null,G__42461,G__42462));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$raw_DASH_response_QMARK_,raw_QMARK_], null));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (2);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq42456){
var G__42457 = cljs.core.first(seq42456);
var seq42456__$1 = cljs.core.next(seq42456);
var G__42458 = cljs.core.first(seq42456__$1);
var seq42456__$2 = cljs.core.next(seq42456__$1);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__42457,G__42458,seq42456__$2);
});
/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(account,dataset_id,record_id){
var url = (function (){var G__42466 = "data";
var G__42467 = dataset_id;
var G__42468 = record_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42466,G__42467,G__42468) : milia.api.io.make_url.call(null,G__42466,G__42467,G__42468));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(account,dataset_id){
var url = (function (){var G__42472 = "forms";
var G__42473 = dataset_id;
var G__42474 = "labels";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42472,G__42473,G__42474) : milia.api.io.make_url.call(null,G__42472,G__42473,G__42474));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(account,dataset_id,tags){
var url = (function (){var G__42478 = "forms";
var G__42479 = dataset_id;
var G__42480 = "labels";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42478,G__42479,G__42480) : milia.api.io.make_url.call(null,G__42478,G__42479,G__42480));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,tags], null));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(){
var G__42482 = arguments.length;
switch (G__42482) {
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (account,dataset_id){
var url = (function (){var G__42483 = "forms";
var G__42484 = dataset_id;
var G__42485 = "form.json";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42483,G__42484,G__42485) : milia.api.io.make_url.call(null,G__42483,G__42484,G__42485));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3 = (function (account,dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = (function (){var G__42486 = "forms";
var G__42487 = dataset_id;
var G__42488 = suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42486,G__42487,G__42488) : milia.api.io.make_url.call(null,G__42486,G__42487,G__42488));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,options,[cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join(''));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 3;
/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(account,dataset_id){
var url = (function (){var G__42492 = "forms";
var G__42493 = [cljs.core.str(dataset_id),cljs.core.str(".json")].join('');
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42492,G__42493) : milia.api.io.make_url.call(null,G__42492,G__42493));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(account,dataset_id,instance_id){
var return_url = milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["/submission-editing-complete"], 0));
var url = (function (){var G__42498 = "data";
var G__42499 = dataset_id;
var G__42500 = instance_id;
var G__42501 = [cljs.core.str("enketo?return_url="),cljs.core.str(return_url)].join('');
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$4 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$4(G__42498,G__42499,G__42500,G__42501) : milia.api.io.make_url.call(null,G__42498,G__42499,G__42500,G__42501));
})();
return cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(account,dataset_id){
var url = (function (){var G__42505 = "forms";
var G__42506 = dataset_id;
var G__42507 = "delete_async";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42505,G__42506,G__42507) : milia.api.io.make_url.call(null,G__42505,G__42506,G__42507));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$delete,url,account);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(account,dataset_id,project_id){
var url = (function (){var G__42511 = "projects";
var G__42512 = project_id;
var G__42513 = "forms";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42511,G__42512,G__42513) : milia.api.io.make_url.call(null,G__42511,G__42512,G__42513));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$formid,dataset_id], null)], null));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(account,dataset_id,username,role){
var url = (function (){var G__42517 = "forms";
var G__42518 = dataset_id;
var G__42519 = "share";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42517,G__42518,G__42519) : milia.api.io.make_url.call(null,G__42517,G__42518,G__42519));
})();
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(account,dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = (function (){var G__42521 = "metadata";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42521) : milia.api.io.make_url.call(null,G__42521));
})();
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$xform,dataset_id,cljs.core.constant$keyword$data_type,"external_export",cljs.core.constant$keyword$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(){
var G__42523 = arguments.length;
switch (G__42523) {
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (account,dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5(account,dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5 = (function (account,dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = (function (){var G__42524 = "forms";
var G__42525 = suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42524,G__42525) : milia.api.io.make_url.call(null,G__42524,G__42525));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], null),filename);
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 5;
