// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('milia.api.io');
/**
 * Send and parse an HTTP response as JSON.
 * Options object has special keys that modify beavior of parse-http:
 * In clj: `suppress-40x-exceptions?`, `as-map?`,`raw-response?`.
 * In cljs: `raw-response?`, `no-cache?`.
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var G__42429 = arguments.length;
switch (G__42429) {
case 3:
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3 = (function (method,url,account){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(method,url,account,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4 = (function (method,url,account,options){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(method,url,account,options,null);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5 = (function (method,url,account,options,filename){
var map__42430 = options;
var map__42430__$1 = ((cljs.core.seq_QMARK_(map__42430))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42430):map__42430);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42430__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42430__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42430__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var suppress_40x_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42430__$1,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_);
var auth_token = account;
var http_request = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$put,null], null), null),method))?null:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(options,cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$form_DASH_params.cljs$core$IFn$_invoke$arity$1(options)));
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(auth_token,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__42431 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__42431) : cljs_hash.md5.md5.call(null,G__42431));
})()], null):null);
var all_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([options__$1,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$xhr,true,cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0));
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via js"));
} else {
}

var G__42432 = all_params;
return (http_request.cljs$core$IFn$_invoke$arity$1 ? http_request.cljs$core$IFn$_invoke$arity$1(G__42432) : http_request.call(null,G__42432));
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = 5;
