(ns milia.api.http
                                                                   
                                                                 
                                             
                                                
                                                             
         (:require [milia.api.io :refer [token->headers raw-request]]
                   [cljs-hash.md5  :refer [md5]]
                   [cljs-http.client :as http]))

;;; PARSE HTTP ;;;;;

(defn parse-http
  "Send and parse an HTTP response as JSON.
   Options object has special keys that modify beavior of parse-http:
   In clj: `suppress-40x-exceptions?`, `as-map?`,`raw-response?`.
   In cljs: `raw-response?`, `no-cache?`."
  ([method url account]
   (parse-http method url account {}))
  ([method url account options]
   (parse-http method url account options nil))
  ([method url account options filename]
   (let [{:keys [suppress-40x-exceptions? raw-response? as-map?
                 no-cache?]} options]
     ;; CLJ: synchronous implementation, checks status before returning.
     ;; no-cache? has no meaning in clj a.t.m.
          
                                                                
                               
                                                                    
                                               
                                                 
                                                   
                                                          
                              
                                                          
                                                                            
                                                                                     
                  
                                               
                          
     ;; CLJS: asynchronous implementation, returns a channel.
     ;; suppress-40x-exceptions?, as-map? have no meaning in cljs a.t.m.
           
     (let [auth-token account ; in cljs, we just get the auth-token, not full account
           http-request (if raw-response? raw-request http/request) ;; v0
           ;; For :put / :patch, we need :form-params, for the rest :query-params
           options (when-not (contains? #{:put :patch} method)
                     (assoc options :query-params (:form-params options)))
           headers (token->headers auth-token (= method :delete))
           time-params (when no-cache?
                         {:t (md5 (.toString (.now js/Date)))})
           all-params (merge options
                             {:xhr true
                              :headers headers
                              :method method
                              :url url})]
       (when filename
         (throw (js/Error. "File downloads auth not supported via js")))
       (http-request all-params)))))

;;;;;;;;;;;; This file autogenerated from src/cljx/milia/api/http.cljx
